/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.tools;

import com.stimulsoft.base.enums.StiArabicDigitsType;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.utils.StiBidirectionalConvert;
import com.stimulsoft.lib.base64.StiBase64DecoderUtil;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.options.ExportOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Stack;
import java.util.zip.InflaterInputStream;

public final class StiBidirectionalConvert2 {
    private static final int MAX_DEPTH = 125;
    private static final int MAX_NESTED_BRACKET_PAIRS = 63;
    private static final String LeftBracketsList = "([{\u0f3a\u0f3c\u169b\u2045\u207d\u208d\u2308\u230a\u2329\u2768\u276a\u276c\u276e\u2770\u2772\u2774\u27c5\u27e6\u27e8\u27ea\u27ec\u27ee\u2983\u2985\u2987\u2989\u298b\u298d\u298f\u2991\u2993\u2995\u2997\u29d8\u29da\u29fc\u2e22\u2e24\u2e26\u2e28\u3008\u300a\u300c\u300e\u3010\u3014\u3016\u3018\u301a\ufe59\ufe5b\ufe5d\uff08\uff3b\uff5b\uff5f\uff62";
    private static final String RightBracketsList = ")]}\u0f3b\u0f3d\u169c\u2046\u207e\u208e\u2309\u230b\u232a\u2769\u276b\u276d\u276f\u2771\u2773\u2775\u27c6\u27e7\u27e9\u27eb\u27ed\u27ef\u2984\u2986\u2988\u298a\u298c\u298e\u2990\u2992\u2994\u2996\u2998\u29d9\u29db\u29fd\u2e23\u2e25\u2e27\u2e29\u3009\u300b\u300d\u300f\u3011\u3015\u3017\u3019\u301b\ufe5a\ufe5c\ufe5e\uff09\uff3d\uff5d\uff60\uff63";

    public static StringBuilder convertStringBuilder(StringBuilder input, boolean rightToLeft, boolean modePdf) {
        return StiBidirectionalConvert2.convertStringBuilder(input, rightToLeft, modePdf, false);
    }

    public static StringBuilder convertStringBuilder(StringBuilder input, boolean rightToLeft) {
        return StiBidirectionalConvert2.convertStringBuilder(input, rightToLeft, true, false);
    }

    public static StringBuilder convertStringBuilder(StringBuilder input, boolean rightToLeft, boolean modePdf, boolean paddingWithSpaces) {
        return new StringBuilder(StiBidirectionalConvert2.convertString(input.toString(), rightToLeft, modePdf, paddingWithSpaces));
    }

    public static String convertString(String input, boolean rightToLeft, boolean modePdf) {
        return StiBidirectionalConvert2.convertString(input, rightToLeft, modePdf, false);
    }

    public static String convertString(String input, boolean rightToLeft) {
        return StiBidirectionalConvert2.convertString(input, rightToLeft, true, false);
    }

    public static String convertString(String input, boolean rightToLeft, boolean modePdf, boolean paddingWithSpaces) {
        if (input == null) {
            return "";
        }
        if (input == null || StiValidationUtil.isBlank((String)input)) {
            return input;
        }
        boolean alignWidth = false;
        if (input.charAt(input.length() - 1) == '\u0007') {
            alignWidth = true;
            input = input.substring(0, input.length() - 1);
        }
        int len = input.length();
        input = StiBidirectionalConvert2.convertArabicHebrew(input).toString();
        String output = StiBidirectionalConvert2.logicalToVisual(input, rightToLeft);
        if (modePdf && ExportOptions.Pdf.getConvertDigitsToArabic() && rightToLeft) {
            output = StiBidirectionalConvert.convertDigitsToArabic((String)output, (StiArabicDigitsType)ExportOptions.Pdf.getArabicDigitsType());
        }
        if (paddingWithSpaces && output.length() < len) {
            output = output + StiStringUtil.createCopies((char)'\u200b', (int)(len - output.length()));
        }
        if (alignWidth) {
            return output + '\u0007';
        }
        return output;
    }

    public static ArrayList<String> convertToRunes(String input, boolean rightToLeft) {
        if (input == null || StiValidationUtil.isBlank((String)input)) {
            return null;
        }
        ArrayList<String> runes = new ArrayList<String>();
        String output = StiBidirectionalConvert2.logicalToVisual(input, rightToLeft, null, runes);
        if (runes.size() > 1) {
            return runes;
        }
        return null;
    }

    private static String logicalToVisual(String input, boolean rightToLeft, int[] lineBreaks) {
        return StiBidirectionalConvert2.logicalToVisual(input, rightToLeft, lineBreaks, null);
    }

    private static String logicalToVisual(String input, boolean rightToLeft) {
        return StiBidirectionalConvert2.logicalToVisual(input, rightToLeft, null, null);
    }

    private static String logicalToVisual(String input, boolean rightToLeft, int[] lineBreaks, ArrayList<String> runes) {
        int[] lines;
        int[] nArray;
        boolean found = rightToLeft;
        if (!found) {
            for (int i = 0; i < input.length(); ++i) {
                char ch = input.charAt(i);
                BidiClass ct = BidiClass.forValue(Bidi_Types.bidiCharTypes[ch]);
                if (ct != BidiClass.R && ct != BidiClass.AL && ct != BidiClass.AN) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            return input;
        }
        int inputLength = input.length();
        int[] typesList = new int[input.length()];
        int[] levelsList = new int[input.length()];
        StiRefObject tempRefTypesList = new StiRefObject((Object)typesList);
        StiBidirectionalConvert2.classifyCharacters(input, (StiRefObject<int[]>)tempRefTypesList);
        typesList = (int[])tempRefTypesList.argvalue;
        StiRefObject tempOutMatchingPDI = new StiRefObject((Object)new int[0]);
        StiRefObject tempOutMatchingIsolateInitiator = new StiRefObject((Object)new int[0]);
        StiBidirectionalConvert2.getMatchingPDI(typesList, (StiRefObject<int[]>)tempOutMatchingPDI, (StiRefObject<int[]>)tempOutMatchingIsolateInitiator);
        int[] matchingIsolateInitiator = (int[])tempOutMatchingIsolateInitiator.argvalue;
        int[] matchingPDI = (int[])tempOutMatchingPDI.argvalue;
        int baseLevel = StiBidirectionalConvert2.getParagraphEmbeddingLevel(typesList, matchingPDI);
        baseLevel = rightToLeft ? 1 : 0;
        StiRefObject tempRefLevelsList = new StiRefObject((Object)levelsList);
        StiBidirectionalConvert2.setLevels((StiRefObject<int[]>)tempRefLevelsList, baseLevel);
        levelsList = (int[])tempRefLevelsList.argvalue;
        StiRefObject tempRefLevelsList2 = new StiRefObject((Object)levelsList);
        StiBidirectionalConvert2.getExplicitEmbeddingLevels(baseLevel, typesList, (StiRefObject<int[]>)tempRefLevelsList2, matchingPDI);
        levelsList = (int[])tempRefLevelsList2.argvalue;
        StiRefObject tempRefTypesList2 = new StiRefObject((Object)typesList);
        StiBidirectionalConvert2.removeX9Characters((StiRefObject<int[]>)tempRefTypesList2);
        typesList = (int[])tempRefTypesList2.argvalue;
        ArrayList<ArrayList<Integer>> levelRuns = StiBidirectionalConvert2.getLevelRuns(levelsList);
        int[] runCharsArray = StiBidirectionalConvert2.getRunForCharacter(levelRuns, inputLength);
        ArrayList<IsolatingRunSequence> sequences = StiBidirectionalConvert2.getIsolatingRunSequences(baseLevel, typesList, levelsList, levelRuns, matchingIsolateInitiator, matchingPDI, runCharsArray);
        for (IsolatingRunSequence sequence : sequences) {
            StiBidirectionalConvert2.resolveWeaks(sequence);
            StiBidirectionalConvert2.resolveNeutrals(sequence, input);
            StiBidirectionalConvert2.resolveImplicit(sequence);
            StiRefObject tempRefTypesList3 = new StiRefObject((Object)typesList);
            StiRefObject tempRefLevelsList3 = new StiRefObject((Object)levelsList);
            StiBidirectionalConvert2.applyTypesAndLevels(sequence, (StiRefObject<int[]>)tempRefTypesList3, (StiRefObject<int[]>)tempRefLevelsList3);
            levelsList = (int[])tempRefLevelsList3.argvalue;
            typesList = (int[])tempRefTypesList3.argvalue;
        }
        if (lineBreaks == null) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = typesList.length;
        } else {
            nArray = lines = lineBreaks;
        }
        if (runes != null) {
            int[] levels2 = StiBidirectionalConvert2.getTextLevels(baseLevel, typesList, levelsList, lines);
            int len = levels2.length;
            int first = 0;
            while (first < len) {
                int index;
                int val = levels2[first];
                for (index = first + 1; index < len && levels2[index] == val; ++index) {
                }
                runes.add(input.substring(first, index));
                first = index;
            }
            return null;
        }
        StiRefObject tempOutLevels = new StiRefObject((Object)new int[0]);
        int[] newIndexes = StiBidirectionalConvert2.getReorderedIndexes(baseLevel, typesList, levelsList, lines, (StiRefObject<int[]>)tempOutLevels);
        int[] levels = (int[])tempOutLevels.argvalue;
        String finalStr = StiBidirectionalConvert2.getOrderedString(input, newIndexes, levels);
        return finalStr;
    }

    public static StringBuilder convertArabicHebrew(StringBuilder inputSB) {
        return StiBidirectionalConvert2.convertArabicHebrew(inputSB.toString());
    }

    public static StringBuilder convertArabicHebrew(String inputSB) {
        return StiBidirectionalConvert2.convertArabicHebrew(inputSB, false);
    }

    public static StringBuilder convertArabicHebrew(String inputSB, boolean keepSize) {
        StringBuilder tempSB = new StringBuilder();
        if (inputSB == null) {
            return tempSB;
        }
        boolean hasArabic = false;
        boolean hasLigatures = false;
        for (int i = 0; i < inputSB.length(); ++i) {
            char ch = inputSB.charAt(i);
            int bb = ch >> 8 & 0xFF;
            if (bb == 5 || bb == 6 || bb == 251) {
                hasArabic = true;
            }
            if (bb != 5 && bb != 251 && bb != 254) continue;
            hasLigatures = true;
        }
        if (hasArabic) {
            hasLigatures = true;
        }
        if (hasArabic) {
            block5: for (int index = 0; index < inputSB.length(); ++index) {
                int tempInt = Bidi_Types.getArabicTableValue(inputSB.charAt(index), 0);
                switch (tempInt) {
                    case 3: {
                        StringBuilder sb = new StringBuilder();
                        sb.append(inputSB.charAt(index));
                        while (index + 1 < inputSB.length() && Bidi_Types.getArabicTableValue(inputSB.charAt(index + 1), 0) == 3) {
                            sb.append(inputSB.charAt(++index));
                        }
                        if (index + 1 < inputSB.length() && Bidi_Types.getArabicTableValue(inputSB.charAt(index + 1), 0) == 2) {
                            sb.append(inputSB.charAt(++index));
                        }
                        if (sb.length() == 1) {
                            tempSB.append((char)Bidi_Types.getArabicTableValue(sb.charAt(0), 1));
                            continue block5;
                        }
                        tempSB.append((char)Bidi_Types.getArabicTableValue(sb.charAt(0), 3));
                        if (sb.length() > 2) {
                            for (int tempIndex = 1; tempIndex < sb.length() - 1; ++tempIndex) {
                                tempSB.append((char)Bidi_Types.getArabicTableValue(sb.charAt(tempIndex), 4));
                            }
                        }
                        tempSB.append((char)Bidi_Types.getArabicTableValue(sb.charAt(sb.length() - 1), 2));
                        continue block5;
                    }
                    case 1: 
                    case 2: {
                        tempSB.append((char)Bidi_Types.getArabicTableValue(inputSB.charAt(index), 1));
                        continue block5;
                    }
                    default: {
                        tempSB.append(inputSB.charAt(index));
                    }
                }
            }
        } else {
            tempSB.append(inputSB);
        }
        if (hasLigatures) {
            for (int index3 = 0; index3 < Bidi_Types.ligaturesTable.length; ++index3) {
                tempSB = keepSize ? new StringBuilder(tempSB.toString().replaceAll(Bidi_Types.ligaturesTable[index3][0], Bidi_Types.ligaturesTable[index3][1] + '\u200b')) : new StringBuilder(tempSB.toString().replaceAll(Bidi_Types.ligaturesTable[index3][0], Bidi_Types.ligaturesTable[index3][1]));
            }
        }
        return tempSB;
    }

    private static void classifyCharacters(String text, StiRefObject<int[]> typesList) {
        typesList.argvalue = new int[text.length()];
        for (int i = 0; i < text.length(); ++i) {
            char chIndex = text.charAt(i);
            ((int[])typesList.argvalue)[i] = Bidi_Types.bidiCharTypes[chIndex];
        }
    }

    private static int getParagraphEmbeddingLevel(int[] types, int[] matchingPDI, int si) {
        return StiBidirectionalConvert2.getParagraphEmbeddingLevel(types, matchingPDI, si, -1);
    }

    private static int getParagraphEmbeddingLevel(int[] types, int[] matchingPDI) {
        return StiBidirectionalConvert2.getParagraphEmbeddingLevel(types, matchingPDI, -1, -1);
    }

    private static int getParagraphEmbeddingLevel(int[] types, int[] matchingPDI, int si, int ei) {
        int start = si != -1 ? si : 0;
        int end = ei != -1 ? ei : types.length;
        for (int i = start; i < end; ++i) {
            BidiClass cct = BidiClass.forValue(types[i]);
            if (cct == BidiClass.L || cct == BidiClass.AL || cct == BidiClass.R) {
                if (cct == BidiClass.L) {
                    return 0;
                }
                return 1;
            }
            if (cct != BidiClass.LRI && cct != BidiClass.RLI && cct != BidiClass.FSI) continue;
            i = matchingPDI[i];
        }
        return 0;
    }

    private static void getExplicitEmbeddingLevels(int level, int[] types, StiRefObject<int[]> levels, int[] matchingPDI) {
        Stack<DirectionalStatus> dirStatusStack = new Stack<DirectionalStatus>();
        DirectionalStatus dirEntry = new DirectionalStatus();
        dirEntry.paragraphEmbeddingLevel = level;
        dirEntry.directionalOverrideStatus = BidiClass.ON.getValue();
        dirEntry.directionalIsolateStatus = false;
        dirStatusStack.push(dirEntry.clone());
        int overflowIsolateCount = 0;
        int overflowEmbeddingCount = 0;
        int validIsolateCount = 0;
        block6: for (int i = 0; i < types.length; ++i) {
            BidiClass cct = BidiClass.forValue(types[i]);
            switch (cct) {
                case RLE: 
                case RLO: 
                case LRE: 
                case LRO: 
                case LRI: 
                case RLI: 
                case FSI: {
                    int newLevel;
                    boolean isIsolate;
                    boolean bl = isIsolate = cct == BidiClass.RLI || cct == BidiClass.LRI;
                    if (isIsolate) {
                        ((int[])levels.argvalue)[i] = ((DirectionalStatus)dirStatusStack.peek()).paragraphEmbeddingLevel;
                    }
                    if (cct == BidiClass.FSI) {
                        int el = StiBidirectionalConvert2.getParagraphEmbeddingLevel(types, matchingPDI, i + 1, matchingPDI[i]);
                        cct = el == 1 ? BidiClass.RLI : BidiClass.LRI;
                    }
                    if ((newLevel = cct == BidiClass.RLE || cct == BidiClass.RLO || cct == BidiClass.RLI ? StiBidirectionalConvert2.leastGreaterOdd(((DirectionalStatus)dirStatusStack.peek()).paragraphEmbeddingLevel) : StiBidirectionalConvert2.leastGreaterEven(((DirectionalStatus)dirStatusStack.peek()).paragraphEmbeddingLevel)) <= 125 && overflowIsolateCount == 0 && overflowEmbeddingCount == 0) {
                        if (isIsolate) {
                            ++validIsolateCount;
                        }
                        int dos = cct == BidiClass.RLO ? BidiClass.R.getValue() : (cct == BidiClass.LRO ? BidiClass.L.getValue() : BidiClass.ON.getValue());
                        DirectionalStatus tempVar = new DirectionalStatus();
                        tempVar.paragraphEmbeddingLevel = newLevel;
                        tempVar.directionalOverrideStatus = dos;
                        tempVar.directionalIsolateStatus = isIsolate;
                        dirStatusStack.push(tempVar.clone());
                        continue block6;
                    }
                    if (overflowIsolateCount != 0) continue block6;
                    ++overflowEmbeddingCount;
                    continue block6;
                }
                case PDI: {
                    if (overflowIsolateCount > 0) {
                        --overflowIsolateCount;
                    } else if (validIsolateCount != 0) {
                        overflowEmbeddingCount = 0;
                        while (!((DirectionalStatus)dirStatusStack.peek()).directionalIsolateStatus) {
                            dirStatusStack.pop();
                        }
                        dirStatusStack.pop();
                        --validIsolateCount;
                    }
                    ((int[])levels.argvalue)[i] = ((DirectionalStatus)dirStatusStack.peek()).paragraphEmbeddingLevel;
                    continue block6;
                }
                case PDF: {
                    if (overflowIsolateCount > 0) continue block6;
                    if (overflowEmbeddingCount > 0) {
                        --overflowEmbeddingCount;
                        continue block6;
                    }
                    if (((DirectionalStatus)dirStatusStack.peek()).directionalIsolateStatus || dirStatusStack.size() <= 1) continue block6;
                    dirStatusStack.pop();
                    continue block6;
                }
                case B: {
                    overflowEmbeddingCount = 0;
                    overflowIsolateCount = 0;
                    validIsolateCount = 0;
                    dirStatusStack.clear();
                    dirStatusStack.push(dirEntry.clone());
                    ((int[])levels.argvalue)[i] = level;
                    continue block6;
                }
                default: {
                    ((int[])levels.argvalue)[i] = ((DirectionalStatus)dirStatusStack.peek()).paragraphEmbeddingLevel;
                    if (((DirectionalStatus)dirStatusStack.peek()).directionalOverrideStatus == BidiClass.ON.getValue()) continue block6;
                    types[i] = ((DirectionalStatus)dirStatusStack.peek()).directionalOverrideStatus;
                }
            }
        }
    }

    private static void resolveWeaks(IsolatingRunSequence sequence) {
        int i;
        int i2;
        for (i2 = 0; i2 < sequence.length; ++i2) {
            BidiClass prevType;
            BidiClass ct = BidiClass.forValue(sequence.types[i2]);
            BidiClass bidiClass = prevType = i2 == 0 ? sequence.sos : BidiClass.forValue(sequence.types[i2 - 1]);
            if (ct != BidiClass.NSM) continue;
            boolean isIsolateOrPDI = prevType == BidiClass.LRI || prevType == BidiClass.RLI || prevType == BidiClass.FSI || prevType == BidiClass.PDI;
            sequence.types[i2] = isIsolateOrPDI ? BidiClass.ON.getValue() : prevType.getValue();
        }
        block1: for (i2 = 0; i2 < sequence.length; ++i2) {
            BidiClass chType = BidiClass.forValue(sequence.types[i2]);
            if (chType != BidiClass.EN) continue;
            for (int j = i2 - 1; j >= 0; --j) {
                BidiClass type = BidiClass.forValue(sequence.types[j]);
                if (type != BidiClass.R && type != BidiClass.AL && type != BidiClass.L || type != BidiClass.AL) continue;
                sequence.types[i2] = BidiClass.AN.getValue();
                continue block1;
            }
        }
        for (i2 = 0; i2 < sequence.length; ++i2) {
            if (sequence.types[i2] != BidiClass.AL.getValue()) continue;
            sequence.types[i2] = BidiClass.R.getValue();
        }
        for (i2 = 1; i2 < sequence.length - 1; ++i2) {
            BidiClass cct = BidiClass.forValue(sequence.types[i2]);
            BidiClass prevType = BidiClass.forValue(sequence.types[i2 - 1]);
            BidiClass nextType = BidiClass.forValue(sequence.types[i2 + 1]);
            if (cct == BidiClass.ES && prevType == BidiClass.EN && nextType == BidiClass.EN) {
                sequence.types[i2] = BidiClass.EN.getValue();
                continue;
            }
            if (cct != BidiClass.CS || (prevType != BidiClass.EN || nextType != BidiClass.EN) && (prevType != BidiClass.AN || nextType != BidiClass.AN)) continue;
            sequence.types[i2] = prevType.getValue();
        }
        BidiClass[] typesSet = new BidiClass[]{BidiClass.ET};
        for (i = 0; i < sequence.length; ++i) {
            BidiClass type;
            if (sequence.types[i] != BidiClass.ET.getValue()) continue;
            int runStart = i;
            int runEnd = StiBidirectionalConvert2.getRunLimit(sequence, runStart, sequence.length, typesSet);
            BidiClass bidiClass = type = runStart > 0 ? BidiClass.forValue(sequence.types[runStart - 1]) : sequence.sos;
            if (type != BidiClass.EN) {
                BidiClass bidiClass2 = type = runEnd < sequence.length ? BidiClass.forValue(sequence.types[runEnd]) : sequence.eos;
            }
            if (type == BidiClass.EN) {
                StiBidirectionalConvert2.setRunTypes(sequence, runStart, runEnd, BidiClass.EN);
            }
            i = runEnd;
        }
        for (i = 0; i < sequence.length; ++i) {
            BidiClass t = BidiClass.forValue(sequence.types[i]);
            if (t != BidiClass.ET && t != BidiClass.ES && t != BidiClass.CS) continue;
            sequence.types[i] = BidiClass.ON.getValue();
        }
        block7: for (i = 0; i < sequence.length; ++i) {
            if (sequence.types[i] != BidiClass.EN.getValue()) continue;
            BidiClass prevStrong = sequence.sos;
            for (int j = i - 1; j >= 0; --j) {
                BidiClass t = BidiClass.forValue(sequence.types[j]);
                if (t == BidiClass.R || t == BidiClass.L || t == BidiClass.AL) {
                    prevStrong = t;
                    continue block7;
                }
                if (prevStrong != BidiClass.L) continue;
                sequence.types[i] = BidiClass.L.getValue();
            }
        }
    }

    private static void resolveNeutrals(IsolatingRunSequence sequence, String input) {
        int n;
        int[][] pairStack = new int[63][2];
        int stackPointer = 0;
        ArrayList<StiKeyValue<Integer, Integer>> pairList = new ArrayList<StiKeyValue<Integer, Integer>>();
        block0: for (int i = 0; i < sequence.length; ++i) {
            char c = input.charAt(sequence.indexes[i]);
            if (StiBidirectionalConvert2.isBracketTypeOpen(c)) {
                if (stackPointer >= 63) break;
                pairStack[stackPointer][0] = c;
                pairStack[stackPointer][1] = i;
                ++stackPointer;
                continue;
            }
            if (!StiBidirectionalConvert2.isBracketTypeClose(c) || stackPointer == 0) continue;
            char chPair = (char)Bidi_Types.mirrorChars[c];
            for (int stackP2 = stackPointer - 1; stackP2 >= 0; --stackP2) {
                if (pairStack[stackP2][0] != chPair) continue;
                stackPointer = stackP2;
                pairList.add(new StiKeyValue<Integer, Integer>(pairStack[stackP2][1], i));
                continue block0;
            }
        }
        for (StiKeyValue stiKeyValue : pairList) {
            BidiClass ct;
            int i;
            boolean found = false;
            BidiClass strongType = BidiClass.ON;
            for (i = (Integer)stiKeyValue.getKey() + 1; i < (Integer)stiKeyValue.getValue(); ++i) {
                ct = BidiClass.forValue(sequence.types[i]);
                if (ct == BidiClass.AN || ct == BidiClass.EN) {
                    ct = BidiClass.R;
                }
                if (ct != BidiClass.L && ct != BidiClass.R) continue;
                strongType = ct;
                if (sequence.sos != ct) continue;
                found = true;
                break;
            }
            if (!found) {
                for (i = (Integer)stiKeyValue.getKey() - 1; i >= 0; --i) {
                    ct = BidiClass.forValue(sequence.types[i]);
                    if (ct == BidiClass.AN || ct == BidiClass.EN) {
                        ct = BidiClass.R;
                    }
                    if (ct != BidiClass.L && ct != BidiClass.R || strongType != ct) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                strongType = sequence.sos;
            }
            sequence.types[((Integer)stiKeyValue.getKey()).intValue()] = strongType.getValue();
            sequence.types[((Integer)stiKeyValue.getValue()).intValue()] = strongType.getValue();
        }
        BidiClass[] typesSet = new BidiClass[]{BidiClass.B, BidiClass.S, BidiClass.WS, BidiClass.ON, BidiClass.LRI, BidiClass.RLI, BidiClass.FSI, BidiClass.PDI};
        boolean bl = false;
        while (n < sequence.length) {
            boolean isNI;
            BidiClass ct = BidiClass.forValue(sequence.types[n]);
            boolean bl2 = isNI = ct == BidiClass.B || ct == BidiClass.S || ct == BidiClass.WS || ct == BidiClass.ON || ct == BidiClass.LRI || ct == BidiClass.RLI || ct == BidiClass.FSI || ct == BidiClass.PDI;
            if (isNI) {
                BidiClass leadType = BidiClass.forValue(0);
                BidiClass trailType = BidiClass.forValue(0);
                void start = n;
                int runEnd = StiBidirectionalConvert2.getRunLimit(sequence, (int)start, sequence.length, typesSet);
                if (start == false) {
                    leadType = sequence.sos;
                } else {
                    leadType = BidiClass.forValue(sequence.types[start - true]);
                    if (leadType == BidiClass.AN || leadType == BidiClass.EN) {
                        leadType = BidiClass.R;
                    }
                }
                if (runEnd == sequence.length) {
                    trailType = sequence.eos;
                } else {
                    trailType = BidiClass.forValue(sequence.types[runEnd]);
                    if (trailType == BidiClass.AN || trailType == BidiClass.EN) {
                        trailType = BidiClass.R;
                    }
                }
                if (leadType == trailType) {
                    StiBidirectionalConvert2.setRunTypes(sequence, (int)start, runEnd, leadType);
                } else {
                    BidiClass runDirection = StiBidirectionalConvert2.getTypeForLevel(sequence.level);
                    StiBidirectionalConvert2.setRunTypes(sequence, (int)start, runEnd, runDirection);
                }
                n = runEnd;
            }
            ++n;
        }
    }

    private static void resolveImplicit(IsolatingRunSequence sequence) {
        int level = sequence.level;
        sequence.resolvedLevels = new int[sequence.length];
        StiRefObject tempRefResolvedLevels = new StiRefObject((Object)sequence.resolvedLevels);
        StiBidirectionalConvert2.setLevels((StiRefObject<int[]>)tempRefResolvedLevels, sequence.level);
        sequence.resolvedLevels = (int[])tempRefResolvedLevels.argvalue;
        for (int i = 0; i < sequence.length; ++i) {
            BidiClass ct = BidiClass.forValue(sequence.types[i]);
            if (!StiBidirectionalConvert2.isOdd(level)) {
                if (ct == BidiClass.R) {
                    int n = i;
                    sequence.resolvedLevels[n] = sequence.resolvedLevels[n] + 1;
                    continue;
                }
                if (ct != BidiClass.AN && ct != BidiClass.EN) continue;
                int n = i;
                sequence.resolvedLevels[n] = sequence.resolvedLevels[n] + 2;
                continue;
            }
            if (ct != BidiClass.L && ct != BidiClass.AN && ct != BidiClass.EN) continue;
            int n = i;
            sequence.resolvedLevels[n] = sequence.resolvedLevels[n] + 1;
        }
    }

    private static void applyTypesAndLevels(IsolatingRunSequence sequence, StiRefObject<int[]> typesList, StiRefObject<int[]> levelsList) {
        for (int i = 0; i < sequence.length; ++i) {
            int idx = sequence.indexes[i];
            ((int[])typesList.argvalue)[idx] = sequence.types[i];
            ((int[])levelsList.argvalue)[idx] = sequence.resolvedLevels[i];
        }
    }

    private static int[] getReorderedIndexes(int level, int[] typesList, int[] levelsList, int[] lineBreaks, StiRefObject<int[]> levels) {
        levels.argvalue = StiBidirectionalConvert2.getTextLevels(level, typesList, levelsList, lineBreaks);
        int[] multilineLevels = StiBidirectionalConvert2.getMultiLineReordered((int[])levels.argvalue, lineBreaks);
        return multilineLevels;
    }

    private static void getMatchingPDI(int[] types, StiRefObject<int[]> outMatchingPDI, StiRefObject<int[]> outMatchingIsolateInitiator) {
        int[] matchingPDI = new int[types.length];
        int[] matchingIsolateInitiator = new int[types.length];
        for (int i = 0; i < types.length; ++i) {
            BidiClass cct = BidiClass.forValue(types[i]);
            if (cct == BidiClass.LRI || cct == BidiClass.RLI || cct == BidiClass.FSI) {
                int counter = 1;
                boolean hasMatchingPDI = false;
                for (int j = i + 1; j < types.length; ++j) {
                    BidiClass nct = BidiClass.forValue(types[j]);
                    if (nct == BidiClass.LRI || nct == BidiClass.RLI || nct == BidiClass.FSI) {
                        ++counter;
                        continue;
                    }
                    if (nct != BidiClass.PDI || --counter != 0) continue;
                    hasMatchingPDI = true;
                    matchingPDI[i] = j;
                    matchingIsolateInitiator[j] = i;
                    break;
                }
                if (hasMatchingPDI) continue;
                matchingPDI[i] = types.length;
                continue;
            }
            matchingPDI[i] = -1;
            matchingIsolateInitiator[i] = -1;
        }
        outMatchingPDI.argvalue = matchingPDI;
        outMatchingIsolateInitiator.argvalue = matchingIsolateInitiator;
    }

    private static void removeX9Characters(StiRefObject<int[]> buffer) {
        for (int i = 0; i < ((int[])buffer.argvalue).length; ++i) {
            BidiClass ct = BidiClass.forValue(((int[])buffer.argvalue)[i]);
            if (ct != BidiClass.LRE && ct != BidiClass.RLE && ct != BidiClass.LRO && ct != BidiClass.RLO) continue;
            ((int[])buffer.argvalue)[i] = BidiClass.BN.getValue();
        }
    }

    private static ArrayList<ArrayList<Integer>> getLevelRuns(int[] levels) {
        ArrayList<Integer> runList = new ArrayList<Integer>();
        ArrayList<ArrayList<Integer>> allRunsList = new ArrayList<ArrayList<Integer>>();
        int currentLevel = -1;
        for (int i = 0; i < levels.length; ++i) {
            if (levels[i] != currentLevel) {
                if (currentLevel >= 0) {
                    allRunsList.add(runList);
                    runList.clear();
                }
                currentLevel = levels[i];
            }
            runList.add(i);
        }
        if (!runList.isEmpty()) {
            allRunsList.add(runList);
        }
        return allRunsList;
    }

    private static int[] getRunForCharacter(ArrayList<ArrayList<Integer>> levelRuns, int length) {
        int[] runCharsArray = new int[length];
        for (int i = 0; i < levelRuns.size(); ++i) {
            for (int j = 0; j < levelRuns.get(i).size(); ++j) {
                int chPos;
                runCharsArray[chPos] = chPos = levelRuns.get(i).get(j).intValue();
            }
        }
        return runCharsArray;
    }

    private static ArrayList<IsolatingRunSequence> getIsolatingRunSequences(int pLevel, int[] types, int[] levels, ArrayList<ArrayList<Integer>> levelRuns, int[] matchingIsolateInitiator, int[] matchingPDI, int[] runCharsArray) {
        ArrayList<IsolatingRunSequence> allRunSequences = new ArrayList<IsolatingRunSequence>(levelRuns.size());
        for (ArrayList<Integer> run : levelRuns) {
            Integer first = run.get(0);
            if (BidiClass.forValue(types[first]) == BidiClass.PDI && matchingIsolateInitiator[first] != -1) continue;
            ArrayList<Integer> currRunSequence = new ArrayList<Integer>(run);
            int lastCh = currRunSequence.get(currRunSequence.size() - 1);
            BidiClass lastType = BidiClass.forValue(types[lastCh]);
            boolean isIsolateInitiator = lastType == BidiClass.RLI || lastType == BidiClass.LRI || lastType == BidiClass.FSI;
            int lastChMatchingPDI = matchingPDI[lastCh];
            while (isIsolateInitiator && lastChMatchingPDI != types.length) {
                int lChRunIndex = runCharsArray[lastChMatchingPDI];
                ArrayList<Integer> newRun = levelRuns.get(lChRunIndex);
                currRunSequence.addAll(newRun);
            }
            allRunSequences.add(new IsolatingRunSequence(pLevel, currRunSequence, types, levels));
        }
        return allRunSequences;
    }

    private static void computeIsolatingRunSequence(IsolatingRunSequence sequence, int pLevel, ArrayList<Integer> indexList, int[] typesList, int[] levels) {
        int firstLevel;
        int i;
        sequence.length = indexList.size();
        sequence.indexes = new int[indexList.size()];
        for (i = 0; i < indexList.size(); ++i) {
            sequence.indexes[i] = indexList.get(i);
        }
        sequence.types = new int[indexList.size()];
        for (i = 0; i < sequence.length; ++i) {
            sequence.types[i] = typesList[indexList.get(i)];
        }
        sequence.level = firstLevel = levels[indexList.get(0)];
        int previous = indexList.get(0) - 1;
        int prevLevel = previous >= 0 ? levels[previous] : pLevel;
        sequence.sos = StiBidirectionalConvert2.getTypeForLevel(Math.max(firstLevel, prevLevel));
        BidiClass lastType = BidiClass.forValue(sequence.types[sequence.length - 1]);
        int last = indexList.get(sequence.length - 1);
        int lastLevel = levels[last];
        int next = indexList.get(sequence.length - 1) + 1;
        int nextLevel = next < typesList.length && lastType != BidiClass.PDI ? levels[last] : pLevel;
        sequence.eos = StiBidirectionalConvert2.getTypeForLevel(Math.max(lastLevel, nextLevel));
    }

    private static void setLevels(StiRefObject<int[]> levels, int newLevel) {
        for (int i = 0; i < ((int[])levels.argvalue).length; ++i) {
            ((int[])levels.argvalue)[i] = newLevel;
        }
    }

    private static int getRunLimit(IsolatingRunSequence sequence, int index, int limit, BidiClass[] typesSet) {
        block0: while (index < limit) {
            BidiClass type = BidiClass.forValue(sequence.types[index]);
            for (int i = 0; i < typesSet.length; ++i) {
                if (type != typesSet[i]) continue;
                ++index;
                continue block0;
            }
            return index;
        }
        return limit;
    }

    private static void setRunTypes(IsolatingRunSequence sequence, int start, int limit, BidiClass newType) {
        for (int i = start; i < limit; ++i) {
            sequence.types[i] = newType.getValue();
        }
    }

    private static int leastGreaterOdd(int l) {
        return StiBidirectionalConvert2.isOdd(l) ? l + 2 : l + 1;
    }

    private static int leastGreaterEven(int l) {
        return !StiBidirectionalConvert2.isOdd(l) ? l + 2 : l + 1;
    }

    private static boolean isOdd(int n) {
        return (n & 1) != 0;
    }

    private static BidiClass getTypeForLevel(int level) {
        return (level & 1) == 0 ? BidiClass.L : BidiClass.R;
    }

    private static int[] getTextLevels(int paragraphEmbeddingLevel, int[] typesList, int[] levelsList, int[] lineBreaks) {
        int[] finalLevels = levelsList;
        for (int i = 0; i < finalLevels.length; ++i) {
            BidiClass t = BidiClass.forValue(typesList[i]);
            if (t == BidiClass.S || t == BidiClass.B) {
                finalLevels[i] = paragraphEmbeddingLevel;
            }
            for (int j = i - 1; j >= 0 && ((t = BidiClass.forValue(typesList[j])) == BidiClass.LRI || t == BidiClass.RLI || t == BidiClass.FSI || t == BidiClass.FSI); --j) {
                finalLevels[j] = paragraphEmbeddingLevel;
            }
        }
        int start = 0;
        for (int i = 0; i < lineBreaks.length; ++i) {
            BidiClass t;
            int end = lineBreaks[i];
            for (int j = end - 1; j >= start && ((t = BidiClass.forValue(typesList[j])) == BidiClass.LRI || t == BidiClass.RLI || t == BidiClass.FSI || t == BidiClass.FSI); --j) {
                finalLevels[j] = paragraphEmbeddingLevel;
            }
            start = end;
        }
        return finalLevels;
    }

    private static int[] getMultiLineReordered(int[] levels, int[] lineBreaks) {
        int[] resultIndexes = new int[levels.length];
        int start = 0;
        for (int i = 0; i < lineBreaks.length; ++i) {
            int end = lineBreaks[i];
            int[] tempLevels = new int[end - start];
            System.arraycopy(levels, start, tempLevels, 0, tempLevels.length);
            int[] tempReorderedIndexes = StiBidirectionalConvert2.computeReorderingIndexes(tempLevels);
            for (int j = 0; j < tempReorderedIndexes.length; ++j) {
                resultIndexes[start + j] = tempReorderedIndexes[j] + start;
            }
            start = end;
        }
        return resultIndexes;
    }

    private static int[] computeReorderingIndexes(int[] levels) {
        int lineLength = levels.length;
        int[] resultIndexes = new int[lineLength];
        for (int i = 0; i < lineLength; ++i) {
            resultIndexes[i] = i;
        }
        int highestLevel = 0;
        int lowestOddLevel = 127;
        for (int level : levels) {
            if (level > highestLevel) {
                highestLevel = level;
            }
            if (!StiBidirectionalConvert2.isOdd(level) || level >= lowestOddLevel) continue;
            lowestOddLevel = level;
        }
        for (int l = highestLevel; l >= lowestOddLevel; --l) {
            for (int i = 0; i < lineLength; ++i) {
                int end;
                if (levels[i] < l) continue;
                int start = i;
                for (end = i + 1; end < lineLength && levels[end] >= l; ++end) {
                }
                int j = start;
                for (int k = end - 1; j < k; ++j, --k) {
                    int tmp = resultIndexes[j];
                    resultIndexes[j] = resultIndexes[k];
                    resultIndexes[k] = tmp;
                }
                i = end;
            }
        }
        return resultIndexes;
    }

    private static String getOrderedString(String input, int[] newIndexes, int[] levels) {
        StringBuilder sb = new StringBuilder(input.length());
        for (int i = 0; i < newIndexes.length; ++i) {
            char ch2;
            int index = newIndexes[i];
            char ch = input.charAt(index);
            if (levels[index] % 2 == 1 && (ch2 = (char)Bidi_Types.mirrorChars[ch]) != '\u0000') {
                ch = ch2;
            }
            if (ch == '\u200e' || ch == '\u200f' || ch == '\u2066' || ch == '\u2067' || ch == '\u2068' || ch == '\u202a' || ch == '\u202b' || ch == '\u202d' || ch == '\u202e' || ch == '\u2069' || ch == '\u202c') continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    private static boolean isBracketTypeOpen(char ch) {
        return LeftBracketsList.indexOf(ch) != -1;
    }

    private static boolean isBracketTypeClose(char ch) {
        return RightBracketsList.indexOf(ch) != -1;
    }

    static class Bidi_Types {
        private static final int arabicTableSize = 97;
        private static final int ligaturesTableSize = 40;
        public static int[] bidiCharTypes;
        public static int[] mirrorChars;
        public static int[][] arabicTable;
        public static String[][] ligaturesTable;

        Bidi_Types() {
        }

        public static int getArabicTableValue(int sym, int column) {
            int index = 0;
            if ((sym & 0xFF00) == 1280 || (sym & 0xFF00) == 1536) {
                index = sym - 1280;
            }
            if ((sym & 0xFF00) == 64256) {
                index = sym - 63744;
            }
            return arabicTable[index][column];
        }

        static {
            int index;
            bidiCharTypes = null;
            mirrorChars = null;
            arabicTable = null;
            ligaturesTable = null;
            byte[] packed = StiBase64DecoderUtil.decode((String)"eJzt3Yt6myAYgOF/022Rimm4/4udiijgATVq0vZ722XK6QdE6+qepHI+75+PexW43+s0Y5RSplGURVneemWbaGTWmvwuUDWrbMK38evyVdOZ263ZNDdZan4h7Kp8vLv+0JvAeN8vEmXW9MWCrovr3tXr8eJwy7yZ+cm6Y6K3yOov++1ayeYN+V7Uj1qzAnOl8jIPzodcJM/r77WmOti2b6mPj6ZQfoUu+ocbSZ1g7Mbw82uqnlSpDup5smGuNvKi5BLI1uubyLLmyuevgh/siQtPW3M4+jbBbQ+llgPsDz/EDxJGpaJUpRazN+jiu1fbkURzozLPx2/iDvM/LhWmhqOXJ+dfT8//lgE+0QGJaq9ryt74qCPuAdzY7SHoR6rT43c3ZM+IG56OFKWaI8bt2Xz+nWWYfC0nhtTi37C5s8m/Cp6rjx+vsmPDL7bVTLDeuXx1ILh8+dlRuWlDo3KJNmYX2l7xF4p2FcYZUZrXzkXDAC6yeUUPv5kQ4Nt7zGe96BTQevmkTecvZifzV4luAIabMi9VTV194uvLsN/8gmThaLzaEbO2g3Y3MkNKkNFMo3nba7VJmqmoXzTdlxvdjq7Q37V3eyvF52eXKAm2hl4d5jxD/9+hN2jodWZrC76u9nmmvx9dz9P78hhUVSXZ3M+Jx/3Xn3+//5bKPY73lGbWo32I3wazz/Nv9ZZ9/lIUdb4Mz2PsfkxNklmpEyFe8N0z4eBn+DCtdhBivyT85bEtYgu4La9SRzYyL1fEhxcjcoSF5s3htnciMFfdr5/KX3SbIIcy+HLCozY6hOJddffqG15eIWuWj7iGpC++b9nJfLUoIzj/lurNkR/OAEdx60nwVszEUTFTid9P6p9DZis51kIgc5Z18b8ymRWXenQbZk5fs1svXSuuMTlLszRFzvyfyic2fR2zguy1o+qW2Lu6ttB+Kt4buairySCpfAAAAAAAAAAAAFzMPEkAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD+C2UdwgPMncvgIWek/4vWlTJJc4qIwE3T3x75MF9GHfmCpOXhW5zt+FPdp2ckCS2W+Njc498fLGW0AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACslemsV2Q+6V4l676d/HSpTkuOq4zfxzR/0t4WZKWgkgneuLQVv+9t/KamJqE0pdQvjjKmKOq/xShl+vg7x3g4kaoekKq71ijKoixvvW4QMmtdfqLQ2dqxKSWjjtjd/2GsGxo=");
            InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(packed));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1000];
            try {
                int len;
                while ((len = ((InputStream)in).read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
                ((InputStream)in).close();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            byte[] res = out.toByteArray();
            bidiCharTypes = new int[65535];
            for (int i = 0; i < res.length; ++i) {
                Bidi_Types.bidiCharTypes[i] = res[i];
            }
            int[][] tempArabicTable = new int[][]{{1569, 1, 65152, 0, 0, 0}, {1570, 2, 65153, 65154, 0, 0}, {1571, 2, 65155, 65156, 0, 0}, {1572, 2, 65157, 65158, 0, 0}, {1573, 2, 65159, 65160, 0, 0}, {1574, 3, 65161, 65162, 65163, 65164}, {1575, 2, 65165, 65166, 0, 0}, {1576, 3, 65167, 65168, 65169, 65170}, {1577, 2, 65171, 65172, 0, 0}, {1578, 3, 65173, 65174, 65175, 65176}, {1579, 3, 65177, 65178, 65179, 65180}, {1580, 3, 65181, 65182, 65183, 65184}, {1581, 3, 65185, 65186, 65187, 65188}, {1582, 3, 65189, 65190, 65191, 65192}, {1583, 2, 65193, 65194, 0, 0}, {1584, 2, 65195, 65196, 0, 0}, {1585, 2, 65197, 65198, 0, 0}, {1586, 2, 65199, 65200, 0, 0}, {1587, 3, 65201, 65202, 65203, 65204}, {1588, 3, 65205, 65206, 65207, 65208}, {1589, 3, 65209, 65210, 65211, 65212}, {1590, 3, 65213, 65214, 65215, 65216}, {1591, 3, 65217, 65218, 65219, 65220}, {1592, 3, 65221, 65222, 65223, 65224}, {1593, 3, 65225, 65226, 65227, 65228}, {1594, 3, 65229, 65230, 65231, 65232}, {1601, 3, 65233, 65234, 65235, 65236}, {1602, 3, 65237, 65238, 65239, 65240}, {1603, 3, 65241, 65242, 65243, 65244}, {1604, 3, 65245, 65246, 65247, 65248}, {1605, 3, 65249, 65250, 65251, 65252}, {1606, 3, 65253, 65254, 65255, 65256}, {1607, 3, 65257, 65258, 65259, 65260}, {1608, 2, 65261, 65262, 0, 0}, {1609, 3, 65263, 65264, 64488, 64489}, {1610, 3, 65265, 65266, 65267, 65268}, {1649, 2, 64336, 64337, 0, 0}, {1655, 2, 64477, 1655, 0, 0}, {1657, 3, 64358, 64359, 64360, 64361}, {1658, 3, 64350, 64351, 64352, 64353}, {1659, 3, 64338, 64339, 64340, 64341}, {1662, 3, 64342, 64343, 64344, 64345}, {1663, 3, 64354, 64355, 64356, 64357}, {1664, 3, 64346, 64347, 64348, 64349}, {1667, 3, 64374, 64375, 64376, 64377}, {1668, 3, 64370, 64371, 64372, 64373}, {1670, 3, 64378, 64379, 64380, 64381}, {1671, 3, 64382, 64383, 64384, 64385}, {1672, 2, 64392, 64393, 0, 0}, {1676, 2, 64388, 64389, 0, 0}, {1677, 2, 64386, 64387, 0, 0}, {1678, 2, 64390, 64391, 0, 0}, {1681, 2, 64396, 64397, 0, 0}, {1688, 2, 64394, 64395, 0, 0}, {1700, 3, 64362, 64363, 64364, 64365}, {1702, 3, 64366, 64367, 64368, 64369}, {1705, 3, 64398, 64399, 64400, 64401}, {1709, 3, 64467, 64468, 64469, 64470}, {1711, 3, 64402, 64403, 64404, 64405}, {1713, 3, 64410, 64411, 64412, 64413}, {1715, 3, 64406, 64407, 64408, 64409}, {1722, 2, 64414, 64415, 0, 0}, {1723, 3, 64416, 64417, 64418, 64419}, {1726, 3, 64426, 64427, 64428, 64429}, {1728, 2, 64420, 64421, 0, 0}, {1729, 3, 64422, 64423, 64424, 64425}, {1733, 2, 64480, 64481, 0, 0}, {1734, 2, 64473, 64474, 0, 0}, {1735, 2, 64471, 64472, 0, 0}, {1736, 2, 64475, 64476, 0, 0}, {1737, 2, 64482, 64483, 0, 0}, {1739, 2, 64478, 64479, 0, 0}, {1740, 3, 64508, 64509, 64510, 64511}, {1744, 3, 64484, 64485, 64486, 64487}, {1746, 2, 64430, 64431, 0, 0}, {1747, 2, 64432, 64433, 0, 0}, {1611, 3, 1611, 1611, 1611, 1611}, {1612, 3, 1612, 1612, 1612, 1612}, {1613, 3, 1613, 1613, 1613, 1613}, {1614, 3, 1614, 1614, 1614, 1614}, {1615, 3, 1615, 1615, 1615, 1615}, {1616, 3, 1616, 1616, 1616, 1616}, {1617, 3, 1617, 1617, 1617, 1617}, {1618, 3, 1618, 1618, 1618, 1618}, {1619, 3, 1619, 1619, 1619, 1619}, {1620, 3, 1620, 1620, 1620, 1620}, {1621, 3, 1621, 1621, 1621, 1621}, {1622, 3, 1622, 1622, 1622, 1622}, {1623, 3, 1623, 1623, 1623, 1623}, {1624, 3, 1624, 1624, 1624, 1624}, {1625, 3, 1625, 1625, 1625, 1625}, {1626, 3, 1626, 1626, 1626, 1626}, {1627, 3, 1627, 1627, 1627, 1627}, {1628, 3, 1628, 1628, 1628, 1628}, {1629, 3, 1629, 1629, 1629, 1629}, {1630, 3, 1630, 1630, 1630, 1630}, {1631, 3, 1631, 1631, 1631, 1631}};
            arabicTable = new int[768][5];
            for (index = 0; index < 97; ++index) {
                int tempInt = tempArabicTable[index][0] - 1280;
                Bidi_Types.arabicTable[tempInt][0] = tempArabicTable[index][1];
                Bidi_Types.arabicTable[tempInt][1] = tempArabicTable[index][2];
                Bidi_Types.arabicTable[tempInt][2] = tempArabicTable[index][3];
                Bidi_Types.arabicTable[tempInt][3] = tempArabicTable[index][4];
                Bidi_Types.arabicTable[tempInt][4] = tempArabicTable[index][5];
            }
            for (index = 1424; index <= 1535; ++index) {
                Bidi_Types.arabicTable[index - 1280][0] = 1;
                Bidi_Types.arabicTable[index - 1280][1] = index;
            }
            for (index = 64285; index <= 64335; ++index) {
                Bidi_Types.arabicTable[index - 63744][0] = 1;
                Bidi_Types.arabicTable[index - 63744][1] = index;
            }
            ligaturesTable = new String[][]{{"\ufedf\ufe82", "\ufef5"}, {"\ufee0\ufe82", "\ufef6"}, {"\ufedf\ufe84", "\ufef7"}, {"\ufee0\ufe84", "\ufef8"}, {"\ufedf\ufe88", "\ufef9"}, {"\ufee0\ufe88", "\ufefa"}, {"\ufedf\ufe8e", "\ufefb"}, {"\ufee0\ufe8e", "\ufefc"}, {"\u05e9\u05c1", "\ufb2a"}, {"\u05e9\u05c2", "\ufb2b"}, {"\ufb49\u05c1", "\ufb2c"}, {"\ufb49\u05c2", "\ufb2d"}, {"\u05d0\u05b7", "\ufb2e"}, {"\u05d0\u05b8", "\ufb2f"}, {"\u05d0\u05bc", "\ufb30"}, {"\u05d1\u05bc", "\ufb31"}, {"\u05d2\u05bc", "\ufb32"}, {"\u05d3\u05bc", "\ufb33"}, {"\u05d4\u05bc", "\ufb34"}, {"\u05d5\u05bc", "\ufb35"}, {"\u05d6\u05bc", "\ufb36"}, {"\u05d8\u05bc", "\ufb38"}, {"\u05d9\u05bc", "\ufb39"}, {"\u05da\u05bc", "\ufb3a"}, {"\u05db\u05bc", "\ufb3b"}, {"\u05dc\u05bc", "\ufb3c"}, {"\u05de\u05bc", "\ufb3e"}, {"\u05e0\u05bc", "\ufb40"}, {"\u05e1\u05bc", "\ufb41"}, {"\u05e3\u05bc", "\ufb43"}, {"\u05e4\u05bc", "\ufb44"}, {"\u05e6\u05bc", "\ufb46"}, {"\u05e7\u05bc", "\ufb47"}, {"\u05e8\u05bc", "\ufb48"}, {"\u05e9\u05bc", "\ufb49"}, {"\u05ea\u05bc", "\ufb4a"}, {"\u05d5\u05b9", "\ufb4b"}, {"\u05d1\u05bf", "\ufb4c"}, {"\u05db\u05bf", "\ufb4d"}, {"\u05e4\u05bf", "\ufb4e"}};
            mirrorChars = new int[65536];
            Bidi_Types.mirrorChars[40] = 41;
            Bidi_Types.mirrorChars[41] = 40;
            Bidi_Types.mirrorChars[60] = 62;
            Bidi_Types.mirrorChars[62] = 60;
            Bidi_Types.mirrorChars[91] = 93;
            Bidi_Types.mirrorChars[93] = 91;
            Bidi_Types.mirrorChars[123] = 125;
            Bidi_Types.mirrorChars[125] = 123;
            Bidi_Types.mirrorChars[171] = 187;
            Bidi_Types.mirrorChars[187] = 171;
            Bidi_Types.mirrorChars[8249] = 8250;
            Bidi_Types.mirrorChars[8250] = 8249;
            Bidi_Types.mirrorChars[8261] = 8262;
            Bidi_Types.mirrorChars[8262] = 8261;
            Bidi_Types.mirrorChars[8317] = 8318;
            Bidi_Types.mirrorChars[8318] = 8317;
            Bidi_Types.mirrorChars[8333] = 8334;
            Bidi_Types.mirrorChars[8334] = 8333;
            Bidi_Types.mirrorChars[8712] = 8715;
            Bidi_Types.mirrorChars[8713] = 8716;
            Bidi_Types.mirrorChars[8714] = 8717;
            Bidi_Types.mirrorChars[8715] = 8712;
            Bidi_Types.mirrorChars[8716] = 8713;
            Bidi_Types.mirrorChars[8717] = 8714;
            Bidi_Types.mirrorChars[8725] = 10741;
            Bidi_Types.mirrorChars[8764] = 8765;
            Bidi_Types.mirrorChars[8765] = 8764;
            Bidi_Types.mirrorChars[8771] = 8909;
            Bidi_Types.mirrorChars[8786] = 8787;
            Bidi_Types.mirrorChars[8787] = 8786;
            Bidi_Types.mirrorChars[8788] = 8789;
            Bidi_Types.mirrorChars[8789] = 8788;
            Bidi_Types.mirrorChars[8804] = 8805;
            Bidi_Types.mirrorChars[8805] = 8804;
            Bidi_Types.mirrorChars[8806] = 8807;
            Bidi_Types.mirrorChars[8807] = 8806;
            Bidi_Types.mirrorChars[8808] = 8809;
            Bidi_Types.mirrorChars[8809] = 8808;
            Bidi_Types.mirrorChars[8810] = 8811;
            Bidi_Types.mirrorChars[8811] = 8810;
            Bidi_Types.mirrorChars[8814] = 8815;
            Bidi_Types.mirrorChars[8815] = 8814;
            Bidi_Types.mirrorChars[8816] = 8817;
            Bidi_Types.mirrorChars[8817] = 8816;
            Bidi_Types.mirrorChars[8818] = 8819;
            Bidi_Types.mirrorChars[8819] = 8818;
            Bidi_Types.mirrorChars[8820] = 8821;
            Bidi_Types.mirrorChars[8821] = 8820;
            Bidi_Types.mirrorChars[8822] = 8823;
            Bidi_Types.mirrorChars[8823] = 8822;
            Bidi_Types.mirrorChars[8824] = 8825;
            Bidi_Types.mirrorChars[8825] = 8824;
            Bidi_Types.mirrorChars[8826] = 8827;
            Bidi_Types.mirrorChars[8827] = 8826;
            Bidi_Types.mirrorChars[8828] = 8829;
            Bidi_Types.mirrorChars[8829] = 8828;
            Bidi_Types.mirrorChars[8830] = 8831;
            Bidi_Types.mirrorChars[8831] = 8830;
            Bidi_Types.mirrorChars[8832] = 8833;
            Bidi_Types.mirrorChars[8833] = 8832;
            Bidi_Types.mirrorChars[8834] = 8835;
            Bidi_Types.mirrorChars[8835] = 8834;
            Bidi_Types.mirrorChars[8836] = 8837;
            Bidi_Types.mirrorChars[8837] = 8836;
            Bidi_Types.mirrorChars[8838] = 8839;
            Bidi_Types.mirrorChars[8839] = 8838;
            Bidi_Types.mirrorChars[8840] = 8841;
            Bidi_Types.mirrorChars[8841] = 8840;
            Bidi_Types.mirrorChars[8842] = 8843;
            Bidi_Types.mirrorChars[8843] = 8842;
            Bidi_Types.mirrorChars[8847] = 8848;
            Bidi_Types.mirrorChars[8848] = 8847;
            Bidi_Types.mirrorChars[8849] = 8850;
            Bidi_Types.mirrorChars[8850] = 8849;
            Bidi_Types.mirrorChars[8856] = 10680;
            Bidi_Types.mirrorChars[8866] = 8867;
            Bidi_Types.mirrorChars[8867] = 8866;
            Bidi_Types.mirrorChars[8870] = 10974;
            Bidi_Types.mirrorChars[8872] = 10980;
            Bidi_Types.mirrorChars[8873] = 10979;
            Bidi_Types.mirrorChars[8875] = 10981;
            Bidi_Types.mirrorChars[8880] = 8881;
            Bidi_Types.mirrorChars[8881] = 8880;
            Bidi_Types.mirrorChars[8882] = 8883;
            Bidi_Types.mirrorChars[8883] = 8882;
            Bidi_Types.mirrorChars[8884] = 8885;
            Bidi_Types.mirrorChars[8885] = 8884;
            Bidi_Types.mirrorChars[8886] = 8887;
            Bidi_Types.mirrorChars[8887] = 8886;
            Bidi_Types.mirrorChars[8905] = 8906;
            Bidi_Types.mirrorChars[8906] = 8905;
            Bidi_Types.mirrorChars[8907] = 8908;
            Bidi_Types.mirrorChars[8908] = 8907;
            Bidi_Types.mirrorChars[8909] = 8771;
            Bidi_Types.mirrorChars[8912] = 8913;
            Bidi_Types.mirrorChars[8913] = 8912;
            Bidi_Types.mirrorChars[8918] = 8919;
            Bidi_Types.mirrorChars[8919] = 8918;
            Bidi_Types.mirrorChars[8920] = 8921;
            Bidi_Types.mirrorChars[8921] = 8920;
            Bidi_Types.mirrorChars[8922] = 8923;
            Bidi_Types.mirrorChars[8923] = 8922;
            Bidi_Types.mirrorChars[8924] = 8925;
            Bidi_Types.mirrorChars[8925] = 8924;
            Bidi_Types.mirrorChars[8926] = 8927;
            Bidi_Types.mirrorChars[8927] = 8926;
            Bidi_Types.mirrorChars[8928] = 8929;
            Bidi_Types.mirrorChars[8929] = 8928;
            Bidi_Types.mirrorChars[8930] = 8931;
            Bidi_Types.mirrorChars[8931] = 8930;
            Bidi_Types.mirrorChars[8932] = 8933;
            Bidi_Types.mirrorChars[8933] = 8932;
            Bidi_Types.mirrorChars[8934] = 8935;
            Bidi_Types.mirrorChars[8935] = 8934;
            Bidi_Types.mirrorChars[8936] = 8937;
            Bidi_Types.mirrorChars[8937] = 8936;
            Bidi_Types.mirrorChars[8938] = 8939;
            Bidi_Types.mirrorChars[8939] = 8938;
            Bidi_Types.mirrorChars[8940] = 8941;
            Bidi_Types.mirrorChars[8941] = 8940;
            Bidi_Types.mirrorChars[8944] = 8945;
            Bidi_Types.mirrorChars[8945] = 8944;
            Bidi_Types.mirrorChars[8946] = 8954;
            Bidi_Types.mirrorChars[8947] = 8955;
            Bidi_Types.mirrorChars[8948] = 8956;
            Bidi_Types.mirrorChars[8950] = 8957;
            Bidi_Types.mirrorChars[8951] = 8958;
            Bidi_Types.mirrorChars[8954] = 8946;
            Bidi_Types.mirrorChars[8955] = 8947;
            Bidi_Types.mirrorChars[8956] = 8948;
            Bidi_Types.mirrorChars[8957] = 8950;
            Bidi_Types.mirrorChars[8958] = 8951;
            Bidi_Types.mirrorChars[8968] = 8969;
            Bidi_Types.mirrorChars[8969] = 8968;
            Bidi_Types.mirrorChars[8970] = 8971;
            Bidi_Types.mirrorChars[8971] = 8970;
            Bidi_Types.mirrorChars[9001] = 9002;
            Bidi_Types.mirrorChars[9002] = 9001;
            Bidi_Types.mirrorChars[10088] = 10089;
            Bidi_Types.mirrorChars[10089] = 10088;
            Bidi_Types.mirrorChars[10090] = 10091;
            Bidi_Types.mirrorChars[10091] = 10090;
            Bidi_Types.mirrorChars[10092] = 10093;
            Bidi_Types.mirrorChars[10093] = 10092;
            Bidi_Types.mirrorChars[10094] = 10095;
            Bidi_Types.mirrorChars[10095] = 10094;
            Bidi_Types.mirrorChars[10096] = 10097;
            Bidi_Types.mirrorChars[10097] = 10096;
            Bidi_Types.mirrorChars[10098] = 10099;
            Bidi_Types.mirrorChars[10099] = 10098;
            Bidi_Types.mirrorChars[10100] = 10101;
            Bidi_Types.mirrorChars[10101] = 10100;
            Bidi_Types.mirrorChars[10197] = 10198;
            Bidi_Types.mirrorChars[10198] = 10197;
            Bidi_Types.mirrorChars[10205] = 10206;
            Bidi_Types.mirrorChars[10206] = 10205;
            Bidi_Types.mirrorChars[10210] = 10211;
            Bidi_Types.mirrorChars[10211] = 10210;
            Bidi_Types.mirrorChars[10212] = 10213;
            Bidi_Types.mirrorChars[10213] = 10212;
            Bidi_Types.mirrorChars[10214] = 10215;
            Bidi_Types.mirrorChars[10215] = 10214;
            Bidi_Types.mirrorChars[10216] = 10217;
            Bidi_Types.mirrorChars[10217] = 10216;
            Bidi_Types.mirrorChars[10218] = 10219;
            Bidi_Types.mirrorChars[10219] = 10218;
            Bidi_Types.mirrorChars[10627] = 10628;
            Bidi_Types.mirrorChars[10628] = 10627;
            Bidi_Types.mirrorChars[10629] = 10630;
            Bidi_Types.mirrorChars[10630] = 10629;
            Bidi_Types.mirrorChars[10631] = 10632;
            Bidi_Types.mirrorChars[10632] = 10631;
            Bidi_Types.mirrorChars[10633] = 10634;
            Bidi_Types.mirrorChars[10634] = 10633;
            Bidi_Types.mirrorChars[10635] = 10636;
            Bidi_Types.mirrorChars[10636] = 10635;
            Bidi_Types.mirrorChars[10637] = 10640;
            Bidi_Types.mirrorChars[10638] = 10639;
            Bidi_Types.mirrorChars[10639] = 10638;
            Bidi_Types.mirrorChars[10640] = 10637;
            Bidi_Types.mirrorChars[10641] = 10642;
            Bidi_Types.mirrorChars[10642] = 10641;
            Bidi_Types.mirrorChars[10643] = 10644;
            Bidi_Types.mirrorChars[10644] = 10643;
            Bidi_Types.mirrorChars[10645] = 10646;
            Bidi_Types.mirrorChars[10646] = 10645;
            Bidi_Types.mirrorChars[10647] = 10648;
            Bidi_Types.mirrorChars[10648] = 10647;
            Bidi_Types.mirrorChars[10680] = 8856;
            Bidi_Types.mirrorChars[10688] = 10689;
            Bidi_Types.mirrorChars[10689] = 10688;
            Bidi_Types.mirrorChars[10692] = 10693;
            Bidi_Types.mirrorChars[10693] = 10692;
            Bidi_Types.mirrorChars[10703] = 10704;
            Bidi_Types.mirrorChars[10704] = 10703;
            Bidi_Types.mirrorChars[10705] = 10706;
            Bidi_Types.mirrorChars[10706] = 10705;
            Bidi_Types.mirrorChars[10708] = 10709;
            Bidi_Types.mirrorChars[10709] = 10708;
            Bidi_Types.mirrorChars[10712] = 10713;
            Bidi_Types.mirrorChars[10713] = 10712;
            Bidi_Types.mirrorChars[10714] = 10715;
            Bidi_Types.mirrorChars[10715] = 10714;
            Bidi_Types.mirrorChars[10741] = 8725;
            Bidi_Types.mirrorChars[10744] = 10745;
            Bidi_Types.mirrorChars[10745] = 10744;
            Bidi_Types.mirrorChars[10748] = 10749;
            Bidi_Types.mirrorChars[10749] = 10748;
            Bidi_Types.mirrorChars[10795] = 10796;
            Bidi_Types.mirrorChars[10796] = 10795;
            Bidi_Types.mirrorChars[10797] = 10796;
            Bidi_Types.mirrorChars[10798] = 10797;
            Bidi_Types.mirrorChars[10804] = 10805;
            Bidi_Types.mirrorChars[10805] = 10804;
            Bidi_Types.mirrorChars[10812] = 10813;
            Bidi_Types.mirrorChars[10813] = 10812;
            Bidi_Types.mirrorChars[10852] = 10853;
            Bidi_Types.mirrorChars[10853] = 10852;
            Bidi_Types.mirrorChars[10873] = 10874;
            Bidi_Types.mirrorChars[10874] = 10873;
            Bidi_Types.mirrorChars[10877] = 10878;
            Bidi_Types.mirrorChars[10878] = 10877;
            Bidi_Types.mirrorChars[10879] = 10880;
            Bidi_Types.mirrorChars[10880] = 10879;
            Bidi_Types.mirrorChars[10881] = 10882;
            Bidi_Types.mirrorChars[10882] = 10881;
            Bidi_Types.mirrorChars[10883] = 10884;
            Bidi_Types.mirrorChars[10884] = 10883;
            Bidi_Types.mirrorChars[10891] = 10892;
            Bidi_Types.mirrorChars[10892] = 10891;
            Bidi_Types.mirrorChars[10897] = 10898;
            Bidi_Types.mirrorChars[10898] = 10897;
            Bidi_Types.mirrorChars[10899] = 10900;
            Bidi_Types.mirrorChars[10900] = 10899;
            Bidi_Types.mirrorChars[10901] = 10902;
            Bidi_Types.mirrorChars[10902] = 10901;
            Bidi_Types.mirrorChars[10903] = 10904;
            Bidi_Types.mirrorChars[10904] = 10903;
            Bidi_Types.mirrorChars[10905] = 10906;
            Bidi_Types.mirrorChars[10906] = 10905;
            Bidi_Types.mirrorChars[10907] = 10908;
            Bidi_Types.mirrorChars[10908] = 10907;
            Bidi_Types.mirrorChars[10913] = 10914;
            Bidi_Types.mirrorChars[10914] = 10913;
            Bidi_Types.mirrorChars[10918] = 10919;
            Bidi_Types.mirrorChars[10919] = 10918;
            Bidi_Types.mirrorChars[10920] = 10921;
            Bidi_Types.mirrorChars[10921] = 10920;
            Bidi_Types.mirrorChars[10922] = 10923;
            Bidi_Types.mirrorChars[10923] = 10922;
            Bidi_Types.mirrorChars[10924] = 10925;
            Bidi_Types.mirrorChars[10925] = 10924;
            Bidi_Types.mirrorChars[10927] = 10928;
            Bidi_Types.mirrorChars[10928] = 10927;
            Bidi_Types.mirrorChars[10931] = 10932;
            Bidi_Types.mirrorChars[10932] = 10931;
            Bidi_Types.mirrorChars[10939] = 10940;
            Bidi_Types.mirrorChars[10940] = 10939;
            Bidi_Types.mirrorChars[10941] = 10942;
            Bidi_Types.mirrorChars[10942] = 10941;
            Bidi_Types.mirrorChars[10943] = 10944;
            Bidi_Types.mirrorChars[10944] = 10943;
            Bidi_Types.mirrorChars[10945] = 10946;
            Bidi_Types.mirrorChars[10946] = 10945;
            Bidi_Types.mirrorChars[10947] = 10948;
            Bidi_Types.mirrorChars[10948] = 10947;
            Bidi_Types.mirrorChars[10949] = 10950;
            Bidi_Types.mirrorChars[10950] = 10949;
            Bidi_Types.mirrorChars[10957] = 10958;
            Bidi_Types.mirrorChars[10958] = 10957;
            Bidi_Types.mirrorChars[10959] = 10960;
            Bidi_Types.mirrorChars[10960] = 10959;
            Bidi_Types.mirrorChars[10961] = 10962;
            Bidi_Types.mirrorChars[10962] = 10961;
            Bidi_Types.mirrorChars[10963] = 10964;
            Bidi_Types.mirrorChars[10964] = 10963;
            Bidi_Types.mirrorChars[10965] = 10966;
            Bidi_Types.mirrorChars[10966] = 10965;
            Bidi_Types.mirrorChars[10974] = 8870;
            Bidi_Types.mirrorChars[10979] = 8873;
            Bidi_Types.mirrorChars[10980] = 8872;
            Bidi_Types.mirrorChars[10981] = 8875;
            Bidi_Types.mirrorChars[10988] = 10989;
            Bidi_Types.mirrorChars[10989] = 10988;
            Bidi_Types.mirrorChars[10999] = 11000;
            Bidi_Types.mirrorChars[11000] = 10999;
            Bidi_Types.mirrorChars[11001] = 11002;
            Bidi_Types.mirrorChars[11002] = 11001;
            Bidi_Types.mirrorChars[12296] = 12297;
            Bidi_Types.mirrorChars[12297] = 12296;
            Bidi_Types.mirrorChars[12298] = 12299;
            Bidi_Types.mirrorChars[12299] = 12298;
            Bidi_Types.mirrorChars[12300] = 12301;
            Bidi_Types.mirrorChars[12301] = 12300;
            Bidi_Types.mirrorChars[12302] = 12303;
            Bidi_Types.mirrorChars[12303] = 12302;
            Bidi_Types.mirrorChars[12304] = 12305;
            Bidi_Types.mirrorChars[12305] = 12304;
            Bidi_Types.mirrorChars[12308] = 12309;
            Bidi_Types.mirrorChars[12309] = 12308;
            Bidi_Types.mirrorChars[12310] = 12311;
            Bidi_Types.mirrorChars[12311] = 12310;
            Bidi_Types.mirrorChars[12312] = 12313;
            Bidi_Types.mirrorChars[12313] = 12312;
            Bidi_Types.mirrorChars[12314] = 12315;
            Bidi_Types.mirrorChars[12315] = 12314;
            Bidi_Types.mirrorChars[65288] = 65289;
            Bidi_Types.mirrorChars[65289] = 65288;
            Bidi_Types.mirrorChars[65308] = 65310;
            Bidi_Types.mirrorChars[65310] = 65308;
            Bidi_Types.mirrorChars[65339] = 65341;
            Bidi_Types.mirrorChars[65341] = 65339;
            Bidi_Types.mirrorChars[65371] = 65373;
            Bidi_Types.mirrorChars[65373] = 65371;
            Bidi_Types.mirrorChars[65375] = 65376;
            Bidi_Types.mirrorChars[65376] = 65375;
            Bidi_Types.mirrorChars[65378] = 65379;
            Bidi_Types.mirrorChars[65379] = 65378;
        }
    }

    private static enum BidiClass {
        L,
        LRE,
        LRO,
        R,
        AL,
        RLE,
        RLO,
        PDF,
        EN,
        ES,
        ET,
        AN,
        CS,
        NSM,
        BN,
        B,
        S,
        WS,
        ON,
        LRI,
        RLI,
        FSI,
        PDI;

        public static final int SIZE = 8;

        public int getValue() {
            return this.ordinal();
        }

        public static BidiClass forValue(int value) {
            return BidiClass.values()[value];
        }
    }

    private static class IsolatingRunSequence {
        public int level;
        public BidiClass sos = BidiClass.values()[0];
        public BidiClass eos = BidiClass.values()[0];
        public int length;
        public int[] indexes;
        public int[] types;
        public int[] resolvedLevels;

        public IsolatingRunSequence(int paragraphEmbeddingLevel, ArrayList<Integer> runIndexList, int[] types, int[] levels) {
            StiBidirectionalConvert2.computeIsolatingRunSequence(this, paragraphEmbeddingLevel, runIndexList, types, levels);
        }
    }

    private static final class DirectionalStatus {
        public int paragraphEmbeddingLevel;
        public int directionalOverrideStatus;
        public boolean directionalIsolateStatus;

        private DirectionalStatus() {
        }

        public DirectionalStatus clone() {
            DirectionalStatus varCopy = new DirectionalStatus();
            varCopy.paragraphEmbeddingLevel = this.paragraphEmbeddingLevel;
            varCopy.directionalOverrideStatus = this.directionalOverrideStatus;
            varCopy.directionalIsolateStatus = this.directionalIsolateStatus;
            return varCopy;
        }
    }

    static class StiKeyValue<T, B> {
        T key;
        B value;

        public T getKey() {
            return this.key;
        }

        public B getValue() {
            return this.value;
        }

        StiKeyValue(T t, B b) {
            this.key = t;
            this.value = b;
        }
    }
}

