/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service.helper;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.report.maps.StiMap;
import com.stimulsoft.report.maps.StiMapData;
import java.util.List;

public class HeatmapInfo {
    private double min;
    private double max;
    private List<StiColor> colors;

    public HeatmapInfo(StiMap map, List<StiMapData> mapData) throws Exception {
        boolean isFirst = true;
        for (StiMapData data : mapData) {
            if (data.getValue() == null) continue;
            double value = 0.0;
            try {
                value = Double.parseDouble(data.getValue());
            }
            catch (Exception e) {
                continue;
            }
            if (isFirst) {
                isFirst = false;
                this.min = value;
                this.max = value;
                continue;
            }
            if (value < this.min) {
                this.min = value;
                continue;
            }
            if (!(value > this.max)) continue;
            this.max = value;
        }
        this.colors = StiMap.getMapStyle(map).getHeatmapColors();
    }

    public StiBrush getBrush(StiMapData mapData, StiBrush defaultBrush) {
        if (this.min == this.max) {
            return new StiSolidBrush(this.colors.get(0));
        }
        double value = 0.0;
        if (mapData.getValue() == null) {
            return defaultBrush;
        }
        try {
            value = Double.parseDouble(mapData.getValue());
        }
        catch (Exception e) {
            return defaultBrush;
        }
        return new StiSolidBrush(StiColorUtils.changeLightness((StiColor)this.colors.get(0), (float)((float)(0.85 * (this.max - value) / (this.max - this.min)))));
    }
}

