/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service;

import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.licenses.StiLicenseKeyValidator;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.service.StiExportService;
import com.stimulsoft.report.export.service.StiPcxExportService;
import com.stimulsoft.report.export.service.StiSvgExportService;
import com.stimulsoft.report.export.service.StiTiffExportService;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiImageExportSettings;
import com.stimulsoft.report.export.tools.StiColorImageFormat;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.export.tools.StiMonochromeDitheringType;
import com.stimulsoft.report.export.tools.StiPagesRange;
import com.stimulsoft.report.export.tools.StiPcxPaletteType;
import com.stimulsoft.report.painters.StiPaintArgs;
import com.stimulsoft.report.painters.StiPainter;
import com.stimulsoft.report.units.StiUnit;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class StiImageExportService
extends StiExportService {
    public StiImageExportService() {
        this.multipleFiles = true;
    }

    public abstract StiImageFormat getImageFormat();

    private BufferedImage draw(StiReport report, StiPage page, double imageZoomBase, int imageResolution, boolean cutEdges, StiColorImageFormat imageFormat, boolean emf) {
        double imageZoom = imageZoomBase * (double)((float)imageResolution / 100.0f);
        double zoom = page.getReport().getInfo().getZoom();
        double pageZoom = page.getReport().getInfo().getPageZoom();
        page.getReport().getInfo().setZoom(imageZoom);
        page.getReport().getInfo().setPageZoom(1.0 / (imageZoom * imageZoom));
        StiUnit unit = page.getUnit();
        int imageWidth = (int)(unit.ConvertToHInches(page.getDisplayRectangle().getWidth()) * imageZoom);
        int imageHeight = (int)(unit.ConvertToHInches(page.getDisplayRectangle().getHeight()) * imageZoom);
        double lf = page.getMargins().getLeft();
        double rt = page.getMargins().getRight();
        double tp = page.getMargins().getTop();
        double bt = page.getMargins().getBottom();
        if (cutEdges) {
            imageWidth = (int)(unit.ConvertToHInches(page.getDisplayRectangle().getWidth() - lf + lf * 0.2 - rt + rt * 0.2) * imageZoom);
            imageHeight = (int)(unit.ConvertToHInches(page.getDisplayRectangle().getHeight() - tp + tp * 0.2 - bt + bt * 0.2) * imageZoom);
        }
        BufferedImage bmp = null;
        bmp = new BufferedImage(imageWidth, imageHeight, 1);
        Graphics2D g = bmp.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, imageWidth, imageHeight);
        if (cutEdges) {
            g.translate(unit.ConvertToHInches(-lf + lf * 0.2) * imageZoom, unit.ConvertToHInches(-tp + tp * 0.2) * imageZoom);
        }
        page.setDenyDrawSegmentMode(true);
        StiPainter painter = StiPainter.getPainter(page);
        painter.paint(page, new StiPaintArgs(new StiGraphics((Graphics)g)));
        page.setDenyDrawSegmentMode(false);
        page.getReport().getInfo().setZoom(zoom);
        page.getReport().getInfo().setPageZoom(pageZoom);
        if (imageFormat != StiColorImageFormat.Color) {
            bmp = StiImageHelper.makeGrayscaleImage(bmp);
        }
        return bmp;
    }

    @Override
    public void export(StiReport report, OutputStream outputStream, StiExportSettings settings) throws StiException {
        this.exportImage(report, outputStream, settings);
    }

    public void exportImage(StiReport report, OutputStream outputStream, StiExportSettings settings) throws StiException {
        try {
            report.invokeExporting(settings.getExportFormat());
            this.exportImageException(report, outputStream, settings);
            report.invokeExported(settings.getExportFormat());
        }
        catch (Exception e) {
            throw new StiException((Throwable)e);
        }
    }

    private void exportImageException(StiReport report, OutputStream outputStream, StiExportSettings exportSettings) throws IOException {
        StiLicenseKeyValidator.isValidOnJavaFramework(null);
        StiImageExportSettings settings = (StiImageExportSettings)exportSettings;
        if (settings == null) {
            throw new IllegalArgumentException("The 'settings' argument cannot be equal in null.");
        }
        StiPagesRange pageRange = settings.getPageRange();
        double imageZoom = 1.0;
        int imageResolution = 100;
        boolean cutEdges = false;
        StiColorImageFormat imageFormat = StiColorImageFormat.Color;
        StiMonochromeDitheringType ditheringType = StiMonochromeDitheringType.FloydSteinberg;
        imageZoom = settings.getImageZoom();
        imageResolution = settings.getImageResolution();
        cutEdges = settings.isCutEdges();
        imageFormat = settings.getImageFormat();
        this.multipleFiles = settings.isMultipleFiles();
        ditheringType = settings.getDitheringType();
        StiPagesCollection pages = pageRange.getSelectedPages(report.getRenderedPages());
        String name = "";
        if (pages.size() > 1 && outputStream instanceof FileOutputStream && this.exFile != null) {
            String absolutePath = this.exFile.getAbsolutePath();
            name = absolutePath.substring(0, absolutePath.lastIndexOf(".") - 3);
        }
        int index = 1;
        this.setStatusString(StiLocalization.getValue((String)"Export", (String)"ExportingCreatingDocument"));
        for (StiPage page : pages) {
            pages.GetPage(page);
            this.invokeExporting(page, pages);
            if (this.isStoped()) {
                return;
            }
            StiImageFormat format = this.getImageFormat();
            Image image = null;
            if (this.getExportFormat() != StiExportFormat.ImageSvg && this.getExportFormat() != StiExportFormat.ImageSvgz) {
                image = this.draw(report, page, imageZoom, imageResolution, cutEdges, imageFormat, format == StiImageFormat.Emf);
                if (imageFormat == StiColorImageFormat.Monochrome) {
                    image = StiImageHelper.makeMonochromeImage((BufferedImage)image, ditheringType, 128);
                }
            }
            if (this instanceof StiTiffExportService && !this.getMultipleFiles()) continue;
            if (format != StiImageFormat.Emf) {
                if (this.getExportFormat() == StiExportFormat.ImagePcx) {
                    StiPcxPaletteType paletteType = imageFormat == StiColorImageFormat.Monochrome ? StiPcxPaletteType.Monochrome : StiPcxPaletteType.Color;
                    StiPcxExportService.StiPcxHelper.saveToStream((BufferedImage)image, paletteType, ditheringType, outputStream);
                } else if (this.getExportFormat() == StiExportFormat.ImageSvg || this.getExportFormat() == StiExportFormat.ImageSvgz) {
                    StiSvgExportService.StiSvgHelper.saveToStream(report, page, outputStream, this.getExportFormat() == StiExportFormat.ImageSvgz);
                } else if (!(this instanceof StiTiffExportService)) {
                    StiImageHelper.saveWithDPI((BufferedImage)image, outputStream, format, (Integer)imageResolution, 1.0f);
                }
            }
            if (pages.size() > 1 && outputStream instanceof FileOutputStream && !"".equals(name)) {
                if (index <= pages.size()) {
                    if (index >= pages.size()) break;
                    String fs = String.format("%03d", index++ + 1);
                    String fileName = "";
                    fileName = this.getImageFormat() != null ? name + fs + "." + this.getImageFormat().name().toLowerCase() : name + fs + "." + this.getExportFormat().getExtension().toLowerCase();
                    this.exportedFiles.add(new File(fileName));
                    outputStream = new FileOutputStream(fileName);
                }
            } else {
                if (image != null) {
                    image.flush();
                }
                this.closeProgress();
                return;
            }
            if (image == null) continue;
            image.flush();
        }
        this.closeProgress();
    }

    @Override
    public boolean getMultipleFiles() {
        return this.multipleFiles;
    }
}

