/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.export.service;

import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.licenses.StiLicenseKeyValidator;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiPagesCollection;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.service.StiExportService;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiHtml5ExportSettings;
import com.stimulsoft.report.export.tools.StiImageFormat;
import com.stimulsoft.report.export.tools.StiPagesRange;
import com.stimulsoft.report.export.tools.html.StiHtmlTextWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class StiHtml5ExportService
extends StiExportService {
    StiReport report;
    String fileName = "";
    StiImageFormat imageFormat;
    public StiHtmlTextWriter htmlWriter = null;
    float imageQuality = 0.75f;
    float imageResolution = 96.0f;
    Character currentCulture = null;

    @Override
    public StiExportFormat getExportFormat() {
        return StiExportFormat.Html5;
    }

    @Override
    public boolean getMultipleFiles() {
        return false;
    }

    public String getFilter() {
        return StiLocalization.getValue((String)"FileFilters", (String)"HtmlFiles");
    }

    private void renderPage(StiReport report, StiPage page, Integer clipCounter) throws IOException {
        this.htmlWriter.flush();
    }

    private void renderStartDoc(StiPagesCollection pages, Charset encoding) throws IOException {
        this.htmlWriter.write("<!DOCTYPE html>");
        this.htmlWriter.writeLine();
        this.htmlWriter.incIndent();
        this.htmlWriter.writeFullBeginTag("head");
        this.htmlWriter.writeLine();
        this.htmlWriter.incIndent();
        this.htmlWriter.writeFullBeginTag("title");
        this.htmlWriter.writeEndTag("title");
        this.htmlWriter.writeLine();
        this.htmlWriter.writeBeginTag("meta");
        this.htmlWriter.writeAttribute("charset", encoding.name());
        this.htmlWriter.writeEndTag("meta");
        this.htmlWriter.writeLine();
        this.htmlWriter.decIndent();
        this.htmlWriter.writeEndTag("head");
        this.htmlWriter.writeLine();
        this.htmlWriter.writeBeginTag("body");
        this.htmlWriter.writeAttribute("bgcolor", StiColorEnum.LightBlue.color().toHTML());
        this.htmlWriter.writeAttribute("style", "text-align:center;");
        this.htmlWriter.write(">");
        this.htmlWriter.incIndent();
        this.htmlWriter.writeLine();
    }

    private void renderEndDoc() throws IOException {
        this.htmlWriter.decIndent();
        this.htmlWriter.writeEndTag("body");
        this.htmlWriter.decIndent();
        this.htmlWriter.writeLine();
        this.htmlWriter.writeEndTag("html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportHtml(StiReport report, File file, StiHtml5ExportSettings settings) throws IOException {
        StiLicenseKeyValidator.isValidOnJavaFramework(null);
        if (settings == null) {
            throw new IllegalArgumentException("The 'settings' argument cannot be equal in null.");
        }
        StiPagesRange pageRange = settings.getPageRange();
        this.imageFormat = settings.getImageFormat();
        this.imageResolution = settings.getImageResolution();
        this.imageQuality = settings.getImageQuality();
        boolean continuousPages = settings.isContinuousPages();
        StiPagesCollection pages = settings.getPageRange().getSelectedPages(report.getRenderedPages());
        try {
            this.report = report;
            this.renderStartDoc(pages, settings.getEncoding());
            this.htmlWriter.write("<div style=\"FONT-SIZE: 10px; COLOR: red; FONT-FAMILY: Arial\">Stimulsoft Reports - Demo Version</div>");
            this.setStatusString(StiLocalization.getValue((String)"Export", (String)"ExportingCreatingDocument"));
            this.htmlWriter.setIndent(0);
            int clipCounter = 1;
            for (StiPage page : pages) {
                pages.GetPage(page);
                this.invokeExporting(page, pages);
                if (this.isStoped()) {
                    return;
                }
                this.renderPage(report, page, clipCounter);
                if (continuousPages) {
                    this.htmlWriter.write("<br/>");
                }
                this.htmlWriter.writeLine();
            }
            this.renderEndDoc();
            this.htmlWriter.flush();
        }
        finally {
            report = null;
        }
    }

    @Override
    public void export(StiReport report, OutputStream outputStream, StiExportSettings settings) throws StiException {
        throw new UnsupportedOperationException("this export not supported");
    }
}

