/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.enums;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.report.export.service.StiBmpExportService;
import com.stimulsoft.report.export.service.StiCsvExportService;
import com.stimulsoft.report.export.service.StiExcel2007ExportService;
import com.stimulsoft.report.export.service.StiExcelExportService;
import com.stimulsoft.report.export.service.StiExcelXmlExportService;
import com.stimulsoft.report.export.service.StiExportService;
import com.stimulsoft.report.export.service.StiHtmlExportService;
import com.stimulsoft.report.export.service.StiJpegExportService;
import com.stimulsoft.report.export.service.StiOdsExportService;
import com.stimulsoft.report.export.service.StiOdtExportService;
import com.stimulsoft.report.export.service.StiPcxExportService;
import com.stimulsoft.report.export.service.StiPdfExportService;
import com.stimulsoft.report.export.service.StiPngExportService;
import com.stimulsoft.report.export.service.StiPpt2007ExportService;
import com.stimulsoft.report.export.service.StiRtfExportService;
import com.stimulsoft.report.export.service.StiSvgExportService;
import com.stimulsoft.report.export.service.StiSvgzExportService;
import com.stimulsoft.report.export.service.StiSylkExportService;
import com.stimulsoft.report.export.service.StiTxtExportService;
import com.stimulsoft.report.export.service.StiWord2007ExportService;
import com.stimulsoft.report.export.service.StiXmlExportService;
import com.stimulsoft.report.export.service.StiXpsExportService;
import com.stimulsoft.report.export.settings.StiBmpExportSettings;
import com.stimulsoft.report.export.settings.StiCsvExportSettings;
import com.stimulsoft.report.export.settings.StiExcelExportSettings;
import com.stimulsoft.report.export.settings.StiExportSettings;
import com.stimulsoft.report.export.settings.StiHtmlExportSettings;
import com.stimulsoft.report.export.settings.StiJpegExportSettings;
import com.stimulsoft.report.export.settings.StiOdsExportSettings;
import com.stimulsoft.report.export.settings.StiOdtExportSettings;
import com.stimulsoft.report.export.settings.StiPcxExportSettings;
import com.stimulsoft.report.export.settings.StiPdfExportSettings;
import com.stimulsoft.report.export.settings.StiPngExportSettings;
import com.stimulsoft.report.export.settings.StiPowerPointExportSettings;
import com.stimulsoft.report.export.settings.StiRtfExportSettings;
import com.stimulsoft.report.export.settings.StiSvgExportSettings;
import com.stimulsoft.report.export.settings.StiSvgzExportSettings;
import com.stimulsoft.report.export.settings.StiSylkExportSettings;
import com.stimulsoft.report.export.settings.StiTxtExportSettings;
import com.stimulsoft.report.export.settings.StiWordExportSettings;
import com.stimulsoft.report.export.settings.StiXmlExportSettings;
import com.stimulsoft.report.export.settings.StiXpsExportSettings;
import com.stimulsoft.report.export.tools.StiExcelType;
import java.util.HashMap;

public enum StiExportFormat {
    None(0),
    Pdf(1),
    Xps(2),
    HtmlTable(3),
    HtmlSpan(4),
    HtmlDiv(5),
    Rtf(6),
    RtfTable(7),
    RtfFrame(8),
    RtfWinWord(9),
    RtfTabbedText(10),
    Text(11),
    ExcelBiff(12),
    ExcelXml(13),
    Excel(14),
    Excel2007(14),
    Word(15),
    Word2007(15),
    Xml(16),
    Csv(17),
    Dif(18),
    Sylk(19),
    Image(20),
    ImageGif(21),
    ImageBmp(22),
    ImagePng(23),
    ImageTiff(24),
    ImageJpeg(25),
    ImagePcx(26),
    ImageEmf(27),
    ImageSvg(28),
    ImageSvgz(29),
    Mht(30),
    Dbf(31),
    Html(32),
    Ods(33),
    Odt(34),
    Ppt2007(132),
    PowerPoint(35),
    Html5(36),
    Data(37),
    Json(38),
    Document(1000);

    private static HashMap<Integer, StiExportFormat> mappings;
    private int intValue;

    private StiExportFormat(int value) {
        this.intValue = value;
        StiExportFormat.getMappings().put(value, this);
    }

    private static synchronized HashMap<Integer, StiExportFormat> getMappings() {
        if (mappings == null) {
            mappings = new HashMap();
        }
        return mappings;
    }

    public int getValue() {
        return this.intValue;
    }

    public static StiExportFormat forValue(int value) {
        return StiExportFormat.getMappings().get(value);
    }

    public String getFileFilter() {
        String bundle = "";
        switch (this) {
            case Html: 
            case Html5: 
            case HtmlTable: 
            case HtmlDiv: 
            case HtmlSpan: {
                bundle = "HtmlFiles";
                break;
            }
            case ImageBmp: {
                bundle = "BmpFiles";
                break;
            }
            case ImageEmf: {
                bundle = "EmfFiles";
                break;
            }
            case ImageGif: {
                bundle = "GifFiles";
                break;
            }
            case ImageJpeg: {
                bundle = "JpegFiles";
                break;
            }
            case ImagePcx: {
                bundle = "PcxFiles";
                break;
            }
            case ImagePng: {
                bundle = "PngFiles";
                break;
            }
            case ImageSvg: {
                bundle = "SvgFiles";
                break;
            }
            case ImageTiff: {
                bundle = "TiffFiles";
                break;
            }
            case ImageSvgz: {
                bundle = "SvgzFiles";
                break;
            }
            case Text: {
                bundle = "TxtFiles";
                break;
            }
            case Rtf: {
                bundle = "RtfFiles";
                break;
            }
            case Xps: {
                bundle = "XpsFiles";
                break;
            }
            case Csv: {
                bundle = "CsvFiles";
                break;
            }
            case Sylk: {
                bundle = "SylkFiles";
                break;
            }
            case Xml: {
                bundle = "XmlFiles";
                break;
            }
            case Word2007: {
                bundle = "Word2007Files";
            }
            case Word: {
                bundle = "WordFiles";
                break;
            }
            case ExcelXml: {
                bundle = "ExcelXmlFiles";
                break;
            }
            case Excel: {
                bundle = "ExcelFiles";
                break;
            }
            case Excel2007: {
                bundle = "Excel2007Files";
                break;
            }
            case Pdf: {
                bundle = "PdfFiles";
                break;
            }
            case Odt: {
                bundle = "OdtFiles";
                break;
            }
            case Ods: {
                bundle = "OdsFiles";
                break;
            }
            case PowerPoint: {
                bundle = "Ppt2007Files";
            }
        }
        return StiLocalization.getValue((String)"FileFilters", (String)bundle);
    }

    public String getExtension() {
        switch (this) {
            case Html: 
            case Html5: 
            case HtmlTable: 
            case HtmlDiv: 
            case HtmlSpan: {
                return "html";
            }
            case ImageBmp: {
                return "bmp";
            }
            case ImageEmf: {
                return "emf";
            }
            case ImageGif: {
                return "gif";
            }
            case ImageJpeg: {
                return "jpeg";
            }
            case ImagePcx: {
                return "pcx";
            }
            case ImagePng: {
                return "png";
            }
            case ImageSvg: {
                return "svg";
            }
            case ImageTiff: {
                return "tiff";
            }
            case ImageSvgz: {
                return "svgz";
            }
            case Text: {
                return "txt";
            }
            case Rtf: {
                return "rtf";
            }
            case Xps: {
                return "xps";
            }
            case Csv: {
                return "csv";
            }
            case Sylk: {
                return "slk";
            }
            case Xml: {
                return "xml";
            }
            case Word: {
                return "docx";
            }
            case Word2007: {
                return "doc";
            }
            case ExcelXml: 
            case Excel: {
                return "xls";
            }
            case Excel2007: {
                return "xlsx";
            }
            case Pdf: {
                return "pdf";
            }
            case Odt: {
                return "odt";
            }
            case Ods: {
                return "ods";
            }
            case PowerPoint: {
                return "pptx";
            }
        }
        return "";
    }

    public StiExportService getExportService() {
        switch (this) {
            case Html: 
            case HtmlTable: {
                return new StiHtmlExportService();
            }
            case ImageBmp: {
                return new StiBmpExportService();
            }
            case ImageJpeg: {
                return new StiJpegExportService();
            }
            case ImagePng: {
                return new StiPngExportService();
            }
            case ImageSvg: {
                return new StiSvgExportService();
            }
            case ImageSvgz: {
                return new StiSvgzExportService();
            }
            case ImagePcx: {
                return new StiPcxExportService();
            }
            case Text: {
                return new StiTxtExportService();
            }
            case Rtf: 
            case RtfTable: {
                return new StiRtfExportService();
            }
            case Xps: {
                return new StiXpsExportService();
            }
            case Csv: {
                return new StiCsvExportService();
            }
            case Sylk: {
                return new StiSylkExportService();
            }
            case Xml: {
                return new StiXmlExportService();
            }
            case Word: {
                return new StiWord2007ExportService();
            }
            case ExcelXml: {
                return new StiExcelXmlExportService();
            }
            case Excel: {
                return new StiExcel2007ExportService();
            }
            case Pdf: {
                return new StiPdfExportService();
            }
            case ExcelBiff: {
                return new StiExcelExportService();
            }
            case Odt: {
                return new StiOdtExportService();
            }
            case Ods: {
                return new StiOdsExportService();
            }
            case PowerPoint: {
                return new StiPpt2007ExportService();
            }
        }
        throw new IllegalArgumentException((Object)((Object)this) + " not support Export Service");
    }

    public StiExportSettings getDefaultExportSettings() {
        switch (this) {
            case Html: 
            case HtmlTable: {
                return new StiHtmlExportSettings();
            }
            case ImageBmp: {
                return new StiBmpExportSettings();
            }
            case ImageJpeg: {
                return new StiJpegExportSettings();
            }
            case ImagePng: {
                return new StiPngExportSettings();
            }
            case ImageSvg: {
                return new StiSvgExportSettings();
            }
            case ImageSvgz: {
                return new StiSvgzExportSettings();
            }
            case ImagePcx: {
                return new StiPcxExportSettings();
            }
            case Text: {
                return new StiTxtExportSettings();
            }
            case Rtf: 
            case RtfTable: {
                return new StiRtfExportSettings();
            }
            case Xps: {
                return new StiXpsExportSettings();
            }
            case Csv: {
                return new StiCsvExportSettings();
            }
            case PowerPoint: {
                return new StiPowerPointExportSettings();
            }
            case Sylk: {
                return new StiSylkExportSettings();
            }
            case Xml: {
                return new StiXmlExportSettings();
            }
            case Word: {
                return new StiWordExportSettings();
            }
            case ExcelXml: {
                return new StiExcelExportSettings(StiExcelType.ExcelXml);
            }
            case Excel2007: {
                return new StiExcelExportSettings(StiExcelType.Excel2007);
            }
            case ExcelBiff: {
                return new StiExcelExportSettings();
            }
            case Pdf: {
                return new StiPdfExportSettings();
            }
            case Excel: {
                return new StiExcelExportSettings(StiExcelType.Excel2007);
            }
            case Odt: {
                return new StiOdtExportSettings();
            }
            case Ods: {
                return new StiOdsExportSettings();
            }
        }
        throw new IllegalArgumentException((Object)((Object)this) + " not support Export Settings");
    }
}

