/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.parser;

import com.stimulsoft.base.DBNull;
import com.stimulsoft.base.StiTokenType;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiHatchStyle;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.exception.StiParserException;
import com.stimulsoft.base.helper.StiValueHelper;
import com.stimulsoft.base.range.DateTimeRange;
import com.stimulsoft.base.range.Range;
import com.stimulsoft.base.range.TimeSpanRange;
import com.stimulsoft.base.system.StiDateOnly;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.StiGuid;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiTimeOnly;
import com.stimulsoft.base.system.StiTimeSpan;
import com.stimulsoft.base.system.type.ParameterType;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.base.utils.StiConvertHelper;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.lib.enums.StiTypeCode;
import com.stimulsoft.lib.utils.StiTypeConverter;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.Func;
import com.stimulsoft.report.IStiInherited;
import com.stimulsoft.report.StiCustomFunction;
import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiScriptHelper;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiGroupHeaderBand;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.crossTab.StiCrossCell;
import com.stimulsoft.report.crossTab.StiCrossSummary;
import com.stimulsoft.report.dictionary.StiCalcDataColumn;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataRelation;
import com.stimulsoft.report.dictionary.StiDataRow;
import com.stimulsoft.report.dictionary.StiDialogInfoItem;
import com.stimulsoft.report.dictionary.StiUserFunction;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.StiVariablesMap;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.dataSources.StiDataSourceHelper;
import com.stimulsoft.report.dictionary.dataSources.StiDataSourcesCollection;
import com.stimulsoft.report.dictionary.enums.StiVariableInitBy;
import com.stimulsoft.report.dictionary.functions.StiFunction;
import com.stimulsoft.report.dictionary.functions.StiFunctions;
import com.stimulsoft.report.engine.StiParserParameters;
import com.stimulsoft.report.engine.StiVariableHelper;
import com.stimulsoft.report.engine.engineV2.StiEngine;
import com.stimulsoft.report.engine.parser.ParserErrorCode;
import com.stimulsoft.report.engine.parser.StiAsmCommand;
import com.stimulsoft.report.engine.parser.StiCallFunction;
import com.stimulsoft.report.engine.parser.StiParserAsmOperations;
import com.stimulsoft.report.engine.parser.StiParserMethodInfo;
import com.stimulsoft.report.engine.parser.enums.StiAsmCommandType;
import com.stimulsoft.report.engine.parser.enums.StiFunctionType;
import com.stimulsoft.report.engine.parser.enums.StiMethodType;
import com.stimulsoft.report.engine.parser.enums.StiParserDataType;
import com.stimulsoft.report.engine.parser.enums.StiPropertyType;
import com.stimulsoft.report.engine.parser.enums.StiSystemVariableType;
import com.stimulsoft.report.expressions.StiExpression;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Logger;

public class StiParser {
    private static final Logger LOGGER = Logger.getLogger("com.stimulsoft.report.engine.parser.StiParser");
    private static Hashtable<StiFunctionType, List<StiParserMethodInfo>> methodsHash = null;
    private static final StiParserMethodInfo[] methods;
    private static Map<String, Object> constantsList;
    private static Object namespaceObj;
    private static Hashtable<String, Object> namespacesList;
    private StiReport report = null;
    private String inputExpression = "";
    private StiComponent component = null;
    private boolean checkSyntaxMode = false;
    private Object sender;
    private int position = 0;
    private ArrayList<StiToken> tokensList = null;
    private StiToken currentToken = null;
    private int tokenPos = 0;
    private ArrayList<StiAsmCommand> asmList = null;
    private Hashtable<String, String> hashAliases = null;
    private Hashtable<String, Object> componentsList = null;
    private int expressionPosition = 0;
    private HashMap<String, Integer> userFunctionsList = null;
    private StiParserParameters parameters;
    private static String[] errorsList;

    private Hashtable<String, Object> getComponentsList() {
        if (this.componentsList == null) {
            this.componentsList = new Hashtable();
            StiComponentsCollection comps = this.report.getComponents();
            for (StiComponent comp : comps) {
                this.componentsList.put(comp.getName(), comp);
            }
            this.componentsList.put("this", this.report);
        }
        return this.componentsList;
    }

    private void eval_exp() {
        this.tokenPos = 0;
        if (this.tokensList.isEmpty()) {
            this.ThrowError(2);
            return;
        }
        this.eval_exp0();
        if (this.tokenPos <= this.tokensList.size()) {
            this.ThrowError(6);
        }
    }

    private void eval_exp0() {
        this.getToken();
        this.eval_exp01();
    }

    private void eval_exp01() {
        if (this.currentToken.Type == StiTokenType.Variable) {
            StiToken variableToken = this.currentToken;
            this.getToken();
            if (this.currentToken.Type != StiTokenType.Assign) {
                --this.tokenPos;
                this.currentToken = this.tokensList.get(this.tokenPos - 1);
            } else {
                this.getToken();
                this.eval_exp1();
                this.asmList.add(new StiAsmCommand(StiAsmCommandType.CopyToVariable, variableToken.Value));
                return;
            }
        }
        this.eval_exp1();
    }

    private void eval_exp1() {
        this.eval_exp10();
        if (this.currentToken.Type == StiTokenType.Question) {
            if (this.checkSyntaxMode) {
                this.getToken();
                this.eval_exp10();
                if (this.currentToken.Type != StiTokenType.Colon) {
                    this.ThrowError(ParserErrorCode.SyntaxError, this.currentToken);
                }
                this.getToken();
                this.eval_exp10();
                this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushFunction, StiFunctionType.IIF.intValue, 3));
            } else {
                this.getToken();
                StiAsmCommand jump1 = new StiAsmCommand(StiAsmCommandType.JumpFalse, 0, null);
                this.asmList.add(jump1);
                int addr1 = this.asmList.size();
                this.eval_exp10();
                if (this.currentToken.Type != StiTokenType.Colon) {
                    this.ThrowError(ParserErrorCode.SyntaxError, this.currentToken);
                }
                StiAsmCommand jump2 = new StiAsmCommand(StiAsmCommandType.Jump, 0, null);
                this.asmList.add(jump2);
                int addr2 = this.asmList.size();
                this.getToken();
                this.eval_exp10();
                jump1.Parameter1 = addr2 - addr1;
                jump2.Parameter1 = this.asmList.size() - addr2;
            }
        }
    }

    private void eval_exp10() {
        this.eval_exp11();
        while (this.currentToken.Type == StiTokenType.DoubleOr) {
            this.getToken();
            this.eval_exp11();
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.Or2));
        }
    }

    private void eval_exp11() {
        this.eval_exp12();
        while (this.currentToken.Type == StiTokenType.DoubleAnd) {
            this.getToken();
            this.eval_exp12();
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.And2));
        }
    }

    private void eval_exp12() {
        this.eval_exp14();
        if (this.currentToken.Type == StiTokenType.Or) {
            this.getToken();
            this.eval_exp14();
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.Or));
        }
    }

    private void eval_exp14() {
        this.eval_exp15();
        if (this.currentToken.Type == StiTokenType.Xor) {
            this.getToken();
            this.eval_exp15();
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.Xor));
        }
    }

    private void eval_exp15() {
        this.eval_exp16();
        while (this.currentToken.Type == StiTokenType.And) {
            this.getToken();
            this.eval_exp16();
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.And));
        }
    }

    private void eval_exp16() {
        this.eval_exp17();
        if (this.currentToken.Type == StiTokenType.Equal || this.currentToken.Type == StiTokenType.NotEqual) {
            StiAsmCommand command = new StiAsmCommand(StiAsmCommandType.CompareEqual);
            if (this.currentToken.Type == StiTokenType.NotEqual) {
                command.Type = StiAsmCommandType.CompareNotEqual;
            }
            this.getToken();
            this.eval_exp17();
            this.asmList.add(command);
        }
    }

    private void eval_exp17() {
        this.eval_exp18();
        if (this.currentToken.Type == StiTokenType.Left || this.currentToken.Type == StiTokenType.LeftEqual || this.currentToken.Type == StiTokenType.Right || this.currentToken.Type == StiTokenType.RightEqual) {
            StiAsmCommand command = null;
            if (this.currentToken.Type == StiTokenType.Left) {
                command = new StiAsmCommand(StiAsmCommandType.CompareLeft);
            }
            if (this.currentToken.Type == StiTokenType.LeftEqual) {
                command = new StiAsmCommand(StiAsmCommandType.CompareLeftEqual);
            }
            if (this.currentToken.Type == StiTokenType.Right) {
                command = new StiAsmCommand(StiAsmCommandType.CompareRight);
            }
            if (this.currentToken.Type == StiTokenType.RightEqual) {
                command = new StiAsmCommand(StiAsmCommandType.CompareRightEqual);
            }
            this.getToken();
            this.eval_exp18();
            this.asmList.add(command);
        }
    }

    private void eval_exp18() {
        this.eval_exp2();
        if (this.currentToken.Type == StiTokenType.Shl || this.currentToken.Type == StiTokenType.Shr) {
            StiAsmCommand command = new StiAsmCommand(StiAsmCommandType.Shl);
            if (this.currentToken.Type == StiTokenType.Shr) {
                command.Type = StiAsmCommandType.Shr;
            }
            this.getToken();
            this.eval_exp2();
            this.asmList.add(command);
        }
    }

    private void eval_exp2() {
        this.eval_exp3();
        while (this.currentToken.Type == StiTokenType.Plus || this.currentToken.Type == StiTokenType.Minus) {
            StiToken operation = this.currentToken;
            this.getToken();
            this.eval_exp3();
            if (operation.Type == StiTokenType.Minus) {
                this.asmList.add(new StiAsmCommand(StiAsmCommandType.Sub));
                continue;
            }
            if (operation.Type != StiTokenType.Plus) continue;
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.Add));
        }
    }

    private void eval_exp3() {
        this.eval_exp4();
        while (this.currentToken.Type == StiTokenType.Mult || this.currentToken.Type == StiTokenType.Div || this.currentToken.Type == StiTokenType.Percent) {
            StiToken operation = this.currentToken;
            this.getToken();
            this.eval_exp4();
            if (operation.Type == StiTokenType.Mult) {
                this.asmList.add(new StiAsmCommand(StiAsmCommandType.Mult));
            } else if (operation.Type == StiTokenType.Div) {
                this.asmList.add(new StiAsmCommand(StiAsmCommandType.Div));
            }
            if (operation.Type != StiTokenType.Percent) continue;
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.Mod));
        }
    }

    private void eval_exp4() {
        this.eval_exp5();
        if (this.currentToken.Type == StiTokenType.Xor) {
            this.getToken();
            this.eval_exp4();
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.Power));
        }
    }

    private void eval_exp5() {
        StiAsmCommand command = null;
        if (this.currentToken.Type == StiTokenType.Plus || this.currentToken.Type == StiTokenType.Minus || this.currentToken.Type == StiTokenType.Not) {
            if (this.currentToken.Type == StiTokenType.Minus) {
                command = new StiAsmCommand(StiAsmCommandType.Neg);
            }
            if (this.currentToken.Type == StiTokenType.Not) {
                command = new StiAsmCommand(StiAsmCommandType.Not);
            }
            this.getToken();
        }
        this.eval_exp6();
        if (command != null) {
            this.asmList.add(command);
        }
    }

    private void eval_exp6() {
        if (this.currentToken.Type == StiTokenType.LParenthesis) {
            this.getToken();
            if (this.currentToken.Type == StiTokenType.Cast) {
                StiTypeCode typeCode = (StiTypeCode)StiTypeCode.getTypesList().get(this.currentToken.Value);
                this.getToken();
                if (this.currentToken.Type != StiTokenType.RParenthesis) {
                    this.ThrowError(8);
                }
                this.getToken();
                this.eval_exp5();
                this.asmList.add(new StiAsmCommand(StiAsmCommandType.Cast, typeCode));
            } else {
                this.eval_exp1();
                if (this.currentToken.Type != StiTokenType.RParenthesis) {
                    this.ThrowError(8);
                }
                this.getToken();
                if (this.currentToken.Type == StiTokenType.Dot) {
                    this.getToken();
                    this.eval_exp7();
                }
                if (this.currentToken.Type == StiTokenType.LBracket) {
                    this.eval_exp62();
                }
            }
        } else {
            this.eval_exp62();
        }
    }

    private void eval_exp62() {
        if (this.currentToken.Type == StiTokenType.LBracket) {
            int argsCount;
            for (argsCount = 0; argsCount == 0 || this.currentToken.Type == StiTokenType.Comma; ++argsCount) {
                this.getToken();
                this.eval_exp1();
            }
            if (this.currentToken.Type != StiTokenType.RBracket) {
                this.ThrowError(0, this.currentToken);
            }
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushArrayElement, argsCount + 1));
            this.getToken();
            if (this.currentToken.Type == StiTokenType.LBracket) {
                this.eval_exp62();
            }
            if (this.currentToken.Type == StiTokenType.Dot) {
                this.getToken();
                this.eval_exp7();
            }
        } else {
            this.eval_exp7();
        }
    }

    private void eval_exp7() {
        this.atom();
        if (this.currentToken.Type == StiTokenType.Dot) {
            this.getToken();
            this.eval_exp7();
        }
        if (this.currentToken.Type == StiTokenType.LBracket) {
            this.eval_exp62();
        }
    }

    private void atom() {
        if (this.currentToken.Type == StiTokenType.Variable) {
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushVariable, this.currentToken.Value));
            this.getToken();
            return;
        }
        if (this.currentToken.Type == StiTokenType.SystemVariable) {
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushSystemVariable, StiSystemVariableType.getSystemVariablesList().get(this.currentToken.Value)));
            this.getToken();
            return;
        }
        if (this.currentToken.Type == StiTokenType.Function) {
            Integer funcInt;
            StiToken function = this.currentToken;
            StiFunctionType functionType = StiFunctionType.getFunctionsList().get(function.Value);
            Integer n = funcInt = functionType != null ? Integer.valueOf(functionType.intValue) : null;
            if (functionType == null && this.getUserFunctionsList().containsKey(function.Value)) {
                funcInt = this.getUserFunctionsList().get(function.Value);
            }
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushFunction, funcInt, this.get_args_count(funcInt), null, this.expressionPosition + function.Position, function.Length));
            this.getToken();
            return;
        }
        if (this.currentToken.Type == StiTokenType.Method) {
            StiToken method = this.currentToken;
            StiMethodType methodType = StiMethodType.getMethodsList().get(method.Value);
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushMethod, (Object)methodType, this.get_args_countForMetod(methodType) + 1));
            this.getToken();
            return;
        }
        if (this.currentToken.Type == StiTokenType.CustomFunction) {
            StiToken function = this.currentToken;
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushFunction, StiFunctionType.CustomFunction.intValue, this.get_args_count(StiFunctionType.CustomFunction.intValue), function.Value));
            this.getToken();
            return;
        }
        if (this.currentToken.Type == StiTokenType.Property) {
            StiToken function = this.currentToken;
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushProperty, (Object)StiPropertyType.getPropertiesList().get(function.Value)));
            this.getToken();
            return;
        }
        if (this.currentToken.Type == StiTokenType.DataSourceField) {
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushDataSourceField, this.currentToken.Value, this.currentToken.ValueObject));
            this.getToken();
            return;
        }
        if (this.currentToken.Type == StiTokenType.BusinessObjectField) {
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushBusinessObjectField, this.currentToken.Value));
            this.getToken();
            return;
        }
        if (this.currentToken.Type == StiTokenType.Component) {
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushComponent, this.getComponentsList().get(this.currentToken.Value), null, null, this.expressionPosition + this.currentToken.Position, this.currentToken.Length));
            this.getToken();
            return;
        }
        if (this.currentToken.Type == StiTokenType.Number) {
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushValue, this.currentToken.ValueObject));
            this.getToken();
            return;
        }
        if (this.currentToken.Type == StiTokenType.String) {
            this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushValue, this.currentToken.ValueObject));
            this.getToken();
            return;
        }
        if (this.currentToken.Type == StiTokenType.Empty) {
            this.ThrowError(4);
        }
        this.ThrowError(0, this.currentToken, "Token type: " + this.currentToken.Type + "; value: " + this.currentToken.Value + "; valueObject: " + this.currentToken.ValueObject, "Input expression: " + this.inputExpression, "Position: " + this.position, "Token position" + this.tokenPos);
    }

    private int get_args_count(Integer intValue) {
        ArrayList<StiAsmCommand> arg0;
        ArrayList<StiAsmCommand> newCommand;
        IStiInherited aggregateComponent;
        int posFunc = -1;
        if (this.currentToken != null) {
            posFunc = this.currentToken.Position;
        }
        ArrayList<ArrayList<StiAsmCommand>> args = this.get_args();
        StiFunctionType func = StiFunctionType.forValue(intValue);
        if (func == StiFunctionType.Count && args.isEmpty() || (intValue >= StiFunctionType.CountDistinct.intValue && intValue <= StiFunctionType.Last.intValue || intValue >= StiFunctionType.cCountDistinct.intValue && intValue <= StiFunctionType.cLast.intValue || intValue >= StiFunctionType.rCountDistinct.intValue && intValue <= StiFunctionType.rLast.intValue) && args.size() == 1 || func == StiFunctionType.iCount && args.size() == 1 || (intValue >= StiFunctionType.iCountDistinct.intValue && intValue <= StiFunctionType.iLast.intValue || intValue >= StiFunctionType.ciCountDistinct.intValue && intValue <= StiFunctionType.ciLast.intValue || intValue >= StiFunctionType.riCountDistinct.intValue && intValue <= StiFunctionType.riLast.intValue) && args.size() == 2) {
            aggregateComponent = this.component.GetGroupHeaderBand();
            if (aggregateComponent == null) {
                aggregateComponent = this.component.GetDataBand();
            }
            if (aggregateComponent == null && args.size() > 0 && args.get(0) != null && args.get(0).size() > 0) {
                try {
                    String dsName = null;
                    for (StiAsmCommand stiAsmCommand : args.get(0)) {
                        if (stiAsmCommand.Type != StiAsmCommandType.PushDataSourceField) continue;
                        String dsName2 = (String)((List)stiAsmCommand.Parameter2).get(0);
                        if (dsName == null) {
                            dsName = dsName2;
                            continue;
                        }
                        if (Objects.equals(dsName, dsName2)) continue;
                        dsName = null;
                        break;
                    }
                    if (!StiValidationUtil.isNullOrWhiteSpace(dsName)) {
                        aggregateComponent = this.report.getDictionary().getDataSources().get(dsName);
                    }
                }
                catch (Exception dsName) {
                    // empty catch block
                }
            }
            newCommand = new ArrayList<StiAsmCommand>();
            newCommand.add(new StiAsmCommand(StiAsmCommandType.PushComponent, aggregateComponent, null, null, this.expressionPosition + posFunc, -1));
            args.add(0, newCommand);
        }
        if ((intValue >= StiFunctionType.Count.intValue && intValue <= StiFunctionType.Last.intValue || intValue >= StiFunctionType.cCount.intValue && intValue <= StiFunctionType.cLast.intValue || intValue >= StiFunctionType.rCount.intValue && intValue <= StiFunctionType.rLast.intValue || intValue == StiFunctionType.cCount.intValue || intValue >= StiFunctionType.iCount.intValue && intValue <= StiFunctionType.iLast.intValue || intValue >= StiFunctionType.ciCount.intValue && intValue <= StiFunctionType.ciLast.intValue || intValue >= StiFunctionType.riCount.intValue && intValue <= StiFunctionType.riLast.intValue || intValue == StiFunctionType.ciCount.intValue) && (aggregateComponent = this.component.GetGroupHeaderBand()) != null) {
            newCommand = new ArrayList();
            newCommand.add(new StiAsmCommand(StiAsmCommandType.PushComponent, aggregateComponent));
            args.set(0, newCommand);
        }
        if ((intValue >= StiFunctionType.cCount.intValue && intValue <= StiFunctionType.cLast.intValue || intValue >= StiFunctionType.rCount.intValue && intValue <= StiFunctionType.rLast.intValue || intValue >= StiFunctionType.ciCount.intValue && intValue <= StiFunctionType.ciLast.intValue || intValue >= StiFunctionType.riCount.intValue && intValue <= StiFunctionType.riLast.intValue) && args.size() > 0 && (arg0 = args.get(0)) != null && arg0.size() > 0 && arg0.get((int)0).Type == StiAsmCommandType.PushComponent && arg0.get((int)0).Parameter1 instanceof StiBand) {
            String dataBandName = ((StiBand)(arg0.get((int)0).Parameter1 instanceof StiBand ? arg0.get((int)0).Parameter1 : null)).getName();
            if (this.report.DataBandsUsedInPageTotals == null) {
                this.report.DataBandsUsedInPageTotals = new String[1];
                this.report.DataBandsUsedInPageTotals[0] = dataBandName;
            } else {
                boolean finded3 = false;
                for (String str : this.report.DataBandsUsedInPageTotals) {
                    if (!dataBandName.equals(str)) continue;
                    finded3 = true;
                    break;
                }
                if (!finded3) {
                    String[] stringArray = new String[this.report.DataBandsUsedInPageTotals.length + 1];
                    for (int indexStr = 0; indexStr < this.report.DataBandsUsedInPageTotals.length; ++indexStr) {
                        stringArray[indexStr] = this.report.DataBandsUsedInPageTotals[indexStr];
                    }
                    stringArray[this.report.DataBandsUsedInPageTotals.length] = dataBandName;
                    this.report.DataBandsUsedInPageTotals = stringArray;
                }
            }
        }
        int bitsValue = 0;
        if (func != null && StiFunctionType.getParametersList().containsKey((Object)func)) {
            bitsValue = StiFunctionType.getParametersList().get((Object)func);
        }
        int bitsCounter = 1;
        for (ArrayList arrayList : args) {
            if ((bitsValue & bitsCounter) > 0) {
                this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushValue, arrayList));
            } else {
                this.asmList.addAll(arrayList);
            }
            bitsCounter <<= 1;
        }
        return args.size();
    }

    private int get_args_countForMetod(StiMethodType methodType) {
        ArrayList<ArrayList<StiAsmCommand>> args = this.get_args();
        int bitsValue = 0;
        if (StiFunctionType.getParametersList().contains((Object)methodType)) {
            bitsValue = StiFunctionType.getParametersList().get((Object)methodType);
        }
        int bitsCounter = 1;
        for (ArrayList<StiAsmCommand> arg : args) {
            if ((bitsValue & bitsCounter) > 0) {
                this.asmList.add(new StiAsmCommand(StiAsmCommandType.PushValue, arg));
            } else {
                this.asmList.addAll(arg);
            }
            bitsCounter <<= 1;
        }
        return args.size();
    }

    private Object call_arrayElement(ArrayList argsList) {
        Object baseValue = argsList.get(0);
        if (argsList.size() < 2) {
            this.ThrowError(11, "get_ArrayElement", argsList.size() - 1);
        }
        if (baseValue instanceof String) {
            if (argsList.size() != 2) {
                this.ThrowError(11, "String.get_Item", argsList.size() - 1);
            }
            int index = Integer.parseInt(argsList.get(1).toString());
            return Character.valueOf(((String)baseValue).charAt(index));
        }
        if (baseValue instanceof StiDataSource) {
            Object result = ((StiDataSource)baseValue).GetData((String)argsList.get(1));
            return result != null ? result : DBNull.Value;
        }
        try {
            Class[] parameterTypes = new Class[argsList.size() - 1];
            Object[] args = new Object[argsList.size() - 1];
            for (int i = 1; i < argsList.size(); ++i) {
                parameterTypes[i - 1] = argsList.get(i).getClass();
                args[i - 1] = argsList.get(i);
            }
            Method method = baseValue.getClass().getMethod("get", parameterTypes);
            return method.invoke(baseValue, args);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ArrayList<ArrayList<StiAsmCommand>> get_args() {
        ArrayList<ArrayList<StiAsmCommand>> args = new ArrayList<ArrayList<StiAsmCommand>>();
        this.getToken();
        if (this.currentToken.Type != StiTokenType.LParenthesis) {
            this.ThrowError(7);
        }
        this.getToken();
        if (this.currentToken.Type == StiTokenType.RParenthesis) {
            return args;
        }
        --this.tokenPos;
        this.currentToken = this.tokensList.get(this.tokenPos - 1);
        ArrayList<StiAsmCommand> tempAsmList = this.asmList;
        do {
            this.asmList = new ArrayList();
            this.eval_exp0();
            args.add(this.asmList);
        } while (this.currentToken.Type == StiTokenType.Comma);
        this.asmList = tempAsmList;
        if (this.currentToken.Type != StiTokenType.RParenthesis) {
            this.ThrowError(8);
        }
        return args;
    }

    private void getToken() {
        this.currentToken = this.tokenPos < this.tokensList.size() ? this.tokensList.get(this.tokenPos) : new StiToken();
        ++this.tokenPos;
    }

    private void ThrowError(int code) {
        this.ThrowError(code, null, "", "", "", "");
    }

    private void ThrowError(int code, String message1) {
        this.ThrowError(code, null, message1, "", "", "");
    }

    private void ThrowError(int code, String message1, String message2) {
        this.ThrowError(code, null, message1, message2, "", "");
    }

    private void ThrowError(int code, String message1, String message2, String message3) {
        this.ThrowError(code, null, message1, message2, message3, "");
    }

    private void ThrowError(int code, String message1, String message2, String message3, String message4) {
        this.ThrowError(code, null, message1, message2, message3, message4);
    }

    private void ThrowError(int code, StiToken token) {
        this.ThrowError(code, token, "", "", "", "");
    }

    private void ThrowError(int code, StiToken token, String message1) {
        this.ThrowError(code, token, message1, "", "", "");
    }

    private void ThrowError(int code, StiToken token, String message1, String message2) {
        this.ThrowError(code, token, message1, message2, "", "");
    }

    private void ThrowError(int code, StiToken token, String message1, String message2, String message3) {
        this.ThrowError(code, token, message1, message2, message3, "");
    }

    private void ThrowError(int code, StiToken token, String message1, String message2, String message3, String message4) {
        String errorMessage = "Parser error: Unknown error";
        if (code < errorsList.length) {
            errorMessage = "Parser error: " + String.format(errorsList[code], message1, message2, message3, message4);
        }
        errorMessage = errorMessage + "\nInputExpression: " + this.inputExpression + " position: " + this.position;
        StiParserException exception = new StiParserException(errorMessage);
        exception.BaseMessage = errorMessage;
        if (token != null) {
            exception.Position = this.expressionPosition + token.Position;
            exception.Length = token.Length;
        }
        if (this.report != null) {
            this.report.WriteToReportRenderingMessages(errorMessage + (token != null ? "Position: " + exception.Position + " Length: " + token.Length : ""));
        }
        throw exception;
    }

    private StiToken getNextLexem() {
        int pos2;
        while (this.position < this.inputExpression.length() && this.isWhiteSpace(this.inputExpression.charAt(this.position))) {
            ++this.position;
        }
        if (this.position >= this.inputExpression.length()) {
            return null;
        }
        StiToken token = null;
        char ch = this.inputExpression.charAt(this.position);
        if (Character.isLetter(ch) || ch == '_') {
            int pos22;
            for (pos22 = this.position + 1; pos22 < this.inputExpression.length() && (Character.isLetterOrDigit(this.inputExpression.charAt(pos22)) || this.inputExpression.charAt(pos22) == '_'); ++pos22) {
            }
            token = new StiToken();
            token.Value = this.inputExpression.substring(this.position, pos22);
            token.Type = StiTokenType.Identifier;
            token.Position = this.position;
            token.Length = pos22 - this.position;
            this.position = pos22;
            String alias = token.Value;
            if (token.Position > 0 && this.inputExpression.charAt(token.Position - 1) == '.') {
                alias = "." + alias;
            }
            if (this.hashAliases.containsKey(alias)) {
                token.Value = this.hashAliases.get(alias);
            }
            return token;
        }
        if (Character.isDigit(ch)) {
            token = new StiToken();
            token.Type = StiTokenType.Number;
            token.Position = this.position;
            token.ValueObject = this.scanNumber();
            token.Length = this.position - token.Position;
            return token;
        }
        if (ch == '\"' || ch == '@' && this.position < this.inputExpression.length() - 1 && this.inputExpression.charAt(this.position + 1) == '\"') {
            int pos23;
            boolean needReplaceBackslash = true;
            if (ch == '@') {
                needReplaceBackslash = false;
                ++this.position;
            }
            ++this.position;
            for (pos23 = this.position; pos23 < this.inputExpression.length(); ++pos23) {
                if (needReplaceBackslash) {
                    if (this.inputExpression.charAt(pos23) == '\"') break;
                    if (this.inputExpression.charAt(pos23) != '\\') continue;
                    ++pos23;
                    continue;
                }
                if (this.inputExpression.charAt(pos23) != '\"') continue;
                if (pos23 + 1 >= this.inputExpression.length() || this.inputExpression.charAt(pos23 + 1) != '\"') break;
                ++pos23;
            }
            token = new StiToken();
            token.Type = StiTokenType.String;
            String st = this.inputExpression.substring(this.position, pos23);
            token.ValueObject = needReplaceBackslash ? StiParser.replaceBackslash(st) : StiParser.replaceQuotationMark(st);
            token.Position = this.position - 1;
            this.position = pos23 + 1;
            token.Length = this.position - token.Position;
            return token;
        }
        if (ch == '[' && (pos2 = this.inputExpression.indexOf(93, this.position)) != -1) {
            String alias = this.inputExpression.substring(this.position, ++pos2);
            if (this.position > 0 && this.inputExpression.charAt(this.position - 1) == '.') {
                alias = "." + alias;
            }
            if (this.hashAliases.containsKey(alias)) {
                token = new StiToken();
                token.Value = this.hashAliases.get(alias);
                token.Type = StiTokenType.Identifier;
                token.Position = this.position;
                token.Length = pos2 - this.position;
                this.position = pos2;
                return token;
            }
        }
        int tPos = this.position++;
        int ch2 = 32;
        if (this.position < this.inputExpression.length()) {
            ch2 = this.inputExpression.charAt(this.position);
        }
        switch (ch) {
            case '.': {
                return new StiToken(StiTokenType.Dot, tPos, 1);
            }
            case '(': {
                return new StiToken(StiTokenType.LParenthesis, tPos, 1);
            }
            case ')': {
                return new StiToken(StiTokenType.RParenthesis, tPos, 1);
            }
            case '[': {
                return new StiToken(StiTokenType.LBracket, tPos, 1);
            }
            case ']': {
                return new StiToken(StiTokenType.RBracket, tPos, 1);
            }
            case '+': {
                return new StiToken(StiTokenType.Plus, tPos, 1);
            }
            case '-': {
                return new StiToken(StiTokenType.Minus, tPos, 1);
            }
            case '*': {
                return new StiToken(StiTokenType.Mult, tPos, 1);
            }
            case '/': {
                return new StiToken(StiTokenType.Div, tPos, 1);
            }
            case '%': {
                return new StiToken(StiTokenType.Percent, tPos, 1);
            }
            case '^': {
                return new StiToken(StiTokenType.Xor, tPos, 1);
            }
            case ',': {
                return new StiToken(StiTokenType.Comma, tPos, 1);
            }
            case ':': {
                return new StiToken(StiTokenType.Colon, tPos, 1);
            }
            case ';': {
                return new StiToken(StiTokenType.SemiColon, tPos, 1);
            }
            case '?': {
                return new StiToken(StiTokenType.Question, tPos, 1);
            }
            case '|': {
                if (ch2 == 124) {
                    ++this.position;
                    return new StiToken(StiTokenType.DoubleOr, tPos, 2);
                }
                return new StiToken(StiTokenType.Or, tPos, 1);
            }
            case '&': {
                if (ch2 == 38) {
                    ++this.position;
                    return new StiToken(StiTokenType.DoubleAnd, tPos, 2);
                }
                return new StiToken(StiTokenType.And, tPos, 1);
            }
            case '!': {
                if (ch2 == 61) {
                    ++this.position;
                    return new StiToken(StiTokenType.NotEqual, tPos, 2);
                }
                return new StiToken(StiTokenType.Not, tPos, 1);
            }
            case '=': {
                if (ch2 == 61) {
                    ++this.position;
                    return new StiToken(StiTokenType.Equal, tPos, 2);
                }
                return new StiToken(StiTokenType.Assign, tPos, 1);
            }
            case '<': {
                if (ch2 == 60) {
                    ++this.position;
                    return new StiToken(StiTokenType.Shl, tPos, 2);
                }
                if (ch2 == 61) {
                    ++this.position;
                    return new StiToken(StiTokenType.LeftEqual, tPos, 2);
                }
                return new StiToken(StiTokenType.Left, tPos, 1);
            }
            case '>': {
                if (ch2 == 62) {
                    ++this.position;
                    return new StiToken(StiTokenType.Shr, tPos, 2);
                }
                if (ch2 == 61) {
                    ++this.position;
                    return new StiToken(StiTokenType.RightEqual, tPos, 2);
                }
                return new StiToken(StiTokenType.Right, tPos, 1);
            }
        }
        token = new StiToken(StiTokenType.Unknown);
        token.ValueObject = Character.valueOf(ch);
        token.Position = tPos;
        token.Length = 1;
        return token;
    }

    private static boolean isValidName(String name) {
        if (StiValidationUtil.isNullOrEmpty((String)name) || !Character.isLetter(name.charAt(0)) && name.charAt(0) != '_') {
            return false;
        }
        for (int pos = 0; pos < name.length(); ++pos) {
            if (Character.isLetterOrDigit(name.charAt(pos)) || name.charAt(pos) == '_') continue;
            return false;
        }
        return true;
    }

    private static String getCorrectedAlias(String alias) {
        if (StiParser.isValidName(alias)) {
            return alias;
        }
        return String.format("[%s]", alias);
    }

    private void buildAliases() {
        if (this.hashAliases != null) {
            return;
        }
        this.hashAliases = new Hashtable();
        Iterator iterator = this.report.getDictionary().getDataSources().iterator();
        while (iterator.hasNext()) {
            StiDataSource dataSource = (StiDataSource)iterator.next();
            String dataSourceName = dataSource.getName();
            String dataSourceAlias = StiParser.getCorrectedAlias(dataSource.getAlias());
            if (dataSourceAlias != dataSourceName) {
                this.hashAliases.put(dataSourceAlias, dataSourceName);
            }
            Iterator iterator2 = dataSource.getColumns().iterator();
            while (iterator2.hasNext()) {
                StiDataColumn dataColumn = (StiDataColumn)iterator2.next();
                String dataColumnName = dataColumn.getName();
                String dataColumnAlias = StiParser.getCorrectedAlias(dataColumn.getAlias());
                if (StiValidationUtil.equals((Object)dataColumnAlias, (Object)dataColumnName)) continue;
                this.hashAliases.put("." + dataColumnAlias, dataColumnName);
            }
        }
        for (StiDataRelation dataRelation : this.report.getDictionary().getRelations()) {
            String dataRelationName = dataRelation.getName();
            String dataRelationAlias = StiParser.getCorrectedAlias(dataRelation.getAlias());
            if (StiValidationUtil.equals((Object)dataRelationAlias, (Object)dataRelationName)) continue;
            this.hashAliases.put("." + dataRelationAlias, dataRelationName);
        }
        iterator = this.report.getDictionary().getVariables().iterator();
        while (iterator.hasNext()) {
            StiVariable variable = (StiVariable)iterator.next();
            String variableName = variable.getName();
            String variableAlias = StiParser.getCorrectedAlias(variable.getAlias());
            if (StiValidationUtil.equals((Object)variableAlias, (Object)variableName)) continue;
            this.hashAliases.put(variableAlias, variableName);
        }
    }

    public final Object scanNumber() {
        Object result;
        block12: {
            StiTypeCode typecode = StiTypeCode.Int32;
            int posBegin = this.position;
            int posBeginAll = this.position;
            while (this.position != this.inputExpression.length() && Character.isDigit(this.inputExpression.charAt(this.position))) {
                ++this.position;
            }
            if (this.position != this.inputExpression.length() && this.inputExpression.charAt(this.position) == '.' && this.position + 1 != this.inputExpression.length() && Character.isDigit(this.inputExpression.charAt(this.position + 1))) {
                ++this.position;
                while (this.position != this.inputExpression.length() && Character.isDigit(this.inputExpression.charAt(this.position))) {
                    ++this.position;
                }
                typecode = StiTypeCode.Double;
            }
            String nm = this.inputExpression.substring(posBegin, this.position);
            nm = nm.replace('.', StiConvertHelper.DECIMAL_SEPARATOR);
            if (this.position != this.inputExpression.length() && Character.isLetter(this.inputExpression.charAt(this.position))) {
                posBegin = this.position;
                while (this.position != this.inputExpression.length() && Character.isLetter(this.inputExpression.charAt(this.position))) {
                    ++this.position;
                }
                String postfix = this.inputExpression.substring(posBegin, this.position).toLowerCase();
                if (postfix.equals("f")) {
                    typecode = StiTypeCode.Single;
                }
                if (postfix.equals("d")) {
                    typecode = StiTypeCode.Double;
                }
                if (postfix.equals("m")) {
                    typecode = StiTypeCode.Decimal;
                }
                if (postfix.equals("l")) {
                    typecode = StiTypeCode.Int64;
                }
                if (postfix.equals("u") || postfix.equals("ul") || postfix.equals("lu")) {
                    typecode = StiTypeCode.UInt64;
                }
            }
            result = null;
            try {
                result = StiTypeConverter.changeType((String)nm, (StiTypeCode)typecode);
            }
            catch (Exception e) {
                if (typecode != StiTypeCode.Int32 && typecode != StiTypeCode.Int64 && typecode != StiTypeCode.UInt32 && typecode != StiTypeCode.UInt64) break block12;
                this.ThrowError(1, new StiToken(StiTokenType.Number, posBeginAll, this.position - posBeginAll));
            }
        }
        return result;
    }

    private ArrayList<StiToken> postProcessTokensList(ArrayList<StiToken> tokensList) {
        ArrayList<StiToken> newList = new ArrayList<StiToken>();
        this.tokenPos = 0;
        while (this.tokenPos < tokensList.size()) {
            StiToken token = tokensList.get(this.tokenPos);
            ++this.tokenPos;
            if (token.Type == StiTokenType.Identifier) {
                String oldTokenValue;
                StiDataSourcesCollection dataSources;
                StiBusinessObject bos = this.report.getDictionary().getBusinessObjects().get(token.Value);
                String stNameSpace = null;
                if (namespacesList.containsKey(token.Value)) {
                    if (this.tokenPos + 1 >= tokensList.size()) {
                        LOGGER.severe(this.inputExpression);
                        this.ThrowError(4, token);
                    }
                    if (tokensList.get((int)this.tokenPos).Type != StiTokenType.Dot) {
                        LOGGER.severe(this.inputExpression);
                        this.ThrowError(0, token, token.Value);
                    }
                    stNameSpace = token.Value + ".";
                    token = tokensList.get(this.tokenPos + 1);
                    this.tokenPos += 2;
                    while (namespacesList.containsKey(stNameSpace + tokensList.get((int)(this.tokenPos - 1)).Value)) {
                        if (this.tokenPos + 1 >= tokensList.size()) {
                            LOGGER.severe(this.inputExpression);
                            this.ThrowError(4);
                        }
                        if (tokensList.get((int)this.tokenPos).Type != StiTokenType.Dot) {
                            LOGGER.severe(this.inputExpression);
                            this.ThrowError(0, token, token.Value);
                        }
                        stNameSpace = stNameSpace + token.Value + ".";
                        token = tokensList.get(this.tokenPos + 1);
                        this.tokenPos += 2;
                    }
                }
                if ((dataSources = this.report.getDictionary().getDataSources()).exist(token.Value)) {
                    StiDataSource ds = dataSources.get(token.Value);
                    StringBuilder fieldPath = new StringBuilder(StiNameValidator.CorrectName(token.Value));
                    ArrayList<String> fieldList = new ArrayList<String>();
                    fieldList.add(StiNameValidator.CorrectName(token.Value));
                    while (this.tokenPos + 1 < tokensList.size() && tokensList.get((int)this.tokenPos).Type == StiTokenType.Dot) {
                        token = tokensList.get(this.tokenPos + 1);
                        String nextName = StiNameValidator.CorrectName(token.Value);
                        StiDataRelation dr = this.GetDataRelationByName(nextName, ds);
                        if (dr != null) {
                            ds = dr.getParentSource();
                            this.tokenPos += 2;
                            fieldPath.append(".");
                            fieldPath.append(dr.getNameInSource());
                            fieldList.add(dr.getNameInSource());
                            continue;
                        }
                        StiDataColumn dc = this.getDataColumnByName(nextName, ds);
                        if (dc != null) {
                            this.tokenPos += 2;
                            fieldPath.append(".");
                            fieldPath.append(nextName);
                            fieldList.add(dc.getName());
                            break;
                        }
                        token = tokensList.get(this.tokenPos - 1);
                        break;
                    }
                    token.Type = StiTokenType.DataSourceField;
                    token.Value = fieldPath.toString();
                    token.ValueObject = fieldList;
                } else if (bos != null) {
                    StringBuilder fieldPath = new StringBuilder(token.Value);
                    while (this.tokenPos + 1 < tokensList.size() && tokensList.get((int)this.tokenPos).Type == StiTokenType.Dot) {
                        token = tokensList.get(this.tokenPos + 1);
                        String nextName = token.Value;
                        if (bos.getColumns().contains(nextName)) {
                            this.tokenPos += 2;
                            fieldPath.append(".");
                            fieldPath.append(nextName);
                            break;
                        }
                        if ((bos = bos.getBusinessObjects().get(nextName)) == null) break;
                        this.tokenPos += 2;
                        fieldPath.append(".");
                        fieldPath.append(bos.getName());
                    }
                    token.Type = StiTokenType.BusinessObjectField;
                    token.Value = fieldPath.toString();
                } else if (newList.size() > 0 && newList.get((int)(newList.size() - 1)).Type == StiTokenType.Dot) {
                    if (StiMethodType.getMethodsList().containsKey(token.Value)) {
                        token.Type = StiTokenType.Method;
                    } else if (StiPropertyType.getPropertiesList().containsKey(token.Value)) {
                        token.Type = StiTokenType.Property;
                    } else {
                        this.ThrowError(9, token, token.Value);
                    }
                } else if (StiTypeCode.getTypesList().containsKey(token.Value)) {
                    token.Type = StiTokenType.Cast;
                    if (this.tokenPos + 1 < tokensList.size() && tokensList.get((int)this.tokenPos).Type == StiTokenType.Dot) {
                        String tempName = token.Value + "." + tokensList.get((int)(this.tokenPos + 1)).Value;
                        if (StiFunctionType.getFunctionsList().containsKey(tempName)) {
                            token.Type = StiTokenType.Function;
                            token.Value = tempName;
                            this.tokenPos += 2;
                        }
                        if (StiSystemVariableType.getSystemVariablesList().containsKey(tempName)) {
                            token.Type = StiTokenType.SystemVariable;
                            token.Value = tempName;
                            this.tokenPos += 2;
                        }
                        if (constantsList.containsKey(tempName)) {
                            token.Type = StiTokenType.Number;
                            token.ValueObject = constantsList.get(tempName);
                            token.Value = tempName;
                            this.tokenPos += 2;
                        }
                    }
                } else if (this.getComponentsList().containsKey(token.Value)) {
                    StiComponent comp;
                    token.Type = StiTokenType.Component;
                    if (this.tokenPos + 1 < tokensList.size() && tokensList.get((int)this.tokenPos).Type == StiTokenType.Colon && this.getComponentsList().containsKey(tokensList.get((int)(this.tokenPos + 1)).Value) && (comp = (StiComponent)this.getComponentsList().get(tokensList.get((int)(this.tokenPos + 1)).Value)) != null && comp instanceof StiDataBand) {
                        token.Value = ((StiDataBand)(comp instanceof StiDataBand ? comp : null)).getDataSourceName();
                        token.Type = StiTokenType.DataSourceField;
                        this.tokenPos += 2;
                    }
                } else if (StiFunctionType.getFunctionsList().containsKey(token.Value)) {
                    if (StiFunctionType.getFunctionsList().get(token.Value) == StiFunctionType.TotalsNameSpace) {
                        if (this.tokenPos + 1 >= tokensList.size()) {
                            this.ThrowError(4);
                        }
                        token.Value = token.Value + "." + tokensList.get((int)(this.tokenPos + 1)).Value;
                        this.tokenPos += 2;
                        if (!StiFunctionType.getFunctionsList().containsKey(token.Value)) {
                            this.ThrowError(11, token, token.Value);
                        }
                    }
                    token.Type = StiTokenType.Function;
                } else if (this.getUserFunctionsList().containsKey(token.Value)) {
                    token.Type = StiTokenType.Function;
                } else if (this.report.getDictionary().getVariables().contains(token.Value) || this.report.getVariables() != null && this.report.getVariables().containsKey(token.Value)) {
                    if (this.tokenPos + 1 < tokensList.size() && tokensList.get((int)this.tokenPos).Type == StiTokenType.Dot && "Label".equals(tokensList.get((int)(this.tokenPos + 1)).Value)) {
                        token.Type = StiTokenType.String;
                        token.ValueObject = token.Value;
                        StiToken token2 = new StiToken(StiTokenType.Function, token.Position, token.Length + 6);
                        token2.Value = "GetLabel";
                        newList.add(token2);
                        newList.add(new StiToken(StiTokenType.LParenthesis, token.Position, token.Length));
                        newList.add(token);
                        newList.add(new StiToken(StiTokenType.RParenthesis, token.Position, token.Length));
                        this.tokenPos += 2;
                        continue;
                    }
                    token.Type = StiTokenType.Variable;
                } else if (StiSystemVariableType.getSystemVariablesList().containsKey(token.Value) && (!token.Value.equals("value") || this.component instanceof StiCrossCell)) {
                    token.Type = StiTokenType.SystemVariable;
                } else if (token.Value.toLowerCase().equals("true") || token.Value.toLowerCase().equals("false")) {
                    token.ValueObject = token.Value.toLowerCase().equals("true") ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    token.Type = StiTokenType.Number;
                } else if (token.Value.toLowerCase().equals("null")) {
                    token.ValueObject = null;
                    token.Type = StiTokenType.Number;
                } else if (this.report.getDictionary().getVariables().contains(token.Value)) {
                    token.Type = StiTokenType.Variable;
                } else if (this.isCustomFunction(token.Value)) {
                    token.Type = StiTokenType.CustomFunction;
                } else if (constantsList.containsKey(stNameSpace + token.Value)) {
                    while (constantsList.get(stNameSpace + token.Value) == namespaceObj) {
                        if (this.tokenPos + 1 >= tokensList.size()) {
                            this.ThrowError(ParserErrorCode.UnexpectedEndOfExpression);
                        }
                        oldTokenValue = token.Value;
                        token.Value = token.Value + "." + tokensList.get((int)(this.tokenPos + 1)).Value;
                        this.tokenPos += 2;
                        if (constantsList.containsKey(stNameSpace + token.Value)) continue;
                        this.ThrowError(ParserErrorCode.ItemDoesNotContainDefinition, token, oldTokenValue, tokensList.get((int)(this.tokenPos + 1)).Value);
                    }
                    token.Value = stNameSpace + token.Value;
                    token.ValueObject = constantsList.get(token.Value);
                    token.Type = StiTokenType.Number;
                } else if (constantsList.containsKey(token.Value)) {
                    while (constantsList.get(token.Value) == namespaceObj) {
                        if (this.tokenPos + 1 >= tokensList.size()) {
                            this.ThrowError(4);
                        }
                        oldTokenValue = token.Value;
                        token.Value = token.Value + "." + tokensList.get((int)(this.tokenPos + 1)).Value;
                        this.tokenPos += 2;
                        if (constantsList.containsKey(token.Value)) continue;
                        this.ThrowError(15, token, oldTokenValue, tokensList.get((int)(this.tokenPos + 1)).Value);
                    }
                    token.ValueObject = constantsList.get(token.Value);
                    token.Type = StiTokenType.Number;
                } else {
                    this.ThrowError(5, token, token.Value);
                }
            }
            newList.add(token);
        }
        return newList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Integer> getUserFunctionsList() {
        if (this.userFunctionsList == null) {
            HashMap<String, Integer> hashMap = this.userFunctionsList = new HashMap();
            synchronized (hashMap) {
                List<StiUserFunction> list;
                StiFunction[] functions;
                HashMap<String, ArrayList<StiFunction>> tempUserFunctionsList = new HashMap<String, ArrayList<StiFunction>>();
                for (StiFunction func : functions = StiFunctions.getFunctions(false)) {
                    list = (ArrayList<StiFunction>)tempUserFunctionsList.get(func.getFunctionName());
                    if (list == null) {
                        list = new ArrayList<StiFunction>();
                        tempUserFunctionsList.put(func.getFunctionName(), (ArrayList<StiFunction>)list);
                        this.userFunctionsList.put(func.getFunctionName(), 3000 + this.userFunctionsList.size());
                    }
                    list.add((StiUserFunction)((Object)func));
                }
                HashMap tempUserFunctionsList2 = new HashMap();
                for (StiUserFunction func : this.report.getDictionary().getUserFunctions()) {
                    int funcName = StiFunctionType.UserFunction2.intValue + this.userFunctionsList.size();
                    list = (List)tempUserFunctionsList2.get(func.getName());
                    if (list == null) {
                        list = new ArrayList();
                        tempUserFunctionsList2.put(func.getName(), list);
                        this.userFunctionsList.put(func.getName(), funcName);
                    }
                    list.add(func);
                }
            }
        }
        return this.userFunctionsList;
    }

    public boolean isCustomFunction(String name) {
        for (StiCustomFunction func : this.report.getCustomFunctions()) {
            if (!name.equals(func.getFunctionName())) continue;
            return true;
        }
        return false;
    }

    private StiDataColumn getDataColumnByName(String name, StiDataSource ds) {
        int index;
        if (ds.getDataTable() != null && (index = ds.GetColumnIndex(name)) >= 0 && index < ds.getDataTable().getColumns().size()) {
            String nameInSource = ((StiDataColumn)ds.getDataTable().getColumns().get(index)).getNameInSource();
            Iterator iterator = ds.getColumns().iterator();
            while (iterator.hasNext()) {
                StiDataColumn dc = (StiDataColumn)iterator.next();
                if (!StiValidationUtil.equals((Object)dc.getNameInSource(), (Object)nameInSource)) continue;
                return dc;
            }
        }
        return ds.getColumns().get(name);
    }

    private void MakeTokensList() {
        StiToken token;
        this.buildAliases();
        this.tokensList = new ArrayList();
        this.position = 0;
        while ((token = this.getNextLexem()) != null) {
            this.tokensList.add(token);
        }
        this.tokensList = this.postProcessTokensList(this.tokensList);
    }

    private boolean isWhiteSpace(char ch) {
        return Character.isWhitespace(ch) || ch < ' ';
    }

    private StiDataRelation GetDataRelationByName(String name, StiDataSource ds) {
        StiDataRelation dr = null;
        for (StiDataRelation drTemp : this.report.getDictionary().getRelations()) {
            if (!name.equals(drTemp.getName()) || drTemp.getChildSource() != ds) continue;
            dr = drTemp;
            break;
        }
        return dr;
    }

    private Object op_Mod(Object par1, Object par2) {
        BigDecimal value1 = new BigDecimal(par1.toString());
        BigDecimal value2 = new BigDecimal(par2.toString());
        return value1.remainder(value2);
    }

    private Object op_Pow(Object par1, Object par2) {
        int category1 = StiTypeConverter.getCategoryClass((Object)par1);
        int category2 = StiTypeConverter.getCategoryClass((Object)par2);
        if (category1 >= 2 && category2 >= 2 && category1 <= 7 && category2 <= 7) {
            return Math.pow(Double.parseDouble((String)par1), Double.parseDouble((String)par2));
        }
        this.ThrowError(10, "^", par1.getClass().toString(), par2.getClass().toString());
        return null;
    }

    private Object op_Neg(Object par1) {
        int category = StiTypeConverter.getCategoryClass((Object)par1);
        if (category <= 1 || category >= 8) {
            this.ThrowError(10, "Negative", par1.getClass().toString());
        }
        return StiParserAsmOperations.op_Mult(par1, -1);
    }

    private Object op_Not(Object par1) {
        int category = StiTypeConverter.getCategoryClass((Object)par1);
        if (category != 9) {
            this.ThrowError(10, "Not", par1.getClass().toString());
        }
        return !Boolean.parseBoolean(par1.toString());
    }

    private Object op_Cast(Object par1, Object par2) {
        if (!(par2 instanceof StiTypeCode)) {
            return par1;
        }
        StiTypeCode typecode = (StiTypeCode)par2;
        switch (typecode) {
            case Boolean: {
                return par1 != null ? Boolean.parseBoolean(String.valueOf(par1)) : false;
            }
            case Byte: 
            case SByte: {
                return par1 != null ? (byte)Double.parseDouble(String.valueOf(par1)) : (byte)0;
            }
            case Char: {
                return StiTypeConverter.ToChar((Object)par1);
            }
            case DateTime: {
                return par1 != null ? StiParser.toDateTime(par1) : StiDateTime.minValue;
            }
            case Decimal: 
            case Double: {
                return par1 != null ? new BigDecimal(String.valueOf(par1)) : new BigDecimal(0);
            }
            case Int16: 
            case UInt16: {
                return par1 != null ? (short)Double.parseDouble(String.valueOf(par1)) : (short)0;
            }
            case Int32: 
            case UInt32: 
            case UInt: 
            case Int: {
                return par1 != null ? (int)Double.parseDouble(String.valueOf(par1)) : 0;
            }
            case Int64: 
            case UInt64: {
                return par1 != null ? (long)Double.parseDouble(String.valueOf(par1)) : 0L;
            }
            case Single: 
            case Number: {
                return Float.valueOf(par1 != null ? (float)Double.parseDouble(String.valueOf(par1)) : 0.0f);
            }
            case String: {
                Locale locale;
                Locale locale2 = locale = StiOptions.Engine.defaultDateTimeFormatLocale != null ? StiOptions.Engine.defaultDateTimeFormatLocale : this.report.getLocale();
                return par1 != null ? (par1 instanceof StiDateTime ? ((StiDateTime)par1).format(null, locale) : String.valueOf(par1)) : "";
            }
        }
        return par1;
    }

    private int compare(Object par1, Object par2) {
        Object comparable1 = null;
        Object comparable2 = null;
        if (par1 instanceof StiDateTime && par2 instanceof StiDateTime) {
            comparable1 = StiDateTime.valueOf((Object)par1);
            comparable2 = StiDateTime.valueOf((Object)par2);
        } else if (par1 instanceof StiDateOnly && par2 instanceof StiDateOnly) {
            comparable1 = StiDateOnly.valueOf((Object)par1);
            comparable2 = StiDateOnly.valueOf((Object)par2);
        } else if (par1 instanceof StiTimeOnly && par2 instanceof StiTimeOnly) {
            comparable1 = StiTimeOnly.valueOf((Object)par1);
            comparable2 = StiTimeOnly.valueOf((Object)par2);
        } else if (StiValidationUtil.isNumber((Object)par1) && StiValidationUtil.isNumber((Object)par2)) {
            comparable1 = new BigDecimal(par1.toString());
            comparable2 = new BigDecimal(par2.toString());
        } else if (par1 instanceof Comparable && par2 instanceof Comparable) {
            comparable1 = (Comparable)par1;
            comparable2 = (Comparable)par2;
        } else {
            if (par1 == null && par2 != null) {
                return -1;
            }
            if (par1 != null && par2 == null) {
                return 1;
            }
            if (par1 == null && par2 == null) {
                return 0;
            }
        }
        if (par1 instanceof DBNull && !(par2 instanceof DBNull) || par2 instanceof DBNull && !(par1 instanceof DBNull)) {
            return -1;
        }
        if (par1 instanceof DBNull && par2 instanceof DBNull) {
            return 0;
        }
        try {
            String p1 = par1.toString().trim();
            String p2 = par2.toString().trim();
            if (("true".equals(p1) || "false".equals(p1)) && ("true".equals(p2) || "false".equals(p2))) {
                return new Boolean(Boolean.parseBoolean(p1)).compareTo(Boolean.parseBoolean(p2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return comparable1.compareTo(comparable2);
    }

    private Object compareLeft(Object par1, Object par2) {
        return this.compare(par1, par2) < 0;
    }

    private Object compareLeftEqual(Object par1, Object par2) {
        return this.compare(par1, par2) <= 0;
    }

    private Object compareRight(Object par1, Object par2) {
        return this.compare(par1, par2) > 0;
    }

    private Object compareRightEqual(Object par1, Object par2) {
        return this.compare(par1, par2) >= 0;
    }

    private Object compareEqual(Object par1, Object par2) {
        if (par1 == null && par2 == null) {
            return true;
        }
        if (par1 == null || par2 == null) {
            return false;
        }
        return this.compare(par1, par2) == 0;
    }

    private Object compareNotEqual(Object par1, Object par2) {
        return this.compare(par1, par2) != 0;
    }

    private Object op_Shl(Object par1, Object par2) {
        int category1 = StiTypeConverter.getCategoryClass((Object)par1);
        int category2 = StiTypeConverter.getCategoryClass((Object)par2);
        if (category1 < 4 || category1 >= 8 || category2 != 7) {
            this.ThrowError(10, "<<", par1.getClass().toString(), par2.getClass().toString());
        } else {
            if (category1 == 4 || category2 == 4) {
                return StiTypeConverter.parseLong((Object)par1) << StiTypeConverter.parseInt((Object)par2);
            }
            if (category1 == 5 || category2 == 5) {
                return StiTypeConverter.parseLong((Object)par1) << StiTypeConverter.parseInt((Object)par2);
            }
            if (category1 == 6 || category2 == 6) {
                return StiTypeConverter.parseInt((Object)par1) << StiTypeConverter.parseInt((Object)par2);
            }
            if (category1 == 7 || category2 == 7) {
                return StiTypeConverter.parseInt((Object)par1) << StiTypeConverter.parseInt((Object)par2);
            }
        }
        return null;
    }

    private Object op_Shr(Object par1, Object par2) {
        int category1 = StiTypeConverter.getCategoryClass((Object)par1);
        int category2 = StiTypeConverter.getCategoryClass((Object)par2);
        if (category1 < 4 || category1 >= 8 || category2 != 7) {
            this.ThrowError(10, ">>", par1.getClass().toString(), par2.getClass().toString());
        } else {
            if (category1 == 4 || category2 == 4) {
                return StiTypeConverter.parseLong((Object)par1) >> StiTypeConverter.parseInt((Object)par2);
            }
            if (category1 == 5 || category2 == 5) {
                return StiTypeConverter.parseLong((Object)par1) >> StiTypeConverter.parseInt((Object)par2);
            }
            if (category1 == 6 || category2 == 6) {
                return StiTypeConverter.parseInt((Object)par1) >> StiTypeConverter.parseInt((Object)par2);
            }
            if (category1 == 7 || category2 == 7) {
                return StiTypeConverter.parseInt((Object)par1) >> StiTypeConverter.parseInt((Object)par2);
            }
        }
        return null;
    }

    private Object op_And(Object par1, Object par2) {
        int category1 = StiTypeConverter.getCategoryClass((Object)par1);
        int category2 = StiTypeConverter.getCategoryClass((Object)par2);
        if (category1 == 9 || category2 == 9) {
            return StiTypeConverter.parseBoolean((Object)par1) & StiTypeConverter.parseBoolean((Object)par2);
        }
        return new BigInteger(par1.toString()).and(new BigInteger(par2.toString())).intValue();
    }

    private Object op_Or(Object par1, Object par2) {
        int category1 = StiTypeConverter.getCategoryClass((Object)par1);
        int category2 = StiTypeConverter.getCategoryClass((Object)par2);
        if (category1 < 4 || category1 == 8 || category2 < 4 || category2 == 8) {
            this.ThrowError(10, "|", par1.getClass().toString(), par2.getClass().toString());
        } else {
            if (category1 == 4 || category2 == 4) {
                return StiTypeConverter.parseLong((Object)par1) | StiTypeConverter.parseLong((Object)par2);
            }
            if (category1 == 5 || category2 == 5) {
                return StiTypeConverter.parseLong((Object)par1) | StiTypeConverter.parseLong((Object)par2);
            }
            if (category1 == 6 || category2 == 6) {
                return StiTypeConverter.parseInt((Object)par1) | StiTypeConverter.parseInt((Object)par2);
            }
            if (category1 == 7 || category2 == 7) {
                return StiTypeConverter.parseInt((Object)par1) | StiTypeConverter.parseInt((Object)par2);
            }
            if (category1 == 9 || category2 == 9) {
                return StiTypeConverter.parseBoolean((Object)par1) | StiTypeConverter.parseBoolean((Object)par2);
            }
        }
        return null;
    }

    private Object op_Xor(Object par1, Object par2) {
        int category1 = StiTypeConverter.getCategoryClass((Object)par1);
        int category2 = StiTypeConverter.getCategoryClass((Object)par2);
        if (category1 < 4 || category1 == 8 || category2 < 4 || category2 == 8) {
            this.ThrowError(10, "^", par1.getClass().toString(), par2.getClass().toString());
        } else {
            if (category1 == 4 || category2 == 4) {
                return StiTypeConverter.parseLong((Object)par1) ^ StiTypeConverter.parseLong((Object)par2);
            }
            if (category1 == 5 || category2 == 5) {
                return StiTypeConverter.parseLong((Object)par1) ^ StiTypeConverter.parseLong((Object)par2);
            }
            if (category1 == 6 || category2 == 6) {
                return StiTypeConverter.parseInt((Object)par1) ^ StiTypeConverter.parseInt((Object)par2);
            }
            if (category1 == 7 || category2 == 7) {
                return StiTypeConverter.parseInt((Object)par1) ^ StiTypeConverter.parseInt((Object)par2);
            }
            if (category1 == 9 || category2 == 9) {
                return StiTypeConverter.parseBoolean((Object)par1) ^ StiTypeConverter.parseBoolean((Object)par2);
            }
        }
        return null;
    }

    private Object op_And2(Object par1, Object par2) {
        try {
            return StiTypeConverter.parseBoolean((Object)par1) && StiTypeConverter.parseBoolean((Object)par2);
        }
        catch (Exception e) {
            int category1 = StiTypeConverter.getCategoryClass((Object)par1);
            int category2 = StiTypeConverter.getCategoryClass((Object)par2);
            if (category1 != 9 || category2 != 9) {
                this.ThrowError(10, "&&", par1.getClass().toString(), par2.getClass().toString());
            }
            return null;
        }
    }

    private Object op_Or2(Object par1, Object par2) {
        int category1 = StiTypeConverter.getCategoryClass((Object)par1);
        int category2 = StiTypeConverter.getCategoryClass((Object)par2);
        return StiTypeConverter.parseBoolean((Object)par1) || StiTypeConverter.parseBoolean((Object)par2);
    }

    public final Object executeAsm(ArrayList<StiAsmCommand> asmList) {
        int indexAsm;
        if (asmList == null || asmList.size() == 0) {
            return null;
        }
        Stack<Object> stack = new Stack<Object>();
        ArrayList argsList = null;
        Integer par1 = 0;
        Object par2 = 0;
        if (StiOptions.Engine.logLevel >= 10) {
            LOGGER.info("AsmList");
            for (indexAsm = 0; indexAsm < asmList.size(); ++indexAsm) {
                LOGGER.info(asmList.get(indexAsm).toString());
            }
        }
        block39: for (indexAsm = 0; indexAsm < asmList.size(); ++indexAsm) {
            StiAsmCommand asmCommand = asmList.get(indexAsm);
            switch (asmCommand.Type) {
                case PushValue: {
                    stack.push(asmCommand.Parameter1);
                    continue block39;
                }
                case PushVariable: {
                    stack.push(this.getVariableValue((String)asmCommand.Parameter1));
                    continue block39;
                }
                case PushSystemVariable: {
                    stack.push(this.getSystemVariable(asmCommand.Parameter1));
                    continue block39;
                }
                case PushComponent: {
                    stack.push(asmCommand.Parameter1);
                    continue block39;
                }
                case CopyToVariable: {
                    Object value = stack.peek();
                    this.report.getDictionary().getVariables().get((String)asmCommand.Parameter1).setValueObject(value);
                    this.report.getVariables().put((String)asmCommand.Parameter1, value);
                    continue block39;
                }
                case PushFunction: {
                    argsList = new ArrayList();
                    for (int index = 0; index < (Integer)asmCommand.Parameter2; ++index) {
                        argsList.add(stack.pop());
                    }
                    Collections.reverse(argsList);
                    stack.push(this.callFunc((Integer)asmCommand.Parameter1, argsList, asmCommand));
                    continue block39;
                }
                case PushMethod: {
                    argsList = new ArrayList();
                    for (int index = 0; index < (Integer)asmCommand.Parameter2; ++index) {
                        argsList.add(stack.pop());
                    }
                    Collections.reverse(argsList);
                    stack.push(this.callMethod(asmCommand.Parameter1, argsList));
                    continue block39;
                }
                case PushProperty: {
                    argsList = new ArrayList();
                    argsList.add(stack.pop());
                    stack.push(this.callProperty(asmCommand.Parameter1, argsList));
                    continue block39;
                }
                case PushDataSourceField: {
                    String[] parts = null;
                    parts = asmCommand.Parameter2 instanceof ArrayList ? ((ArrayList)asmCommand.Parameter2).toArray(new String[0]) : ((String)asmCommand.Parameter1).split("[.]", -1);
                    StiDataSource ds = this.report.getDictionary().getDataSources().get(parts[0]);
                    if (parts.length > 1) {
                        StiDataSource ds2;
                        int indexPart;
                        if (parts.length == 2) {
                            StiDataSource ds22;
                            StiDataColumn column = ds.getColumns().get(parts[1]);
                            if (column == null && (ds22 = ds.GetParentDataSource(parts[1])) != null) {
                                stack.push(ds22);
                                continue block39;
                            }
                            if (column != null && column instanceof StiCalcDataColumn) {
                                stack.push(this.parseCalcColumnValue((StiCalcDataColumn)column, this.component));
                                continue block39;
                            }
                            stack.push(StiReport.changeType(ds.GetData(parts[1]), column.getSystemType(), this.report.getConvertNulls()));
                            continue block39;
                        }
                        String nameInSource = parts[1];
                        StiDataRow row = ds.GetParentData(nameInSource);
                        ds = ds.GetParentDataSource(nameInSource);
                        for (indexPart = 2; indexPart < parts.length - 1; ++indexPart) {
                            nameInSource = parts[indexPart];
                            row = row.getParentData(nameInSource);
                            ds = ds.GetParentDataSource(nameInSource);
                        }
                        StiDataColumn column = ds.columns.get(parts[indexPart]);
                        if (column == null && (ds2 = ds.GetParentDataSource(parts[indexPart])) != null) {
                            stack.push(ds2);
                            continue block39;
                        }
                        if (column != null && column instanceof StiCalcDataColumn) {
                            stack.push(this.parseCalcColumnValue((StiCalcDataColumn)column, this.component));
                            continue block39;
                        }
                        Object columnValue = null;
                        if (row != null) {
                            columnValue = row.getValueAsObject(parts[indexPart]);
                        }
                        stack.push(StiReport.changeType(columnValue, column.getSystemType(), this.report.getConvertNulls()));
                        continue block39;
                    }
                    stack.push(ds);
                    continue block39;
                }
                case PushBusinessObjectField: {
                    String[] parts2 = ((String)asmCommand.Parameter1).split("[.]", -1);
                    StiBusinessObject bos = this.report.getDictionary().getBusinessObjects().get(parts2[0]);
                    if (parts2.length > 1) {
                        int indexPart;
                        String nextName = null;
                        for (indexPart = 1; indexPart < parts2.length - 1; ++indexPart) {
                            nextName = parts2[indexPart];
                            if (bos.getColumns().contains(nextName)) break;
                            bos = bos.getBusinessObjects().get(nextName);
                        }
                        stack.push(bos.get(parts2[indexPart]));
                        continue block39;
                    }
                    stack.push((Object)bos);
                    continue block39;
                }
                case PushArrayElement: {
                    argsList = new ArrayList();
                    Integer index = 0;
                    while (index < (Integer)asmCommand.Parameter1) {
                        argsList.add(stack.pop());
                        Integer n = index;
                        Integer n2 = index = Integer.valueOf(index + 1);
                    }
                    Collections.reverse(argsList);
                    stack.push(this.call_arrayElement(argsList));
                    continue block39;
                }
                case Jump: {
                    indexAsm += (int)Func.Convert.toInt32(asmCommand.Parameter1);
                    continue block39;
                }
                case JumpTrue: {
                    if (!Func.Convert.toBoolean(stack.pop())) continue block39;
                    indexAsm += (int)Func.Convert.toInt32(asmCommand.Parameter1);
                    continue block39;
                }
                case JumpFalse: {
                    if (Func.Convert.toBoolean(stack.pop())) continue block39;
                    indexAsm += (int)Func.Convert.toInt32(asmCommand.Parameter1);
                    continue block39;
                }
                case Add: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(StiParserAsmOperations.op_Add(par1, par2));
                    continue block39;
                }
                case Sub: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(StiParserAsmOperations.op_Sub(par1, par2));
                    continue block39;
                }
                case Mult: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(StiParserAsmOperations.op_Mult(par1, par2));
                    continue block39;
                }
                case Div: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(StiParserAsmOperations.op_Div(par1, par2));
                    continue block39;
                }
                case Mod: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.op_Mod(par1, par2));
                    continue block39;
                }
                case Power: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.op_Pow(par1, par2));
                    continue block39;
                }
                case Neg: {
                    par1 = stack.pop();
                    stack.push(this.op_Neg(par1));
                    continue block39;
                }
                case Cast: {
                    par1 = stack.pop();
                    par2 = asmCommand.Parameter1;
                    stack.push(this.op_Cast(par1, par2));
                    continue block39;
                }
                case Not: {
                    par1 = stack.pop();
                    stack.push(this.op_Not(par1));
                    continue block39;
                }
                case CompareLeft: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.compareLeft(par1, par2));
                    continue block39;
                }
                case CompareLeftEqual: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.compareLeftEqual(par1, par2));
                    continue block39;
                }
                case CompareRight: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.compareRight(par1, par2));
                    continue block39;
                }
                case CompareRightEqual: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.compareRightEqual(par1, par2));
                    continue block39;
                }
                case CompareEqual: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.compareEqual(par1, par2));
                    continue block39;
                }
                case CompareNotEqual: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.compareNotEqual(par1, par2));
                    continue block39;
                }
                case Shl: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.op_Shl(par1, par2));
                    continue block39;
                }
                case Shr: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.op_Shr(par1, par2));
                    continue block39;
                }
                case And: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.op_And(par1, par2));
                    continue block39;
                }
                case Or: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.op_Or(par1, par2));
                    continue block39;
                }
                case Xor: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.op_Xor(par1, par2));
                    continue block39;
                }
                case And2: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.op_And2(par1, par2));
                    continue block39;
                }
                case Or2: {
                    par2 = stack.pop();
                    par1 = stack.pop();
                    stack.push(this.op_Or2(par1, par2));
                }
            }
        }
        return stack.pop();
    }

    private Object getVariableValue(String name) {
        StiReport tempReport;
        StiVariable var = this.report.getDictionary().getVariables().get(name);
        StiReport stiReport = tempReport = this.report.compiledReport == null ? this.report : this.report.compiledReport;
        if (var != null && var.getReadOnly() && var.getInitBy() == StiVariableInitBy.Expression) {
            if (this.checkVariableRecursion(name)) {
                return null;
            }
            StiText tempText = new StiText();
            tempText.setName("**ReportVariables**");
            tempText.setPage(this.report.getPages().get(0));
            Object result = StiParser.ParseTextValue("{" + var.getValue() + "}", (StiComponent)tempText);
            this.removeRecursionCheck(name);
            return result;
        }
        if (this.report.getVariables() != null && this.report.getVariables().containsKey(name)) {
            return tempReport.getVariables().get(name);
        }
        if (var != null) {
            if (var.getInitBy() == StiVariableInitBy.Expression) {
                try {
                    if (this.checkVariableRecursion(name)) {
                        return null;
                    }
                    Object result = StiParser.prepareVariableValue(var, tempReport, null);
                    this.removeRecursionCheck(name);
                    return result;
                }
                catch (Exception e) {
                    if (StiOptions.Engine.logLevel >= 10) {
                        e.printStackTrace();
                    }
                    return null;
                }
            }
            return var.getValueObject();
        }
        return null;
    }

    private boolean checkVariableRecursion(String varName) {
        if (this.parameters.variablesRecursionCheck == null) {
            this.parameters.variablesRecursionCheck = new HashMap();
        }
        if (this.parameters.variablesRecursionCheck.containsKey(varName)) {
            return true;
        }
        this.parameters.variablesRecursionCheck.put(varName, null);
        return false;
    }

    private void removeRecursionCheck(String varName) {
        this.parameters.variablesRecursionCheck.remove(varName);
    }

    private Object callFunc(Integer intValue, ArrayList argsList, StiAsmCommand command) {
        return StiCallFunction.callFunc(intValue, argsList, this.report, this, command);
    }

    private void ThrowError(int code, String message, int size) {
        throw new RuntimeException("code '" + code + "', message '" + message + "', size '" + size);
    }

    private Object callMethod(Object name, ArrayList argsList) {
        int category;
        Object baseValue = argsList.get(0);
        StiMethodType methodType = (StiMethodType)((Object)name);
        switch (methodType) {
            case ToString: {
                int category2 = StiTypeConverter.getCategoryClass(argsList.get(0));
                if (baseValue instanceof StiDateTime) {
                    Locale locale = StiOptions.Engine.defaultDateTimeFormatLocale != null ? StiOptions.Engine.defaultDateTimeFormatLocale : (this.report != null ? this.report.getLocale() : null);
                    return ((StiDateTime)baseValue).toString(argsList.size() > 1 && argsList.get(1) != null ? String.valueOf(argsList.get(1)) : null, locale);
                }
                if (category2 == 1) {
                    return String.valueOf(argsList.get(0));
                }
                if (category2 == 2 || category2 == 3) {
                    BigDecimal resDecimal = StiTypeConverter.ToDecimal(argsList.get(0));
                    if (argsList.size() == 1) {
                        return resDecimal.toString();
                    }
                    if (argsList.size() == 2) {
                        return new DecimalFormat(argsList.get(1).toString(), new DecimalFormatSymbols(this.report.getLocale())).format(resDecimal);
                    }
                    return resDecimal.toString();
                }
                if (category2 == 4 || category2 == 6) {
                    long resUlong = StiTypeConverter.parseLong(argsList.get(0));
                    if (argsList.size() == 1) {
                        return new Long(resUlong).toString();
                    }
                    if (argsList.size() == 2) {
                        return new DecimalFormat(argsList.get(1).toString(), new DecimalFormatSymbols(this.report.getLocale())).format(resUlong);
                    }
                    return new Long(resUlong).toString();
                }
                if (category2 == 5 || category2 == 7) {
                    long resLong = StiTypeConverter.parseLong(argsList.get(0));
                    if (argsList.size() == 1) {
                        return new Long(resLong).toString();
                    }
                    if (argsList.size() == 2) {
                        return new DecimalFormat(argsList.get(1).toString(), new DecimalFormatSymbols(this.report.getLocale())).format(resLong);
                    }
                    return new Long(resLong).toString();
                }
                if (category2 == 8) {
                    StiDateTime resDate = StiParser.toDateTime(argsList.get(0));
                    if (argsList.size() == 1) {
                        return resDate.formatEN();
                    }
                    String format = String.valueOf(argsList.get(1));
                    return resDate.format(format);
                }
                if (category2 == 10) {
                    StiTimeSpan resDate = (StiTimeSpan)argsList.get(0);
                    if (argsList.size() == 1) {
                        return resDate.toString();
                    }
                    String format = String.valueOf(argsList.get(1));
                    return resDate.format(format);
                }
                if (category2 == 9) {
                    return StiTypeConverter.parseBoolean(argsList.get(0));
                }
                return argsList.get(0) != null ? argsList.get(0).toString() : "";
            }
        }
        if (baseValue instanceof String) {
            switch (methodType) {
                case Substring: {
                    category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category != 1) {
                        this.ThrowError(0);
                    }
                    Integer beginIndex = ((Number)argsList.get(1)).intValue();
                    if (argsList.size() == 3) {
                        Integer endIndex = beginIndex + ((Number)argsList.get(2)).intValue();
                        return ((String)argsList.get(0)).substring(beginIndex, endIndex);
                    }
                    if (argsList.size() == 2) {
                        return ((String)argsList.get(0)).substring(beginIndex);
                    }
                    this.ThrowError(12, "Substring", argsList.size() - 1);
                    break;
                }
                case ToLower: {
                    category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category != 1) {
                        this.ThrowError(0);
                    }
                    if (argsList.size() == 1) {
                        return ((String)argsList.get(0)).toLowerCase();
                    }
                    this.ThrowError(12, "ToLower", argsList.size() - 1);
                    break;
                }
                case ToUpper: {
                    category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category != 1) {
                        this.ThrowError(0);
                    }
                    if (argsList.size() == 1) {
                        return ((String)argsList.get(0)).toUpperCase();
                    }
                    this.ThrowError(12, "ToUpper", argsList.size() - 1);
                    break;
                }
                case IndexOf: {
                    category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category != 1) {
                        this.ThrowError(16, argsList.get(0).getClass().toString(), "IndexOf");
                    }
                    if (argsList.size() == 2) {
                        category = StiTypeConverter.getCategoryClass(argsList.get(1));
                        if (category != 1) {
                            this.ThrowError(15, "IndexOf", "1", argsList.get(0).getClass().toString(), "String");
                        }
                        return ((String)argsList.get(0)).indexOf((String)argsList.get(1));
                    }
                    this.ThrowError(12, "IndexOf", argsList.size() - 1);
                    break;
                }
                case StartsWith: {
                    category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category != 1) {
                        this.ThrowError(16, argsList.get(0).getClass().toString(), "StartsWith");
                    }
                    if (argsList.size() == 2) {
                        category = StiTypeConverter.getCategoryClass(argsList.get(1));
                        if (category != 1) {
                            this.ThrowError(15, "StartsWith", "1", argsList.get(0).getClass().toString(), "String");
                        }
                        return ((String)argsList.get(0)).startsWith((String)argsList.get(1));
                    }
                    this.ThrowError(12, "StartsWith", argsList.size() - 1);
                    break;
                }
                case EndsWith: {
                    category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category != 1) {
                        this.ThrowError(16, argsList.get(0).getClass().toString(), "EndsWith");
                    }
                    if (argsList.size() == 2) {
                        category = StiTypeConverter.getCategoryClass(argsList.get(1));
                        if (category != 1) {
                            this.ThrowError(15, "EndsWith", "1", argsList.get(0).getClass().toString(), "String");
                        }
                        return ((String)argsList.get(0)).endsWith((String)argsList.get(1));
                    }
                    this.ThrowError(12, "EndsWith", argsList.size() - 1);
                    break;
                }
                case Contains: {
                    category = StiTypeConverter.getCategoryClass(argsList.get(0));
                    if (category != 1) {
                        this.ThrowError(16, argsList.get(0).getClass().toString(), "Contains");
                    }
                    if (argsList.size() == 2) {
                        category = StiTypeConverter.getCategoryClass(argsList.get(1));
                        if (category != 1) {
                            this.ThrowError(15, "Contains", "1", argsList.get(0).getClass().toString(), "String");
                        }
                        return ((String)argsList.get(0)).contains((String)argsList.get(1));
                    }
                    this.ThrowError(12, "Contains", argsList.size() - 1);
                    break;
                }
                case Replace: {
                    int category3;
                    if (argsList.size() != 3) {
                        this.ThrowError(12, "Replace", argsList.size());
                    }
                    if ((category3 = StiTypeConverter.getCategoryClass(argsList.get(0))) != 1) {
                        this.ThrowError(13, "Replace", "1", argsList.get(0).getClass().toString(), "string");
                    }
                    if ((category3 = StiTypeConverter.getCategoryClass(argsList.get(1))) != 1) {
                        this.ThrowError(13, "Replace", "2", argsList.get(0).getClass().toString(), "string");
                    }
                    if ((category3 = StiTypeConverter.getCategoryClass(argsList.get(2))) != 1) {
                        this.ThrowError(13, "Replace", "3", argsList.get(0).getClass().toString(), "string");
                    }
                    try {
                        return String.valueOf(argsList.get(0)).replaceAll(String.valueOf(argsList.get(1)), String.valueOf(argsList.get(2)));
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel >= 10) {
                            e.printStackTrace();
                        }
                        return "";
                    }
                }
            }
        }
        if (baseValue instanceof StiGroupHeaderBand) {
            switch (methodType) {
                case GetCurrentConditionValue: {
                    StiGroupHeaderBand band = (StiGroupHeaderBand)baseValue;
                    return band.GetCurrentConditionValue();
                }
            }
        }
        if (baseValue instanceof ArrayList) {
            switch (methodType) {
                case Contains: {
                    if (argsList.size() == 2) {
                        ArrayList arrayList = (ArrayList)argsList.get(0);
                        if (arrayList.size() > 0) {
                            Object containsElement;
                            Object firstElement = arrayList.get(0);
                            String containsString = argsList.get(1).toString();
                            if (firstElement instanceof Integer) {
                                containsElement = Integer.valueOf(containsString);
                            } else if (firstElement instanceof Long) {
                                containsElement = Long.valueOf(containsString);
                            } else if (firstElement instanceof Boolean) {
                                containsElement = Boolean.valueOf(containsString);
                            } else if (firstElement instanceof Character) {
                                containsElement = Character.valueOf(containsString.charAt(0));
                            } else if (firstElement instanceof Float) {
                                containsElement = Float.valueOf(containsString);
                            } else if (firstElement instanceof Double) {
                                containsElement = Double.valueOf(containsString);
                            } else if (firstElement instanceof Byte) {
                                containsElement = Byte.valueOf(containsString);
                            } else if (firstElement instanceof Short) {
                                containsElement = Short.valueOf(containsString);
                            } else if (firstElement instanceof String) {
                                containsElement = containsString;
                            } else {
                                throw new RuntimeException("Error Contains by " + firstElement.getClass());
                            }
                            return arrayList.contains(containsElement);
                        }
                        return false;
                    }
                    this.ThrowError(12, "Contains", argsList.size() - 1);
                    break;
                }
                case ToQueryString: {
                    if (argsList.size() == 1) {
                        if (!(baseValue instanceof List)) break;
                        return Func.EngineHelper.toQueryString((List)argsList.get(0), "", "");
                    }
                    if (argsList.size() == 2) {
                        if (!(baseValue instanceof List)) break;
                        return Func.EngineHelper.toQueryString((List)argsList.get(0), argsList.get(1).toString(), "");
                    }
                    if (argsList.size() == 3) {
                        if (!(baseValue instanceof List)) break;
                        return Func.EngineHelper.toQueryString((List)argsList.get(0), argsList.get(1).toString(), argsList.get(2).toString());
                    }
                    this.ThrowError(12, "NoOverloadForMethodTakesNArguments ToQueryString(), " + (argsList.size() - 1));
                    break;
                }
                case Count: {
                    return ((List)argsList.get(0)).size();
                }
            }
        }
        if (baseValue instanceof StiDataSource) {
            switch ((StiMethodType)((Object)name)) {
                case GetData: {
                    category = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category != 1) {
                        this.ThrowError(15, "GetData", "1", argsList.get(0).getClass().toString(), "String");
                    }
                    if (argsList.size() == 3) {
                        category = StiTypeConverter.getCategoryClass(argsList.get(2));
                        if (category < 4 || category > 7) {
                            this.ThrowError(15, "GetData", "2", argsList.get(0).getClass().toString(), "int");
                        }
                        return ((StiDataSource)argsList.get(0)).GetData(StiTypeConverter.parseString(argsList.get(1)), StiTypeConverter.parseInt(argsList.get(2)));
                    }
                    if (argsList.size() == 2) {
                        return ((StiDataSource)argsList.get(0)).GetData(StiTypeConverter.ToString(argsList.get(1)));
                    }
                    this.ThrowError(12, "GetData", argsList.size() - 1);
                }
            }
        }
        if (baseValue instanceof StiDateTime) {
            switch ((StiMethodType)((Object)name)) {
                case AddDays: {
                    category = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category < 2 || category > 7) {
                        this.ThrowError(13, "AddDays", "1", argsList.get(1).getClass().toString(), "double");
                    }
                    if (argsList.size() == 2) {
                        return ((StiDateTime)argsList.get(0)).addDays((long)Double.parseDouble(argsList.get(1).toString()));
                    }
                    this.ThrowError(12, "AddDays", argsList.size() - 1);
                    break;
                }
                case AddHours: {
                    category = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category < 2 || category > 7) {
                        this.ThrowError(13, "AddHours", "1", argsList.get(1).getClass().toString(), "double");
                    }
                    if (argsList.size() == 2) {
                        return ((StiDateTime)argsList.get(0)).addHours((long)Double.parseDouble(argsList.get(1).toString()));
                    }
                    this.ThrowError(12, "AddHours", argsList.size() - 1);
                    break;
                }
                case AddMilliseconds: {
                    category = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category < 2 || category > 7) {
                        this.ThrowError(13, "AddMilliseconds", "1", argsList.get(1).getClass().toString(), "double");
                    }
                    if (argsList.size() == 2) {
                        return ((StiDateTime)argsList.get(0)).addMilliseconds((long)Double.parseDouble(argsList.get(1).toString()));
                    }
                    this.ThrowError(12, "AddMilliseconds", argsList.size() - 1);
                    break;
                }
                case AddMinutes: {
                    category = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category < 2 || category > 7) {
                        this.ThrowError(13, "AddMinutes", "1", argsList.get(1).getClass().toString(), "double");
                    }
                    if (argsList.size() == 2) {
                        return ((StiDateTime)argsList.get(0)).addMinutes((long)Double.parseDouble(argsList.get(1).toString()));
                    }
                    this.ThrowError(12, "AddMinutes", argsList.size() - 1);
                    break;
                }
                case AddMonths: {
                    category = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category < 2 || category > 7) {
                        this.ThrowError(13, "AddMonths", "1", argsList.get(1).getClass().toString(), "int");
                    }
                    if (argsList.size() == 2) {
                        return ((StiDateTime)argsList.get(0)).addMonths(Integer.parseInt(argsList.get(1).toString()));
                    }
                    this.ThrowError(12, "AddMonths", argsList.size() - 1);
                    break;
                }
                case AddSeconds: {
                    category = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category < 2 || category > 7) {
                        this.ThrowError(13, "AddSeconds", "1", argsList.get(1).getClass().toString(), "double");
                    }
                    if (argsList.size() == 2) {
                        return ((StiDateTime)argsList.get(0)).addSeconds((long)Double.parseDouble(argsList.get(1).toString()));
                    }
                    this.ThrowError(12, "AddSeconds", argsList.size() - 1);
                    break;
                }
                case AddYears: {
                    category = StiTypeConverter.getCategoryClass(argsList.get(1));
                    if (category < 2 || category > 7) {
                        this.ThrowError(13, "AddYears", "1", argsList.get(1).getClass().toString(), "int");
                    }
                    if (argsList.size() == 2) {
                        return ((StiDateTime)argsList.get(0)).addYears(Integer.parseInt(argsList.get(1).toString()));
                    }
                    this.ThrowError(12, "AddYears", argsList.size() - 1);
                }
            }
        }
        if (baseValue == null && "Length".equals(name)) {
            return 0;
        }
        return null;
    }

    private Object callProperty(Object name, ArrayList argsList) {
        Object baseValue = argsList.get(0);
        if (baseValue instanceof StiDateTime) {
            StiDateTime calendar = (StiDateTime)baseValue;
            switch ((StiPropertyType)((Object)name)) {
                case Year: {
                    return calendar.year();
                }
                case Month: {
                    return calendar.month();
                }
                case Day: {
                    return calendar.day();
                }
                case Hour: {
                    return calendar.hour();
                }
                case Minute: {
                    return calendar.minute();
                }
                case Second: {
                    return calendar.second();
                }
                case Date: {
                    return calendar;
                }
                case DayOfWeek: {
                    return calendar.getDayOfWeek();
                }
                case Value: {
                    return baseValue;
                }
            }
            this.ThrowError(16, argsList.get(0).getClass().toString(), StiPropertyType.forValue(name).name());
        }
        if (baseValue instanceof String) {
            switch ((StiPropertyType)((Object)name)) {
                case Length: {
                    return String.valueOf(baseValue).length();
                }
            }
            this.ThrowError(16, argsList.get(0).getClass().toString(), StiPropertyType.forValue(name).name());
        }
        if (baseValue == null) {
            switch ((StiPropertyType)((Object)name)) {
                case Length: {
                    return 0;
                }
            }
        }
        if ((StiPropertyType)((Object)name) == StiPropertyType.Position) {
            try {
                Method method = baseValue.getClass().getMethod("getPosition", new Class[0]);
                return method.invoke(baseValue, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("'Position' property does not", e);
            }
        }
        if (baseValue instanceof Range) {
            switch ((StiPropertyType)((Object)name)) {
                case From: {
                    return ((Range)(baseValue instanceof Range ? baseValue : null)).getFromObject();
                }
                case To: {
                    return ((Range)(baseValue instanceof Range ? baseValue : null)).getToObject();
                }
                case FromDate: {
                    return ((DateTimeRange)(baseValue instanceof DateTimeRange ? baseValue : null)).getFromDate();
                }
                case ToDate: {
                    return ((DateTimeRange)(baseValue instanceof DateTimeRange ? baseValue : null)).getToDate();
                }
                case FromTime: {
                    return ((TimeSpanRange)(baseValue instanceof TimeSpanRange ? baseValue : null)).getFromTime();
                }
                case ToTime: {
                    return ((TimeSpanRange)(baseValue instanceof TimeSpanRange ? baseValue : null)).getToTime();
                }
            }
            this.ThrowError(16, argsList.get(0).getClass().toString(), StiPropertyType.forValue(name).name());
        }
        if (baseValue instanceof StiTimeSpan) {
            switch ((StiPropertyType)((Object)name)) {
                case Days: {
                    return ((StiTimeSpan)baseValue).getDays();
                }
                case Hours: {
                    return ((StiTimeSpan)baseValue).getHours();
                }
                case Milliseconds: {
                    return ((StiTimeSpan)baseValue).getTotalMilliseconds();
                }
                case Minutes: {
                    return ((StiTimeSpan)baseValue).getMinutes();
                }
                case Seconds: {
                    return ((StiTimeSpan)baseValue).getSeconds();
                }
                case Ticks: {
                    return ((StiTimeSpan)baseValue).getTicks();
                }
                case TotalDays: {
                    return ((StiTimeSpan)baseValue).getTotalDays();
                }
                case TotalHours: {
                    return ((StiTimeSpan)baseValue).getTotalHours();
                }
                case TotalMinutes: {
                    return ((StiTimeSpan)baseValue).getTotalMinutes();
                }
                case TotalSeconds: {
                    return ((StiTimeSpan)baseValue).getTotalSeconds();
                }
                case TotalMilliseconds: {
                    return ((StiTimeSpan)baseValue).getTotalMilliseconds();
                }
            }
            this.ThrowError(ParserErrorCode.ItemDoesNotContainDefinition, argsList.get(0).getClass().toString(), StiPropertyType.forValue(name).name());
        }
        if (baseValue instanceof List) {
            switch ((StiPropertyType)((Object)name)) {
                case Count: {
                    return ((List)baseValue).size();
                }
            }
            this.ThrowError(ParserErrorCode.ItemDoesNotContainDefinition, argsList.get(0).getClass().toString(), StiPropertyType.forValue(name).name());
        }
        if (baseValue instanceof StiDataBand) {
            switch ((StiPropertyType)((Object)name)) {
                case SelectedLine: {
                    return ((StiDataBand)baseValue).getSelectedLine();
                }
                case Count: {
                    return ((StiDataBand)baseValue).getCount();
                }
                case Position: {
                    return ((StiDataBand)baseValue).getPosition();
                }
                case Line: {
                    return ((StiDataBand)baseValue).getLine();
                }
                case PageLine: {
                    return ((StiDataBand)baseValue).getPageLine();
                }
                case Enabled: {
                    return ((StiDataBand)baseValue).getEnabled();
                }
            }
            this.ThrowError(16, argsList.get(0).getClass().toString(), StiPropertyType.forValue(name).name());
        }
        if (baseValue instanceof StiDataSource) {
            switch ((StiPropertyType)((Object)name)) {
                case Count: {
                    return ((StiDataSource)baseValue).getCount();
                }
                case Position: {
                    return ((StiDataSource)baseValue).getPosition();
                }
                case PageLine: {
                    return ((StiDataBand)baseValue).getPageLine();
                }
            }
            this.ThrowError(ParserErrorCode.ItemDoesNotContainDefinition, argsList.get(0).getClass().toString(), name.toString());
        }
        if (baseValue instanceof StiPage) {
            switch ((StiPropertyType)((Object)name)) {
                case Skip: {
                    return ((StiPage)baseValue).getSkip();
                }
            }
        }
        if (baseValue instanceof StiComponent) {
            switch ((StiPropertyType)((Object)name)) {
                case Name: {
                    return ((StiComponent)baseValue).getName();
                }
                case Alias: {
                    return ((StiComponent)baseValue).getAlias();
                }
                case TagValue: {
                    return ((StiComponent)baseValue).getTagValue();
                }
                case Enabled: {
                    return ((StiComponent)baseValue).getEnabled();
                }
                case Page: {
                    return ((StiComponent)baseValue).getPage();
                }
            }
        }
        if (baseValue instanceof StiText) {
            switch ((StiPropertyType)((Object)name)) {
                case Text: {
                    return ((StiText)baseValue).getText() != null ? ((StiText)baseValue).getText().getValue() : null;
                }
            }
        }
        if (baseValue instanceof StiReport) {
            switch ((StiPropertyType)((Object)name)) {
                case Pages: {
                    return ((StiReport)baseValue).getPages();
                }
            }
        }
        if (baseValue instanceof StiCrossSummary) {
            switch ((StiPropertyType)((Object)name)) {
                case CrossColumnValue: {
                    return ((StiCrossSummary)baseValue).getCrossColumnValue();
                }
                case CrossRowValue: {
                    return ((StiCrossSummary)baseValue).getCrossRowValue();
                }
            }
        }
        try {
            String getName = "get" + name.toString();
            String isName = "is" + name.toString();
            Method method = Arrays.asList(baseValue.getClass().getMethods()).stream().filter(m -> m.getName().equals(getName) || m.getName().equals(isName)).findFirst().orElse(null);
            if (method != null) {
                return method.invoke(baseValue, new Object[0]);
            }
            String cname = name.toString().substring(0, 1).toLowerCase() + name.toString().substring(1);
            Field field = Arrays.asList(baseValue.getClass().getFields()).stream().filter(f -> f.getName().equals(cname) || f.getName().equals(name.toString())).findFirst().orElse(null);
            if (field != null) {
                return field.get(baseValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.ThrowError(16, argsList.get(0).getClass().toString(), StiPropertyType.forValue(name).name());
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new RuntimeException("call_property property does not" + baseValue + " " + StiPropertyType.forValue(name).name());
    }

    private Object getSystemVariable(Object name) {
        switch ((StiSystemVariableType)((Object)name)) {
            case Column: {
                return this.report.getColumn();
            }
            case Line: {
                return this.report.getLine();
            }
            case LineThrough: {
                return this.report.LineThrough;
            }
            case LineABC: {
                return this.report.LineABC;
            }
            case LineRoman: {
                return this.report.LineRoman;
            }
            case GroupLine: {
                return this.report.GroupLine;
            }
            case PageLine: {
                return this.report.getPageLine();
            }
            case PageNumber: {
                return this.report.getPageNumber();
            }
            case PageNumberThrough: {
                return this.report.getPageNumberThrough();
            }
            case PageNofM: {
                return this.report.getPageNofM();
            }
            case PageNofMThrough: {
                return this.report.getPageNofMThrough();
            }
            case TotalPageCount: {
                return this.report.getTotalPageCount();
            }
            case TotalPageCountThrough: {
                return this.report.getTotalPageCountThrough();
            }
            case IsFirstPage: {
                return this.report.getIsFirstPage();
            }
            case IsFirstPageThrough: {
                return this.report.getIsFirstPageThrough();
            }
            case IsLastPage: {
                return this.report.getIsLastPage();
            }
            case IsLastPageThrough: {
                return this.report.getIsLastPageThrough();
            }
            case ReportAlias: {
                return this.report.getReportAlias();
            }
            case ReportAuthor: {
                return this.report.getReportAuthor();
            }
            case ReportChanged: {
                return new StiDateTime(this.report.getReportChanged());
            }
            case ReportCreated: {
                return new StiDateTime(this.report.getReportCreated());
            }
            case ReportDescription: {
                return this.report.getReportDescription();
            }
            case ReportName: {
                return this.report.getReportName();
            }
            case Time: {
                return StiDateTime.currentDate();
            }
            case Today: {
                return StiDateTime.currentDateOnly();
            }
            case ConditionValue: {
                return this.report.engine.lastInvokeTextProcessValueEventArgsValue != null && this.report.engine.lastInvokeTextProcessValueEventArgsValue instanceof Number ? new BigDecimal(this.report.engine.lastInvokeTextProcessValueEventArgsValue.toString()) : Integer.valueOf(0);
            }
            case ConditionTag: {
                return this.component instanceof StiText ? ((StiText)(this.component instanceof StiText ? this.component : null)).getTagValue() : null;
            }
            case Sender: {
                return this.sender;
            }
        }
        throw new RuntimeException("getSystemVariable" + name);
    }

    public static void prepareReportVariables(StiReport report) {
        report.setVariables(new StiVariablesMap(report));
        StiText tempText = new StiText();
        tempText.setName("**ReportVariables**");
        tempText.setPage(report.pages.get(0));
        Iterator iterator = report.dictionary.variables.iterator();
        while (iterator.hasNext()) {
            StiVariable var = (StiVariable)iterator.next();
            try {
                StiParser.prepareVariableValue(var, report, tempText, false);
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) continue;
                e.printStackTrace();
            }
        }
        report.getModifiedVariables().clear();
    }

    public static Object createExpressionAndParse(String textValue, StiComponent component) {
        String inputExpression = StiParser.createExpression(textValue);
        return StiParser.ParseTextValue(inputExpression, component);
    }

    public static Object parseTextValue(String inputExpression, StiComponent component, StiParserParameters parameters) {
        parameters.inputExpression = inputExpression;
        parameters.component = component;
        return StiParser.ParseTextValue(parameters);
    }

    public static String parseTextValue(StiReport report, String expression) {
        StiText text = new StiText();
        text.setName(String.format("Temp%s", StiGuid.newGuid().toString().substring(0, 10).replace("-", "")));
        text.setPage(report.getPages().get(0));
        Object value = StiParser.parseTextValue(expression, text);
        return value == null || value == DBNull.Value ? "" : value.toString();
    }

    public static Object parseTextValue(String inputExpression, StiComponent component) {
        return StiParser.ParseTextValue(inputExpression, component);
    }

    public static Object ParseTextValue(String inputExpression, StiComponent component) {
        boolean storeToPrint = false;
        Boolean executeIfStoreToPrint = true;
        boolean returnAsmList = false;
        Object tempVar = StiParser.ParseTextValue(inputExpression, component, storeToPrint, executeIfStoreToPrint, returnAsmList, false);
        return tempVar;
    }

    public static Object ParseTextValue(StiExpression inputExpression, StiText component) {
        return StiParser.ParseTextValue(inputExpression.getValue(), (StiComponent)component);
    }

    public static Object parseTextValue(String inputExpression, StiComponent component, StiRefObject<Boolean> storeToPrint, boolean executeIfStoreToPrint, boolean returnAsmList, boolean checkSyntaxMode) {
        StiParserParameters parameters = new StiParserParameters(inputExpression, component, component, (Boolean)storeToPrint.argvalue, executeIfStoreToPrint, returnAsmList, checkSyntaxMode);
        Object result = StiParser.ParseTextValue(parameters);
        storeToPrint.argvalue = parameters.storeToPrint;
        return result;
    }

    public static Object ParseTextValue(String inputExpression, StiComponent component, Boolean storeToPrint, boolean executeIfStoreToPrint, boolean returnAsmList, boolean checkSyntaxMode) {
        StiParserParameters parameters = new StiParserParameters(inputExpression, component, component, storeToPrint, executeIfStoreToPrint, returnAsmList, checkSyntaxMode);
        return StiParser.ParseTextValue(parameters);
    }

    public static Object prepareVariableValue(StiVariable var, StiReport report, StiText textBox) throws StiException {
        return StiParser.prepareVariableValue(var, report, textBox, false);
    }

    public static Object prepareVariableValue(StiVariable var, StiReport report, StiText textBox, boolean fillItems) throws StiException {
        if (textBox == null) {
            textBox = new StiText();
            textBox.setName("**ReportVariables**");
            textBox.setPage(report.getPages().get(0));
        }
        Hashtable hashDataSources = null;
        if (fillItems) {
            hashDataSources = new Hashtable();
        }
        Object obj = null;
        if (var.getSystemType().getInterfaceType() == ParameterType.VALUE || var.getSystemType().getInterfaceType() == ParameterType.NULLABLE || var.getType() == StiSystemTypeEnum.SystemString && !var.isList()) {
            if (var.getInitBy() == StiVariableInitBy.Value) {
                obj = var.getValueObject();
                if (!(var.getSystemType().isNullable() || var.getSystemType().getEnumType() != StiSystemTypeEnum.SystemDateOnly && var.getSystemType().getEnumType() != StiSystemTypeEnum.SystemTimeOnly)) {
                    obj = StiDateTime.currentDate();
                }
            } else {
                obj = StiParser.getExpressionValue("{" + var.getValue() + "}", textBox, hashDataSources, report);
                if (var.getSystemType().getEnumType() == StiSystemTypeEnum.SystemDateOnly) {
                    obj = StiValueHelper.tryToNullableDateOnly((Object)obj);
                }
                if (var.getSystemType().getEnumType() == StiSystemTypeEnum.SystemTimeOnly) {
                    obj = StiValueHelper.tryToNullableTimeOnly((Object)obj);
                }
            }
        } else {
            if (var.getSystemType().getInterfaceType() == ParameterType.LIST) {
                obj = new ArrayList();
            }
            if (var.getSystemType().getInterfaceType() == ParameterType.RANGE) {
                String tp = var.getSystemType().getEnumType().name().replace("System", "");
                try {
                    obj = Class.forName("com.stimulsoft.base.range." + tp + "Range").newInstance();
                }
                catch (Exception e) {
                    LOGGER.warning("Class instance not found: " + var.getSystemType().getEnumType().name());
                }
                if (obj != null) {
                    Range range = (Range)obj;
                    if (var.getInitBy() == StiVariableInitBy.Value) {
                        range.setFromObject(((Range)var.getValueObject()).getFromObject());
                        range.setToObject(((Range)var.getValueObject()).getToObject());
                    } else {
                        range.setFromObject(StiParser.getExpressionValue("{" + var.getInitByExpressionFrom() + "}", textBox, hashDataSources, report));
                        range.setToObject(StiParser.getExpressionValue("{" + var.getInitByExpressionTo() + "}", textBox, hashDataSources, report));
                    }
                }
            } else if (var.getSystemType().getInterfaceType() == ParameterType.LIST) {
                List<StiDialogInfoItem> items = var.getDialogInfo().getDialogInfoItems(var.getType());
                items = var.getDialogInfo().orderBy(items);
                List objList = (List)obj;
                if (items != null && items.size() > 0) {
                    for (StiDialogInfoItem item : items) {
                        try {
                            if (!item.checked) continue;
                            objList.add(item.KeyObject);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            if (fillItems) {
                StiVariableHelper.fillItemsOfVariable(var, report, (StiRefObject<Boolean>)new StiRefObject((Object)true));
            }
        }
        if (fillItems) {
            for (Object de : hashDataSources.keySet()) {
                StiDataSource dataSource = report.getDictionary().getDataSources().get((String)de);
                if (dataSource == null) continue;
                dataSource.disconnect();
            }
        }
        report.setVariable(var.getName(), obj);
        return obj;
    }

    private static Object getExpressionValue(String expr, StiComponent comp, Hashtable hash, StiReport report) throws StiException {
        if (hash != null) {
            Hashtable<String, Hashtable<String, String>> hash2 = new Hashtable<String, Hashtable<String, String>>();
            StiDataSourceHelper.checkExpression(expr, comp, hash2);
            for (String key : hash2.keySet()) {
                Object obj = hash.get(key);
                if (obj != null) continue;
                hash.put(key, true);
                StiDataSource dataSource = report.getDictionary().getDataSources().get(key);
                if (dataSource == null) continue;
                dataSource.connect();
            }
        }
        return StiScriptHelper.parseTextValue(expr, comp);
    }

    public static Object ParseTextValue(StiParserParameters param) {
        try {
            StiParser parser;
            if (param.inputExpression == null || param.inputExpression.length() == 0) {
                return null;
            }
            param.parser = parser = new StiParser();
            parser.report = param.component.getReport();
            parser.component = param.component;
            parser.checkSyntaxMode = param.checkSyntaxMode;
            parser.sender = param.sender;
            parser.parameters = param;
            ArrayList list = null;
            StiEngine engine = param.parser != null && param.parser.report != null && param.parser.report.getEngine() != null ? param.parser.report.getEngine() : param.component.getReport().getEngine();
            String expressionId = param.inputExpression + param.component.getName();
            if (engine != null) {
                if (engine.getparserConversionStore() == null) {
                    engine.setparserConversionStore(new Hashtable());
                }
                if (engine.getparserConversionStore().containsKey(expressionId)) {
                    list = (ArrayList)engine.getparserConversionStore().get(expressionId);
                }
            }
            if (list == null) {
                try {
                    list = new ArrayList();
                    int counter = 0;
                    int pos = 0;
                    while (pos < param.inputExpression.length()) {
                        int posBegin = pos;
                        while (pos < param.inputExpression.length() && param.inputExpression.charAt(pos) != '{') {
                            ++pos;
                        }
                        if (pos != posBegin) {
                            if (counter == 1) {
                                list.add(new StiAsmCommand(StiAsmCommandType.Cast, StiTypeCode.String));
                            }
                            list.add(new StiAsmCommand(StiAsmCommandType.PushValue, param.inputExpression.substring(posBegin, pos)));
                            if (++counter > 1) {
                                list.add(new StiAsmCommand(StiAsmCommandType.Add));
                            }
                        }
                        if (pos >= param.inputExpression.length() || param.inputExpression.charAt(pos) != '{') continue;
                        posBegin = ++pos;
                        boolean flag = false;
                        while (pos < param.inputExpression.length()) {
                            if (param.inputExpression.charAt(pos) == '\"') {
                                int pos2;
                                boolean verbatim = param.inputExpression.charAt(pos - 1) == '@';
                                for (pos2 = ++pos; pos2 < param.inputExpression.length(); ++pos2) {
                                    if (param.inputExpression.charAt(pos2) == '\"') {
                                        if (!verbatim || pos2 + 1 >= param.inputExpression.length() || param.inputExpression.charAt(pos2 + 1) != '\"') break;
                                        ++pos2;
                                    }
                                    if (verbatim || param.inputExpression.charAt(pos2) != '\\') continue;
                                    ++pos2;
                                }
                                pos = pos2 + 1;
                                continue;
                            }
                            if (param.inputExpression.charAt(pos) == '}') {
                                String currentExpression = param.inputExpression.substring(posBegin, pos);
                                if (StiValidationUtil.isNotNullOrEmpty((String)currentExpression)) {
                                    parser.expressionPosition = posBegin;
                                    list.addAll(parser.ParseToAsm(currentExpression));
                                    if (++counter > 1) {
                                        list.add(new StiAsmCommand(StiAsmCommandType.Cast, StiTypeCode.String));
                                        list.add(new StiAsmCommand(StiAsmCommandType.Add));
                                    }
                                }
                                flag = true;
                                ++pos;
                                break;
                            }
                            ++pos;
                        }
                        if (flag) continue;
                        parser.expressionPosition = posBegin;
                        list.add(new StiAsmCommand(StiAsmCommandType.PushValue, param.inputExpression.substring(posBegin)));
                        if (++counter <= 1) continue;
                        list.add(new StiAsmCommand(StiAsmCommandType.Add));
                    }
                }
                catch (RuntimeException ex) {
                    if (engine != null) {
                        engine.getparserConversionStore().put(expressionId, new ArrayList());
                    }
                    LOGGER.warning(ex.getMessage());
                    if (StiOptions.Engine.logLevel >= 10) {
                        ex.printStackTrace();
                    }
                    throw ex;
                }
                if (engine != null) {
                    engine.getparserConversionStore().put(expressionId, list);
                }
            }
            if (param.returnAsmList) {
                return list;
            }
            if (list.size() > 0) {
                param.storeToPrint = StiParser.CheckForStoreToPrint(list);
                if (param.storeToPrint && !param.executeIfStoreToPrint) {
                    return param.inputExpression;
                }
                return StiConvertHelper.noTrailing((Object)parser.executeAsm(list));
            }
            return null;
        }
        catch (RuntimeException e) {
            StiLoggingUtil.uppendException((Exception)e, (String)param.component.getClass().getName(), (String)("Expression:" + param.inputExpression));
            throw e;
        }
        catch (Exception e) {
            StiLoggingUtil.uppendException((Exception)e, (String)param.component.getClass().getName(), (String)("Expression:" + param.inputExpression));
            throw new RuntimeException(e);
        }
    }

    private ArrayList<StiAsmCommand> ParseToAsm(String inputExpression) {
        this.inputExpression = inputExpression;
        this.MakeTokensList();
        this.asmList = new ArrayList();
        this.eval_exp();
        return this.asmList;
    }

    private static boolean CheckForStoreToPrint(Object objAsmList) {
        boolean result = false;
        ArrayList asmList = (ArrayList)(objAsmList instanceof ArrayList ? objAsmList : null);
        if (asmList != null) {
            for (StiAsmCommand command : asmList) {
                Integer intValue;
                StiSystemVariableType type;
                if (command.Type == StiAsmCommandType.PushSystemVariable && ((type = (StiSystemVariableType)((Object)command.Parameter1)) == StiSystemVariableType.PageNumber || type == StiSystemVariableType.PageNumberThrough || type == StiSystemVariableType.TotalPageCount || type == StiSystemVariableType.TotalPageCountThrough || type == StiSystemVariableType.PageNofM || type == StiSystemVariableType.GetAnchorPageNumber || type == StiSystemVariableType.PageNofMThrough || type == StiSystemVariableType.IsFirstPage || type == StiSystemVariableType.IsFirstPageThrough || type == StiSystemVariableType.IsLastPage || type == StiSystemVariableType.IsLastPageThrough)) {
                    result = true;
                    break;
                }
                if (command.Type != StiAsmCommandType.PushFunction || !((intValue = (Integer)command.Parameter1) >= StiFunctionType.cCount.intValue && intValue <= StiFunctionType.cLast.intValue || intValue >= StiFunctionType.rCount.intValue && intValue <= StiFunctionType.rLast.intValue || intValue >= StiFunctionType.ciCount.intValue && intValue <= StiFunctionType.ciLast.intValue || intValue >= StiFunctionType.riCount.intValue && intValue <= StiFunctionType.riLast.intValue || intValue == StiFunctionType.GetAnchorPageNumber.intValue) && intValue != StiFunctionType.GetAnchorPageNumberThrough.intValue) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private Object parseCalcColumnValue(StiCalcDataColumn column, StiComponent comp) {
        return StiScriptHelper.parseTextValue("{" + column.getExpression() + "}", comp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StiParserException checkExpression(String inputExpression, StiComponent component, boolean useAliases) {
        try {
            StiParser parser = new StiParser();
            boolean storeToPrint = false;
            Object result = StiParser.ParseTextValue(inputExpression, component, storeToPrint, false, true, true);
            List list = (List)result;
            if (list == null) return null;
        }
        catch (StiParserException pex) {
            return pex;
        }
        return null;
    }

    public static StiDateTime toDateTime(Object par1) {
        return (StiDateTime)par1;
    }

    public static void checkForDataBandsUsedInPageTotals(StiText stiText) {
        try {
            if (StiScriptHelper.isScriptInExpression(stiText.getText().getValue(), stiText)) {
                return;
            }
            boolean storeToPrint = false;
            StiParser.ParseTextValue(stiText.getText().getValue(), stiText, storeToPrint, false, true, false);
        }
        catch (Exception e) {
            if (stiText.getReport() != null) {
                stiText.getReport().WriteToReportRenderingMessages(String.format("Expression in Text property of '%s' can't be evaluated! %s", stiText.getName(), e.getMessage()));
            }
            LOGGER.warning(String.format("Expression in Text property of '%s' can't be evaluated! %s", stiText.getName(), e.getMessage()));
        }
    }

    private static String createExpression(String value) {
        return "{" + value + "}";
    }

    public static Hashtable<StiFunctionType, List<StiParserMethodInfo>> getMethodsHash() {
        if (methodsHash == null) {
            methodsHash = new Hashtable();
            for (StiParserMethodInfo methodInfo : methods) {
                List<StiParserMethodInfo> list = methodsHash.get((Object)methodInfo.getName());
                if (list == null) {
                    list = new ArrayList<StiParserMethodInfo>();
                    methodsHash.put(methodInfo.getName(), list);
                }
                list.add(methodInfo);
            }
        }
        return methodsHash;
    }

    private void checkTypes(List<StiAsmCommand> asmList) {
    }

    private static String replaceBackslash(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder output = new StringBuilder();
        for (int index = 0; index < input.length(); ++index) {
            char c = input.charAt(index);
            if (c == '\\' && index < input.length() - 1) {
                char ch = input.charAt(++index);
                switch (ch) {
                    case '\\': {
                        output.append('\\');
                        break;
                    }
                    case '\'': {
                        output.append('\'');
                        break;
                    }
                    case '\"': {
                        output.append('\"');
                        break;
                    }
                    case '0': {
                        output.append('\u0000');
                        break;
                    }
                    case 'n': {
                        output.append('\n');
                        break;
                    }
                    case 'r': {
                        output.append('\r');
                        break;
                    }
                    case 't': {
                        output.append('\t');
                        break;
                    }
                    case 'x': {
                        char next;
                        StringBuilder sbHex = new StringBuilder();
                        for (int hexLen = 0; index < input.length() - 1 && hexLen < 4 && StiParser.isHexDigit(next = input.charAt(index + 1)); ++index, ++hexLen) {
                            sbHex.append(next);
                        }
                        int resInt = 0;
                        try {
                            resInt = Integer.parseInt(sbHex.toString(), 16);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        output.append((char)resInt);
                        break;
                    }
                    case 'u': {
                        if (index + 4 < input.length()) {
                            String hex = input.substring(index + 1, index + 5);
                            if (StiParser.isHexString(hex)) {
                                try {
                                    int resIntU = Integer.parseInt(hex, 16);
                                    output.append((char)resIntU);
                                    index += 4;
                                }
                                catch (NumberFormatException e) {
                                    output.append('\\').append('u');
                                }
                                break;
                            }
                            output.append('\\').append('u');
                            break;
                        }
                        output.append('\\').append('u');
                        break;
                    }
                    default: {
                        output.append('\\').append(ch);
                    }
                }
                continue;
            }
            output.append(c);
        }
        return output.toString();
    }

    private static String replaceQuotationMark(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder output = new StringBuilder();
        for (int index = 0; index < input.length(); ++index) {
            char c = input.charAt(index);
            if (c == '\"' && index < input.length() - 1) {
                ++index;
                output.append('\"');
                continue;
            }
            output.append(c);
        }
        return output.toString();
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static boolean isHexString(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (StiParser.isHexDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static {
        constantsList = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        namespaceObj = new Object();
        namespacesList = new Hashtable();
        methods = new StiParserMethodInfo[]{new StiParserMethodInfo(StiFunctionType.ToWords, 1, new StiParserDataType[]{StiParserDataType.Long}), new StiParserMethodInfo(StiFunctionType.ToWords, 3, new StiParserDataType[]{StiParserDataType.Double}), new StiParserMethodInfo(StiFunctionType.ToWords, 2, new StiParserDataType[]{StiParserDataType.Decimal}), new StiParserMethodInfo(StiFunctionType.ToWords, 4, new StiParserDataType[]{StiParserDataType.Long, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWords, 6, new StiParserDataType[]{StiParserDataType.Double, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWords, 5, new StiParserDataType[]{StiParserDataType.Decimal, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWordsEs, 1, new StiParserDataType[]{StiParserDataType.Long, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWordsEs, 2, new StiParserDataType[]{StiParserDataType.Long, StiParserDataType.Bool, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWordsFa, 1, new StiParserDataType[]{StiParserDataType.Long}), new StiParserMethodInfo(StiFunctionType.ToWordsPl, 1, new StiParserDataType[]{StiParserDataType.Long, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWordsPt, 1, new StiParserDataType[]{StiParserDataType.Long, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWordsRu, 1, new StiParserDataType[]{StiParserDataType.Long}), new StiParserMethodInfo(StiFunctionType.ToWordsRu, 3, new StiParserDataType[]{StiParserDataType.Double}), new StiParserMethodInfo(StiFunctionType.ToWordsRu, 2, new StiParserDataType[]{StiParserDataType.Decimal}), new StiParserMethodInfo(StiFunctionType.ToWordsRu, 4, new StiParserDataType[]{StiParserDataType.Long, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWordsRu, 6, new StiParserDataType[]{StiParserDataType.Double, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWordsRu, 5, new StiParserDataType[]{StiParserDataType.Decimal, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWordsUa, 1, new StiParserDataType[]{StiParserDataType.Long}), new StiParserMethodInfo(StiFunctionType.ToWordsUa, 3, new StiParserDataType[]{StiParserDataType.Double}), new StiParserMethodInfo(StiFunctionType.ToWordsUa, 2, new StiParserDataType[]{StiParserDataType.Decimal}), new StiParserMethodInfo(StiFunctionType.ToWordsUa, 4, new StiParserDataType[]{StiParserDataType.Long, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWordsUa, 6, new StiParserDataType[]{StiParserDataType.Double, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWordsUa, 5, new StiParserDataType[]{StiParserDataType.Decimal, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToWordsZh, 1, new StiParserDataType[]{StiParserDataType.Long}), new StiParserMethodInfo(StiFunctionType.ToWordsZh, 3, new StiParserDataType[]{StiParserDataType.Double}), new StiParserMethodInfo(StiFunctionType.ToWordsZh, 2, new StiParserDataType[]{StiParserDataType.Decimal}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWordsZh, 1, new StiParserDataType[]{StiParserDataType.Long}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWordsZh, 2, new StiParserDataType[]{StiParserDataType.Double}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWordsZh, 3, new StiParserDataType[]{StiParserDataType.Decimal}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWordsZh, 1, new StiParserDataType[]{StiParserDataType.Long}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWords, 2, new StiParserDataType[]{StiParserDataType.Double}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWords, 3, new StiParserDataType[]{StiParserDataType.Decimal}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWords, 4, new StiParserDataType[]{StiParserDataType.Long, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWords, 5, new StiParserDataType[]{StiParserDataType.Double, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWords, 6, new StiParserDataType[]{StiParserDataType.Decimal, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWords, 7, new StiParserDataType[]{StiParserDataType.Long, StiParserDataType.Bool, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWords, 8, new StiParserDataType[]{StiParserDataType.Double, StiParserDataType.Bool, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWords, 9, new StiParserDataType[]{StiParserDataType.Decimal, StiParserDataType.Bool, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWords, 10, new StiParserDataType[]{StiParserDataType.Double, StiParserDataType.Bool, StiParserDataType.Bool, StiParserDataType.String, StiParserDataType.String}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWordsEs, 1, new StiParserDataType[]{StiParserDataType.Decimal, StiParserDataType.String, StiParserDataType.Int32}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWordsEs, 1, new StiParserDataType[]{StiParserDataType.Decimal, StiParserDataType.String, StiParserDataType.Int32, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.GetLabel, 1, new StiParserDataType[]{StiParserDataType.Object}), new StiParserMethodInfo(StiFunctionType.GetParam, 1, new StiParserDataType[]{StiParserDataType.Object}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWordsPtBr, 1, new StiParserDataType[]{StiParserDataType.Decimal}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWordsPtBr, 2, new StiParserDataType[]{StiParserDataType.Decimal, StiParserDataType.Bool, StiParserDataType.String, StiParserDataType.String}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWordsPtBr, 1, new StiParserDataType[]{StiParserDataType.Double}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWordsPtBr, 2, new StiParserDataType[]{StiParserDataType.Double, StiParserDataType.Bool, StiParserDataType.String, StiParserDataType.String}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWordsRu, 1, new StiParserDataType[]{StiParserDataType.Decimal}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWordsRu, 4, new StiParserDataType[]{StiParserDataType.Decimal, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWordsRu, 7, new StiParserDataType[]{StiParserDataType.Decimal, StiParserDataType.Bool, StiParserDataType.String}), new StiParserMethodInfo(StiFunctionType.ToCurrencyWordsRu, 10, new StiParserDataType[]{StiParserDataType.Decimal, StiParserDataType.String, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.DateToStr, 1, new StiParserDataType[]{StiParserDataType.DateTime}), new StiParserMethodInfo(StiFunctionType.DateToStr, 2, new StiParserDataType[]{StiParserDataType.DateTime, StiParserDataType.Bool}), new StiParserMethodInfo(StiFunctionType.Left, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.Int}), new StiParserMethodInfo(StiFunctionType.Right, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.Int}), new StiParserMethodInfo(StiFunctionType.Mid, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.Int, StiParserDataType.Int}), new StiParserMethodInfo(StiFunctionType.JoinColumnContent, 1, new StiParserDataType[]{StiParserDataType.StiDataSource, StiParserDataType.String, StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemObject, StiSystemTypeEnum.SystemObject, StiSystemTypeEnum.SystemObject}), new StiParserMethodInfo(StiFunctionType.JoinColumnContent, 2, new StiParserDataType[]{StiParserDataType.StiDataSource, StiParserDataType.String, StiParserDataType.String, StiParserDataType.Bool}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemObject, StiSystemTypeEnum.SystemObject, StiSystemTypeEnum.SystemObject, StiSystemTypeEnum.SystemBoolean}), new StiParserMethodInfo(StiFunctionType.IsAllDataRowNullOrEmpty, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemBoolean}), new StiParserMethodInfo(StiFunctionType.IsDataEmpty, 1, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemBoolean}), new StiParserMethodInfo(StiFunctionType.MathRound, 1, new StiParserDataType[]{StiParserDataType.Double}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDouble}), new StiParserMethodInfo(StiFunctionType.MathRound, 2, new StiParserDataType[]{StiParserDataType.Double, StiParserDataType.Int}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDouble}), new StiParserMethodInfo(StiFunctionType.MathRound, 3, new StiParserDataType[]{StiParserDataType.Double, StiParserDataType.Int}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDouble}), new StiParserMethodInfo(StiFunctionType.MathRound, 4, new StiParserDataType[]{StiParserDataType.Double, StiParserDataType.Int, StiParserDataType.Int}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDouble}), new StiParserMethodInfo(StiFunctionType.MathRound, 5, new StiParserDataType[]{StiParserDataType.Decimal}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDecimal}), new StiParserMethodInfo(StiFunctionType.MathRound, 6, new StiParserDataType[]{StiParserDataType.Decimal, StiParserDataType.Int}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDecimal}), new StiParserMethodInfo(StiFunctionType.MathRound, 7, new StiParserDataType[]{StiParserDataType.Decimal, StiParserDataType.Int}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDecimal}), new StiParserMethodInfo(StiFunctionType.MathRound, 8, new StiParserDataType[]{StiParserDataType.Decimal, StiParserDataType.Int, StiParserDataType.Int}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDecimal}), new StiParserMethodInfo(StiFunctionType.SystemConvertToBoolean, 1, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemBoolean}), new StiParserMethodInfo(StiFunctionType.SystemConvertToByte, 2, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemByte}), new StiParserMethodInfo(StiFunctionType.SystemConvertToChar, 3, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemChar}), new StiParserMethodInfo(StiFunctionType.SystemConvertToDateTime, 4, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDateTime}), new StiParserMethodInfo(StiFunctionType.SystemConvertToDecimal, 5, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDecimal}), new StiParserMethodInfo(StiFunctionType.SystemConvertToDouble, 6, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDouble}), new StiParserMethodInfo(StiFunctionType.SystemConvertToInt16, 7, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemInt16}), new StiParserMethodInfo(StiFunctionType.SystemConvertToInt32, 8, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemInt32}), new StiParserMethodInfo(StiFunctionType.SystemConvertToInt64, 9, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemInt64}), new StiParserMethodInfo(StiFunctionType.SystemConvertToSByte, 10, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemByte}), new StiParserMethodInfo(StiFunctionType.SystemConvertToSingle, 11, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemSingle}), new StiParserMethodInfo(StiFunctionType.SystemConvertToString, 12, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemString}), new StiParserMethodInfo(StiFunctionType.SystemConvertToUInt16, 13, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemUInt16}), new StiParserMethodInfo(StiFunctionType.SystemConvertToUInt32, 14, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemUInt32}), new StiParserMethodInfo(StiFunctionType.SystemConvertToUInt64, 15, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemUInt64}), new StiParserMethodInfo(StiFunctionType.MathPow, 1, new StiParserDataType[]{StiParserDataType.Double, StiParserDataType.Double}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDouble}), new StiParserMethodInfo(StiFunctionType.GetAnchorPageNumber, 1, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemInt32}), new StiParserMethodInfo(StiFunctionType.GetAnchorPageNumberThrough, 1, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemInt32}), new StiParserMethodInfo(StiFunctionType.ParseDateTime, 1, new StiParserDataType[]{StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDateTime}), new StiParserMethodInfo(StiFunctionType.ParseDecimal, 1, new StiParserDataType[]{StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDecimal}), new StiParserMethodInfo(StiFunctionType.ParseDouble, 1, new StiParserDataType[]{StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDouble}), new StiParserMethodInfo(StiFunctionType.ParseInt, 1, new StiParserDataType[]{StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemInt32}), new StiParserMethodInfo(StiFunctionType.StringIsNullOrEmpty, 1, new StiParserDataType[]{StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemBoolean}), new StiParserMethodInfo(StiFunctionType.StringIsNullOrWhiteSpace, 1, new StiParserDataType[]{StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemBoolean}), new StiParserMethodInfo(StiFunctionType.IsNull, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemBoolean}), new StiParserMethodInfo(StiFunctionType.Next, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemObject}), new StiParserMethodInfo(StiFunctionType.NextIsNull, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemBoolean}), new StiParserMethodInfo(StiFunctionType.Previous, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemObject}), new StiParserMethodInfo(StiFunctionType.PreviousIsNull, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemBoolean}), new StiParserMethodInfo(StiFunctionType.StiNullValuesHelperIsNull, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemBoolean}), new StiParserMethodInfo(StiFunctionType.TimeSpanFromDays, 1, new StiParserDataType[]{StiParserDataType.Double}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemTimeSpan}), new StiParserMethodInfo(StiFunctionType.TimeSpanFromHours, 1, new StiParserDataType[]{StiParserDataType.Double}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemTimeSpan}), new StiParserMethodInfo(StiFunctionType.TimeSpanFromMilliseconds, 1, new StiParserDataType[]{StiParserDataType.Double}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemTimeSpan}), new StiParserMethodInfo(StiFunctionType.TimeSpanFromMinutes, 1, new StiParserDataType[]{StiParserDataType.Double}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemTimeSpan}), new StiParserMethodInfo(StiFunctionType.TimeSpanFromSeconds, 1, new StiParserDataType[]{StiParserDataType.Double}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemTimeSpan}), new StiParserMethodInfo(StiFunctionType.TimeSpanFromTicks, 1, new StiParserDataType[]{StiParserDataType.Int64}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemTimeSpan}), new StiParserMethodInfo(StiFunctionType.TryParseDateTime, 1, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemBoolean}), new StiParserMethodInfo(StiFunctionType.StrToDateTime, 1, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDateTime}), new StiParserMethodInfo(StiFunctionType.StrToNullableDateTime, 1, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDateTime}), new StiParserMethodInfo(StiFunctionType.DaysInMonth, 1, new StiParserDataType[]{StiParserDataType.DateTime, StiParserDataType.DateTime}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemInt16}), new StiParserMethodInfo(StiFunctionType.DaysInMonth, 3, new StiParserDataType[]{StiParserDataType.Int, StiParserDataType.Int}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemInt16}), new StiParserMethodInfo(StiFunctionType.DaysInMonth, 2, new StiParserDataType[]{StiParserDataType.Int, StiParserDataType.Int}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemInt16}), new StiParserMethodInfo(StiFunctionType.DaysInMonth, 4, new StiParserDataType[]{StiParserDataType.DateTime}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemDateTime}), new StiParserMethodInfo(StiFunctionType.DaysInYear, 1, new StiParserDataType[]{StiParserDataType.DateTime}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemInt16}), new StiParserMethodInfo(StiFunctionType.DaysInYear, 3, new StiParserDataType[]{StiParserDataType.Int}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemInt16}), new StiParserMethodInfo(StiFunctionType.DaysInYear, 2, new StiParserDataType[]{StiParserDataType.Int}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemInt16}), new StiParserMethodInfo(StiFunctionType.MonthName, 1, new StiParserDataType[]{StiParserDataType.DateTime}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemString}), new StiParserMethodInfo(StiFunctionType.MonthName, 2, new StiParserDataType[]{StiParserDataType.DateTime, StiParserDataType.Bool}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemString}), new StiParserMethodInfo(StiFunctionType.MonthName, 3, new StiParserDataType[]{StiParserDataType.DateTime, StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemString}), new StiParserMethodInfo(StiFunctionType.MonthName, 4, new StiParserDataType[]{StiParserDataType.DateTime, StiParserDataType.String, StiParserDataType.Bool}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemString}), new StiParserMethodInfo(StiFunctionType.ARGB, 1, new StiParserDataType[]{StiParserDataType.Int, StiParserDataType.Int, StiParserDataType.Int, StiParserDataType.Int}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemObject}), new StiParserMethodInfo(StiFunctionType.RGB, 1, new StiParserDataType[]{StiParserDataType.Int, StiParserDataType.Int, StiParserDataType.Int}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemObject}), new StiParserMethodInfo(StiFunctionType.ColorValue, 1, new StiParserDataType[]{StiParserDataType.String}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemObject}), new StiParserMethodInfo(StiFunctionType.ColorFade, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.Double}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemObject}), new StiParserMethodInfo(StiFunctionType.SolidBrushValue, 1, new StiParserDataType[]{StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemObject}), new StiParserMethodInfo(StiFunctionType.GradientBrushValue, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.Object, StiParserDataType.Double}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemObject}), new StiParserMethodInfo(StiFunctionType.GlareBrushValue, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.Object, StiParserDataType.Double, StiParserDataType.Double, StiParserDataType.Double}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemObject}), new StiParserMethodInfo(StiFunctionType.GlassBrushValue, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.Bool, StiParserDataType.Double}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemObject}), new StiParserMethodInfo(StiFunctionType.HatchBrushValue, 1, new StiParserDataType[]{StiParserDataType.Object, StiParserDataType.Object, StiParserDataType.Object}, new StiSystemTypeEnum[]{StiSystemTypeEnum.SystemObject})};
        constantsList.put("DBNull", namespaceObj);
        constantsList.put("DBNull.Value", DBNull.Value);
        constantsList.put("string.Empty", "");
        constantsList.put("MidpointRounding", namespaceObj);
        constantsList.put("MidpointRounding.ToEven", "ToEven");
        constantsList.put("MidpointRounding.AwayFromZero", "AwayFromZero");
        constantsList.put("StiRankOrder", namespaceObj);
        constantsList.put("Color.AliceBlue", StiColorEnum.AliceBlue.color());
        constantsList.put("Color.AntiqueWhite", StiColorEnum.AntiqueWhite.color());
        constantsList.put("Color.Aqua", StiColorEnum.Aqua.color());
        constantsList.put("Color.Aquamarine", StiColorEnum.Aquamarine.color());
        constantsList.put("Color.Azure", StiColorEnum.Azure.color());
        constantsList.put("Color.Beige", StiColorEnum.Beige.color());
        constantsList.put("Color.Bisque", StiColorEnum.Bisque.color());
        constantsList.put("Color.Black", StiColorEnum.Black.color());
        constantsList.put("Color.BlanchedAlmond", StiColorEnum.BlanchedAlmond.color());
        constantsList.put("Color.Blue", StiColorEnum.Blue.color());
        constantsList.put("Color.BlueViolet", StiColorEnum.BlueViolet.color());
        constantsList.put("Color.Brown", StiColorEnum.Brown.color());
        constantsList.put("Color.BurlyWood", StiColorEnum.BurlyWood.color());
        constantsList.put("Color.CadetBlue", StiColorEnum.CadetBlue.color());
        constantsList.put("Color.Chartreuse", StiColorEnum.Chartreuse.color());
        constantsList.put("Color.Chocolate", StiColorEnum.Chocolate.color());
        constantsList.put("Color.Coral", StiColorEnum.Coral.color());
        constantsList.put("Color.CornflowerBlue", StiColorEnum.CornflowerBlue.color());
        constantsList.put("Color.Cornsilk", StiColorEnum.Cornsilk.color());
        constantsList.put("Color.Crimson", StiColorEnum.Crimson.color());
        constantsList.put("Color.Cyan", StiColorEnum.Cyan.color());
        constantsList.put("Color.DarkBlue", StiColorEnum.DarkBlue.color());
        constantsList.put("Color.DarkCyan", StiColorEnum.DarkCyan.color());
        constantsList.put("Color.DarkGoldenrod", StiColorEnum.DarkGoldenrod.color());
        constantsList.put("Color.DarkGray", StiColorEnum.DarkGray.color());
        constantsList.put("Color.DarkGreen", StiColorEnum.DarkGreen.color());
        constantsList.put("Color.DarkKhaki", StiColorEnum.DarkKhaki.color());
        constantsList.put("Color.DarkMagenta", StiColorEnum.DarkMagenta.color());
        constantsList.put("Color.DarkOliveGreen", StiColorEnum.DarkOliveGreen.color());
        constantsList.put("Color.DarkOrange", StiColorEnum.DarkOrange.color());
        constantsList.put("Color.DarkOrchid", StiColorEnum.DarkOrchid.color());
        constantsList.put("Color.DarkRed", StiColorEnum.DarkRed.color());
        constantsList.put("Color.DarkSalmon", StiColorEnum.DarkSalmon.color());
        constantsList.put("Color.DarkSeaGreen", StiColorEnum.DarkSeaGreen.color());
        constantsList.put("Color.DarkSlateBlue", StiColorEnum.DarkSlateBlue.color());
        constantsList.put("Color.DarkSlateGray", StiColorEnum.DarkSlateGray.color());
        constantsList.put("Color.DarkTurquoise", StiColorEnum.DarkTurquoise.color());
        constantsList.put("Color.DarkViolet", StiColorEnum.DarkViolet.color());
        constantsList.put("Color.DeepPink", StiColorEnum.DeepPink.color());
        constantsList.put("Color.DeepSkyBlue", StiColorEnum.DeepSkyBlue.color());
        constantsList.put("Color.DimGray", StiColorEnum.DimGray.color());
        constantsList.put("Color.DodgerBlue", StiColorEnum.DodgerBlue.color());
        constantsList.put("Color.Firebrick", StiColorEnum.Firebrick.color());
        constantsList.put("Color.FloralWhite", StiColorEnum.FloralWhite.color());
        constantsList.put("Color.ForestGreen", StiColorEnum.ForestGreen.color());
        constantsList.put("Color.Fuchsia", StiColorEnum.Fuchsia.color());
        constantsList.put("Color.Gainsboro", StiColorEnum.Gainsboro.color());
        constantsList.put("Color.GhostWhite", StiColorEnum.GhostWhite.color());
        constantsList.put("Color.Gold", StiColorEnum.Gold.color());
        constantsList.put("Color.Goldenrod", StiColorEnum.Goldenrod.color());
        constantsList.put("Color.Gray", StiColorEnum.Gray.color());
        constantsList.put("Color.Green", StiColorEnum.Green.color());
        constantsList.put("Color.GreenYellow", StiColorEnum.GreenYellow.color());
        constantsList.put("Color.Honeydew", StiColorEnum.Honeydew.color());
        constantsList.put("Color.HotPink", StiColorEnum.HotPink.color());
        constantsList.put("Color.IndianRed", StiColorEnum.IndianRed.color());
        constantsList.put("Color.Indigo", StiColorEnum.Indigo.color());
        constantsList.put("Color.Ivory", StiColorEnum.Ivory.color());
        constantsList.put("Color.Khaki", StiColorEnum.Khaki.color());
        constantsList.put("Color.Lavender", StiColorEnum.Lavender.color());
        constantsList.put("Color.LavenderBlush", StiColorEnum.LavenderBlush.color());
        constantsList.put("Color.LawnGreen", StiColorEnum.LawnGreen.color());
        constantsList.put("Color.LemonChiffon", StiColorEnum.LemonChiffon.color());
        constantsList.put("Color.LightBlue", StiColorEnum.LightBlue.color());
        constantsList.put("Color.LightCoral", StiColorEnum.LightCoral.color());
        constantsList.put("Color.LightCyan", StiColorEnum.LightCyan.color());
        constantsList.put("Color.LightGoldenrodYellow", StiColorEnum.LightGoldenrodYellow.color());
        constantsList.put("Color.LightGray", StiColorEnum.LightGray.color());
        constantsList.put("Color.LightGreen", StiColorEnum.LightGreen.color());
        constantsList.put("Color.LightPink", StiColorEnum.LightPink.color());
        constantsList.put("Color.LightSalmon", StiColorEnum.LightSalmon.color());
        constantsList.put("Color.LightSeaGreen", StiColorEnum.LightSeaGreen.color());
        constantsList.put("Color.LightSkyBlue", StiColorEnum.LightSkyBlue.color());
        constantsList.put("Color.LightSlateGray", StiColorEnum.LightSlateGray.color());
        constantsList.put("Color.LightSteelBlue", StiColorEnum.LightSteelBlue.color());
        constantsList.put("Color.LightYellow", StiColorEnum.LightYellow.color());
        constantsList.put("Color.Lime", StiColorEnum.Lime.color());
        constantsList.put("Color.LimeGreen", StiColorEnum.LimeGreen.color());
        constantsList.put("Color.Linen", StiColorEnum.Linen.color());
        constantsList.put("Color.Magenta", StiColorEnum.Magenta.color());
        constantsList.put("Color.Maroon", StiColorEnum.Maroon.color());
        constantsList.put("Color.MediumAquamarine", StiColorEnum.MediumAquamarine.color());
        constantsList.put("Color.MediumBlue", StiColorEnum.MediumBlue.color());
        constantsList.put("Color.MediumOrchid", StiColorEnum.MediumOrchid.color());
        constantsList.put("Color.MediumPurple", StiColorEnum.MediumPurple.color());
        constantsList.put("Color.MediumSeaGreen", StiColorEnum.MediumSeaGreen.color());
        constantsList.put("Color.MediumSlateBlue", StiColorEnum.MediumSlateBlue.color());
        constantsList.put("Color.MediumSpringGreen", StiColorEnum.MediumSpringGreen.color());
        constantsList.put("Color.MediumTurquoise", StiColorEnum.MediumTurquoise.color());
        constantsList.put("Color.MediumVioletRed", StiColorEnum.MediumVioletRed.color());
        constantsList.put("Color.MidnightBlue", StiColorEnum.MidnightBlue.color());
        constantsList.put("Color.MintCream", StiColorEnum.MintCream.color());
        constantsList.put("Color.MistyRose", StiColorEnum.MistyRose.color());
        constantsList.put("Color.Moccasin", StiColorEnum.Moccasin.color());
        constantsList.put("Color.NavajoWhite", StiColorEnum.NavajoWhite.color());
        constantsList.put("Color.Navy", StiColorEnum.Navy.color());
        constantsList.put("Color.OldLace", StiColorEnum.OldLace.color());
        constantsList.put("Color.Olive", StiColorEnum.Olive.color());
        constantsList.put("Color.OliveDrab", StiColorEnum.OliveDrab.color());
        constantsList.put("Color.Orange", StiColorEnum.Orange.color());
        constantsList.put("Color.OrangeRed", StiColorEnum.OrangeRed.color());
        constantsList.put("Color.Orchid", StiColorEnum.Orchid.color());
        constantsList.put("Color.PaleGoldenrod", StiColorEnum.PaleGoldenrod.color());
        constantsList.put("Color.PaleGreen", StiColorEnum.PaleGreen.color());
        constantsList.put("Color.PaleTurquoise", StiColorEnum.PaleTurquoise.color());
        constantsList.put("Color.PaleVioletRed", StiColorEnum.PaleVioletRed.color());
        constantsList.put("Color.PapayaWhip", StiColorEnum.PapayaWhip.color());
        constantsList.put("Color.PeachPuff", StiColorEnum.PeachPuff.color());
        constantsList.put("Color.Peru", StiColorEnum.Peru.color());
        constantsList.put("Color.Pink", StiColorEnum.Pink.color());
        constantsList.put("Color.Plum", StiColorEnum.Plum.color());
        constantsList.put("Color.PowderBlue", StiColorEnum.PowderBlue.color());
        constantsList.put("Color.Purple", StiColorEnum.Purple.color());
        constantsList.put("Color.Red", StiColorEnum.Red.color());
        constantsList.put("Color.RosyBrown", StiColorEnum.RosyBrown.color());
        constantsList.put("Color.RoyalBlue", StiColorEnum.RoyalBlue.color());
        constantsList.put("Color.SaddleBrown", StiColorEnum.SaddleBrown.color());
        constantsList.put("Color.Salmon", StiColorEnum.Salmon.color());
        constantsList.put("Color.SandyBrown", StiColorEnum.SandyBrown.color());
        constantsList.put("Color.SeaGreen", StiColorEnum.SeaGreen.color());
        constantsList.put("Color.SeaShell", StiColorEnum.SeaShell.color());
        constantsList.put("Color.Sienna", StiColorEnum.Sienna.color());
        constantsList.put("Color.Silver", StiColorEnum.Silver.color());
        constantsList.put("Color.SkyBlue", StiColorEnum.SkyBlue.color());
        constantsList.put("Color.SlateBlue", StiColorEnum.SlateBlue.color());
        constantsList.put("Color.SlateGray", StiColorEnum.SlateGray.color());
        constantsList.put("Color.Snow", StiColorEnum.Snow.color());
        constantsList.put("Color.SpringGreen", StiColorEnum.SpringGreen.color());
        constantsList.put("Color.SteelBlue", StiColorEnum.SteelBlue.color());
        constantsList.put("Color.Tan", StiColorEnum.Tan.color());
        constantsList.put("Color.Teal", StiColorEnum.Teal.color());
        constantsList.put("Color.Thistle", StiColorEnum.Thistle.color());
        constantsList.put("Color.Tomato", StiColorEnum.Tomato.color());
        constantsList.put("Color.Transparent", StiColorEnum.Transparent.color());
        constantsList.put("Color.Turquoise", StiColorEnum.Turquoise.color());
        constantsList.put("Color.Violet", StiColorEnum.Violet.color());
        constantsList.put("Color.Wheat", StiColorEnum.Wheat.color());
        constantsList.put("Color.White", StiColorEnum.White.color());
        constantsList.put("Color.WhiteSmoke", StiColorEnum.WhiteSmoke.color());
        constantsList.put("Color.Yellow", StiColorEnum.Yellow.color());
        constantsList.put("Color.YellowGreen", StiColorEnum.YellowGreen.color());
        constantsList.put("HatchStyle.BackwardDiagonal", StiHatchStyle.BackwardDiagonal);
        constantsList.put("HatchStyle.Cross", StiHatchStyle.Cross);
        constantsList.put("HatchStyle.DarkDownwardDiagonal", StiHatchStyle.DarkDownwardDiagonal);
        constantsList.put("HatchStyle.DarkHorizontal", StiHatchStyle.DarkHorizontal);
        constantsList.put("HatchStyle.DarkUpwardDiagonal", StiHatchStyle.DarkUpwardDiagonal);
        constantsList.put("HatchStyle.DarkVertical", StiHatchStyle.DarkVertical);
        constantsList.put("HatchStyle.DashedDownwardDiagonal", StiHatchStyle.DashedDownwardDiagonal);
        constantsList.put("HatchStyle.DashedHorizontal", StiHatchStyle.DashedHorizontal);
        constantsList.put("HatchStyle.DashedUpwardDiagonal", StiHatchStyle.DashedUpwardDiagonal);
        constantsList.put("HatchStyle.DashedVertical", StiHatchStyle.DashedVertical);
        constantsList.put("HatchStyle.DiagonalBrick", StiHatchStyle.DiagonalBrick);
        constantsList.put("HatchStyle.DiagonalCross", StiHatchStyle.DiagonalCross);
        constantsList.put("HatchStyle.Divot", StiHatchStyle.Divot);
        constantsList.put("HatchStyle.DottedDiamond", StiHatchStyle.DottedDiamond);
        constantsList.put("HatchStyle.DottedGrid", StiHatchStyle.DottedGrid);
        constantsList.put("HatchStyle.ForwardDiagonal", StiHatchStyle.ForwardDiagonal);
        constantsList.put("HatchStyle.Horizontal", StiHatchStyle.Horizontal);
        constantsList.put("HatchStyle.HorizontalBrick", StiHatchStyle.HorizontalBrick);
        constantsList.put("HatchStyle.LargeCheckerBoard", StiHatchStyle.LargeCheckerBoard);
        constantsList.put("HatchStyle.LargeConfetti", StiHatchStyle.LargeConfetti);
        constantsList.put("HatchStyle.LargeGrid", StiHatchStyle.LargeGrid);
        constantsList.put("HatchStyle.LightDownwardDiagonal", StiHatchStyle.LightDownwardDiagonal);
        constantsList.put("HatchStyle.LightHorizontal", StiHatchStyle.LightHorizontal);
        constantsList.put("HatchStyle.LightUpwardDiagonal", StiHatchStyle.LightUpwardDiagonal);
        constantsList.put("HatchStyle.LightVertical", StiHatchStyle.LightVertical);
        constantsList.put("HatchStyle.Max", StiHatchStyle.Max);
        constantsList.put("HatchStyle.Min", StiHatchStyle.Min);
        constantsList.put("HatchStyle.NarrowHorizontal", StiHatchStyle.NarrowHorizontal);
        constantsList.put("HatchStyle.NarrowVertical", StiHatchStyle.NarrowVertical);
        constantsList.put("HatchStyle.OutlinedDiamond", StiHatchStyle.OutlinedDiamond);
        constantsList.put("HatchStyle.Percent05", StiHatchStyle.Percent05);
        constantsList.put("HatchStyle.Percent10", StiHatchStyle.Percent10);
        constantsList.put("HatchStyle.Percent20", StiHatchStyle.Percent20);
        constantsList.put("HatchStyle.Percent25", StiHatchStyle.Percent25);
        constantsList.put("HatchStyle.Percent30", StiHatchStyle.Percent30);
        constantsList.put("HatchStyle.Percent40", StiHatchStyle.Percent40);
        constantsList.put("HatchStyle.Percent50", StiHatchStyle.Percent50);
        constantsList.put("HatchStyle.Percent60", StiHatchStyle.Percent60);
        constantsList.put("HatchStyle.Percent70", StiHatchStyle.Percent70);
        constantsList.put("HatchStyle.Percent75", StiHatchStyle.Percent75);
        constantsList.put("HatchStyle.Percent80", StiHatchStyle.Percent80);
        constantsList.put("HatchStyle.Percent90", StiHatchStyle.Percent90);
        constantsList.put("HatchStyle.Plaid", StiHatchStyle.Plaid);
        constantsList.put("HatchStyle.Shingle", StiHatchStyle.Shingle);
        constantsList.put("HatchStyle.SmallCheckerBoard", StiHatchStyle.SmallCheckerBoard);
        constantsList.put("HatchStyle.SmallConfetti", StiHatchStyle.SmallConfetti);
        constantsList.put("HatchStyle.SmallGrid", StiHatchStyle.SmallGrid);
        constantsList.put("HatchStyle.SolidDiamond", StiHatchStyle.SolidDiamond);
        constantsList.put("HatchStyle.Sphere", StiHatchStyle.Sphere);
        constantsList.put("HatchStyle.Trellis", StiHatchStyle.Trellis);
        constantsList.put("HatchStyle.Vertical", StiHatchStyle.Vertical);
        constantsList.put("HatchStyle.Wave", StiHatchStyle.Wave);
        constantsList.put("HatchStyle.Weave", StiHatchStyle.Weave);
        constantsList.put("HatchStyle.WideDownwardDiagonal", StiHatchStyle.WideDownwardDiagonal);
        constantsList.put("HatchStyle.WideUpwardDiagonal", StiHatchStyle.WideUpwardDiagonal);
        constantsList.put("HatchStyle.ZigZag", StiHatchStyle.ZigZag);
        namespacesList.put("Totals", namespaceObj);
        namespacesList.put("System", namespaceObj);
        namespacesList.put("String", namespaceObj);
        namespacesList.put("System.Convert", namespaceObj);
        namespacesList.put("System.Globalization", namespaceObj);
        namespacesList.put("Convert", namespaceObj);
        namespacesList.put("Math", namespaceObj);
        namespacesList.put("Func", namespaceObj);
        namespacesList.put("Func.EngineHelper", namespaceObj);
        namespacesList.put("HatchStyle", namespaceObj);
        namespacesList.put("Color", namespaceObj);
        errorsList = new String[]{"Syntax error %s %s %s %s", "Integral constant is too large", "The expression is empty", "Division by zero", "Unexpected end of expression", "The name '%s' does not exist in the current context", "Syntax error - unprocessed lexemes remain", "( expected", ") expected", "Field, method, or property is not found: '%s'", "Operator '%s' cannot be applied to operands of type '%s' and type '%s'", "The function is not found: '%s'", "No overload for method '%s' takes '%s' arguments", "The '%s' function has invalid argument '%s': cannot convert from '%s' to '%s'", "The '%s' function is not yet implemented", "The '%s' method has invalid argument '%s': cannot convert from '%s' to '%s'", "'%s' does not contain a definition for '%s'"};
    }

    public static class StiToken {
        public StiTokenType Type = StiTokenType.forValue((int)0);
        public String Value;
        public Object ValueObject;
        public int Position = -1;
        public int Length = -1;

        public StiToken(StiTokenType type) {
            this.Type = type;
        }

        public StiToken() {
            this.Type = StiTokenType.Empty;
        }

        public StiToken(StiTokenType type, int position, int length) {
            this.Type = type;
            this.Position = position;
            this.Length = length;
        }

        public String toString() {
            return String.format("TokenType=%s|value=%s", this.Type, this.Value);
        }
    }

    public static class StiFilterParserData {
        public StiComponent Component;
        public String Expression;

        public StiFilterParserData(StiComponent component, String expression) {
            this.Component = component;
            this.Expression = expression;
        }
    }
}

