/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2.builders;

import com.stimulsoft.base.DBNull;
import com.stimulsoft.base.helper.StiValueHelper;
import com.stimulsoft.base.json.JSONArray;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.Func;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.engine.engineV2.builders.StiComponentV2Builder;
import com.stimulsoft.report.maps.StiMap;
import com.stimulsoft.report.maps.StiMapData;
import com.stimulsoft.report.maps.enums.StiMapMode;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StiMapV2Builder
extends StiComponentV2Builder {
    public static StiMap renderMap(StiMap masterMap) throws UnsupportedEncodingException, IOException, JSONException {
        StiMap mapComp = (StiMap)masterMap.clone();
        if (!StiValidationUtil.isNullOrEmpty((String)masterMap.getKeyDataColumn()) && mapComp.getMapMode() == StiMapMode.Choropleth) {
            Object[] keys = StiDataColumn.GetDatasFromDataColumn(mapComp.getReport().getDictionary(), masterMap.getKeyDataColumn());
            if (keys == null) {
                return mapComp;
            }
            Object[] names = null;
            Object[] values = null;
            Object[] groups = null;
            Object[] colors = null;
            if (!StiValidationUtil.isNullOrEmpty((String)masterMap.getNameDataColumn())) {
                names = StiDataColumn.GetDatasFromDataColumn(mapComp.getReport().getDictionary(), masterMap.getNameDataColumn());
            }
            if (!StiValidationUtil.isNullOrEmpty((String)masterMap.getValueDataColumn())) {
                values = StiDataColumn.GetDatasFromDataColumn(mapComp.getReport().getDictionary(), masterMap.getValueDataColumn());
            }
            if (!StiValidationUtil.isNullOrEmpty((String)masterMap.getGroupDataColumn())) {
                groups = StiDataColumn.GetDatasFromDataColumn(mapComp.getReport().getDictionary(), masterMap.getGroupDataColumn());
            }
            if (!StiValidationUtil.isNullOrEmpty((String)masterMap.getColorDataColumn())) {
                colors = StiDataColumn.GetDatasFromDataColumn(mapComp.getReport().getDictionary(), masterMap.getColorDataColumn());
            }
            if (names == null && values == null && groups == null && colors == null) {
                return mapComp;
            }
            List<StiMapData> mapData = mapComp.GetMapData();
            for (int index = 0; index < keys.length; ++index) {
                String key = (String)keys[index];
                StiMapData data = null;
                if (!StiValidationUtil.isNullOrEmpty((String)key)) {
                    for (StiMapData dt : mapData) {
                        if (!StiValidationUtil.equals((Object)dt.getKey(), (Object)key)) continue;
                        data = dt;
                    }
                }
                if (data == null) continue;
                if (names != null && names.length > 0) {
                    String name = Func.Convert.toString(names[index]);
                    if (!StiValidationUtil.isNullOrEmpty((String)name)) {
                        data.setName(name);
                    } else {
                        data.setName(null);
                    }
                }
                if (values != null && values.length > 0) {
                    data.setValue(values[index] != DBNull.Value ? (String)values[index] : null);
                }
                if (groups != null && groups.length > 0) {
                    String group = Func.Convert.toString(groups[index]);
                    if (!StiValidationUtil.isNullOrEmpty((String)group)) {
                        data.setGroup(group);
                    } else {
                        data.setGroup(null);
                    }
                }
                if (colors == null || colors.length <= 0) continue;
                String color = Func.Convert.toString(colors[index]);
                if (!StiValidationUtil.isNullOrEmpty((String)color)) {
                    data.setColor(color);
                    continue;
                }
                data.setColor(null);
            }
            ArrayList mMapData = new ArrayList();
            for (StiMapData dt : mapData) {
                HashMap<String, String> hm = new HashMap<String, String>();
                hm.put("Key", dt.getKey());
                hm.put("Color", dt.getColor());
                hm.put("Group", dt.getGroup());
                hm.put("Name", dt.getName());
                hm.put("Value", dt.getValue());
                mMapData.add(hm);
            }
            mapComp.setMapData(new JSONArray(mMapData).toString());
        } else if (!StiValidationUtil.isNullOrEmpty((String)mapComp.getLatitude()) && !StiValidationUtil.isNullOrEmpty((String)mapComp.getLongitude())) {
            ArrayList<StiPoint> pushPins = new ArrayList<StiPoint>();
            StiDataBand band = mapComp.getParent() instanceof StiDataBand ? (StiDataBand)mapComp.getParent() : null;
            List latitudeValues = null;
            List longitudeValues = null;
            mapComp.setPoints(null);
            if (band != null) {
                Object latitude = StiDataColumn.GetDataFromDataColumn(mapComp.getReport().getDictionary(), mapComp.getLatitude());
                Object longitude = StiDataColumn.GetDataFromDataColumn(mapComp.getReport().getDictionary(), mapComp.getLongitude());
                if (latitude != null && longitude != null) {
                    latitudeValues = (List)latitude;
                    longitudeValues = (List)longitude;
                }
            } else {
                latitudeValues = StiDataColumn.getDataListFromDataColumn(mapComp.getReport().getDictionary(), mapComp.getLatitude(), null);
                longitudeValues = StiDataColumn.getDataListFromDataColumn(mapComp.getReport().getDictionary(), mapComp.getLongitude(), null);
            }
            if (latitudeValues != null && longitudeValues != null) {
                int count = Math.min(1000, Math.max(latitudeValues.size(), longitudeValues.size()));
                for (int index = 0; index < count; ++index) {
                    Object latValue = latitudeValues.get(index);
                    Object lonValue = longitudeValues.get(index);
                    if (latValue == null || lonValue == null) continue;
                    double lat = StiValueHelper.tryToDouble(latValue);
                    double lon = StiValueHelper.tryToDouble(lonValue);
                    pushPins.add(new StiPoint(lat, lon));
                }
                mapComp.setPoints(pushPins);
            }
        }
        return mapComp;
    }

    @Override
    public void Prepare(StiComponent masterComp) {
        super.Prepare(masterComp);
        if (masterComp.getHeight() > masterComp.getPage().getHeight() || masterComp.getHeight() > masterComp.getParent().getHeight()) {
            masterComp.setHeight(Math.min(masterComp.getPage().getHeight(), masterComp.getParent().getHeight()));
        }
    }

    @Override
    public StiComponent InternalRender(StiComponent masterComp) {
        StiMap masterMap = (StiMap)masterComp;
        try {
            return StiMapV2Builder.renderMap(masterMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

