/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2.builders;

import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiGroupHeaderBand;
import com.stimulsoft.report.components.bands.StiPageFooterBand;
import com.stimulsoft.report.components.bands.StiPageHeaderBand;
import com.stimulsoft.report.components.bands.StiReportSummaryBand;
import com.stimulsoft.report.components.bands.StiReportTitleBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.complexcomponents.StiContainerHelper;
import com.stimulsoft.report.components.complexcomponents.StiPanel;
import com.stimulsoft.report.components.crossBands.StiCrossDataBand;
import com.stimulsoft.report.components.enums.StiComponentType;
import com.stimulsoft.report.components.interfaces.IStiComponentsOwnerRenderer;
import com.stimulsoft.report.crossTab.StiCrossTab;
import com.stimulsoft.report.engine.engineV2.StiSubReportsHelper;
import com.stimulsoft.report.engine.engineV2.builders.StiComponentV2Builder;

public class StiContainerV2Builder
extends StiComponentV2Builder {
    public static StiContainer GetRenderContainer(StiComponent comp) {
        StiContainer cont;
        StiBand band;
        StiContainer container = null;
        StiRectangle rect = new StiRectangle(comp.getClientRectangle().x, comp.getClientRectangle().y, comp.getClientRectangle().width, comp.getClientRectangle().height);
        if (comp instanceof StiPanel) {
            container = new StiPanel(rect);
            ((StiPanel)container).setColumns(((StiPanel)comp).getColumns());
        } else {
            container = new StiContainer(rect);
        }
        container.setMinSize(comp.getMinSize());
        container.setMaxSize(comp.getMaxSize());
        container.setDockStyle(comp.getDockStyle());
        container.setName(comp.getName());
        container.setParentComponentIsBand(comp instanceof StiBand);
        container.setParentComponentIsCrossBand(comp instanceof StiCrossDataBand);
        container.setCanBreak(((StiContainer)comp).getCanBreak());
        container.setCanGrow(comp.getCanGrow());
        container.setCanShrink(comp.getCanShrink());
        container.setGrowToHeight(comp.getGrowToHeight());
        container.setShiftMode(comp.getShiftMode());
        container.setPrintable(comp.getPrintable());
        container.setPrintOn(comp.getPrintOn());
        container.setComponentStyle(comp.getComponentStyle());
        container.setCurrentBookmark(comp.getCurrentBookmark());
        container.setParentBookmark(comp.getParentBookmark());
        container.currentPointer = comp.currentPointer;
        container.parentPointer = comp.parentPointer;
        container.setGuid(comp.getGuid());
        container.setInteraction(comp.getInteraction());
        container.setDrillDownParameters(comp.getDrillDownParameters());
        if (comp instanceof StiGroupHeaderBand) {
            container.setCollapsingIndex(((StiGroupHeaderBand)comp).getCollapsingIndex());
            container.setCollapsedValue(((StiGroupHeaderBand)comp).getCollapsedValue());
        }
        if (comp instanceof StiDataBand) {
            container.collapsingIndex = ((StiDataBand)comp).collapsingIndex;
            container.setCollapsedValue(((StiDataBand)comp).getCollapsedValue());
            container.setCollapsingTreePath(((StiDataBand)comp).getCollapsingTreePath());
        }
        if ((band = (StiBand)(comp instanceof StiBand ? comp : null)) != null) {
            if (band.getBandInfoV2().ForceCanBreak) {
                container.setCanBreak(true);
            }
            if (band.getBandInfoV2().ForceCanGrow) {
                container.canGrow = true;
            }
        }
        if ((cont = (StiContainer)(comp instanceof StiContainer ? comp : null)) != null) {
            Object tempVar = cont.getBrush().clone();
            container.brush = (StiBrush)(tempVar instanceof StiBrush ? tempVar : null);
            Object tempVar2 = cont.getBorder().clone();
            container.border = (StiBorder)(tempVar2 instanceof StiBorder ? tempVar2 : null);
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StiComponent InternalRender(StiComponent masterComp) {
        StiComponentsCollection stiComponentsCollection;
        StiContainer masterContainer = (StiContainer)(masterComp instanceof StiContainer ? masterComp : null);
        boolean isSubReportMode = false;
        StiContainer renderedContainer = StiContainerV2Builder.GetRenderContainer(masterContainer);
        renderedContainer.setBookmark(masterContainer.getBookmark());
        renderedContainer.setHyperlink(masterContainer.getHyperlink());
        if (!(masterContainer instanceof IStiComponentsOwnerRenderer)) {
            stiComponentsCollection = masterContainer.components;
            synchronized (stiComponentsCollection) {
                for (StiComponent component : masterContainer.components) {
                    StiChart chart;
                    component.parentBookmark = masterContainer.getCurrentBookmark();
                    if (component.parentPointer == null) {
                        component.parentPointer = masterContainer.currentPointer;
                    }
                    if (component.getComponentType() != StiComponentType.Simple) continue;
                    component.parentBookmark = masterContainer.getCurrentBookmark();
                    component.parentPointer = masterContainer.currentPointer;
                    StiComponent comp = component.render();
                    if (comp == null) continue;
                    StiContainer cont = (StiContainer)(comp instanceof StiContainer ? comp : null);
                    if (cont != null && cont.getContainerInfoV2().SetSegmentPerWidth != -1) {
                        renderedContainer.getContainerInfoV2().SetSegmentPerWidth = cont.getContainerInfoV2().SetSegmentPerWidth;
                    }
                    renderedContainer.components.add(comp);
                    if (StiOptions.Engine.isAllowForceCanBreakForCrossTabPrintOnAllPages() && component instanceof StiCrossTab && ((StiCrossTab)component).getPrintTitleOnAllPages()) {
                        renderedContainer.setCanBreak(true);
                    }
                    if (!StiOptions.Engine.getAllowInteractionInChartWithComponents() || (chart = (StiChart)(comp instanceof StiChart ? comp : null)) == null || chart.getChartInfoV2().interactiveComps == null) continue;
                    for (StiComponent stiComponent : chart.getChartInfoV2().interactiveComps) {
                        stiComponent.setLeft(stiComponent.getLeft() + comp.getLeft());
                        stiComponent.setTop(stiComponent.getTop() + comp.getTop());
                        renderedContainer.components.add(stiComponent);
                    }
                }
            }
        }
        if (!masterContainer.getReport().engine.getDenyRenderMasterComponentsInContainer() && !(masterContainer instanceof IStiComponentsOwnerRenderer)) {
            stiComponentsCollection = masterContainer.components;
            synchronized (stiComponentsCollection) {
                for (StiComponent component : masterContainer.components) {
                    component.parentBookmark = masterContainer.getCurrentBookmark();
                    component.parentPointer = masterContainer.currentPointer;
                    if (component.getComponentType() != StiComponentType.Master) continue;
                    component.render();
                    if (!(component instanceof StiDataBand)) continue;
                    isSubReportMode = true;
                }
            }
        }
        if (isSubReportMode) {
            boolean skipStaticBands = false;
            StiContainer container = masterContainer;
            while (true) {
                if (container instanceof StiPageHeaderBand || container instanceof StiPageFooterBand || container instanceof StiReportTitleBand || container instanceof StiReportSummaryBand) {
                    skipStaticBands = true;
                    break;
                }
                if (container == null || container instanceof StiPage) break;
                container = container.parent;
            }
            StiSubReportsHelper.RenderDataBandsInContainer(renderedContainer, masterContainer, skipStaticBands);
        }
        if (masterContainer.getPage() != null && masterContainer.getPage().getReport() != null) {
            renderedContainer.engine = masterContainer.getPage().getReport().getEngine();
        }
        double reservedWidth = renderedContainer.getWidth();
        StiContainerHelper.checkSize(renderedContainer);
        if (!renderedContainer.ParentComponentIsCrossBand) {
            renderedContainer.setWidth(reservedWidth);
        }
        return renderedContainer;
    }
}

