/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.engine.engineV2.builders;

import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiDataHelper;
import com.stimulsoft.report.components.StiFilterHelper;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.engine.StiChartInteractionHelper;
import com.stimulsoft.report.engine.engineV2.builders.StiComponentV2Builder;

public class StiChartV2Builder
extends StiComponentV2Builder {
    public static void RenderAtEnd(StiChart masterChart) {
        if (masterChart.getChartInfoV2().storedForProcessAtEndChart != null) {
            StiChartV2Builder.RenderChart(masterChart);
        }
        masterChart.getChartInfoV2().storedForProcessAtEndChart = null;
    }

    public static StiComponent RenderChart(StiChart masterChart) {
        StiChart chartComp = null;
        if (masterChart.getChartInfoV2().storedForProcessAtEndChart != null) {
            chartComp = masterChart.getChartInfoV2().storedForProcessAtEndChart instanceof StiChart ? masterChart.getChartInfoV2().storedForProcessAtEndChart : null;
        } else {
            chartComp = (StiChart)masterChart.clone();
            if (masterChart.getProcessAtEnd()) {
                return chartComp;
            }
        }
        if (!StiOptions.Engine.getDontSaveDataSourceBeforeChartRendering()) {
            masterChart.saveState("ChartRender");
        }
        if (masterChart.getMasterComponent() == null) {
            StiDataHelper.SetData(masterChart, true, masterChart.getParent() instanceof StiComponent ? masterChart.getParent() : null);
        }
        StiChartHelper.CreateChart(masterChart, chartComp);
        if (!StiOptions.Engine.getDontSaveDataSourceBeforeChartRendering()) {
            masterChart.RestoreState("ChartRender");
        }
        if (StiOptions.Engine.getRenderChartAsBitmap()) {
            StiImage image = StiChartHelper.GetImageFromChart(chartComp);
            image.setImageRotation(chartComp.getRotation());
            switch (chartComp.getRotation()) {
                case Rotate90CCW: 
                case Rotate90CW: {
                    double width = image.getHeight();
                    image.setHeight(image.getWidth());
                    image.setWidth(width);
                }
            }
            return image;
        }
        return chartComp;
    }

    @Override
    public void Prepare(StiComponent masterComp) {
        super.Prepare(masterComp);
        StiFilterHelper.SetFilter(masterComp);
        if (masterComp.getHeight() > masterComp.getPage().getHeight() || masterComp.getHeight() > masterComp.getParent().getHeight()) {
            masterComp.setHeight(Math.min(masterComp.getPage().getHeight(), masterComp.getParent().getHeight()));
        }
    }

    @Override
    public StiComponent InternalRender(StiComponent masterComp) {
        StiChart masterChart = (StiChart)(masterComp instanceof StiChart ? masterComp : null);
        StiComponent component = StiChartV2Builder.RenderChart(masterChart);
        StiChart childChart = (StiChart)(component instanceof StiChart ? component : null);
        if (masterChart.getProcessAtEnd()) {
            masterChart.getChartInfoV2().storedForProcessAtEndChart = (StiChart)(component instanceof StiChart ? component : null);
        }
        StiChartInteractionHelper.ProcessChart(masterChart, childChart);
        return component;
    }
}

