/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.databases;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.utils.Base64;
import com.stimulsoft.base.utils.StiCharsetHelper;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class StiEncryptionConnectionString {
    private long randomSeed = 0L;
    private final int rand_m = 714025;
    private final int rand_a = 4096;
    private final int rand_c = 150889;

    public int[] encrypt(int[] src, int[] key) {
        return this.encryptAdv(src, key);
    }

    public byte[] encrypt(byte[] src, String password) throws NoSuchAlgorithmException {
        int[] byteKey = this.getKeyFromPassword(password);
        return this.toB(this.encryptAdv(this.toI(src), byteKey));
    }

    public String encrypt(String src, String password) throws NoSuchAlgorithmException {
        int[] byteSrc = src != null ? this.toI(StiCharsetHelper.UTF8.encode(src).array()) : new int[]{};
        int[] byteKey = this.getKeyFromPassword(password);
        int[] dst = this.encryptAdv(byteSrc, byteKey);
        return Base64.encode((byte[])this.toB(dst));
    }

    public int[] decrypt(int[] src, int[] key) {
        return this.decryptAdv(src, key);
    }

    public int[] decrypt(int[] src, String password) throws NoSuchAlgorithmException {
        int[] byteKey = this.getKeyFromPassword(password);
        return this.decryptAdv(src, byteKey);
    }

    public String decrypt(String src, String password) throws NoSuchAlgorithmException {
        int[] byteSrc = this.toI(Base64.decode((String)src));
        int[] byteKey = this.getKeyFromPassword(password);
        int[] dst = this.decryptAdv(byteSrc, byteKey);
        return StiCharsetHelper.UTF8.decode(ByteBuffer.wrap(this.toB(dst))).toString();
    }

    public int[] generateRandomKey() {
        int[] key = new int[32];
        Random random = new Random();
        for (int index = 0; index < 32; ++index) {
            key[index] = random.nextInt(255);
        }
        return key;
    }

    private int[] encryptAdv(int[] src, int[] key) {
        int[] dst = new int[src.length];
        dst = this.cryptRandom(src, key, true);
        dst = this.cryptXor(dst, key);
        dst = this.cryptShift(dst, key, true);
        return dst;
    }

    private int[] decryptAdv(int[] src, int[] key) {
        int[] dst = new int[src.length];
        dst = this.cryptShift(src, key, false);
        dst = this.cryptXor(dst, key);
        dst = this.cryptRandom(dst, key, false);
        return dst;
    }

    private int[] cryptXor(int[] src, int[] key) {
        int[] dst = new int[src.length];
        int pos = 0;
        int keyPos = 0;
        while (pos < src.length) {
            if (keyPos >= key.length) {
                keyPos = 0;
            }
            dst[pos] = src[pos] ^ key[keyPos];
            ++pos;
            ++keyPos;
        }
        return dst;
    }

    private int[] cryptShift(int[] src, int[] key, boolean encrypt) {
        int[] dst = new int[src.length];
        int pos = 0;
        int keyPos = 0;
        while (pos < src.length) {
            if (keyPos >= key.length) {
                keyPos = 0;
            }
            dst[pos] = encrypt ? this.shiftLeft(src[pos], key[keyPos]) : this.shiftRight(src[pos], key[keyPos]);
            ++pos;
            ++keyPos;
        }
        return dst;
    }

    private int shiftLeft(int value, int count) {
        int res = value << (count & 7);
        res = res & 0xFF | (res & 0xFF00) >> 8;
        return res;
    }

    private int shiftRight(int value, int count) {
        int res = value << 8 - (count & 7);
        res = res & 0xFF | (res & 0xFF00) >> 8;
        return res;
    }

    private int[] cryptRandom(int[] src, int[] key, boolean encrypt) {
        int[] dst = new int[src.length];
        this.setRandomSeed(key);
        int[] randomMix = this.getMixArray(src.length);
        for (int pos = 0; pos < src.length; ++pos) {
            if (encrypt) {
                dst[pos] = src[randomMix[pos]];
                continue;
            }
            dst[randomMix[pos]] = src[pos];
        }
        return dst;
    }

    private int[] getMixArray(int count) {
        int[] check = new int[count];
        int[] mix = new int[count];
        for (int index = 0; index < count; ++index) {
            check[index] = index;
        }
        for (int indexMix = 0; indexMix < count; ++indexMix) {
            int rnd = this.getRandom(0, count - indexMix - 1);
            mix[indexMix] = check[rnd];
            check[rnd] = check[count - indexMix - 1];
        }
        return mix;
    }

    private void setRandomSeed(int[] key) {
        this.randomSeed = key[0] | key[1] << 8 | key[key.length - 2] << 16 | key[key.length - 1] << 24;
        if (this.randomSeed < 0L) {
            this.randomSeed = 0x100000000L + this.randomSeed;
        }
        this.randomSeed %= 714025L;
        if (this.randomSeed < 0L) {
            this.randomSeed = 0xFFFFFFL - this.randomSeed & 0xFFFFFFL;
        }
    }

    private int getRandom(int min, int max) {
        this.randomSeed = (this.randomSeed * 4096L + 150889L) % 714025L;
        int jran = (int)((long)min + (long)(max - min + 1) * this.randomSeed / 714025L);
        return jran;
    }

    private int[] getKeyFromPassword(String password) throws NoSuchAlgorithmException {
        try {
            ByteArrayOutputStream ms = new ByteArrayOutputStream();
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(password.getBytes("UTF8"));
            ms.write(hash, 0, hash.length);
            for (int pos = hash.length; pos < password.length(); pos += hash.length) {
                ms.write(hash, 0, pos + (hash = md.digest(password.substring(0, pos).getBytes("UTF8"))).length < password.length() ? hash.length : password.length() - pos);
            }
            return this.toI(ms.toByteArray());
        }
        catch (Exception e) {
            throw new NoSuchAlgorithmException(e);
        }
    }

    public byte[] toB(int[] in) {
        byte[] out = new byte[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = (byte)in[i];
        }
        return out;
    }

    public int[] toI(byte[] in) {
        int[] out = new int[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i] < 0 ? 256 + in[i] : in[i];
        }
        return out;
    }

    public static void main(String[] args) throws NoSuchAlgorithmException, UnsupportedEncodingException, StiException {
    }
}

