/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.databases;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.lib.utils.StiCollectionsUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.dictionary.StiDictionary;
import com.stimulsoft.report.dictionary.databases.StiDatabase;
import com.stimulsoft.report.dictionary.databases.StiDatabaseEmpty;
import java.util.ArrayList;
import java.util.List;

public class StiDatabaseCollection
extends ArrayList<StiDatabase>
implements IStiJsonReportObject {
    private static final long serialVersionUID = -5911917428286313711L;
    private StiDictionary stiDictionary;

    public StiDatabaseCollection(StiDictionary stiDictionary) {
        this.stiDictionary = stiDictionary;
    }

    public StiDatabaseCollection() {
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        if (this.size() == 0) {
            return null;
        }
        JSONObject jObject = new JSONObject();
        Integer index = 0;
        for (StiDatabase database : this) {
            jObject.AddPropertyJObject(index.toString(), database.SaveToJsonObject(mode));
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        List<Class<?>> classes = StiOptions.Services.getDataBases();
        for (JProperty property : jObject.Properties()) {
            JSONObject propJObject = (JSONObject)property.Value;
            String ident = (String)propJObject.Properties().FirstOrDefault((String)"Ident").Value;
            Class<?> clazz = null;
            for (Class<?> claz : classes) {
                String name = claz.getName();
                if (!name.substring(name.lastIndexOf(46) + 1).equals(ident)) continue;
                clazz = claz;
            }
            if (clazz == null) continue;
            StiDatabase database = null;
            try {
                database = (StiDatabase)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            database.LoadFromJsonObject((JSONObject)property.Value);
            this.add(database);
        }
    }

    public StiDatabase get(String databaseName) {
        return (StiDatabase)StiCollectionsUtil.getElement((ArrayList)this, (String)databaseName, StiDatabaseEmpty.class, (boolean)false);
    }

    public int indexOf(String name, boolean ignoreCase) {
        if (name == null) {
            return -1;
        }
        if (ignoreCase) {
            name = name.toLowerCase();
        }
        int index = 0;
        for (StiDatabase d : this) {
            if (name.equals(ignoreCase && d.getName() != null ? d.getName().toLowerCase() : d.getName())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void remove(String name, boolean ignoreCase, boolean throwException) {
        int index = this.indexOf(name, ignoreCase);
        if (index != -1) {
            this.remove(index);
        } else if (throwException) {
            throw new RuntimeException(String.format("The database '%s' is not found", name));
        }
    }
}

