/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.dataSources;

import com.stimulsoft.base.DBNull;
import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.StiSerializedObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableRef;
import com.stimulsoft.lib.commoninterface.IStiName;
import com.stimulsoft.lib.utils.StiTypeConverter;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.ICloneable;
import com.stimulsoft.report.IStiAlias;
import com.stimulsoft.report.IStiInherited;
import com.stimulsoft.report.IStiStateSaveRestore;
import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiStatesManager;
import com.stimulsoft.report.StiTotals;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiGroupHeaderBand;
import com.stimulsoft.report.components.bands.StiHierarchicalBand;
import com.stimulsoft.report.components.enums.StiGroupSortDirection;
import com.stimulsoft.report.components.enums.StiGroupSummaryType;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.dictionary.IStiEnumerator;
import com.stimulsoft.report.dictionary.StiCalcDataColumn;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataColumnsCollection;
import com.stimulsoft.report.dictionary.StiDataParameter;
import com.stimulsoft.report.dictionary.StiDataParametersCollection;
import com.stimulsoft.report.dictionary.StiDataRelation;
import com.stimulsoft.report.dictionary.StiDataRelationsCollection;
import com.stimulsoft.report.dictionary.StiDataRow;
import com.stimulsoft.report.dictionary.StiDataSort;
import com.stimulsoft.report.dictionary.StiDictionary;
import com.stimulsoft.report.dictionary.StiGroupSummaryDataSort;
import com.stimulsoft.report.dictionary.StiHierarchicalDataSort;
import com.stimulsoft.report.dictionary.StiRowsCollection;
import com.stimulsoft.report.dictionary.StiSort;
import com.stimulsoft.report.dictionary.adapters.StiDataAdapterService;
import com.stimulsoft.report.dictionary.data.DataRow;
import com.stimulsoft.report.dictionary.data.DataTable;
import com.stimulsoft.report.dictionary.dataSources.StiDataTableSource;
import com.stimulsoft.report.dictionary.dataSources.StiSqlSource;
import com.stimulsoft.report.dictionary.databases.StiDatabase;
import com.stimulsoft.report.dictionary.enums.StiConnectionOrder;
import com.stimulsoft.report.engine.StiEngineVersion;
import com.stimulsoft.report.engine.StiParserParameters;
import com.stimulsoft.report.engine.engineV2.builders.StiDataBandV2Builder;
import com.stimulsoft.report.engine.engineV2.builders.StiGroupHeaderBandV2Builder;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.engine.parser.StiParserData;
import com.stimulsoft.report.enums.StiCalculationMode;
import com.stimulsoft.report.events.StiFilterEventArgs;
import com.stimulsoft.report.events.StiFilterEventHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class StiDataSource
extends StiSerializedObject
implements IStiSerializableRef,
Cloneable,
IStiStateSaveRestore,
IStiEnumerator,
IStiName,
IStiInherited,
IStiJsonReportObject,
IStiAlias,
ICloneable {
    private static final Logger LOGGER = Logger.getLogger("com.stimulsoft.report.dictionary.dataSources.StiDataSource");
    private boolean inherited;
    private String name;
    private int positionValue;
    private boolean isBofValue;
    private boolean isEofValue;
    private StiStatesManager states;
    private String nameOfDataBandWhichInitDataSource = "";
    private boolean isInited;
    public boolean initForSubreport;
    private String relationNameStored;
    private Object resFilterMethod;
    private ArrayList<String> resSortColumns;
    private StiDataAdapterService DataAdapterService;
    private StiDataParametersCollection parameters;
    private List<StiDataParameter> variableParameters = new ArrayList<StiDataParameter>();
    private StiRowsCollection rows;
    protected Hashtable<String, Integer> columnsIndexs;
    public ArrayList<DataRow> detailRows;
    public Hashtable RowToLevel;
    public boolean connectOnStart = true;
    public Integer connectionOrder = StiConnectionOrder.Standard.getValue();
    private DataTable dataTable;
    private StiDictionary dictionary;
    private String alias;
    public StiDataColumnsCollection columns;
    private String key = null;

    @StiSerializable
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public StiDataSource() {
        this("", "");
    }

    public StiDataSource(String name, String alias) {
        this.setName(name);
        this.setAlias(alias);
        if (this.getAlias() == null || this.getAlias().length() == 0) {
            this.setAlias(name);
        }
        this.rows = new StiRowsCollection(this);
        this.columns = new StiDataColumnsCollection(this);
        this.parameters = new StiDataParametersCollection(this);
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="false")
    public final boolean getInherited() {
        return this.inherited;
    }

    @Override
    public final void setInherited(boolean value) {
        this.inherited = value;
    }

    private Object getCurrent() {
        return this;
    }

    private boolean MoveNext() {
        this.Next();
        return !this.getIsEof();
    }

    private void Reset() {
        this.First();
    }

    public abstract Class<? extends StiDatabase> getDatabaseClass();

    @StiSerializable
    public final String getName() {
        return this.name;
    }

    public final void setName(String value) {
        if (this.getDictionary() != null && this.getDictionary().getReport() != null && this.getDictionary().getReport().getIsDesigning() && StiOptions.Designer.getAutoCorrectDataSourceName()) {
            value = StiNameValidator.CorrectName(value);
        }
        this.name = StiNameValidator.CorrectName(value);
    }

    public void setCorrectName(String correctName) {
        this.name = correctName;
    }

    @Override
    public int getPosition() {
        return this.positionValue;
    }

    @Override
    public void setPosition(int value) {
        this.positionValue = value;
    }

    public final int getRealCount() {
        if (this.detailRows != null) {
            return this.detailRows.size();
        }
        return this.getDataTable() == null ? 0 : this.getDataTable().getRows().size();
    }

    @Override
    public final int getCount() {
        if (this.getRealCount() == 0 && StiOptions.Engine.getEmulateData()) {
            if (this.getDataTable() == null) {
                return 1;
            }
            if (this.getDataTable() != null && this.getDataTable().getRows().size() == 0) {
                return 1;
            }
        }
        return this.getRealCount();
    }

    @Override
    public boolean getIsBof() {
        if (this.getIsEmpty()) {
            return true;
        }
        return this.isBofValue;
    }

    @Override
    public void setIsBof(boolean value) {
        this.isBofValue = value;
    }

    @Override
    public boolean getIsEof() {
        if (this.getIsEmpty()) {
            return true;
        }
        return this.isEofValue;
    }

    @Override
    public void setIsEof(boolean value) {
        this.isEofValue = value;
    }

    @Override
    public boolean getIsEmpty() {
        return this.getCount() == 0;
    }

    @Override
    public void First() {
        this.positionValue = 0;
        this.isEofValue = false;
        this.isBofValue = true;
    }

    @Override
    public void Prior() {
        this.isBofValue = false;
        this.isEofValue = false;
        if (this.positionValue <= 0) {
            this.isBofValue = true;
        } else {
            --this.positionValue;
        }
    }

    @Override
    public void Next() {
        this.isBofValue = false;
        this.isEofValue = false;
        if (this.positionValue >= this.getCount() - 1) {
            this.isEofValue = true;
            return;
        }
        ++this.positionValue;
    }

    @Override
    public void Last() {
        this.positionValue = this.getCount() - 1;
        this.isEofValue = true;
        this.isBofValue = false;
    }

    protected final StiStatesManager getStates() {
        if (this.states == null) {
            this.states = new StiStatesManager();
        }
        return this.states;
    }

    @Override
    public void saveState(String stateName) {
        this.getStates().PushInt(stateName, this, "positionValue", this.positionValue);
        this.getStates().PushBool(stateName, this, "isEofValue", this.isEofValue);
        this.getStates().PushBool(stateName, this, "isBofValue", this.isBofValue);
        this.getStates().Push(stateName, this, "detailRows", this.detailRows);
    }

    public void ClearAllStates() {
        this.states = null;
    }

    private boolean IsEqualSort(ArrayList<String> sortColumns1, ArrayList<String> sortColumns2) {
        if (sortColumns1 == null && sortColumns2 == null) {
            return true;
        }
        if (sortColumns1 != null && sortColumns2 == null) {
            return false;
        }
        if (sortColumns1 == null && sortColumns2 != null) {
            return false;
        }
        if (sortColumns1.size() != sortColumns2.size()) {
            return false;
        }
        int index = 0;
        for (String str : sortColumns1) {
            if (!sortColumns2.get(index).equals(str)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public final void SetData(StiDataBand dataBand, String relationName, Object filterMethod, ArrayList<String> sortColumns, boolean reinit, StiComponent component) {
        boolean reconnectOnEachRow = false;
        if (this instanceof StiSqlSource) {
            reconnectOnEachRow = ((StiSqlSource)this).getReconnectOnEachRow();
        }
        if (this.resFilterMethod != filterMethod) {
            this.isInited = false;
        }
        if (!this.IsEqualSort(sortColumns, this.resSortColumns)) {
            this.isInited = false;
        }
        if (dataBand != null) {
            if (!this.nameOfDataBandWhichInitDataSource.equals(dataBand.getName())) {
                this.isInited = false;
            }
            this.nameOfDataBandWhichInitDataSource = dataBand.getName();
        }
        if (!reconnectOnEachRow && this.isInited && !reinit && !this.initForSubreport && this.relationNameStored != null && this.relationNameStored.equals(relationName)) {
            return;
        }
        this.initForSubreport = false;
        this.resFilterMethod = filterMethod;
        this.resSortColumns = sortColumns;
        ArrayList<StiGroupHeaderBand> groupHeaderComponents = null;
        if (dataBand != null) {
            groupHeaderComponents = dataBand.getDataBandInfoV2().GroupHeaders;
        }
        this.detailRows = null;
        this.SetDetails(relationName);
        if (StiOptions.Engine.isFilterDataInDataSourceBeforeSorting()) {
            this.SetFilter(filterMethod);
        }
        Object[][][] conditions = this.GetConditions(dataBand);
        this.SetSort(conditions, sortColumns, component, dataBand, groupHeaderComponents);
        if (!StiOptions.Engine.isFilterDataInDataSourceBeforeSorting()) {
            this.SetFilter(filterMethod);
        }
        this.isInited = true;
        relationName = this.relationNameStored;
    }

    public final Object[][][] GetConditions(StiDataBand dataBand) {
        Object[][][] conditions = null;
        if (dataBand == null) {
            return conditions;
        }
        ArrayList<StiGroupHeaderBand> groupHeaderComponents = null;
        groupHeaderComponents = dataBand.getReport().getEngineVersion() == StiEngineVersion.EngineV1 ? dataBand.getDataBandInfoV2().GroupHeaderComponents : dataBand.getDataBandInfoV2().GroupHeaders;
        if (groupHeaderComponents != null && groupHeaderComponents.size() > 0) {
            boolean resIsEof = dataBand.getIsEof();
            boolean resIsBof = dataBand.getIsBof();
            int groupCount = 0;
            for (StiGroupHeaderBand groupHeader : groupHeaderComponents) {
                if (groupHeader.getSortDirection() == StiGroupSortDirection.None) continue;
                ++groupCount;
            }
            if (groupCount == 0) {
                return conditions;
            }
            conditions = new Object[dataBand.getCount()][groupCount][2];
            for (int index = 0; index < dataBand.getCount(); ++index) {
                dataBand.setPosition(index);
                int groupIndex = 0;
                for (StiGroupHeaderBand groupHeader : groupHeaderComponents) {
                    if (groupHeader.getSortDirection() == StiGroupSortDirection.None) continue;
                    conditions[index][groupIndex][0] = StiGroupHeaderBandV2Builder.GetCurrentConditionValue(groupHeader);
                    conditions[index][groupIndex][1] = groupHeader.getSortDirection();
                    ++groupIndex;
                }
            }
            dataBand.setIsEof(resIsEof);
            dataBand.setIsBof(resIsBof);
        }
        return conditions;
    }

    public final void SetDetails(String relationName) {
        if (relationName != null && relationName.length() > 0) {
            DataTable dataTable;
            StiDataSource table;
            StiDataRelation relation = this.getRelations(relationName);
            StiDataSource stiDataSource = table = relation.getParentSource() instanceof StiDataSource ? relation.getParentSource() : null;
            if (table != null && (dataTable = table.getDataTable()) != null) {
                if (table.detailRows != null) {
                    if (table.detailRows.size() != 0) {
                        if (table.getPosition() < table.detailRows.size()) {
                            DataRow pRow = table.detailRows.get(table.getPosition());
                            this.detailRows = relation.getChildRows(pRow, relationName);
                        } else {
                            this.detailRows = new ArrayList();
                        }
                    } else {
                        this.detailRows = table.detailRows;
                    }
                } else if (table.getPosition() < dataTable.getRows().size()) {
                    DataRow pRow = (DataRow)dataTable.getRows().get(table.getPosition());
                    this.detailRows = relation.getChildRows(pRow, relationName);
                }
            }
        }
    }

    public StiDataRelation getRelations(String relationName) {
        return this.getDictionary().getRelation(relationName);
    }

    public final void SetFilter(Object filterMethod) {
        if (filterMethod != null && this.getRealCount() > 0) {
            int resPos = this.getPosition();
            int resLine = this.getDictionary().getReport().getLine();
            ArrayList rows = new ArrayList();
            if (filterMethod instanceof StiFilterEventHandler) {
                StiFilterEventHandler filterMethod2 = (StiFilterEventHandler)filterMethod;
                for (int pos = 0; pos < this.getCount(); ++pos) {
                    this.setPosition(pos);
                    this.getDictionary().getReport().setLine(pos + 1);
                    StiFilterEventArgs args = new StiFilterEventArgs();
                    if (!args.getValue()) continue;
                    if (this.detailRows == null) {
                        rows.add(this.getDataTable().getRows().get(pos));
                        continue;
                    }
                    rows.add(this.detailRows.get(pos));
                }
            } else if (filterMethod instanceof StiParser.StiFilterParserData) {
                StiParser.StiFilterParserData data = (StiParser.StiFilterParserData)filterMethod;
                for (int pos = 0; pos < this.getCount(); ++pos) {
                    this.setPosition(pos);
                    this.getDictionary().getReport().setLine(pos + 1);
                    try {
                        Object result = StiParser.ParseTextValue(data.Expression, data.Component);
                        if (!(result instanceof Boolean) || !((Boolean)result).booleanValue()) continue;
                        if (this.detailRows == null) {
                            rows.add(this.getDataTable().getRows().get(pos));
                            continue;
                        }
                        rows.add(this.detailRows.get(pos));
                        continue;
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel < 10) continue;
                        e.printStackTrace();
                    }
                }
            }
            this.detailRows = rows;
            this.setPosition(resPos);
            this.getDictionary().getReport().setLine(resLine);
        }
    }

    public final void SetSort(Object[][][] conditions, ArrayList<String> sortColumns, StiComponent component, StiDataBand databand, ArrayList<StiGroupHeaderBand> groupHeaders) {
        if (component instanceof StiHierarchicalBand) {
            if (this.getRealCount() == 0) {
                return;
            }
            if (this.detailRows == null && this.getDataTable() != null) {
                this.detailRows = new ArrayList();
                this.detailRows = this.getDataTable().getRows();
            }
            Hashtable<DataRow, Integer> rowToConditions = new Hashtable<DataRow, Integer>();
            int index = 0;
            for (DataRow row : this.detailRows) {
                rowToConditions.put(row, index++);
            }
            StiHierarchicalDataSort hierarchicalSort = new StiHierarchicalDataSort(this, (StiHierarchicalBand)(component instanceof StiHierarchicalBand ? component : null), sortColumns);
            hierarchicalSort.Process(rowToConditions);
            return;
        }
        if ((conditions != null || sortColumns != null) && this.getRealCount() > 0) {
            boolean bl;
            ArrayList<DataRow> listOfDetailRows = new ArrayList<DataRow>();
            if (this.detailRows == null && this.getDataTable() != null) {
                for (DataRow row : this.dataTable.getRows()) {
                    listOfDetailRows.add(row);
                }
            }
            if (this.detailRows != null) {
                for (DataRow row : this.detailRows) {
                    listOfDetailRows.add(row);
                }
            }
            Hashtable<DataRow, Integer> rowToConditions = new Hashtable<DataRow, Integer>();
            int index = 0;
            for (DataRow dataRow : listOfDetailRows) {
                rowToConditions.put(dataRow, index++);
            }
            StiDataSort dataSort = new StiDataSort(rowToConditions, conditions, StiSort.creatByStringArray(sortColumns), this);
            Collections.sort(listOfDetailRows, dataSort);
            this.detailRows = new ArrayList();
            for (DataRow dataRow : listOfDetailRows) {
                this.detailRows.add(dataRow);
            }
            boolean bl2 = false;
            if (groupHeaders != null) {
                for (StiGroupHeaderBand group : groupHeaders) {
                    if (group.getSummarySortDirection() == StiGroupSortDirection.None) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                Hashtable<StiGroupHeaderBand, Hashtable<DataRow, Object>> hashtable = new Hashtable<StiGroupHeaderBand, Hashtable<DataRow, Object>>();
                Hashtable<StiGroupHeaderBand, Hashtable<DataRow, Object>> groupLines = new Hashtable<StiGroupHeaderBand, Hashtable<DataRow, Object>>();
                int[] groupLinesArray = new int[groupHeaders.size()];
                Hashtable<DataRow, Integer> baseRowOrder = new Hashtable<DataRow, Integer>();
                int pos = 0;
                for (DataRow row : listOfDetailRows) {
                    databand.setPosition(pos);
                    baseRowOrder.put(row, pos);
                    StiDataBandV2Builder.PrepareGroupResults(databand);
                    int groupIndex = 0;
                    for (StiGroupHeaderBand group : groupHeaders) {
                        Hashtable<DataRow, Object> rows;
                        String methodName = null;
                        Object bandData = group;
                        if (group.getSummaryType() != StiGroupSummaryType.Count) {
                            if (StiValidationUtil.isNullOrEmpty((String)group.getSummaryExpression().getValue())) continue;
                            StiParserParameters parserParameters = new StiParserParameters(group.getSummaryExpression().getValue(), group, group, false, false, true, false);
                            ArrayList asmList = (ArrayList)StiParser.ParseTextValue(parserParameters);
                            bandData = new StiParserData(group, asmList, parserParameters.parser);
                        }
                        Object value = null;
                        switch (group.getSummaryType()) {
                            case Avg: {
                                try {
                                    value = StiTypeConverter.ChangeType((BigDecimal)StiTotals.Avg(bandData, group.getReport(), methodName), BigDecimal.class);
                                }
                                catch (Exception asmList) {}
                                break;
                            }
                            case AvgDate: {
                                try {
                                    value = StiTypeConverter.ChangeType((Date)StiTotals.AvgDate(bandData, group.getReport(), methodName), Date.class);
                                }
                                catch (Exception asmList) {}
                                break;
                            }
                            case AvgTime: {
                                try {
                                    value = StiTypeConverter.ChangeType((Calendar)StiTotals.AvgTime(bandData, group.getReport(), methodName), Calendar.class);
                                }
                                catch (Exception asmList) {}
                                break;
                            }
                            case Count: {
                                try {
                                    value = StiTotals.Count(group);
                                }
                                catch (Exception asmList) {}
                                break;
                            }
                            case CountDistinct: {
                                try {
                                    value = StiTotals.CountDistinct(group, group.getReport(), methodName);
                                }
                                catch (Exception asmList) {}
                                break;
                            }
                            case Max: {
                                try {
                                    value = StiTypeConverter.ChangeType((BigDecimal)StiTotals.Max(bandData, group.getReport(), methodName), BigDecimal.class);
                                }
                                catch (Exception asmList) {}
                                break;
                            }
                            case MaxDate: {
                                try {
                                    value = StiTypeConverter.ChangeType((Date)StiTotals.MaxDate(bandData, group.getReport(), methodName), Date.class);
                                }
                                catch (Exception asmList) {}
                                break;
                            }
                            case MaxTime: {
                                try {
                                    value = StiTypeConverter.ChangeType((Calendar)StiTotals.MaxTime(bandData, group.getReport(), methodName), Calendar.class);
                                }
                                catch (Exception asmList) {}
                                break;
                            }
                            case Median: {
                                try {
                                    value = StiTypeConverter.ChangeType((BigDecimal)StiTotals.Median(bandData, group.getReport(), methodName), BigDecimal.class);
                                }
                                catch (Exception asmList) {}
                                break;
                            }
                            case Min: {
                                try {
                                    value = StiTypeConverter.ChangeType((BigDecimal)StiTotals.Min(bandData, group.getReport(), methodName), BigDecimal.class);
                                }
                                catch (Exception asmList) {}
                                break;
                            }
                            case MinDate: {
                                try {
                                    value = StiTypeConverter.ChangeType((Date)StiTotals.MinDate(bandData, group.getReport(), methodName), Date.class);
                                }
                                catch (Exception asmList) {}
                                break;
                            }
                            case MinTime: {
                                try {
                                    value = StiTypeConverter.ChangeType((Calendar)StiTotals.MinTime(bandData, group.getReport(), methodName), Calendar.class);
                                }
                                catch (Exception asmList) {}
                                break;
                            }
                            case Mode: {
                                try {
                                    value = StiTypeConverter.ChangeType((BigDecimal)StiTotals.Mode(bandData, group.getReport(), methodName), BigDecimal.class);
                                }
                                catch (Exception asmList) {}
                                break;
                            }
                            case Sum: {
                                try {
                                    value = StiTypeConverter.ChangeType((BigDecimal)StiTotals.Sum(bandData, group.getReport(), methodName), BigDecimal.class);
                                }
                                catch (Exception asmList) {}
                                break;
                            }
                            case SumTime: {
                                try {
                                    value = StiTypeConverter.ChangeType((Calendar)StiTotals.SumTime(bandData, group.getReport(), methodName), Calendar.class);
                                    break;
                                }
                                catch (Exception asmList) {
                                    // empty catch block
                                }
                            }
                        }
                        if (databand.getDataBandInfoV2().GroupHeaderResults[groupIndex]) {
                            int n = groupIndex;
                            groupLinesArray[n] = groupLinesArray[n] + 1;
                        }
                        if ((rows = (Hashtable<DataRow, Object>)(hashtable.get(group) instanceof Hashtable ? hashtable.get(group) : null)) == null) {
                            rows = new Hashtable<DataRow, Object>();
                            hashtable.put(group, rows);
                        }
                        rows.put(row, value);
                        rows = groupLines.get(group) instanceof Hashtable ? groupLines.get(group) : null;
                        if (rows == null) {
                            rows = new Hashtable<DataRow, Object>();
                            groupLines.put(group, rows);
                        }
                        rows.put(row, groupLinesArray[groupIndex]);
                        ++groupIndex;
                    }
                    ++pos;
                }
                if (hashtable != null && hashtable.size() > 0) {
                    StiGroupSummaryDataSort groupDataSort = new StiGroupSummaryDataSort(hashtable, groupLines, groupHeaders, baseRowOrder);
                    listOfDetailRows.sort(groupDataSort);
                    this.detailRows = new ArrayList();
                    for (DataRow row : listOfDetailRows) {
                        this.detailRows.add(row);
                    }
                }
            }
            dataSort.Clear();
        }
    }

    public final void ResetDetailsRows() {
        this.detailRows = null;
    }

    public final void ResetData() {
        this.isInited = false;
        this.relationNameStored = null;
        this.resFilterMethod = null;
        this.resSortColumns = null;
    }

    public final DataRow GetDataRow(int index) {
        if (this.detailRows == null) {
            if (this.getDataTable() != null && index < this.getDataTable().getRows().size()) {
                return this.getDataTable().getRows(index);
            }
            return null;
        }
        if (index < this.detailRows.size()) {
            return this.detailRows.get(index);
        }
        return null;
    }

    public final StiDataRow GetParentData(String relationName) {
        DataRow dataRow = this.GetDataRow(this.getPosition());
        StiDataRelation relations = this.getRelations(relationName);
        DataRow result = relations.getFirstParentRows(dataRow);
        return new StiDataRow(this.getRelations(relationName).getParentSource(), result);
    }

    public StiDataRelationsCollection GetParentRelations() {
        StiDataRelationsCollection relations = new StiDataRelationsCollection(this.getDictionary());
        if (this.getDictionary() == null) {
            return relations;
        }
        for (StiDataRelation relation : this.getDictionary().getRelations()) {
            if (relation.getChildSource() != this) continue;
            relations.add(relation);
        }
        return relations;
    }

    public List<StiDataRelation> fetchParentRelations(boolean activePreferred) {
        return activePreferred && this.GetParentRelations().stream().anyMatch(r -> r.isActive()) ? this.GetParentRelations().stream().filter(r -> r.isActive()).collect(Collectors.toList()) : this.GetParentRelations();
    }

    public StiDataRelationsCollection GetChildRelations() {
        StiDataRelationsCollection relations = new StiDataRelationsCollection(this.getDictionary());
        for (StiDataRelation relation : this.getDictionary().getRelations()) {
            if (relation.getParentSource() != this) continue;
            relations.add(relation);
        }
        return relations;
    }

    public StiDataSource GetParentDataSource(String relationName) {
        for (StiDataRelation relation : this.getDictionary().getRelations()) {
            if (relation.getChildSource() != this || !relationName.equals(relation.getNameInSource())) continue;
            return relation.getParentSource();
        }
        for (StiDataRelation relation : this.getDictionary().getRelations()) {
            if (relation.getChildSource() != this || !relationName.equals(StiNameValidator.CorrectName(relation.getNameInSource()))) continue;
            return relation.getParentSource();
        }
        return null;
    }

    public StiDataSource GetChildDataSource(String relationName) {
        for (StiDataRelation relation : this.getDictionary().getRelations()) {
            if (relation.getParentSource() != this || !relationName.equals(relation.getNameInSource())) continue;
            return relation.getChildSource();
        }
        return null;
    }

    public void prepareData() {
        this.InvokeConnecting();
    }

    protected final void InvokeConnecting() {
        boolean isCompilationMode = true;
        if (this.getDictionary() != null && this.getDictionary().getReport() != null && this.getDictionary().getReport().getCalculationMode() == StiCalculationMode.Interpretation) {
            isCompilationMode = false;
        }
        if (!isCompilationMode) {
            StiText tempText = new StiText();
            tempText.setName("**DataSourceParameter**");
            tempText.setPage(this.getDictionary().getReport().getPages().get(0));
            for (StiDataParameter param : this.getParameters()) {
                String paramValue = param.getValue() != null && param.getValue().indexOf("}") >= 0 && param.getValue().indexOf("{") >= 0 ? param.getValue() : "{" + param.getValue() + "}";
                param.setParameterValue(StiParser.ParseTextValue(paramValue, (StiComponent)tempText));
            }
        }
    }

    protected final void InvokeDisconnecting() {
    }

    protected StiDatabase getDatabase() {
        try {
            return this.getDictionary().getDatabases().get(this.GetCategoryName());
        }
        catch (RuntimeException e) {
            String err = "";
            if (this.getDictionary() == null) {
                err = "Dictionary is null";
            } else if (this.getDictionary().getDatabases() == null) {
                err = "Databeses is null";
            }
            if (this.getDictionary() != null && this.getDictionary().getReport() != null) {
                this.getDictionary().getReport().WriteToReportRenderingMessages(err + " for " + this + " " + this.getClass());
            }
            LOGGER.severe(err + " for " + this + " " + this.getClass());
            throw e;
        }
    }

    public void disconnect() {
        this.InvokeDisconnecting();
        this.RowToLevel = null;
        this.detailRows = null;
    }

    public final boolean getIsConnected() {
        return this.dataTable != null;
    }

    @StiSerializable
    public StiDataParametersCollection getParameters() {
        if (this.parameters != null) {
            for (StiDataParameter param : this.parameters) {
                param.setDataSource(this);
            }
        }
        return this.parameters;
    }

    public void setParameters(StiDataParametersCollection value) {
        this.parameters = value;
    }

    public Object getItem(String columnName) {
        return this.GetData(columnName);
    }

    public final Object GetData(String columnName) {
        return this.GetData(columnName, this.getPosition());
    }

    public final Object GetData(String columnName, int rowIndex) {
        if (this.getIsConnected()) {
            int columnIndex = this.GetColumnIndex(columnName);
            if (columnIndex < 0) {
                return null;
            }
            DataRow row = this.GetDataRow(rowIndex);
            if (row == null) {
                return null;
            }
            return row.getValue(columnIndex);
        }
        return DBNull.Value;
    }

    public final int GetColumnIndex(String columnName) {
        StiDataColumn column;
        if (this.columnsIndexs != null) {
            Integer index = this.columnsIndexs.get(columnName);
            if (index == null || index == -1) {
                index = this.columnsIndexs.get(columnName.toLowerCase());
            }
            if (index == null) {
                return -1;
            }
            return index;
        }
        int index = 0;
        Iterator iterator = this.getColumns().iterator();
        while (iterator.hasNext()) {
            column = (StiDataColumn)iterator.next();
            if (columnName.equals(column.getNameInSource())) {
                return index;
            }
            ++index;
        }
        index = 0;
        iterator = this.getColumns().iterator();
        while (iterator.hasNext()) {
            column = (StiDataColumn)iterator.next();
            if (columnName.equals(column.getName()) || columnName.equals(column.getAlias())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public final StiRowsCollection getRows() {
        return this.rows;
    }

    public final void setRows(StiRowsCollection value) {
        this.rows = value;
    }

    public final void CheckColumnsIndexs() {
        if ((this.columnsIndexs == null || this.columnsIndexs.keySet().size() == 0) && this.dataTable != null && this.getDataTable().getColumns().size() > 0) {
            this.columnsIndexs = new Hashtable();
            Hashtable<String, Integer> hashColumns = new Hashtable<String, Integer>();
            for (int index = 0; index < this.getDataTable().getColumns().size(); ++index) {
                hashColumns.put(((StiDataColumn)this.getDataTable().getColumns().get(index)).getNameInSource().toLowerCase(), index);
            }
            Iterator iterator = this.getColumns().iterator();
            while (iterator.hasNext()) {
                StiDataColumn column = (StiDataColumn)iterator.next();
                if (column instanceof StiCalcDataColumn) continue;
                int index = -1;
                Integer obj = (Integer)hashColumns.get(column.getNameInSource().toLowerCase());
                if (obj != null) {
                    index = obj;
                }
                this.columnsIndexs.put(column.getNameInSource().toLowerCase(), index);
                this.columnsIndexs.put(column.getNameInSource(), index);
                this.columnsIndexs.put(column.getName(), index);
                this.columnsIndexs.put(column.getAlias(), index);
                this.columnsIndexs.put(StiNameValidator.CorrectName(column.getName()), index);
            }
        }
    }

    public String toString() {
        if (StiOptions.Dictionary.getShowOnlyAliasForDatabase()) {
            return this.getAlias();
        }
        if (this.name.equals(this.alias) || StiValidationUtil.isNullOrEmpty((String)this.alias)) {
            return this.name;
        }
        return String.format("%1$s [%2$s]", this.getName(), this.getAlias());
    }

    public final int GetLevel() {
        if (this.RowToLevel == null) {
            return 0;
        }
        DataRow row = null;
        if (this.detailRows != null) {
            if (this.detailRows.size() <= this.getPosition()) {
                return 0;
            }
            row = this.detailRows.get(this.getPosition());
        } else {
            if (this.getDataTable() == null || this.getDataTable().getRows().size() <= this.getPosition()) {
                return 0;
            }
            row = (DataRow)this.getDataTable().getRows().get(this.getPosition());
        }
        Object value = this.RowToLevel.get(row);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    public String GetCategoryName() {
        StiDataAdapterService dataAdapter = StiDataAdapterService.GetDataAdapter(this);
        if (dataAdapter != null) {
            return dataAdapter.getServiceName();
        }
        return "";
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getConnectOnStart() {
        return this.connectOnStart;
    }

    public void setConnectOnStart(boolean value) {
        this.connectOnStart = value;
    }

    public final DataTable getDataTable() {
        return this.dataTable;
    }

    public abstract void connect() throws StiException;

    public abstract void connect(Boolean var1) throws StiException;

    public final void setDataTable(DataTable value) {
        if (StiOptions.Engine.logLevel >= 10) {
            LOGGER.info("SetDataTable: " + this.getName() + " value:" + value);
        }
        this.dataTable = value;
        this.detailRows = null;
        if (value != null) {
            this.CheckColumnsIndexs();
            if ((this instanceof StiDataTableSource && this.getDictionary().getReport().getCacheAllData() || this.dataTable.getDataSet() == null) && this.getDictionary().getCacheDataSet() != null) {
                int index = 0;
                String name = this.getDataTable().getTableName();
                while (this.getDictionary().getCacheDataSet().getTables().get(name) != null) {
                    name = this.getDataTable().getTableName() + new Integer(++index).toString();
                }
                if (!name.equals(this.getDataTable().getTableName())) {
                    this.getDataTable().setTableName(name);
                }
                this.getDictionary().getCacheDataSet().getTables().add(this.getDataTable());
            }
        }
        this.First();
    }

    @StiSerializable(isRef=true)
    public final StiDictionary getDictionary() {
        return this.dictionary;
    }

    public final void setDictionary(StiDictionary value) {
        this.dictionary = value;
    }

    @Override
    @StiSerializable
    public final String getAlias() {
        return this.alias;
    }

    @Override
    public final void setAlias(String value) {
        this.alias = value;
    }

    @StiSerializable
    public StiDataColumnsCollection getColumns() {
        return this.columns;
    }

    public void setColumns(StiDataColumnsCollection value) {
        this.columns = value;
    }

    public Object getData(String columnName, int rowIndex) {
        return this.GetData(columnName, rowIndex);
    }

    @Override
    public void restoreState(String stateName) {
        if (this.getStates().IsExist(stateName, this)) {
            this.isBofValue = this.getStates().PopBool(stateName, this, "isBofValue");
            this.isEofValue = this.getStates().PopBool(stateName, this, "isEofValue");
            this.positionValue = this.getStates().PopInt(stateName, this, "positionValue");
            this.detailRows = (ArrayList)this.getStates().Pop(stateName, this, "detailRows");
        }
    }

    public void RestoreState(String stateName) {
        if (this.getStates().IsExist(stateName, this)) {
            this.isBofValue = this.getStates().PopBool(stateName, this, "isBofValue");
            this.isEofValue = this.getStates().PopBool(stateName, this, "isEofValue");
            this.positionValue = this.getStates().PopInt(stateName, this, "positionValue");
            this.detailRows = (ArrayList)this.getStates().Pop(stateName, this, "detailRows");
        }
    }

    @Override
    public void clearAllStates() {
        this.states = null;
    }

    public boolean isEmpty() {
        return this.getIsEmpty();
    }

    public Object get(String columnName) {
        return this.GetData(columnName);
    }

    public void setPositionValue(int positionValue) {
        this.positionValue = positionValue;
    }

    public int getPositionValue() {
        return this.positionValue;
    }

    public int size() {
        return this.rows.getCount();
    }

    @Override
    public Object clone() {
        try {
            JSONObject json = this.SaveToJsonObject(StiJsonSaveMode.Document);
            StiDataSource result = (StiDataSource)this.getClass().newInstance();
            result.LoadFromJsonObject(json);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyBool("Inherited", this.getInherited());
        jObject.AddPropertyStringNullOfEmpty("Name", this.getName());
        jObject.AddPropertyStringNullOfEmpty("Alias", this.getAlias());
        jObject.AddPropertyStringNullOfEmpty("Key", this.getKey());
        jObject.AddPropertyJObject("Columns", this.getColumns().SaveToJsonObject(mode));
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Inherited")) {
                this.inherited = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("Name")) {
                this.name = (String)property.Value;
                continue;
            }
            if (property.Name.equals("IsCloud")) continue;
            if (property.Name.equals("Alias")) {
                this.alias = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Key")) {
                this.key = (String)property.Value;
                continue;
            }
            if (!property.Name.equals("Columns")) continue;
            this.columns.LoadFromJsonObject((JSONObject)property.Value);
        }
    }

    public List<StiDataParameter> getVariableParameters() {
        return this.variableParameters;
    }

    public void setVariableParameters(List<StiDataParameter> variableParameters) {
        this.variableParameters = variableParameters;
    }

    public StiDataParameter getVariableParameterByName(String name) {
        for (StiDataParameter param : this.variableParameters) {
            if (!name.equals(param.getName())) continue;
            return param;
        }
        return null;
    }

    public Object get(int index) {
        if (index < 0 || index >= this.columns.size()) {
            return null;
        }
        return this.GetData(((StiDataColumn)this.columns.get(index)).getNameInSource(), this.getPosition());
    }
}

