/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.aggregateFunctions;

import com.stimulsoft.base.DBNull;
import com.stimulsoft.base.StiObjectConverter;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiAggregateFunctionService;
import java.math.BigDecimal;

public class StiSumDecimalNullableFunctionService
extends StiAggregateFunctionService {
    private boolean hasValues;
    private double summary;

    public StiSumDecimalNullableFunctionService() {
    }

    public StiSumDecimalNullableFunctionService(boolean runningTotal) {
        super(runningTotal);
    }

    @Override
    public void CalcItem(Object value) {
        if (value == null || value == DBNull.Value) {
            return;
        }
        this.summary += (double)StiObjectConverter.ConvertToInt64((Object)value);
        this.hasValues = true;
    }

    @Override
    public boolean getRecureParam() {
        return true;
    }

    @Override
    public Class GetResultType() {
        return BigDecimal.class;
    }

    public String getServiceName() {
        return "SumNullable";
    }

    @Override
    public Object GetValue() {
        if (this.hasValues) {
            return this.summary;
        }
        return null;
    }

    @Override
    public void Init() {
        if (!this.getRunningTotal() || this.IsFirstInit) {
            this.summary = 0.0;
            this.hasValues = false;
        }
    }

    @Override
    public void SetValue(Object value) {
        if (value != null) {
            this.summary = ((Long)value).longValue();
            this.hasValues = true;
        } else {
            this.summary = 0.0;
            this.hasValues = false;
        }
    }
}

