/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary.aggregateFunctions;

import com.stimulsoft.base.DBNull;
import com.stimulsoft.base.StiObjectConverter;
import com.stimulsoft.report.dictionary.aggregateFunctions.StiAggregateFunctionService;
import java.math.BigDecimal;

public class StiMinDecimalFunctionService
extends StiAggregateFunctionService {
    private long minimum;

    public StiMinDecimalFunctionService() {
    }

    public StiMinDecimalFunctionService(boolean runningTotal) {
        super(runningTotal);
    }

    @Override
    public void CalcItem(Object value) {
        if (value == null || value == DBNull.Value) {
            return;
        }
        Long val = StiObjectConverter.ConvertToInt64((Object)value);
        if (this.minimum > val) {
            this.minimum = val;
        }
    }

    @Override
    public boolean getRecureParam() {
        return true;
    }

    @Override
    public Class GetResultType() {
        return BigDecimal.class;
    }

    public String getServiceName() {
        return "Min";
    }

    @Override
    public Object GetValue() {
        return this.minimum;
    }

    @Override
    public void Init() {
        if (!this.getRunningTotal() || this.IsFirstInit) {
            this.minimum = Long.MAX_VALUE;
        }
    }

    @Override
    public void SetValue(Object value) {
        this.minimum = (Long)value;
    }
}

