/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary;

import com.stimulsoft.base.StiLexer;
import com.stimulsoft.base.StiToken;
import com.stimulsoft.base.StiTokenType;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.dictionary.StiDataParameter;
import com.stimulsoft.report.dictionary.StiVariable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StiVariableAsParameterHelper {
    public static boolean parameterExists(List<StiToken> tokens, String name) {
        name = name.toLowerCase();
        for (int index = 1; index < tokens.size(); ++index) {
            StiToken prevToken = tokens.get(index - 1);
            StiToken token = tokens.get(index);
            if (prevToken.type != StiTokenType.Ampersand || token.type != StiTokenType.Ident || !(token.data instanceof String) || !StiValidationUtil.equals((Object)token.data.toString(), (Object)name)) continue;
            return true;
        }
        return false;
    }

    public static List<StiVariable> fetchAll(String query, List<StiDataParameter> parameters, StiReport report) {
        query = query.toLowerCase();
        List tokens = StiLexer.getAllTokens((String)query.toLowerCase());
        ArrayList<StiVariable> result = new ArrayList<StiVariable>();
        Iterator iterator = report.getDictionary().getVariables().iterator();
        while (iterator.hasNext()) {
            StiVariable variable = (StiVariable)iterator.next();
            if (!variable.isAllowUseAsSqlParameter() || !StiVariableAsParameterHelper.parameterExists(tokens, variable.getName()) || StiVariableAsParameterHelper.parameterExists2(parameters, variable.getName())) continue;
            result.add(variable);
        }
        return result;
    }

    private static boolean parameterExists2(List<StiDataParameter> parameters, String name) {
        name = name.toLowerCase();
        for (StiDataParameter param : parameters) {
            if (!StiValidationUtil.equals((Object)param.getName().toLowerCase(), (Object)name) && !StiValidationUtil.equals((Object)param.getName().toLowerCase(), (Object)("@" + name))) continue;
            return true;
        }
        return false;
    }
}

