/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary;

import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.dictionary.SortGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StiSort {
    public String column;
    public Order order;
    public ArrayList<String> relations = new ArrayList();

    public StiSort(String column) {
        this.column = column;
        this.order = Order.None;
    }

    public StiSort(String column, Order order) {
        this.column = column;
        this.order = order;
    }

    public StiSort(Order order, String column, ArrayList<String> relations) {
        this.column = column;
        this.order = order;
        this.relations = relations;
    }

    public static List<StiSort> creatByStringArray(ArrayList<String> sortColumns) {
        ArrayList<StiSort> result = new ArrayList<StiSort>();
        if (StiValidationUtil.isEmpty(sortColumns)) {
            return Collections.emptyList();
        }
        ArrayList<SortGroup> sortGroups = new ArrayList<SortGroup>();
        SortGroup group = null;
        for (String value : sortColumns) {
            if (Order.isOrder(value)) {
                group = new SortGroup(Order.forValue(value));
                sortGroups.add(group);
                continue;
            }
            group.addValue(value);
        }
        for (SortGroup sortGroup : sortGroups) {
            result.add(sortGroup.getSort());
        }
        return result;
    }

    public boolean existRelations() {
        return StiValidationUtil.isNotEmpty(this.relations);
    }

    public static enum Order {
        Asc(1),
        Desc(-1),
        None(0);

        public final int value;

        private Order(int value) {
            this.value = value;
        }

        public static Order forValue(String value) {
            if ((value = value.toLowerCase()).equals("asc") || value.equals("ascending")) {
                return Asc;
            }
            if (value.equals("desc") || value.equals("descending")) {
                return Desc;
            }
            if (value.equals("none")) {
                return None;
            }
            throw new RuntimeException("Invalid sort type specified '" + value + "'");
        }

        public static boolean isOrder(String value) {
            try {
                Order.forValue(value);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

