/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.dictionary;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.json.StiJSONHelper;
import com.stimulsoft.base.serializing.StiSerializedObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.annotations.StiSerializeTypesEnum;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.IStiStateSaveRestore;
import com.stimulsoft.report.StiNameCreation;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiDataRetrieval;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataRelation;
import com.stimulsoft.report.dictionary.StiDataRelationSetName;
import com.stimulsoft.report.dictionary.StiDataRelationsCollection;
import com.stimulsoft.report.dictionary.StiRestrictions;
import com.stimulsoft.report.dictionary.StiStrFix;
import com.stimulsoft.report.dictionary.StiUserFunctionsCollection;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.StiVariablesCollection;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObjectsCollection;
import com.stimulsoft.report.dictionary.data.DataSet;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.dataSources.StiDataSourceHelper;
import com.stimulsoft.report.dictionary.dataSources.StiDataSourcesCollection;
import com.stimulsoft.report.dictionary.dataSources.StiDataStoreSource;
import com.stimulsoft.report.dictionary.dataSources.StiDataTableSource;
import com.stimulsoft.report.dictionary.databases.StiDataCollection;
import com.stimulsoft.report.dictionary.databases.StiDatabase;
import com.stimulsoft.report.dictionary.databases.StiDatabaseCollection;
import com.stimulsoft.report.dictionary.databases.StiResourcesCollection;
import com.stimulsoft.report.dictionary.enums.StiAutoSynchronizeMode;
import com.stimulsoft.report.dictionary.enums.StiSortOrder;
import com.stimulsoft.report.saveLoad.StiDictionarySLService;
import com.stimulsoft.report.saveLoad.StiJsonDictionarySLService;
import com.stimulsoft.report.saveLoad.StiXmlDictionarySLService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class StiDictionary
extends StiSerializedObject
implements Cloneable,
IStiStateSaveRestore,
IStiJsonReportObject {
    private static Hashtable cachedUserNamesAndPasswords = null;
    private boolean useInternalData = false;
    private StiRestrictions restrictions = new StiRestrictions();
    private StiReport report;
    private StiDataCollection dataStore = new StiDataCollection();
    public StiVariablesCollection variables = new StiVariablesCollection();
    public StiDataSourcesCollection dataSources = new StiDataSourcesCollection();
    private StiDatabaseCollection databases = new StiDatabaseCollection();
    private StiBusinessObjectsCollection businessObjects;
    private StiDataRelationsCollection relations = new StiDataRelationsCollection();
    private DataSet cacheDataSet;
    private StiResourcesCollection resources = new StiResourcesCollection();
    private StiUserFunctionsCollection userFunctions = new StiUserFunctionsCollection();

    public StiDictionary() {
        this(null);
    }

    public StiDictionary(StiReport report) {
        this.report = report;
        this.dataSources = new StiDataSourcesCollection(this);
        this.relations = new StiDataRelationsCollection(this);
        this.databases = new StiDatabaseCollection(this);
        this.businessObjects = new StiBusinessObjectsCollection(this, null);
    }

    @Override
    public void saveState(String stateName) {
        Iterator iterator = this.getDataSources().iterator();
        while (iterator.hasNext()) {
            StiDataSource data = (StiDataSource)iterator.next();
            data.saveState(stateName);
        }
    }

    public void save(StiDictionarySLService service, OutputStream stream) {
        service.save(this, stream);
    }

    public void RestoreState(String stateName) {
        Iterator iterator = this.getDataSources().iterator();
        while (iterator.hasNext()) {
            StiDataSource data = (StiDataSource)iterator.next();
            data.RestoreState(stateName);
        }
    }

    public void ClearAllStates() {
        Iterator iterator = this.getDataSources().iterator();
        while (iterator.hasNext()) {
            StiDataSource data = (StiDataSource)iterator.next();
            data.ClearAllStates();
        }
    }

    public void merge(InputStream stream) throws IOException {
        List json = StiJSONHelper.isJsonFile((InputStream)stream);
        boolean isJson = (Boolean)json.get(0);
        InputStream fis = (InputStream)json.get(1);
        StiDictionarySLService service = isJson ? new StiJsonDictionarySLService() : new StiXmlDictionarySLService();
        this.merge(service, stream);
    }

    public void merge(StiDictionarySLService service, InputStream stream) {
        service.merge(this, stream);
    }

    public void merge(StiDictionary dictionary) {
        Iterator iterator = dictionary.getDataSources().iterator();
        while (iterator.hasNext()) {
            StiDataSource ds = (StiDataSource)iterator.next();
            StiDataSource dataSource = this.getDataSources().get(ds.getName());
            if (dataSource == null) {
                dataSource = (StiDataSource)ds.clone();
                dataSource.setName(StiNameCreation.createName(this.report, dataSource.getName(), false, false, true));
                this.getDataSources().add(dataSource);
                continue;
            }
            Iterator iterator2 = ds.getColumns().iterator();
            while (iterator2.hasNext()) {
                StiDataColumn cl = (StiDataColumn)iterator2.next();
                StiDataColumn dataColumn = dataSource.getColumns().get(cl.getName());
                if (dataColumn != null) continue;
                dataSource.getColumns().add((StiDataColumn)cl.clone());
            }
        }
        for (StiDataRelation rl : dictionary.getRelations()) {
            StiDataRelation relation = this.getRelations().get(rl.getNameInSource());
            if (relation != null && StiValidationUtil.equals((Object)relation.getName(), (Object)rl.getName())) continue;
            relation = (StiDataRelation)rl.clone();
            relation.setParentSource(this.getDataSources().get(relation.getParentSource().getName()));
            relation.setChildSource(this.getDataSources().get(relation.getChildSource().getName()));
            relation.setName(this.getRelationName(relation));
            this.getRelations().add(relation);
        }
        this.getUserFunctions().addAll(dictionary.getUserFunctions());
        this.getVariables().addAll((Collection)((Object)dictionary.getVariables()));
        this.connect(false, null);
    }

    public void load(InputStream stream) throws IOException {
        List json = StiJSONHelper.isJsonFile((InputStream)stream);
        boolean isJson = (Boolean)json.get(0);
        InputStream fis = (InputStream)json.get(1);
        StiDictionarySLService service = isJson ? new StiJsonDictionarySLService() : new StiXmlDictionarySLService();
        this.load(service, fis);
    }

    public void load(StiDictionarySLService service, InputStream stream) {
        service.load(this, stream);
    }

    private String getRelationName(StiDataRelation relation) {
        String relationName3;
        String baseName;
        String relationName = baseName = relation.getName();
        if (relation.getChildSource().getColumns().stream().anyMatch(column -> StiValidationUtil.equals((Object)column.getName(), (Object)relationName))) {
            baseName = "Parent" + relationName;
        }
        String relationName2 = baseName;
        int index = 2;
        while (true) {
            relationName3 = relationName2;
            if (this.relations.stream().filter(r -> r.getChildSource() == relation.getChildSource() && r != relation).allMatch(r -> !StiValidationUtil.equals((Object)r.getName(), (Object)relationName3))) break;
            relationName2 = baseName + "_" + index++;
        }
        while (true) {
            relationName3 = relationName2;
            if (this.dataSources.stream().allMatch(dataSource -> !StiValidationUtil.equals((Object)("Parent" + dataSource.getName()), (Object)relationName3))) break;
            relationName2 = baseName + "_" + index++;
        }
        return relationName2;
    }

    public static Hashtable getCacheUserNamesAndPasswords() {
        return cachedUserNamesAndPasswords;
    }

    public static void setCacheUserNamesAndPasswords(Hashtable value) {
        cachedUserNamesAndPasswords = value;
    }

    public final boolean getUseInternalData() {
        return this.useInternalData;
    }

    public final void setUseInternalData(boolean value) {
        this.useInternalData = value;
    }

    public final StiRestrictions getRestrictions() {
        return this.restrictions;
    }

    public final void setRestrictions(StiRestrictions value) {
        this.restrictions = value;
    }

    public static StiAutoSynchronizeMode getAutoSynchronize() {
        return StiOptions.Dictionary.getAutoSynchronize();
    }

    public static void setAutoSynchronize(StiAutoSynchronizeMode value) {
        StiOptions.Dictionary.setAutoSynchronize(value);
    }

    public static void DoAutoSynchronize(StiReport report) {
        if (report == null) {
            return;
        }
        if (StiDictionary.getAutoSynchronize() == StiAutoSynchronizeMode.Always || StiDictionary.getAutoSynchronize() == StiAutoSynchronizeMode.IfDictionaryEmpty && report.getDictionary().getDataSources().size() == 0) {
            report.getDictionary().synchronize();
        }
    }

    public void synchronize() {
        this.connect(false, null);
        StiDataRelationsCollection unusedRelations = this.getUnusedRelationsFromDataStore();
        for (StiDataRelation rel : unusedRelations) {
            boolean relationExists = false;
            for (StiDataRelation relation : this.getRelations()) {
                if (!StiValidationUtil.equals((Object)StiStrFix.del_(rel.getNameInSource()), (Object)StiStrFix.del_(relation.getNameInSource()))) continue;
                relationExists = true;
            }
            if (relationExists) continue;
            rel.setName(StiNameCreation.createRelationName(this.getReport(), rel, rel.getParentSource().getName()));
            this.getRelations().add(rel);
        }
        this.Disconnect();
    }

    public StiDataRelationsCollection getUnusedRelationsFromDataStore() {
        StiDataRelationsCollection collection = new StiDataRelationsCollection(this);
        Iterator iterator = this.getDataSources().iterator();
        while (iterator.hasNext()) {
            StiDataSource dataSource = (StiDataSource)iterator.next();
            if (!(dataSource instanceof StiDataTableSource)) continue;
            Iterator iterator2 = dataSource.getColumns().iterator();
            while (iterator2.hasNext()) {
                StiDataColumn column = (StiDataColumn)iterator2.next();
                String colName = column.getName();
                String datasourceName = colName.endsWith("_Id") ? colName.substring(0, colName.length() - 3) : null;
                if (datasourceName == null || dataSource.getName().equals(datasourceName) || this.getDataSources().get(datasourceName) == null || this.getDataSources().get(datasourceName).getColumns().get(colName) == null) continue;
                ArrayList<String> parentColumns = new ArrayList<String>();
                parentColumns.add(colName);
                ArrayList<String> childColumns = new ArrayList<String>();
                childColumns.add(colName);
                String relationName = datasourceName + "_" + dataSource.getName();
                StiDataRelation stiRelation = new StiDataRelation(relationName, this.getDataSources().get(datasourceName), dataSource, parentColumns, childColumns);
                StiDataRelationSetName.setName(stiRelation, this.getReport(), relationName);
                collection.add(stiRelation);
            }
        }
        return collection;
    }

    @StiSerializable(isRef=true, type=StiSerializeTypesEnum.SerializeToAll)
    public final StiReport getReport() {
        return this.report;
    }

    public final void setReport(StiReport value) {
        this.report = value;
    }

    public final StiDataCollection getDataStore() {
        return this.dataStore;
    }

    public final void setDataStore(StiDataCollection value) {
        this.dataStore = value;
    }

    public void removeDatabase(String name) {
        StiDatabase database = this.databases.get(name);
        if (database != null) {
            this.removeDatabase(database);
        }
    }

    public void removeDatabase(StiDatabase database) {
        String name = database.getName() + ".";
        ArrayList<StiDataSource> selectedDataSources = new ArrayList<StiDataSource>();
        Iterator iterator = this.dataSources.iterator();
        while (iterator.hasNext()) {
            StiDataSource dataSource = (StiDataSource)iterator.next();
            if (!(dataSource instanceof StiDataStoreSource) || !((StiDataStoreSource)dataSource).getNameInSource().startsWith(name)) continue;
            selectedDataSources.add(dataSource);
        }
        ArrayList<StiDataRelation> relationsToRemove = new ArrayList<StiDataRelation>();
        for (StiDataRelation relation : this.relations) {
            if (!selectedDataSources.contains(relation.getParentSource()) && !selectedDataSources.contains(relation.getChildSource())) continue;
            relationsToRemove.add(relation);
        }
        this.relations.removeAll(relationsToRemove);
        this.dataSources.removeAll(selectedDataSources);
        this.databases.remove(database);
    }

    @StiSerializable
    public final StiVariablesCollection getVariables() {
        return this.variables;
    }

    public final void setVariables(StiVariablesCollection value) {
        this.variables = value;
    }

    @StiSerializable
    public StiResourcesCollection getResources() {
        return this.resources;
    }

    public void setResources(StiResourcesCollection resources) {
        this.resources = resources;
    }

    @StiSerializable
    public final StiDataSourcesCollection getDataSources() {
        return this.dataSources;
    }

    public final void setDataSources(StiDataSourcesCollection value) {
        this.dataSources = value;
    }

    @StiSerializable
    public final StiDatabaseCollection getDatabases() {
        return this.databases;
    }

    public final void setDatabases(StiDatabaseCollection value) {
        this.databases = value;
    }

    @StiSerializable
    public final StiBusinessObjectsCollection getBusinessObjects() {
        return this.businessObjects;
    }

    public final void setBusinessObjects(StiBusinessObjectsCollection value) {
        this.businessObjects = value;
    }

    @StiSerializable
    public StiDataRelationsCollection getRelations() {
        return this.relations;
    }

    public void setRelations(StiDataRelationsCollection value) {
        this.relations = value;
    }

    public final boolean getisRequestFromUserVariablesPresent() {
        if (this.getVariables() == null) {
            return false;
        }
        Iterator iterator = this.getVariables().iterator();
        while (iterator.hasNext()) {
            StiVariable variable = (StiVariable)iterator.next();
            if (!variable.getRequestFromUser()) continue;
            return true;
        }
        return false;
    }

    public final void SortItems() {
        this.SortItems(StiSortOrder.Asc);
    }

    public final void SortItems(StiSortOrder order) {
        this.getDataSources().sort(order);
        this.getVariables().Sort(order);
    }

    public final void RetrievalData(Hashtable usedRelations, Hashtable usedDataSources, Hashtable usedColumns) {
        StiDataRetrieval service = new StiDataRetrieval();
        service.Retrieval(this.getReport());
        usedRelations.putAll(service.getUsedRelations());
        usedDataSources.putAll(service.getUsedDataSources());
        usedColumns.putAll(service.getUsedColumns());
    }

    public final void clear() {
        this.variables.clear();
        this.dataSources.clear();
        this.databases.clear();
        this.relations.clear();
        this.dataStore.clear();
        this.resources.clear();
    }

    public final void SynchronizeBusinessObjects(int maxLevel) {
        this.SynchronizeBusinessObjects();
        this.SynchronizeBusinessObjects(this.businessObjects, 0, maxLevel);
    }

    private void SynchronizeBusinessObjects() {
    }

    private void SynchronizeBusinessObjects(StiBusinessObjectsCollection objects, int curLevel, int maxLevel) {
    }

    private String GetRelationName(StiDataRelation relation) {
        String baseName;
        boolean finded = true;
        int index = 2;
        String relationName = baseName = relation.getName();
        Iterator iterator = relation.getChildSource().getColumns().iterator();
        while (iterator.hasNext()) {
            StiDataColumn column = (StiDataColumn)iterator.next();
            if (!relationName.equals(column.getName())) continue;
            baseName = relationName = "Parent" + relationName;
            break;
        }
        block1: while (finded) {
            finded = false;
            for (StiDataRelation dataRelation : this.getRelations()) {
                if (dataRelation.getChildSource() != relation.getChildSource() || dataRelation == relation || !relationName.equals(dataRelation.getName())) continue;
                relationName = (baseName + "_" + index++).toString();
                finded = true;
                continue block1;
            }
        }
        finded = true;
        block3: while (finded) {
            finded = false;
            iterator = this.getDataSources().iterator();
            while (iterator.hasNext()) {
                StiDataSource dataSource = (StiDataSource)iterator.next();
                if (!("Parent" + relationName).equals(dataSource.getName())) continue;
                relationName = (baseName + "_" + index++).toString();
                finded = true;
                continue block3;
            }
        }
        return relationName;
    }

    public final void connect() {
        this.connect(true, null);
    }

    public final void connect(boolean loadData) {
        this.connect(loadData, null);
    }

    public final void connect(boolean loadData, List<StiDataSource> dataSources) {
        try {
            this.getDataSources().prepareData();
            if (dataSources != null) {
                for (StiDataSource source : dataSources) {
                    source.connect(loadData);
                }
            } else if (this.report.getRetrieveOnlyUsedData()) {
                Hashtable<String, Hashtable<String, String>> dataSourceNames = StiDataSourceHelper.getUsedDataSourcesNames(this.report);
                Iterator iterator = this.getDataSources().iterator();
                while (iterator.hasNext()) {
                    StiDataSource dataSource = (StiDataSource)iterator.next();
                    if (!dataSourceNames.containsKey(dataSource.getName())) continue;
                    dataSource.connect(loadData);
                }
            } else {
                this.getDataSources().connect(loadData);
            }
        }
        catch (StiException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public final void ConnectVirtualDataSources() {
    }

    public final void ConnectCrossTabDataSources() {
    }

    public boolean ShowOnlyAliasForDataRelation() {
        return false;
    }

    @Override
    public void restoreState(String stateName) {
    }

    @Override
    public void clearAllStates() {
    }

    public StiDataRelation getRelation(String dataRelationName) {
        return this.relations.get(dataRelationName);
    }

    public boolean existRelation(String dataRelationName) {
        return this.relations.exist(dataRelationName);
    }

    public boolean getShowOnlyAliasForVariable() {
        return false;
    }

    public boolean showOnlyAliasForBusinessObject() {
        return false;
    }

    public boolean ShowOnlyAliasForDatabase() {
        return false;
    }

    public boolean ShowOnlyAliasForDataColumn() {
        return false;
    }

    public void RegRelations(boolean b) {
    }

    public void Disconnect() {
        this.getDataSources().disconnect();
    }

    public final DataSet getCacheDataSet() {
        return this.cacheDataSet;
    }

    public final void setCacheDataSet(DataSet value) {
        this.cacheDataSet = value;
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyJObject("Resources", this.getResources().SaveToJsonObjectEx(mode));
        if (mode == StiJsonSaveMode.Report) {
            jObject.AddPropertyJObject("Variables", this.getVariables().SaveToJsonObjectEx(mode));
            jObject.AddPropertyJObject("DataSources", this.getDataSources().SaveToJsonObject(mode));
            jObject.AddPropertyJObject("Databases", this.getDatabases().SaveToJsonObject(mode));
            jObject.AddPropertyJObject("Relations", this.getRelations().SaveToJsonObject(mode));
            jObject.AddPropertyJObject("UserFunctions", this.getUserFunctions().SaveToJsonObject(mode));
        }
        if (jObject.length() == 0) {
            return null;
        }
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Resources")) {
                this.resources.LoadFromJsonObjectEx((JSONObject)property.Value, this.report);
            }
            if (property.Name.equals("Variables")) {
                this.variables.LoadFromJsonObjectEx((JSONObject)property.Value, this.report);
                continue;
            }
            if (property.Name.equals("DataSources")) {
                this.dataSources.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("Databases")) {
                this.databases.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("BusinessObjects")) continue;
            if (property.Name.equals("Relations")) {
                this.relations.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (!property.Name.equals("UserFunctions")) continue;
            this.userFunctions.LoadFromJsonObject((JSONObject)property.Value);
        }
    }

    public void removeUnusedRelations() {
        ArrayList<StiDataRelation> relationsToDelete = new ArrayList<StiDataRelation>();
        for (StiDataRelation relation : this.report.getDictionary().getRelations()) {
            StiDataTableSource parentSource = (StiDataTableSource)relation.getParentSource();
            StiDataTableSource childSource = (StiDataTableSource)relation.getChildSource();
            boolean parendExist = false;
            boolean childExist = false;
            Iterator iterator = this.getDataSources().iterator();
            while (iterator.hasNext()) {
                StiDataSource dataSource = (StiDataSource)iterator.next();
                if (!(dataSource instanceof StiDataTableSource)) continue;
                StiDataTableSource dataTableSource = (StiDataTableSource)dataSource;
                if (parentSource != null && StiValidationUtil.equals((Object)dataTableSource.getNameInSource(), (Object)parentSource.getNameInSource())) {
                    parendExist = true;
                }
                if (childSource == null || !StiValidationUtil.equals((Object)dataTableSource.getNameInSource(), (Object)childSource.getNameInSource())) continue;
                childExist = true;
            }
            if (parendExist && childExist) continue;
            relationsToDelete.add(relation);
        }
        for (StiDataRelation relation : relationsToDelete) {
            this.report.getDictionary().getRelations().remove(relation);
        }
    }

    @StiSerializable
    public StiUserFunctionsCollection getUserFunctions() {
        return this.userFunctions;
    }

    public void setUserFunctions(StiUserFunctionsCollection userFunctions) {
        this.userFunctions = userFunctions;
    }
}

