/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.crossTab;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.StiAlignValue;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.system.type.StiSystemObject;
import com.stimulsoft.base.system.type.StiSystemType;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiDataHelper;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.crossTab.StiCrossCell;
import com.stimulsoft.report.crossTab.StiCrossColumn;
import com.stimulsoft.report.crossTab.StiCrossField;
import com.stimulsoft.report.crossTab.StiCrossHeader;
import com.stimulsoft.report.crossTab.StiCrossRow;
import com.stimulsoft.report.crossTab.StiCrossSummary;
import com.stimulsoft.report.crossTab.StiCrossSummaryHeader;
import com.stimulsoft.report.crossTab.StiCrossTab;
import com.stimulsoft.report.crossTab.StiCrossTabInfo;
import com.stimulsoft.report.crossTab.StiCrossTitle;
import com.stimulsoft.report.crossTab.core.StiCell;
import com.stimulsoft.report.crossTab.core.StiCross;
import com.stimulsoft.report.crossTab.enums.StiCrossHorAlignment;
import com.stimulsoft.report.crossTab.events.StiGetCrossValueEventArgs;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.data.DataRow;
import com.stimulsoft.report.dictionary.data.DataTable;
import com.stimulsoft.report.events.StiGetValueEventArgs;
import java.util.Hashtable;

public class StiCrossTabHelper {
    public static boolean IsCrossTabRendering = false;

    public static void renderCells(StiCrossTab masterCrossTab, StiContainer outContainer, int startCol, int startRow, int endCol, int endRow, StiRectangle rect) {
        StiCrossTabInfo info = masterCrossTab.crossTabInfo;
        StiCross cross = info.Cross;
        info.HidedCells.clear();
        double startX = rect.getLeft() - cross.getCoordX()[startCol];
        double startY = rect.getTop() - cross.getCoordY()[startRow];
        for (int rowIndex = startRow; rowIndex < endRow; ++rowIndex) {
            for (int colIndex = startCol; colIndex < endCol; ++colIndex) {
                StiCell cell = cross.getCells()[colIndex][rowIndex];
                if (info.HidedCells.containsKey(cell)) continue;
                int cellRight = colIndex + cell.getWidth();
                int cellBottom = rowIndex + cell.getHeight();
                if (cellRight > endCol) {
                    cellRight = endCol;
                }
                if (cellBottom > endRow) {
                    cellBottom = endRow;
                }
                for (int widthIndex = colIndex; widthIndex < cellRight; ++widthIndex) {
                    for (int heightIndex = rowIndex; heightIndex < cellBottom; ++heightIndex) {
                        StiCell curCell = cross.getCells()[widthIndex][heightIndex];
                        info.HidedCells.put(curCell, curCell);
                    }
                }
                StiRectangle cellRect = StiCrossTabHelper.getCellSize(colIndex, cellRight, cross, rowIndex, cellBottom, startX, startY);
                StiComponent componentCell = StiCrossTabHelper.createComponentFromCell(cell);
                if (componentCell != null) {
                    outContainer.getComponents().add(componentCell);
                    componentCell.setClientRectangle(cellRect);
                }
                StiCrossTabHelper.setBottomLine(masterCrossTab, cell, componentCell, rowIndex, endRow);
            }
        }
    }

    private static void setBottomLine(StiCrossTab crossTab, StiCell cell, StiComponent component, int rowIndex, int endRow) {
        IStiBorder border;
        IStiBorder lastBorder;
        StiCross cross = crossTab.crossTabInfo.Cross;
        int sumCount = cross.getSumFields().size();
        if (sumCount < 2) {
            return;
        }
        if (cell.getSummaryIndex() < 0 || cell.getSummaryIndex() >= sumCount - 1) {
            return;
        }
        if (rowIndex != endRow - 1) {
            return;
        }
        IStiBorder iStiBorder = lastBorder = cross.getSumFields().size() > 0 && cross.getSumFields().get(cross.getSumFields().size() - 1) instanceof IStiBorder ? (IStiBorder)cross.getSumFields().get(cross.getSumFields().size() - 1) : null;
        if (lastBorder == null || !lastBorder.getBorder().isBottomBorderSidePresent()) {
            return;
        }
        IStiBorder iStiBorder2 = border = component instanceof IStiBorder ? (IStiBorder)((Object)component) : null;
        if (border == null || border.getBorder().isBottomBorderSidePresent()) {
            return;
        }
        border.getBorder().getSide().add((IStiEnum)StiBorderSides.Bottom);
    }

    private static StiRectangle getCellSize(int colIndex, int cellRight, StiCross cross, int rowIndex, int cellBottom, double startX, double startY) {
        double cellWidth = 0.0;
        double cellHeight = 0.0;
        for (int widthIndex = colIndex; widthIndex < cellRight; ++widthIndex) {
            cellWidth += cross.getWidths()[widthIndex];
        }
        for (int heightIndex = rowIndex; heightIndex < cellBottom; ++heightIndex) {
            cellHeight += cross.getHeights()[heightIndex];
        }
        return new StiRectangle(cross.getCoordX()[colIndex] + startX, cross.getCoordY()[rowIndex] + startY, cellWidth, cellHeight);
    }

    private static StiComponent createComponentFromCell(StiCell cell) {
        StiComponent component;
        StiComponent stiComponent = component = cell.getIsImage() ? StiCrossTabHelper.createImageFromCell(cell) : StiCrossTabHelper.createTextFromCell(cell);
        if (component != null) {
            component.setHyperlinkValue(cell.getHyperlinkValue());
            component.setToolTipValue(cell.getToolTipValue());
            component.setTagValue(cell.getTagValue());
            component.setDrillDownParameters(cell.getDrillDownParameters());
            component.setComponentPlacement(cell.getComponentPlacement());
        }
        return component;
    }

    private static StiComponent createTextFromCell(StiCell cell) {
        StiText text = null;
        if (cell.field != null) {
            Object tempVar3;
            StiCrossHeader header;
            if (cell.getWidth() > 1 || cell.getHeight() > 1 || !cell.getIsNumeric() || cell.getField() instanceof StiCrossHeader || cell.getField().needClone) {
                Object tempVar2 = cell.field.clone();
                text = (StiCrossField)(tempVar2 instanceof StiCrossField ? tempVar2 : null);
            } else {
                text = cell.field;
                cell.getField().needClone = true;
            }
            StiCrossHeader stiCrossHeader = header = text instanceof StiCrossHeader ? (StiCrossHeader)text : null;
            if (header != null) {
                header.setHeaderLevel(cell.getLevel());
                header.setHeaderValue(cell.getValue() != null ? cell.getValue().toString() : null);
            }
            text.setBorder((StiBorder)((tempVar3 = cell.field.getBorder().clone()) instanceof StiBorder ? tempVar3 : null));
            text.setMaxSize(new StiSize());
            text.setMinSize(new StiSize());
            if (cell.getHeight() > 1) {
                text.setCanBreak(true);
            }
        } else if (cell.getWidth() > 1 || cell.getHeight() > 1) {
            text = new StiText();
            text.getBorder().side = StiEnumSet.of((Enum)StiBorderSides.All);
        }
        if (text != null) {
            text.SetTextInternal(cell.getText());
            return text;
        }
        return null;
    }

    private static StiComponent createImageFromCell(StiCell cell) {
        StiImage image = null;
        if (cell.getField() != null) {
            image = new StiImage();
            Object tempVar = cell.field.getBorder().clone();
            image.setBorder((StiBorder)(tempVar instanceof StiBorder ? tempVar : null));
        } else {
            image = new StiImage();
            image.getBorder().side = StiEnumSet.of((Enum)StiBorderSides.All);
        }
        if (cell.getValue() != null) {
            image.setImage(StiImageHelper.getImageFromObject(cell.getValue()));
        }
        if (cell.getField() instanceof StiCrossSummary) {
            image.setStretch(((StiCrossSummary)cell.field).getStretch());
            image.setAspectRatio(((StiCrossSummary)cell.field).getAspectRatio());
            image.setHorAlignment(((StiCrossSummary)cell.field).getImageHorAlignment());
            image.setVertAlignment(((StiCrossSummary)cell.field).getImageVertAlignment());
        }
        return image;
    }

    public static StiRectangle GetCellRect(StiCrossTab masterCrossTab, int colIndex, int rowIndex, int state, int colRow, int sumColumn, int sumHeaders) {
        int widthIndex;
        double cellWidth = 0.0;
        double cellHeight = 0.0;
        StiCell cell = masterCrossTab.getCrossTabInfo().Cross.getCells()[colIndex][rowIndex];
        if (colRow == 0 && colIndex == 0 && rowIndex < sumColumn) {
            for (widthIndex = colIndex; widthIndex < colIndex + cell.getWidth() + 1; ++widthIndex) {
                cellWidth += masterCrossTab.getCrossTabInfo().Cross.getWidths()[widthIndex];
            }
        } else if (rowIndex == state && colIndex < colRow - 1 && cell.getWidth() > 1) {
            for (widthIndex = colIndex; widthIndex < colIndex + cell.getWidth() - 1; ++widthIndex) {
                cellWidth += masterCrossTab.getCrossTabInfo().Cross.getWidths()[widthIndex];
            }
        } else {
            for (widthIndex = colIndex; widthIndex < colIndex + cell.getWidth(); ++widthIndex) {
                cellWidth += masterCrossTab.getCrossTabInfo().Cross.getWidths()[widthIndex];
            }
        }
        for (int heightIndex = rowIndex; heightIndex < rowIndex + cell.getHeight(); ++heightIndex) {
            cellHeight += masterCrossTab.getCrossTabInfo().Cross.getHeights()[heightIndex];
        }
        return new StiRectangle(masterCrossTab.getCrossTabInfo().Cross.getCoordX()[colIndex], masterCrossTab.getCrossTabInfo().Cross.getCoordY()[rowIndex], cellWidth, cellHeight);
    }

    public static StiRectangle GetCellRect(StiCrossTab masterCrossTab, int colIndex, int rowIndex) {
        double cellWidth = 0.0;
        double cellHeight = 0.0;
        StiCell cell = masterCrossTab.getCrossTabInfo().Cross.getCells()[colIndex][rowIndex];
        for (int widthIndex = colIndex; widthIndex < colIndex + cell.getWidth(); ++widthIndex) {
            cellWidth += masterCrossTab.getCrossTabInfo().Cross.getWidths()[widthIndex];
        }
        for (int heightIndex = rowIndex; heightIndex < rowIndex + cell.getHeight(); ++heightIndex) {
            cellHeight += masterCrossTab.getCrossTabInfo().Cross.getHeights()[heightIndex];
        }
        return new StiRectangle(masterCrossTab.getCrossTabInfo().Cross.getCoordX()[colIndex], masterCrossTab.getCrossTabInfo().Cross.getCoordY()[rowIndex], cellWidth, cellHeight);
    }

    public static StiSize GetCellsRect(StiCrossTab masterCrossTab, int startCol, int startRow, int endCol, int endRow) {
        double cellsWidth = 0.0;
        double cellsHeight = 0.0;
        for (int indexCol = startCol; indexCol < endCol; ++indexCol) {
            cellsWidth += masterCrossTab.getCrossTabInfo().Cross.getWidths()[indexCol];
        }
        for (int indexRow = startRow; indexRow < endRow; ++indexRow) {
            cellsHeight += masterCrossTab.getCrossTabInfo().Cross.getHeights()[indexRow];
        }
        return new StiSize(cellsWidth, cellsHeight);
    }

    public static void RenderCells(StiCrossTab masterCrossTab, StiContainer outContainer, int startCol, int startRow, int endCol, int endRow, StiRectangle rect) {
        masterCrossTab.getCrossTabInfo().HidedCells.clear();
        double startX = rect.getLeft() - masterCrossTab.getCrossTabInfo().Cross.getCoordX()[startCol];
        double startY = rect.getTop() - masterCrossTab.getCrossTabInfo().Cross.getCoordY()[startRow];
        for (int rowIndex = startRow; rowIndex < endRow; ++rowIndex) {
            for (int colIndex = startCol; colIndex < endCol; ++colIndex) {
                StiCell cell = masterCrossTab.getCrossTabInfo().Cross.getCells()[colIndex][rowIndex];
                if (masterCrossTab.getCrossTabInfo().HidedCells.get(cell) != null) continue;
                StiComponent componentCell = null;
                if (cell.getIsImage()) {
                    StiImage image = null;
                    if (cell.getField() != null) {
                        image = new StiImage();
                        Object tempVar = cell.field.getBorder().clone();
                        image.setBorder((StiBorder)(tempVar instanceof StiBorder ? tempVar : null));
                    } else {
                        image = new StiImage();
                        image.getBorder().side = StiEnumSet.of((Enum)StiBorderSides.All);
                    }
                    if (cell.getValue() != null) {
                        image.setImage(StiImageHelper.getImageFromObject(cell.getValue()));
                    }
                    if (cell.getField() instanceof StiCrossSummary) {
                        image.setStretch(((StiCrossSummary)cell.field).getStretch());
                        image.setAspectRatio(((StiCrossSummary)cell.field).getAspectRatio());
                        image.setHorAlignment(((StiCrossSummary)cell.field).getImageHorAlignment());
                        image.setVertAlignment(((StiCrossSummary)cell.field).getImageVertAlignment());
                    }
                    componentCell = image;
                } else {
                    StiText text = null;
                    if (cell.field != null) {
                        Object tempVar3;
                        StiCrossHeader header;
                        Object tempVar2;
                        text = cell.getWidth() > 1 || cell.getHeight() > 1 || !cell.getIsNumeric() ? (StiCrossField)((tempVar2 = cell.field.clone()) instanceof StiCrossField ? tempVar2 : null) : cell.field;
                        StiCrossHeader stiCrossHeader = header = text instanceof StiCrossHeader ? (StiCrossHeader)text : null;
                        if (header != null) {
                            header.setHeaderLevel(cell.getLevel());
                            header.setHeaderValue(cell.getValue() != null ? cell.getValue().toString() : null);
                        }
                        text.setBorder((StiBorder)((tempVar3 = cell.field.getBorder().clone()) instanceof StiBorder ? tempVar3 : null));
                        text.setMaxSize(new StiSize());
                        text.setMinSize(new StiSize());
                        if (cell.getHeight() > 1) {
                            text.setCanBreak(true);
                        }
                    } else if (cell.getWidth() > 1 || cell.getHeight() > 1) {
                        text = new StiText();
                        text.getBorder().side = StiEnumSet.of((Enum)StiBorderSides.All);
                    }
                    if (text != null) {
                        text.SetTextInternal(cell.getText());
                        componentCell = text;
                    }
                }
                if (componentCell != null) {
                    componentCell.setHyperlinkValue(cell.getHyperlinkValue());
                    componentCell.setToolTipValue(cell.getToolTipValue());
                    componentCell.setTagValue(cell.getTagValue());
                    componentCell.setDrillDownParameters(cell.getDrillDownParameters());
                    if (cell.field instanceof StiCrossColumn) {
                        componentCell.setComponentPlacement("h");
                    } else if (cell.field instanceof StiCrossHeader) {
                        componentCell.setComponentPlacement("h");
                    } else if (cell.field instanceof StiCrossTitle) {
                        componentCell.setComponentPlacement("h");
                    } else {
                        componentCell.setComponentPlacement("d");
                    }
                    if (componentCell.getComponentPlacement().length() > 0 && cell.field != null && cell.field.parent != null) {
                        componentCell.componentPlacement = componentCell.componentPlacement + "." + cell.field.parent.getName();
                    }
                    outContainer.components.add(componentCell);
                }
                int cellRight = colIndex + cell.getWidth();
                int cellBottom = rowIndex + cell.getHeight();
                if (cellRight > endCol) {
                    cellRight = endCol;
                }
                if (cellBottom > endRow) {
                    cellBottom = endRow;
                }
                for (int widthIndex = colIndex; widthIndex < cellRight; ++widthIndex) {
                    for (int heightIndex = rowIndex; heightIndex < cellBottom; ++heightIndex) {
                        StiCell curCell = masterCrossTab.getCrossTabInfo().Cross.getCells()[widthIndex][heightIndex];
                        masterCrossTab.getCrossTabInfo().HidedCells.put(curCell, curCell);
                    }
                }
                double cellWidth = 0.0;
                double cellHeight = 0.0;
                for (int widthIndex = colIndex; widthIndex < cellRight; ++widthIndex) {
                    cellWidth += masterCrossTab.getCrossTabInfo().Cross.getWidths()[widthIndex];
                }
                for (int heightIndex = rowIndex; heightIndex < cellBottom; ++heightIndex) {
                    cellHeight += masterCrossTab.getCrossTabInfo().Cross.getHeights()[heightIndex];
                }
                StiRectangle cellRect = new StiRectangle(masterCrossTab.getCrossTabInfo().Cross.getCoordX()[colIndex], masterCrossTab.getCrossTabInfo().Cross.getCoordY()[rowIndex], cellWidth, cellHeight);
                cellRect.x += startX;
                cellRect.y += startY;
                if (componentCell == null) continue;
                componentCell.setClientRectangle(cellRect);
            }
        }
    }

    public static DataTable CreateCrossForCrossTabDataSource(StiCrossTab masterCrossTab) {
        masterCrossTab.getCrossTabInfoV1().StartRow = 0;
        masterCrossTab.getCrossTabInfoV1().StartCol = 0;
        StiDataHelper.SetData(masterCrossTab, true, masterCrossTab.getParent() instanceof StiDataBand ? masterCrossTab.getParent() : null);
        return StiCrossTabHelper.BuildCrossForCrossTabDataSource(masterCrossTab, false);
    }

    public static DataTable BuildCrossForCrossTabDataSource(StiCrossTab masterCrossTab, boolean designTime) {
        StiComponentsCollection colFields = new StiComponentsCollection(null);
        StiComponentsCollection rowFields = new StiComponentsCollection(null);
        StiComponentsCollection sumFields = new StiComponentsCollection(null);
        StiComponentsCollection sumHeaderFields = new StiComponentsCollection(null);
        StiComponentsCollection rowTitleFields = new StiComponentsCollection(null);
        StiComponentsCollection colTitleFields = new StiComponentsCollection(null);
        StiCrossTitle crossLeftTitle = null;
        StiCrossTitle crossRightTitle = null;
        StiCrossTitle crossSummaryTitle = null;
        DataTable table = new DataTable();
        for (StiComponent component : masterCrossTab.getComponents()) {
            if (!(component instanceof StiCrossCell) && !(component instanceof StiCrossTitle) && !(component instanceof StiCrossSummaryHeader)) continue;
            StiCrossRow row = (StiCrossRow)(component instanceof StiCrossRow ? component : null);
            StiCrossColumn col = (StiCrossColumn)(component instanceof StiCrossColumn ? component : null);
            StiCrossSummary sum = (StiCrossSummary)(component instanceof StiCrossSummary ? component : null);
            StiCrossSummaryHeader sumHeader = (StiCrossSummaryHeader)(component instanceof StiCrossSummaryHeader ? component : null);
            StiCrossTitle title = (StiCrossTitle)(component instanceof StiCrossTitle ? component : null);
            if (title != null) {
                if (title.getTypeOfComponent().startsWith("Row:")) {
                    rowTitleFields.add(title);
                }
                if (title.getTypeOfComponent().startsWith("Col:")) {
                    colTitleFields.add(title);
                }
                if (title.getTypeOfComponent().startsWith("LeftTitle")) {
                    crossLeftTitle = title;
                }
                if (title.getTypeOfComponent().startsWith("RightTitle")) {
                    crossRightTitle = title;
                }
                if (!title.getTypeOfComponent().startsWith("SummaryTitle")) continue;
                crossSummaryTitle = title;
                continue;
            }
            if (row != null) {
                rowFields.add(row);
                if (!row.isTotalVisible()) {
                    row.getTotal().setHeight(0.0);
                }
            }
            if (col != null) {
                colFields.add(col);
                if (!col.isTotalVisible()) {
                    col.getTotal().setWidth(0.0);
                }
            }
            if (sum != null && sum.getEnabled() && !sum.isDisabledByCondition()) {
                sumFields.add(sum);
            }
            if (sumHeader != null && sumHeader.getEnabled() && !sumHeader.isDisabledByCondition()) {
                sumHeaderFields.add(sumHeader);
            }
            StiDataColumn column = new StiDataColumn(component.getName(), component.getName(), (StiSystemType)new StiSystemObject());
            table.getColumns().add(column);
            if (!(component instanceof StiCrossHeader)) continue;
            String colName = "Display__" + component.getName();
            column = new StiDataColumn(colName, colName, (StiSystemType)new StiSystemObject());
            table.getColumns().add(column);
        }
        if (!designTime) {
            masterCrossTab.First();
            while (!masterCrossTab.getIsEof()) {
                DataRow row = table.NewRow();
                for (StiComponent component : masterCrossTab.getComponents()) {
                    if (component instanceof StiCrossSummaryHeader) continue;
                    StiCrossCell cell = (StiCrossCell)(component instanceof StiCrossCell ? component : null);
                    if (cell != null) {
                        StiGetCrossValueEventArgs arg = new StiGetCrossValueEventArgs();
                        cell.InvokeGetCrossValue(cell, arg);
                        row.setValue(cell.getName(), arg.getValue());
                        if (!(cell instanceof StiCrossHeader)) continue;
                        arg = new StiGetCrossValueEventArgs();
                        if (cell instanceof StiCrossHeader) {
                            ((StiCrossHeader)cell).InvokeGetDisplayCrossValue(arg);
                        }
                        row.setValue("Display__" + component.getName(), arg.getValue());
                        continue;
                    }
                    if (!(component instanceof StiCrossTitle)) continue;
                    StiGetValueEventArgs args = new StiGetValueEventArgs();
                    ((StiCrossTitle)component).InvokeGetValue(component, args);
                    ((StiCrossTitle)component).SetTextInternal(args.getValue());
                }
                table.getRows().add(row);
                masterCrossTab.Next();
            }
        }
        return table;
    }

    public static void BuildCross(StiCrossTab masterCrossTab, boolean designTime) {
        StiComponentsCollection colFields = new StiComponentsCollection(null);
        StiComponentsCollection rowFields = new StiComponentsCollection(null);
        StiComponentsCollection sumFields = new StiComponentsCollection(null);
        StiComponentsCollection sumHeaderFields = new StiComponentsCollection(null);
        StiComponentsCollection rowTitleFields = new StiComponentsCollection(null);
        StiComponentsCollection colTitleFields = new StiComponentsCollection(null);
        StiCrossTitle crossLeftTitle = null;
        StiCrossTitle crossRightTitle = null;
        StiCrossTitle crossSummaryTitle = null;
        DataTable table = new DataTable();
        for (StiComponent component : masterCrossTab.getComponents()) {
            if (!(component instanceof StiCrossCell) && !(component instanceof StiCrossTitle) && !(component instanceof StiCrossSummaryHeader)) continue;
            StiCrossRow row = (StiCrossRow)(component instanceof StiCrossRow ? component : null);
            StiCrossColumn col = (StiCrossColumn)(component instanceof StiCrossColumn ? component : null);
            StiCrossSummary sum = (StiCrossSummary)(component instanceof StiCrossSummary ? component : null);
            StiCrossSummaryHeader sumHeader = (StiCrossSummaryHeader)(component instanceof StiCrossSummaryHeader ? component : null);
            StiCrossTitle title = (StiCrossTitle)(component instanceof StiCrossTitle ? component : null);
            if (title != null) {
                if (title.getTypeOfComponent().startsWith("Row:")) {
                    rowTitleFields.add(title);
                }
                if (title.getTypeOfComponent().startsWith("Col:")) {
                    colTitleFields.add(title);
                }
                if (title.getTypeOfComponent().startsWith("LeftTitle")) {
                    crossLeftTitle = title;
                }
                if (title.getTypeOfComponent().startsWith("RightTitle")) {
                    crossRightTitle = title;
                }
                if (!title.getTypeOfComponent().startsWith("SummaryTitle")) continue;
                crossSummaryTitle = title;
                continue;
            }
            if (row != null) {
                rowFields.add(row);
                if (!row.isTotalVisible()) {
                    row.getTotal().setHeight(0.0);
                }
            }
            if (col != null) {
                colFields.add(col);
                if (!col.isTotalVisible()) {
                    col.getTotal().setWidth(0.0);
                }
            }
            if (sum != null && sum.getEnabled() && !sum.isDisabledByCondition()) {
                sumFields.add(sum);
            }
            if (sumHeader != null && sumHeader.getEnabled() && !sumHeader.isDisabledByCondition()) {
                sumHeaderFields.add(sumHeader);
            }
            StiDataColumn column = new StiDataColumn(component.getName(), component.getName(), (StiSystemType)new StiSystemObject());
            table.getColumns().add(column);
            if (!(component instanceof StiCrossHeader)) continue;
            String colName = "Display__" + component.getName();
            column = new StiDataColumn(colName, colName, (StiSystemType)new StiSystemObject());
            table.getColumns().add(column);
        }
        if (!designTime) {
            masterCrossTab.First();
            while (!masterCrossTab.getIsEof()) {
                DataRow row = table.NewRow();
                for (StiComponent component : masterCrossTab.getComponents()) {
                    if (component instanceof StiCrossSummaryHeader) continue;
                    StiCrossCell cell = (StiCrossCell)(component instanceof StiCrossCell ? component : null);
                    if (cell != null) {
                        StiGetCrossValueEventArgs arg = new StiGetCrossValueEventArgs();
                        cell.InvokeGetCrossValue(component, arg);
                        row.setValue(cell.getName(), arg.getValue());
                        if (!(cell instanceof StiCrossHeader)) continue;
                        arg = new StiGetCrossValueEventArgs();
                        if (cell instanceof StiCrossHeader) {
                            ((StiCrossHeader)cell).InvokeGetDisplayCrossValue(arg);
                        }
                        row.setValue("Display__" + component.getName(), arg.getValue());
                        continue;
                    }
                    if (!(component instanceof StiCrossTitle)) continue;
                    StiGetValueEventArgs args = new StiGetValueEventArgs();
                    ((StiCrossTitle)component).InvokeGetValue(component, args);
                    ((StiCrossTitle)component).setTextValue(args.getValue());
                }
                table.getRows().add(row);
                masterCrossTab.Next();
            }
        }
        masterCrossTab.getCrossTabInfo().Cross = new StiCross();
        masterCrossTab.getCrossTabInfo().Cross.setDesignTime(designTime);
        masterCrossTab.getCrossTabInfo().Cross.setColFields(colFields);
        masterCrossTab.getCrossTabInfo().Cross.setRowFields(rowFields);
        masterCrossTab.getCrossTabInfo().Cross.setSumFields(sumFields);
        masterCrossTab.getCrossTabInfo().Cross.setSumHeaderFields(sumHeaderFields);
        masterCrossTab.getCrossTabInfo().Cross.setColTitleFields(colTitleFields);
        masterCrossTab.getCrossTabInfo().Cross.setRowTitleFields(rowTitleFields);
        masterCrossTab.getCrossTabInfo().Cross.setLeftCrossTitle(crossLeftTitle);
        masterCrossTab.getCrossTabInfo().Cross.setRightCrossTitle(crossRightTitle);
        masterCrossTab.getCrossTabInfo().Cross.setSummaryCrossTitle(crossSummaryTitle);
        masterCrossTab.getCrossTabInfo().Cross.crossTab = masterCrossTab;
        masterCrossTab.getCrossTabInfo().Cross.Create(table, masterCrossTab.getReport(), masterCrossTab.getSummaryDirection(), masterCrossTab.getEmptyValue());
        masterCrossTab.getCrossTabInfo().Cross.crossTab = null;
    }

    public static int GetEndCol(StiCrossTab masterCrossTab, int startCol, StiRectangle rect) {
        int maxCol = masterCrossTab.getCrossTabInfo().Cross.getColCount();
        if (masterCrossTab.getHorAlignment() != StiCrossHorAlignment.None && masterCrossTab.getHorAlignment() != StiCrossHorAlignment.Left && !masterCrossTab.getWrap()) {
            return maxCol;
        }
        int endCol = startCol;
        double width = 0.0;
        for (int index = startCol; index < masterCrossTab.getCrossTabInfo().Cross.getColCount() && !((width += masterCrossTab.getCrossTabInfo().Cross.getWidths()[index]) > rect.getWidth()); ++index) {
            ++endCol;
        }
        if (endCol == startCol && endCol + 1 <= maxCol) {
            ++endCol;
        }
        return endCol;
    }

    public static int GetEndRow(StiCrossTab masterCrossTab, int startRow, StiRectangle rect) {
        int maxRow = masterCrossTab.getCrossTabInfo().Cross.getRowCount();
        int endRow = startRow;
        double height = 0.0;
        for (int index = startRow; index < masterCrossTab.getCrossTabInfo().Cross.getRowCount() && !((height += masterCrossTab.getCrossTabInfo().Cross.getHeights()[index]) > rect.getHeight()); ++index) {
            ++endRow;
        }
        if (endRow == startRow && endRow + 1 <= maxRow) {
            ++endRow;
        }
        return endRow;
    }

    public static int checkMergedRowCells(StiCrossTab masterCrossTab, int startRow, int endRow, int startCol, int endCol) {
        StiCell[][] cells = masterCrossTab.crossTabInfo.Cross.getCells();
        int mHeight = 0;
        for (int x = startCol; x < endCol; ++x) {
            StiCell cell = cells[x][endRow - 1];
            StiCell parent = cell.getParentCell();
            if (cell.field == null || cell.getHeight() <= 1 || parent == null || !parent.isKeepMergedCellsTogether()) continue;
            mHeight = Math.max(mHeight, parent.getHeight() - cell.getHeight() + 1);
        }
        return Math.max(endRow - mHeight, startRow + 1);
    }

    public static boolean IsColFieldsEmpty(StiCrossTab masterCrossTab) {
        return masterCrossTab.getCrossTabInfo().Cross.getColFields().size() == 1 && ((StiComponent)masterCrossTab.getCrossTabInfo().Cross.getColFields().get(0)).getName() == "EMPTY_FIELD";
    }

    public static boolean IsRowFieldsEmpty(StiCrossTab masterCrossTab) {
        return masterCrossTab.getCrossTabInfo().Cross.getRowFields().size() == 1 && ((StiComponent)masterCrossTab.getCrossTabInfo().Cross.getRowFields().get(0)).getName() == "EMPTY_FIELD";
    }

    public static void CreateCross(StiCrossTab masterCrossTab) {
        masterCrossTab.getCrossTabInfoV1().StartRow = 0;
        masterCrossTab.getCrossTabInfoV1().StartCol = 0;
        StiDataBand masterComponent = (StiDataBand)(masterCrossTab.getParent() instanceof StiDataBand ? masterCrossTab.getParent() : null);
        StiDataHelper.SetData(masterCrossTab, true, masterComponent);
        StiCrossTabHelper.BuildCross(masterCrossTab, false);
        masterCrossTab.getCrossTabInfo().Cross.MaxWidth = masterCrossTab.getPage().getWidth();
        masterCrossTab.getCrossTabInfo().Cross.MaxHeight = masterCrossTab.getPage().getHeight();
        if (masterCrossTab.getRightToLeft()) {
            StiCrossTabHelper.MakeRightToLeft(masterCrossTab);
        }
        IsCrossTabRendering = true;
        masterCrossTab.getCrossTabInfo().Cross.DoAutoSize();
        IsCrossTabRendering = false;
    }

    public static void MakeRightToLeft(StiCrossTab masterCrossTab) {
        StiCross cross = masterCrossTab.getCrossTabInfo().Cross;
        StiCell[][] newCells = new StiCell[cross.getColCount()][];
        for (int indexCol = 0; indexCol < cross.getColCount(); ++indexCol) {
            newCells[indexCol] = new StiCell[cross.getRowCount()];
            for (int indexRow = 0; indexRow < cross.getRowCount(); ++indexRow) {
                StiCell cell;
                newCells[indexCol][indexRow] = cell = cross.getCells()[cross.getColCount() - indexCol - 1][indexRow];
            }
        }
        Hashtable<String, Integer> hideCells = new Hashtable<String, Integer>();
        for (int indexCol = 0; indexCol < cross.getColCount(); ++indexCol) {
            for (int indexRow = 0; indexRow < cross.getRowCount(); ++indexRow) {
                StiCell cell;
                if (indexRow < 2) {
                    cell = newCells[cross.getColCount() - indexCol - 1][indexRow];
                    if (cell == null || cell.getWidth() <= 1 || cell.getIsChangeWidthForRightToLeft()) continue;
                    int number = 0;
                    if (hideCells.contains(cell.getText())) {
                        number = (Integer)hideCells.get(cell.getText());
                        if (cell.getWidth() == 2) {
                            hideCells.remove(cell.getText());
                        }
                    } else {
                        number = indexCol;
                        hideCells.put(cell.getText(), indexCol);
                    }
                    StiCell oldCell = newCells[cross.getColCount() - number - cell.getWidth()][indexRow];
                    cell.setIsChangeWidthForRightToLeft(true);
                    oldCell.setIsChangeWidthForRightToLeft(true);
                    newCells[cross.getColCount() - number - cell.getWidth()][indexRow] = cell;
                    newCells[cross.getColCount() - indexCol - 1][indexRow] = oldCell;
                    continue;
                }
                cell = newCells[indexCol][indexRow];
                if (cell == null || cell.getWidth() <= 1) continue;
                StiCell oldCell = newCells[indexCol - cell.getWidth() + 1][indexRow];
                newCells[indexCol - cell.getWidth() + 1][indexRow] = cell;
                newCells[indexCol][indexRow] = oldCell;
            }
        }
        hideCells.clear();
        cross.setCells(newCells);
        StiComponentsCollection comps = new StiComponentsCollection();
        for (int indexCol = cross.getColFields().size() - 1; indexCol >= 0; --indexCol) {
            comps.add((StiComponent)cross.getColFields().get(indexCol));
        }
    }

    public static void CalculateMaxAndMin(StiContainer outContainer, StiRefObject<Double> maxLeft, StiRefObject<Double> maxRight, int startIndex) {
        maxLeft.argvalue = 0.0;
        maxRight.argvalue = 0.0;
        for (int index = startIndex; index < outContainer.getComponents().size(); ++index) {
            StiComponent comp = (StiComponent)outContainer.getComponents().get(index);
            if (index == startIndex) {
                maxLeft.argvalue = comp.getLeft();
                maxRight.argvalue = comp.getRight();
                continue;
            }
            maxLeft.argvalue = Math.min((Double)maxLeft.argvalue, comp.getLeft());
            maxRight.argvalue = Math.max((Double)maxRight.argvalue, comp.getRight());
        }
    }

    public static void MakeHorAlignmentByWidth(StiContainer outContainer, int startIndex) {
        Double[] keys;
        double maxLeft = 0.0;
        double maxRight = 0.0;
        StiRefObject tempRef_maxLeft = new StiRefObject((Object)maxLeft);
        StiRefObject tempRef_maxRight = new StiRefObject((Object)maxRight);
        StiCrossTabHelper.CalculateMaxAndMin(outContainer, (StiRefObject<Double>)tempRef_maxLeft, (StiRefObject<Double>)tempRef_maxRight, startIndex);
        maxLeft = (Double)tempRef_maxLeft.argvalue;
        maxRight = (Double)tempRef_maxRight.argvalue;
        Hashtable<Double, Double> coordForAlignWidth = new Hashtable<Double, Double>();
        for (int index = startIndex; index < outContainer.getComponents().size(); ++index) {
            StiComponent comp = (StiComponent)outContainer.getComponents().get(index);
            coordForAlignWidth.put(comp.getLeft(), comp.getLeft());
            coordForAlignWidth.put(comp.getRight(), comp.getRight());
        }
        double scale = outContainer.getWidth() / (maxRight - maxLeft);
        Double[] doubleArray = keys = coordForAlignWidth.keySet().toArray(new Double[coordForAlignWidth.size()]);
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            double value = doubleArray[i];
            double newValue = value - maxLeft;
            newValue = StiAlignValue.alignToGrid((double)(newValue * scale), (double)0.01, (boolean)true);
            coordForAlignWidth.put(value, newValue);
        }
        for (int index = startIndex; index < outContainer.getComponents().size(); ++index) {
            StiText text;
            StiComponent comp = (StiComponent)outContainer.getComponents().get(index);
            double valueLeft = 0.0;
            if (coordForAlignWidth.containsKey(comp.getLeft())) {
                valueLeft = (Double)coordForAlignWidth.get(comp.getLeft());
            }
            double valueRight = 0.0;
            if (coordForAlignWidth.containsKey(comp.getRight())) {
                valueRight = (Double)coordForAlignWidth.get(comp.getRight());
            }
            comp.setLeft(valueLeft);
            comp.setWidth(valueRight - valueLeft);
            if (!(scale < 1.0) || (text = (StiText)comp) == null) continue;
            text.setFont(StiFont.changeFontSize((StiFont)text.getFont(), (double)(text.getFont().size * (double)((float)scale))));
        }
    }
}

