/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.textFormats;

import com.stimulsoft.base.DBNull;
import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.helper.StiValueHelper;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiTextFormatState;
import com.stimulsoft.report.components.textFormats.StiFormatService;
import com.stimulsoft.report.helpers.StiAbbreviationNumberFormatHelper;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class StiNumberFormatService
extends StiFormatService {
    private BitsNumberFormatService bits;

    protected static void FillLocalSetting(DecimalFormat format) {
    }

    public StiNumberFormatService() {
    }

    public StiNumberFormatService(int negativePattern, String decimalSeparator, int decimalDigits, String groupSeparator, int groupSize, boolean useGroupSeparator, boolean useLocalSetting, String nullDisplay) {
        this(negativePattern, 0, decimalSeparator, decimalDigits, groupSeparator, groupSize, useGroupSeparator, useLocalSetting, nullDisplay);
    }

    public StiNumberFormatService(int negativePattern, int decimalPlaces, String decimalSeparator, int decimalDigits, String groupSeparator, int groupSize, boolean useGroupSeparator, boolean useLocalSetting, String nullDisplay) {
        this.setDecimalDigits(decimalDigits);
        this.setDecimalSeparator(decimalSeparator);
        this.setGroupSeparator(groupSeparator);
        this.setGroupSize(groupSize);
        this.setNegativePattern(negativePattern);
        this.setUseGroupSeparator(useGroupSeparator);
        this.setUseLocalSetting(useLocalSetting);
        this.setNullDisplay(nullDisplay);
    }

    public String getServiceName() {
        return StiLocalization.Get((String)"FormFormatEditor", (String)"Number");
    }

    @Override
    public int getPosition() {
        return 2;
    }

    @StiDefaulValue(value=" ")
    @StiSerializable
    public final String getNullDisplay() {
        if (this.bits == null) {
            return " ";
        }
        return this.bits.nullDisplay;
    }

    public final void setNullDisplay(String value) {
        if (value.equals(" ") && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.nullDisplay = value;
        } else {
            this.bits = new BitsNumberFormatService(this.getNegativePattern(), this.getDecimalSeparator(), this.getDecimalDigits(), this.getGroupSeparator(), this.getGroupSize(), this.getUseGroupSeparator(), this.getUseLocalSetting(), value, this.getState());
        }
    }

    @StiSerializable
    public int getNegativePattern() {
        if (this.bits == null) {
            return 1;
        }
        return this.bits.negativePattern;
    }

    public final void setNegativePattern(int value) {
        if (value == 1 && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.negativePattern = value;
        } else {
            this.bits = new BitsNumberFormatService(value, this.getDecimalSeparator(), this.getDecimalDigits(), this.getGroupSeparator(), this.getGroupSize(), this.getUseGroupSeparator(), this.getUseLocalSetting(), this.getNullDisplay(), this.getState());
        }
    }

    @StiDefaulValue(value=".")
    @StiSerializable
    public String getDecimalSeparator() {
        if (this.bits == null) {
            return ".";
        }
        return this.bits.decimalSeparator;
    }

    public final void setDecimalSeparator(String value) {
        if (value.equals(".") && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.decimalSeparator = value;
        } else {
            this.bits = new BitsNumberFormatService(this.getNegativePattern(), value, this.getDecimalDigits(), this.getGroupSeparator(), this.getGroupSize(), this.getUseGroupSeparator(), this.getUseLocalSetting(), this.getNullDisplay(), this.getState());
        }
    }

    @StiDefaulValue(value="2")
    @StiSerializable
    public int getDecimalDigits() {
        if (this.bits == null) {
            return 2;
        }
        return this.bits.decimalDigits;
    }

    public final void setDecimalDigits(int value) {
        if (value == 2 && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.decimalDigits = value;
        } else {
            this.bits = new BitsNumberFormatService(this.getNegativePattern(), this.getDecimalSeparator(), value, this.getGroupSeparator(), this.getGroupSize(), this.getUseGroupSeparator(), this.getUseLocalSetting(), this.getNullDisplay(), this.getState());
        }
    }

    @StiSerializable
    public String getGroupSeparator() {
        if (this.bits == null) {
            return " ";
        }
        return this.bits.groupSeparator;
    }

    public final void setGroupSeparator(String value) {
        if (value.equals(" ") && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.groupSeparator = value;
        } else {
            this.bits = new BitsNumberFormatService(this.getNegativePattern(), this.getDecimalSeparator(), this.getDecimalDigits(), value, this.getGroupSize(), this.getUseGroupSeparator(), this.getUseLocalSetting(), this.getNullDisplay(), this.getState());
        }
    }

    @StiDefaulValue(value="3")
    @StiSerializable
    public int getGroupSize() {
        if (this.bits == null) {
            return 3;
        }
        return this.bits.groupSize;
    }

    public final void setGroupSize(int value) {
        if (value == 3 && this.bits == null) {
            return;
        }
        if (value > 9) {
            value = 9;
        }
        if (this.bits != null) {
            this.bits.groupSize = value;
        } else {
            this.bits = new BitsNumberFormatService(this.getNegativePattern(), this.getDecimalSeparator(), this.getDecimalDigits(), this.getGroupSeparator(), value, this.getUseGroupSeparator(), this.getUseLocalSetting(), this.getNullDisplay(), this.getState());
        }
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getUseGroupSeparator() {
        if (this.bits == null) {
            return true;
        }
        return this.bits.useGroupSeparator;
    }

    public final void setUseGroupSeparator(boolean value) {
        if (value && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.useGroupSeparator = value;
        } else {
            this.bits = new BitsNumberFormatService(this.getNegativePattern(), this.getDecimalSeparator(), this.getDecimalDigits(), this.getGroupSeparator(), this.getGroupSize(), value, this.getUseLocalSetting(), this.getNullDisplay(), this.getState());
        }
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getUseLocalSetting() {
        if (this.bits == null) {
            return true;
        }
        return this.bits.useLocalSetting;
    }

    public final void setUseLocalSetting(boolean value) {
        if (value && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.useLocalSetting = value;
        } else {
            this.bits = new BitsNumberFormatService(this.getNegativePattern(), this.getDecimalSeparator(), this.getDecimalDigits(), this.getGroupSeparator(), this.getGroupSize(), this.getUseGroupSeparator(), value, this.getNullDisplay(), this.getState());
        }
    }

    @Override
    @StiSerializable(need=false)
    public String getStringFormat() {
        return super.getStringFormat();
    }

    @Override
    public void setStringFormat(String value) {
        super.setStringFormat(value);
    }

    @Override
    public Object getSample() {
        return -1234.123456789;
    }

    @Override
    public String getNativeFormatString() {
        return "{0:N2}";
    }

    @Override
    public boolean equals(Object obj) {
        StiNumberFormatService format = (StiNumberFormatService)((Object)(obj instanceof StiNumberFormatService ? obj : null));
        if (format == null) {
            return false;
        }
        if (!this.getNullDisplay().equals(format.getNullDisplay())) {
            return false;
        }
        if (this.getNegativePattern() != format.getNegativePattern()) {
            return false;
        }
        if (this.getDecimalDigits() != format.getDecimalDigits()) {
            return false;
        }
        if (!this.getDecimalSeparator().equals(format.getDecimalSeparator())) {
            return false;
        }
        if (!this.getGroupSeparator().equals(format.getGroupSeparator())) {
            return false;
        }
        if (this.getGroupSize() != format.getGroupSize()) {
            return false;
        }
        if (this.getUseGroupSeparator() != format.getUseGroupSeparator()) {
            return false;
        }
        if (this.getUseLocalSetting() != format.getUseLocalSetting()) {
            return false;
        }
        return this.getStringFormat().equals(format.getStringFormat());
    }

    @Override
    public String format(String stringFormat, Object value, Locale locale) {
        String result;
        Double val;
        BigDecimal decimal;
        Double convertedArg;
        if (value == null || value instanceof DBNull) {
            return this.getNullDisplay();
        }
        if (StiOptions.Engine.allowConvertingInFormatting && !(value instanceof Number) && (convertedArg = StiValueHelper.tryToNullableDouble((Object)value)) != null) {
            value = convertedArg;
        }
        try {
            decimal = new BigDecimal(value.toString());
        }
        catch (Exception e) {
            return value != null ? value.toString() : "";
        }
        String postfix = "";
        if (this.getState().contains((IStiEnum)StiTextFormatState.Abbreviation) && (val = Double.valueOf(StiValueHelper.tryToDouble((Object)value))) != null) {
            StiRefObject postfixRef = new StiRefObject((Object)"");
            val = StiAbbreviationNumberFormatHelper.format(val, (StiRefObject<String>)postfixRef);
            decimal = new BigDecimal(val);
            postfix = (String)postfixRef.argvalue;
        }
        DecimalFormat form = null;
        if (this.getUseLocalSetting()) {
            DecimalFormatSymbols dfs;
            form = (DecimalFormat)DecimalFormat.getInstance(locale != null ? locale : Locale.ENGLISH);
            if (this.getState().contains((IStiEnum)StiTextFormatState.DecimalDigits)) {
                form.setMaximumFractionDigits(this.getDecimalDigits());
                form.setMinimumFractionDigits(this.getDecimalDigits());
            }
            if (this.getState().contains((IStiEnum)StiTextFormatState.DecimalSeparator) && StiValidationUtil.isNotNullOrEmpty((String)this.getDecimalSeparator())) {
                dfs = form.getDecimalFormatSymbols();
                dfs.setDecimalSeparator(this.getDecimalSeparator().charAt(0));
                form.setDecimalFormatSymbols(dfs);
            }
            if (this.getState().contains((IStiEnum)StiTextFormatState.GroupSeparator) && StiValidationUtil.isNotNullOrEmpty((String)this.getGroupSeparator())) {
                dfs = form.getDecimalFormatSymbols();
                dfs.setGroupingSeparator(this.getGroupSeparator().charAt(0));
                form.setDecimalFormatSymbols(dfs);
            }
            if (this.getState().contains((IStiEnum)StiTextFormatState.GroupSize)) {
                form.setGroupingUsed(this.getUseGroupSeparator());
                form.setGroupingSize(this.getGroupSize());
            }
            if (this.getState().contains((IStiEnum)StiTextFormatState.NegativePattern) && this.getNegativePattern() != 1 && decimal.doubleValue() < 0.0) {
                result = form.format(decimal).replaceFirst("-", "");
                result = result + postfix;
                switch (this.getNegativePattern()) {
                    case 0: {
                        return "(" + result + ")";
                    }
                    case 2: {
                        return "- " + result;
                    }
                    case 3: {
                        return result + "-";
                    }
                    case 4: {
                        return result + " -";
                    }
                }
            }
        } else {
            form = (DecimalFormat)DecimalFormat.getInstance();
            form.setGroupingUsed(this.getUseGroupSeparator());
            form.setGroupingSize(this.getGroupSize());
            form.setDecimalFormatSymbols(this.getDecimalFormatSymbols(form));
            form.setMaximumFractionDigits(this.getDecimalDigits());
            form.setMinimumFractionDigits(this.getDecimalDigits());
            if (this.getNegativePattern() != 1 && decimal.doubleValue() < 0.0) {
                result = form.format(decimal).replaceFirst("-", "");
                result = result + postfix;
                switch (this.getNegativePattern()) {
                    case 0: {
                        return "(" + result + ")";
                    }
                    case 2: {
                        return "- " + result;
                    }
                    case 3: {
                        return result + "-";
                    }
                    case 4: {
                        return result + " -";
                    }
                }
            }
        }
        return form.format(decimal) + postfix;
    }

    protected DecimalFormatSymbols getDecimalFormatSymbols(DecimalFormat form) {
        DecimalFormatSymbols dfs = form.getDecimalFormatSymbols();
        dfs.setGroupingSeparator(StiValidationUtil.isNotNullOrEmpty((String)this.getGroupSeparator()) ? this.getGroupSeparator().charAt(0) : (char)' ');
        dfs.setDecimalSeparator(StiValidationUtil.isNotNullOrEmpty((String)this.getDecimalSeparator()) ? this.getDecimalSeparator().charAt(0) : (char)',');
        return dfs;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("StringFormat");
        jObject.AddPropertyIntNoDefaultValue("NegativePattern", Integer.valueOf(this.getNegativePattern()));
        jObject.AddPropertyString("DecimalSeparator", this.getDecimalSeparator(), ".");
        jObject.AddPropertyInt("DecimalDigits", this.getDecimalDigits(), 2);
        jObject.AddPropertyString("GroupSeparator", this.getGroupSeparator());
        jObject.AddPropertyInt("GroupSize", this.getGroupSize(), 3);
        jObject.AddPropertyBool("UseGroupSeparator", this.getUseGroupSeparator(), true);
        jObject.AddPropertyBool("UseLocalSetting", this.getUseLocalSetting(), true);
        jObject.AddPropertyString("NullDisplay", this.getNullDisplay(), " ");
        jObject.AddPropertyEnum("State", this.getState(), (IStiEnum)StiTextFormatState.None);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("NegativePattern")) {
                this.setNegativePattern((Integer)property.Value);
                continue;
            }
            if (property.Name.equals("DecimalSeparator")) {
                this.setDecimalSeparator((String)property.Value);
                continue;
            }
            if (property.Name.equals("DecimalDigits")) {
                this.setDecimalDigits((Integer)property.Value);
                continue;
            }
            if (property.Name.equals("GroupSeparator")) {
                this.setGroupSeparator((String)property.Value);
                continue;
            }
            if (property.Name.equals("GroupSize")) {
                this.setGroupSize((Integer)property.Value);
                continue;
            }
            if (property.Name.equals("UseGroupSeparator")) {
                this.setUseGroupSeparator((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("UseLocalSetting")) {
                this.setUseLocalSetting((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("NullDisplay")) {
                this.setNullDisplay((String)property.Value);
                continue;
            }
            if (!property.Name.equals("State")) continue;
            this.setState((StiEnumSet<StiTextFormatState>)StiEnumSet.stringToEnums(StiTextFormatState.class, (String)((String)property.Value)));
        }
    }

    private static class BitsNumberFormatService
    implements Cloneable {
        public int negativePattern;
        public String decimalSeparator;
        public int decimalDigits;
        public String groupSeparator;
        public int groupSize;
        public boolean useGroupSeparator;
        public boolean useLocalSetting;
        public String nullDisplay;
        public StiEnumSet<StiTextFormatState> states;

        public BitsNumberFormatService(int negativePattern, String decimalSeparator, int decimalDigits, String groupSeparator, int groupSize, boolean useGroupSeparator, boolean useLocalSetting, String nullDisplay, StiEnumSet<StiTextFormatState> states) {
            this.negativePattern = negativePattern;
            this.decimalSeparator = decimalSeparator;
            this.decimalDigits = decimalDigits;
            this.groupSeparator = groupSeparator;
            this.groupSize = groupSize;
            this.useGroupSeparator = useGroupSeparator;
            this.useLocalSetting = useLocalSetting;
            this.nullDisplay = nullDisplay;
            this.states = states;
        }
    }
}

