/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.textFormats;

import com.stimulsoft.base.DBNull;
import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.helper.StiValueHelper;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.lib.utils.StiCurrencyFormat;
import com.stimulsoft.lib.utils.StiCurrencyHelper;
import com.stimulsoft.lib.utils.StiTypeConverter;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.components.StiTextFormatState;
import com.stimulsoft.report.components.textFormats.StiNumberFormatService;
import com.stimulsoft.report.helpers.StiAbbreviationNumberFormatHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;

public class StiCurrencyFormatService
extends StiNumberFormatService {
    private int positivePattern = 1;
    private String symbol = "$";
    private String culture;

    public StiCurrencyFormatService() {
    }

    public StiCurrencyFormatService(int positivePattern, int negativePattern, String decimalSeparator, int decimalDigits, String groupSeparator, int groupSize, String symbol, boolean useGroupSeparator, boolean useLocalSetting, String nullDisplay) {
        this(positivePattern, negativePattern, 0, decimalSeparator, decimalDigits, groupSeparator, groupSize, symbol, useGroupSeparator, useLocalSetting, nullDisplay);
    }

    public StiCurrencyFormatService(int positivePattern, int negativePattern, int decimalPlaces, String decimalSeparator, int decimalDigits, String groupSeparator, int groupSize, String symbol, boolean useGroupSeparator, boolean useLocalSetting, String nullDisplay) {
        super(negativePattern, decimalSeparator, decimalDigits, groupSeparator, groupSize, useGroupSeparator, useLocalSetting, nullDisplay);
        this.setDecimalDigits(decimalDigits);
        this.setDecimalSeparator(decimalSeparator);
        this.setGroupSeparator(groupSeparator);
        this.setGroupSize(groupSize);
        this.setNegativePattern(negativePattern);
        this.setPositivePattern(positivePattern);
        this.setSymbol(symbol);
        this.setUseGroupSeparator(useGroupSeparator);
        this.setUseLocalSetting(useLocalSetting);
        this.setNullDisplay(nullDisplay);
    }

    @Override
    public String getServiceName() {
        return StiLocalization.getValue((String)"FormFormatEditor", (String)"Currency");
    }

    @Override
    public int getPosition() {
        return 3;
    }

    public String getCulture() {
        if (this.culture == null) {
            this.culture = Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry();
        }
        return this.culture;
    }

    public void setCulture(String culture) {
        this.culture = culture;
    }

    @StiDefaulValue(value="1")
    @StiSerializable
    public final int getPositivePattern() {
        return !this.getState().contains((IStiEnum)StiTextFormatState.PositivePattern) && this.getUseLocalSetting() && this.getCulture() != null && StiCurrencyHelper.getCurrencySymbol().containsKey(this.getCulture()) ? ((StiCurrencyFormat)StiCurrencyHelper.getCurrencySymbol().get(this.getCulture())).getCurrencyPositivePattern() : this.positivePattern;
    }

    @Override
    @StiSerializable
    public final int getNegativePattern() {
        return !this.getState().contains((IStiEnum)StiTextFormatState.NegativePattern) && this.getUseLocalSetting() && this.getCulture() != null && StiCurrencyHelper.getCurrencySymbol().containsKey(this.getCulture()) ? ((StiCurrencyFormat)StiCurrencyHelper.getCurrencySymbol().get(this.getCulture())).getCurrencyNegativePattern() : super.getNegativePattern();
    }

    @Override
    @StiSerializable
    public int getDecimalDigits() {
        return !this.getState().contains((IStiEnum)StiTextFormatState.DecimalDigits) && this.getUseLocalSetting() && this.getCulture() != null && StiCurrencyHelper.getCurrencySymbol().containsKey(this.getCulture()) ? ((StiCurrencyFormat)StiCurrencyHelper.getCurrencySymbol().get(this.getCulture())).getDecimalDigits() : super.getDecimalDigits();
    }

    @Override
    @StiSerializable
    public final String getDecimalSeparator() {
        return !this.getState().contains((IStiEnum)StiTextFormatState.DecimalSeparator) && this.getUseLocalSetting() && this.getCulture() != null && StiCurrencyHelper.getCurrencySymbol().containsKey(this.getCulture()) ? ((StiCurrencyFormat)StiCurrencyHelper.getCurrencySymbol().get(this.getCulture())).getDecimalSeparator() : super.getDecimalSeparator();
    }

    public final void setPositivePattern(int value) {
        this.positivePattern = value;
    }

    @Override
    @StiSerializable
    public String getGroupSeparator() {
        return !this.getState().contains((IStiEnum)StiTextFormatState.GroupSeparator) && this.getUseLocalSetting() && this.getCulture() != null && StiCurrencyHelper.getCurrencySymbol().containsKey(this.getCulture()) ? ((StiCurrencyFormat)StiCurrencyHelper.getCurrencySymbol().get(this.getCulture())).getGroupSeparator() : super.getGroupSeparator();
    }

    public int[] getGroupSizes() {
        int[] nArray;
        if (!this.getState().contains((IStiEnum)StiTextFormatState.GroupSize) && this.getUseLocalSetting() && this.getCulture() != null && StiCurrencyHelper.getCurrencySymbol().containsKey(this.getCulture())) {
            nArray = ((StiCurrencyFormat)StiCurrencyHelper.getCurrencySymbol().get(this.getCulture())).getGroupSizes();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = super.getGroupSize();
        }
        return nArray;
    }

    @StiDefaulValue(value="$")
    @StiSerializable
    public final String getSymbol() {
        return !this.getState().contains((IStiEnum)StiTextFormatState.CurrencySymbol) && this.getUseLocalSetting() && this.getCulture() != null && StiCurrencyHelper.getCurrencySymbol().containsKey(this.getCulture()) ? ((StiCurrencyFormat)StiCurrencyHelper.getCurrencySymbol().get(this.getCulture())).getSymbol() : this.symbol;
    }

    public final void setSymbol(String value) {
        this.symbol = value;
    }

    @Override
    public String getNativeFormatString() {
        return "{0:C2}";
    }

    @Override
    public Object getSample() {
        return -1234.12345679;
    }

    @Override
    public String getStringFormat() {
        return super.getStringFormat();
    }

    @Override
    public void setStringFormat(String value) {
        super.setStringFormat(value);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.positivePattern;
        result = 31 * result + (this.symbol == null ? 0 : this.symbol.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        StiCurrencyFormatService other = (StiCurrencyFormatService)((Object)obj);
        if (this.positivePattern != other.positivePattern) {
            return false;
        }
        return !(this.symbol == null ? other.symbol != null : !this.symbol.equals(other.symbol));
    }

    @Override
    public String format(String stringFormat, Object arg, Locale locale) {
        int groupIndex;
        Double value;
        if (StiValidationUtil.isEmpty((Object)arg) || arg instanceof DBNull) {
            return this.getNullDisplay();
        }
        if (StiValidationUtil.isNotNumber((Object)arg)) {
            return arg.toString();
        }
        Double val = StiTypeConverter.stringToDouble((String)arg.toString());
        String postfix = "";
        if (this.getState().contains((IStiEnum)StiTextFormatState.Abbreviation) && (value = Double.valueOf(StiValueHelper.tryToDouble((Object)arg))) != null) {
            StiRefObject postfixRef = new StiRefObject((Object)"");
            val = value = Double.valueOf(StiAbbreviationNumberFormatHelper.format(value, (StiRefObject<String>)postfixRef));
            postfix = (String)postfixRef.argvalue;
        }
        String result = "";
        Double abs = Math.abs(val);
        Boolean sign = val < 0.0;
        Long integerPart = (long)Math.floor(abs);
        double decimalPower = Math.pow(10.0, this.getDecimalDigits());
        Long decimalPart = Math.round((new BigDecimal(String.valueOf(abs)).setScale(this.getDecimalDigits(), RoundingMode.HALF_UP).doubleValue() - (double)integerPart.longValue()) * decimalPower);
        if ((double)decimalPart.longValue() >= decimalPower) {
            Long l = integerPart;
            Long l2 = integerPart = Long.valueOf(integerPart + 1L);
            decimalPart = 0L;
        }
        String integerStr = integerPart.toString();
        int[] groupSizes = this.getGroupSizes();
        if (groupSizes[groupIndex = 0] > 0 && this.getUseGroupSeparator()) {
            int index;
            for (index = integerStr.length() - groupSizes[groupIndex]; index >= 0; index -= groupSizes[groupIndex]) {
                result = (index > 0 ? this.getGroupSeparator() : "") + integerStr.substring(index, index + groupSizes[groupIndex]) + result;
                ++groupIndex;
                groupIndex = Math.min(groupIndex, groupSizes.length - 1);
            }
            if (index < 0) {
                result = integerStr.substring(0, index + groupSizes[groupIndex]) + result;
            }
        } else {
            result = integerStr;
        }
        if (this.getDecimalDigits() > 0) {
            integerStr = decimalPart.toString();
            while (integerStr.length() < this.getDecimalDigits()) {
                integerStr = "0" + integerStr;
            }
            result = result + this.getDecimalSeparator() + integerStr;
        }
        result = result + postfix;
        String symbol = this.getSymbol();
        if (!sign.booleanValue()) {
            switch (this.getPositivePattern()) {
                case 0: {
                    result = symbol + result;
                    break;
                }
                case 2: {
                    result = symbol + " " + result;
                    break;
                }
                case 3: {
                    result = result + " " + symbol;
                    break;
                }
                default: {
                    result = result + symbol;
                    break;
                }
            }
        } else {
            switch (this.getNegativePattern()) {
                case 0: {
                    result = "(" + symbol + result + ")";
                    break;
                }
                case 1: {
                    result = "-" + symbol + result;
                    break;
                }
                case 2: {
                    result = symbol + "-" + result;
                    break;
                }
                case 3: {
                    result = symbol + result + "-";
                    break;
                }
                case 4: {
                    result = "(" + result + symbol + ")";
                    break;
                }
                case 6: {
                    result = result + "-" + symbol;
                    break;
                }
                case 7: {
                    result = result + symbol + "-";
                    break;
                }
                case 8: {
                    result = "-" + result + " " + symbol;
                    break;
                }
                case 9: {
                    result = "-" + symbol + " " + result;
                    break;
                }
                case 10: {
                    result = result + " " + symbol + "-";
                    break;
                }
                case 11: {
                    result = symbol + " " + result + "-";
                    break;
                }
                case 12: {
                    result = symbol + " -" + result;
                    break;
                }
                case 13: {
                    result = symbol + result + "-";
                    break;
                }
                case 14: {
                    result = result + "- " + symbol;
                    break;
                }
                case 15: {
                    result = "(" + symbol + " " + result + ")";
                    break;
                }
                case 16: {
                    result = "(" + result + " " + symbol + ")";
                    break;
                }
                default: {
                    result = "-" + result + symbol;
                }
            }
        }
        return result;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("StringFormat");
        jObject.AddPropertyIntNoDefaultValue("PositivePattern", Integer.valueOf(this.getPositivePattern()));
        jObject.AddPropertyString("Symbol", this.getSymbol(), "$");
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("PositivePattern")) {
                this.positivePattern = (Integer)property.Value;
                continue;
            }
            if (!property.Name.equals("Symbol")) continue;
            this.symbol = (String)property.Value;
        }
    }
}

