/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.table;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.StiAppExpressionCollection;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.StiRepositoryItems;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiEmptyBrush;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiFiltersCollection;
import com.stimulsoft.report.components.StiInteraction;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiChildBand;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiDynamicBand;
import com.stimulsoft.report.components.bands.StiEmptyBand;
import com.stimulsoft.report.components.bands.StiFooterBand;
import com.stimulsoft.report.components.bands.StiGroupFooterBand;
import com.stimulsoft.report.components.bands.StiGroupHeaderBand;
import com.stimulsoft.report.components.bands.StiHeaderBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.complexcomponents.StiPanel;
import com.stimulsoft.report.components.conditions.StiConditionsCollection;
import com.stimulsoft.report.components.enums.StiColumnDirection;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.enums.StiDockStyle;
import com.stimulsoft.report.components.enums.StiPrintOnEvenOddPagesType;
import com.stimulsoft.report.components.enums.StiPrintOnType;
import com.stimulsoft.report.components.enums.StiRestrictions;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiBrush;
import com.stimulsoft.report.components.interfaces.IStiDataSource;
import com.stimulsoft.report.components.interfaces.IStiFilter;
import com.stimulsoft.report.components.simplecomponents.StiCheckBox;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiRichText;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.components.table.IStiTableCell;
import com.stimulsoft.report.components.table.IStiTableComponent;
import com.stimulsoft.report.components.table.StiTableCell;
import com.stimulsoft.report.components.table.StiTableCellCheckBox;
import com.stimulsoft.report.components.table.StiTableCellImage;
import com.stimulsoft.report.components.table.StiTableCellRichText;
import com.stimulsoft.report.components.table.enums.StiTableAutoWidth;
import com.stimulsoft.report.components.table.enums.StiTableAutoWidthType;
import com.stimulsoft.report.components.table.enums.StiTableStyle;
import com.stimulsoft.report.dictionary.IStiEnumerator;
import com.stimulsoft.report.units.StiUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;

public class StiTable
extends StiDataBand
implements IStiTableComponent {
    public boolean IsConverted = false;
    private boolean dockableTable = true;
    private StiTableAutoWidth autoWidth = StiTableAutoWidth.None;
    public StiTableAutoWidthType autoWidthType = StiTableAutoWidthType.None;
    private int rowCount = 5;
    private int columnCount = 5;
    private int footerRowsCount = 0;
    private int headerRowsCount = 0;
    private StiPrintOnType headerPrintOn = StiPrintOnType.AllPages;
    private boolean headerCanGrow = true;
    private boolean headerCanShrink = false;
    private boolean headerCanBreak = false;
    private boolean headerPrintAtBottom = false;
    private boolean headerPrintIfEmpty = true;
    private boolean headerPrintOnAllPages = true;
    private StiPrintOnEvenOddPagesType headerPrintOnEvenOddPages = StiPrintOnEvenOddPagesType.Ignore;
    private StiPrintOnType footerPrintOn = StiPrintOnType.AllPages;
    private boolean footerCanGrow = true;
    private boolean footerCanShrink = false;
    private boolean footerCanBreak = false;
    private boolean footerPrintAtBottom = false;
    private boolean footerPrintIfEmpty = true;
    private boolean footerPrintOnAllPages = false;
    private StiPrintOnEvenOddPagesType footerPrintOnEvenOddPages = StiPrintOnEvenOddPagesType.Ignore;
    private int numberID = 0;
    private StiTableStyle tableStyle = StiTableStyle.StyleNone;
    public boolean enabled;

    public StiTable() {
        this(StiRectangle.empty());
    }

    public StiTable(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(true);
    }

    @Override
    public Object clone(boolean cloneProperties, boolean cloneComponents) {
        StiTable cloneTable = (StiTable)super.clone(cloneProperties, false);
        cloneTable.numberID = this.numberID;
        cloneTable.rowCount = this.rowCount;
        cloneTable.columnCount = this.columnCount;
        cloneTable.footerRowsCount = this.footerRowsCount;
        cloneTable.headerRowsCount = this.headerRowsCount;
        cloneTable.tableStyle = this.tableStyle;
        cloneTable.dockableTable = this.dockableTable;
        cloneTable.headerPrintOn = this.headerPrintOn;
        cloneTable.headerCanGrow = this.headerCanGrow;
        cloneTable.headerCanShrink = this.headerCanShrink;
        cloneTable.headerCanBreak = this.headerCanBreak;
        cloneTable.headerPrintAtBottom = this.headerPrintAtBottom;
        cloneTable.headerPrintIfEmpty = this.headerPrintIfEmpty;
        cloneTable.headerPrintOnAllPages = this.headerPrintOnAllPages;
        cloneTable.headerPrintOnEvenOddPages = this.headerPrintOnEvenOddPages;
        cloneTable.footerPrintOn = this.footerPrintOn;
        cloneTable.footerCanGrow = this.footerCanGrow;
        cloneTable.footerCanShrink = this.footerCanShrink;
        cloneTable.footerCanBreak = this.footerCanBreak;
        cloneTable.footerPrintAtBottom = this.footerPrintAtBottom;
        cloneTable.footerPrintIfEmpty = this.footerPrintIfEmpty;
        cloneTable.footerPrintOnAllPages = this.footerPrintOnAllPages;
        cloneTable.footerPrintOnEvenOddPages = this.footerPrintOnEvenOddPages;
        cloneTable.autoWidth = this.autoWidth;
        cloneTable.autoWidthType = this.autoWidthType;
        cloneTable.setComponents(new StiComponentsCollection(cloneTable));
        if (cloneComponents) {
            for (StiComponent comp : this.getComponents()) {
                switch (((IStiTableCell)((Object)comp)).getCellType()) {
                    case Text: {
                        StiTableCell cloneTableCellText = (StiTableCell)comp.clone(true);
                        cloneTableCellText.setParent(cloneTable);
                        cloneTable.getComponents().add(cloneTableCellText);
                        break;
                    }
                    case Image: {
                        StiTableCellImage cloneTableCellImage = (StiTableCellImage)comp.clone(true);
                        cloneTableCellImage.setParent(cloneTable);
                        cloneTable.getComponents().add(cloneTableCellImage);
                        break;
                    }
                    case CheckBox: {
                        StiTableCellCheckBox cloneTableCellCheckBox = (StiTableCellCheckBox)comp.clone(true);
                        cloneTableCellCheckBox.setParent(cloneTable);
                        cloneTable.getComponents().add(cloneTableCellCheckBox);
                        break;
                    }
                    case RichText: {
                        StiTableCellRichText cloneTableCellRichText = (StiTableCellRichText)comp.clone(true);
                        cloneTableCellRichText.setParent(cloneTable);
                        cloneTable.getComponents().add(cloneTableCellRichText);
                    }
                }
            }
        }
        return cloneTable;
    }

    @Override
    public void convert(StiUnit oldUnit, StiUnit newUnit) {
        super.convert(oldUnit, newUnit);
        this.DistributeRows();
        this.DistributeColumns();
    }

    @Override
    public boolean getCanGrow() {
        return super.getCanGrow();
    }

    @Override
    public void setCanGrow(boolean value) {
        super.setCanGrow(value);
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"getComponents()", (String)"StiTable");
    }

    @Override
    public String getLocalizedCategory() {
        return StiLocalization.Get((String)"Report", (String)"Bands");
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.Table.getValue();
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getDockableTable() {
        return this.dockableTable;
    }

    public final void setDockableTable(boolean value) {
        this.dockableTable = value;
    }

    @StiSerializable
    @StiDefaulValue(value="None")
    public final StiTableAutoWidth getAutoWidth() {
        return this.autoWidth;
    }

    public final void setAutoWidth(StiTableAutoWidth value) {
        this.autoWidth = value;
    }

    @StiSerializable
    @StiDefaulValue(value="None")
    public final StiTableAutoWidthType getAutoWidthType() {
        return this.autoWidthType;
    }

    public final void setAutoWidthType(StiTableAutoWidthType value) {
        this.autoWidthType = value;
    }

    @StiDefaulValue(value="5")
    @StiSerializable
    public final int getRowCount() {
        return this.rowCount;
    }

    public final void setRowCount(int value) {
        if (value > 0) {
            int oldValue = this.rowCount;
            this.rowCount = value;
            this.ChangeRowCount(oldValue, value);
        }
    }

    @StiDefaulValue(value="5")
    @StiSerializable
    public final int getColumnCount() {
        return this.columnCount;
    }

    public final void setColumnCount(int value) {
        if (value > 0) {
            int oldValue = this.columnCount;
            this.columnCount = value;
            this.ChangeColumnCount(oldValue, value);
        }
    }

    @StiDefaulValue(value="0")
    @StiSerializable
    public final int getFooterRowsCount() {
        return this.footerRowsCount;
    }

    public final void setFooterRowsCount(int value) {
        if (value <= this.rowCount - this.headerRowsCount) {
            this.footerRowsCount = value;
            this.RefreshTableStyle();
        }
    }

    @StiDefaulValue(value="0")
    @StiSerializable
    public final int getHeaderRowsCount() {
        return this.headerRowsCount;
    }

    public final void setHeaderRowsCount(int value) {
        if (value <= this.rowCount - this.footerRowsCount) {
            this.headerRowsCount = value;
            this.RefreshTableStyle();
        }
    }

    public final double getDefaultHeightCell() {
        if (this.getPage() != null && this.getPage().getReport() != null) {
            switch (this.getPage().getReport().getReportUnit()) {
                case Centimeters: {
                    return 0.8;
                }
                case HundredthsOfInch: {
                    return 30.0;
                }
                case Inches: {
                    return 0.3;
                }
                case Millimeters: {
                    return 8.0;
                }
            }
        }
        return 1.0;
    }

    @StiDefaulValue(value="AllPages")
    @StiSerializable
    public final StiPrintOnType getHeaderPrintOn() {
        return this.headerPrintOn;
    }

    public final void setHeaderPrintOn(StiPrintOnType value) {
        this.headerPrintOn = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getHeaderCanGrow() {
        return this.headerCanGrow;
    }

    public final void setHeaderCanGrow(boolean value) {
        this.headerCanGrow = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getHeaderCanShrink() {
        return this.headerCanShrink;
    }

    public final void setHeaderCanShrink(boolean value) {
        this.headerCanShrink = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getHeaderCanBreak() {
        return this.headerCanBreak;
    }

    public final void setHeaderCanBreak(boolean value) {
        this.headerCanBreak = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getHeaderPrintAtBottom() {
        return this.headerPrintAtBottom;
    }

    public final void setHeaderPrintAtBottom(boolean value) {
        this.headerPrintAtBottom = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getHeaderPrintIfEmpty() {
        return this.headerPrintIfEmpty;
    }

    public final void setHeaderPrintIfEmpty(boolean value) {
        this.headerPrintIfEmpty = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getHeaderPrintOnAllPages() {
        return this.headerPrintOnAllPages;
    }

    public void setHeaderPrintOnAllPages(boolean value) {
        this.headerPrintOnAllPages = value;
    }

    @StiDefaulValue(value="Ignore")
    @StiSerializable
    public StiPrintOnEvenOddPagesType getHeaderPrintOnEvenOddPages() {
        return this.headerPrintOnEvenOddPages;
    }

    public void setHeaderPrintOnEvenOddPages(StiPrintOnEvenOddPagesType value) {
        this.headerPrintOnEvenOddPages = value;
    }

    @StiDefaulValue(value="AllPages")
    @StiSerializable
    public final StiPrintOnType getFooterPrintOn() {
        return this.footerPrintOn;
    }

    public final void setFooterPrintOn(StiPrintOnType value) {
        this.footerPrintOn = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getFooterCanGrow() {
        return this.footerCanGrow;
    }

    public final void setFooterCanGrow(boolean value) {
        this.footerCanGrow = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getFooterCanShrink() {
        return this.footerCanShrink;
    }

    public final void setFooterCanShrink(boolean value) {
        this.footerCanShrink = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getFooterCanBreak() {
        return this.footerCanBreak;
    }

    public final void setFooterCanBreak(boolean value) {
        this.footerCanBreak = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getFooterPrintAtBottom() {
        return this.footerPrintAtBottom;
    }

    public final void setFooterPrintAtBottom(boolean value) {
        this.footerPrintAtBottom = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getFooterPrintIfEmpty() {
        return this.footerPrintIfEmpty;
    }

    public final void setFooterPrintIfEmpty(boolean value) {
        this.footerPrintIfEmpty = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getFooterPrintOnAllPages() {
        return this.footerPrintOnAllPages;
    }

    public void setFooterPrintOnAllPages(boolean value) {
        this.footerPrintOnAllPages = value;
    }

    @StiDefaulValue(value="Ignore")
    @StiSerializable
    public StiPrintOnEvenOddPagesType getFooterPrintOnEvenOddPages() {
        return this.footerPrintOnEvenOddPages;
    }

    public void setFooterPrintOnEvenOddPages(StiPrintOnEvenOddPagesType value) {
        this.footerPrintOnEvenOddPages = value;
    }

    @StiDefaulValue(value="0")
    @StiSerializable
    public final int getNumberID() {
        return this.numberID;
    }

    public final void setNumberID(int value) {
        this.numberID = value;
    }

    @Override
    @StiSerializable(need=false)
    public int getColumns() {
        return 0;
    }

    @Override
    @StiSerializable(need=false)
    public double getColumnWidth() {
        return 0.0;
    }

    @Override
    @StiSerializable(need=false)
    public double getColumnGaps() {
        return 0.0;
    }

    @Override
    public StiColumnDirection getColumnDirection() {
        return super.getColumnDirection();
    }

    @Override
    @StiSerializable(need=false)
    public int getMinRowsInColumn() {
        return 0;
    }

    @Override
    @StiDefaulValue(value="0.0")
    @StiSerializable
    public double getMinHeight() {
        return super.getMinHeight();
    }

    @Override
    public void setMinHeight(double value) {
        super.setMinHeight(value);
    }

    @Override
    @StiDefaulValue(value="0.0")
    @StiSerializable
    public double getMaxHeight() {
        return super.getMaxHeight();
    }

    @Override
    public void setMaxHeight(double value) {
        super.setMaxHeight(value);
    }

    @Override
    public StiSize getMinSize() {
        return new StiSize(0, 0);
    }

    @Override
    public void setMinSize(StiSize value) {
        super.setMinSize(value);
    }

    @Override
    public boolean getRightToLeft() {
        return super.getRightToLeft();
    }

    @Override
    public void setRightToLeft(boolean value) {
        super.setRightToLeft(value);
    }

    @Override
    public double getWidth() {
        return super.getWidth();
    }

    @Override
    public void setWidth(double value) {
        double oldWidth = super.getWidth();
        if (value == super.getWidth()) {
            return;
        }
        super.setWidth(value);
        if (value > 0.0 && value != oldWidth) {
            this.ResizeWidthCell(oldWidth);
        }
    }

    @Override
    public double getHeight() {
        return super.getHeight();
    }

    @Override
    public void setHeight(double value) {
        super.setHeight(value);
        if (this.getComponents() != null && this.getComponents().size() == 0 && this.getPage() != null) {
            this.SelectAll();
            this.CreateCell();
            return;
        }
    }

    @Override
    public StiRectangle getDefaultClientRectangle() {
        return new StiRectangle(0L, 0L, 300L, 120L);
    }

    @Override
    public boolean getDockable() {
        return this.dockableTable;
    }

    @Override
    public void setDockable(boolean value) {
    }

    public StiColor getHeaderStartStiColor() {
        return StiColor.fromArgb((int)120, (int)168, (int)211, (int)255);
    }

    public StiColor getHeaderEndStiColor() {
        return StiColor.fromArgb((int)120, (int)0, (int)111, (int)221);
    }

    public final void ChangeGrowToHeightAtCell(StiComponent cell) {
        StiComponent comp;
        int indexCell;
        int index = this.getComponents().indexOf(cell);
        if (index == -1) {
            return;
        }
        int numberRow = index / this.columnCount;
        int startIndex = numberRow * this.columnCount;
        boolean canGrow = false;
        for (indexCell = startIndex; indexCell < startIndex + this.columnCount; ++indexCell) {
            StiComponent stiComponent = comp = this.getComponents().get(indexCell) instanceof StiComponent ? (StiComponent)this.getComponents().get(indexCell) : null;
            if (!comp.getCanGrow()) continue;
            if (canGrow) break;
            canGrow = true;
            break;
        }
        for (indexCell = startIndex; indexCell < startIndex + this.columnCount; ++indexCell) {
            comp = this.getComponents().get(indexCell) instanceof StiComponent ? (StiComponent)this.getComponents().get(indexCell) : null;
            comp.setGrowToHeight(canGrow);
        }
    }

    @StiDefaulValue(value="StyleNone")
    @StiSerializable
    public final StiTableStyle getTableStyle() {
        return this.tableStyle;
    }

    public final void setTableStyle(StiTableStyle value) {
        if (this.tableStyle != value) {
            this.tableStyle = value;
            if (this.tableStyle.getValue() != 0) {
                this.RefreshTableStyle();
            }
        }
    }

    private void RefreshTableStyle() {
        switch (this.tableStyle) {
            case StyleNone: {
                break;
            }
            case Style11: {
                this.ApplyStyle1(StiTableStyles.GetStyle(StiTableStyle.Style11));
                break;
            }
            case Style12: {
                this.ApplyStyle1(StiTableStyles.GetStyle(StiTableStyle.Style12));
                break;
            }
            case Style13: {
                this.ApplyStyle1(StiTableStyles.GetStyle(StiTableStyle.Style13));
                break;
            }
            case Style14: {
                this.ApplyStyle1(StiTableStyles.GetStyle(StiTableStyle.Style14));
                break;
            }
            case Style15: {
                this.ApplyStyle1(StiTableStyles.GetStyle(StiTableStyle.Style15));
                break;
            }
            case Style16: {
                this.ApplyStyle1(StiTableStyles.GetStyle(StiTableStyle.Style16));
                break;
            }
            case Style17: {
                this.ApplyStyle1(StiTableStyles.GetStyle(StiTableStyle.Style17));
                break;
            }
            case Style18: {
                this.ApplyStyle1(StiTableStyles.GetStyle(StiTableStyle.Style18));
                break;
            }
            case Style19: {
                this.ApplyStyle1(StiTableStyles.GetStyle(StiTableStyle.Style19));
                break;
            }
            case Style31: {
                this.ApplyStyle3(StiTableStyles.GetStyle(StiTableStyle.Style31));
                break;
            }
            case Style32: {
                this.ApplyStyle3(StiTableStyles.GetStyle(StiTableStyle.Style32));
                break;
            }
            case Style33: {
                this.ApplyStyle3(StiTableStyles.GetStyle(StiTableStyle.Style33));
                break;
            }
            case Style34: {
                this.ApplyStyle3(StiTableStyles.GetStyle(StiTableStyle.Style34));
                break;
            }
            case Style35: {
                this.ApplyStyle3(StiTableStyles.GetStyle(StiTableStyle.Style35));
                break;
            }
            case Style36: {
                this.ApplyStyle3(StiTableStyles.GetStyle(StiTableStyle.Style36));
                break;
            }
            case Style37: {
                this.ApplyStyle3(StiTableStyles.GetStyle(StiTableStyle.Style37));
                break;
            }
            case Style38: {
                this.ApplyStyle3(StiTableStyles.GetStyle(StiTableStyle.Style38));
                break;
            }
            case Style39: {
                this.ApplyStyle3(StiTableStyles.GetStyle(StiTableStyle.Style39));
                break;
            }
            case Style41: {
                this.ApplyStyle4(StiTableStyles.GetStyle(StiTableStyle.Style41));
                break;
            }
            case Style42: {
                this.ApplyStyle4(StiTableStyles.GetStyle(StiTableStyle.Style42));
                break;
            }
            case Style43: {
                this.ApplyStyle4(StiTableStyles.GetStyle(StiTableStyle.Style43));
                break;
            }
            case Style44: {
                this.ApplyStyle4(StiTableStyles.GetStyle(StiTableStyle.Style44));
                break;
            }
            case Style45: {
                this.ApplyStyle4(StiTableStyles.GetStyle(StiTableStyle.Style45));
                break;
            }
            case Style46: {
                this.ApplyStyle4(StiTableStyles.GetStyle(StiTableStyle.Style46));
                break;
            }
            case Style47: {
                this.ApplyStyle4(StiTableStyles.GetStyle(StiTableStyle.Style47));
                break;
            }
            case Style48: {
                this.ApplyStyle4(StiTableStyles.GetStyle(StiTableStyle.Style48));
                break;
            }
            case Style49: {
                this.ApplyStyle4(StiTableStyles.GetStyle(StiTableStyle.Style49));
                break;
            }
            case Style51: {
                this.ApplyStyle5(StiTableStyles.GetStyle(StiTableStyle.Style51));
                break;
            }
            case Style52: {
                this.ApplyStyle5(StiTableStyles.GetStyle(StiTableStyle.Style52));
                break;
            }
            case Style53: {
                this.ApplyStyle5(StiTableStyles.GetStyle(StiTableStyle.Style53));
                break;
            }
            case Style54: {
                this.ApplyStyle5(StiTableStyles.GetStyle(StiTableStyle.Style54));
                break;
            }
            case Style55: {
                this.ApplyStyle5(StiTableStyles.GetStyle(StiTableStyle.Style55));
                break;
            }
            case Style56: {
                this.ApplyStyle5(StiTableStyles.GetStyle(StiTableStyle.Style56));
                break;
            }
            case Style57: {
                this.ApplyStyle5(StiTableStyles.GetStyle(StiTableStyle.Style57));
                break;
            }
            case Style58: {
                this.ApplyStyle5(StiTableStyles.GetStyle(StiTableStyle.Style58));
                break;
            }
            case Style59: {
                this.ApplyStyle5(StiTableStyles.GetStyle(StiTableStyle.Style59));
            }
        }
    }

    public final void ApplyStyleNone() {
        if (this.getComponents().size() == 0) {
            return;
        }
        StiTableStyles style = StiTableStyles.GetStyle(StiTableStyle.StyleNone);
        for (StiComponent cell : this.getComponents()) {
            switch (((IStiTableCell)((Object)cell)).getCellType()) {
                case Text: {
                    ((StiTableCell)cell).setBorder(new StiBorder(StiBorderSides.All, style.GridStiColor, 1.0, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.GridStiColor)));
                    ((StiTableCell)cell).setBrush((StiBrush)new StiSolidBrush(StiColor.Transparent));
                    ((StiTableCell)cell).setTextBrush((StiBrush)new StiSolidBrush(style.DataTextStiColor));
                    break;
                }
                case Image: {
                    ((StiTableCellImage)cell).setBorder(new StiBorder(StiBorderSides.All, style.GridStiColor, 1.0, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.GridStiColor)));
                    ((StiTableCellImage)cell).setBrush((StiBrush)new StiSolidBrush(StiColor.Transparent));
                    break;
                }
                case CheckBox: {
                    ((StiTableCellCheckBox)cell).setBorder(new StiBorder(StiBorderSides.All, style.GridStiColor, 1.0, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.GridStiColor)));
                    ((StiTableCellCheckBox)cell).setBrush((StiBrush)new StiSolidBrush(StiColor.Transparent));
                    break;
                }
                case RichText: {
                    ((StiTableCellRichText)cell).setBorder(new StiBorder(StiBorderSides.All, style.GridStiColor, 1.0, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.GridStiColor)));
                    ((StiTableCellRichText)cell).setBackColor(StiSolidBrush.ToColor((StiBrush)new StiSolidBrush(StiColor.Transparent)));
                }
            }
        }
    }

    private void ApplyStyleNoneForCell(StiComponent cell) {
        StiTableStyles style = StiTableStyles.GetStyle(StiTableStyle.StyleNone);
        switch (((IStiTableCell)((Object)cell)).getCellType()) {
            case Text: {
                ((StiTableCell)cell).setBorder(new StiBorder(StiBorderSides.All, style.GridStiColor, 1.0, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.GridStiColor)));
                ((StiTableCell)cell).setBrush((StiBrush)new StiSolidBrush(StiColor.Transparent));
                ((StiTableCell)cell).setTextBrush((StiBrush)new StiSolidBrush(style.DataTextStiColor));
                break;
            }
            case Image: {
                ((StiTableCellImage)cell).setBorder(new StiBorder(StiBorderSides.All, style.GridStiColor, 1.0, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.GridStiColor)));
                ((StiTableCellImage)cell).setBrush((StiBrush)new StiSolidBrush(StiColor.Transparent));
                break;
            }
            case CheckBox: {
                ((StiTableCellCheckBox)cell).setBorder(new StiBorder(StiBorderSides.All, style.GridStiColor, 1.0, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.GridStiColor)));
                ((StiTableCellCheckBox)cell).setBrush((StiBrush)new StiSolidBrush(StiColor.Transparent));
                break;
            }
            case RichText: {
                ((StiTableCellRichText)cell).setBorder(new StiBorder(StiBorderSides.All, style.GridStiColor, 1.0, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.GridStiColor)));
                ((StiTableCellRichText)cell).setBackColor(StiSolidBrush.ToColor((StiBrush)new StiSolidBrush(StiColor.Transparent)));
            }
        }
    }

    private void ApplyStyle1(StiTableStyles style) {
        if (this.getComponents().size() == 0) {
            return;
        }
        for (StiComponent cell : this.getComponents()) {
            switch (((IStiTableCell)((Object)cell)).getCellType()) {
                case Text: {
                    ((StiTableCell)cell).setBorder(new StiBorder(StiBorderSides.All, style.GridStiColor, 1.0, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.GridStiColor)));
                    ((StiTableCell)cell).setBrush((StiBrush)new StiSolidBrush(StiColor.Transparent));
                    ((StiTableCell)cell).setTextBrush((StiBrush)new StiSolidBrush(style.DataTextStiColor));
                    break;
                }
                case Image: {
                    ((StiTableCellImage)cell).setBorder(new StiBorder(StiBorderSides.All, style.GridStiColor, 1.0, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.GridStiColor)));
                    ((StiTableCellImage)cell).setBrush((StiBrush)new StiSolidBrush(StiColor.Transparent));
                    break;
                }
                case CheckBox: {
                    ((StiTableCellCheckBox)cell).setBorder(new StiBorder(StiBorderSides.All, style.GridStiColor, 1.0, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.GridStiColor)));
                    ((StiTableCellCheckBox)cell).setBrush((StiBrush)new StiSolidBrush(StiColor.Transparent));
                    break;
                }
                case RichText: {
                    ((StiTableCellRichText)cell).setBorder(new StiBorder(StiBorderSides.All, style.GridStiColor, 1.0, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.GridStiColor)));
                    ((StiTableCellRichText)cell).setBackColor(StiSolidBrush.ToColor((StiBrush)new StiSolidBrush(StiColor.Transparent)));
                }
            }
        }
    }

    private void ApplyStyle3(StiTableStyles style) {
        if (this.getComponents().size() == 0) {
            return;
        }
        StiBorder headerBorder = new StiBorder(StiBorderSides.All, style.HeaderStiColor, 1.0, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.HeaderStiColor));
        StiSolidBrush headerBrush = new StiSolidBrush(style.HeaderStiColor);
        StiSolidBrush headerTextBrush = new StiSolidBrush(style.HeaderFooterTextStiColor);
        StiBorder dataBorder = new StiBorder(StiEnumSet.of((Enum)StiBorderSides.None, (Enum)StiBorderSides.Top, (Enum)StiBorderSides.Bottom), style.HeaderStiColor, 1, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.HeaderStiColor));
        StiBorder dataLeftBorder = new StiBorder(StiEnumSet.of((Enum)StiBorderSides.None, (Enum)StiBorderSides.Top, (Enum)StiBorderSides.Left, (Enum)StiBorderSides.Bottom), style.HeaderStiColor, 1, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.HeaderStiColor));
        StiBorder dataRightBorder = new StiBorder(StiEnumSet.of((Enum)StiBorderSides.None, (Enum)StiBorderSides.Top, (Enum)StiBorderSides.Right, (Enum)StiBorderSides.Bottom), style.HeaderStiColor, 1, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.HeaderStiColor));
        StiSolidBrush dataBrush = new StiSolidBrush(style.DataStiColor);
        StiSolidBrush dataTextBrush = new StiSolidBrush(style.DataTextStiColor);
        int numberRow = 0;
        if (this.headerRowsCount > 0) {
            int indexCell = 0;
            for (int indexRow = 0; indexRow < this.headerRowsCount; ++indexRow) {
                for (int indexCol = 0; indexCol < this.columnCount; ++indexCol) {
                    StiComponent headerCell;
                    StiComponent stiComponent = headerCell = this.getComponents().get(indexCell) instanceof StiComponent ? (StiComponent)this.getComponents().get(indexCell) : null;
                    if (headerCell != null) {
                        switch (((IStiTableCell)((Object)headerCell)).getCellType()) {
                            case Text: {
                                ((StiTableCell)headerCell).setBorder((StiBorder)headerBorder.clone());
                                ((StiTableCell)headerCell).setBrush((StiBrush)headerBrush.clone());
                                ((StiTableCell)headerCell).setTextBrush((StiBrush)((StiSolidBrush)headerTextBrush.clone()));
                                break;
                            }
                            case Image: {
                                ((StiTableCellImage)headerCell).setBorder((StiBorder)headerBorder.clone());
                                ((StiTableCellImage)headerCell).setBrush((StiBrush)headerBrush.clone());
                                break;
                            }
                            case CheckBox: {
                                ((StiTableCellCheckBox)headerCell).setBorder((StiBorder)headerBorder.clone());
                                ((StiTableCellCheckBox)headerCell).setBrush((StiBrush)headerBrush.clone());
                                break;
                            }
                            case RichText: {
                                ((StiTableCellRichText)headerCell).setBorder((StiBorder)headerBorder.clone());
                                ((StiTableCellRichText)headerCell).setBackColor(StiSolidBrush.ToColor((StiBrush)((StiBrush)headerBrush.clone())));
                            }
                        }
                    }
                    ++indexCell;
                }
            }
            numberRow = this.headerRowsCount;
        }
        int countDataRows = this.rowCount - numberRow;
        int indexDataCell = numberRow * this.columnCount;
        for (int indexRow = numberRow; indexRow < this.rowCount; ++indexRow) {
            for (int indexCol = 0; indexCol < this.columnCount; ++indexCol) {
                StiComponent dataCell;
                StiComponent stiComponent = dataCell = this.getComponents().get(indexDataCell) instanceof StiComponent ? (StiComponent)this.getComponents().get(indexDataCell) : null;
                if (dataCell != null) {
                    switch (((IStiTableCell)((Object)dataCell)).getCellType()) {
                        case Text: {
                            if (indexCol == 0) {
                                ((StiTableCell)dataCell).setBorder((StiBorder)dataLeftBorder.clone());
                            } else if (indexCol == this.columnCount - 1) {
                                ((StiTableCell)dataCell).setBorder((StiBorder)dataRightBorder.clone());
                            } else {
                                ((StiTableCell)dataCell).setBorder((StiBorder)dataBorder.clone());
                            }
                            ((StiTableCell)dataCell).setBrush((StiBrush)dataBrush.clone());
                            ((StiTableCell)dataCell).setTextBrush((StiBrush)((StiSolidBrush)dataTextBrush.clone()));
                            break;
                        }
                        case Image: {
                            if (indexCol == 0) {
                                ((StiTableCellImage)dataCell).setBorder((StiBorder)dataLeftBorder.clone());
                            } else if (indexCol == this.columnCount - 1) {
                                ((StiTableCellImage)dataCell).setBorder((StiBorder)dataRightBorder.clone());
                            } else {
                                ((StiTableCellImage)dataCell).setBorder((StiBorder)dataBorder.clone());
                            }
                            ((StiTableCellImage)dataCell).setBrush((StiBrush)dataBrush.clone());
                            break;
                        }
                        case CheckBox: {
                            if (indexCol == 0) {
                                ((StiTableCellCheckBox)dataCell).setBorder((StiBorder)dataLeftBorder.clone());
                            } else if (indexCol == this.columnCount - 1) {
                                ((StiTableCellCheckBox)dataCell).setBorder((StiBorder)dataRightBorder.clone());
                            } else {
                                ((StiTableCellCheckBox)dataCell).setBorder((StiBorder)dataBorder.clone());
                            }
                            ((StiTableCellCheckBox)dataCell).setBrush((StiBrush)dataBrush.clone());
                            break;
                        }
                        case RichText: {
                            if (indexCol == 0) {
                                ((StiTableCellRichText)dataCell).setBorder((StiBorder)dataLeftBorder.clone());
                            } else if (indexCol == this.columnCount - 1) {
                                ((StiTableCellRichText)dataCell).setBorder((StiBorder)dataRightBorder.clone());
                            } else {
                                ((StiTableCellRichText)dataCell).setBorder((StiBorder)dataBorder.clone());
                            }
                            ((StiTableCellRichText)dataCell).setBackColor(StiBrush.ToColor((StiBrush)((StiBrush)dataBrush.clone())));
                        }
                    }
                }
                ++indexDataCell;
            }
        }
    }

    private void ApplyStyle4(StiTableStyles style) {
        if (this.getComponents().size() == 0) {
            return;
        }
        StiBorder footerBorder = new StiBorder(StiBorderSides.All, style.FooterStiColor, 1.0, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.FooterStiColor));
        StiSolidBrush footerBrush = new StiSolidBrush(style.FooterStiColor);
        StiSolidBrush footerTextBrush = new StiSolidBrush(style.HeaderFooterTextStiColor);
        StiBorder dataBorder = new StiBorder(StiEnumSet.of((Enum)StiBorderSides.None, (Enum)StiBorderSides.Top, (Enum)StiBorderSides.Bottom), style.FooterStiColor, 1, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.FooterStiColor));
        StiBorder dataLeftBorder = new StiBorder(StiEnumSet.of((Enum)StiBorderSides.None, (Enum)StiBorderSides.Top, (Enum)StiBorderSides.Left, (Enum)StiBorderSides.Bottom), style.FooterStiColor, 1, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.FooterStiColor));
        StiBorder dataRightBorder = new StiBorder(StiEnumSet.of((Enum)StiBorderSides.None, (Enum)StiBorderSides.Top, (Enum)StiBorderSides.Right, (Enum)StiBorderSides.Bottom), style.FooterStiColor, 1, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.FooterStiColor));
        StiSolidBrush dataBrush = new StiSolidBrush(style.DataStiColor);
        StiSolidBrush dataTextBrush = new StiSolidBrush(style.DataTextStiColor);
        if (this.footerRowsCount > 0) {
            int numberRow = this.rowCount - this.footerRowsCount;
            int indexCell = numberRow * this.columnCount;
            for (int indexRow = numberRow; indexRow < this.rowCount; ++indexRow) {
                for (int indexCol = 0; indexCol < this.columnCount; ++indexCol) {
                    StiComponent footerCell;
                    StiComponent stiComponent = footerCell = this.getComponents().get(indexCell) instanceof StiComponent ? (StiComponent)this.getComponents().get(indexCell) : null;
                    if (footerCell != null) {
                        switch (((IStiTableCell)((Object)footerCell)).getCellType()) {
                            case Text: {
                                ((StiTableCell)footerCell).setBorder((StiBorder)footerBorder.clone());
                                ((StiTableCell)footerCell).setBrush((StiBrush)footerBrush.clone());
                                ((StiTableCell)footerCell).setTextBrush((StiBrush)((StiSolidBrush)footerTextBrush.clone()));
                                break;
                            }
                            case Image: {
                                ((StiTableCellImage)footerCell).setBorder((StiBorder)footerBorder.clone());
                                ((StiTableCellImage)footerCell).setBrush((StiBrush)footerBrush.clone());
                                break;
                            }
                            case CheckBox: {
                                ((StiTableCellCheckBox)footerCell).setBorder((StiBorder)footerBorder.clone());
                                ((StiTableCellCheckBox)footerCell).setBrush((StiBrush)footerBrush.clone());
                                break;
                            }
                            case RichText: {
                                ((StiTableCellRichText)footerCell).setBorder((StiBorder)footerBorder.clone());
                                ((StiTableCellRichText)footerCell).setBackColor(StiBrush.ToColor((StiBrush)((StiBrush)footerBrush.clone())));
                            }
                        }
                    }
                    ++indexCell;
                }
            }
        }
        int indexDataCell = 0;
        for (int indexRow = 0; indexRow < this.rowCount - this.footerRowsCount; ++indexRow) {
            for (int indexCol = 0; indexCol < this.columnCount; ++indexCol) {
                StiComponent dataCell;
                StiComponent stiComponent = dataCell = this.getComponents().get(indexDataCell) instanceof StiComponent ? (StiComponent)this.getComponents().get(indexDataCell) : null;
                if (dataCell != null) {
                    switch (((IStiTableCell)((Object)dataCell)).getCellType()) {
                        case Text: {
                            if (indexCol == 0) {
                                ((StiTableCell)dataCell).setBorder((StiBorder)dataLeftBorder.clone());
                            } else if (indexCol == this.columnCount - 1) {
                                ((StiTableCell)dataCell).setBorder((StiBorder)dataRightBorder.clone());
                            } else {
                                ((StiTableCell)dataCell).setBorder((StiBorder)dataBorder.clone());
                            }
                            ((StiTableCell)dataCell).setBrush((StiBrush)dataBrush.clone());
                            ((StiTableCell)dataCell).setTextBrush((StiBrush)((StiSolidBrush)dataTextBrush.clone()));
                            break;
                        }
                        case Image: {
                            if (indexCol == 0) {
                                ((StiTableCellImage)dataCell).setBorder((StiBorder)dataLeftBorder.clone());
                            } else if (indexCol == this.columnCount - 1) {
                                ((StiTableCellImage)dataCell).setBorder((StiBorder)dataRightBorder.clone());
                            } else {
                                ((StiTableCellImage)dataCell).setBorder((StiBorder)dataBorder.clone());
                            }
                            ((StiTableCellImage)dataCell).setBrush((StiBrush)dataBrush.clone());
                            break;
                        }
                        case CheckBox: {
                            if (indexCol == 0) {
                                ((StiTableCellCheckBox)dataCell).setBorder((StiBorder)dataLeftBorder.clone());
                            } else if (indexCol == this.columnCount - 1) {
                                ((StiTableCellCheckBox)dataCell).setBorder((StiBorder)dataRightBorder.clone());
                            } else {
                                ((StiTableCellCheckBox)dataCell).setBorder((StiBorder)dataBorder.clone());
                            }
                            ((StiTableCellCheckBox)dataCell).setBrush((StiBrush)dataBrush.clone());
                            break;
                        }
                        case RichText: {
                            if (indexCol == 0) {
                                ((StiTableCellRichText)dataCell).setBorder((StiBorder)dataLeftBorder.clone());
                            } else if (indexCol == this.columnCount - 1) {
                                ((StiTableCellRichText)dataCell).setBorder((StiBorder)dataRightBorder.clone());
                            } else {
                                ((StiTableCellRichText)dataCell).setBorder((StiBorder)dataBorder.clone());
                            }
                            ((StiTableCellRichText)dataCell).setBackColor(StiBrush.ToColor((StiBrush)((StiBrush)dataBrush.clone())));
                        }
                    }
                }
                ++indexDataCell;
            }
        }
    }

    private void ApplyStyle5(StiTableStyles style) {
        int indexCol;
        int indexRow;
        if (this.getComponents().size() == 0) {
            return;
        }
        StiBorder hfBorder = new StiBorder(StiBorderSides.All, style.HeaderStiColor, 1.0, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.HeaderStiColor));
        StiSolidBrush hfBrush = new StiSolidBrush(style.HeaderStiColor);
        StiSolidBrush hfTextBrush = new StiSolidBrush(style.HeaderFooterTextStiColor);
        StiBorder dataBorder = new StiBorder(StiEnumSet.of((Enum)StiBorderSides.None, (Enum)StiBorderSides.Top, (Enum)StiBorderSides.Bottom), style.HeaderStiColor, 1, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.HeaderStiColor));
        StiBorder dataLeftBorder = new StiBorder(StiEnumSet.of((Enum)StiBorderSides.None, (Enum)StiBorderSides.Top, (Enum)StiBorderSides.Left, (Enum)StiBorderSides.Bottom), style.HeaderStiColor, 1, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.HeaderStiColor));
        StiBorder dataRightBorder = new StiBorder(StiEnumSet.of((Enum)StiBorderSides.None, (Enum)StiBorderSides.Top, (Enum)StiBorderSides.Right, (Enum)StiBorderSides.Bottom), style.HeaderStiColor, 1, StiPenStyle.Solid, false, 4.0, (StiBrush)new StiSolidBrush(style.HeaderStiColor));
        StiSolidBrush dataBrush = new StiSolidBrush(style.DataStiColor);
        StiSolidBrush dataTextBrush = new StiSolidBrush(style.DataTextStiColor);
        int numberRow = 0;
        if (this.headerRowsCount > 0) {
            int indexCell = 0;
            for (indexRow = 0; indexRow < this.headerRowsCount; ++indexRow) {
                for (indexCol = 0; indexCol < this.columnCount; ++indexCol) {
                    StiComponent headerCell;
                    StiComponent stiComponent = headerCell = this.getComponents().get(indexCell) instanceof StiComponent ? (StiComponent)this.getComponents().get(indexCell) : null;
                    if (headerCell != null) {
                        switch (((IStiTableCell)((Object)headerCell)).getCellType()) {
                            case Text: {
                                ((StiTableCell)headerCell).setBorder((StiBorder)hfBorder.clone());
                                ((StiTableCell)headerCell).setBrush((StiBrush)hfBrush.clone());
                                ((StiTableCell)headerCell).setTextBrush((StiBrush)((StiSolidBrush)hfTextBrush.clone()));
                                break;
                            }
                            case Image: {
                                ((StiTableCellImage)headerCell).setBorder((StiBorder)hfBorder.clone());
                                ((StiTableCellImage)headerCell).setBrush((StiBrush)hfBrush.clone());
                                break;
                            }
                            case CheckBox: {
                                ((StiTableCellCheckBox)headerCell).setBorder((StiBorder)hfBorder.clone());
                                ((StiTableCellCheckBox)headerCell).setBrush((StiBrush)hfBrush.clone());
                                break;
                            }
                            case RichText: {
                                ((StiTableCellRichText)headerCell).setBorder((StiBorder)hfBorder.clone());
                                ((StiTableCellRichText)headerCell).setBackColor(StiBrush.ToColor((StiBrush)((StiBrush)hfBrush.clone())));
                            }
                        }
                    }
                    ++indexCell;
                }
            }
            numberRow = this.headerRowsCount;
        }
        if (this.footerRowsCount > 0) {
            int nRow = this.rowCount - this.footerRowsCount;
            int indexCell = nRow * this.columnCount;
            for (int indexRow2 = nRow; indexRow2 < this.rowCount; ++indexRow2) {
                for (int indexCol2 = 0; indexCol2 < this.columnCount; ++indexCol2) {
                    StiComponent footerCell;
                    StiComponent stiComponent = footerCell = this.getComponents().get(indexCell) instanceof StiComponent ? (StiComponent)this.getComponents().get(indexCell) : null;
                    if (footerCell != null) {
                        switch (((IStiTableCell)((Object)footerCell)).getCellType()) {
                            case Text: {
                                ((StiTableCell)footerCell).setBorder((StiBorder)hfBorder.clone());
                                ((StiTableCell)footerCell).setBrush((StiBrush)hfBrush.clone());
                                ((StiTableCell)footerCell).setTextBrush((StiBrush)((StiSolidBrush)hfTextBrush.clone()));
                                break;
                            }
                            case Image: {
                                ((StiTableCellImage)footerCell).setBorder((StiBorder)hfBorder.clone());
                                ((StiTableCellImage)footerCell).setBrush((StiBrush)hfBrush.clone());
                                break;
                            }
                            case CheckBox: {
                                ((StiTableCellCheckBox)footerCell).setBorder((StiBorder)hfBorder.clone());
                                ((StiTableCellCheckBox)footerCell).setBrush((StiBrush)hfBrush.clone());
                                break;
                            }
                            case RichText: {
                                ((StiTableCellRichText)footerCell).setBorder((StiBorder)hfBorder.clone());
                                ((StiTableCellRichText)footerCell).setBackColor(StiBrush.ToColor((StiBrush)((StiBrush)hfBrush.clone())));
                            }
                        }
                    }
                    ++indexCell;
                }
            }
        }
        int indexDataCell = numberRow * this.columnCount;
        for (indexRow = numberRow; indexRow < this.rowCount - this.footerRowsCount; ++indexRow) {
            for (indexCol = 0; indexCol < this.columnCount; ++indexCol) {
                StiComponent dataCell;
                StiComponent stiComponent = dataCell = this.getComponents().get(indexDataCell) instanceof StiComponent ? (StiComponent)this.getComponents().get(indexDataCell) : null;
                if (dataCell != null) {
                    switch (((IStiTableCell)((Object)dataCell)).getCellType()) {
                        case Text: {
                            if (indexCol == 0) {
                                ((StiTableCell)dataCell).setBorder((StiBorder)dataLeftBorder.clone());
                            } else if (indexCol == this.columnCount - 1) {
                                ((StiTableCell)dataCell).setBorder((StiBorder)dataRightBorder.clone());
                            } else {
                                ((StiTableCell)dataCell).setBorder((StiBorder)dataBorder.clone());
                            }
                            ((StiTableCell)dataCell).setBrush((StiBrush)dataBrush.clone());
                            ((StiTableCell)dataCell).setTextBrush((StiBrush)((StiSolidBrush)dataTextBrush.clone()));
                            break;
                        }
                        case Image: {
                            if (indexCol == 0) {
                                ((StiTableCellImage)dataCell).setBorder((StiBorder)dataLeftBorder.clone());
                            } else if (indexCol == this.columnCount - 1) {
                                ((StiTableCellImage)dataCell).setBorder((StiBorder)dataRightBorder.clone());
                            } else {
                                ((StiTableCellImage)dataCell).setBorder((StiBorder)dataBorder.clone());
                            }
                            ((StiTableCellImage)dataCell).setBrush((StiBrush)dataBrush.clone());
                            break;
                        }
                        case CheckBox: {
                            if (indexCol == 0) {
                                ((StiTableCellCheckBox)dataCell).setBorder((StiBorder)dataLeftBorder.clone());
                            } else if (indexCol == this.columnCount - 1) {
                                ((StiTableCellCheckBox)dataCell).setBorder((StiBorder)dataRightBorder.clone());
                            } else {
                                ((StiTableCellCheckBox)dataCell).setBorder((StiBorder)dataBorder.clone());
                            }
                            ((StiTableCellCheckBox)dataCell).setBrush((StiBrush)dataBrush.clone());
                            break;
                        }
                        case RichText: {
                            if (indexCol == 0) {
                                ((StiTableCellRichText)dataCell).setBorder((StiBorder)dataLeftBorder.clone());
                            } else if (indexCol == this.columnCount - 1) {
                                ((StiTableCellRichText)dataCell).setBorder((StiBorder)dataRightBorder.clone());
                            } else {
                                ((StiTableCellRichText)dataCell).setBorder((StiBorder)dataBorder.clone());
                            }
                            ((StiTableCellRichText)dataCell).setBackColor(StiBrush.ToColor((StiBrush)((StiBrush)dataBrush.clone())));
                        }
                    }
                }
                ++indexDataCell;
            }
        }
    }

    private void ChangeRowCount(int oldValue, int value) {
        if (this.getPage() == null || this.getReport() == null) {
            return;
        }
        if (value > 0 && value != oldValue) {
            if (value < this.headerRowsCount + this.footerRowsCount) {
                this.headerRowsCount = 0;
                this.footerRowsCount = 0;
            }
            super.setMinHeight(this.getPage().getGridSize() * (double)value);
            int difference = value - oldValue;
            if (difference > 0) {
                this.AddNewRows(difference);
            } else {
                this.DeleteLastRows(Math.abs(difference), oldValue);
            }
        }
    }

    private void ChangeColumnCount(int oldValue, int value) {
        if (this.getPage() == null || this.getReport() == null) {
            return;
        }
        if (value > 0 && value != oldValue) {
            int difference = value - oldValue;
            if (difference > 0) {
                this.AddTableNewColumns(difference, oldValue);
            } else {
                this.DeleteTableColumns(Math.abs(difference), oldValue);
            }
        }
    }

    public final ArrayList<Integer> createJoin(StiRefObject<Double> sumWidth, StiRefObject<Double> sumHeight, StiRefObject<Integer> joinWidth, StiRefObject<Integer> joinHeight) {
        int count = this.GetCountSelectedCells();
        if (count <= 1 || this.getPage() == null) {
            return new ArrayList<Integer>();
        }
        int[] allX = new int[count];
        int[] allY = new int[count];
        int row = 0;
        int col = 0;
        int selectedCount = 0;
        for (StiComponent c : this.getComponents()) {
            if (c.getIsSelected()) {
                allX[selectedCount] = col;
                allY[selectedCount] = row;
                ++selectedCount;
                c.setIsSelected(false);
            }
            if (++col != this.columnCount) continue;
            col = 0;
            ++row;
        }
        int leftX = 0;
        int leftY = 0;
        int rightX = 0;
        int rightY = 0;
        StiRefObject tempRef_leftX = new StiRefObject((Object)leftX);
        StiRefObject tempRef_rightX = new StiRefObject((Object)rightX);
        this.FindLeftSelectedElement(allX, (StiRefObject<Integer>)tempRef_leftX, (StiRefObject<Integer>)tempRef_rightX);
        leftX = (Integer)tempRef_leftX.argvalue;
        rightX = (Integer)tempRef_rightX.argvalue;
        StiRefObject tempRef_leftY = new StiRefObject((Object)leftY);
        StiRefObject tempRef_rightY = new StiRefObject((Object)rightY);
        this.FindRightSelectedElement(allY, (StiRefObject<Integer>)tempRef_leftY, (StiRefObject<Integer>)tempRef_rightY);
        leftY = (Integer)tempRef_leftY.argvalue;
        rightY = (Integer)tempRef_rightY.argvalue;
        joinWidth.argvalue = rightX - leftX + 1;
        joinHeight.argvalue = rightY - leftY + 1;
        ArrayList<Integer> joinCells = new ArrayList<Integer>((rightY - leftY + 1) * (rightX - leftX + 1));
        int indexNewCell = 0;
        for (int index1 = leftY; index1 <= rightY; ++index1) {
            StiComponent selectCell = null;
            for (int index2 = leftX; index2 <= rightX; ++index2) {
                int nomer = index1 * this.columnCount + index2;
                selectCell = (StiComponent)this.getComponents().get(nomer);
                if (((IStiTableCell)((Object)selectCell)).getMerged()) {
                    StiComponent parentJoinCell = ((IStiTableCell)((Object)selectCell)).GetJoinComponentByGuid(((IStiTableCell)((Object)selectCell)).getParentJoin());
                    ((IStiTableCell)((Object)parentJoinCell)).setJoin(false);
                }
                if (joinCells.size() - 1 < indexNewCell) {
                    joinCells.add(((IStiTableCell)((Object)selectCell)).getID());
                } else {
                    joinCells.set(indexNewCell, ((IStiTableCell)((Object)selectCell)).getID());
                }
                if (index1 == leftY) {
                    StiRefObject<Double> stiRefObject = sumWidth;
                    Double.valueOf((Double)stiRefObject.argvalue + selectCell.getWidth());
                    stiRefObject.argvalue = stiRefObject.argvalue;
                }
                ++indexNewCell;
            }
            StiRefObject<Double> stiRefObject = sumHeight;
            Double.valueOf((Double)stiRefObject.argvalue + selectCell.getHeight());
            stiRefObject.argvalue = stiRefObject.argvalue;
        }
        return joinCells;
    }

    private int GetCountSelectedCells() {
        int count = 0;
        for (StiComponent cell : this.getComponents()) {
            if (!cell.getIsSelected()) continue;
            ++count;
        }
        return count;
    }

    private int GetCountJoinSelectedCells(Integer countJoin) {
        int count = 0;
        countJoin = 0;
        for (StiComponent cell : this.getComponents()) {
            if (!cell.getIsSelected()) continue;
            ++count;
            if (!((IStiTableCell)((Object)cell)).getMerged()) continue;
            Integer n = countJoin;
            Integer n2 = countJoin = Integer.valueOf(countJoin + 1);
        }
        return count;
    }

    private void FindLeftSelectedElement(int[] allX, StiRefObject<Integer> leftX, StiRefObject<Integer> rightX) {
        leftX.argvalue = allX[0];
        rightX.argvalue = allX[0];
        for (int index = 1; index < allX.length; ++index) {
            if ((Integer)leftX.argvalue > allX[index]) {
                leftX.argvalue = allX[index];
            }
            if ((Integer)rightX.argvalue >= allX[index]) continue;
            rightX.argvalue = allX[index];
        }
    }

    private void FindRightSelectedElement(int[] allY, StiRefObject<Integer> leftY, StiRefObject<Integer> rightY) {
        leftY.argvalue = allY[0];
        rightY.argvalue = allY[0];
        for (int index = 1; index < allY.length; ++index) {
            if ((Integer)leftY.argvalue > allY[index]) {
                leftY.argvalue = allY[index];
            }
            if ((Integer)rightY.argvalue >= allY[index]) continue;
            rightY.argvalue = allY[index];
        }
    }

    public final void ChangeTableCellContentInImage(StiTableCell cellText) {
        int indexCell = this.getComponents().indexOf(cellText);
        if (indexCell == -1) {
            return;
        }
        StiTableCellImage cellImage = new StiTableCellImage();
        cellImage.setClientRectangle(cellText.getClientRectangle());
        cellImage.setName(cellText.getName());
        cellImage.setBorder(cellText.getBorder());
        cellImage.setBrush(cellText.getBrush());
        cellImage.setID(cellText.getID());
        cellImage.setRestrictions(cellText.getRestrictions());
        cellImage.setPage(cellText.getPage());
        cellImage.setParent(cellText.getParent());
        cellImage.setCanBreak(cellText.getCanBreak());
        cellImage.setCanGrow(cellText.getCanGrow());
        cellImage.setCanShrink(cellText.getCanShrink());
        cellImage.setEnabled(cellText.getEnabled());
        cellImage.setGrowToHeight(cellText.getGrowToHeight());
        cellImage.setPrintable(cellText.getPrintable());
        if (cellText.getText().getValue().length() != 0) {
            cellImage.setDataColumn(cellText.getText().getValue().substring(1, 1 + cellText.getText().getValue().length() - 2));
        }
        if (cellText.join) {
            cellImage.join = cellText.join;
            cellImage.parentJoin = cellText.parentJoin;
            cellImage.joinCells = cellText.joinCells;
        }
        this.getComponents().remove(indexCell);
        this.getComponents().add(indexCell, cellImage);
        cellImage.select();
        cellText = null;
    }

    public final void ChangeTableCellContentInImage(StiTableCellCheckBox cellCheckBox) {
        int indexCell = this.getComponents().indexOf(cellCheckBox);
        if (indexCell == -1) {
            return;
        }
        StiTableCellImage cellImage = new StiTableCellImage();
        cellImage.setClientRectangle(cellCheckBox.getClientRectangle());
        cellImage.setName(cellCheckBox.getName());
        cellImage.setBorder(cellCheckBox.getBorder());
        cellImage.setBrush(cellCheckBox.getBrush());
        cellImage.setID(cellCheckBox.getID());
        cellImage.setRestrictions(cellCheckBox.getRestrictions());
        cellImage.setPage(cellCheckBox.getPage());
        cellImage.setParent(cellCheckBox.getParent());
        cellImage.setCanGrow(cellCheckBox.getCanGrow());
        cellImage.setCanShrink(cellCheckBox.getCanShrink());
        cellImage.setEnabled(cellCheckBox.getEnabled());
        cellImage.setGrowToHeight(cellCheckBox.getGrowToHeight());
        cellImage.setPrintable(cellCheckBox.getPrintable());
        if (cellCheckBox.getChecked().getValue().length() != 0) {
            cellImage.setDataColumn(cellCheckBox.getChecked().getValue().substring(1, 1 + cellCheckBox.getChecked().getValue().length() - 2));
        }
        if (cellCheckBox.join) {
            cellImage.join = cellCheckBox.join;
            cellImage.parentJoin = cellCheckBox.parentJoin;
            cellImage.joinCells = cellCheckBox.joinCells;
        }
        this.getComponents().remove(indexCell);
        this.getComponents().add(indexCell, cellImage);
        cellImage.select();
        cellCheckBox = null;
    }

    public final void ChangeTableCellContentInImage(StiTableCellRichText cellRichText) {
        int indexCell = this.getComponents().indexOf(cellRichText);
        if (indexCell == -1) {
            return;
        }
        StiTableCellImage cellImage = new StiTableCellImage();
        this.setProperty(cellImage, cellRichText);
        this.setProperty(cellImage, cellRichText);
        cellImage.setBrush((StiBrush)new StiSolidBrush(cellRichText.getBackColor()));
        if (cellRichText.getDataColumn().length() != 0) {
            cellImage.setDataColumn(cellRichText.getDataColumn());
        }
        if (cellRichText.join) {
            cellImage.join = cellRichText.join;
            cellImage.parentJoin = cellRichText.parentJoin;
            cellImage.joinCells = cellRichText.joinCells;
        }
        this.getComponents().remove(indexCell);
        this.getComponents().add(indexCell, cellImage);
        cellImage.select();
        cellRichText = null;
    }

    private void setProperty(StiComponent receiver, StiComponent source) {
        receiver.setClientRectangle(source.getClientRectangle());
        receiver.setName(source.getName());
        receiver.setRestrictions(source.getRestrictions());
        receiver.setPage(source.getPage());
        receiver.setParent(source.getParent());
        receiver.setCanGrow(source.getCanGrow());
        receiver.setCanShrink(source.getCanShrink());
        receiver.setEnabled(source.getEnabled());
        receiver.setGrowToHeight(source.getGrowToHeight());
        receiver.setPrintable(source.getPrintable());
    }

    private void setProperty(IStiBorder receiver, IStiBorder source) {
        receiver.setBorder(source.getBorder());
    }

    private void setProperty(IStiTableCell receiver, IStiTableCell source) {
        receiver.setID(source.getID());
    }

    private void setProperty(IStiBrush receiver, IStiBrush source) {
        receiver.setBrush(source.getBrush());
    }

    public final void ChangeTableCellContentInText(StiTableCellImage cellImage) {
        int indexCell = this.getComponents().indexOf(cellImage);
        if (indexCell == -1) {
            return;
        }
        StiTableCell cellText = new StiTableCell();
        this.setProperty(cellImage, cellImage);
        this.setProperty(cellImage, cellImage);
        this.setProperty(cellImage, cellImage);
        cellText.setCanBreak(cellImage.getCanBreak());
        if (cellImage.getDataColumn().length() != 0) {
            cellText.getText().setValue("{" + cellImage.getDataColumn() + "}");
        }
        if (cellImage.join) {
            cellText.join = cellImage.join;
            cellText.parentJoin = cellImage.parentJoin;
            cellText.joinCells = cellImage.joinCells;
        }
        this.getComponents().remove(indexCell);
        this.getComponents().add(indexCell, cellText);
        cellText.select();
        cellImage = null;
    }

    public final void ChangeTableCellContentInText(StiTableCellCheckBox cellCheckBox) {
        int indexCell = this.getComponents().indexOf(cellCheckBox);
        if (indexCell == -1) {
            return;
        }
        StiTableCell cellText = new StiTableCell();
        this.setProperty(cellText, cellCheckBox);
        this.setProperty(cellText, cellCheckBox);
        this.setProperty(cellText, cellCheckBox);
        if (cellCheckBox.getChecked().getValue().length() != 0) {
            cellText.getText().setValue(cellCheckBox.getChecked().getValue());
        }
        if (cellCheckBox.join) {
            cellText.join = cellCheckBox.join;
            cellText.parentJoin = cellCheckBox.parentJoin;
            cellText.joinCells = cellCheckBox.joinCells;
        }
        this.getComponents().remove(indexCell);
        this.getComponents().add(indexCell, cellText);
        cellText.select();
        cellCheckBox = null;
    }

    public final void ChangeTableCellContentInText(StiTableCellRichText cellRichText) {
        int indexCell = this.getComponents().indexOf(cellRichText);
        if (indexCell == -1) {
            return;
        }
        StiTableCell cellText = new StiTableCell();
        this.setProperty(cellText, cellRichText);
        this.setProperty(cellText, cellRichText);
        cellText.setBrush((StiBrush)new StiSolidBrush(cellRichText.getBackColor()));
        if (cellRichText.getDataColumn().length() != 0) {
            cellText.getText().setValue(cellRichText.getDataColumn());
        }
        if (cellRichText.join) {
            cellText.join = cellRichText.join;
            cellText.parentJoin = cellRichText.parentJoin;
            cellText.joinCells = cellRichText.joinCells;
        }
        this.getComponents().remove(indexCell);
        this.getComponents().add(indexCell, cellText);
        cellText.select();
        cellRichText = null;
    }

    public final void ChangeTableCellContentInCheckBox(StiTableCellImage cellImage) {
        int indexCell = this.getComponents().indexOf(cellImage);
        if (indexCell == -1) {
            return;
        }
        StiTableCellCheckBox cellCheckBox = new StiTableCellCheckBox();
        this.setProperty(cellCheckBox, cellImage);
        this.setProperty(cellCheckBox, cellImage);
        this.setProperty(cellCheckBox, cellImage);
        if (cellImage.getDataColumn().length() != 0) {
            cellCheckBox.getChecked().setValue("{" + cellImage.getDataColumn() + "}");
        }
        if (cellImage.join) {
            cellCheckBox.join = cellImage.join;
            cellCheckBox.parentJoin = cellImage.parentJoin;
            cellCheckBox.joinCells = cellImage.joinCells;
        }
        this.getComponents().remove(indexCell);
        this.getComponents().add(indexCell, cellCheckBox);
        cellCheckBox.select();
        cellImage = null;
    }

    public final void ChangeTableCellContentInCheckBox(StiTableCell cellText) {
        int indexCell = this.getComponents().indexOf(cellText);
        if (indexCell == -1) {
            return;
        }
        StiTableCellCheckBox cellCheckBox = new StiTableCellCheckBox();
        this.setProperty(cellCheckBox, cellText);
        this.setProperty(cellCheckBox, cellText);
        this.setProperty(cellCheckBox, cellText);
        if (cellText.getText().getValue().length() != 0) {
            cellCheckBox.getChecked().setValue(cellText.getText().getValue());
        }
        if (cellText.join) {
            cellCheckBox.join = cellText.join;
            cellCheckBox.parentJoin = cellText.parentJoin;
            cellCheckBox.joinCells = cellText.joinCells;
        }
        this.getComponents().remove(indexCell);
        this.getComponents().add(indexCell, cellCheckBox);
        cellCheckBox.select();
        cellText = null;
    }

    public final void ChangeTableCellContentInCheckBox(StiTableCellRichText cellRichText) {
        int indexCell = this.getComponents().indexOf(cellRichText);
        if (indexCell == -1) {
            return;
        }
        StiTableCellCheckBox cellCheckBox = new StiTableCellCheckBox();
        this.setProperty(cellCheckBox, cellRichText);
        this.setProperty(cellCheckBox, cellRichText);
        cellCheckBox.setBrush((StiBrush)new StiSolidBrush(cellRichText.getBackColor()));
        if (cellRichText.getDataColumn().length() != 0) {
            cellCheckBox.getChecked().setValue("{" + cellRichText.getDataColumn() + "}");
        }
        if (cellRichText.join) {
            cellCheckBox.join = cellRichText.join;
            cellCheckBox.parentJoin = cellRichText.parentJoin;
            cellCheckBox.joinCells = cellRichText.joinCells;
        }
        this.getComponents().remove(indexCell);
        this.getComponents().add(indexCell, cellCheckBox);
        cellCheckBox.select();
        cellRichText = null;
    }

    public final void ChangeTableCellContentInRichText(StiTableCell cellText) {
        int indexCell = this.getComponents().indexOf(cellText);
        if (indexCell == -1) {
            return;
        }
        StiTableCellRichText cellRichText = new StiTableCellRichText();
        cellRichText.setBackColor(StiBrush.ToColor((StiBrush)cellText.getBrush()));
        cellRichText.setCanBreak(cellText.getCanBreak());
        this.setProperty(cellRichText, cellText);
        this.setProperty(cellRichText, cellText);
        if (cellText.getText().getValue().length() != 0) {
            cellRichText.setDataColumn(cellText.getText().getValue().substring(1, 1 + cellText.getText().getValue().length() - 2));
        }
        if (cellText.join) {
            cellRichText.join = cellText.join;
            cellRichText.parentJoin = cellText.parentJoin;
            cellRichText.joinCells = cellText.joinCells;
        }
        this.getComponents().remove(indexCell);
        this.getComponents().add(indexCell, cellRichText);
        cellRichText.select();
        cellText = null;
    }

    public final void ChangeTableCellContentInRichText(StiTableCellImage cellImage) {
        int indexCell = this.getComponents().indexOf(cellImage);
        if (indexCell == -1) {
            return;
        }
        StiTableCellRichText cellRichText = new StiTableCellRichText();
        cellRichText.setBackColor(StiBrush.ToColor((StiBrush)cellImage.getBrush()));
        cellRichText.setCanBreak(cellImage.getCanBreak());
        this.setProperty(cellRichText, cellImage);
        this.setProperty(cellRichText, cellImage);
        if (cellImage.getDataColumn().length() != 0) {
            cellRichText.setDataColumn(cellImage.getDataColumn());
        }
        if (cellImage.join) {
            cellRichText.join = cellImage.join;
            cellRichText.parentJoin = cellImage.parentJoin;
            cellRichText.joinCells = cellImage.joinCells;
        }
        this.getComponents().remove(indexCell);
        this.getComponents().add(indexCell, cellRichText);
        cellRichText.select();
        cellImage = null;
    }

    public final void ChangeTableCellContentInRichText(StiTableCellCheckBox cellCheckBox) {
        int indexCell = this.getComponents().indexOf(cellCheckBox);
        if (indexCell == -1) {
            return;
        }
        StiTableCellRichText cellRichText = new StiTableCellRichText();
        cellRichText.setBackColor(StiBrush.ToColor((StiBrush)cellCheckBox.getBrush()));
        this.setProperty(cellRichText, cellCheckBox);
        this.setProperty(cellRichText, cellCheckBox);
        if (cellCheckBox.getChecked().getValue().length() != 0) {
            cellRichText.setDataColumn(cellCheckBox.getChecked().getValue().substring(1, 1 + cellCheckBox.getChecked().getValue().length() - 2));
        }
        if (cellCheckBox.join) {
            cellRichText.join = cellCheckBox.join;
            cellRichText.parentJoin = cellCheckBox.parentJoin;
            cellRichText.joinCells = cellCheckBox.joinCells;
        }
        this.getComponents().remove(indexCell);
        this.getComponents().add(indexCell, cellRichText);
        cellRichText.select();
        cellCheckBox = null;
    }

    public final int GetColumnForCell(IStiTableCell cell) {
        return 0;
    }

    private void SetCellID(IStiTableCell cell) {
        cell.setID(this.numberID);
        ++this.numberID;
    }

    public final void CreateCell() {
        if (this.getPage() == null || this.getParent() == null || this.getPage().getReport() == null) {
            return;
        }
        StiRectangle rect = this.getClientRectangle();
        if (rect.getWidth() < 0.0) {
            return;
        }
        super.setHeight((double)this.rowCount * this.getDefaultHeightCell());
        rect = this.getClientRectangle();
        if (this.getComponents().size() != 0) {
            this.getComponents().clear();
        }
        double w = rect.getWidth() / (double)this.columnCount;
        int indexW = (int)(w / this.getPage().getGridSize());
        double h = rect.height / (double)this.rowCount;
        int indexH = (int)(h / this.getPage().getGridSize());
        double allWidth = (double)indexW * this.getPage().getGridSize();
        double lastWidth = rect.getWidth() - allWidth * (double)(this.columnCount - 1);
        double allHeight = (double)indexH * this.getPage().getGridSize();
        double lastHeight = rect.height - allHeight * (double)(this.rowCount - 1);
        double posX = 0.0;
        int index = 1;
        for (int index1 = 0; index1 < this.rowCount; ++index1) {
            for (int index2 = 0; index2 < this.columnCount; ++index2) {
                StiTableCell cell = new StiTableCell();
                this.SetCellID(cell);
                cell.setName(String.format("%1$s_Cell%2$s", this.getName(), index));
                double cellWidth = index2 == this.columnCount - 1 ? lastWidth : allWidth;
                double cellHeight = index1 == this.rowCount - 1 ? lastHeight : allHeight;
                cell.setClientRectangle(new StiRectangle(posX, allHeight * (double)index1, cellWidth, cellHeight));
                this.SetStyleForCell(cell, true);
                posX = cell.getRight();
                this.getComponents().add(cell);
                ++index;
            }
            posX = 0.0;
        }
        this.ResizeHeightCell();
        this.ApplyStyleNone();
    }

    private void SetStyleForCell(StiComponent cell, boolean select) {
        cell.setRestrictions((StiEnumSet<StiRestrictions>)new StiEnumSet((Enum)StiRestrictions.AllowMove, (Enum[])new StiRestrictions[]{StiRestrictions.AllowSelect, StiRestrictions.AllowChange}));
        cell.setIsSelected(select);
        cell.setCanGrow(false);
        cell.setGrowToHeight(false);
        cell.setPage(this.getPage());
        cell.setParent(this);
    }

    private void SetStyleForCell(StiTableCell cell, boolean select) {
        cell.setRestrictions((StiEnumSet<StiRestrictions>)new StiEnumSet((Enum)StiRestrictions.AllowMove, (Enum[])new StiRestrictions[]{StiRestrictions.AllowSelect, StiRestrictions.AllowChange}));
        cell.setBrush((StiBrush)new StiSolidBrush(StiColor.White));
        cell.setFont(new StiFont("Arial", 9.0));
        cell.setIsSelected(select);
        cell.setCanGrow(false);
        cell.setGrowToHeight(false);
        cell.setPage(this.getPage());
        cell.setParent(this);
    }

    private void AddNewRows(int count) {
        if (this.getComponents().size() == 0) {
            return;
        }
        int numberCell = this.getComponents().size() + 1;
        StiRectangle rect = this.getClientRectangle();
        rect.height += this.getDefaultHeightCell() * (double)count;
        super.setClientRectangle(rect);
        for (int index1 = 0; index1 < count; ++index1) {
            for (int index2 = 0; index2 < this.columnCount; ++index2) {
                StiTableCell newCell = new StiTableCell();
                StiComponent topCell = this.getComponents().get(this.getComponents().size() - this.columnCount) instanceof StiComponent ? (StiComponent)this.getComponents().get(this.getComponents().size() - this.columnCount) : null;
                newCell.setName(String.format("%1$s_Cell%2$s", this.getName(), numberCell));
                this.SetCellID(newCell);
                double newLeft = ((IStiTableCell)((Object)topCell)).GetRealLeft();
                double newWidth = ((IStiTableCell)((Object)topCell)).GetRealWidth();
                newCell.setClientRectangle(new StiRectangle(newLeft, topCell.getBottom(), newWidth, this.getDefaultHeightCell()));
                this.SetStyleForCell(newCell, true);
                if (this.tableStyle == StiTableStyle.StyleNone) {
                    this.ApplyStyleNoneForCell(newCell);
                }
                this.getComponents().add(newCell);
                ++numberCell;
            }
        }
        this.RefreshTableStyle();
    }

    private void DeleteLastRows(int count, int oldValue) {
        int index1;
        if (this.getComponents().size() == 0) {
            return;
        }
        double sumHeight = 0.0;
        for (index1 = oldValue - count; index1 < oldValue; ++index1) {
            for (int index2 = 0; index2 < this.columnCount; ++index2) {
                StiComponent cell;
                StiComponent stiComponent = cell = this.getComponents().get(index1 * this.columnCount + index2) instanceof StiComponent ? (StiComponent)this.getComponents().get(index1 * this.columnCount + index2) : null;
                if (!((IStiTableCell)((Object)cell)).getMerged()) continue;
                StiComponent parentJoinCell = ((IStiTableCell)((Object)cell)).GetJoinComponentByGuid(((IStiTableCell)((Object)cell)).getParentJoin());
                ((IStiTableCell)((Object)parentJoinCell)).setJoin(false);
            }
            sumHeight += ((StiComponent)this.getComponents().get(index1 * this.columnCount)).getHeight();
        }
        for (index1 = 0; index1 < count * this.columnCount; ++index1) {
            this.getComponents().remove(this.getComponents().size() - 1);
        }
        super.setHeight(super.getHeight() - sumHeight);
        this.RefreshTableStyle();
    }

    private void AddTableNewColumns(int count, int oldValue) {
        int index1;
        if (this.getComponents().size() == 0) {
            return;
        }
        StiRectangle rect = this.getClientRectangle();
        int countGrid = (int)(rect.width / this.getPage().getGridSize());
        int countColumns = this.columnCount;
        int colGridForCell = countGrid / countColumns;
        int rest = countGrid - colGridForCell * countColumns;
        double[] widths = new double[countColumns];
        for (int index12 = 0; index12 < countColumns; ++index12) {
            widths[index12] = (double)colGridForCell * this.getPage().getGridSize();
            if (index12 >= rest) continue;
            int n = index12;
            widths[n] = widths[n] + this.getPage().getGridSize();
        }
        int n = countColumns - 1;
        widths[n] = widths[n] + (rect.width - (double)countGrid * this.getPage().getGridSize());
        int index = 0;
        int indexColumn = 0;
        double posX = 0.0;
        for (index1 = 0; index1 < this.rowCount; ++index1) {
            for (int index2 = 0; index2 < oldValue; ++index2) {
                StiComponent cell = this.getComponents().get(index) instanceof StiComponent ? (StiComponent)this.getComponents().get(index) : null;
                cell.setName(String.format("%1$s_Cell%2$s", this.getName(), index + 1));
                cell.setClientRectangle(new StiRectangle(posX, cell.getTop(), widths[indexColumn], cell.getHeight()));
                posX += widths[indexColumn];
                ++index;
                ++indexColumn;
                if (index2 != oldValue - 1) continue;
                double newHeight = ((IStiTableCell)((Object)cell)).GetRealHeight();
                double newTop = ((IStiTableCell)((Object)cell)).GetRealTop();
                for (int index3 = 0; index3 < count; ++index3) {
                    StiTableCell newCell = new StiTableCell();
                    newCell.setName(String.format("%1$s_Cell%2$s", this.getName(), index + 1));
                    this.SetCellID(newCell);
                    newCell.setClientRectangle(new StiRectangle(posX, newTop, widths[indexColumn], newHeight));
                    this.SetStyleForCell(newCell, true);
                    if (this.tableStyle == StiTableStyle.StyleNone) {
                        this.ApplyStyleNoneForCell(newCell);
                    }
                    this.getComponents().add(index, newCell);
                    posX += widths[indexColumn];
                    ++index;
                    ++indexColumn;
                }
            }
            posX = 0.0;
            indexColumn = 0;
        }
        for (index1 = 0; index1 < this.getComponents().size(); ++index1) {
            StiComponent cells;
            StiComponent stiComponent = cells = this.getComponents().get(index1) instanceof StiComponent ? (StiComponent)this.getComponents().get(index1) : null;
            if (cells == null || !((IStiTableCell)((Object)cells)).getJoin()) continue;
            ((IStiTableCell)((Object)cells)).SetJoinSize();
        }
        this.RefreshTableStyle();
    }

    private void DeleteTableColumns(int count, int oldValue) {
        int index1;
        if (this.getComponents().size() == 0) {
            return;
        }
        int countColumn = oldValue - count;
        int index = 0;
        for (int index12 = 0; index12 < this.rowCount; ++index12) {
            index += countColumn;
            for (int index2 = 0; index2 < count; ++index2) {
                this.getComponents().remove(index);
            }
        }
        StiRectangle rect = this.getClientRectangle();
        int countGrid = (int)(rect.width / this.getPage().getGridSize());
        int countGridOnCell = countGrid / countColumn;
        int rest = countGrid - countGridOnCell * countColumn;
        double[] widths = new double[countColumn];
        for (int index13 = 0; index13 < countColumn; ++index13) {
            widths[index13] = (double)countGridOnCell * this.getPage().getGridSize();
            if (index13 >= rest) continue;
            int n = index13;
            widths[n] = widths[n] + this.getPage().getGridSize();
        }
        double posX = 0.0;
        index = 0;
        for (index1 = 0; index1 < this.rowCount; ++index1) {
            for (int index2 = 0; index2 < countColumn; ++index2) {
                StiComponent cell = this.getComponents().get(index) instanceof StiComponent ? (StiComponent)this.getComponents().get(index) : null;
                cell.setName(String.format("%1$s_Cell%2$s", this.getName(), index + 1));
                cell.setLeft(posX);
                cell.setWidth(widths[index2]);
                posX += widths[index2];
                ++index;
            }
            posX = 0.0;
        }
        for (index1 = 0; index1 < this.getComponents().size(); ++index1) {
            StiComponent cells;
            StiComponent stiComponent = cells = this.getComponents().get(index1) instanceof StiComponent ? (StiComponent)this.getComponents().get(index1) : null;
            if (cells == null || !((IStiTableCell)((Object)cells)).getJoin()) continue;
            ((IStiTableCell)((Object)cells)).SetJoinSize();
        }
        this.RefreshTableStyle();
    }

    public final void InsertColumnToLeft(int numberColumn) {
        StiComponent cell;
        if (numberColumn < 0) {
            return;
        }
        if (numberColumn != 0) {
            int indexCell = numberColumn;
            for (int indexRow = 0; indexRow < this.rowCount; ++indexRow) {
                StiComponent parentJoinCell;
                cell = (StiComponent)this.getComponents().get(indexCell);
                StiComponent leftCell = (StiComponent)this.getComponents().get(indexCell - 1);
                if (((IStiTableCell)((Object)cell)).getMerged() && ((IStiTableCell)((Object)leftCell)).getMerged() && ((IStiTableCell)((Object)(parentJoinCell = ((IStiTableCell)((Object)cell)).GetJoinComponentByGuid(((IStiTableCell)((Object)cell)).getParentJoin())))).ContainsGuid(((IStiTableCell)((Object)leftCell)).getID())) {
                    ((IStiTableCell)((Object)parentJoinCell)).setJoin(false);
                }
                indexCell += this.columnCount;
            }
        }
        int indexNewCell = numberColumn;
        for (int index = 0; index < this.rowCount; ++index) {
            cell = (StiComponent)this.getComponents().get(indexNewCell);
            StiTableCell newCell = new StiTableCell();
            this.SetCellID(newCell);
            newCell.setTop(((IStiTableCell)((Object)cell)).GetRealTop());
            newCell.setHeight(((IStiTableCell)((Object)cell)).GetRealHeight());
            this.SetStyleForCell(newCell, false);
            if (this.tableStyle == StiTableStyle.StyleNone) {
                this.ApplyStyleNoneForCell(newCell);
            }
            this.getComponents().add(indexNewCell, newCell);
            ++indexNewCell;
            indexNewCell += this.columnCount;
        }
        ++this.columnCount;
        this.ResizeWidthCellsAfterChanges();
        this.RefreshTableStyle();
    }

    public final void InsertColumnToRight(int numberColumn) {
        StiComponent cell;
        if (numberColumn < 0) {
            return;
        }
        if (numberColumn != this.columnCount - 1) {
            int indexCell = numberColumn;
            for (int indexRow = 0; indexRow < this.rowCount; ++indexRow) {
                StiComponent parentJoinCell;
                cell = (StiComponent)this.getComponents().get(indexCell);
                StiComponent rightCell = (StiComponent)this.getComponents().get(indexCell + 1);
                if (((IStiTableCell)((Object)cell)).getMerged() && ((IStiTableCell)((Object)rightCell)).getMerged() && ((IStiTableCell)((Object)(parentJoinCell = ((IStiTableCell)((Object)cell)).GetJoinComponentByGuid(((IStiTableCell)((Object)cell)).getParentJoin())))).ContainsGuid(((IStiTableCell)((Object)rightCell)).getID())) {
                    ((IStiTableCell)((Object)parentJoinCell)).setJoin(false);
                }
                indexCell += this.columnCount;
            }
        }
        int indexNewCell = numberColumn;
        for (int index = 0; index < this.rowCount; ++index) {
            cell = (StiComponent)this.getComponents().get(indexNewCell);
            StiTableCell newCell = new StiTableCell();
            this.SetCellID(newCell);
            newCell.setTop(((IStiTableCell)((Object)cell)).GetRealTop());
            newCell.setHeight(((IStiTableCell)((Object)cell)).GetRealHeight());
            this.SetStyleForCell(newCell, false);
            if (this.tableStyle == StiTableStyle.StyleNone) {
                this.ApplyStyleNoneForCell(newCell);
            }
            this.getComponents().add(indexNewCell + 1, newCell);
            ++indexNewCell;
            indexNewCell += this.columnCount;
        }
        ++this.columnCount;
        this.ResizeWidthCellsAfterChanges();
        this.RefreshTableStyle();
    }

    public final void InsertRowAbove(int numberRow) {
        StiComponent cell;
        if (numberRow < 0) {
            return;
        }
        if (numberRow != 0) {
            int indexCell = numberRow * this.columnCount;
            for (int indexRow = 0; indexRow < this.columnCount; ++indexRow) {
                StiComponent parentJoinCell;
                cell = (StiComponent)this.getComponents().get(indexCell);
                StiComponent leftCell = (StiComponent)this.getComponents().get(indexCell - this.columnCount);
                if (((IStiTableCell)((Object)cell)).getMerged() && ((IStiTableCell)((Object)leftCell)).getMerged() && ((IStiTableCell)((Object)(parentJoinCell = ((IStiTableCell)((Object)cell)).GetJoinComponentByGuid(((IStiTableCell)((Object)cell)).getParentJoin())))).ContainsGuid(((IStiTableCell)((Object)leftCell)).getID())) {
                    ((IStiTableCell)((Object)parentJoinCell)).setJoin(false);
                }
                ++indexCell;
            }
        }
        int indexNewCell = numberRow * this.columnCount;
        for (int index = 0; index < this.columnCount; ++index) {
            cell = (StiComponent)this.getComponents().get(indexNewCell + index);
            StiTableCell newCell = new StiTableCell();
            this.SetCellID(newCell);
            newCell.setLeft(((IStiTableCell)((Object)cell)).GetRealLeft());
            newCell.setWidth(((IStiTableCell)((Object)cell)).GetRealWidth());
            newCell.setHeight(this.getDefaultHeightCell());
            this.SetStyleForCell(newCell, false);
            if (this.tableStyle == StiTableStyle.StyleNone) {
                this.ApplyStyleNoneForCell(newCell);
            }
            this.getComponents().add(indexNewCell, newCell);
            ++indexNewCell;
        }
        ++this.rowCount;
        this.ResizeHeightCellsAfterChanges(this.getDefaultHeightCell());
        this.RefreshTableStyle();
    }

    public final void InsertRowBelow(int numberRow) {
        StiComponent cell;
        if (numberRow < 0) {
            return;
        }
        if (numberRow != this.rowCount) {
            int indexCell = numberRow * this.columnCount;
            for (int indexRow = 0; indexRow < this.columnCount; ++indexRow) {
                StiComponent parentJoinCell;
                cell = (StiComponent)this.getComponents().get(indexCell);
                StiComponent leftCell = (StiComponent)this.getComponents().get(indexCell - this.columnCount);
                if (((IStiTableCell)((Object)cell)).getMerged() && ((IStiTableCell)((Object)leftCell)).getMerged() && ((IStiTableCell)((Object)(parentJoinCell = ((IStiTableCell)((Object)cell)).GetJoinComponentByGuid(((IStiTableCell)((Object)cell)).getParentJoin())))).ContainsGuid(((IStiTableCell)((Object)leftCell)).getID())) {
                    ((IStiTableCell)((Object)parentJoinCell)).setJoin(false);
                }
                ++indexCell;
            }
        }
        int indexNewCell = numberRow * this.columnCount;
        for (int index = 0; index < this.columnCount; ++index) {
            cell = numberRow == this.rowCount ? (StiComponent)this.getComponents().get(indexNewCell - this.columnCount) : (StiComponent)this.getComponents().get(indexNewCell + index);
            StiTableCell newCell = new StiTableCell();
            this.SetCellID(newCell);
            newCell.setLeft(((IStiTableCell)((Object)cell)).GetRealLeft());
            newCell.setWidth(((IStiTableCell)((Object)cell)).GetRealWidth());
            newCell.setHeight(this.getDefaultHeightCell());
            this.SetStyleForCell(newCell, false);
            if (this.tableStyle == StiTableStyle.StyleNone) {
                this.ApplyStyleNoneForCell(newCell);
            }
            this.getComponents().add(indexNewCell, newCell);
            ++indexNewCell;
        }
        ++this.rowCount;
        this.ResizeHeightCellsAfterChanges(this.getDefaultHeightCell());
        this.RefreshTableStyle();
    }

    public final void DeleteRows(int firstRow, int lastRow) {
        int countDeleteRows = lastRow - firstRow + 1;
        if (countDeleteRows == this.rowCount) {
            return;
        }
        int numberCell = firstRow * this.columnCount;
        double sumHeight = 0.0;
        for (int indexRow = firstRow; indexRow <= lastRow; ++indexRow) {
            for (int indexCol = 0; indexCol < this.columnCount; ++indexCol) {
                StiComponent cell;
                StiComponent stiComponent = cell = this.getComponents().get(numberCell) instanceof StiComponent ? (StiComponent)this.getComponents().get(numberCell) : null;
                if (cell == null) continue;
                if (((IStiTableCell)((Object)cell)).getMerged()) {
                    ((IStiTableCell)((Object)((IStiTableCell)((Object)cell)).GetJoinComponentByGuid(((IStiTableCell)((Object)cell)).getParentJoin()))).setJoin(false);
                }
                if (indexCol == 0) {
                    sumHeight += ((IStiTableCell)((Object)cell)).GetRealHeight();
                }
                this.getComponents().remove(numberCell);
            }
        }
        this.rowCount -= countDeleteRows;
        this.ResizeHeightCellsAfterChanges(sumHeight * -1.0);
        this.RefreshTableStyle();
    }

    public final void DeleteColumns(int firstColumn, int lastColumn) {
        int countDeleteColumns = lastColumn - firstColumn + 1;
        if (countDeleteColumns == this.columnCount) {
            return;
        }
        int numberCell = firstColumn;
        double sumWidth = 0.0;
        for (int indexRow = 0; indexRow < this.rowCount; ++indexRow) {
            for (int indexCol = firstColumn; indexCol <= lastColumn; ++indexCol) {
                StiComponent cell;
                StiComponent stiComponent = cell = this.getComponents().get(numberCell) instanceof StiComponent ? (StiComponent)this.getComponents().get(numberCell) : null;
                if (cell == null) continue;
                if (((IStiTableCell)((Object)cell)).getMerged()) {
                    ((IStiTableCell)((Object)((IStiTableCell)((Object)cell)).GetJoinComponentByGuid(((IStiTableCell)((Object)cell)).getParentJoin()))).setJoin(false);
                }
                if (indexRow == 0) {
                    sumWidth += ((IStiTableCell)((Object)cell)).GetRealWidth();
                }
                this.getComponents().remove(numberCell);
            }
            numberCell += this.columnCount - countDeleteColumns;
        }
        this.columnCount -= countDeleteColumns;
        this.ResizeWidthCellsAfterChanges();
        this.RefreshTableStyle();
    }

    public final void DistributeRows() {
        if (this.IsConverted || this.getParent() == null && this.getPage() == null && this.getComponents().size() == 0) {
            return;
        }
        StiRectangle rect = this.getClientRectangle();
        int gridCountHeight = (int)(rect.height / this.getPage().getGridSize());
        int cellGridCount = gridCountHeight / this.rowCount;
        int restHeight = gridCountHeight - cellGridCount * this.rowCount;
        double[] heights = new double[this.rowCount];
        for (int indexRow = 0; indexRow < this.rowCount; ++indexRow) {
            heights[indexRow] = (double)cellGridCount * this.getPage().getGridSize();
            if (indexRow >= restHeight) continue;
            int n = indexRow;
            heights[n] = heights[n] + this.getPage().getGridSize();
        }
        int n = heights.length - 1;
        heights[n] = heights[n] + (rect.height - (double)gridCountHeight * this.getPage().getGridSize());
        double posY = 0.0;
        int indexCell = 0;
        for (int indexRow = 0; indexRow < this.rowCount; ++indexRow) {
            for (int indexCol = 0; indexCol < this.columnCount; ++indexCol) {
                StiComponent cell;
                StiComponent stiComponent = cell = this.getComponents().get(indexCell) instanceof StiComponent ? (StiComponent)this.getComponents().get(indexCell) : null;
                if (cell == null) continue;
                cell.setClientRectangle(new StiRectangle(((IStiTableCell)((Object)cell)).GetRealLeft(), posY, ((IStiTableCell)((Object)cell)).GetRealWidth(), heights[indexRow]));
                if (((IStiTableCell)((Object)cell)).getJoin()) {
                    ((IStiTableCell)((Object)cell)).SetJoinSize();
                }
                ++indexCell;
            }
            posY += heights[indexRow];
        }
    }

    public final void DistributeColumns() {
        if (this.IsConverted || this.getParent() == null && this.getPage() == null && this.getComponents().size() == 0) {
            return;
        }
        StiRectangle rect = this.getClientRectangle();
        int gridCountWidth = (int)(rect.width / this.getPage().getGridSize());
        int cellGridCount = gridCountWidth / this.columnCount;
        int restWidth = gridCountWidth - cellGridCount * this.columnCount;
        double[] widths = new double[this.columnCount];
        for (int indexCol = 0; indexCol < this.columnCount; ++indexCol) {
            widths[indexCol] = (double)cellGridCount * this.getPage().getGridSize();
            if (indexCol >= restWidth) continue;
            int n = indexCol;
            widths[n] = widths[n] + this.getPage().getGridSize();
        }
        int n = widths.length - 1;
        widths[n] = widths[n] + (rect.width - (double)gridCountWidth * this.getPage().getGridSize());
        double posX = 0.0;
        int indexCell = 0;
        for (int indexRow = 0; indexRow < this.rowCount; ++indexRow) {
            for (int indexCol = 0; indexCol < this.columnCount; ++indexCol) {
                StiComponent cell;
                StiComponent stiComponent = cell = this.getComponents().get(indexCell) instanceof StiComponent ? (StiComponent)this.getComponents().get(indexCell) : null;
                if (cell == null) continue;
                cell.setClientRectangle(new StiRectangle(posX, ((IStiTableCell)((Object)cell)).GetRealTop(), widths[indexCol], ((IStiTableCell)((Object)cell)).GetRealHeight()));
                posX += widths[indexCol];
                ++indexCell;
            }
            posX = 0.0;
        }
    }

    public final void AutoSizeCells() {
        if (this.IsConverted || this.getComponents().size() == 0 || this.getPage() == null) {
            return;
        }
        StiRectangle rect = this.getClientRectangle();
        int gridCountWidth = (int)(rect.width / this.getPage().getGridSize());
        int cellGridCount = gridCountWidth / this.columnCount;
        int restWidth = gridCountWidth - cellGridCount * this.columnCount;
        double[] widths = new double[this.columnCount];
        for (int indexCol = 0; indexCol < this.columnCount; ++indexCol) {
            widths[indexCol] = (double)cellGridCount * this.getPage().getGridSize();
            if (indexCol >= restWidth) continue;
            int n = indexCol;
            widths[n] = widths[n] + this.getPage().getGridSize();
        }
        int n = widths.length - 1;
        widths[n] = widths[n] + (rect.width - (double)gridCountWidth * this.getPage().getGridSize());
        int gridCountHeight = (int)(rect.height / this.getPage().getGridSize());
        cellGridCount = gridCountHeight / this.rowCount;
        int restHeight = gridCountHeight - cellGridCount * this.rowCount;
        double[] heights = new double[this.rowCount];
        for (int indexRow = 0; indexRow < this.rowCount; ++indexRow) {
            heights[indexRow] = (double)cellGridCount * this.getPage().getGridSize();
            if (indexRow >= restHeight) continue;
            int n2 = indexRow;
            heights[n2] = heights[n2] + this.getPage().getGridSize();
        }
        int n3 = heights.length - 1;
        heights[n3] = heights[n3] + (rect.height - (double)gridCountHeight * this.getPage().getGridSize());
        double posX = 0.0;
        double posY = 0.0;
        int indexCell = 0;
        for (int indexRow = 0; indexRow < this.rowCount; ++indexRow) {
            for (int indexCol = 0; indexCol < this.columnCount; ++indexCol) {
                StiComponent cell = (StiComponent)this.getComponents().get(indexCell);
                cell.setClientRectangle(new StiRectangle(posX, posY, widths[indexCol], heights[indexRow]));
                posX += widths[indexCol];
                ++indexCell;
            }
            posX = 0.0;
            posY += heights[indexRow];
        }
    }

    private void ResizeWidthCellsAfterChanges() {
        if (this.IsConverted) {
            return;
        }
        StiRectangle rect = this.getClientRectangle();
        int countGrid = (int)(rect.width / this.getPage().getGridSize());
        int colGridForCell = countGrid / this.columnCount;
        int rest = countGrid - colGridForCell * this.columnCount;
        double[] widths = new double[this.columnCount];
        for (int index1 = 0; index1 < this.columnCount; ++index1) {
            widths[index1] = (double)colGridForCell * this.getPage().getGridSize();
            if (index1 >= rest) continue;
            int n = index1;
            widths[n] = widths[n] + this.getPage().getGridSize();
        }
        int n = this.columnCount - 1;
        widths[n] = widths[n] + (rect.width - (double)countGrid * this.getPage().getGridSize());
        int index = 0;
        int indexColumn = 0;
        double posX = 0.0;
        for (int index1 = 0; index1 < this.rowCount; ++index1) {
            for (int index2 = 0; index2 < this.columnCount; ++index2) {
                StiComponent cell = this.getComponents().get(index) instanceof StiComponent ? (StiComponent)this.getComponents().get(index) : null;
                cell.setName(String.format("%1$s_Cell%2$s", this.getName(), index + 1));
                if (((IStiTableCell)((Object)cell)).getJoin()) {
                    cell.setLeft(posX);
                    cell.setWidth(widths[indexColumn]);
                    ((IStiTableCell)((Object)cell)).SetJoinSize();
                } else {
                    cell.setClientRectangle(new StiRectangle(posX, cell.getTop(), widths[indexColumn], cell.getHeight()));
                }
                posX += widths[indexColumn];
                ++index;
                ++indexColumn;
            }
            indexColumn = 0;
            posX = 0.0;
        }
    }

    private void ResizeHeightCellsAfterChanges(double changeHeight) {
        if (this.IsConverted) {
            return;
        }
        StiRectangle rect = this.getClientRectangle();
        rect.height += changeHeight;
        double posY = 0.0;
        int indexCell = 0;
        StiComponent cell = null;
        for (int indexRow = 0; indexRow < this.rowCount; ++indexRow) {
            for (int indexCol = 0; indexCol < this.columnCount; ++indexCol) {
                cell = (StiComponent)this.getComponents().get(indexCell);
                cell.setName(String.format("%1$s_Cell%2$s", this.getName(), indexCell + 1));
                if (((IStiTableCell)((Object)cell)).getJoin()) {
                    cell.setHeight(((IStiTableCell)((Object)cell)).GetRealHeightAfterInsertRows());
                    cell.setTop(posY);
                    ((IStiTableCell)((Object)cell)).SetJoinSize();
                } else {
                    cell.setTop(posY);
                }
                ++indexCell;
            }
            if (cell == null) continue;
            posY += ((IStiTableCell)((Object)cell)).GetRealHeight();
        }
        super.setClientRectangle(rect);
    }

    private void ResizeWidthCell(double oldWidth) {
        if (this.IsConverted || this.getComponents().size() == 0 || this.getPage() == null) {
            return;
        }
        double difference = super.getWidth() - oldWidth;
        double w = difference / (double)this.columnCount;
        int index = (int)(w / this.getPage().getGridSize());
        double allWidth = this.getPage().getGridSize() * (double)index;
        double lastWidth = difference - allWidth * (double)(this.columnCount - 1);
        for (int index1 = 0; index1 < this.columnCount; ++index1) {
            for (int index2 = 0; index2 < this.rowCount; ++index2) {
                StiComponent cell;
                StiComponent stiComponent = cell = this.getComponents().get(index2 * this.columnCount + index1) instanceof StiComponent ? (StiComponent)this.getComponents().get(index2 * this.columnCount + index1) : null;
                if (index1 == this.columnCount - 1) {
                    cell.setLeft(cell.getLeft() + (double)index1 * allWidth);
                    cell.setWidth(cell.getWidth() + lastWidth);
                    continue;
                }
                cell.setLeft(cell.getLeft() + (double)index1 * allWidth);
                cell.setWidth(cell.getWidth() + allWidth);
            }
        }
    }

    private void ResizeHeightCell() {
        if (this.IsConverted || this.getPage() == null && this.getComponents().size() == 0) {
            return;
        }
        StiRectangle rect = this.getClientRectangle();
        if (this.rowCount == 1) {
            for (int index1 = 0; index1 < this.columnCount; ++index1) {
                StiComponent cell = this.getComponents().get(index1) instanceof StiComponent ? (StiComponent)this.getComponents().get(index1) : null;
                cell.setTop(0.0);
                cell.setHeight(rect.height);
            }
        } else {
            double[] heights = new double[this.rowCount];
            int countGrid = (int)(rect.height / this.getPage().getGridSize());
            int indexH = countGrid / this.rowCount;
            int rest = countGrid - indexH * this.rowCount;
            double allHeight = (double)indexH * this.getPage().getGridSize();
            for (int index1 = 0; index1 < this.rowCount; ++index1) {
                heights[index1] = allHeight;
                if (index1 >= rest) continue;
                int n = index1;
                heights[n] = heights[n] + this.getPage().getGridSize();
            }
            int n = this.rowCount - 1;
            heights[n] = heights[n] + (rect.height - this.getPage().getGridSize() * (double)countGrid);
            double posY = 0.0;
            for (int index1 = 0; index1 < this.rowCount; ++index1) {
                for (int index2 = 0; index2 < this.columnCount; ++index2) {
                    StiComponent cell;
                    StiComponent stiComponent = cell = this.getComponents().get(index1 * this.columnCount + index2) instanceof StiComponent ? (StiComponent)this.getComponents().get(index1 * this.columnCount + index2) : null;
                    if (((IStiTableCell)((Object)cell)).getJoin()) {
                        StiComponent firstCell = ((IStiTableCell)((Object)cell)).GetJoinComponentByIndex(0);
                        cell.setLeft(firstCell.getLeft());
                        cell.setTop(firstCell.getTop());
                        cell.setHeight(posY + heights[index1] - firstCell.getTop());
                        continue;
                    }
                    cell.setTop(posY);
                    cell.setHeight(heights[index1]);
                }
                posY += heights[index1];
            }
        }
    }

    public final StiDataBand StartRenderTableBand(Hashtable newTableComponents) {
        if (!this.getReport().isInteractionRendering && !this.getEnabled()) {
            return null;
        }
        StiPage page = (StiPage)(this.parent instanceof StiPage ? this.parent : null);
        StiDataBand dataBand = (StiDataBand)(this.parent instanceof StiDataBand ? this.parent : null);
        StiPanel panel = (StiPanel)(this.parent instanceof StiPanel ? this.parent : null);
        if (this.dockableTable) {
            if (dataBand != null) {
                StiPanel panelInDataBand = new StiPanel();
                panelInDataBand.setName(this.getName() + "_Panel");
                panelInDataBand.setCanBreak(true);
                panelInDataBand.setClientRectangle(dataBand.getClientRectangle());
                panelInDataBand.setDockStyle(StiDockStyle.Fill);
                int indexTable = dataBand.getComponents().indexOf(this);
                dataBand.getComponents().add(indexTable, panelInDataBand);
                return this.StartRenderTable(panelInDataBand, 0, newTableComponents);
            }
            if (page != null) {
                int index = this.page.getComponents().indexOf(this);
                return this.StartRenderTable(page, index, newTableComponents);
            }
            if (panel != null) {
                int index = panel.getComponents().indexOf(this);
                return this.StartRenderTable(panel, index, newTableComponents);
            }
        } else {
            if (dataBand != null) {
                StiPanel panelInDataBand = new StiPanel();
                panelInDataBand.setName(this.getName() + "_Panel");
                panelInDataBand.setCanBreak(true);
                panelInDataBand.setCanGrow(true);
                panelInDataBand.setClientRectangle(this.getClientRectangle());
                int indexTable = dataBand.getComponents().indexOf(this);
                dataBand.getComponents().add(indexTable, panelInDataBand);
                return this.StartRenderTable(panelInDataBand, 0, newTableComponents);
            }
            if (page != null) {
                int index = this.page.getComponents().indexOf(this);
                StiDataBand newBand = new StiDataBand();
                newBand.setName(this.getName() + "_Band");
                newBand.setLeft(this.getLeft());
                newBand.top = this.top;
                this.page.getComponents().add(index, newBand);
                StiPanel panelInDataBand = new StiPanel();
                panelInDataBand.setName(this.getName() + "_Panel");
                panelInDataBand.setCanBreak(true);
                panelInDataBand.setCanGrow(true);
                panelInDataBand.setClientRectangle(this.getClientRectangle());
                panelInDataBand.top = 0.0;
                newBand.getComponents().add(panelInDataBand);
                return this.StartRenderTable(panelInDataBand, 0, newTableComponents);
            }
            if (panel != null) {
                int index = panel.parent.getComponents().indexOf(panel);
                return this.StartRenderTable(panel, index, newTableComponents);
            }
        }
        return null;
    }

    private StiDataBand StartRenderTable(StiContainer parentContainer, int index, Hashtable newTableComponents) {
        StiRichText newRichText;
        StiCheckBox newCheckBox;
        StiText newCellText;
        StiText emptyText;
        StiComponent parentJoin;
        boolean join;
        StiComponent tableCell;
        int indexCell;
        StiPanel panel;
        double __height;
        Hashtable<StiComponent, StiComponent> joinCells;
        Hashtable<StiComponent, Integer> listCellHeader;
        StiPage page = this.getPage();
        ArrayList list = null;
        if (newTableComponents.containsKey(page)) {
            list = newTableComponents.get(page) instanceof ArrayList ? newTableComponents.get(page) : null;
        } else {
            list = new ArrayList();
            newTableComponents.put(page, list);
        }
        super.setEnabled(false);
        int lastElementHeader = 0;
        StiDataBand tableData = null;
        StiRectangle rect = this.getClientRectangle();
        double posY = this.dockableTable ? rect.y : 0.0;
        double headerHeight = 0.0;
        double footerHeight = 0.0;
        double dataBandHeight = 0.0;
        int rCount = this.getComponents().size() / this.columnCount;
        for (int indexRow = 0; indexRow < this.rowCount; ++indexRow) {
            for (int indexCol = 0; indexCol < this.columnCount; ++indexCol) {
                StiComponent component = (StiComponent)this.getComponents().get(this.columnCount * indexRow + indexCol);
                if (!(component instanceof IStiTableCell)) continue;
                ((IStiTableCell)((Object)component)).setColumn(indexCol);
                ((IStiTableCell)((Object)component)).setTableTag(this);
            }
        }
        boolean isGroupingPresent = false;
        for (int indexOfTable = this.parent.components.indexOf(this) - 1; indexOfTable >= 0; --indexOfTable) {
            StiComponent comp = (StiComponent)this.parent.components.get(indexOfTable);
            if (comp instanceof StiHeaderBand || comp instanceof StiChildBand || comp instanceof StiEmptyBand) continue;
            if (!(comp instanceof StiGroupHeaderBand)) break;
            isGroupingPresent = true;
            break;
        }
        if (this.headerRowsCount > 0) {
            for (int index1 = 0; index1 < this.headerRowsCount; ++index1) {
                headerHeight += ((IStiTableCell)this.components.get(index1 * this.columnCount)).GetRealHeight();
            }
            listCellHeader = new Hashtable<StiComponent, Integer>();
            joinCells = new Hashtable<StiComponent, StiComponent>();
            StiDynamicBand tableHeader = null;
            if (isGroupingPresent) {
                tableHeader = new StiGroupHeaderBand();
                ((StiGroupHeaderBand)tableHeader).getGroupHeaderBandInfoV2().IsTableGroupHeader = true;
                tableHeader.setName(this.getName() + "_GrHd");
                ((StiGroupHeaderBand)tableHeader).setPrintOnAllPages(this.headerPrintOnAllPages);
            } else {
                tableHeader = new StiHeaderBand();
                tableHeader.setName(this.getName() + "_Hd");
                ((StiHeaderBand)tableHeader).getHeaderBandInfoV2().IsTableHeader = true;
                ((StiHeaderBand)tableHeader).setPrintOnAllPages(this.headerPrintOnAllPages);
                ((StiHeaderBand)tableHeader).setPrintIfEmpty(this.headerPrintIfEmpty);
                ((StiHeaderBand)tableHeader).setPrintOnEvenOddPages(this.headerPrintOnEvenOddPages);
            }
            tableHeader.setHeight(headerHeight);
            tableHeader.setClientRectangle(new StiRectangle(rect.x, posY, rect.width, headerHeight));
            tableHeader.border = this.border;
            tableHeader.brush = this.brush;
            tableHeader.page = this.page;
            tableHeader.parent = this.page;
            tableHeader.canGrow = this.headerCanGrow;
            tableHeader.canShrink = this.headerCanShrink;
            tableHeader.setCanBreak(this.headerCanBreak);
            tableHeader.setPrintAtBottom(this.headerPrintAtBottom);
            tableHeader.setPrintOn(this.headerPrintOn);
            double yPosHeaderPanel = 0.0;
            for (int indexHeader = 0; indexHeader < this.headerRowsCount; ++indexHeader) {
                __height = ((IStiTableCell)this.components.get(lastElementHeader)).GetRealHeight();
                panel = new StiPanel();
                panel.setClientRectangle(new StiRectangle(rect.x, yPosHeaderPanel, rect.width, __height));
                panel.setName(tableHeader.getName() + "_HPnl" + new Integer(indexHeader).toString());
                panel.canGrow = true;
                panel.canShrink = true;
                panel.setDockStyle(StiDockStyle.Top);
                tableHeader.components.add(panel);
                yPosHeaderPanel += __height;
                lastElementHeader += this.columnCount;
                block23: for (indexCell = this.columnCount * indexHeader; indexCell < lastElementHeader; ++indexCell) {
                    tableCell = (StiComponent)this.components.get(indexCell);
                    join = false;
                    parentJoin = null;
                    if (((IStiTableCell)((Object)tableCell)).getParentJoin() != -1) {
                        int row = 0;
                        StiRefObject tempRef_row = new StiRefObject((Object)row);
                        parentJoin = this.GetParentJoin(((IStiTableCell)((Object)tableCell)).getParentJoin(), (StiRefObject<Integer>)tempRef_row);
                        row = (Integer)tempRef_row.argvalue;
                        if (listCellHeader.containsKey(parentJoin)) {
                            if (indexHeader == (Integer)listCellHeader.get(parentJoin)) continue;
                            emptyText = new StiText();
                            emptyText.page = tableCell.page;
                            emptyText.setConditions(tableCell.getConditions());
                            emptyText.setPaintRectangle(tableCell.getPaintRectangle());
                            emptyText.setClientRectangle(new StiRectangle(((IStiTableCell)((Object)tableCell)).GetRealLeft(), 0.0, ((IStiTableCell)((Object)tableCell)).GetRealWidth(), ((IStiTableCell)((Object)tableCell)).GetRealHeight()));
                            emptyText.setName(tableCell.getName() + "_Emp");
                            emptyText.setGrowToHeight(true);
                            emptyText.setBrush((StiBrush)new StiEmptyBrush());
                            emptyText.setDockStyle(((IStiTableCell)((Object)tableCell)).getCellDockStyle());
                            panel.components.add(emptyText);
                            list.add(emptyText);
                            if (tableCell != parentJoin) continue;
                            ((IStiTableCell)joinCells.get(parentJoin)).setParentJoinCell(emptyText);
                            continue;
                        }
                        listCellHeader.put(parentJoin, indexHeader);
                        tableCell = parentJoin;
                        join = true;
                    }
                    tableCell.setTop(0.0);
                    switch (((IStiTableCell)((Object)tableCell)).getCellType()) {
                        case Image: {
                            StiImage newCellImage = (StiImage)((StiTableCellImage)tableCell).clone(true);
                            newCellImage.setRestrictions((StiEnumSet<StiRestrictions>)newCellImage.getRestrictions().exclusiveOR((IStiEnum)StiRestrictions.AllowDelete));
                            newCellImage.setDockStyle(((StiTableCellImage)tableCell).getCellDockStyle());
                            this.SetInteraction(tableCell);
                            panel.components.add(newCellImage);
                            list.add(newCellImage);
                            if (!join) continue block23;
                            newCellImage.canGrow = true;
                            if (!this.IsEqualRows(tableCell, (StiComponent)this.components.get(indexCell))) {
                                newCellImage.setHeight(((IStiTableCell)((Object)tableCell)).GetRealHeight());
                            }
                            joinCells.put(parentJoin, newCellImage);
                            continue block23;
                        }
                        case Text: {
                            newCellText = (StiText)((StiTableCell)tableCell).clone(true);
                            newCellText.setRestrictions((StiEnumSet<StiRestrictions>)newCellText.getRestrictions().exclusiveOR((IStiEnum)StiRestrictions.AllowDelete));
                            newCellText.setDockStyle(((StiTableCell)tableCell).getCellDockStyle());
                            this.SetInteraction(tableCell);
                            panel.components.add(newCellText);
                            list.add(newCellText);
                            if (!join) continue block23;
                            newCellText.canGrow = true;
                            if (!this.IsEqualRows(tableCell, (StiComponent)this.components.get(indexCell))) {
                                newCellText.setHeight(((IStiTableCell)((Object)tableCell)).GetRealHeight());
                            }
                            joinCells.put(parentJoin, newCellText);
                            continue block23;
                        }
                        case CheckBox: {
                            newCheckBox = (StiCheckBox)((StiTableCellCheckBox)tableCell).clone(true);
                            newCheckBox.setRestrictions((StiEnumSet<StiRestrictions>)newCheckBox.getRestrictions().exclusiveOR((IStiEnum)StiRestrictions.AllowDelete));
                            newCheckBox.setDockStyle(((StiTableCellCheckBox)tableCell).getCellDockStyle());
                            this.SetInteraction(tableCell);
                            panel.components.add(newCheckBox);
                            list.add(newCheckBox);
                            if (!join) continue block23;
                            newCheckBox.canGrow = true;
                            if (!this.IsEqualRows(tableCell, (StiComponent)this.components.get(indexCell))) {
                                newCheckBox.setHeight(((IStiTableCell)((Object)tableCell)).GetRealHeight());
                            }
                            joinCells.put(parentJoin, newCheckBox);
                            continue block23;
                        }
                        case RichText: {
                            newRichText = (StiRichText)((StiTableCellRichText)tableCell).clone(true);
                            newRichText.setRestrictions((StiEnumSet<StiRestrictions>)newRichText.getRestrictions().exclusiveOR((IStiEnum)StiRestrictions.AllowDelete));
                            newRichText.setDockStyle(((StiTableCellRichText)tableCell).getCellDockStyle());
                            this.SetInteraction(tableCell);
                            panel.components.add(newRichText);
                            list.add(newRichText);
                            if (!join) continue block23;
                            newRichText.canGrow = true;
                            if (!this.IsEqualRows(tableCell, (StiComponent)this.components.get(indexCell))) {
                                newRichText.setHeight(((IStiTableCell)((Object)tableCell)).GetRealHeight());
                            }
                            joinCells.put(parentJoin, newRichText);
                        }
                    }
                }
            }
            parentContainer.components.add(index, tableHeader);
            list.add(tableHeader);
            ++index;
            posY += headerHeight + 1.0;
        } else if (isGroupingPresent && this.footerRowsCount > 0) {
            StiGroupHeaderBand tableHeaderEmpty = new StiGroupHeaderBand();
            tableHeaderEmpty.setHeight(0.0);
            tableHeaderEmpty.setClientRectangle(new StiRectangle(rect.x, posY, rect.width, 0.0));
            tableHeaderEmpty.setName(this.getName() + "_GrHdEmp");
            tableHeaderEmpty.page = this.page;
            tableHeaderEmpty.parent = this.page;
            tableHeaderEmpty.setPrintAtBottom(this.headerPrintAtBottom);
            parentContainer.components.add(index, tableHeaderEmpty);
            list.add(tableHeaderEmpty);
            ++index;
            posY += 1.0;
        }
        if (this.rowCount - this.headerRowsCount - this.footerRowsCount > 0) {
            this.IsConverted = true;
            tableData = (StiDataBand)this.clone(true, false);
            tableData.expressions = this.getExpressions() != null ? (StiAppExpressionCollection)this.getExpressions().clone() : null;
            tableData.setConditions(this.getConditions() != null ? (StiConditionsCollection)this.getConditions().clone() : null);
            tableData.setInteraction(this.getInteraction() != null ? (StiInteraction)this.getInteraction().clone() : null);
            if (tableData.getInteraction() != null) {
                tableData.getInteraction().ParentComponent = tableData;
            }
            tableData.setProperties((StiRepositoryItems)this.getProperties().clone());
            tableData.setBorder(this.getBorder() != null ? (StiBorder)this.getBorder().clone() : null);
            tableData.setBrush(this.getBrush() != null ? (StiBrush)this.getBrush().clone() : null);
            tableData.setSort(this.getSort() != null ? (ArrayList)this.getSort().clone() : null);
            tableData.setFilters(this.getFilters() != null ? (StiFiltersCollection)this.getFilters().clone() : null);
            tableData.setOddStyle(this.getOddStyle());
            tableData.setEvenStyle(this.getEvenStyle());
            tableData.setDataSourceName(this.getDataSourceName());
            tableData.setBusinessObjectGuid(this.getBusinessObjectGuid());
            tableData.setSelectedLine(this.getSelectedLine());
            tableData.setDataRelationName(this.getDataRelationName());
            tableData.setFilterMode(this.getFilterMode());
            tableData.setFilterEngine(this.getFilterEngine());
            tableData.setFilterOn(this.getFilterOn());
            this.IsConverted = false;
            tableData.components.Clear();
            this.SetFilter(tableData);
            for (int index1 = this.headerRowsCount; index1 < rCount - this.footerRowsCount; ++index1) {
                dataBandHeight += ((IStiTableCell)this.components.get(index1 * this.columnCount)).GetRealHeight();
            }
            tableData.parent = this.parent;
            tableData.page = this.page;
            tableData.setEnabled(true);
            tableData.setClientRectangle(new StiRectangle(rect.x, posY, rect.width, dataBandHeight));
            tableData.setName(this.getName() + "_DB");
            tableData.setMasterComponent(this.getMasterComponent());
            listCellHeader = new Hashtable();
            joinCells = new Hashtable();
            int elementDataBand = this.headerRowsCount * this.columnCount;
            double yPosDataPanel = 0.0;
            for (int indexDataBand = 0; indexDataBand < this.rowCount - this.headerRowsCount - this.footerRowsCount; ++indexDataBand) {
                __height = ((IStiTableCell)this.components.get(elementDataBand)).GetRealHeight();
                panel = new StiPanel();
                panel.setClientRectangle(new StiRectangle(rect.x, yPosDataPanel, rect.width, __height));
                panel.setName(tableData.getName() + "_DPnl" + new Integer(indexDataBand).toString());
                panel.canGrow = true;
                panel.setCanBreak(true);
                panel.canShrink = true;
                panel.setDockStyle(StiDockStyle.Top);
                tableData.components.add(panel);
                yPosDataPanel += __height;
                block26: for (indexCell = elementDataBand; indexCell < elementDataBand + this.columnCount; ++indexCell) {
                    tableCell = (StiComponent)this.components.get(indexCell);
                    join = false;
                    parentJoin = null;
                    if (((IStiTableCell)((Object)tableCell)).getParentJoin() != -1) {
                        int row = 0;
                        StiRefObject tempRef_row2 = new StiRefObject((Object)row);
                        parentJoin = this.GetParentJoin(((IStiTableCell)((Object)tableCell)).getParentJoin(), (StiRefObject<Integer>)tempRef_row2);
                        row = (Integer)tempRef_row2.argvalue;
                        if (listCellHeader.containsKey(parentJoin)) {
                            if (indexDataBand == (Integer)listCellHeader.get(parentJoin)) continue;
                            emptyText = new StiText();
                            emptyText.page = tableCell.page;
                            emptyText.conditions = tableCell.conditions;
                            emptyText.setPaintRectangle(tableCell.getPaintRectangle());
                            emptyText.setClientRectangle(new StiRectangle(((IStiTableCell)((Object)tableCell)).GetRealLeft(), 0.0, ((IStiTableCell)((Object)tableCell)).GetRealWidth(), ((IStiTableCell)((Object)tableCell)).GetRealHeight()));
                            emptyText.setName(tableCell.getName() + "_Emp");
                            emptyText.setGrowToHeight(true);
                            emptyText.setBrush((StiBrush)new StiEmptyBrush());
                            emptyText.setDockStyle(((IStiTableCell)((Object)tableCell)).getCellDockStyle());
                            panel.components.add(emptyText);
                            list.add(emptyText);
                            if (tableCell != parentJoin) continue;
                            ((IStiTableCell)joinCells.get(parentJoin)).setParentJoinCell(emptyText);
                            continue;
                        }
                        listCellHeader.put(parentJoin, indexDataBand);
                        tableCell = parentJoin;
                        join = true;
                    }
                    tableCell.top = 0.0;
                    switch (((IStiTableCell)((Object)tableCell)).getCellType()) {
                        case Image: {
                            StiImage newCellImage = (StiImage)((StiTableCellImage)tableCell).clone(true);
                            newCellImage.setRestrictions((StiEnumSet<StiRestrictions>)newCellImage.getRestrictions().exclusiveOR((IStiEnum)StiRestrictions.AllowDelete));
                            newCellImage.setDockStyle(((StiTableCellImage)tableCell).getCellDockStyle());
                            this.SetInteraction(tableCell);
                            panel.components.add(newCellImage);
                            list.add(newCellImage);
                            if (!join) continue block26;
                            newCellImage.canGrow = true;
                            if (!this.IsEqualRows(tableCell, (StiComponent)this.components.get(indexCell))) {
                                newCellImage.setHeight(((IStiTableCell)((Object)tableCell)).GetRealHeight());
                            }
                            joinCells.put(parentJoin, newCellImage);
                            continue block26;
                        }
                        case Text: {
                            newCellText = (StiText)((StiTableCell)tableCell).clone(true);
                            newCellText.setRestrictions((StiEnumSet<StiRestrictions>)newCellText.getRestrictions().exclusiveOR((IStiEnum)StiRestrictions.AllowDelete));
                            newCellText.setDockStyle(((StiTableCell)tableCell).getCellDockStyle());
                            this.SetInteraction(tableCell);
                            panel.components.add(newCellText);
                            list.add(newCellText);
                            if (!join) continue block26;
                            newCellText.setCanGrow(true);
                            if (!this.IsEqualRows(tableCell, (StiComponent)this.components.get(indexCell))) {
                                panel.setCanGrow(false);
                            }
                            joinCells.put(parentJoin, newCellText);
                            continue block26;
                        }
                        case CheckBox: {
                            newCheckBox = (StiCheckBox)((StiTableCellCheckBox)tableCell).clone(true);
                            newCheckBox.setRestrictions((StiEnumSet<StiRestrictions>)newCheckBox.getRestrictions().exclusiveOR((IStiEnum)StiRestrictions.AllowDelete));
                            newCheckBox.setDockStyle(((StiTableCellCheckBox)tableCell).getCellDockStyle());
                            this.SetInteraction(tableCell);
                            panel.components.add(newCheckBox);
                            list.add(newCheckBox);
                            if (!join) continue block26;
                            newCheckBox.canGrow = true;
                            if (!this.IsEqualRows(tableCell, (StiComponent)this.components.get(indexCell))) {
                                newCheckBox.setHeight(((IStiTableCell)((Object)tableCell)).GetRealHeight());
                            }
                            joinCells.put(parentJoin, newCheckBox);
                            continue block26;
                        }
                        case RichText: {
                            newRichText = (StiRichText)((StiTableCellRichText)tableCell).clone(true);
                            newRichText.setRestrictions((StiEnumSet<StiRestrictions>)newRichText.getRestrictions().exclusiveOR((IStiEnum)StiRestrictions.AllowDelete));
                            newRichText.setDockStyle(((StiTableCellRichText)tableCell).getCellDockStyle());
                            this.SetInteraction(tableCell);
                            panel.components.add(newRichText);
                            list.add(newRichText);
                            if (!join) continue block26;
                            newRichText.canGrow = true;
                            if (!this.IsEqualRows(tableCell, (StiComponent)this.components.get(indexCell))) {
                                newRichText.setHeight(((IStiTableCell)((Object)tableCell)).GetRealHeight());
                            }
                            joinCells.put(parentJoin, newRichText);
                        }
                    }
                }
                elementDataBand += this.columnCount;
            }
            parentContainer.components.add(index, tableData);
            list.add(tableData);
            posY += dataBandHeight + 0.8;
            ++index;
        }
        if (this.footerRowsCount > 0) {
            Hashtable<StiComponent, Integer> listCellFooter = new Hashtable<StiComponent, Integer>();
            joinCells = new Hashtable();
            int numberElementFooter = this.components.size() - this.footerRowsCount * this.columnCount;
            for (int index1 = rCount - this.footerRowsCount; index1 < rCount; ++index1) {
                footerHeight += ((IStiTableCell)this.components.get(index1 * this.columnCount)).GetRealHeight();
            }
            StiDynamicBand tableFooter = null;
            if (isGroupingPresent) {
                tableFooter = new StiGroupFooterBand();
                ((StiGroupFooterBand)tableFooter).getGroupFooterBandInfoV2().IsTableGroupFooter = true;
                tableFooter.setName(this.getName() + "_GrFt");
            } else {
                tableFooter = new StiFooterBand();
                tableFooter.setName(this.getName() + "_Ft");
                ((StiFooterBand)tableFooter).getFooterBandInfoV2().IsTableFooter = true;
                ((StiFooterBand)tableFooter).setPrintOnAllPages(this.footerPrintOnAllPages);
                ((StiFooterBand)tableFooter).setPrintIfEmpty(this.footerPrintIfEmpty);
                ((StiFooterBand)tableFooter).setPrintOnEvenOddPages(this.footerPrintOnEvenOddPages);
            }
            tableFooter.setClientRectangle(new StiRectangle(rect.x, posY, rect.width, footerHeight));
            tableFooter.setBorder(this.border);
            tableFooter.setBrush(this.getBrush());
            tableFooter.setInteraction(null);
            tableFooter.page = this.page;
            tableFooter.parent = this.page;
            tableFooter.setCanGrow(this.footerCanGrow);
            tableFooter.setCanShrink(this.footerCanShrink);
            tableFooter.setCanBreak(this.footerCanBreak);
            tableFooter.setPrintAtBottom(this.footerPrintAtBottom);
            tableFooter.setPrintOn(this.footerPrintOn);
            double yPosFooterPanel = 0.0;
            for (int indexFooter = 0; indexFooter < this.footerRowsCount; ++indexFooter) {
                double __height2 = ((IStiTableCell)this.components.get(numberElementFooter)).GetRealHeight();
                StiPanel panel2 = new StiPanel();
                panel2.setClientRectangle(new StiRectangle(rect.x, yPosFooterPanel, rect.width, __height2));
                panel2.setName(tableFooter.getName() + "_FPnl" + new Integer(indexFooter).toString());
                panel2.setCanGrow(true);
                panel2.setCanShrink(true);
                panel2.setDockStyle(StiDockStyle.Top);
                tableFooter.components.add(panel2);
                yPosFooterPanel += __height2;
                block29: for (int indexCell2 = numberElementFooter; indexCell2 < numberElementFooter + this.columnCount; ++indexCell2) {
                    StiComponent tableCell2 = (StiComponent)this.components.get(indexCell2);
                    boolean join2 = false;
                    StiComponent parentJoin2 = null;
                    if (((IStiTableCell)((Object)tableCell2)).getParentJoin() != -1) {
                        int row = 0;
                        StiRefObject tempRef_row3 = new StiRefObject((Object)row);
                        parentJoin2 = this.GetParentJoin(((IStiTableCell)((Object)tableCell2)).getParentJoin(), (StiRefObject<Integer>)tempRef_row3);
                        row = (Integer)tempRef_row3.argvalue;
                        if (listCellFooter.containsKey(parentJoin2)) {
                            if (indexFooter == (Integer)listCellFooter.get(parentJoin2)) continue;
                            StiText emptyText2 = new StiText();
                            emptyText2.page = tableCell2.page;
                            emptyText2.conditions = tableCell2.conditions;
                            emptyText2.setPaintRectangle(tableCell2.getPaintRectangle());
                            emptyText2.setClientRectangle(new StiRectangle(((IStiTableCell)((Object)tableCell2)).GetRealLeft(), 0.0, ((IStiTableCell)((Object)tableCell2)).GetRealWidth(), ((IStiTableCell)((Object)tableCell2)).GetRealHeight()));
                            emptyText2.setName(tableCell2.getName() + "_Emp");
                            emptyText2.setGrowToHeight(true);
                            emptyText2.setBrush((StiBrush)new StiEmptyBrush());
                            emptyText2.setDockStyle(((IStiTableCell)((Object)tableCell2)).getCellDockStyle());
                            panel2.components.add(emptyText2);
                            list.add(emptyText2);
                            if (tableCell2 != parentJoin2) continue;
                            ((IStiTableCell)joinCells.get(parentJoin2)).setParentJoinCell(emptyText2);
                            continue;
                        }
                        listCellFooter.put(parentJoin2, indexFooter);
                        tableCell2 = parentJoin2;
                        join2 = true;
                    }
                    tableCell2.top = 0.0;
                    switch (((IStiTableCell)((Object)tableCell2)).getCellType()) {
                        case Image: {
                            StiImage newCellImage = (StiImage)((StiTableCellImage)tableCell2).clone(true);
                            newCellImage.setRestrictions((StiEnumSet<StiRestrictions>)newCellImage.getRestrictions().exclusiveOR((IStiEnum)StiRestrictions.AllowDelete));
                            newCellImage.setDockStyle(((StiTableCellImage)tableCell2).getCellDockStyle());
                            this.SetInteraction(tableCell2);
                            panel2.components.add(newCellImage);
                            list.add(newCellImage);
                            if (!join2) continue block29;
                            newCellImage.canGrow = true;
                            if (!this.IsEqualRows(tableCell2, (StiComponent)this.components.get(indexCell2))) {
                                newCellImage.setHeight(((IStiTableCell)((Object)tableCell2)).GetRealHeight());
                            }
                            joinCells.put(parentJoin2, newCellImage);
                            continue block29;
                        }
                        case Text: {
                            StiText newCellText2 = (StiText)((StiTableCell)tableCell2).clone(true);
                            newCellText2.setRestrictions((StiEnumSet<StiRestrictions>)newCellText2.getRestrictions().exclusiveOR((IStiEnum)StiRestrictions.AllowDelete));
                            newCellText2.setDockStyle(((StiTableCell)tableCell2).getCellDockStyle());
                            this.SetInteraction(tableCell2);
                            panel2.components.add(newCellText2);
                            list.add(newCellText2);
                            if (!join2) continue block29;
                            newCellText2.canGrow = true;
                            if (!this.IsEqualRows(tableCell2, (StiComponent)this.components.get(indexCell2))) {
                                newCellText2.setHeight(((IStiTableCell)((Object)tableCell2)).GetRealHeight());
                            }
                            joinCells.put(parentJoin2, newCellText2);
                            continue block29;
                        }
                        case CheckBox: {
                            StiCheckBox newCheckBox2 = (StiCheckBox)((StiTableCellCheckBox)tableCell2).clone(true);
                            newCheckBox2.setRestrictions((StiEnumSet<StiRestrictions>)newCheckBox2.getRestrictions().exclusiveOR((IStiEnum)StiRestrictions.AllowDelete));
                            newCheckBox2.setDockStyle(((StiTableCellCheckBox)tableCell2).getCellDockStyle());
                            this.SetInteraction(tableCell2);
                            panel2.components.add(newCheckBox2);
                            list.add(newCheckBox2);
                            if (!join2) continue block29;
                            newCheckBox2.canGrow = true;
                            if (!this.IsEqualRows(tableCell2, (StiComponent)this.components.get(indexCell2))) {
                                newCheckBox2.setHeight(((IStiTableCell)((Object)tableCell2)).GetRealHeight());
                            }
                            joinCells.put(parentJoin2, newCheckBox2);
                            continue block29;
                        }
                        case RichText: {
                            StiRichText newRichText2 = (StiRichText)((StiTableCellRichText)tableCell2).clone(true);
                            newRichText2.setRestrictions((StiEnumSet<StiRestrictions>)newRichText2.getRestrictions().exclusiveOR((IStiEnum)StiRestrictions.AllowDelete));
                            newRichText2.setDockStyle(((StiTableCellRichText)tableCell2).getCellDockStyle());
                            this.SetInteraction(tableCell2);
                            panel2.components.add(newRichText2);
                            list.add(newRichText2);
                            if (!join2) continue block29;
                            newRichText2.canGrow = true;
                            if (!this.IsEqualRows(tableCell2, (StiComponent)this.components.get(indexCell2))) {
                                newRichText2.setHeight(((IStiTableCell)((Object)tableCell2)).GetRealHeight());
                            }
                            joinCells.put(parentJoin2, newRichText2);
                        }
                    }
                }
                numberElementFooter += this.columnCount;
            }
            parentContainer.components.add(index, tableFooter);
            ++index;
            list.add(tableFooter);
        } else if (isGroupingPresent && this.headerRowsCount > 0) {
            StiGroupFooterBand tableFooterEmpty = new StiGroupFooterBand();
            tableFooterEmpty.setHeight(0.0);
            tableFooterEmpty.setClientRectangle(new StiRectangle(rect.x, posY, rect.width, 0.0));
            tableFooterEmpty.setName(this.getName() + "_GrFtEmp");
            tableFooterEmpty.setPage(this.page);
            tableFooterEmpty.setParent(this.page);
            tableFooterEmpty.setPrintAtBottom(this.footerPrintAtBottom);
            parentContainer.components.add(index, tableFooterEmpty);
            list.add(tableFooterEmpty);
            ++index;
        }
        return tableData;
    }

    private void SetFilter(StiDataBand comp) {
        StiDataBand dataSource;
        StiDataBand enumerator = comp instanceof IStiEnumerator ? comp : null;
        StiDataBand filter = comp instanceof IStiFilter ? comp : null;
        StiDataBand stiDataBand = dataSource = comp instanceof IStiDataSource ? comp : null;
        if (!dataSource.isDataSourceEmpty() && filter.getFilterMethodHandler() == null && filter.getFilterOn()) {
            String string = StiNameValidator.CorrectName(this.getName());
        }
    }

    private void SetInteraction(StiComponent cell) {
        int indexOfDot;
        if (cell.getInteraction() == null) {
            return;
        }
        StiInteraction interaction = cell.getInteraction();
        if (!interaction.getSortingEnabled() || interaction.getSortingColumn() == null || interaction.getSortingColumn().length() <= 0 || (indexOfDot = interaction.getSortingColumn().indexOf(".")) != -1) {
            // empty if block
        }
    }

    private StiComponent GetParentJoin(int id, StiRefObject<Integer> tempRef_row) {
        int index = 0;
        for (StiComponent component : this.getComponents()) {
            IStiTableCell cell = (IStiTableCell)((Object)component);
            if (cell.getID() == id) {
                tempRef_row.argvalue = index / this.columnCount;
                return (StiComponent)((Object)(cell instanceof StiComponent ? cell : null));
            }
            ++index;
        }
        return null;
    }

    private boolean IsEqualRows(StiComponent comp1, StiComponent comp2) {
        int index2;
        int index1 = this.getComponents().indexOf(comp1) / this.columnCount;
        return index1 == (index2 = this.getComponents().indexOf(comp2) / this.columnCount);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("Columns");
        jObject.RemoveProperty("ColumnWidth");
        jObject.RemoveProperty("ColumnGaps");
        jObject.RemoveProperty("MinRowsInColumn");
        jObject.AddPropertyBool("DockableTable", this.getDockableTable(), true);
        jObject.AddPropertyEnum("AutoWidth", (Enum)this.getAutoWidth(), (Enum)StiTableAutoWidth.None);
        jObject.AddPropertyEnum("AutoWidthType", (Enum)this.getAutoWidthType(), (Enum)StiTableAutoWidthType.None);
        jObject.AddPropertyInt("RowCount", this.getRowCount(), 5);
        jObject.AddPropertyInt("ColumnCount", this.getColumnCount(), 5);
        jObject.AddPropertyInt("FooterRowsCount", this.getFooterRowsCount());
        jObject.AddPropertyInt("HeaderRowsCount", this.getHeaderRowsCount());
        jObject.AddPropertyEnum("HeaderPrintOn", (Enum)this.getHeaderPrintOn(), (Enum)StiPrintOnType.AllPages);
        jObject.AddPropertyBool("HeaderCanGrow", this.getHeaderCanGrow(), true);
        jObject.AddPropertyBool("HeaderCanShrink", this.getHeaderCanShrink());
        jObject.AddPropertyBool("HeaderCanBreak", this.getHeaderCanBreak());
        jObject.AddPropertyBool("HeaderPrintAtBottom", this.getHeaderPrintAtBottom());
        jObject.AddPropertyBool("HeaderPrintIfEmpty", this.getHeaderPrintIfEmpty(), true);
        jObject.AddPropertyBool("HeaderPrintOnAllPages", this.getHeaderPrintOnAllPages(), true);
        jObject.AddPropertyEnum("HeaderPrintOnEvenOddPages", (Enum)this.getHeaderPrintOnEvenOddPages(), (Enum)StiPrintOnEvenOddPagesType.Ignore);
        jObject.AddPropertyEnum("FooterPrintOn", (Enum)this.getFooterPrintOn(), (Enum)StiPrintOnType.AllPages);
        jObject.AddPropertyBool("FooterCanGrow", this.getFooterCanGrow(), true);
        jObject.AddPropertyBool("FooterCanShrink", this.getFooterCanShrink());
        jObject.AddPropertyBool("FooterCanBreak", this.getFooterCanBreak());
        jObject.AddPropertyBool("FooterPrintAtBottom", this.getFooterPrintAtBottom());
        jObject.AddPropertyBool("FooterPrintIfEmpty", this.getFooterPrintIfEmpty(), true);
        jObject.AddPropertyBool("FooterPrintOnAllPages", this.getFooterPrintOnAllPages());
        jObject.AddPropertyEnum("FooterPrintOnEvenOddPages", (Enum)this.getFooterPrintOnEvenOddPages(), (Enum)StiPrintOnEvenOddPagesType.Ignore);
        jObject.AddPropertyInt("NumberID", this.getNumberID());
        jObject.AddPropertyEnum("TableStyle", (Enum)this.getTableStyle(), (Enum)StiTableStyle.StyleNone);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        if (this.components.size() > 0) {
            Collections.sort(this.components, new Comparator<StiComponent>(){

                @Override
                public int compare(StiComponent a, StiComponent b) {
                    try {
                        Integer name1 = Integer.parseInt(a.getName().substring(a.getName().indexOf("_Cell") + 5));
                        Integer name2 = Integer.parseInt(b.getName().substring(b.getName().indexOf("_Cell") + 5));
                        return name1.compareTo(name2);
                    }
                    catch (Exception e) {
                        return 0;
                    }
                }
            });
        }
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("DockableTable")) {
                this.dockableTable = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("AutoWidth")) {
                this.autoWidth = StiTableAutoWidth.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("AutoWidthType")) {
                this.autoWidthType = StiTableAutoWidthType.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("RowCount")) {
                this.rowCount = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("ColumnCount")) {
                this.columnCount = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("FooterRowsCount")) {
                this.footerRowsCount = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("HeaderRowsCount")) {
                this.headerRowsCount = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("HeaderPrintOn")) {
                this.headerPrintOn = StiPrintOnType.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("HeaderCanGrow")) {
                this.headerCanGrow = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("HeaderCanShrink")) {
                this.headerCanShrink = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("HeaderCanBreak")) {
                this.headerCanBreak = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("HeaderPrintAtBottom")) {
                this.headerPrintAtBottom = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("HeaderPrintIfEmpty")) {
                this.headerPrintIfEmpty = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("HeaderPrintOnAllPages")) {
                this.headerPrintOnAllPages = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("HeaderPrintOnEvenOddPages")) {
                this.headerPrintOnEvenOddPages = StiPrintOnEvenOddPagesType.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("FooterPrintOn")) {
                this.footerPrintOn = StiPrintOnType.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("FooterCanGrow")) {
                this.footerCanGrow = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("FooterCanShrink")) {
                this.footerCanShrink = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("FooterCanBreak")) {
                this.footerCanBreak = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("FooterPrintAtBottom")) {
                this.footerPrintAtBottom = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("FooterPrintIfEmpty")) {
                this.footerPrintIfEmpty = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("FooterPrintOnAllPages")) {
                this.footerPrintOnAllPages = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("FooterPrintOnEvenOddPages")) {
                this.footerPrintOnEvenOddPages = StiPrintOnEvenOddPagesType.valueOf((String)property.Value);
                continue;
            }
            if (!property.Name.equals("NumberID")) continue;
            this.numberID = (Integer)property.Value;
        }
    }

    private static class StiTableStyles {
        public StiColor HeaderStiColor;
        public StiColor FooterStiColor;
        public StiColor DataStiColor;
        public StiColor DataTextStiColor;
        public StiColor HeaderFooterTextStiColor;
        public StiColor GridStiColor;

        public StiTableStyles(StiColor gridStiColor, StiColor dataTextStiColor) {
            this.GridStiColor = gridStiColor;
            this.DataTextStiColor = dataTextStiColor;
        }

        public StiTableStyles(StiColor dataStiColor, StiColor hfStiColor, StiColor dataTextStiColor, StiColor headerFooterTextStiColor, boolean header) {
            this.DataStiColor = dataStiColor;
            this.DataTextStiColor = dataTextStiColor;
            this.HeaderFooterTextStiColor = headerFooterTextStiColor;
            if (header) {
                this.HeaderStiColor = hfStiColor;
            } else {
                this.FooterStiColor = hfStiColor;
            }
        }

        public StiTableStyles(StiColor dataStiColor, StiColor headerStiColor, StiColor footerStiColor, StiColor dataTextStiColor, StiColor headerFooterTextStiColor) {
            this.DataStiColor = dataStiColor;
            this.DataTextStiColor = dataTextStiColor;
            this.HeaderFooterTextStiColor = headerFooterTextStiColor;
            this.HeaderStiColor = headerStiColor;
            this.FooterStiColor = footerStiColor;
        }

        public static StiTableStyles GetStyle(StiTableStyle style) {
            switch (style) {
                case StyleNone: {
                    return new StiTableStyles(StiColor.fromArgb((int)105, (int)105, (int)105), StiColor.Black);
                }
                case Style11: {
                    return new StiTableStyles(StiColor.fromArgb((int)0, (int)0, (int)0), StiColor.Black);
                }
                case Style12: {
                    return new StiTableStyles(StiColor.fromArgb((int)79, (int)129, (int)189), StiColor.Black);
                }
                case Style13: {
                    return new StiTableStyles(StiColor.fromArgb((int)192, (int)80, (int)77), StiColor.Black);
                }
                case Style14: {
                    return new StiTableStyles(StiColor.fromArgb((int)155, (int)187, (int)89), StiColor.Black);
                }
                case Style15: {
                    return new StiTableStyles(StiColor.fromArgb((int)128, (int)100, (int)162), StiColor.Black);
                }
                case Style16: {
                    return new StiTableStyles(StiColor.fromArgb((int)75, (int)172, (int)198), StiColor.Black);
                }
                case Style17: {
                    return new StiTableStyles(StiColor.fromArgb((int)247, (int)150, (int)70), StiColor.Black);
                }
                case Style18: {
                    return new StiTableStyles(StiColor.fromArgb((int)221, (int)160, (int)221), StiColor.Black);
                }
                case Style19: {
                    return new StiTableStyles(StiColor.fromArgb((int)32, (int)178, (int)170), StiColor.Black);
                }
                case Style31: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)0, (int)0, (int)0), StiColor.Black, StiColor.White, true);
                }
                case Style32: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)79, (int)129, (int)189), StiColor.Black, StiColor.White, true);
                }
                case Style33: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)192, (int)80, (int)77), StiColor.Black, StiColor.White, true);
                }
                case Style34: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)155, (int)187, (int)89), StiColor.Black, StiColor.White, true);
                }
                case Style35: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)128, (int)100, (int)162), StiColor.Black, StiColor.White, true);
                }
                case Style36: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)75, (int)172, (int)198), StiColor.Black, StiColor.White, true);
                }
                case Style37: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)247, (int)150, (int)70), StiColor.Black, StiColor.White, true);
                }
                case Style38: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)221, (int)160, (int)221), StiColor.Black, StiColor.White, true);
                }
                case Style39: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)32, (int)178, (int)170), StiColor.Black, StiColor.White, true);
                }
                case Style41: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)0, (int)0, (int)0), StiColor.Black, StiColor.White, false);
                }
                case Style42: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)79, (int)129, (int)189), StiColor.Black, StiColor.White, false);
                }
                case Style43: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)192, (int)80, (int)77), StiColor.Black, StiColor.White, false);
                }
                case Style44: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)155, (int)187, (int)89), StiColor.Black, StiColor.White, false);
                }
                case Style45: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)128, (int)100, (int)162), StiColor.Black, StiColor.White, false);
                }
                case Style46: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)75, (int)172, (int)198), StiColor.Black, StiColor.White, false);
                }
                case Style47: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)247, (int)150, (int)70), StiColor.Black, StiColor.White, false);
                }
                case Style48: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)221, (int)160, (int)221), StiColor.Black, StiColor.White, false);
                }
                case Style49: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)32, (int)178, (int)170), StiColor.Black, StiColor.White, false);
                }
                case Style51: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)0, (int)0, (int)0), StiColor.fromArgb((int)0, (int)0, (int)0), StiColor.Black, StiColor.White);
                }
                case Style52: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)79, (int)129, (int)189), StiColor.fromArgb((int)79, (int)129, (int)189), StiColor.Black, StiColor.White);
                }
                case Style53: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)192, (int)80, (int)77), StiColor.fromArgb((int)192, (int)80, (int)77), StiColor.Black, StiColor.White);
                }
                case Style54: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)155, (int)187, (int)89), StiColor.fromArgb((int)155, (int)187, (int)89), StiColor.Black, StiColor.White);
                }
                case Style55: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)128, (int)100, (int)162), StiColor.fromArgb((int)128, (int)100, (int)162), StiColor.Black, StiColor.White);
                }
                case Style56: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)75, (int)172, (int)198), StiColor.fromArgb((int)75, (int)172, (int)198), StiColor.Black, StiColor.White);
                }
                case Style57: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)247, (int)150, (int)70), StiColor.fromArgb((int)247, (int)150, (int)70), StiColor.Black, StiColor.White);
                }
                case Style58: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)221, (int)160, (int)221), StiColor.fromArgb((int)221, (int)160, (int)221), StiColor.Black, StiColor.White);
                }
                case Style59: {
                    return new StiTableStyles(StiColor.White, StiColor.fromArgb((int)32, (int)178, (int)170), StiColor.fromArgb((int)32, (int)178, (int)170), StiColor.Black, StiColor.White);
                }
            }
            return null;
        }
    }
}

