/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.simplecomponents;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiCap;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiHideBorderFromDesigner;
import com.stimulsoft.report.components.simplecomponents.StiCrossLinePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiEndPointPrimitive;
import com.stimulsoft.report.components.simplecomponents.StiStartPointPrimitive;
import com.stimulsoft.report.units.StiUnit;

public class StiVerticalLinePrimitive
extends StiCrossLinePrimitive
implements IStiHideBorderFromDesigner,
IStiBorder {
    private StiBorder border;
    private StiCap startCap = new StiCap();
    private StiCap endCap = new StiCap();

    public StiVerticalLinePrimitive() {
        this(StiRectangle.empty());
    }

    public StiVerticalLinePrimitive(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(true);
    }

    @Override
    @StiSerializable(need=false)
    public StiBorder getBorder() {
        if (this.border == null) {
            this.border = new StiBorder(StiBorderSides.Left, this.getColor(), this.getSize(), this.getStyle(), false, 0.0, null);
        }
        return this.border;
    }

    @Override
    public void setBorder(StiBorder value) {
    }

    @Override
    public void convert(StiUnit oldUnit, StiUnit newUnit) {
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.VerticalLinePrimitive.getValue();
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Components", (String)"StiVerticalLinePrimitive");
    }

    @StiSerializable
    public final StiCap getStartCap() {
        return this.startCap;
    }

    public final void setStartCap(StiCap value) {
        this.startCap = value;
    }

    @StiSerializable
    public final StiCap getEndCap() {
        return this.endCap;
    }

    public final void setEndCap(StiCap value) {
        this.endCap = value;
    }

    @Override
    public double getWidth() {
        if (this.getPage() != null) {
            return this.getPage().getUnit().ConvertFromHInches(1.0);
        }
        return 1.0;
    }

    @Override
    public void setWidth(double value) {
        if (this.getIsDesigning()) {
            super.setWidth(value);
            StiStartPointPrimitive startPoint = this.getStartPoint();
            StiEndPointPrimitive endPoint = this.getEndPoint();
            if (startPoint != null && endPoint != null) {
                StiPoint startPos = new StiPoint(startPoint.getLeft(), startPoint.getTop());
                startPos = startPoint.ComponentToPage(startPos);
                StiPoint endPos = new StiPoint(startPos.x, startPos.y);
                endPos = endPoint.PageToComponent(endPos);
                endPoint.setLeft(endPos.x);
            }
        }
    }

    @Override
    public Object clone(boolean cloneProperties) {
        StiVerticalLinePrimitive cloneLine = (StiVerticalLinePrimitive)super.clone(cloneProperties);
        cloneLine.startCap = this.startCap != null ? (StiCap)this.startCap.clone() : null;
        cloneLine.endCap = this.endCap != null ? (StiCap)this.endCap.clone() : null;
        return cloneLine;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyStringNullOfEmpty("StartCap", StiJsonReportObjectHelper.Serialize.jCap((StiCap)this.getStartCap()));
        jObject.AddPropertyStringNullOfEmpty("EndCap", StiJsonReportObjectHelper.Serialize.jCap((StiCap)this.getEndCap()));
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("StartCap")) {
                this.startCap = StiJsonReportObjectHelper.Deserialize.JCap((String)((String)property.Value));
                continue;
            }
            if (!property.Name.equals("EndCap")) continue;
            this.endCap = StiJsonReportObjectHelper.Deserialize.JCap((String)((String)property.Value));
        }
    }
}

