/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.shapeTypes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.report.components.shapeTypes.StiShapeDirection;
import com.stimulsoft.report.components.shapeTypes.StiShapeTypeService;

public class StiArrowShapeType
extends StiShapeTypeService {
    private StiShapeDirection direction = StiShapeDirection.Up;
    private float arrowWidth = 0.3f;
    private float arrowHeight = 0.4f;

    public String getServiceName() {
        return StiLocalization.Get((String)"Shapes", (String)"Arrow");
    }

    @StiSerializable
    public StiShapeDirection getDirection() {
        return this.direction;
    }

    public void setDirection(StiShapeDirection value) {
        this.direction = value;
    }

    @StiDefaulValue(value="0.3")
    @StiSerializable
    public float getArrowWidth() {
        return this.arrowWidth;
    }

    public void setArrowWidth(float value) {
        if (value >= 0.0f && value <= 0.5f) {
            this.arrowWidth = value;
        }
    }

    @StiDefaulValue(value="0.4")
    @StiSerializable
    public float getArrowHeight() {
        return this.arrowHeight;
    }

    public void setArrowHeight(float value) {
        if (value >= 0.0f && value <= 1.0f) {
            this.arrowHeight = value;
        }
    }

    public StiArrowShapeType() {
        this(StiShapeDirection.Up, 0.3f, 0.4f);
    }

    public StiArrowShapeType(StiShapeDirection direction, float arrowWidth, float arrowHeight) {
        this.direction = direction;
        this.arrowWidth = arrowWidth;
        this.arrowHeight = arrowHeight;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyEnum("Direction", (Enum)this.getDirection(), (Enum)StiShapeDirection.Up);
        jObject.AddPropertyFloat("ArrowWidth", (double)this.getArrowWidth(), (double)0.3f);
        jObject.AddPropertyFloat("ArrowHeight", (double)this.getArrowHeight(), (double)0.4f);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Direction")) {
                this.direction = StiShapeDirection.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("ArrowWidth")) {
                this.arrowWidth = property.floatValue().floatValue();
                continue;
            }
            if (!property.Name.equals("ArrowHeight")) continue;
            this.arrowHeight = property.floatValue().floatValue();
        }
    }
}

