/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components.bands;

import com.stimulsoft.base.EventArgs;
import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiEventHandler;
import com.stimulsoft.base.system.StiEventHandlerListener;
import com.stimulsoft.base.system.StiEventObject;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiBlocklyHelper;
import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiScriptHelper;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiFiltersCollection;
import com.stimulsoft.report.components.bands.StiDataBandInfoV1;
import com.stimulsoft.report.components.bands.StiDataBandInfoV2;
import com.stimulsoft.report.components.bands.StiDynamicBand;
import com.stimulsoft.report.components.bands.StiGroupHeaderBand;
import com.stimulsoft.report.components.enums.StiColumnDirection;
import com.stimulsoft.report.components.enums.StiComponentPriority;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.enums.StiComponentType;
import com.stimulsoft.report.components.enums.StiFilterEngine;
import com.stimulsoft.report.components.enums.StiFilterMode;
import com.stimulsoft.report.components.interfaces.IStiBusinessObject;
import com.stimulsoft.report.components.interfaces.IStiDataRelation;
import com.stimulsoft.report.components.interfaces.IStiDataSource;
import com.stimulsoft.report.components.interfaces.IStiFilter;
import com.stimulsoft.report.components.interfaces.IStiKeepDetailsTogether;
import com.stimulsoft.report.components.interfaces.IStiKeepFooterTogether;
import com.stimulsoft.report.components.interfaces.IStiKeepGroupTogether;
import com.stimulsoft.report.components.interfaces.IStiKeepHeaderTogether;
import com.stimulsoft.report.components.interfaces.IStiMasterComponent;
import com.stimulsoft.report.components.interfaces.IStiOddEvenStyles;
import com.stimulsoft.report.components.interfaces.IStiPrintIfDetailEmpty;
import com.stimulsoft.report.components.interfaces.IStiPrintOnAllPages;
import com.stimulsoft.report.components.interfaces.IStiRenderMaster;
import com.stimulsoft.report.components.interfaces.IStiResetPageNumber;
import com.stimulsoft.report.components.interfaces.IStiSort;
import com.stimulsoft.report.components.interfaces.IStiStartNewPage;
import com.stimulsoft.report.dictionary.StiDataRelation;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObjectHelper;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.engine.StiEngineVersion;
import com.stimulsoft.report.engine.engineV1.builders.StiDataBandV1Builder;
import com.stimulsoft.report.engine.engineV2.StiPageLineHelper;
import com.stimulsoft.report.engine.engineV2.builders.StiDataBandV2Builder;
import com.stimulsoft.report.engine.engineV2.builders.StiV2Builder;
import com.stimulsoft.report.enums.StiEventFlags;
import com.stimulsoft.report.enums.StiKeepDetails;
import com.stimulsoft.report.events.StiBeginRenderEvent;
import com.stimulsoft.report.events.StiEndRenderEvent;
import com.stimulsoft.report.events.StiEvent;
import com.stimulsoft.report.events.StiEventsCollection;
import com.stimulsoft.report.events.StiFilterEventHandler;
import com.stimulsoft.report.events.StiGetCollapsedEvent;
import com.stimulsoft.report.events.StiRenderingEvent;
import com.stimulsoft.report.events.StiValueEventArgs;
import com.stimulsoft.report.expressions.StiCollapsedExpression;
import com.stimulsoft.report.units.StiUnit;
import java.util.ArrayList;

public class StiDataBand
extends StiDynamicBand
implements IStiDataSource,
IStiMasterComponent,
IStiDataRelation,
IStiOddEvenStyles,
IStiSort,
IStiFilter,
IStiStartNewPage,
IStiPrintOnAllPages,
IStiPrintIfDetailEmpty,
IStiKeepDetailsTogether,
IStiKeepFooterTogether,
IStiKeepGroupTogether,
IStiKeepHeaderTogether,
IStiResetPageNumber,
IStiRenderMaster,
IStiBusinessObject {
    private static final Object EventBeginRender = new Object();
    private static final Object EventEndRender = new Object();
    private static final Object EventGetCollapsed = new Object();
    private static final Object EventRendering = new Object();
    public static Object PropertyEvenStyle = new Object();
    public static Object PropertyOddStyle = new Object();
    private String businessObjectGuid = "";
    private boolean calcInvisible;
    private StiColumnDirection columnDirection = StiColumnDirection.AcrossThenDown;
    private double columnGaps;
    private int columns;
    private double columnWidth;
    private int countData;
    private StiDataBandInfoV1 dataBandInfoV1;
    private StiDataBandInfoV2 dataBandInfoV2;
    private String dataRelationName = "";
    private String dataSourceName = "";
    private StiFilterEngine filterEngine = StiFilterEngine.ReportEngine;
    private StiFilterEventHandler filterMethodHandler;
    private StiFilterMode filterMode = StiFilterMode.And;
    private boolean filterOn = true;
    private StiFiltersCollection filters = new StiFiltersCollection();
    public boolean isBofValue;
    public boolean isEofValue;
    private StiKeepDetails keepDetails = StiKeepDetails.None;
    private boolean keepFooterTogether = true;
    private boolean keepGroupTogether;
    private boolean keepHeaderTogether = true;
    private int line = 1;
    public int lineThrough = 1;
    private StiComponent masterComponent;
    private int minRowsInColumn;
    private int positionValue;
    private boolean printIfDetailEmpty;
    private boolean printOnAllPages;
    private boolean resetDataSource;
    private boolean rightToLeft;
    private ArrayList<String> sort = new ArrayList();
    private boolean startNewPage;
    private int selectedLine = -1;
    public String jsonMasterComponentTemp;
    public StiEventHandler handlerRendering = StiEventHandler.empty();
    private String limitRows = "";
    private int eventFlags = 0;

    public StiDataBand() {
        this(StiRectangle.empty());
    }

    public StiDataBand(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(true);
        this.printIfDetailEmpty = StiOptions.Engine.getPrintIfDetailEmptyDefaultValue();
    }

    @StiSerializable
    public String getLimitRows() {
        return this.limitRows;
    }

    public void setLimitRows(String limitRows) {
        this.limitRows = limitRows;
    }

    @Override
    public void convert(StiUnit oldUnit, StiUnit newUnit) {
        super.convert(oldUnit, newUnit);
        this.setColumnGaps(newUnit.ConvertFromHInches(oldUnit.ConvertToHInches(this.getColumnGaps())));
        this.setColumnWidth(newUnit.ConvertFromHInches(oldUnit.ConvertToHInches(this.getColumnWidth())));
    }

    @Override
    public boolean doBookmark() {
        if (this.getReport() != null && this.getReport().getEngineVersion() == StiEngineVersion.EngineV2) {
            return super.doBookmark();
        }
        return false;
    }

    @Override
    public void doPointer() {
        if (this.getReport() != null && this.getReport().getEngineVersion() == StiEngineVersion.EngineV2) {
            super.doPointer();
        }
    }

    @Override
    public void First() {
        if (!this.getIsBusinessObjectEmpty()) {
            this.getBusinessObject().first();
        } else if (!this.isDataSourceEmpty()) {
            this.getDataSource().First();
        } else {
            this.isEofValue = false;
            this.isBofValue = true;
            this.setPosition(0);
        }
        if (this.getReport() != null && this.getReport().getEngineVersion() == StiEngineVersion.EngineV1) {
            StiDataBandV1Builder.setDetails(this);
        } else {
            StiDataBandV2Builder.SetDetails(this);
        }
    }

    @StiSerializable
    public final StiBeginRenderEvent getBeginRenderEvent() {
        return new StiBeginRenderEvent(this);
    }

    @Override
    public StiBusinessObject getBusinessObject() {
        if (this.getPage() == null || this.getReport() == null || this.getBusinessObjectGuid() == null || this.getBusinessObjectGuid().length() == 0) {
            return null;
        }
        return StiBusinessObjectHelper.getBusinessObjectFromGuid(this.getReport(), this.getBusinessObjectGuid());
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="")
    public final String getBusinessObjectGuid() {
        return this.businessObjectGuid;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getCalcInvisible() {
        return this.calcInvisible;
    }

    @StiSerializable
    public StiCollapsedExpression getCollapsed() {
        return new StiCollapsedExpression(this, "Collapsed");
    }

    @StiDefaulValue(value="AcrossThenDown")
    @StiSerializable
    public StiColumnDirection getColumnDirection() {
        return this.columnDirection;
    }

    @StiDefaulValue(value="0.0")
    @StiSerializable
    public double getColumnGaps() {
        return this.columnGaps;
    }

    @StiDefaulValue(value="0")
    @StiSerializable
    public int getColumns() {
        return this.columns;
    }

    @StiDefaulValue(value="0.0")
    @StiSerializable
    public double getColumnWidth() {
        return this.columnWidth;
    }

    public final double GetColumnWidth() {
        double bandColumnWidth = this.getColumnWidth();
        if (bandColumnWidth == 0.0) {
            if (this.getColumns() == 0) {
                return this.getWidth();
            }
            bandColumnWidth = this.getWidth() / (double)this.getColumns() - this.getColumnGaps();
        }
        return bandColumnWidth;
    }

    @Override
    public StiComponentType getComponentType() {
        if (this.masterComponent == null) {
            return StiComponentType.Master;
        }
        if (this.masterComponent != null) {
            if (this.getPage().getSkip() && this.masterComponent.getPage() != this.getPage()) {
                return StiComponentType.Master;
            }
            if (this.getParent() != this.masterComponent.getParent()) {
                return StiComponentType.Master;
            }
        }
        return StiComponentType.Detail;
    }

    @Override
    public int getCount() {
        if (!this.getIsBusinessObjectEmpty()) {
            return this.getBusinessObject().getSize();
        }
        if (!this.isDataSourceEmpty()) {
            return this.getDataSource().getCount();
        }
        return this.countData;
    }

    @StiDefaulValue(value="0")
    @StiSerializable
    public int getCountData() {
        return this.countData;
    }

    public final StiDataBandInfoV1 getDataBandInfoV1() {
        if (this.dataBandInfoV1 == null) {
            this.dataBandInfoV1 = new StiDataBandInfoV1();
        }
        return this.dataBandInfoV1;
    }

    public final StiDataBandInfoV2 getDataBandInfoV2() {
        if (this.dataBandInfoV2 == null) {
            this.dataBandInfoV2 = new StiDataBandInfoV2();
        }
        return this.dataBandInfoV2;
    }

    @Override
    public StiDataRelation getDataRelation() {
        if (this.getPage() == null || this.getReport() == null || this.getReport().getDictionary() == null || this.getReport().getDictionary().getRelations() == null || this.getDataRelationName() == null || this.getDataRelationName().length() == 0) {
            return null;
        }
        return this.getReport().getDictionary().getRelation(this.getDataRelationName());
    }

    @Override
    public boolean existDataRelation() {
        if (this.getPage() == null || this.getReport() == null || this.getReport().getDictionary() == null || this.getReport().getDictionary().getRelations() == null || this.getDataRelationName() == null || this.getDataRelationName().length() == 0) {
            return false;
        }
        return this.getReport().getDictionary().existRelation(this.getDataRelationName());
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="")
    public final String getDataRelationName() {
        return this.dataRelationName;
    }

    @Override
    public StiDataSource getDataSource() {
        if (this.getPage() == null || this.getReport() == null || this.getReport().getDataSources() == null || this.getDataSourceName() == null || this.getDataSourceName().length() == 0) {
            return null;
        }
        return this.getReport().getDataSources().get(this.getDataSourceName());
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="")
    public final String getDataSourceName() {
        return this.dataSourceName;
    }

    @StiSerializable
    public final StiEndRenderEvent getEndRenderEvent() {
        return new StiEndRenderEvent(this);
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="")
    public String getEvenStyle() {
        Object tempVar = this.properties.get(PropertyEvenStyle, (Object)"");
        return (String)(tempVar instanceof String ? tempVar : null);
    }

    @Override
    public StiEventsCollection getEvents() {
        StiEventsCollection events = super.getEvents();
        if (this.getBeginRenderEvent() != null) {
            events.add(this.getBeginRenderEvent());
        }
        if (this.getRenderingEvent() != null) {
            events.add(this.getRenderingEvent());
        }
        if (this.getEndRenderEvent() != null) {
            events.add(this.getEndRenderEvent());
        }
        return events;
    }

    @StiDefaulValue(value="0")
    @StiSerializable
    public int getFilterEngine() {
        return this.filterEngine.getValue();
    }

    @Override
    public final StiFilterEventHandler getFilterMethodHandler() {
        return this.filterMethodHandler;
    }

    @Override
    @StiDefaulValue(value="And")
    @StiSerializable
    public StiFilterMode getFilterMode() {
        return this.filterMode;
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getFilterOn() {
        return this.filterOn;
    }

    @Override
    @StiSerializable
    public StiFiltersCollection getFilters() {
        return this.filters;
    }

    @StiSerializable
    public final StiGetCollapsedEvent getGetCollapsedEvent() {
        return new StiGetCollapsedEvent(this);
    }

    @Override
    public StiColor getHeaderEndColor() {
        return new StiColor(StiColorEnum.CornflowerBlue);
    }

    @Override
    public StiColor getHeaderStartColor() {
        return new StiColor(StiColorEnum.LightBlue);
    }

    @Override
    public String GetHeaderText() {
        StiBusinessObject businessObject = this.getBusinessObject();
        if (businessObject != null) {
            String text = this.toString() + "; " + StiLocalization.get((String)"PropertyMain", (String)"BusinessObject") + ": ";
            return text + businessObject.GetFullName();
        }
        String text2 = this.toString() + "; " + StiLocalization.get((String)"PropertyMain", (String)"DataSource") + ": ";
        if (this.getDataSource() == null) {
            if (this.getCountData() > 0) {
                return text2 + new Integer(this.getCountData()).toString();
            }
            return text2 + StiLocalization.Get((String)"Report", (String)"NotAssigned");
        }
        return text2 + this.getDataSource().toString();
    }

    @Override
    public boolean getIsBof() {
        if (!this.getIsBusinessObjectEmpty()) {
            return this.getBusinessObject().isBof();
        }
        if (!this.isDataSourceEmpty()) {
            return this.getDataSource().getIsBof();
        }
        return this.isBofValue;
    }

    @Override
    public final boolean getIsBusinessObjectEmpty() {
        return this.getBusinessObjectGuid() == null || this.getBusinessObjectGuid().length() == 0 || this.getBusinessObject() == null;
    }

    @Override
    public boolean getIsEmpty() {
        if (!this.getIsBusinessObjectEmpty()) {
            return this.getBusinessObject().isEmpty();
        }
        if (!this.isDataSourceEmpty()) {
            return this.getDataSource().isEmpty();
        }
        return this.getCountData() == 0;
    }

    @Override
    public boolean getIsEof() {
        boolean result = !this.getIsBusinessObjectEmpty() ? this.getBusinessObject().isEof() : (!this.isDataSourceEmpty() ? this.getDataSource().getIsEof() : this.isEofValue);
        return result;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getKeepChildTogether() {
        return this.getKeepDetailsTogether();
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable(deprecated=true)
    public boolean getKeepDetailsTogether() {
        return this.keepDetails == StiKeepDetails.KeepDetailsTogether;
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getKeepFooterTogether() {
        return this.keepFooterTogether;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getKeepGroupTogether() {
        return this.keepGroupTogether;
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getKeepHeaderTogether() {
        return this.keepHeaderTogether;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getLineThrough() {
        return this.lineThrough;
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Components", (String)"StiDataBand");
    }

    public String getPageLine() {
        if (this.getReport() != null && this.getReport().getEngine() != null) {
            this.getReport().getEngine().pageLineRenderingEnabled = true;
        }
        if (this.getReport() != null && this.getReport().getIsRendering()) {
            return StiPageLineHelper.getIdent(this.getReport(), this.getName());
        }
        return String.valueOf(this.getLineThrough());
    }

    @Override
    @StiSerializable(isRef=true)
    public StiComponent getMasterComponent() {
        return this.masterComponent;
    }

    @StiDefaulValue(value="0")
    @StiSerializable
    public int getMinRowsInColumn() {
        return this.minRowsInColumn;
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="")
    public String getOddStyle() {
        Object tempVar = this.properties.get(PropertyOddStyle, (Object)"");
        return (String)(tempVar instanceof String ? tempVar : null);
    }

    @Override
    public int getPosition() {
        if (!this.getIsBusinessObjectEmpty()) {
            return this.getBusinessObject().getPosition();
        }
        if (!this.isDataSourceEmpty()) {
            return this.getDataSource().getPosition();
        }
        return this.positionValue;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getPrintIfDetailEmpty() {
        return this.printIfDetailEmpty;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getPrintOnAllPages() {
        return this.printOnAllPages;
    }

    @Override
    public int getPriority() {
        return StiComponentPriority.DataBand.getValue();
    }

    @StiSerializable
    public final StiRenderingEvent getRenderingEvent() {
        return new StiRenderingEvent(this);
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getResetDataSource() {
        return this.resetDataSource;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getResetPageNumber() {
        return super.getResetPageNumber();
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getRightToLeft() {
        return this.rightToLeft;
    }

    @Override
    @StiSerializable
    public ArrayList<String> getSort() {
        return this.sort;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getStartNewPage() {
        return this.startNewPage;
    }

    @Override
    @StiDefaulValue(value="100.0")
    @StiSerializable
    public float getStartNewPageIfLessThan() {
        return super.getBreakIfLessThan();
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.DataBand.getValue();
    }

    @Override
    public final void InvokeBeginRender() {
        this.getDataBandInfoV1().LastPositionRendering = -1;
        this.getDataBandInfoV1().RuntimeLine = 0;
        this.OnBeginRender(EventArgs.Empty);
        this.invokeScript(this.getBeginRenderEvent());
        StiBlocklyHelper.invokeBlockly(this.getReport(), this, this.getBeginRenderEvent());
    }

    public final void InvokeGroupRendering() {
        StiReport report = this.getReport();
        if (report == null) {
            return;
        }
        if (this.dataBandInfoV2.GroupHeaders != null && this.dataBandInfoV2.GroupHeaders.size() > 0) {
            for (StiGroupHeaderBand header : this.dataBandInfoV2.GroupHeaders) {
                header.InvokeRendering();
            }
        }
    }

    public final void InvokeRendering() {
        try {
            if (this.getReport() != null && this.getReport().getEngineVersion() == StiEngineVersion.EngineV2) {
                for (StiEventHandlerListener listener : this.handlerRendering) {
                    listener.invoke(new StiEventObject((Object)this));
                }
            } else if (this.dataBandInfoV1.LastPositionRendering != this.getPosition()) {
                ++this.lineThrough;
            }
            if ((this.eventFlags & StiEventFlags.Rendering.getValue()) > 0 || (this.eventFlags & StiEventFlags.Mark.getValue()) == 0) {
                this.invokeScript(this.getRenderingEvent());
                StiBlocklyHelper.invokeBlockly(this.getReport(), this, this.getRenderingEvent());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void InvokeEndRender() {
        try {
            this.OnEndRender(EventArgs.Empty);
            this.invokeScript(this.getEndRenderEvent());
            StiBlocklyHelper.invokeBlockly(this.getReport(), this, this.getEndRenderEvent());
        }
        catch (Exception ex) {
            StiLoggingUtil.printStackTrace((Exception)ex);
        }
    }

    @Override
    public final boolean isDataSourceEmpty() {
        return this.getDataSourceName() == null || this.getDataSourceName().length() == 0 || this.getDataSource() == null;
    }

    @Override
    public void Last() {
        if (!this.getIsBusinessObjectEmpty()) {
            this.getBusinessObject().last();
        } else if (!this.isDataSourceEmpty()) {
            this.getDataSource().Last();
        } else {
            this.isEofValue = true;
            this.isBofValue = false;
            this.setPosition(this.countData - 1);
        }
        if (this.getReport() != null && this.getReport().getEngineVersion() == StiEngineVersion.EngineV1) {
            StiDataBandV1Builder.setDetails(this);
        } else {
            StiDataBandV2Builder.SetDetails(this);
        }
    }

    @Override
    public void Next() {
        boolean needSetDetails = true;
        if (!this.getIsBusinessObjectEmpty()) {
            this.getBusinessObject().next();
            if (this.getDataSource().getIsEof()) {
                needSetDetails = false;
            }
        } else if (!this.isDataSourceEmpty()) {
            this.getDataSource().Next();
            if (this.getDataSource().getIsEof()) {
                needSetDetails = false;
            }
        } else {
            this.isBofValue = false;
            this.isEofValue = false;
            if (this.getPosition() >= this.countData - 1) {
                this.isEofValue = true;
                needSetDetails = false;
            } else {
                this.setPosition(this.getPosition() + 1);
            }
        }
        if (needSetDetails) {
            StiDataBandV2Builder.SetDetails(this);
        }
    }

    protected void OnBeginRender(EventArgs e) {
    }

    protected void OnEndRender(EventArgs e) {
    }

    protected void OnGetCollapsed(StiValueEventArgs e) {
    }

    protected void OnRendering(EventArgs e) {
    }

    @Override
    public void packService() {
        super.packService();
        this.filters = null;
    }

    @Override
    public void Prior() {
        if (!this.getIsBusinessObjectEmpty()) {
            this.getBusinessObject().prior();
        } else if (!this.isDataSourceEmpty()) {
            this.getDataSource().Prior();
        } else {
            this.isBofValue = false;
            this.isEofValue = false;
            if (this.getPosition() <= 0) {
                this.isBofValue = true;
            } else {
                this.setPosition(this.getPosition() - 1);
            }
        }
        if (this.getReport() != null && this.getReport().getEngineVersion() == StiEngineVersion.EngineV1) {
            StiDataBandV1Builder.setDetails(this);
        } else {
            StiDataBandV2Builder.SetDetails(this);
        }
    }

    @Override
    public void renderMaster() {
        StiV2Builder tempVar = StiV2Builder.GetBuilder(this.getClass());
        StiDataBandV2Builder builder = (StiDataBandV2Builder)(tempVar instanceof StiDataBandV2Builder ? tempVar : null);
        builder.RenderMaster(this);
    }

    @Override
    public void saveState(String stateName) {
        this.getStates().PushInt(stateName, this, "positionValue", this.getPosition());
        this.getStates().PushBool(stateName, this, "isEofValue", this.isEofValue);
        this.getStates().PushBool(stateName, this, "isBofValue", this.isBofValue);
        if (this.getDataSource() != null) {
            this.getDataSource().saveState(stateName);
        }
        if (!StiValidationUtil.isNullOrEmpty((String)this.getBusinessObjectGuid())) {
            this.getBusinessObject().SaveState(stateName);
        }
    }

    @Override
    public void RestoreState(String stateName) {
        this.isBofValue = this.getStates().PopBool(stateName, this, "isBofValue");
        this.isEofValue = this.getStates().PopBool(stateName, this, "isEofValue");
        this.positionValue = this.getStates().PopInt(stateName, this, "positionValue");
        if (this.getDataSource() != null) {
            this.getDataSource().RestoreState(stateName);
        }
        if (!StiValidationUtil.isNullOrEmpty((String)this.getBusinessObjectGuid())) {
            this.getBusinessObject().RestoreState(stateName);
        }
        StiDataBandV2Builder.PrepareGroupResults(this);
    }

    public final void setBeginRenderEvent(StiBeginRenderEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    @Override
    public final void setBusinessObjectGuid(String value) {
        if (!this.businessObjectGuid.equals(value)) {
            this.businessObjectGuid = value;
        }
    }

    public void setCalcInvisible(boolean value) {
        this.calcInvisible = value;
    }

    public void setCollapsed(StiCollapsedExpression value) {
        if (value != null) {
            value.set(this, "Collapsed", value.getValue());
        }
    }

    public void setColumnDirection(StiColumnDirection value) {
        if (this.columnDirection != value) {
            this.checkBlockedException("ColumnDirection");
            this.columnDirection = value;
        }
    }

    public void setColumnGaps(double value) {
        if (this.columnGaps != value) {
            this.checkBlockedException("ColumnGaps");
            if (value < 0.0) {
                throw new IndexOutOfBoundsException("ColumnGaps " + String.format("Value of '%1$s' is not valid for 'ColumnGaps'. 'ColumnGaps' must be greater than or equal to 0.", value));
            }
            this.columnGaps = value;
        }
    }

    public void setColumns(int value) {
        if (this.columns != value) {
            this.checkBlockedException("Columns");
            if (value < 0) {
                throw new IndexOutOfBoundsException("Columns " + String.format("Value of '%1$s' is not valid for 'Columns'. 'Columns' must be greater than or equal to 0.", value));
            }
            this.columns = value;
        }
    }

    public void setColumnWidth(double value) {
        if (this.columnWidth != value) {
            this.checkBlockedException("ColumnWidth");
            if (value < 0.0) {
                throw new IndexOutOfBoundsException("ColumnWidth " + String.format("Value of '%1$s' is not valid for 'ColumnWidth'. 'ColumnWidth' must be greater than or equal to 0.", value));
            }
            this.columnWidth = value;
        }
    }

    public void setCountData(int value) {
        if (this.countData != value) {
            this.countData = value;
            if (value > 0) {
                this.setDataSourceName("");
            }
        }
    }

    @Override
    public final void setDataRelationName(String value) {
        this.dataRelationName = value;
    }

    @Override
    public final void setDataSourceName(String value) {
        this.dataSourceName = StiNameValidator.CorrectName(value);
    }

    public final void setEndRenderEvent(StiEndRenderEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    @Override
    public void setEvenStyle(String value) {
        this.properties.set(PropertyEvenStyle, (Object)value, (Object)"");
    }

    public void setFilterEngine(int value) {
        this.filterEngine = StiFilterEngine.forValue(value);
    }

    @Override
    public final void setFilterMethodHandler(StiFilterEventHandler value) {
        this.filterMethodHandler = value;
    }

    @Override
    public void setFilterMode(StiFilterMode value) {
        this.filterMode = value;
    }

    @Override
    public void setFilterOn(boolean value) {
        this.filterOn = value;
    }

    @Override
    public void setFilters(StiFiltersCollection value) {
        this.filters = value;
    }

    public final void setGetCollapsedEvent(StiGetCollapsedEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    @Override
    public void setIsBof(boolean value) {
        if (!this.getIsBusinessObjectEmpty()) {
            this.getBusinessObject().setBof(value);
        } else if (!this.isDataSourceEmpty()) {
            this.getDataSource().setIsBof(value);
        } else {
            this.isBofValue = value;
        }
    }

    @Override
    public void setIsEof(boolean value) {
        if (!this.getIsBusinessObjectEmpty()) {
            this.getBusinessObject().setEof(value);
        } else if (!this.isDataSourceEmpty()) {
            this.getDataSource().setIsEof(value);
        } else {
            this.isEofValue = value;
        }
    }

    public void setKeepChildTogether(boolean value) {
        this.setKeepDetailsTogether(value);
    }

    @Override
    public void setKeepDetailsTogether(boolean value) {
        this.CheckBlockedException("KeepDetailsTogether");
        this.keepDetails = value ? StiKeepDetails.KeepDetailsTogether : StiKeepDetails.None;
    }

    @Override
    public void setKeepFooterTogether(boolean value) {
        this.keepFooterTogether = value;
    }

    @Override
    public void setKeepGroupTogether(boolean value) {
        this.keepGroupTogether = value;
    }

    @Override
    public void setKeepHeaderTogether(boolean value) {
        this.keepHeaderTogether = value;
    }

    public final void setLine(int value) {
        this.line = value;
    }

    public final void setLineThrough(int value) {
        this.lineThrough = value;
    }

    @Override
    public void setMasterComponent(StiComponent value) {
        this.masterComponent = value;
    }

    public void setMinRowsInColumn(int value) {
        if (this.minRowsInColumn != value) {
            this.checkBlockedException("MinRowsInColumn");
            if (value < 0) {
                throw new IndexOutOfBoundsException("MinRowsInColumn " + String.format("Value of '%1$s' is not valid for 'MinRowsInColumn'. 'MinRowsInColumn' must be greater than or equal to 0.", value));
            }
            this.minRowsInColumn = value;
        }
    }

    @Override
    public void setOddStyle(String value) {
        this.properties.set(PropertyOddStyle, (Object)value, (Object)"");
    }

    @Override
    public void setPosition(int value) {
        if (!this.getIsBusinessObjectEmpty()) {
            this.getBusinessObject().setPosition(value);
        } else if (!this.isDataSourceEmpty()) {
            this.getDataSource().setPosition(value);
        } else {
            this.positionValue = value;
        }
    }

    @Override
    public void setPrintIfDetailEmpty(boolean value) {
        this.printIfDetailEmpty = value;
    }

    @Override
    public void setPrintOnAllPages(boolean value) {
        this.printOnAllPages = value;
    }

    public final void setRenderingEvent(StiRenderingEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    public void setResetDataSource(boolean value) {
        this.resetDataSource = value;
    }

    @Override
    public void setResetPageNumber(boolean value) {
        super.setResetPageNumber(value);
    }

    public void setRightToLeft(boolean value) {
        if (this.rightToLeft != value) {
            this.checkBlockedException("RightToLeft");
            this.rightToLeft = value;
        }
    }

    @Override
    public void setSort(ArrayList<String> value) {
        this.sort = value;
    }

    @Override
    public void setStartNewPage(boolean value) {
        this.startNewPage = value;
    }

    @Override
    public void setStartNewPageIfLessThan(float value) {
        super.setBreakIfLessThan(value);
    }

    @Override
    public String getComponentPlacementForChildren() {
        return "d." + this.getName();
    }

    public void InvokeGetCollapsed(StiValueEventArgs e) {
        try {
            this.OnGetCollapsed(e);
            if (this.getReport() != null && StiValidationUtil.isNotNullOrEmpty((String)this.getCollapsed().getValue())) {
                e.setValue(StiScriptHelper.parseTextValue(this.getCollapsed().getValue(), this));
            }
            if ((this.eventFlags & StiEventFlags.GetCollapsed.getValue()) > 0 || (this.eventFlags & StiEventFlags.Mark.getValue()) == 0) {
                this.invokeScript(this.getGetCollapsedEvent(), this, e);
                StiBlocklyHelper.invokeBlockly(this.getReport(), this, this.getGetCollapsedEvent(), e);
            }
        }
        catch (Exception ex) {
            if (this.getReport() != null) {
                this.getReport().WriteToReportRenderingMessages(ex.getMessage() != null ? ex.getMessage() : ex.getStackTrace()[0].toString());
            }
            ex.printStackTrace();
        }
    }

    public int getSelectedLine() {
        return this.selectedLine;
    }

    public void setSelectedLine(int selectedLine) {
        this.selectedLine = selectedLine;
    }

    public void setKeepDetails(StiKeepDetails keepDetails) {
        this.keepDetails = keepDetails;
    }

    @StiSerializable
    public StiKeepDetails getKeepDetails() {
        return this.keepDetails;
    }

    @Override
    public Object clone(boolean cloneProperties, boolean cloneComponents) {
        Object tempVar3;
        StiDataBand band = (StiDataBand)super.clone(cloneProperties, cloneComponents);
        Object tempVar = this.getDataBandInfoV1().clone();
        band.dataBandInfoV1 = (StiDataBandInfoV1)(tempVar instanceof StiDataBandInfoV1 ? tempVar : null);
        Object tempVar2 = this.getDataBandInfoV2().clone();
        band.dataBandInfoV2 = (StiDataBandInfoV2)(tempVar2 instanceof StiDataBandInfoV2 ? tempVar2 : null);
        band.masterComponent = null;
        band.keepHeaderTogether = this.keepHeaderTogether;
        band.sort = this.sort != null ? (ArrayList)this.sort.clone() : null;
        band.filters = this.filters != null ? (StiFiltersCollection)((tempVar3 = this.filters.clone()) instanceof StiFiltersCollection ? tempVar3 : null) : null;
        return band;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyBool("StartNewPage", this.getStartNewPage());
        jObject.AddPropertyFloat("StartNewPageIfLessThan", (double)this.getStartNewPageIfLessThan(), 100.0);
        jObject.AddPropertyBool("KeepGroupTogether", this.getKeepGroupTogether());
        jObject.AddPropertyBool("KeepHeaderTogether", this.getKeepHeaderTogether(), true);
        jObject.AddPropertyBool("KeepFooterTogether", this.getKeepFooterTogether(), true);
        jObject.AddPropertyBool("KeepChildTogether", this.getKeepChildTogether());
        jObject.AddPropertyEnum("KeepDetails", (Enum)this.getKeepDetails(), (Enum)StiKeepDetails.None);
        jObject.AddPropertyBool("PrintOnAllPages", this.getPrintOnAllPages());
        jObject.AddPropertyBool("PrintIfDetailEmpty", this.getPrintIfDetailEmpty());
        jObject.AddPropertyStringNullOfEmpty("DataSourceName", this.getDataSourceName());
        jObject.AddPropertyStringNullOfEmpty("BusinessObjectGuid", this.getBusinessObjectGuid());
        jObject.AddPropertyStringNullOfEmpty("DataRelationName", this.getDataRelationName());
        jObject.AddPropertyEnum("FilterMode", (Enum)this.getFilterMode(), (Enum)StiFilterMode.And);
        jObject.AddPropertyInt("FilterEngine", this.getFilterEngine(), StiFilterEngine.ReportEngine.getValue());
        jObject.AddPropertyBool("FilterOn", this.getFilterOn(), true);
        jObject.AddPropertyStringNullOfEmpty("EvenStyle", this.getEvenStyle());
        jObject.AddPropertyStringNullOfEmpty("OddStyle", this.getOddStyle());
        jObject.AddPropertyJObject("BeginRenderEvent", this.getBeginRenderEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("RenderingEvent", this.getRenderingEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("EndRenderEvent", this.getEndRenderEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetCollapsedEvent", this.getGetCollapsedEvent().SaveToJsonObject(mode));
        jObject.AddPropertyBool("RightToLeft", this.getRightToLeft());
        jObject.AddPropertyDouble("ColumnGaps", this.getColumnGaps(), 0.0);
        jObject.AddPropertyDouble("ColumnWidth", this.getColumnWidth(), 0.0);
        jObject.AddPropertyInt("Columns", this.getColumns());
        jObject.AddPropertyInt("MinRowsInColumn", this.getMinRowsInColumn());
        jObject.AddPropertyEnum("ColumnDirection", (Enum)this.getColumnDirection(), (Enum)StiColumnDirection.AcrossThenDown);
        jObject.AddPropertyBool("ResetDataSource", this.getResetDataSource());
        jObject.AddPropertyBool("CalcInvisible", this.getCalcInvisible());
        jObject.AddPropertyInt("CountData", this.getCountData());
        jObject.AddPropertyBool("KeepDetailsTogether", this.getKeepDetailsTogether());
        if (this.getMasterComponent() != null) {
            jObject.AddPropertyStringNullOfEmpty("MasterComponent", this.getMasterComponent().getName());
        }
        if (mode == StiJsonSaveMode.Report) {
            jObject.AddPropertyJObject("Sort", StiJsonReportObjectHelper.Serialize.StringArray(this.getSort()));
            jObject.AddPropertyJObject("Filters", this.getFilters().SaveToJsonObject(mode));
            jObject.AddPropertyJObject("Collapsed", this.getCollapsed().SaveToJsonObject(mode));
        }
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            StiEvent _event;
            if (JSONObject.NULL.equals(property.Value)) continue;
            if (property.Name.equals("StartNewPage")) {
                this.startNewPage = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("StartNewPageIfLessThan")) {
                this.setStartNewPageIfLessThan(property.floatValue().floatValue());
                continue;
            }
            if (property.Name.equals("KeepGroupTogether")) {
                this.keepGroupTogether = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("KeepHeaderTogether")) {
                this.keepHeaderTogether = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("KeepFooterTogether")) {
                this.keepFooterTogether = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("KeepChildTogether")) {
                this.setKeepChildTogether((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("KeepDetails")) {
                this.keepDetails = StiKeepDetails.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("Sort")) {
                this.sort = StiJsonReportObjectHelper.Deserialize.stringList((JSONObject)((JSONObject)property.Value));
                continue;
            }
            if (property.Name.equals("PrintOnAllPages")) {
                this.printOnAllPages = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("PrintIfDetailEmpty")) {
                this.printIfDetailEmpty = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("DataSourceName")) {
                this.dataSourceName = (String)property.Value;
                continue;
            }
            if (property.Name.equals("BusinessObjectGuid")) {
                this.businessObjectGuid = (String)property.Value;
                continue;
            }
            if (property.Name.equals("DataRelationName")) {
                this.dataRelationName = (String)property.Value;
                continue;
            }
            if (property.Name.equals("FilterMode")) {
                this.filterMode = StiFilterMode.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("FilterEngine")) {
                this.filterEngine = StiFilterEngine.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("Filters")) {
                if (this.filters == null) {
                    this.filters = new StiFiltersCollection();
                }
                this.filters.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("FilterOn")) {
                this.filterOn = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("EvenStyle")) {
                this.setEvenStyle((String)property.Value);
                continue;
            }
            if (property.Name.equals("OddStyle")) {
                this.setOddStyle((String)property.Value);
                continue;
            }
            if (property.Name.equals("BeginRenderEvent")) {
                _event = new StiBeginRenderEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setBeginRenderEvent((StiBeginRenderEvent)_event);
                continue;
            }
            if (property.Name.equals("RenderingEvent")) {
                _event = new StiRenderingEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setRenderingEvent((StiRenderingEvent)_event);
                continue;
            }
            if (property.Name.equals("EndRenderEvent")) {
                _event = new StiEndRenderEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setEndRenderEvent((StiEndRenderEvent)_event);
                continue;
            }
            if (property.Name.equals("GetCollapsedEvent")) {
                _event = new StiGetCollapsedEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setGetCollapsedEvent((StiGetCollapsedEvent)_event);
                continue;
            }
            if (property.Name.equals("Collapsed")) {
                StiCollapsedExpression _expression = new StiCollapsedExpression();
                _expression.LoadFromJsonObject((JSONObject)property.Value);
                this.setCollapsed(_expression);
                continue;
            }
            if (property.Name.equals("RightToLeft")) {
                this.rightToLeft = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("ColumnGaps")) {
                this.columnGaps = property.doubleValue();
                continue;
            }
            if (property.Name.equals("ColumnWidth")) {
                this.columnWidth = property.doubleValue();
                continue;
            }
            if (property.Name.equals("Columns")) {
                this.columns = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("MinRowsInColumn")) {
                this.minRowsInColumn = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("ColumnDirection")) {
                this.columnDirection = StiColumnDirection.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("ResetDataSource")) {
                this.resetDataSource = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("CalcInvisible")) {
                this.calcInvisible = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("CountData")) {
                this.countData = (Integer)property.Value;
                continue;
            }
            if (!property.Name.equals("MasterComponent")) continue;
            this.jsonMasterComponentTemp = (String)property.Value;
            this.getReport().getJsonLoaderHelper().MasterComponents.add(this);
        }
    }
}

