/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components;

import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.components.enums.StiInteractionSortDirection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StiSortHelper {
    public static ArrayList<String> addColumnToSorting(List<String> sorts, String columnName, boolean isAscending) {
        int index;
        String[] strs = columnName.split(".");
        if (strs.length == 0) {
            strs = new String[]{columnName};
        }
        String[] newSorts = new String[sorts.size() + strs.length + 1];
        for (index = 0; index < sorts.size(); ++index) {
            newSorts[index] = sorts.get(index);
        }
        newSorts[sorts.size()] = isAscending ? "ASC" : "DESC";
        for (index = 0; index < strs.length; ++index) {
            newSorts[sorts.size() + index + 1] = strs[index];
        }
        return new ArrayList<String>(Arrays.asList(newSorts));
    }

    public static int getColumnIndexInSorting(List<String> sorts, String columnName) {
        int sortIndex = 0;
        String sortStr = "";
        int index = 0;
        for (String str : sorts) {
            if (!"ASC".equals(str) && !"DESC".equals(str)) {
                sortStr = sortStr.length() == 0 ? str : sortStr + "." + str;
            }
            if (("ASC".equals(str) || "DESC".equals(str) || index == sorts.size() - 1) && sortStr.length() > 0) {
                if (StiValidationUtil.equals((Object)columnName, (Object)sortStr)) {
                    return sortIndex;
                }
                sortStr = "";
                ++sortIndex;
            }
            ++index;
        }
        return -1;
    }

    public static StiInteractionSortDirection getColumnSortDirection(List<String> sorts, String columnName) {
        int sortIndex = StiSortHelper.getColumnIndexInSorting(sorts, columnName);
        if (sortIndex == -1) {
            return StiInteractionSortDirection.None;
        }
        for (String str : sorts) {
            if (!"ASC".equals(str) && !"DESC".equals(str)) continue;
            if (sortIndex == 0) {
                if ("ASC".equals(str)) {
                    return StiInteractionSortDirection.Ascending;
                }
                if ("DESC".equals(str)) {
                    return StiInteractionSortDirection.Descending;
                }
            }
            --sortIndex;
        }
        return StiInteractionSortDirection.None;
    }

    public static ArrayList<String> changeColumnSortDirection(List<String> sorts, String columnName) {
        int sortIndex = StiSortHelper.getColumnIndexInSorting(sorts, columnName);
        if (sortIndex == -1) {
            return (ArrayList)sorts;
        }
        int index = 0;
        for (String str : sorts) {
            if ("ASC".equals(str) || "DESC".equals(str)) {
                if (sortIndex == 0) {
                    if ("ASC".equals(str)) {
                        sorts.set(index, "DESC");
                    }
                    if ("DESC".equals(str)) {
                        sorts.set(index, "ASC");
                    }
                    return (ArrayList)sorts;
                }
                --sortIndex;
            }
            ++index;
        }
        return (ArrayList)sorts;
    }
}

