/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components;

import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.conditions.StiFilter;
import com.stimulsoft.report.components.enums.StiFilterCondition;
import com.stimulsoft.report.components.enums.StiFilterDataType;
import com.stimulsoft.report.components.enums.StiFilterItem;
import com.stimulsoft.report.components.enums.StiFilterMode;
import com.stimulsoft.report.components.interfaces.IStiBusinessObject;
import com.stimulsoft.report.components.interfaces.IStiDataRelation;
import com.stimulsoft.report.components.interfaces.IStiDataSource;
import com.stimulsoft.report.components.interfaces.IStiFilter;
import com.stimulsoft.report.components.interfaces.IStiMasterComponent;
import com.stimulsoft.report.components.interfaces.IStiSort;
import com.stimulsoft.report.dictionary.IStiEnumerator;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.enums.StiCalculationMode;
import java.util.ArrayList;

public class StiDataHelper {
    public static void SetData(StiComponent component, boolean reinit) {
        StiDataHelper.SetData(component, reinit, null);
    }

    public static void SetData(StiComponent component, boolean reinit, StiComponent masterComponent) {
        StiBusinessObject businessObjectData;
        IStiEnumerator enumerator;
        boolean existDataSource;
        IStiDataSource dataSource = (IStiDataSource)((Object)(component instanceof IStiDataSource ? component : null));
        boolean bl = existDataSource = dataSource != null && dataSource.getDataSource() != null;
        if (existDataSource) {
            IStiMasterComponent msComponent;
            IStiDataRelation dataRelation = (IStiDataRelation)((Object)(component instanceof IStiDataRelation ? component : null));
            String relationName = null;
            if (dataRelation != null && dataRelation.existDataRelation()) {
                relationName = dataRelation.getDataRelationName();
            }
            if (masterComponent == null && ((msComponent = (IStiMasterComponent)((Object)(component instanceof IStiMasterComponent ? component : null))) == null || msComponent.getMasterComponent() == null)) {
                relationName = null;
            }
            Object filterEventHandler = StiDataHelper.GetFilterEventHandler(component, dataSource);
            IStiSort dataSort = (IStiSort)((Object)(component instanceof IStiSort ? component : null));
            ArrayList<String> sorts = null;
            if (dataSort != null && dataSort.getSort() != null && dataSort.getSort().size() > 0) {
                sorts = dataSort.getSort();
            }
            dataSource.getDataSource().SetData((StiDataBand)(component instanceof StiDataBand ? component : null), relationName, filterEventHandler, sorts, reinit, component);
        }
        if ((enumerator = (IStiEnumerator)((Object)(component instanceof IStiEnumerator ? component : null))) != null) {
            enumerator.First();
        }
        IStiBusinessObject businessObject = (IStiBusinessObject)((Object)(component instanceof IStiBusinessObject ? component : null));
        StiBusinessObject stiBusinessObject = businessObjectData = businessObject != null ? businessObject.getBusinessObject() : null;
        if (businessObjectData != null) {
            businessObjectData.SetDetails();
        }
    }

    public static Object GetFilterEventHandler(StiComponent component, Object dataSource) {
        IStiFilter dataFilter = (IStiFilter)((Object)(component instanceof IStiFilter ? component : null));
        Object filterEventHandler = null;
        if (dataFilter != null && dataFilter.getFilterMethodHandler() != null) {
            filterEventHandler = dataFilter.getFilterMethodHandler();
        }
        if (component != null && component.getReport() != null && component.getReport().getCalculationMode() == StiCalculationMode.Interpretation && dataFilter != null && dataFilter.getFilterOn() && dataFilter.getFilters().size() > 0) {
            StringBuilder filterExpression = new StringBuilder("{");
            for (int index = 0; index < dataFilter.getFilters().size(); ++index) {
                StiFilter filter = (StiFilter)dataFilter.getFilters().get(index);
                filterExpression.append("(");
                if (dataSource instanceof IStiDataSource) {
                    filterExpression.append(StiDataHelper.GetFilterExpression(filter, ((IStiDataSource)dataSource).getDataSourceName() + "." + filter.getColumn()));
                } else {
                    filterExpression.append(StiDataHelper.GetFilterExpression(filter, ((StiBusinessObject)((Object)dataSource)).getName() + "." + filter.getColumn()));
                }
                filterExpression.append(")");
                if (index >= dataFilter.getFilters().size() - 1) continue;
                filterExpression.append(dataFilter.getFilterMode() == StiFilterMode.And ? " && " : " || ");
            }
            filterExpression.append("}");
            filterEventHandler = new StiParser.StiFilterParserData(component, filterExpression.toString());
        }
        return filterEventHandler;
    }

    public static String GetFilterExpression(StiFilter filter, String fullColumnName) {
        StringBuilder filterExpression = new StringBuilder();
        if (filter.getItem() == StiFilterItem.Expression) {
            String st = filter.getExpression().getValue();
            if (st != null) {
                if (st.startsWith("{") && st.endsWith("}")) {
                    filterExpression.append(st.substring(1, 1 + st.length() - 2));
                } else {
                    filterExpression.append(st);
                }
            }
        } else if (filter.getItem() == StiFilterItem.Value) {
            if (filter.getCondition() == StiFilterCondition.IsNull || filter.getCondition() == StiFilterCondition.IsNotNull) {
                String expr = null;
                int posDot = fullColumnName.lastIndexOf(46);
                if (posDot < 0) {
                    expr = fullColumnName;
                } else {
                    String dsName = fullColumnName.substring(0, posDot);
                    String colName = fullColumnName.substring(posDot + 1);
                    expr = String.format("%s[\"%s\"]", dsName, colName);
                }
                if (filter.getCondition() == StiFilterCondition.IsNull) {
                    filterExpression.append(String.format("%s == null || %s == DBNull.Value", expr, expr));
                } else {
                    filterExpression.append(String.format("%s != null && %s != DBNull.Value", expr, expr));
                }
            } else if (filter.getDataType() == StiFilterDataType.String) {
                if (filter.getCondition() == StiFilterCondition.EqualTo) {
                    filterExpression.append(String.format("%1$s.ToString().ToLower() == ToString(\"%2$s\").ToLower()", fullColumnName, filter.getValue1()));
                } else if (filter.getCondition() == StiFilterCondition.NotEqualTo) {
                    filterExpression.append(String.format("%1$s.ToString().ToLower() != ToString(\"%2$s\").ToLower()", fullColumnName, filter.getValue1()));
                } else if (filter.getCondition() == StiFilterCondition.Containing) {
                    filterExpression.append(String.format("ToString(%1$s).ToLower().IndexOf(ToString(\"%2$s\").ToLower()) != -1", fullColumnName, filter.getValue1()));
                } else if (filter.getCondition() == StiFilterCondition.NotContaining) {
                    filterExpression.append(String.format("ToString(%1$s).ToLower().IndexOf(ToString(\"%2$s\").ToLower()) == -1", fullColumnName, filter.getValue1()));
                } else if (filter.getCondition() == StiFilterCondition.BeginningWith) {
                    filterExpression.append(String.format("ToString(%1$s).ToLower().StartsWith(ToString(\"%2$s\").ToLower())", fullColumnName, filter.getValue1()));
                } else if (filter.getCondition() == StiFilterCondition.EndingWith) {
                    filterExpression.append(String.format("ToString(%1$s).ToLower().EndsWith(ToString(\"%2$s\").ToLower())", fullColumnName, filter.getValue1()));
                }
            } else if (filter.getDataType() == StiFilterDataType.Numeric) {
                if (filter.getCondition() == StiFilterCondition.EqualTo) {
                    filterExpression.append(String.format("(decimal)%1$s == (decimal)%2$s", fullColumnName, filter.getValue1()));
                } else if (filter.getCondition() == StiFilterCondition.NotEqualTo) {
                    filterExpression.append(String.format("(decimal)%1$s != (decimal)%2$s", fullColumnName, filter.getValue1()));
                } else if (filter.getCondition() == StiFilterCondition.Between) {
                    filterExpression.append(String.format("(decimal)%1$s >= (decimal)%2$s && (decimal)%1$s <= (decimal)%3$s", fullColumnName, filter.getValue1(), filter.getValue2()));
                } else if (filter.getCondition() == StiFilterCondition.NotBetween) {
                    filterExpression.append(String.format("(decimal)%1$s < (decimal)%2$s || (decimal)%1$s > (decimal)%3$s", fullColumnName, filter.getValue1(), filter.getValue2()));
                } else if (filter.getCondition() == StiFilterCondition.GreaterThan) {
                    filterExpression.append(String.format("(decimal)%1$s > (decimal)%2$s", fullColumnName, filter.getValue1()));
                } else if (filter.getCondition() == StiFilterCondition.GreaterThanOrEqualTo) {
                    filterExpression.append(String.format("(decimal)%1$s >= (decimal)%2$s", fullColumnName, filter.getValue1()));
                } else if (filter.getCondition() == StiFilterCondition.LessThan) {
                    filterExpression.append(String.format("(decimal)%1$s < (decimal)%2$s", fullColumnName, filter.getValue1()));
                } else if (filter.getCondition() == StiFilterCondition.LessThanOrEqualTo) {
                    filterExpression.append(String.format("(decimal)%1$s <= (decimal)%2$s", fullColumnName, filter.getValue1()));
                }
            } else if (filter.getDataType() == StiFilterDataType.DateTime) {
                String dt1 = "";
                if (filter.getValue1() != null && filter.getValue1().length() > 0) {
                    String[] parts = filter.getValue1().split("[/]", -1);
                    dt1 = String.format("DateSerial(%1$s,%2$s,%3$s)", parts[2], parts[0], parts[1]);
                }
                String dt2 = "";
                if (filter.getValue2() != null && filter.getValue2().length() > 0) {
                    String[] parts = filter.getValue2().split("[/]", -1);
                    dt2 = String.format("DateSerial(%1$s,%2$s,%3$s)", parts[2], parts[0], parts[1]);
                }
                if (filter.getCondition() == StiFilterCondition.EqualTo) {
                    filterExpression.append(String.format("(datetime)%1$s == %2$s", fullColumnName, dt1));
                } else if (filter.getCondition() == StiFilterCondition.NotEqualTo) {
                    filterExpression.append(String.format("(datetime)%1$s != %2$s", fullColumnName, dt1));
                } else if (filter.getCondition() == StiFilterCondition.Between) {
                    filterExpression.append(String.format("(datetime)%1$s >= %2$s && (datetime)%1$s <= %3$s", fullColumnName, dt1, dt2));
                } else if (filter.getCondition() == StiFilterCondition.NotBetween) {
                    filterExpression.append(String.format("(datetime)%1$s < %2$s || (datetime)%1$s > %3$s", fullColumnName, dt1, dt2));
                } else if (filter.getCondition() == StiFilterCondition.GreaterThan) {
                    filterExpression.append(String.format("(datetime)%1$s > %2$s", fullColumnName, dt1));
                } else if (filter.getCondition() == StiFilterCondition.GreaterThanOrEqualTo) {
                    filterExpression.append(String.format("(datetime)%1$s >= %2$s", fullColumnName, dt1));
                } else if (filter.getCondition() == StiFilterCondition.LessThan) {
                    filterExpression.append(String.format("(datetime)%1$s < %2$s", fullColumnName, dt1));
                } else if (filter.getCondition() == StiFilterCondition.LessThanOrEqualTo) {
                    filterExpression.append(String.format("(datetime)%1$s <= %2$s", fullColumnName, dt1));
                }
            } else if (filter.getDataType() == StiFilterDataType.Boolean) {
                if (filter.getCondition() == StiFilterCondition.EqualTo) {
                    filterExpression.append(String.format("(bool)%1$s == %2$s", fullColumnName, filter.getValue1()));
                } else if (filter.getCondition() == StiFilterCondition.NotEqualTo) {
                    filterExpression.append(String.format("(bool)%1$s != %2$s", fullColumnName, filter.getValue1()));
                }
            } else if (filter.getDataType() == StiFilterDataType.Expression) {
                if (filter.getCondition() == StiFilterCondition.EqualTo) {
                    filterExpression.append(String.format("%1$s == %2$s", fullColumnName, filter.getValue1()));
                } else if (filter.getCondition() == StiFilterCondition.NotEqualTo) {
                    filterExpression.append(String.format("%1$s != )%2$s", fullColumnName, filter.getValue1()));
                } else if (filter.getCondition() == StiFilterCondition.Between) {
                    filterExpression.append(String.format("%1$s >= %2$s && %1$s <= %3$s", fullColumnName, filter.getValue1(), filter.getValue2()));
                } else if (filter.getCondition() == StiFilterCondition.NotBetween) {
                    filterExpression.append(String.format("%1$s < %2$s || %1$s > %3$s", fullColumnName, filter.getValue1(), filter.getValue2()));
                } else if (filter.getCondition() == StiFilterCondition.GreaterThan) {
                    filterExpression.append(String.format("%1$s > %2$s", fullColumnName, filter.getValue1()));
                } else if (filter.getCondition() == StiFilterCondition.GreaterThanOrEqualTo) {
                    filterExpression.append(String.format("%1$s >= %2$s", fullColumnName, filter.getValue1()));
                } else if (filter.getCondition() == StiFilterCondition.LessThan) {
                    filterExpression.append(String.format("%1$s < %2$s", fullColumnName, filter.getValue1()));
                } else if (filter.getCondition() == StiFilterCondition.LessThanOrEqualTo) {
                    filterExpression.append(String.format("%1$s <= %2$s", fullColumnName, filter.getValue1()));
                }
            }
        }
        return filterExpression.toString();
    }
}

