/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components;

import com.stimulsoft.base.EventArgs;
import com.stimulsoft.base.IStiAppExpressionCollection;
import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiAppExpressionCollection;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.StiRepositoryItems;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGlassBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiHatchBrush;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.enums.StiHighlightState;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.annotations.StiSerializeTypesEnum;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.base.utils.StiMath;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.IStiInherited;
import com.stimulsoft.report.IStiStateSaveRestore;
import com.stimulsoft.report.StiBase;
import com.stimulsoft.report.StiBlocklyHelper;
import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiScriptHelper;
import com.stimulsoft.report.StiStatesManager;
import com.stimulsoft.report.components.StiBandInteraction;
import com.stimulsoft.report.components.StiBookmark;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiCrossHeaderInteraction;
import com.stimulsoft.report.components.StiInteraction;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiRestrictionsHelper;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.components.bands.StiColumnFooterBand;
import com.stimulsoft.report.components.bands.StiColumnHeaderBand;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.bands.StiDynamicBand;
import com.stimulsoft.report.components.bands.StiFooterBand;
import com.stimulsoft.report.components.bands.StiGroupFooterBand;
import com.stimulsoft.report.components.bands.StiGroupHeaderBand;
import com.stimulsoft.report.components.bands.StiHeaderBand;
import com.stimulsoft.report.components.bands.StiPageFooterBand;
import com.stimulsoft.report.components.bands.StiPageHeaderBand;
import com.stimulsoft.report.components.bands.StiReportSummaryBand;
import com.stimulsoft.report.components.bands.StiReportTitleBand;
import com.stimulsoft.report.components.complexcomponents.StiClone;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.complexcomponents.StiPanel;
import com.stimulsoft.report.components.complexcomponents.StiSubReport;
import com.stimulsoft.report.components.conditions.StiCondition;
import com.stimulsoft.report.components.conditions.StiConditionHelper;
import com.stimulsoft.report.components.conditions.StiConditionsCollection;
import com.stimulsoft.report.components.enums.StiAnchorMode;
import com.stimulsoft.report.components.enums.StiComponentPriority;
import com.stimulsoft.report.components.enums.StiComponentType;
import com.stimulsoft.report.components.enums.StiConditionBorderSides;
import com.stimulsoft.report.components.enums.StiConditionPermissions;
import com.stimulsoft.report.components.enums.StiDockStyle;
import com.stimulsoft.report.components.enums.StiPrintOnType;
import com.stimulsoft.report.components.enums.StiRestrictions;
import com.stimulsoft.report.components.enums.StiShiftMode;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiBrush;
import com.stimulsoft.report.components.interfaces.IStiCanGrow;
import com.stimulsoft.report.components.interfaces.IStiCanShrink;
import com.stimulsoft.report.components.interfaces.IStiComponentGuid;
import com.stimulsoft.report.components.interfaces.IStiConditions;
import com.stimulsoft.report.components.interfaces.IStiCrossTab;
import com.stimulsoft.report.components.interfaces.IStiCrossTabField;
import com.stimulsoft.report.components.interfaces.IStiFont;
import com.stimulsoft.report.components.interfaces.IStiGrowToHeight;
import com.stimulsoft.report.components.interfaces.IStiInteraction;
import com.stimulsoft.report.components.interfaces.IStiPrintOn;
import com.stimulsoft.report.components.interfaces.IStiSelect;
import com.stimulsoft.report.components.interfaces.IStiShift;
import com.stimulsoft.report.components.interfaces.IStiText;
import com.stimulsoft.report.components.interfaces.IStiTextBrush;
import com.stimulsoft.report.components.interfaces.IStiUnitConvert;
import com.stimulsoft.report.crossTab.StiCrossCell;
import com.stimulsoft.report.crossTab.StiCrossHeader;
import com.stimulsoft.report.dialogs.IStiReportControl;
import com.stimulsoft.report.engine.IStiReportProperty;
import com.stimulsoft.report.engine.StiEngineVersion;
import com.stimulsoft.report.engine.engineV2.StiBookmarksV2Helper;
import com.stimulsoft.report.engine.engineV2.builders.StiDataBandV2Builder;
import com.stimulsoft.report.engine.engineV2.builders.StiFooterBandV2Builder;
import com.stimulsoft.report.engine.engineV2.builders.StiHeaderBandV2Builder;
import com.stimulsoft.report.engine.engineV2.builders.StiV2Builder;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.enums.StiCalculationMode;
import com.stimulsoft.report.enums.StiEventFlags;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.enums.StiReportPass;
import com.stimulsoft.report.events.StiAfterPrintEvent;
import com.stimulsoft.report.events.StiBeforePrintEvent;
import com.stimulsoft.report.events.StiClickEvent;
import com.stimulsoft.report.events.StiDoubleClickEvent;
import com.stimulsoft.report.events.StiEvent;
import com.stimulsoft.report.events.StiEventsCollection;
import com.stimulsoft.report.events.StiGetBookmarkEvent;
import com.stimulsoft.report.events.StiGetDrillDownReportEvent;
import com.stimulsoft.report.events.StiGetDrillDownReportEventArgs;
import com.stimulsoft.report.events.StiGetHyperlinkEvent;
import com.stimulsoft.report.events.StiGetTagEvent;
import com.stimulsoft.report.events.StiGetToolTipEvent;
import com.stimulsoft.report.events.StiMouseEnterEvent;
import com.stimulsoft.report.events.StiMouseLeaveEvent;
import com.stimulsoft.report.events.StiPaintEventArgs;
import com.stimulsoft.report.events.StiValueEventArgs;
import com.stimulsoft.report.expressions.StiBookmarkExpression;
import com.stimulsoft.report.expressions.StiHyperlinkExpression;
import com.stimulsoft.report.expressions.StiPointerExpression;
import com.stimulsoft.report.expressions.StiTagExpression;
import com.stimulsoft.report.expressions.StiToolTipExpression;
import com.stimulsoft.report.expressions.StiUnifiedExpression;
import com.stimulsoft.report.helpers.StiAppExpressionParser;
import com.stimulsoft.report.painters.StiPaintArgs;
import com.stimulsoft.report.painters.StiPainter;
import com.stimulsoft.report.styles.StiBaseStyle;
import com.stimulsoft.report.units.StiUnit;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;

public abstract class StiComponent
extends StiBase
implements IStiComponentGuid,
IStiCanGrow,
IStiCanShrink,
IStiUnitConvert,
IStiShift,
IStiGrowToHeight,
IStiConditions,
IStiPrintOn,
IStiInherited,
IStiReportProperty,
IStiInteraction,
IStiStateSaveRestore,
IStiSelect,
IStiJsonReportObject,
IStiAppExpressionCollection {
    static Logger LOG = Logger.getLogger("com.stimulsoft.report.components.StiComponent");
    private static final Object EventAfterPrint = new Object();
    private static final Object EventBeforePrint = new Object();
    private static final Object EventClick = new Object();
    private static final Object EventDoubleClick = new Object();
    private static final Object EventgetBookmark = new Object();
    private static final Object EventgetDrillDownReport = new Object();
    private static final Object EventgetHyperlink = new Object();
    private static final Object EventgetTag = new Object();
    private static final Object EventgetToolTip = new Object();
    private static final Object EventMouseEnter = new Object();
    private static final Object EventMouseLeave = new Object();
    private static final Object EventPainted = new Object();
    private static final Object EventPainting = new Object();
    protected static Object PropertyComponentStyle = new Object();
    protected static Object PropertyDelimiterComponent = new Object();
    protected static Object PropertyDockable = new Object();
    protected static Object PropertyInherited = new Object();
    protected static Object PropertyLinked = new Object();
    protected static Object PropertyLocked = new Object();
    protected static Object PropertyMaxSize = new Object();
    protected static Object PropertyMinSize = new Object();
    protected static Object PropertyPlaceOnToolbox = new Object();
    protected static Object PropertyRenderedCount = new Object();
    protected static Object PropertyRestrictions = new Object();
    protected static Object PropertySelectionTick = new Object();
    protected static Object PropertyShowQuickButtons = new Object();
    protected static Object PropertyUseParentStyles = new Object();
    private String alias = "";
    private BitsComponent bits;
    public boolean canGrow;
    public boolean canShrink;
    public String componentPlacement = "";
    public StiConditionsCollection conditions = new StiConditionsCollection();
    private StiBookmark currentBookmark;
    private boolean disableCheckWidthHeight = false;
    private HashMap<String, Object> drillDownParameters = new HashMap();
    private boolean growToHeight;
    private String guid;
    public StiInteraction interaction;
    public boolean isRendered;
    private boolean isSelected;
    private StiStatesManager states = null;
    private StiBeforePrintEvent stiBeforePrintEvent = new StiBeforePrintEvent(this);
    public StiPage page;
    public StiContainer parent;
    public StiBookmark parentBookmark;
    private StiPrintOnType printOn = StiPrintOnType.AllPages;
    private StiEnumSet<StiShiftMode> shiftMode = StiEnumSet.of((Enum)StiShiftMode.IncreasingSize);
    private double height;
    public double width;
    private double left;
    public double top;
    private StiEnumSet<StiAnchorMode> anchor = StiEnumSet.of((Enum)StiAnchorMode.Left, (Enum)StiAnchorMode.Top);
    public StiAppExpressionCollection expressions = new StiAppExpressionCollection();
    private Object pointerValue;
    private StiPointerExpression pointer;
    public StiBookmark parentPointer;
    public StiBookmark currentPointer;
    protected int eventFlags = 0;

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyStringNullOfEmpty("Name", this.getName());
        jObject.AddPropertyEnum("ShiftMode", this.getShiftMode(), (IStiEnum)StiShiftMode.IncreasingSize);
        jObject.AddPropertyStringNullOfEmpty("Guid", this.getGuid());
        jObject.AddPropertyEnum("PrintOn", (Enum)this.getPrintOn(), (Enum)StiPrintOnType.AllPages);
        jObject.AddPropertyBool("CanShrink", this.getCanShrink());
        jObject.AddPropertyBool("CanGrow", this.getCanGrow());
        jObject.AddPropertyBool("GrowToHeight", this.getGrowToHeight());
        jObject.AddPropertyBool("Inherited", this.getInherited());
        jObject.AddPropertyBool("Printable", this.getPrintable(), true);
        jObject.AddPropertyEnum("DockStyle", (Enum)this.getDockStyle(), (Enum)StiDockStyle.None);
        jObject.AddPropertyStringNullOfEmpty("MinSize", StiJsonReportObjectHelper.Serialize.sizeD((StiSize)this.getMinSize()));
        jObject.AddPropertyStringNullOfEmpty("MaxSize", StiJsonReportObjectHelper.Serialize.sizeD((StiSize)this.getMaxSize()));
        jObject.AddPropertyStringNullOfEmpty("ClientRectangle", StiJsonReportObjectHelper.Serialize.rectangleD((StiRectangle)this.getClientRectangle()));
        jObject.AddPropertyJObject("GetToolTipEvent", this.getGetToolTipEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetHyperlinkEvent", this.getGetHyperlinkEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetTagEvent", this.getGetTagEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetBookmarkEvent", this.getGetBookmarkEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("BeforePrintEvent", this.getBeforePrintEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("AfterPrintEvent", this.getAfterPrintEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetDrillDownReportEvent", this.getGetDrillDownReportEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("ClickEvent", this.getClickEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("DoubleClickEvent", this.getDoubleClickEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("MouseEnterEvent", this.getMouseEnterEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("MouseLeaveEvent", this.getMouseLeaveEvent().SaveToJsonObject(mode));
        jObject.AddPropertyStringNullOfEmpty("Alias", this.getAlias());
        jObject.AddPropertyEnum("Restrictions", this.getRestrictions(), (IStiEnum)StiRestrictions.All);
        jObject.AddPropertyStringNullOfEmpty("ComponentPlacement", this.getComponentPlacement());
        jObject.AddPropertyStringNullOfEmpty("ComponentStyle", this.getComponentStyle());
        jObject.AddPropertyBool("Locked", this.getLocked());
        jObject.AddPropertyBool("Linked", this.getLinked());
        jObject.AddPropertyBool("Enabled", this.getEnabled(), true);
        jObject.AddPropertyBool("UseParentStyles", this.getUseParentStyles());
        if (mode == StiJsonSaveMode.Report) {
            jObject.AddPropertyJObject("Conditions", this.getConditions().SaveToJsonObject(mode));
            if (this.getInteraction() != null) {
                jObject.AddPropertyJObject("Interaction", this.getInteraction().SaveToJsonObject(mode));
            }
            if (this.getExpressions() != null) {
                jObject.AddPropertyJObject("Expressions", this.getExpressions().SaveToJsonObject(mode));
            }
            jObject.AddPropertyJObject("Bookmark", this.getBookmark().SaveToJsonObject(mode));
            jObject.AddPropertyJObject("ToolTip", this.getToolTip().SaveToJsonObject(mode));
            jObject.AddPropertyJObject("Hyperlink", this.getHyperlink().SaveToJsonObject(mode));
            jObject.AddPropertyJObject("Tag", this.getTag().SaveToJsonObject(mode));
            jObject.AddPropertyJObject("Pointer", this.getPointer().SaveToJsonObject(mode));
        }
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject JSONObject2) throws JSONException {
        for (JProperty property : JSONObject2.Properties()) {
            StiUnifiedExpression expression;
            StiEvent _event;
            if (property.Name.equals("Name")) {
                super.setName(property.Value.toString());
                continue;
            }
            if (property.Name.equals("ShiftMode")) {
                this.shiftMode = StiEnumSet.stringToEnums(StiShiftMode.class, (String)property.Value.toString());
                continue;
            }
            if (property.Name.equals("Guid")) {
                this.guid = property.Value.toString();
                continue;
            }
            if (property.Name.equals("PrintOn")) {
                this.printOn = StiPrintOnType.valueOf(property.Value.toString());
                continue;
            }
            if (property.Name.equals("CanShrink")) {
                this.canShrink = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("CanGrow")) {
                this.canGrow = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("GrowToHeight")) {
                this.growToHeight = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("Conditions")) {
                this.getConditions().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("Inherited")) {
                this.setInherited((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("Interaction")) {
                this.setInteraction(StiInteraction.LoadInteractionFromJsonObject((JSONObject)property.Value));
                continue;
            }
            if (property.Name.equals("Printable")) {
                this.setPrintable((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("DockStyle")) {
                this.setDockStyle(StiDockStyle.valueOf(property.Value.toString()));
                continue;
            }
            if (property.Name.equals("MinSize")) {
                this.setMinSize(StiJsonReportObjectHelper.Deserialize.SizeD((JProperty)property));
                continue;
            }
            if (property.Name.equals("MaxSize")) {
                this.setMaxSize(StiJsonReportObjectHelper.Deserialize.SizeD((JProperty)property));
                continue;
            }
            if (property.Name.equals("ClientRectangle")) {
                this.setClientRectangle(StiJsonReportObjectHelper.Deserialize.RectangleD((JProperty)property));
                continue;
            }
            if (property.Name.equals("GetToolTipEvent")) {
                _event = new StiGetToolTipEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setGetToolTipEvent((StiGetToolTipEvent)_event);
                continue;
            }
            if (property.Name.equals("GetHyperlinkEvent")) {
                _event = new StiGetHyperlinkEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setGetHyperlinkEvent((StiGetHyperlinkEvent)_event);
                continue;
            }
            if (property.Name.equals("GetTagEvent")) {
                _event = new StiGetTagEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setGetTagEvent((StiGetTagEvent)_event);
                continue;
            }
            if (property.Name.equals("GetBookmarkEvent")) {
                _event = new StiGetBookmarkEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setGetBookmarkEvent((StiGetBookmarkEvent)_event);
                continue;
            }
            if (property.Name.equals("BeforePrintEvent")) {
                _event = new StiBeforePrintEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setBeforePrintEvent((StiBeforePrintEvent)_event);
                continue;
            }
            if (property.Name.equals("AfterPrintEvent")) {
                _event = new StiAfterPrintEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setAfterPrintEvent((StiAfterPrintEvent)_event);
                continue;
            }
            if (property.Name.equals("GetDrillDownReportEvent")) {
                _event = new StiGetDrillDownReportEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setGetDrillDownReportEvent((StiGetDrillDownReportEvent)_event);
                continue;
            }
            if (property.Name.equals("ClickEvent")) {
                _event = new StiClickEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setClickEvent((StiClickEvent)_event);
                continue;
            }
            if (property.Name.equals("DoubleClickEvent")) {
                _event = new StiDoubleClickEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setDoubleClickEvent((StiDoubleClickEvent)_event);
                continue;
            }
            if (property.Name.equals("MouseEnterEvent")) {
                _event = new StiMouseEnterEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setMouseEnterEvent((StiMouseEnterEvent)_event);
                continue;
            }
            if (property.Name.equals("MouseLeaveEvent")) {
                _event = new StiMouseLeaveEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setMouseLeaveEvent((StiMouseLeaveEvent)_event);
                continue;
            }
            if (property.Name.equals("Bookmark")) {
                expression = new StiBookmarkExpression();
                expression.LoadFromJsonObject((JSONObject)property.Value);
                this.setBookmark((StiBookmarkExpression)expression);
                continue;
            }
            if (property.Name.equals("ToolTip")) {
                expression = new StiToolTipExpression();
                expression.LoadFromJsonObject((JSONObject)property.Value);
                this.setToolTip((StiToolTipExpression)expression);
                continue;
            }
            if (property.Name.equals("Hyperlink")) {
                expression = new StiHyperlinkExpression();
                expression.LoadFromJsonObject((JSONObject)property.Value);
                this.setHyperlink((StiHyperlinkExpression)expression);
                continue;
            }
            if (property.Name.equals("Tag")) {
                expression = new StiTagExpression();
                expression.LoadFromJsonObject((JSONObject)property.Value);
                this.setTag((StiTagExpression)expression);
                continue;
            }
            if (property.Name.equals("Pointer")) {
                expression = new StiPointerExpression();
                expression.LoadFromJsonObject((JSONObject)property.Value);
                this.setPointer((StiPointerExpression)expression);
                continue;
            }
            if (property.Name.equals("Alias")) {
                this.alias = property.Value.toString();
                continue;
            }
            if (property.Name.equals("Restrictions")) {
                this.setRestrictions((StiEnumSet<StiRestrictions>)StiEnumSet.stringToEnums(StiRestrictions.class, (String)property.Value.toString()));
                continue;
            }
            if (property.Name.equals("ComponentPlacement")) {
                this.componentPlacement = property.Value.toString();
                continue;
            }
            if (property.Name.equals("ComponentStyle")) {
                this.setComponentStyle(property.Value.toString());
                continue;
            }
            if (property.Name.equals("Locked")) {
                this.setLocked((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("Linked")) {
                this.setLinked((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("Enabled")) {
                this.setEnabled((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("UseParentStyles")) {
                this.setUseParentStyles((Boolean)property.Value);
                continue;
            }
            if (!property.Name.equals("Expressions")) continue;
            this.expressions.LoadFromJsonObject((JSONObject)property.Value);
        }
    }

    public boolean getAllowDelete() {
        return !this.getInherited() && StiRestrictionsHelper.isAllowDelete(this);
    }

    public boolean DoBookmark() {
        return this.doGetBookmark();
    }

    public final boolean doGetBookmark() {
        boolean isGuidCreated = false;
        if (this.getBookmarkValue() == null && this.getBookmark().getValue().length() > 0) {
            StiValueEventArgs args = new StiValueEventArgs();
            Object parserResult = StiScriptHelper.parseTextValue(this.getBookmark().getValue(), this);
            args.setValue(this.getReport().ToString(parserResult));
            if (args.getValue() instanceof String && ((String)args.getValue()).length() > 0) {
                if (this.getReport() != null && this.getReport().getEngineVersion() == StiEngineVersion.EngineV2) {
                    this.NewGuid();
                    isGuidCreated = true;
                    String text = (String)(args.getValue() instanceof String ? args.getValue() : null);
                    if (text.length() > 2 && text.charAt(0) == '%') {
                        String bookmarkText = text.substring(0, 1);
                        String splitter = StiStringUtil.escape((String)String.valueOf(text.charAt(1)));
                        text = text.substring(2);
                        String[] strs = text.split(splitter);
                        StiBookmark processedBookmark = this.getReport().getBookmark();
                        for (int index = 0; index < strs.length; ++index) {
                            String str = strs[index];
                            bookmarkText = bookmarkText + splitter + str;
                            processedBookmark = StiBookmarksV2Helper.GetBookmark(processedBookmark, str);
                            if (index != strs.length - 1) continue;
                            processedBookmark.setComponentGuid(this.getGuid());
                        }
                        this.setCurrentBookmark(processedBookmark);
                    } else {
                        this.setCurrentBookmark(StiBookmarksV2Helper.CreateBookmark(text, this.getGuid()));
                        if (this.getParentBookmark() != null) {
                            this.getParentBookmark().getBookmarks().add(this.getCurrentBookmark());
                        }
                    }
                }
            } else {
                this.setCurrentBookmark(this.getParentBookmark());
            }
        } else {
            this.setCurrentBookmark(this.getParentBookmark());
        }
        return isGuidCreated;
    }

    public static StiRectangle DoOffsetRect(StiComponent component, StiRectangle rect, StiRectangle offsetRect) {
        if (component instanceof StiPage) {
            return rect;
        }
        if (!StiComponent.IsParentSelect(component) && component.getIsSelected()) {
            rect = rect.OffsetRect(offsetRect);
        }
        return rect;
    }

    public static boolean IsParentSelect(StiComponent component) {
        for (StiContainer parentComponent = component.getParent(); parentComponent != null && !(parentComponent instanceof StiPage); parentComponent = parentComponent.getParent()) {
            if (!parentComponent.getIsSelected()) continue;
            return true;
        }
        return false;
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="false")
    public boolean getIsSelected() {
        return this.isSelected;
    }

    public void setIsSelected(boolean value) {
        this.isSelected = value;
    }

    @Override
    public final void NewGuid() {
        this.guid = UUID.randomUUID().toString().replace("-", "");
    }

    public final void Reset() {
        this.setIsSelected(false);
    }

    public StiComponent() {
        this(StiRectangle.empty());
    }

    public StiComponent(StiRectangle rect) {
        this.setClientRectangle(rect);
        if (this instanceof StiDataBand || this instanceof StiGroupHeaderBand) {
            this.setInteraction(new StiBandInteraction());
        } else if (this instanceof StiCrossHeader) {
            this.setInteraction(new StiCrossHeaderInteraction());
        } else {
            this.setInteraction(new StiInteraction());
        }
    }

    public final void addSize(boolean leftToRightDirection) {
        StiContainer parent = null;
        parent = this instanceof StiPage ? (StiContainer)(this instanceof StiContainer ? this : null) : this.parent;
        if (leftToRightDirection) {
            if (this.getPage().getUnlimitedWidth()) {
                this.getPage().setSegmentPerWidth(this.getPage().getSegmentPerWidth() + 1);
            }
            StiContainer cont = parent;
            while (!(cont instanceof StiPage)) {
                StiRectangle rect = cont.getDockRegion(cont.getParent());
                cont.setWidth(cont.getWidth() + rect.width);
                if (cont.getRight() > rect.width) {
                    cont.setWidth(rect.width - cont.getLeft());
                }
                cont = cont.getParent();
            }
        } else {
            double heightDiscount = this.getPage().getHeight();
            this.getPage().setSegmentPerHeight(this.getPage().getSegmentPerHeight() + 1);
            heightDiscount = this.getPage().getHeight() - this.getHeight();
            if (!(this instanceof StiPage) && !(this instanceof StiBand)) {
                this.setHeight(this.getHeight() + heightDiscount);
            }
            StiContainer cont = parent;
            while (!(cont instanceof StiPage)) {
                StiRectangle rect = cont.getDockRegion(cont.getParent());
                cont.setHeight(cont.getHeight() + rect.getHeight());
                if (cont.getBottom() > rect.getHeight()) {
                    cont.setHeight(rect.getHeight() - cont.getTop());
                }
                cont = cont.getParent();
            }
            String codeName = "####UNLIMITED";
            StiContainer corrCont = new StiContainer();
            corrCont.setName(codeName);
            corrCont.setDockStyle(StiDockStyle.Top);
            corrCont.setHeight(this.getPage().getPageHeight() - this.getPage().getMargins().getTop() - this.getPage().getMargins().getBottom());
            double totalHeight = 0.0;
            int index = 0;
            while (index < this.getPage().getComponents().size()) {
                StiComponent comp = (StiComponent)this.getPage().getComponents().get(index);
                if (!comp.getName().equals(codeName) && comp.getDockStyle() == StiDockStyle.Top) {
                    if (comp.getHeight() + totalHeight > corrCont.getHeight()) break;
                    this.getPage().getComponents().remove(comp);
                    corrCont.getComponents().add(comp);
                    totalHeight += comp.getHeight();
                    continue;
                }
                ++index;
            }
            if (this.getPage().getUnlimitedBreakable()) {
                corrCont.setHeight(Math.max(totalHeight, corrCont.getHeight()));
            } else {
                corrCont.setHeight(totalHeight);
            }
            this.getPage().getComponents().add(index, corrCont);
        }
        this.getPage().DockToContainer();
    }

    protected final boolean AllowPrintOn() {
        if (this.getPrintOn() == StiPrintOnType.AllPages) {
            return true;
        }
        if (this.getReport() != null && this.getReport().getEngineVersion() == StiEngineVersion.EngineV2) {
            int pageNumber = this.getReport().getPageNumber();
            int totalPageCount = this.getReport().getTotalPageCount();
            if (!StiOptions.Engine.getUseAdvancedPrintOnEngineV2()) {
                if ((this.getPrintOn().getValue() & StiPrintOnType.ExceptFirstPage.getValue()) > 0 && pageNumber == 1) {
                    return false;
                }
                return this.getPrintOn() != StiPrintOnType.OnlyFirstPage || pageNumber <= 1;
            }
            if (this.getPage().getSegmentPerWidth() > 1 || this.getPage().getSegmentPerHeight() > 1) {
                pageNumber += this.getPage().getSegmentPerWidth() * this.getPage().getSegmentPerHeight() - 1;
            }
            if (this.getReport().getReportPass() == StiReportPass.First) {
                if ((this.getPrintOn().getValue() & StiPrintOnType.OnlyLastPage.getValue()) > 0) {
                    return false;
                }
                if ((this.getPrintOn().getValue() & StiPrintOnType.ExceptLastPage.getValue()) > 0) {
                    return true;
                }
            }
            if ((this.getPrintOn().getValue() & StiPrintOnType.ExceptFirstPage.getValue()) > 0 && pageNumber == 1) {
                return false;
            }
            if (this.getPrintOn() == StiPrintOnType.OnlyFirstAndLastPage) {
                return pageNumber <= 1 || pageNumber >= totalPageCount;
            }
            if ((this.getPrintOn().getValue() & StiPrintOnType.OnlyFirstPage.getValue()) > 0 && pageNumber > 1) {
                return false;
            }
            if ((this.getPrintOn().getValue() & StiPrintOnType.OnlyLastPage.getValue()) > 0 && pageNumber < totalPageCount) {
                return false;
            }
            return (this.getPrintOn().getValue() & StiPrintOnType.ExceptLastPage.getValue()) <= 0 || pageNumber != totalPageCount;
        }
        if (!StiOptions.Engine.getUseAdvancedPrintOn()) {
            return true;
        }
        if (this.getReport() == null) {
            return true;
        }
        int pageNumber = this.getReport().getPageNumber();
        int totalPageCount = this.getReport().getTotalPageCount();
        if (this.getPage().getSegmentPerWidth() > 1 || this.getPage().getSegmentPerHeight() > 1) {
            pageNumber += this.getPage().getSegmentPerWidth() * this.getPage().getSegmentPerHeight() - 1;
        }
        if (this.getReport().getReportPass() == StiReportPass.First) {
            if ((this.getPrintOn().getValue() & StiPrintOnType.OnlyLastPage.getValue()) > 0) {
                return false;
            }
            if ((this.getPrintOn().getValue() & StiPrintOnType.ExceptLastPage.getValue()) > 0) {
                return true;
            }
        }
        if ((this.getPrintOn().getValue() & StiPrintOnType.ExceptFirstPage.getValue()) > 0 && pageNumber == 1) {
            return false;
        }
        if (this.getPrintOn().getValue() == StiPrintOnType.OnlyFirstAndLastPage.getValue()) {
            return pageNumber <= 1 || pageNumber >= totalPageCount;
        }
        if ((this.getPrintOn().getValue() & StiPrintOnType.OnlyFirstPage.getValue()) > 0 && pageNumber > 1) {
            return false;
        }
        if ((this.getPrintOn().getValue() & StiPrintOnType.OnlyLastPage.getValue()) > 0 && pageNumber < totalPageCount) {
            return false;
        }
        return (this.getPrintOn().getValue() & StiPrintOnType.ExceptLastPage.getValue()) <= 0 || pageNumber != totalPageCount;
    }

    public final void applyConditions(Object sender, ArrayList<Hashtable<StiCondition, String>> conditions) {
        if (conditions == null) {
            return;
        }
        for (Hashtable<StiCondition, String> conditionTable : conditions) {
            Map.Entry<StiCondition, String> element = conditionTable.entrySet().iterator().next();
            Object result = StiParser.ParseTextValue(element.getValue(), this);
            if (!(result instanceof Boolean) || !((Boolean)result).booleanValue()) continue;
            StiCondition condition = element.getKey();
            if (condition.getStyle() != null && condition.getStyle().length() > 0) {
                StiConditionHelper.Apply(sender, condition.getStyle());
            } else {
                IStiFont font;
                IStiTextBrush textBrush;
                IStiBorder border;
                IStiBrush brush = (IStiBrush)(sender instanceof IStiBrush ? sender : null);
                if (brush != null && condition.getPermissions().contains((IStiEnum)StiConditionPermissions.BackColor)) {
                    brush.setBrush((StiBrush)new StiSolidBrush(condition.getBackColor()));
                }
                if ((border = (IStiBorder)(sender instanceof IStiBorder ? sender : null)) != null && condition.getPermissions().contains((IStiEnum)StiConditionPermissions.Borders) && condition.getBorderSides().notContains((IStiEnum)StiConditionBorderSides.NotAssigned)) {
                    border.setBorder((StiBorder)border.getBorder().clone());
                    border.getBorder().setSide(StiEnumSet.stringToEnums(StiBorderSides.class, (String)condition.getBorderSides().toString()));
                }
                if ((textBrush = (IStiTextBrush)(sender instanceof IStiTextBrush ? sender : null)) != null && condition.getPermissions().contains((IStiEnum)StiConditionPermissions.TextColor)) {
                    textBrush.setTextBrush((StiBrush)new StiSolidBrush(condition.getTextColor()));
                }
                if ((font = (IStiFont)(sender instanceof IStiFont ? sender : null)) != null) {
                    StiConditionHelper.ApplyFont(sender, condition.getFont(), condition.getPermissions());
                }
            }
            if ((condition.getPermissions().getIntValue() & StiConditionPermissions.Enabled.getValue()) == 0) {
                ((StiComponent)sender).setEnabled(condition.getEnabled());
            }
            if (!condition.getBreakIfTrue().booleanValue()) continue;
            break;
        }
    }

    public boolean canContainIn(StiComponent component) {
        if (component instanceof IStiCrossTab) {
            return this instanceof IStiCrossTabField;
        }
        if (component instanceof IStiReportControl) {
            return false;
        }
        if (!(component instanceof StiContainer)) {
            return false;
        }
        if (component instanceof StiClone) {
            return false;
        }
        return !(component instanceof StiSubReport);
    }

    public final boolean CheckForParentComponent(StiComponent comp) {
        if (this.getParent() == null) {
            return false;
        }
        if (this.getParent() == comp) {
            return true;
        }
        return this.getParent().CheckForParentComponent(comp);
    }

    public void paint(StiPaintArgs e) {
        StiPainter painter = StiPainter.getPainter(this);
        painter.paint(this, e);
    }

    private double CheckHeight(double height) {
        if (!this.disableCheckWidthHeight) {
            if (this.getMinSize().height != 0.0) {
                height = Math.max(this.getMinSize().height, height);
            }
            if (this.getMaxSize().height != 0.0) {
                height = Math.min(this.getMaxSize().height, height);
            }
        }
        return height;
    }

    private double CheckWidth(double width) {
        if (!this.disableCheckWidthHeight) {
            if (this.getMinSize().width != 0.0) {
                width = Math.max(this.getMinSize().width, width);
            }
            if (this.getMaxSize().width != 0.0) {
                width = Math.min(this.getMaxSize().width, width);
            }
        }
        return width;
    }

    public void ClearAllStates() {
        this.setStates(null);
    }

    public final void ClearContents() {
        StiContainer container;
        IStiText text = (IStiText)((Object)(this instanceof IStiText ? this : null));
        if (text != null && this.getIsSelected()) {
            text.setTextInternal("");
        }
        if ((container = (StiContainer)(this instanceof StiContainer ? this : null)) != null) {
            for (StiComponent component : container.getComponents()) {
                component.ClearContents();
            }
        }
    }

    public Object clone() {
        return this.clone(true);
    }

    public Object clone(boolean clonegetProperties) {
        StiComponent comp = (StiComponent)super.clone();
        comp.conditions = this.conditions != null ? (StiConditionsCollection)this.conditions.clone() : null;
        comp.interaction = this.interaction != null ? (StiInteraction)this.interaction.clone() : null;
        if (comp.interaction != null) {
            comp.interaction.ParentComponent = comp;
        }
        if (clonegetProperties) {
            comp.setProperties((StiRepositoryItems)this.getProperties().clone());
        }
        if (this.bits != null) {
            comp.bits = (BitsComponent)this.bits.clone();
        }
        return comp;
    }

    public final double ComponentToPage(double value) {
        return this.ComponentToPage(new StiPoint(0.0, value)).getY();
    }

    public final StiPoint ComponentToPage(StiPoint point) {
        StiContainer container = this.getParent();
        if (container != null) {
            return this.getParent().ContainerToPage(point);
        }
        return point;
    }

    public final StiRectangle ComponentToPage(StiRectangle rect) {
        StiContainer container = this.getParent();
        if (container != null) {
            return this.getParent().ContainerToPage(rect);
        }
        return rect;
    }

    public boolean doBookmark() {
        return this.DoBookmark();
    }

    public void DockToContainer() {
        StiContainer container;
        if (this.getDockStyle() != StiDockStyle.None && this.getDockable() && (this.getIsDesigning() || this.getEnabled())) {
            if (this.getIsCross()) {
                this.setClientRectangle(this.DockToContainer(this.getClientRectangle()));
            } else {
                this.setDisplayRectangle(this.DockToContainer(this.getDisplayRectangle()));
            }
        }
        if ((container = (StiContainer)(this instanceof StiContainer ? this : null)) != null) {
            for (StiComponent component : container.getComponents()) {
                component.DockToContainer();
            }
        }
    }

    public StiRectangle DockToContainer(StiRectangle rect) {
        if (this.getParent() != null && this.getDockStyle() != StiDockStyle.None && this.getDockable()) {
            StiRectangle contRect = this.getDockRegion(this.getParent());
            switch (this.getDockStyle()) {
                case Left: {
                    rect.x = contRect.x;
                    rect.y = contRect.y;
                    rect.height = contRect.height;
                    break;
                }
                case Right: {
                    rect.x = contRect.getRight() - rect.width;
                    rect.y = contRect.y;
                    rect.height = contRect.height;
                    break;
                }
                case Top: {
                    rect.x = contRect.x;
                    rect.y = contRect.y;
                    rect.width = contRect.width;
                    break;
                }
                case Bottom: {
                    rect.x = contRect.x;
                    rect.y = contRect.getBottom() - rect.height;
                    rect.width = contRect.width;
                    break;
                }
                case Fill: {
                    rect.x = contRect.x;
                    rect.y = contRect.y;
                    rect.width = contRect.width;
                    rect.height = contRect.height;
                }
            }
        }
        return rect;
    }

    public StiSize getActualSize() {
        return new StiSize(this.getWidth(), this.getHeight());
    }

    @StiSerializable
    public StiAfterPrintEvent getAfterPrintEvent() {
        return new StiAfterPrintEvent(this);
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public String getAlias() {
        return this.alias;
    }

    @StiSerializable
    public StiBeforePrintEvent getBeforePrintEvent() {
        return this.stiBeforePrintEvent;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiBookmarkExpression getBookmark() {
        return new StiBookmarkExpression(this, "Bookmark");
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument, shortName="bookmark")
    public final String getBookmarkValue() {
        if (this.bits == null) {
            return null;
        }
        return this.bits.bookmarkValue;
    }

    public double getBottom() {
        return this.getTop() + this.getHeight();
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="false")
    public boolean getCanGrow() {
        return this.canGrow;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getCanShrink() {
        return this.canShrink;
    }

    @StiSerializable
    public StiClickEvent getClickEvent() {
        return new StiClickEvent(this);
    }

    @StiSerializable
    public StiRectangle getClientRectangle() {
        return new StiRectangle(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
    }

    @StiSerializable(shortName="pl")
    @StiDefaulValue(value="")
    public String getComponentPlacement() {
        return this.componentPlacement;
    }

    public final void fillComponentPlacement() {
        this.componentPlacement = this.getParent().getComponentPlacementForChildren();
    }

    @StiSerializable
    @StiDefaulValue(value="")
    public String getComponentStyle() {
        return (String)this.getProperties().get(PropertyComponentStyle, (Object)"");
    }

    public StiBaseStyle GetComponentStyle() {
        if (StiValidationUtil.isNullOrWhiteSpace((String)this.getComponentStyle()) || this.getReport() == null) {
            return null;
        }
        return this.getReport().getStyles().get(this.getComponentStyle());
    }

    public StiComponentType getComponentType() {
        return StiComponentType.Simple;
    }

    @Override
    @StiSerializable
    public StiConditionsCollection getConditions() {
        return this.conditions;
    }

    public StiContainer getContainer() {
        StiContainer obj = this.getParent();
        if (obj == null) {
            return null;
        }
        while (obj != null && !(obj instanceof StiContainer) && !(obj instanceof StiPage)) {
            obj = obj.getParent();
        }
        if (obj instanceof StiContainer) {
            return obj;
        }
        if (obj instanceof StiPage) {
            return obj;
        }
        return obj.page;
    }

    public final StiBookmark getCurrentBookmark() {
        return this.currentBookmark;
    }

    public StiDataBand getDataBand() {
        StiContainer obj = this.getParent();
        if (obj == null) {
            return null;
        }
        while (obj != null && !(obj instanceof StiDataBand) && !(obj instanceof StiPage)) {
            StiFooterBand footer;
            StiComponent pageFooterMaster;
            StiComponent reportSummaryMaster;
            StiComponent pageHeaderMaster;
            StiComponent reportTitleMaster;
            StiReportTitleBand reportTitle = (StiReportTitleBand)(obj instanceof StiReportTitleBand ? obj : null);
            if (reportTitle != null && (reportTitleMaster = reportTitle.GetMaster()) != null) {
                return (StiDataBand)(reportTitleMaster instanceof StiDataBand ? reportTitleMaster : null);
            }
            StiPageHeaderBand pageHeader = (StiPageHeaderBand)(obj instanceof StiPageHeaderBand ? obj : null);
            if (pageHeader != null && (pageHeaderMaster = pageHeader.GetMaster()) != null) {
                return (StiDataBand)(pageHeaderMaster instanceof StiDataBand ? pageHeaderMaster : null);
            }
            StiReportSummaryBand reportSummary = (StiReportSummaryBand)(obj instanceof StiReportSummaryBand ? obj : null);
            if (reportSummary != null && (reportSummaryMaster = reportSummary.GetMaster()) != null) {
                return (StiDataBand)(reportSummaryMaster instanceof StiDataBand ? reportSummaryMaster : null);
            }
            StiPageFooterBand pageFooter = (StiPageFooterBand)(obj instanceof StiPageFooterBand ? obj : null);
            if (pageFooter != null && (pageFooterMaster = pageFooter.GetMaster()) != null) {
                return (StiDataBand)(pageFooterMaster instanceof StiDataBand ? pageFooterMaster : null);
            }
            StiHeaderBand header = (StiHeaderBand)(obj instanceof StiHeaderBand ? obj : null);
            if (header != null) {
                StiComponent headerMaster;
                StiComponent stiComponent = headerMaster = this.getReport() != null && this.getReport().getEngineVersion() == StiEngineVersion.EngineV1 ? StiHeaderBandV2Builder.getMaster(header) : StiHeaderBandV2Builder.getMaster(header);
                if (headerMaster != null) {
                    return (StiDataBand)(headerMaster instanceof StiDataBand ? headerMaster : null);
                }
            }
            if ((footer = (StiFooterBand)(obj instanceof StiFooterBand ? obj : null)) != null) {
                StiComponent footerMaster;
                StiComponent stiComponent = footerMaster = this.getReport() != null && this.getReport().getEngineVersion() == StiEngineVersion.EngineV1 ? StiFooterBandV2Builder.getMaster(footer) : StiFooterBandV2Builder.getMaster(footer);
                if (footerMaster != null) {
                    return (StiDataBand)(footerMaster instanceof StiDataBand ? footerMaster : null);
                }
            }
            obj = obj.getParent();
        }
        if (obj instanceof StiDataBand) {
            return (StiDataBand)obj;
        }
        return null;
    }

    public StiRectangle getDefaultClientRectangle() {
        return new StiRectangle(0L, 0L, 60L, 20L);
    }

    public final boolean getDelimiterComponent() {
        return this.getProperties().getBool(PropertyDelimiterComponent, false);
    }

    public StiRectangle getDisplayRectangle1() {
        StiRectangle rect = this.getDisplayRectangle();
        StiRectangle offsetRect = this.getPage().getOffsetRectangle();
        rect = StiComponent.DoOffsetRect(this, rect, this.getPage().getOffsetRectangle());
        rect = this.ComponentToPage(rect);
        rect = rect.getNormalize();
        return rect;
    }

    public StiRectangle getDisplayRectangle() {
        return new StiRectangle(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
    }

    public boolean getDockable() {
        return this.getProperties().getBool(PropertyDockable, true);
    }

    public StiRectangle getDockRegion(StiComponent parent) {
        return this.getDockRegion(parent, true);
    }

    public StiRectangle getDockRegion(StiComponent parent, boolean useColumns) {
        if (parent != null) {
            StiPage page = parent instanceof StiPage ? (StiPage)parent : null;
            StiRectangle contRect = parent.getClientRectangle();
            if (this.getReport() != null && this.getReport().getEngineVersion() == StiEngineVersion.EngineV1) {
                if ((this instanceof StiDynamicBand || this instanceof StiReportSummaryBand) && page != null && page.getColumns() > 1) {
                    contRect.setWidth(page.getColumnWidthM());
                }
            } else {
                if (this.getComponentType() != StiComponentType.Static && page != null && page.getColumns() > 1 && useColumns) {
                    contRect.setWidth(page.getColumnWidthM());
                }
                StiPanel panel = (StiPanel)(parent instanceof StiPanel ? parent : null);
                if (this.getComponentType() != StiComponentType.Static && panel != null && panel.getColumns() > 1 && useColumns) {
                    contRect.setWidth(panel.getColumnWidthM());
                }
            }
            if (parent.getIsSelected()) {
                contRect = StiComponent.DoOffsetRect(parent, contRect, parent.getPage().getOffsetRectangle());
            }
            contRect.setX(0.0);
            contRect.setY(0.0);
            StiContainer cont = (StiContainer)parent;
            for (StiComponent comp : cont.getComponents()) {
                if (!comp.getDockable() || !this.getIsDesigning() && !comp.getEnabled()) continue;
                if (comp == this) break;
                StiRectangle disRect = comp.getDisplayRectangle();
                if (comp.getIsSelected()) {
                    disRect = StiComponent.DoOffsetRect(comp, disRect, comp.getPage().getOffsetRectangle());
                }
                switch (comp.getDockStyle()) {
                    case Left: {
                        contRect.setX(contRect.getX() + disRect.getWidth());
                        contRect.setWidth(contRect.getWidth() - disRect.getWidth());
                        break;
                    }
                    case Right: {
                        contRect.setWidth(contRect.getWidth() - disRect.getWidth());
                        break;
                    }
                    case Top: {
                        contRect.y += disRect.height;
                        contRect.height -= disRect.height;
                        break;
                    }
                    case Bottom: {
                        contRect.setHeight(contRect.getHeight() - disRect.getHeight());
                    }
                }
            }
            return contRect;
        }
        return this.getClientRectangle();
    }

    @StiDefaulValue(value="None")
    @StiSerializable
    public StiDockStyle getDockStyle() {
        if (this.bits == null) {
            return StiDockStyle.None;
        }
        return this.bits.dockStyle;
    }

    @StiSerializable
    public StiDoubleClickEvent getDoubleClickEvent() {
        return new StiDoubleClickEvent(this);
    }

    public final HashMap<String, Object> getDrillDownParameters() {
        return this.drillDownParameters;
    }

    @StiSerializable(shortName="enabled")
    @StiDefaulValue(value="true")
    public boolean getEnabled() {
        if (this.bits == null) {
            return true;
        }
        return this.bits.enabled;
    }

    public StiEventsCollection getEvents() {
        StiEventsCollection events = new StiEventsCollection();
        if (this.getGetToolTipEvent() != null) {
            events.add(this.getGetToolTipEvent());
        }
        if (this.getGetHyperlinkEvent() != null) {
            events.add(this.getGetHyperlinkEvent());
        }
        if (this.getGetTagEvent() != null) {
            events.add(this.getGetTagEvent());
        }
        if (this.getGetBookmarkEvent() != null) {
            events.add(this.getGetBookmarkEvent());
        }
        if (this.getBeforePrintEvent() != null) {
            events.add(this.getBeforePrintEvent());
        }
        if (this.getAfterPrintEvent() != null) {
            events.add(this.getAfterPrintEvent());
        }
        if (this.getClickEvent() != null) {
            events.add(this.getClickEvent());
        }
        if (this.getMouseEnterEvent() != null) {
            events.add(this.getMouseEnterEvent());
        }
        if (this.getMouseLeaveEvent() != null) {
            events.add(this.getMouseLeaveEvent());
        }
        return events;
    }

    public boolean getForceRedrawAll() {
        return false;
    }

    @StiSerializable
    public StiGetBookmarkEvent getGetBookmarkEvent() {
        return new StiGetBookmarkEvent(this);
    }

    @StiSerializable
    public StiGetDrillDownReportEvent getGetDrillDownReportEvent() {
        return new StiGetDrillDownReportEvent(this);
    }

    @StiSerializable
    public StiGetHyperlinkEvent getGetHyperlinkEvent() {
        return new StiGetHyperlinkEvent(this);
    }

    @StiSerializable
    public StiGetTagEvent getGetTagEvent() {
        return new StiGetTagEvent(this);
    }

    @StiSerializable
    public StiGetToolTipEvent getGetToolTipEvent() {
        return new StiGetToolTipEvent(this);
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getGrowToHeight() {
        return this.growToHeight;
    }

    @Override
    @StiSerializable
    public String getGuid() {
        return this.guid;
    }

    public final StiHighlightState getHighlightState() {
        if (this.bits == null) {
            return StiHighlightState.Hide;
        }
        return this.bits.highlightState;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiHyperlinkExpression getHyperlink() {
        return new StiHyperlinkExpression(this, "Hyperlink");
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument, shortName="hyperlink")
    public final String getHyperlinkValue() {
        if (this.bits == null) {
            return null;
        }
        return this.bits.hyperlinkValue;
    }

    public final boolean getIsgetTagHandlerEmpty() {
        return this.getEvents().get(EventgetTag) == null;
    }

    public final boolean getIgnoreNamingRule() {
        if (this.bits == null) {
            return false;
        }
        return this.bits.ignoreNamingRule;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getInherited() {
        return this.getProperties().getBool(PropertyInherited, false);
    }

    @Override
    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiInteraction getInteraction() {
        return this.interaction;
    }

    public boolean getInvalidateOnMouseOver() {
        return false;
    }

    public final boolean getIsDesigning() {
        if (this.getReport() != null) {
            return this.getReport().getIsDesigning();
        }
        return false;
    }

    public boolean isDesigning() {
        return this.getIsDesigning();
    }

    public final boolean getIsEnabled() {
        return this.getEnabled() && this.AllowPrintOn();
    }

    public final boolean getIsEventEmpty() {
        StiEventsCollection events = this.getEvents();
        for (StiEvent ev : events) {
            if (ev.getScript().length() == 0) continue;
            return false;
        }
        return true;
    }

    public final boolean getIsExporting() {
        if (this.getReport() != null) {
            return this.getReport().getIsExporting();
        }
        return false;
    }

    public final boolean getIsPrinting() {
        if (this.getReport() != null) {
            return this.getReport().getIsPrinting();
        }
        return false;
    }

    public boolean getIsRendered() {
        return this.isRendered;
    }

    public double getLeft() {
        return this.left;
    }

    public final int getLevel() {
        StiContainer obj = this.getParent();
        int level = 1;
        while (obj != null) {
            obj = obj.getParent();
            ++level;
        }
        return level;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getLinked() {
        return this.getProperties().getBool(PropertyLinked, false);
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getLocked() {
        return this.getProperties().getBool(PropertyLocked, false);
    }

    @StiSerializable
    public StiSize getMaxSize() {
        return (StiSize)this.getProperties().get(PropertyMaxSize, (Object)StiSize.EMPTY);
    }

    public final StiGraphics getMeasureGraphics() {
        if (this.getReport() == null) {
            return StiReport.getGlobalMeasureGraphics();
        }
        return this.getReport().getReportMeasureGraphics();
    }

    @StiSerializable
    public StiSize getMinSize() {
        return (StiSize)this.getProperties().get(PropertyMinSize, (Object)StiSize.EMPTY);
    }

    @StiSerializable
    public StiMouseEnterEvent getMouseEnterEvent() {
        return new StiMouseEnterEvent(this);
    }

    @StiSerializable
    public StiMouseLeaveEvent getMouseLeaveEvent() {
        return new StiMouseLeaveEvent(this);
    }

    @StiDefaulValue(value="null")
    @StiSerializable(isRef=true, type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiPage getPage() {
        return this.page;
    }

    public StiRectangle getPaintRectangle() {
        return this.getPaintRectangle(true, true);
    }

    public final StiRectangle getPaintRectangle(boolean convertToHInches, boolean convertByZoom) {
        return new StiRectangle(this.getPaintRectangle(convertToHInches, convertByZoom, true));
    }

    public final StiRectangle getPaintRectangle(boolean convertToHInches, boolean convertByZoom, boolean docking) {
        if (this.getPage() != null) {
            StiRectangle result;
            if (docking) {
                if (this.getIsCross()) {
                    this.setClientRectangle(this.DockToContainer(this.getClientRectangle()));
                } else if (this.getDockStyle() != StiDockStyle.None && this.getDockable()) {
                    this.setDisplayRectangle(this.DockToContainer(this.getDisplayRectangle()));
                }
            }
            StiRectangle rect = this.getClientRectangle();
            rect = StiComponent.DoOffsetRect(this, rect, this.getPage().getOffsetRectangle());
            rect = this.ComponentToPage(rect);
            rect = rect.normalize();
            if (!convertToHInches) {
                StiRectangle result2;
                StiRectangle stiRectangle = result2 = convertByZoom ? rect.Multiply(this.getPage().getZoom()) : rect;
                if (this.getReport().getInfo().isExporting()) {
                    result2.setX(0.0);
                    result2.setY(0.0);
                }
                return result2;
            }
            StiRectangle stiRectangle = result = convertByZoom ? this.getPage().getUnit().ConvertToHInchesStiRectangle(rect).Multiply(this.getPage().getZoom()) : this.getPage().getUnit().ConvertToHInchesStiRectangle(rect);
            if (this.getReport().getInfo().isExporting()) {
                result.setX(0.0);
                result.setY(0.0);
            }
            return result;
        }
        return StiRectangle.empty();
    }

    @StiSerializable(isRef=true, type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiContainer getParent() {
        return this.parent;
    }

    public final StiBookmark getParentBookmark() {
        return this.parentBookmark;
    }

    public boolean getPlaceOnToolbox() {
        return this.getProperties().getBool(PropertyPlaceOnToolbox, false);
    }

    @StiDefaulValue(value="true")
    @StiSerializable(shortName="pr")
    public boolean getPrintable() {
        if (this.bits == null) {
            return true;
        }
        return this.bits.printable;
    }

    @Override
    @StiDefaulValue(value="AllPages")
    @StiSerializable
    public StiPrintOnType getPrintOn() {
        return this.printOn;
    }

    public int getPriority() {
        return StiComponentPriority.Component.getValue();
    }

    public String getQuickInfo() {
        switch (this.getReport().getInfo().getQuickInfoType()) {
            case ShowAliases: {
                if (this.getAlias() != null && this.getAlias().length() > 0) {
                    return this.getAlias();
                }
                return "";
            }
            case ShowEvents: {
                String evStrs = "";
                return evStrs;
            }
            case ShowComponentsNames: {
                return this.getAlias().length() == 0 ? this.getName() : this.getAlias();
            }
            case ShowFields: {
                IStiText text = (IStiText)((Object)(this instanceof IStiText ? this : null));
                if (text == null) {
                    return "";
                }
                int startIndex = text.getTextInternal().lastIndexOf(46);
                if (startIndex >= 0) {
                    return text.getTextInternal().substring(startIndex);
                }
                return "";
            }
            case ShowFieldsOnly: {
                return "";
            }
        }
        return "";
    }

    public BufferedImage getImage(Double zoom) {
        return this.getImage(zoom, StiExportFormat.None);
    }

    public BufferedImage getImage(Double zoom, StiExportFormat format) {
        StiPainter painter = StiPainter.getPainter(this);
        return painter.getImage(this, zoom, format);
    }

    public final int getRenderedCount() {
        return this.getProperties().getInt(PropertyRenderedCount, 0);
    }

    @Override
    public StiReport getReport() {
        if (this.getPage() != null) {
            return this.getPage().getReport();
        }
        return null;
    }

    @StiDefaulValue(value="All")
    @StiSerializable
    public StiEnumSet<StiRestrictions> getRestrictions() {
        return (StiEnumSet)this.getProperties().get(PropertyRestrictions, (Object)StiEnumSet.of((Enum)StiRestrictions.All));
    }

    public double getRight() {
        return this.getLeft() + this.getWidth();
    }

    @Override
    public int getSelectionTick() {
        return this.getProperties().getInt(PropertySelectionTick, 0);
    }

    public StiRectangle getSelectRectangle() {
        return this.getDisplayRectangle();
    }

    public String getServiceCategory() {
        return StiLocalization.get((String)"Report", (String)"Components");
    }

    public Class getServiceType() {
        return StiComponent.class;
    }

    @Override
    @StiDefaulValue(value="true")
    public boolean getShift() {
        return this.getShiftMode().containsOnly((IStiEnum)StiShiftMode.IncreasingSize);
    }

    @Override
    @StiDefaulValue(value="IncreasingSize")
    @StiSerializable
    public StiEnumSet<StiShiftMode> getShiftMode() {
        return this.shiftMode;
    }

    public final boolean getShowQuickButtons() {
        return this.getProperties().getBool(PropertyShowQuickButtons, false);
    }

    protected StiStatesManager getStates() {
        if (this.states == null) {
            this.states = new StiStatesManager();
        }
        return this.states;
    }

    @StiSerializable
    public StiTagExpression getTag() {
        return new StiTagExpression(this, "Tag");
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument)
    public Object getTagValue() {
        if (this.bits == null) {
            return null;
        }
        return this.bits.tagValue;
    }

    public String getTagStrValue() {
        return this.getTagValue() != null ? this.getTagValue().toString() : null;
    }

    public int getToolboxPosition() {
        return 0;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiToolTipExpression getToolTip() {
        return new StiToolTipExpression(this, "ToolTip");
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument, shortName="toolTip")
    public final String getToolTipValue() {
        if (this.bits == null) {
            return null;
        }
        return this.bits.toolTipValue;
    }

    public double getTop() {
        return this.top;
    }

    public void incrementtTop(double value) {
        this.top += value;
    }

    public void decrementTop(double value) {
        this.top -= value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getUseParentStyles() {
        return this.getProperties().getBool(PropertyUseParentStyles, false);
    }

    public double getWidth() {
        return this.width;
    }

    public void InvokeAfterPrint(Object sender, EventArgs e) {
    }

    protected Object invokeScript(StiEvent stiEvent) {
        return this.invokeScript(stiEvent, null);
    }

    protected Object invokeScript(StiEvent stiEvent, Object sender) {
        return this.invokeScript(stiEvent, sender, null);
    }

    protected Object invokeScript(StiEvent stiEvent, Object sender, EventArgs e) {
        if (e == null) {
            e = EventArgs.Empty;
        }
        return StiScriptHelper.invokeEventScript(this.getReport(), sender != null ? sender : this, stiEvent, e);
    }

    public void InvokeBeforePrint(Object sender, EventArgs e) {
        block15: {
            try {
                StiAppExpressionParser.processExpressions(this, false);
                this.OnBeforePrint(e);
                boolean isCompilationMode = true;
                if (this.getReport() != null) {
                    boolean bl = isCompilationMode = this.getReport().getCalculationMode() == StiCalculationMode.Compilation;
                }
                if (!isCompilationMode) {
                    Object obj;
                    if (this.getReport() != null && this.getReport().getEngine() != null && (obj = this.getReport().getEngine().getParserConversionStore().get("*StiConditionExpression*" + this.getName())) != null && !(this instanceof StiCrossCell)) {
                        this.applyConditions(sender, (ArrayList)(obj instanceof ArrayList ? obj : null));
                    }
                    if (this.interaction != null) {
                        StiComponent comp = (StiComponent)sender;
                        comp.drillDownParameters = new HashMap();
                        try {
                            if (!this.interaction.getDrillDownParameter1().isDefault()) {
                                comp.drillDownParameters.put(this.getInteraction().getDrillDownParameter1().getName(), StiScriptHelper.parseTextValue("{" + this.getInteraction().getDrillDownParameter1().getExpression().getValue() + "}", this));
                            }
                            if (!this.getInteraction().getDrillDownParameter2().isDefault()) {
                                comp.drillDownParameters.put(this.getInteraction().getDrillDownParameter2().getName(), StiScriptHelper.parseTextValue("{" + this.getInteraction().getDrillDownParameter2().getExpression().getValue() + "}", this));
                            }
                            if (!this.getInteraction().getDrillDownParameter3().isDefault()) {
                                comp.drillDownParameters.put(this.getInteraction().getDrillDownParameter3().getName(), StiScriptHelper.parseTextValue("{" + this.getInteraction().getDrillDownParameter3().getExpression().getValue() + "}", this));
                            }
                            if (!this.getInteraction().getDrillDownParameter4().isDefault()) {
                                comp.drillDownParameters.put(this.getInteraction().getDrillDownParameter4().getName(), StiScriptHelper.parseTextValue("{" + this.getInteraction().getDrillDownParameter4().getExpression().getValue() + "}", this));
                            }
                            if (!this.getInteraction().getDrillDownParameter5().isDefault()) {
                                comp.drillDownParameters.put(this.getInteraction().getDrillDownParameter5().getName(), StiScriptHelper.parseTextValue("{" + this.getInteraction().getDrillDownParameter5().getExpression().getValue() + "}", this));
                            }
                        }
                        catch (Exception e2) {
                            if (this.getReport() != null) {
                                String.format(String.format("Expression in DrillDown property of '%s' can't be evaluated!", this.getName()), new Object[0]);
                            }
                            LOG.severe(String.format("Expression in DrillDown property of '%s' can't be evaluated!", this.getName()));
                            e2.printStackTrace();
                        }
                    }
                }
                if ((this.eventFlags & StiEventFlags.BeforePrint.getValue()) > 0 || (this.eventFlags & StiEventFlags.Mark.getValue()) == 0) {
                    this.invokeScript(this.getBeforePrintEvent(), sender, e);
                    StiBlocklyHelper.invokeBlockly(this.getReport(), sender, this.getBeforePrintEvent());
                }
            }
            catch (RuntimeException ex) {
                if (StiOptions.Engine.logLevel < 10) break block15;
                ex.printStackTrace();
            }
        }
    }

    public void InvokeClick(Object sender, EventArgs e) {
    }

    public void InvokeDoubleClick(Object sender, EventArgs e) {
    }

    public void invokeEvents() {
        block16: {
            try {
                String value;
                if (this.getPointerValue() == null && this.getPointer().getValue().length() > 0) {
                    String parserResult = this.getReport().ToString(StiScriptHelper.parseTextValue(this.getPointer().getValue(), this));
                    this.setPointerValue(parserResult);
                }
                if (this.getBookmarkValue() == null && this.getBookmark().getValue().length() > 0) {
                    value = this.getReport().ToString(StiScriptHelper.parseTextValue(this.getBookmark().getValue(), this));
                    this.setBookmarkValue(value);
                    if ((this.eventFlags & StiEventFlags.GetBookmark.getValue()) > 0 || (this.eventFlags & StiEventFlags.Mark.getValue()) == 0) {
                        StiBlocklyHelper.invokeBlockly(this.getReport(), this, this.getGetBookmarkEvent(), null);
                        if (StiScriptHelper.isEventScript(this.getReport(), this.getGetBookmarkEvent())) {
                            StiValueEventArgs e = new StiValueEventArgs(this.getBookmarkValue());
                            this.invokeScript(this.getGetBookmarkEvent(), this, e);
                            this.setBookmarkValue(e.getValue() != null ? e.getValue().toString() : null);
                        }
                    }
                }
                if (this.getTagValue() == null && this.getTag().getValue().length() > 0) {
                    value = this.getReport().ToString(StiScriptHelper.parseTextValue(this.getTag().getValue(), this));
                    this.setTagValue(value);
                    if ((this.eventFlags & StiEventFlags.GetTag.getValue()) > 0 || (this.eventFlags & StiEventFlags.Mark.getValue()) == 0) {
                        StiBlocklyHelper.invokeBlockly(this.getReport(), this, this.getGetTagEvent(), null);
                        if (StiScriptHelper.isEventScript(this.getReport(), this.getGetTagEvent())) {
                            StiValueEventArgs e2 = new StiValueEventArgs(this.getTagValue());
                            this.invokeScript(this.getGetTagEvent(), this, e2);
                            this.setTagValue(e2.getValue());
                        }
                    }
                }
                if (this.getToolTipValue() == null && this.getToolTip().getValue().length() > 0) {
                    value = this.getReport().ToString(StiScriptHelper.parseTextValue(this.getToolTip().getValue(), this));
                    this.setToolTipValue(value);
                    if ((this.eventFlags & StiEventFlags.GetToolTip.getValue()) > 0 || (this.eventFlags & StiEventFlags.Mark.getValue()) == 0) {
                        StiBlocklyHelper.invokeBlockly(this.getReport(), this, this.getGetToolTipEvent(), null);
                        if (StiScriptHelper.isEventScript(this.getReport(), this.getGetToolTipEvent())) {
                            StiValueEventArgs e3 = new StiValueEventArgs(this.getToolTipValue());
                            this.invokeScript(this.getGetToolTipEvent(), this, e3);
                            this.setToolTipValue(e3.getValue() != null ? e3.getValue().toString() : null);
                        }
                    }
                }
                if (this.getHyperlinkValue() == null && this.getHyperlink().getValue().length() > 0) {
                    value = this.getReport().ToString(StiScriptHelper.parseTextValue(this.getHyperlink().getValue(), this));
                    this.setHyperlinkValue(value);
                    if ((this.eventFlags & StiEventFlags.GetHyperlink.getValue()) > 0 || (this.eventFlags & StiEventFlags.Mark.getValue()) == 0) {
                        StiBlocklyHelper.invokeBlockly(this.getReport(), this, this.getGetHyperlinkEvent(), null);
                        if (StiScriptHelper.isEventScript(this.getReport(), this.getGetHyperlinkEvent())) {
                            StiValueEventArgs e4 = new StiValueEventArgs(this.getHyperlinkValue());
                            this.invokeScript(this.getGetHyperlinkEvent(), this, e4);
                            this.setHyperlinkValue(e4.getValue() != null ? e4.getValue().toString() : null);
                        }
                    }
                }
                if (this instanceof StiPage && ((StiPage)this).getExcelSheetValue() == null && StiValidationUtil.isNotNullOrEmpty((String)((StiPage)this).getExcelSheet().getValue())) {
                    value = this.getReport().ToString(StiScriptHelper.parseTextValue(((StiPage)this).getExcelSheet().getValue(), this));
                    ((StiPage)this).setExcelSheetValue(value);
                }
            }
            catch (Exception e) {
                if (StiOptions.Engine.logLevel < 10) break block16;
                e.printStackTrace();
            }
        }
    }

    public final void InvokegetBookmark(Object sender, StiValueEventArgs e) {
        try {
            this.OngetBookmark(e);
            if ((this.eventFlags & StiEventFlags.GetBookmark.getValue()) > 0 || (this.eventFlags & StiEventFlags.Mark.getValue()) == 0) {
                this.invokeScript(this.getGetBookmarkEvent(), sender, e);
                StiBlocklyHelper.invokeBlockly(this.getReport(), sender, this.getGetBookmarkEvent(), e);
            }
        }
        catch (Exception ex) {
            StiLoggingUtil.printStackTrace((Exception)ex);
        }
    }

    public void InvokegetDrillDownReport(Object sender, StiGetDrillDownReportEventArgs e) {
    }

    public final void InvokegetHyperlink(Object sender, StiValueEventArgs e) {
        try {
            this.OngetHyperlink(e);
            this.invokeScript(this.getGetHyperlinkEvent(), sender, e);
            StiBlocklyHelper.invokeBlockly(this.getReport(), sender, this.getGetHyperlinkEvent(), e);
        }
        catch (Exception ex) {
            StiLoggingUtil.printStackTrace((Exception)ex);
        }
    }

    public final void InvokegetTag(Object sender, StiValueEventArgs e) {
        try {
            this.OngetTag(e);
            this.invokeScript(this.getGetTagEvent(), sender, e);
            StiBlocklyHelper.invokeBlockly(this.getReport(), sender, this.getGetTagEvent(), e);
        }
        catch (Exception ex) {
            StiLoggingUtil.printStackTrace((Exception)ex);
        }
    }

    public final void InvokegetToolTip(Object sender, StiValueEventArgs e) {
    }

    public void InvokeMouseEnter(Object sender, EventArgs e) {
    }

    public void InvokeMouseLeave(Object sender, EventArgs e) {
    }

    public final void InvokePainted(StiComponent sender, StiPaintEventArgs e) {
    }

    public final void invokePainting(StiComponent sender, StiPaintArgs e) {
    }

    public boolean isAutomaticDock() {
        return false;
    }

    public boolean getIsCross() {
        return false;
    }

    protected void OnAfterPrint(EventArgs e) {
    }

    protected void OnBeforePrint(EventArgs e) {
    }

    protected void OnClick(EventArgs e) {
    }

    protected void OnDoubleClick(EventArgs e) {
    }

    protected void OngetBookmark(StiValueEventArgs e) {
    }

    protected void OngetDrillDownReport(StiGetDrillDownReportEventArgs e) {
    }

    protected void OngetHyperlink(StiValueEventArgs e) {
    }

    protected void OngetTag(StiValueEventArgs e) {
    }

    protected void OngetToolTip(StiValueEventArgs e) {
    }

    protected void OnMouseEnter(EventArgs e) {
    }

    protected void OnMouseLeave(EventArgs e) {
    }

    protected void OnPainted(StiPaintEventArgs e) {
    }

    protected void OnPainting(StiPaintEventArgs e) {
    }

    public void OnRemoveComponent() {
    }

    public void packService() {
        super.packService();
        if (this.conditions != null && this.conditions.size() == 0) {
            this.conditions = null;
        }
    }

    public final StiPoint PageToComponent(StiPoint point) {
        StiContainer container = this.getParent();
        if (container != null) {
            return this.getParent().PageToContainer(point);
        }
        return point;
    }

    public final StiRectangle PageToComponent(StiRectangle rect) {
        StiContainer container = this.getParent();
        if (container != null) {
            return this.getParent().PageToContainer(rect);
        }
        return rect;
    }

    public final boolean PlacedOnColumnBand() {
        StiComponent obj = this;
        while (obj != null || !(obj instanceof StiPage)) {
            if (obj instanceof StiColumnFooterBand || obj instanceof StiColumnHeaderBand) {
                return true;
            }
            if (obj instanceof StiBand) {
                return false;
            }
            obj = obj.parent;
        }
        return false;
    }

    public void RestoreState(String stateName) {
        if (this.getStates().IsExist(stateName, this)) {
            this.setRenderedCount(this.getStates().PopInt(stateName, this, "renderedCount"));
            this.setIsRendered(this.getStates().PopBool(stateName, this, "isRendered"));
        }
    }

    @Override
    public void saveState(String stateName) {
        this.getStates().PushBool(stateName, this, "isRendered", this.getIsRendered());
        this.getStates().PushInt(stateName, this, "renderedCount", this.getRenderedCount());
    }

    public void setAfterPrintEvent(StiAfterPrintEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    public void setAlias(String value) {
        if (!this.alias.equals(value)) {
            this.alias = value.intern();
        }
    }

    public void setBeforePrintEvent(StiBeforePrintEvent value) {
        this.stiBeforePrintEvent = value;
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    public void setBookmark(StiBookmarkExpression value) {
        if (value != null) {
            value.set(this, "Bookmark", value.getValue());
        }
    }

    public final void setBookmarkValue(String value) {
        if (value == null && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.bookmarkValue = value;
        } else {
            this.bits = new BitsComponent(value, this.getToolTipValue(), this.getHyperlinkValue(), this.getTagValue(), this.getEnabled(), this.getHighlightState(), this.getIgnoreNamingRule(), this.getDockStyle(), this.getPrintable());
        }
    }

    @Override
    public void setCanGrow(boolean value) {
        this.canGrow = value;
    }

    @Override
    public void setCanShrink(boolean value) {
        this.canShrink = value;
    }

    public void setClickEvent(StiClickEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    public void setClientRectangle(StiRectangle value) {
        this.left = StiMath.round((double)value.getLeft(), (int)2);
        this.top = StiMath.round((double)value.getTop(), (int)2);
        this.width = this.CheckWidth(StiMath.round((double)value.getWidth(), (int)2));
        this.height = this.CheckHeight(StiMath.round((double)value.getHeight(), (int)2));
    }

    public final void setComponentPlacement(String value) {
        this.componentPlacement = value;
    }

    public void setComponentStyle(String value) {
        StiBaseStyle st;
        this.getProperties().set(PropertyComponentStyle, (Object)value, (Object)"");
        if (this.getReport() != null && (st = this.getReport().getStyles().getByName(value)) != null) {
            st.SetStyleToComponent(this);
        }
        if (this instanceof StiContainer) {
            ((StiContainer)this).SetParentStylesToChilds();
        }
    }

    @Override
    public void setConditions(StiConditionsCollection value) {
        this.conditions = value;
    }

    public final void setCurrentBookmark(StiBookmark value) {
        this.currentBookmark = value;
    }

    public final void setDelimiterComponent(boolean value) {
        this.getProperties().setBool(PropertyDelimiterComponent, value, false);
    }

    public void setDirectDisplayRectangle(StiRectangle rect) {
        this.left = rect.getLeft();
        this.top = rect.getTop();
        this.width = rect.getWidth();
        this.height = rect.getHeight();
    }

    public void setDisplayRectangle(StiRectangle value) {
        this.left = StiMath.round((double)value.getLeft(), (int)2);
        this.top = StiMath.round((double)value.getTop(), (int)2);
        this.width = this.CheckWidth(StiMath.round((double)value.getWidth(), (int)2));
        this.height = this.CheckHeight(StiMath.round((double)value.getHeight(), (int)2));
    }

    public void setDockable(boolean value) {
        this.getProperties().setBool(PropertyDockable, value, true);
    }

    public void setDockStyle(StiDockStyle value) {
        if (value == StiDockStyle.None && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.dockStyle = value;
        } else {
            this.bits = new BitsComponent(this.getBookmarkValue(), this.getToolTipValue(), this.getHyperlinkValue(), this.getTagValue(), this.getEnabled(), this.getHighlightState(), this.getIgnoreNamingRule(), value, this.getPrintable());
        }
    }

    public void setDoubleClickEvent(StiDoubleClickEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    public final void setDrillDownParameters(HashMap<String, Object> value) {
        if (this.drillDownParameters != value) {
            this.drillDownParameters = value;
        }
    }

    public void setEnabled(boolean value) {
        if (value && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.enabled = value;
        } else {
            this.bits = new BitsComponent(this.getBookmarkValue(), this.getToolTipValue(), this.getHyperlinkValue(), this.getTagValue(), value, this.getHighlightState(), this.getIgnoreNamingRule(), this.getDockStyle(), this.getPrintable());
        }
        if (!(this.getIsDesigning() || value || this.getDockStyle() == StiDockStyle.None || this.getParent() == null || this instanceof StiBand && this.getReport() != null && this.getReport().getEngineVersion() == StiEngineVersion.EngineV2 && !StiOptions.Engine.getCheckDockToContainerIfComponentDisabled())) {
            this.getParent().DockToContainer();
        }
    }

    public void setGetBookmarkEvent(StiGetBookmarkEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    public void setGetDrillDownReportEvent(StiGetDrillDownReportEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    public void setGetHyperlinkEvent(StiGetHyperlinkEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    public void setGetTagEvent(StiGetTagEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    public void setGetToolTipEvent(StiGetToolTipEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    @Override
    public void setGrowToHeight(boolean value) {
        this.growToHeight = value;
    }

    @Override
    public final void setGuid(String value) {
        this.guid = value;
    }

    public final void setHighlightState(StiHighlightState value) {
        if (value == StiHighlightState.Hide && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.highlightState = value;
        } else {
            this.bits = new BitsComponent(this.getBookmarkValue(), this.getToolTipValue(), this.getHyperlinkValue(), this.getTagValue(), this.getEnabled(), value, this.getIgnoreNamingRule(), this.getDockStyle(), this.getPrintable());
        }
    }

    public void setHyperlink(StiHyperlinkExpression value) {
        if (value != null) {
            value.set(this, "Hyperlink", value.getValue());
        }
    }

    public final void setHyperlinkValue(String value) {
        if (value == null && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.hyperlinkValue = value;
        } else {
            this.bits = new BitsComponent(this.getBookmarkValue(), this.getToolTipValue(), value, this.getTagValue(), this.getEnabled(), this.getHighlightState(), this.getIgnoreNamingRule(), this.getDockStyle(), this.getPrintable());
        }
    }

    public final void setIgnoreNamingRule(boolean value) {
        if (!value && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.ignoreNamingRule = value;
        } else {
            this.bits = new BitsComponent(this.getBookmarkValue(), this.getToolTipValue(), this.getHyperlinkValue(), this.getTagValue(), this.getEnabled(), this.getHighlightState(), value, this.getDockStyle(), this.getPrintable());
        }
    }

    @Override
    public final void setInherited(boolean value) {
        this.getProperties().setBool(PropertyInherited, value, false);
    }

    @Override
    public void setInteraction(StiInteraction value) {
        if (this.interaction != value) {
            this.interaction = value;
            if (value != null) {
                this.interaction.ParentComponent = this;
            }
        }
    }

    public boolean isExportAsImage(StiExportFormat format) {
        IStiBrush brush = (IStiBrush)((Object)(this instanceof IStiBrush ? this : null));
        IStiTextBrush textBrush = (IStiTextBrush)((Object)(this instanceof IStiTextBrush ? this : null));
        if (brush != null) {
            if (format == StiExportFormat.Pdf && (brush.getBrush() instanceof StiGradientBrush || brush.getBrush() instanceof StiGlareBrush || brush.getBrush() instanceof StiHatchBrush)) {
                return false;
            }
            if (format == StiExportFormat.Xps && brush.getBrush() instanceof StiGradientBrush && (textBrush == null || !(textBrush.getTextBrush() instanceof StiGradientBrush))) {
                return false;
            }
            if (format == StiExportFormat.Html || format == StiExportFormat.HtmlDiv || format == StiExportFormat.HtmlSpan || format == StiExportFormat.HtmlTable ? brush instanceof StiHatchBrush : format != StiExportFormat.ImageSvg && format != StiExportFormat.ImageSvgz && !(this instanceof StiContainer) && (brush instanceof StiGlareBrush || brush instanceof StiGradientBrush || brush instanceof StiGlassBrush || brush instanceof StiHatchBrush)) {
                return true;
            }
        }
        if (textBrush != null) {
            if (format == StiExportFormat.Pdf && (textBrush.getTextBrush() instanceof StiGradientBrush || textBrush.getTextBrush() instanceof StiGlareBrush || textBrush.getTextBrush() instanceof StiHatchBrush)) {
                return false;
            }
            if (textBrush.getTextBrush() instanceof StiGradientBrush || textBrush.getTextBrush() instanceof StiGlareBrush || textBrush.getTextBrush() instanceof StiGlassBrush || textBrush.getTextBrush() instanceof StiHatchBrush) {
                return true;
            }
        }
        return false;
    }

    public void setIsRendered(boolean value) {
        this.isRendered = value;
    }

    public void setLeftProp(double left) {
        this.left = left;
    }

    public void setLeft(double value) {
        this.left = (double)Math.round(value * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
    }

    public void setLinked(boolean value) {
        this.getProperties().setBool(PropertyLinked, value, false);
    }

    public void setLocked(boolean value) {
        this.getProperties().setBool(PropertyLocked, value, false);
    }

    public void setMaxSize(StiSize value) {
        StiSize maxSize = this.getMaxSize();
        if (maxSize.width != value.width || maxSize.height != value.height) {
            this.getProperties().set(PropertyMaxSize, (Object)value, (Object)StiSize.EMPTY);
            this.setWidth(this.CheckWidth(this.getWidth()));
            this.setHeight(this.CheckHeight(this.getHeight()));
        }
    }

    public void setMinSize(StiSize value) {
        StiSize minSize = this.getMinSize();
        if (minSize.width != value.width || minSize.height != value.height) {
            this.getProperties().set(PropertyMinSize, (Object)value, (Object)StiSize.EMPTY);
            this.width = this.CheckWidth(this.getWidth());
            this.height = this.CheckHeight(this.getHeight());
        }
    }

    public void setMouseEnterEvent(StiMouseEnterEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    public void setMouseLeaveEvent(StiMouseLeaveEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    @Override
    public void setName(String value) {
        if (this.getIgnoreNamingRule() || this.getReport() == null || !this.getReport().getIsDesigning()) {
            super.setName(value);
        }
        if (StiOptions.Designer.getAutoCorrectComponentName()) {
            super.setName(value);
        } else {
            super.setName(StiNameValidator.CorrectName(value));
        }
    }

    public void setPage(StiPage page) {
        this.page = page;
    }

    private void setPageForChildren(StiPage page) {
        if (this instanceof StiContainer) {
            StiComponentsCollection innerComponents = ((StiContainer)this).getComponents();
            for (StiComponent stiComponent : innerComponents) {
                stiComponent.setPage(page);
            }
        }
    }

    public final void setPaintRectangle(StiRectangle rect) {
        rect = this.PageToComponent(rect);
        rect = rect.getNormalize();
        this.setClientRectangle(rect);
    }

    public void setParent(StiContainer value) {
        this.parent = value;
    }

    public final void setParentBookmark(StiBookmark value) {
        this.parentBookmark = value;
    }

    public void setPlaceOnToolbox(boolean value) {
        this.getProperties().setBool(PropertyPlaceOnToolbox, value, false);
    }

    public void setPrintable(boolean value) {
        if (value && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.printable = value;
        } else {
            this.bits = new BitsComponent(this.getBookmarkValue(), this.getToolTipValue(), this.getHyperlinkValue(), this.getTagValue(), this.getEnabled(), this.getHighlightState(), this.getIgnoreNamingRule(), this.getDockStyle(), value);
        }
    }

    @Override
    public void setPrintOn(StiPrintOnType value) {
        this.printOn = value;
    }

    public final void setRenderedCount(int value) {
        this.getProperties().setInt(PropertyRenderedCount, value, 0);
    }

    @Deprecated
    public void setReport(StiReport value) {
    }

    public void setRestrictions(StiEnumSet<StiRestrictions> value) {
        this.getProperties().set(PropertyRestrictions, value, (Object)StiEnumSet.of((Enum)StiRestrictions.All));
    }

    public void setSelectionTick(int value) {
        this.getProperties().setInt(PropertySelectionTick, value, 0);
    }

    public void setSelectRectangle(StiRectangle value) {
        this.setDisplayRectangle(value);
    }

    @Override
    public void setShift(boolean value) {
        this.setShiftMode((StiEnumSet<StiShiftMode>)StiEnumSet.of((Enum)StiShiftMode.IncreasingSize));
    }

    @Override
    public void setShiftMode(StiEnumSet<StiShiftMode> value) {
        this.shiftMode = value;
    }

    public final void setShowQuickButtons(boolean value) {
        this.getProperties().setBool(PropertyShowQuickButtons, value, false);
    }

    public void setTag(StiTagExpression value) {
        if (value != null) {
            value.set(this, "Tag", value.getValue());
        }
    }

    public final void setTagValue(Object value) {
        if (value == null && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.tagValue = value;
        } else {
            this.bits = new BitsComponent(this.getBookmarkValue(), this.getToolTipValue(), this.getHyperlinkValue(), value, this.getEnabled(), this.getHighlightState(), this.getIgnoreNamingRule(), this.getDockStyle(), this.getPrintable());
        }
    }

    public void setToolTip(StiToolTipExpression value) {
        if (value != null) {
            value.set(this, "ToolTip", value.getValue());
        }
    }

    public final void setToolTipValue(String value) {
        if (value == null && this.bits == null) {
            return;
        }
        if (this.bits != null) {
            this.bits.toolTipValue = value;
        } else {
            this.bits = new BitsComponent(this.getBookmarkValue(), value, this.getHyperlinkValue(), this.getTagValue(), this.getEnabled(), this.getHighlightState(), this.getIgnoreNamingRule(), this.getDockStyle(), this.getPrintable());
        }
    }

    public void setTopProp(double top) {
        this.top = top;
    }

    public void setTop(double value) {
        this.top = (double)Math.round(value * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0);
    }

    public void setUseParentStyles(boolean value) {
        if (this.getUseParentStyles() != value) {
            this.getProperties().setBool(PropertyUseParentStyles, value, false);
            if (value && this.getParent() != null) {
                this.getParent().SetParentStylesToChilds();
            }
        }
    }

    public void setWidthProp(double width) {
        this.setWidth(width);
    }

    public void setWidth(double value) {
        this.width = this.CheckWidth((double)Math.round(value * Math.pow(10.0, 2.0)) / Math.pow(10.0, 2.0));
    }

    public String toString() {
        if (this.getAlias() == null || this.getAlias().length() == 0) {
            return this.getName();
        }
        if (StiOptions.Dictionary.getShowOnlyAliasForVariable()) {
            return this.getAlias();
        }
        return this.getName() + " [" + this.getAlias() + "]";
    }

    public void convert(StiUnit oldUnit, StiUnit newUnit, boolean isReportSnapshot, boolean convertComponents) {
        this.convert(oldUnit, newUnit);
    }

    @Override
    public void convert(StiUnit oldUnit, StiUnit newUnit) {
        this.disableCheckWidthHeight = true;
        this.setLeft(newUnit.ConvertFromHInches(oldUnit.ConvertToHInches(this.getLeft())));
        this.setTop(newUnit.ConvertFromHInches(oldUnit.ConvertToHInches(this.getTop())));
        this.setWidth(newUnit.ConvertFromHInches(oldUnit.ConvertToHInches(this.getWidth())));
        this.setHeight(newUnit.ConvertFromHInches(oldUnit.ConvertToHInches(this.getHeight())));
        this.disableCheckWidthHeight = false;
        this.setMinSize(newUnit.ConvertFromHInches(oldUnit.ConvertToHInches(this.getMinSize())));
        this.setMaxSize(newUnit.ConvertFromHInches(oldUnit.ConvertToHInches(this.getMaxSize())));
    }

    @Override
    public void restoreState(String stateName) {
        if (this.getStates().IsExist(stateName, this)) {
            this.setRenderedCount(this.getStates().PopInt(stateName, this, "renderedCount"));
            this.setIsRendered(this.getStates().PopBool(stateName, this, "isRendered"));
        }
    }

    @Override
    public void clearAllStates() {
        this.setStates(null);
    }

    @Override
    public void select() {
        if (StiRestrictionsHelper.isAllowSelect(this instanceof StiComponent ? this : null)) {
            this.setIsSelected(true);
        }
    }

    @Override
    public void invert() {
        if (StiRestrictionsHelper.isAllowSelect(this instanceof StiComponent ? this : null)) {
            this.setIsSelected(!this.getIsSelected());
        }
    }

    @Override
    public void reset() {
        this.setIsSelected(false);
    }

    public StiComponent getGroupHeaderBand() {
        StiComponent obj = null;
        obj = this instanceof StiGroupFooterBand ? this : this.getParent();
        if (obj == null) {
            return null;
        }
        while (!(obj == null || obj instanceof StiDataBand || obj instanceof StiGroupHeaderBand || obj instanceof StiGroupFooterBand || obj instanceof StiPage)) {
            obj = obj.getParent();
        }
        if (obj instanceof StiGroupHeaderBand) {
            return obj;
        }
        if (obj instanceof StiGroupFooterBand || obj instanceof StiDataBand) {
            StiDataBand dataBand = null;
            if (!(obj instanceof StiDataBand)) {
                int index;
                for (int ind = index = obj.parent.components.indexOf(obj) - 1; ind >= 0; --ind) {
                    StiDataBand tempComp = (StiDataBand)(obj.parent.components.get(ind) instanceof StiDataBand ? (StiComponent)obj.parent.components.get(ind) : null);
                    if (tempComp == null) continue;
                    dataBand = tempComp;
                    break;
                }
            } else {
                dataBand = (StiDataBand)(obj instanceof StiDataBand ? obj : null);
            }
            if (dataBand != null) {
                StiV2Builder tempVar = StiDataBandV2Builder.getBuilder(StiDataBand.class);
                StiDataBandV2Builder builder = (StiDataBandV2Builder)(tempVar instanceof StiDataBandV2Builder ? tempVar : null);
                dataBand.getDataBandInfoV2().GroupHeaderComponents = builder.GetGroupHeaders(dataBand);
                dataBand.getDataBandInfoV2().GroupFooterComponents = builder.GetGroupFooters(dataBand);
                builder.GroupsComparison(dataBand);
                if (obj instanceof StiGroupFooterBand) {
                    return ((StiGroupFooterBand)obj).getGroupFooterBandInfoV2().GroupHeader;
                }
                if (dataBand.getDataBandInfoV2().GroupHeaderComponents.size() > 0) {
                    StiGroupHeaderBand groupHeaderBand = dataBand.getDataBandInfoV2().GroupHeaderComponents.get(dataBand.getDataBandInfoV2().GroupHeaderComponents.size() - 1);
                    return groupHeaderBand instanceof StiGroupHeaderBand ? groupHeaderBand : null;
                }
            }
        }
        return null;
    }

    public StiComponent GetGroupHeaderBand() {
        return this.getGroupHeaderBand();
    }

    public StiComponent GetDataBand() {
        return this.getDataBand();
    }

    public void InvokeBeginRender() {
    }

    public void InvokeEndRender() {
    }

    public StiComponent InternalRender() {
        StiV2Builder builder = this.getBuilder();
        return builder.InternalRender(this);
    }

    public StiComponent render() {
        StiV2Builder builder = this.getBuilder();
        try {
            return builder.Render(this);
        }
        catch (RuntimeException e) {
            StiLoggingUtil.uppendException((Exception)e, (String)this.getClass().getName(), (String)("Name:" + this.getName()));
            throw e;
        }
    }

    public void SetReportVariables() {
        StiV2Builder builder = StiV2Builder.GetBuilder(this.getClass());
        builder.SetReportVariables(this);
    }

    public void Prepare() {
        StiV2Builder builder = this.getBuilder();
        builder.Prepare(this);
    }

    public void UnPrepare() {
        StiV2Builder builder = this.getBuilder();
        builder.UnPrepare(this);
    }

    protected StiV2Builder getBuilder() {
        StiV2Builder builder = StiV2Builder.GetBuilder(this.getClass());
        return builder;
    }

    public void setHeightProp(double height) {
        this.height = height;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = this.CheckHeight((double)Math.round(height * 100.0) / 100.0);
    }

    public void setStates(StiStatesManager states) {
        this.states = states;
    }

    @StiSerializable
    @StiDefaulValue(value="Top, Left")
    public StiEnumSet<StiAnchorMode> getAnchor() {
        return this.anchor;
    }

    public void setAnchor(StiEnumSet<StiAnchorMode> anchor) {
        this.anchor = anchor;
        if (anchor != StiEnumSet.of((Enum)StiAnchorMode.Left, (Enum)StiAnchorMode.Top)) {
            this.setGrowToHeight(false);
            this.setShiftMode((StiEnumSet<StiShiftMode>)StiEnumSet.of((Enum)StiShiftMode.None));
        }
    }

    @StiSerializable
    public StiAppExpressionCollection getExpressions() {
        return this.expressions;
    }

    public void setExpressions(StiAppExpressionCollection expressions) {
        this.expressions = expressions;
    }

    public void doPointer() {
        this.doPointer(true);
    }

    public void doPointer(boolean createNewGuid) {
        this.doGetPointer(createNewGuid);
    }

    private void doGetPointer(boolean createNewGuid) {
        if (this.getPointer().getValue().length() > 0) {
            StiValueEventArgs args = new StiValueEventArgs();
            Object parserResult = StiScriptHelper.parseTextValue(this.getPointer().getValue(), this);
            args.setValue(this.getReport() != null ? this.getReport().ToString(parserResult) : null);
            if (args.getValue() instanceof String && ((String)args.getValue()).length() > 0) {
                if (this.getReport() != null && this.getReport().getEngineVersion() == StiEngineVersion.EngineV2) {
                    if (createNewGuid) {
                        this.NewGuid();
                    }
                    String text = (String)args.getValue();
                    this.currentPointer = StiBookmarksV2Helper.CreateBookmark(text, this.getGuid());
                    if (this.parentPointer != null) {
                        this.parentPointer.getBookmarks().add(this.currentPointer);
                    }
                }
            } else {
                this.currentPointer = this.parentPointer;
            }
        } else {
            this.currentPointer = this.parentPointer;
        }
    }

    @StiSerializable
    public Object getPointerValue() {
        return this.pointerValue;
    }

    public void setPointerValue(Object pointerValue) {
        this.pointerValue = pointerValue;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiPointerExpression getPointer() {
        return new StiPointerExpression(this, "Pointer");
    }

    public void setPointer(StiPointerExpression pointer) {
        if (pointer != null) {
            pointer.set(this, "Pointer", pointer.getValue());
        }
    }

    private static class BitsComponent
    implements Cloneable {
        public String bookmarkValue = null;
        public StiDockStyle dockStyle = StiDockStyle.None;
        public boolean enabled = true;
        public StiHighlightState highlightState = StiHighlightState.Hide;
        public String hyperlinkValue = null;
        public boolean ignoreNamingRule = false;
        public boolean printable = true;
        public Object tagValue = null;
        public String toolTipValue = null;

        public BitsComponent(String bookmarkValue, String toolTipValue, String hyperlinkValue, Object tagValue, boolean enabled, StiHighlightState highlightState, boolean ignoreNamingRule, StiDockStyle dockStyle, boolean printable) {
            this.bookmarkValue = bookmarkValue;
            this.toolTipValue = toolTipValue;
            this.hyperlinkValue = hyperlinkValue;
            this.tagValue = tagValue;
            this.enabled = enabled;
            this.highlightState = highlightState;
            this.ignoreNamingRule = ignoreNamingRule;
            this.dockStyle = dockStyle;
            this.printable = printable;
        }

        public final Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

