/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.view.series.pie;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.geoms.StiCloseFigureSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiLineSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import java.util.ArrayList;

public class StiPie3dQuadrilateral {
    private StiAnimation animation;
    private StiRectangle rectangle;
    private StiPoint point1;
    private StiPoint point2;
    private StiPoint point3;
    private StiPoint point4;
    private boolean toClose;
    public static final StiPie3dQuadrilateral empty = new StiPie3dQuadrilateral(new StiRectangle(), new StiPoint(), new StiPoint(), new StiPoint(), new StiPoint(), false, null);

    public final void draw(StiContext context, StiPenGeom pen, StiBrush brush, boolean isMouseOver) {
        ArrayList<Object> path = new ArrayList<Object>();
        path.add(new StiLineSegmentGeom(this.point1, this.point2));
        path.add(new StiLineSegmentGeom(this.point2, this.point3));
        path.add(new StiLineSegmentGeom(this.point3, this.point4));
        if (this.toClose) {
            path.add(new StiCloseFigureSegmentGeom());
        }
        StiRectangle rect = context.GetPathBounds(path);
        if (this.animation != null) {
            context.DrawAnimationPathElement(brush, brush, pen, path, (Object)this.rectangle, null, (Object)this, this.animation, null);
        } else {
            context.FillPath(brush, path, (Object)rect, (Object)this, null);
            context.DrawPath(pen, path, (Object)rect, false);
        }
    }

    public final boolean contains(StiPoint point) {
        StiPoint[] points = new StiPoint[]{this.point1, this.point2, this.point3, this.point4};
        if (points.length == 0) {
            return false;
        }
        return StiPie3dQuadrilateral.contains(point, points);
    }

    public static boolean contains(StiPoint point, StiPoint[] cornerPoints) {
        int intersections = 0;
        for (int i = 1; i < cornerPoints.length; ++i) {
            if (!StiPie3dQuadrilateral.doesIntersect(point, cornerPoints[i], cornerPoints[i - 1])) continue;
            ++intersections;
        }
        if (StiPie3dQuadrilateral.doesIntersect(point, cornerPoints[cornerPoints.length - 1], cornerPoints[0])) {
            ++intersections;
        }
        return intersections % 2 != 0;
    }

    private static boolean doesIntersect(StiPoint point, StiPoint point1, StiPoint point2) {
        double x2 = point2.x;
        double y2 = point2.y;
        double x1 = point1.x;
        double y1 = point1.y;
        if (x2 < point.x && x1 >= point.x || x2 >= point.x && x1 < point.x) {
            double y = (y2 - y1) / (x2 - x1) * (point.x - x1) + y1;
            return y > point.y;
        }
        return false;
    }

    public StiPie3dQuadrilateral() {
    }

    public StiPie3dQuadrilateral(StiRectangle rectangle, StiPoint point1, StiPoint point2, StiPoint point3, StiPoint point4, boolean toClose, StiAnimation animation) {
        this.rectangle = rectangle;
        this.point1 = point1;
        this.point2 = point2;
        this.point3 = point3;
        this.point4 = point4;
        this.toClose = toClose;
        this.animation = animation;
    }
}

