/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.view.areas;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializeToCodeAsClass;
import com.stimulsoft.base.services.StiService;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.chart.core.area.StiAreaCoreXF;
import com.stimulsoft.report.chart.interfaces.IStiChart;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.view.series.fullStackedBar.StiFullStackedBarSeries;
import com.stimulsoft.report.chart.view.series.fullStackedColumn.StiFullStackedColumnSeries;
import java.util.List;

public abstract class StiArea
extends StiService
implements IStiArea,
IStiSerializeToCodeAsClass {
    private StiAreaCoreXF core;
    private IStiChart chart = null;
    private boolean allowApplyStyle = true;
    private boolean colorEach = false;
    private boolean showShadow = false;
    private StiColor borderColor = StiColor.Gray;
    private StiBrush brush = new StiSolidBrush(StiColor.White);

    @Override
    public Object clone() {
        Object tempVar = super.clone();
        IStiArea area = (IStiArea)(tempVar instanceof IStiArea ? tempVar : null);
        Object tempVar2 = this.getBrush().clone();
        area.setBrush((StiBrush)(tempVar2 instanceof StiBrush ? tempVar2 : null));
        if (this.core != null) {
            Object tempVar3 = this.getCore().clone();
            area.setCore((StiAreaCoreXF)(tempVar3 instanceof StiAreaCoreXF ? tempVar3 : null));
            area.getCore().setArea(area);
        }
        return area;
    }

    public String toString() {
        return this.getServiceName();
    }

    @Override
    public abstract Class GetDefaultSeriesType();

    @Override
    public abstract Class[] GetSeriesTypes();

    @Override
    public abstract Class GetDefaultSeriesLabelsType();

    @Override
    public abstract Class[] GetSeriesLabelsTypes();

    public String getServiceName() {
        return this.getCore().getLocalizedName();
    }

    public final String getServiceCategory() {
        return "Chart";
    }

    public final Class getServiceType() {
        return StiArea.class;
    }

    @Override
    public final boolean getIsDefaultSeriesTypeFullStackedColumnSeries() {
        return this.GetDefaultSeriesType() == StiFullStackedColumnSeries.class;
    }

    @Override
    public final boolean getIsDefaultSeriesTypeFullStackedBarSeries() {
        return this.GetDefaultSeriesType() == StiFullStackedBarSeries.class;
    }

    @Override
    public final StiAreaCoreXF getCore() {
        return this.core;
    }

    @Override
    public final void setCore(StiAreaCoreXF value) {
        this.core = value;
    }

    @Override
    @StiSerializable(isRef=true)
    public IStiChart getChart() {
        return this.chart;
    }

    @Override
    public void setChart(IStiChart value) {
        this.chart = value;
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="true")
    public final boolean getAllowApplyStyle() {
        return this.allowApplyStyle;
    }

    @Override
    public final void setAllowApplyStyle(boolean value) {
        if (this.allowApplyStyle != value) {
            this.allowApplyStyle = value;
            if (value && this.getChart() != null) {
                this.core.applyStyle(this.getChart().getStyle());
            }
        }
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getColorEach() {
        return this.colorEach;
    }

    @Override
    public void setColorEach(boolean value) {
        this.colorEach = value;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getShowShadow() {
        return this.showShadow;
    }

    @Override
    public final void setShowShadow(boolean value) {
        this.showShadow = value;
    }

    @Override
    @StiSerializable
    public final StiColor getBorderColor() {
        return this.borderColor;
    }

    @Override
    public final void setBorderColor(StiColor value) {
        this.borderColor = value;
    }

    @Override
    @StiSerializable(shortName="bh")
    public final StiBrush getBrush() {
        return this.brush;
    }

    @Override
    public final void setBrush(StiBrush value) {
        this.brush = value;
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyBool("AllowApplyStyle", this.getAllowApplyStyle(), true);
        jObject.AddPropertyBool("ColorEach", this.getColorEach());
        jObject.AddPropertyBool("ShowShadow", this.getShowShadow());
        jObject.AddPropertyStringNullOfEmpty("BorderColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.getBorderColor(), (StiColorEnum)StiColorEnum.Gray));
        jObject.AddPropertyStringNullOfEmpty("Brush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.getBrush()));
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("AllowApplyStyle")) {
                this.allowApplyStyle = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("ColorEach")) {
                this.setColorEach((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("ShowShadow")) {
                this.showShadow = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("BorderColor")) {
                this.borderColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (!property.Name.equals("Brush")) continue;
            this.brush = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
        }
    }

    public static IStiArea LoadFromJsonObjectInternal(JSONObject jObject) throws JSONException {
        String ident = (String)jObject.Properties().FirstOrDefault((String)"Ident").Value;
        List<Class<?>> classes = StiOptions.Services.getChartAreas();
        Class<?> clazz = null;
        for (Class<?> claz : classes) {
            String name = claz.getName();
            if (!name.substring(name.lastIndexOf(46) + 1).equals(ident)) continue;
            clazz = claz;
        }
        IStiArea area = null;
        if (clazz != null) {
            try {
                area = (IStiArea)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            area.LoadFromJsonObject(jObject);
        }
        return area;
    }
}

