/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.helpers;

import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.system.geometry.StiRectangle;

public class StiPie3dHelper {
    public static final float brightnessEnhancementFactor1 = 0.3f;

    public static StiColor createColorWithCorrectedLightness(StiColor color, float correctionFactor) {
        if (correctionFactor == 0.0f) {
            return color;
        }
        float red = color.r;
        float green = color.g;
        float blue = color.b;
        if (correctionFactor < 0.0f) {
            correctionFactor = 1.0f + correctionFactor;
            red *= correctionFactor;
            green *= correctionFactor;
            blue *= correctionFactor;
        } else {
            red = (255.0f - red) * correctionFactor + red;
            green = (255.0f - green) * correctionFactor + green;
            blue = (255.0f - blue) * correctionFactor + blue;
        }
        return StiColor.fromArgb((int)color.a, (int)((int)red), (int)((int)green), (int)((int)blue));
    }

    public static float getActualAngle(StiRectangle rect, float transformedAngle) {
        double x = rect.height * Math.cos((double)transformedAngle * Math.PI / 180.0);
        double y = rect.width * Math.sin((double)transformedAngle * Math.PI / 180.0);
        float result = (float)(Math.atan2(y, x) * 180.0 / Math.PI);
        if (result < 0.0f) {
            return result + 360.0f;
        }
        return result;
    }

    public static float transformAngle(StiRectangle rect, float angle) {
        double x = rect.width * Math.cos((double)angle * Math.PI / 180.0);
        double y = rect.height * Math.sin((double)angle * Math.PI / 180.0);
        float result = (float)(Math.atan2(y, x) * 180.0 / Math.PI);
        if (result < 0.0f) {
            return result + 360.0f;
        }
        return result;
    }
}

