/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.range;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.enums.StiShadowSides;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.StiSeriesElementGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.range.IStiRangeBarSeries;

public class StiRangeBarElementGeom
extends StiSeriesElementGeom {
    private Integer beginTime;

    public Integer getBeginTime() {
        return this.beginTime;
    }

    @Override
    public void Draw(StiContext context) {
        IStiSeries tempVar = this.getSeries();
        IStiRangeBarSeries currSeries = (IStiRangeBarSeries)(tempVar instanceof IStiRangeBarSeries ? tempVar : null);
        StiRectangle seriesRect = this.getClientRectangle();
        StiChart chart = (StiChart)this.getSeries().getChart();
        if (chart.isAnimation) {
            StiPenGeom pen = new StiPenGeom(currSeries.getBorderColor());
            Double valueStart = this.getSeries().getValuesStart().length > this.getIndex() ? this.getSeries().getValuesStart()[this.getIndex()] : 0.0;
            if (this.getSeries().getShowShadow()) {
                StiOpacityAnimation animationOpacityShadow = new StiOpacityAnimation(StiChartHelper.GlobalDurationElement, Integer.valueOf(this.beginTime + StiChartHelper.GlobalDurationElement));
                context.DrawShadowRect(seriesRect, 5, (StiAnimation)animationOpacityShadow);
            }
            StiOpacityAnimation animationOpacity = new StiOpacityAnimation(StiChartHelper.GlobalDurationElement, this.beginTime);
            context.DrawAnimationColumn((Object)currSeries.getBrush(), pen, (Object)seriesRect, Double.valueOf(this.getValue()), this.GetToolTip(), (Object)this, (StiAnimation)animationOpacity, this.getInteractionData());
        } else {
            if (currSeries.getShowShadow() && seriesRect.width > 4.0 && seriesRect.height > 4.0) {
                context.drawCachedShadow(seriesRect, new StiEnumSet((Enum)StiShadowSides.All), context.Options.isPrinting);
            }
            StiPenGeom pen = new StiPenGeom(currSeries.getBorderColor());
            context.FillRectangle((Object)currSeries.getBrush(), seriesRect.x, seriesRect.y, seriesRect.width, seriesRect.height, this.getInteractionData());
            if (this.getIsMouseOver() || this.getSeries().getCore().getIsMouseOver()) {
                context.FillRectangle((Object)StiMouseOverHelper.GetMouseOverColor(), seriesRect.x, seriesRect.y, seriesRect.width, seriesRect.height, null);
            }
            context.DrawRectangle(pen, seriesRect.x, seriesRect.y, seriesRect.width, seriesRect.height);
        }
    }

    public StiRangeBarElementGeom(StiAreaGeom areaGeom, double value, int index, IStiSeries series, StiRectangle clientRectangle, Integer beginTime) {
        super(areaGeom, value, index, series, clientRectangle);
        this.beginTime = beginTime;
    }
}

