/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.radar;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.animation.StiPointsAnimation;
import com.stimulsoft.base.context.chart.geoms.StiLineSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPathGeom;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.StiInteractionOptions;
import com.stimulsoft.report.chart.StiPointHelper;
import com.stimulsoft.report.chart.core.area.StiAreaCoreXF;
import com.stimulsoft.report.chart.core.area.radar.StiRadarAreaCoreXF;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.radar.IStiRadarArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.radar.IStiRadarAreaSeries;
import java.util.ArrayList;

public class StiRadarAreaSeriesGeom
extends StiCellGeom {
    private final IStiSeries series;
    private final StiPoint[] points;
    private final StiPoint centerPoint;
    private StiPoint[] pointsFrom;

    @Override
    public void InvokeMouseEnter(StiInteractionOptions options) {
        if (!this.getAllowMouseOver()) {
            return;
        }
        if (!this.getIsMouseOver()) {
            this.setIsMouseOver(true);
            options.setUpdateContext(true);
        }
    }

    @Override
    public void InvokeMouseLeave(StiInteractionOptions options) {
        if (!this.getAllowMouseOver()) {
            return;
        }
        if (this.getIsMouseOver()) {
            this.setIsMouseOver(false);
            options.setUpdateContext(true);
        }
    }

    public boolean getAllowMouseOver() {
        return this.getSeries().getInteraction().getDrillDownEnabled() && this.getSeries().getInteraction().getAllowSeries();
    }

    public boolean getIsMouseOver() {
        if (this.getSeries() == null) {
            return false;
        }
        return this.getSeries().getCore().getIsMouseOver();
    }

    public void setIsMouseOver(boolean value) {
        if (this.getSeries() != null) {
            this.getSeries().getCore().setIsMouseOver(value);
        }
    }

    public final IStiSeries getSeries() {
        return this.series;
    }

    public final StiPoint[] getPoints() {
        return this.points;
    }

    public final StiPoint getCenterPoint() {
        return this.centerPoint;
    }

    public StiPoint[] getPointsFrom() {
        return this.pointsFrom;
    }

    @Override
    public boolean Contains(double x, double y) {
        if (this.getInvisible()) {
            return false;
        }
        IStiSeries tempVar = this.getSeries();
        IStiRadarAreaSeries radarSeries = (IStiRadarAreaSeries)(tempVar instanceof IStiRadarAreaSeries ? tempVar : null);
        IStiArea tempVar2 = this.getSeries().getChart().getArea();
        IStiRadarArea radarArea = (IStiRadarArea)(tempVar2 instanceof IStiRadarArea ? tempVar2 : null);
        StiAreaCoreXF tempVar3 = radarArea.getCore();
        StiRadarAreaCoreXF radarCore = (StiRadarAreaCoreXF)(tempVar3 instanceof StiRadarAreaCoreXF ? tempVar3 : null);
        for (int pointIndex = 0; pointIndex < this.getPoints().length; ++pointIndex) {
            boolean result;
            StiPoint point1 = this.getPoints()[pointIndex];
            StiPoint point2 = pointIndex == this.getPoints().length - 1 ? this.points[0] : this.getPoints()[pointIndex + 1];
            StiPoint point3 = radarCore.CenterPoint;
            if (point1 == null || point2 == null || !(result = StiPointHelper.IsPointInTriangle(new StiPoint(x, y), point1.getValue(), point3, point2.getValue()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void Draw(StiContext context) {
        IStiSeries tempVar = this.getSeries();
        IStiRadarAreaSeries radarSeries = (IStiRadarAreaSeries)(tempVar instanceof IStiRadarAreaSeries ? tempVar : null);
        ArrayList<StiLineSegmentGeom> path = new ArrayList<StiLineSegmentGeom>();
        StiChart chart = (StiChart)this.getSeries().getChart();
        if (chart.isAnimation) {
            for (int indexPoint = 0; indexPoint < this.points.length; ++indexPoint) {
                StiPoint nextPoint;
                StiPoint curPoint = this.getPoints()[indexPoint];
                StiPoint stiPoint = nextPoint = indexPoint < this.getPoints().length - 1 ? this.getPoints()[indexPoint + 1] : this.getPoints()[0];
                if (curPoint == null) {
                    curPoint = this.centerPoint;
                }
                if (nextPoint == null) {
                    nextPoint = this.centerPoint;
                }
                StiPointsAnimation animation = null;
                if (chart.isAnimationChangingValues()) {
                    StiPoint nextPointFrom;
                    StiPoint curPointFrom = this.getPointsFrom()[indexPoint];
                    StiPoint stiPoint2 = nextPointFrom = indexPoint < this.getPointsFrom().length - 1 ? this.getPointsFrom()[indexPoint + 1] : this.getPointsFrom()[0];
                    if (curPointFrom == null) {
                        curPoint = this.centerPoint;
                    }
                    if (nextPointFrom == null) {
                        nextPoint = this.centerPoint;
                    }
                    animation = new StiPointsAnimation(new StiPoint[]{curPointFrom != null ? curPointFrom : StiPoint.getEmpty(), nextPointFrom != null ? nextPointFrom : StiPoint.getEmpty()}, StiChartHelper.GlobalDurationElement, StiChartHelper.GlobalBeginTimeElement);
                }
                path.add(new StiLineSegmentGeom(curPoint.getValue(), nextPoint.getValue(), animation));
            }
            if (chart.isAnimationChangingValues()) {
                context.FillDrawAnimationPath((Object)radarSeries.getBrush(), null, path, StiPathGeom.GetBoundsState, null, null, null);
            } else {
                StiOpacityAnimation animation = new StiOpacityAnimation(StiChartHelper.GlobalDurationElement, StiChartHelper.GlobalBeginTimeElement);
                context.FillDrawAnimationPath((Object)radarSeries.getBrush(), null, path, StiPathGeom.GetBoundsState, null, (StiAnimation)animation, null);
            }
        } else {
            int index = 0;
            StiPoint[] stiPointArray = this.getPoints();
            int n = stiPointArray.length;
            for (int i = 0; i < n; ++i) {
                StiPoint nextPoint;
                StiPoint point;
                StiPoint curPoint = point = stiPointArray[i];
                StiPoint stiPoint = nextPoint = index < this.getPoints().length - 1 ? this.getPoints()[index + 1] : this.getPoints()[0];
                if (curPoint == null) {
                    curPoint = this.centerPoint;
                }
                if (nextPoint == null) {
                    nextPoint = this.centerPoint;
                }
                path.add(new StiLineSegmentGeom(curPoint.getValue(), nextPoint.getValue()));
                ++index;
            }
            context.PushSmoothingModeToAntiAlias();
            if (radarSeries.getBrush() != null) {
                context.FillPath((Object)radarSeries.getBrush(), path, (Object)StiRectangle.getEmpty(), null);
            }
            if (this.getIsMouseOver() || this.getSeries().getCore().getIsMouseOver()) {
                context.FillPath((Object)StiMouseOverHelper.GetMouseOverColor(), path, (Object)StiRectangle.getEmpty(), null);
            }
            context.PopSmoothingMode();
        }
    }

    public StiRadarAreaSeriesGeom(IStiSeries series, StiPoint[] pointsFrom, StiPoint[] points, StiPoint centerPoint) {
        super(StiRectangle.getEmpty());
        this.series = series;
        this.points = points;
        this.pointsFrom = pointsFrom;
        this.centerPoint = centerPoint;
    }
}

