/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.pie;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.context.chart.geoms.StiSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.enums.StiPenAlignment;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.StiSeriesElementGeom;
import com.stimulsoft.report.chart.interfaces.series.pie.IStiPieSeries;
import java.util.ArrayList;

public class StiPieSeriesElementGeom
extends StiSeriesElementGeom {
    private final ArrayList<StiSegmentGeom> path;
    private final ArrayList<StiSegmentGeom> pathLight;
    private final StiColor borderColor;
    private final StiBrush brush;
    private double startAngle;
    private double endAngle;
    private double radius;
    private StiAnimation animation;

    public final ArrayList<StiSegmentGeom> getPath() {
        return this.path;
    }

    public final ArrayList<StiSegmentGeom> getPathLight() {
        return this.pathLight;
    }

    public final StiColor getBorderColor() {
        return this.borderColor;
    }

    public final StiBrush getBrush() {
        return this.brush;
    }

    public final double getStartAngle() {
        return this.startAngle;
    }

    public final void setStartAngle(double value) {
        this.startAngle = value;
    }

    public final double getEndAngle() {
        return this.endAngle;
    }

    public final void setEndAngle(double value) {
        this.endAngle = value;
    }

    public final double getRadius() {
        return this.radius;
    }

    public final void setRadius(double value) {
        this.radius = value;
    }

    public StiAnimation getAnimation() {
        return this.animation;
    }

    public void setAnimation(StiAnimation animation) {
        this.animation = animation;
    }

    @Override
    public boolean Contains(double x, double y) {
        if (this.getInvisible()) {
            return false;
        }
        StiPoint center = new StiPoint(this.getClientRectangle().x + this.getClientRectangle().width / 2.0, this.getClientRectangle().y + this.getClientRectangle().height / 2.0);
        double dx = x - center.x;
        double dy = y - center.y;
        float radius = (float)Math.sqrt(dx * dx + dy * dy);
        if ((double)radius >= this.getRadius()) {
            return false;
        }
        float alpha = (float)(Math.atan2(dy, dx) * 180.0 / Math.PI);
        if (alpha < 0.0f) {
            alpha += 360.0f;
        }
        return (double)alpha >= this.getStartAngle() && (double)alpha <= this.getEndAngle();
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle rectPie = this.getClientRectangle();
        StiPenGeom pen = new StiPenGeom(StiColorUtils.dark((StiColor)this.borderColor, (int)10));
        pen.setAlignment(StiPenAlignment.Inset);
        StiChart chart = (StiChart)this.getSeries().getChart();
        if (chart.isAnimation) {
            context.DrawAnimationPathElement((Object)this.brush, pen, this.path, (Object)rectPie, this.GetToolTip(), (Object)this, this.animation, this.getInteractionData());
            if (this.getPathLight() != null) {
                StiSolidBrush brLight = new StiSolidBrush(StiColor.FromArgb((int)30, (StiColor)StiColorEnum.Black.color()));
                context.DrawAnimationPathElement((Object)brLight, null, this.pathLight, (Object)rectPie, this.GetToolTip(), null, this.animation, this.getInteractionData());
            }
        } else {
            context.PushSmoothingModeToAntiAlias();
            context.FillPath((Object)this.getBrush(), this.getPath(), (Object)rectPie, this.getInteractionData());
            if (this.getIsMouseOver() || this.getSeries().getCore().getIsMouseOver()) {
                context.FillPath((Object)StiMouseOverHelper.GetMouseOverColor(), this.getPath(), (Object)rectPie, null);
            }
            if (this.getPathLight() != null) {
                StiSolidBrush brLight = new StiSolidBrush(StiColor.FromArgb((int)30, (StiColor)StiColor.Black));
                context.FillPath((Object)brLight, this.pathLight, (Object)rectPie, null);
            }
            if (!StiColor.Transparent.equals(this.getBorderColor())) {
                context.DrawPath(pen, this.path, null);
            }
            context.PopSmoothingMode();
        }
    }

    public StiPieSeriesElementGeom(StiAreaGeom areaGeom, double value, int index, IStiPieSeries series, StiRectangle clientRectangle, ArrayList<StiSegmentGeom> path, ArrayList<StiSegmentGeom> pathLight, StiColor borderColor, StiBrush brush, double startAngle, double endAngle, double radius, StiAnimation animation) {
        super(areaGeom, value, index, series, clientRectangle);
        this.path = path;
        this.pathLight = pathLight;
        this.borderColor = borderColor;
        this.brush = brush;
        this.startAngle = startAngle;
        this.endAngle = endAngle;
        this.radius = radius;
        this.animation = animation;
    }
}

