/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.pie;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.context.chart.geoms.StiPieSegmentGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiSeriesElementGeom;
import com.stimulsoft.report.chart.helpers.StiPie3dHelper;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.view.series.StiSeriesInteractionData;
import com.stimulsoft.report.chart.view.series.pie.StiPie3dSlice;
import java.util.ArrayList;

public class StiPie3dMainSideSeriesElementGeom
extends StiSeriesElementGeom {
    private StiColor borderColor = new StiColor();
    private float startAngle;
    private float sweepAngle;
    private float realStartAngle;
    private float realSweepAngle;
    private int count;
    private StiPie3dSlice pie3DSlice;

    @Override
    public StiSeriesInteractionData getInteraction() {
        return this.getPie3DSlice().getInteraction();
    }

    public final StiPie3dSlice getPie3DSlice() {
        return this.pie3DSlice;
    }

    private void setPie3DSlice(StiPie3dSlice value) {
        this.pie3DSlice = value;
    }

    @Override
    public boolean Contains(double px, double py) {
        double angleDegrees;
        if (this.getInvisible()) {
            return false;
        }
        double y = py - this.getClientRectangle().y - this.getClientRectangle().height / 2.0;
        double x = px - this.getClientRectangle().x - this.getClientRectangle().width / 2.0;
        double angle = Math.atan2(y, x);
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        if ((angleDegrees = angle * 180.0 / Math.PI) >= (double)this.startAngle && angleDegrees <= (double)(this.startAngle + this.sweepAngle) || this.startAngle + this.sweepAngle > 360.0f && angleDegrees + 360.0 <= (double)(this.startAngle + this.sweepAngle)) {
            double r = Math.sqrt(y * y + x * x);
            return this.getEllipseRadius(angle) > r;
        }
        return false;
    }

    private double getEllipseRadius(double angle) {
        double a = this.getClientRectangle().width / 2.0;
        double b = this.getClientRectangle().height / 2.0;
        double a2 = a * a;
        double b2 = b * b;
        double cosFi = Math.cos(angle);
        double sinFi = Math.sin(angle);
        return a * b / Math.sqrt(b2 * cosFi * cosFi + a2 * sinFi * sinFi);
    }

    @Override
    public void Draw(StiContext context) {
        StiPenGeom pen = new StiPenGeom(this.borderColor, 1.0);
        ArrayList<StiPieSegmentGeom> path = new ArrayList<StiPieSegmentGeom>();
        path.add(new StiPieSegmentGeom(new StiRectangle(this.getClientRectangle().x, this.getClientRectangle().y, this.getClientRectangle().width, this.getClientRectangle().height), this.startAngle, this.sweepAngle, this.realStartAngle, this.realSweepAngle, null));
        context.PushSmoothingModeToAntiAlias();
        StiBrush brush = this.seriesBrush;
        StiAnimation animation = this.getAnimation();
        if (animation != null) {
            context.DrawAnimationPathElement(brush, brush, pen, path, (Object)this.getClientRectangle(), this.GetToolTip(), (Object)this, animation, this.getInteractionData());
        } else {
            context.FillPath((Object)brush, path, (Object)this.getClientRectangle(), null);
            context.DrawPath(pen, path, (Object)this.getClientRectangle());
        }
        context.PopSmoothingMode();
    }

    private StiAnimation getAnimation() {
        if (!((StiChart)this.getSeries().getChart()).isAnimation) {
            return null;
        }
        Integer duration = StiChartHelper.GlobalDurationElement;
        Integer beginTime = StiChartHelper.GlobalBeginTimeElement;
        StiOpacityAnimation animation = null;
        Object pieAnimation = null;
        if (animation == null) {
            int beginTimeAnimationOpacity = beginTime / this.count * this.getIndex();
            StiOpacityAnimation opacityAnimation = new StiOpacityAnimation(duration, Integer.valueOf(beginTimeAnimationOpacity));
            opacityAnimation.id = String.format("series_%1$s_%2$s", this.getSeries().getChart().getSeries().indexOf(this.getSeries()), this.getIndex());
            animation = opacityAnimation;
        }
        return animation;
    }

    public StiPie3dMainSideSeriesElementGeom(StiPie3dSlice pie3DSlice, StiAreaGeom areaGeom, double value, int index, int count, IStiSeries series, StiRectangle clientRectangle, StiColor borderColor, StiBrush brush, float startAngle, float sweepAngle) {
        super(areaGeom, value, index, series, clientRectangle);
        this.seriesBrush = brush;
        this.setPie3DSlice(pie3DSlice);
        this.count = count;
        this.borderColor = borderColor;
        this.realStartAngle = startAngle;
        this.realSweepAngle = sweepAngle;
        this.startAngle = StiPie3dHelper.transformAngle(this.getClientRectangle(), startAngle);
        this.sweepAngle = sweepAngle;
        this.sweepAngle = sweepAngle;
        if (this.sweepAngle % 180.0f != 0.0f) {
            this.sweepAngle = StiPie3dHelper.transformAngle(this.getClientRectangle(), startAngle + sweepAngle) - this.startAngle;
        }
        if (this.sweepAngle < 0.0f) {
            this.sweepAngle += 360.0f;
        }
    }
}

