/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.gantt;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.enums.StiShadowSides;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.StiSeriesElementGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.gantt.IStiGanttSeries;

public class StiGanttSeriesElementGeom
extends StiSeriesElementGeom {
    private Integer beginTime;

    public Integer getBeginTime() {
        return this.beginTime;
    }

    @Override
    public void Draw(StiContext context) {
        IStiSeries tempVar = this.getSeries();
        IStiGanttSeries currSeries = (IStiGanttSeries)(tempVar instanceof IStiGanttSeries ? tempVar : null);
        StiRectangle seriesRect = this.getClientRectangle();
        StiRectangle rectColumn = this.getClientRectangle();
        StiChart chart = (StiChart)this.getSeries().getChart();
        StiBrush brush = currSeries.ProcessSeriesBrushes(this.getIndex(), currSeries.getBrush());
        if (chart.isAnimation) {
            StiPenGeom pen = new StiPenGeom(currSeries.getBorderColor());
            StiOpacityAnimation animationOpacity = new StiOpacityAnimation(StiChartHelper.GlobalDurationElement, this.beginTime);
            context.DrawAnimationBar((Object)brush, pen, (Object)rectColumn, Double.valueOf(this.getValue()), this.GetToolTip(), (Object)this, (StiAnimation)animationOpacity, this.getInteractionData());
        } else {
            if (currSeries.getShowShadow() && seriesRect.width > 4.0 && seriesRect.height > 4.0) {
                context.drawCachedShadow(seriesRect, new StiEnumSet((Enum)StiShadowSides.All), context.Options.isPrinting);
            }
            StiPenGeom pen = new StiPenGeom(currSeries.getBorderColor());
            context.FillRectangle((Object)currSeries.getBrush(), seriesRect.x, seriesRect.y, seriesRect.width, seriesRect.height, this.getInteractionData());
            if (this.getIsMouseOver() || this.getSeries().getCore().getIsMouseOver()) {
                context.FillRectangle((Object)StiMouseOverHelper.GetMouseOverColor(), seriesRect.x, seriesRect.y, seriesRect.width, seriesRect.height, null);
            }
            context.DrawRectangle(pen, seriesRect.x, seriesRect.y, seriesRect.width, seriesRect.height);
        }
    }

    public StiGanttSeriesElementGeom(StiAreaGeom areaGeom, double value, int index, IStiSeries series, StiRectangle clientRectangle, Integer beginTime) {
        super(areaGeom, value, index, series, clientRectangle);
        this.beginTime = beginTime;
    }
}

