/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.financial;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.financial.StiFinancialSeriesElementGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.stock.IStiStockArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.stock.IStiStockSeries;

public class StiStockSeriesElementGeom
extends StiFinancialSeriesElementGeom {
    private final StiColor color;
    private Integer beginTime;

    public final StiColor getColor() {
        return this.color;
    }

    public Integer getBeginTime() {
        return this.beginTime;
    }

    @Override
    public void Draw(StiContext context) {
        IStiArea tempVar = this.getAreaGeom().getArea();
        IStiStockArea stockArea = (IStiStockArea)(tempVar instanceof IStiStockArea ? tempVar : null);
        IStiSeries tempVar2 = this.getSeries();
        IStiStockSeries stockSeries = (IStiStockSeries)(tempVar2 instanceof IStiStockSeries ? tempVar2 : null);
        double open = this.getOpen();
        double close = this.getClose();
        double high = this.getHigh();
        double low = this.getLow();
        double positionX = this.getPositionX();
        double lineWidht = (double)stockSeries.getLineWidth() * context.Options.zoom;
        float width = (float)stockArea.getXAxis().getInfo().Dpi / 3.0f;
        StiPenGeom pen = new StiPenGeom(this.color, lineWidht);
        pen.setPenStyle(stockSeries.getLineStyle());
        StiChart chart = (StiChart)this.getSeries().getChart();
        if (chart.isAnimation) {
            StiOpacityAnimation animationOpacity = new StiOpacityAnimation(StiChartHelper.GlobalDurationElement, this.beginTime);
            if (stockSeries.getShowShadow()) {
                double lineWidgtShadow = lineWidht + 0.5 * context.Options.zoom;
                StiPenGeom penShadow = new StiPenGeom(StiColor.fromArgb((int)50, (int)0, (int)0, (int)0), lineWidgtShadow);
                penShadow.setPenStyle(stockSeries.getLineStyle());
                StiPoint[] pointsShadow1 = new StiPoint[]{new StiPoint(this.getPositionX(), this.getHigh()), new StiPoint(this.getPositionX(), this.getLow())};
                StiPoint[] pointsShadow2 = new StiPoint[]{new StiPoint(this.getPositionX() - (double)width, this.getOpen()), new StiPoint(this.getPositionX() - lineWidgtShadow / 2.0, this.getOpen())};
                StiPoint[] pointsShadow3 = new StiPoint[]{new StiPoint(this.getPositionX() + (double)width, this.getClose()), new StiPoint(this.getPositionX() + lineWidgtShadow / 2.0, this.getClose())};
                context.DrawAnimationLines(penShadow, pointsShadow1, (StiAnimation)animationOpacity);
                context.DrawAnimationLines(penShadow, pointsShadow2, (StiAnimation)animationOpacity);
                context.DrawAnimationLines(penShadow, pointsShadow3, (StiAnimation)animationOpacity);
            }
            StiPoint[] points1 = new StiPoint[]{new StiPoint(this.getPositionX(), this.getHigh()), new StiPoint(this.getPositionX(), this.getLow())};
            StiPoint[] points2 = new StiPoint[]{new StiPoint(this.getPositionX() - (double)width, this.getOpen()), new StiPoint(this.getPositionX(), this.getOpen())};
            StiPoint[] points3 = new StiPoint[]{new StiPoint(this.getPositionX() + (double)width, this.getClose()), new StiPoint(this.getPositionX(), this.getClose())};
            context.DrawAnimationLines(pen, points1, (StiAnimation)animationOpacity);
            context.DrawAnimationLines(pen, points2, (StiAnimation)animationOpacity);
            context.DrawAnimationLines(pen, points3, (StiAnimation)animationOpacity);
        } else {
            if (stockSeries.getShowShadow()) {
                double lineWidgtShadow = lineWidht + 0.5 * context.Options.zoom;
                StiPenGeom penShadow = new StiPenGeom(StiColor.fromArgb((int)50, (int)0, (int)0, (int)0), lineWidgtShadow);
                penShadow.setPenStyle(stockSeries.getLineStyle());
                context.PushTranslateTransform(lineWidht, lineWidht);
                context.DrawLine(penShadow, positionX, high, positionX, low);
                context.DrawLine(penShadow, positionX - (double)width, open, positionX - lineWidgtShadow / 2.0, open);
                context.DrawLine(penShadow, positionX + (double)width, close, positionX + lineWidgtShadow / 2.0, close);
                context.PopTransform();
            }
            context.DrawLine(pen, positionX, high, positionX, low);
            context.DrawLine(pen, positionX - (double)width, open, positionX, open);
            context.DrawLine(pen, positionX + (double)width, close, positionX, close);
        }
    }

    public StiStockSeriesElementGeom(StiAreaGeom areaGeom, IStiSeries series, StiRectangle clientRectangle, double open, double close, double high, double low, double positionX, int index, StiColor color, Integer beginTime) {
        super(areaGeom, series, clientRectangle, open, close, high, low, positionX, index);
        this.color = color;
        this.beginTime = beginTime;
    }
}

