/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.clusteredColumn;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.context.chart.geoms.enums.StiPenLineCap;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiPointHelper;
import com.stimulsoft.report.chart.geoms.StiNullableDrawing;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.clusteredColumn.StiBaseLineSeriesGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredColumn.IStiSplineSeries;
import com.stimulsoft.report.chart.interfaces.series.radar.IStiRadarAreaSeries;
import com.stimulsoft.report.chart.interfaces.series.radar.IStiRadarLineSeries;

public class StiSplineSeriesGeom
extends StiBaseLineSeriesGeom {
    @Override
    public boolean Contains(double x, double y) {
        if (this.getInvisible()) {
            return false;
        }
        for (int pointIndex = 0; pointIndex < this.getPoints().length - 1; ++pointIndex) {
            boolean result;
            StiPoint point1 = this.getPoints()[pointIndex];
            StiPoint point2 = this.getPoints()[pointIndex + 1];
            if (point1 == null || point2 == null || !(result = StiPointHelper.IsLineContainsPoint(point1.getValue(), point2.getValue(), StiMouseOverHelper.MouseOverSplineDistance, new StiPoint(x, y)))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void Draw(StiContext context) {
        IStiSeries tempVar3;
        IStiRadarAreaSeries radarAreaSeries;
        IStiSeries tempVar2;
        IStiRadarLineSeries radarLineSeries;
        StiRectangle rect = this.getClientRectangle();
        StiPenStyle coreLineStyle = StiPenStyle.Solid;
        float lineWidth = 1.0f;
        StiColor coreLineColor = StiColor.Black;
        boolean showShadow = true;
        boolean lighting = true;
        float tension = 1.0f;
        IStiSeries tempVar = this.getSeries();
        IStiSplineSeries splineSeries = (IStiSplineSeries)(tempVar instanceof IStiSplineSeries ? tempVar : null);
        if (splineSeries != null) {
            coreLineStyle = splineSeries.getLineStyle();
            lineWidth = splineSeries.getLineWidth();
            coreLineColor = splineSeries.getLineColor();
            showShadow = splineSeries.getShowShadow();
            lighting = splineSeries.getLighting();
            tension = splineSeries.getTension();
        }
        if ((radarLineSeries = (IStiRadarLineSeries)((tempVar2 = this.getSeries()) instanceof IStiRadarLineSeries ? tempVar2 : null)) != null) {
            coreLineStyle = radarLineSeries.getLineStyle();
            lineWidth = radarLineSeries.getLineWidth();
            coreLineColor = radarLineSeries.getLineColor();
            showShadow = radarLineSeries.getShowShadow();
            lighting = radarLineSeries.getLighting();
        }
        if ((radarAreaSeries = (IStiRadarAreaSeries)((tempVar3 = this.getSeries()) instanceof IStiRadarAreaSeries ? tempVar3 : null)) != null) {
            coreLineStyle = radarAreaSeries.getLineStyle();
            lineWidth = radarAreaSeries.getLineWidth();
            coreLineColor = radarAreaSeries.getLineColor();
            showShadow = radarAreaSeries.getShowShadow();
            lighting = radarAreaSeries.getLighting();
        }
        context.PushSmoothingModeToAntiAlias();
        StiPenStyle dashStyle = coreLineStyle;
        double scaledLineWidth = lineWidth;
        StiPenGeom pen = new StiPenGeom(coreLineColor, scaledLineWidth);
        pen.setPenStyle(dashStyle);
        StiChart chart = (StiChart)this.getSeries().getChart();
        if (showShadow) {
            StiPenGeom penShadow = new StiPenGeom(StiColor.fromArgb((int)50, (int)0, (int)0, (int)0), scaledLineWidth + 0.5 * context.Options.zoom);
            penShadow.setPenStyle(dashStyle);
            context.PushTranslateTransform(scaledLineWidth, scaledLineWidth);
            StiNullableDrawing.DrawCurve(context, penShadow, this.getPoints(), tension, chart.isAnimation);
            context.PopTransform();
        }
        if (this.getSeries().getCore().getIsMouseOver()) {
            double zoom = context.Options.zoom;
            float pointSize = 11.0f + lineWidth;
            for (StiPoint point : this.getPoints()) {
                if (point == null) continue;
                StiRectangle pointRect = new StiRectangle(point.getValue().x - (double)(pointSize / 2.0f) * zoom, point.getValue().y - (double)(pointSize / 2.0f) * zoom, (double)pointSize * zoom, (double)pointSize * zoom);
                context.FillEllipse((Object)StiMouseOverHelper.GetLineMouseOverColor(), pointRect, null);
            }
            StiPenGeom penMouseOver = new StiPenGeom(StiMouseOverHelper.GetLineMouseOverColor(), (double)(4.0f + lineWidth) * context.Options.zoom);
            penMouseOver.setStartCap(StiPenLineCap.Round);
            penMouseOver.setEndCap(StiPenLineCap.Round);
            StiNullableDrawing.DrawCurve(context, penMouseOver, this.getPoints(), tension, chart.isAnimation);
        }
        StiNullableDrawing.DrawCurve(context, pen, this.getPointsFrom(), this.getPoints(), tension, chart.isAnimation);
        if (scaledLineWidth >= 2.0 && lighting) {
            double step = 0.5 * context.Options.zoom;
            context.PushTranslateTransform(-step, -step);
            StiPenGeom penLight = new StiPenGeom(StiColorUtils.light((StiColor)coreLineColor, (int)70), scaledLineWidth);
            penLight.setPenStyle(dashStyle);
            StiNullableDrawing.DrawCurve(context, penLight, this.getPoints(), tension, chart.isAnimation);
            context.PopTransform();
        }
        if (splineSeries != null && splineSeries.getAllowApplyColorNegative()) {
            StiPenGeom penNegative = new StiPenGeom(splineSeries.getLineColorNegative(), scaledLineWidth);
            penNegative.setPenStyle(dashStyle);
            IStiArea tempVar4 = this.getSeries().getChart().getArea();
            IStiAxisArea axisArea = (IStiAxisArea)(tempVar4 instanceof IStiAxisArea ? tempVar4 : null);
            double posY = axisArea.getAxisCore().GetDividerY();
            double width = axisArea.getAxisCore().getScrollRangeX() * axisArea.getAxisCore().getScrollDpiX();
            double height = axisArea.getAxisCore().getScrollRangeY() * axisArea.getAxisCore().getScrollDpiY() - posY;
            StiRectangle clipRect = new StiRectangle(0.0, posY, width, height);
            context.PushClip(clipRect);
            StiNullableDrawing.DrawCurve(context, penNegative, this.getPoints(), tension, chart.isAnimation);
            if (scaledLineWidth >= 2.0 && lighting) {
                double step = 0.5 * context.Options.zoom;
                context.PushTranslateTransform(-step, -step);
                StiPenGeom penLight = new StiPenGeom(StiColorUtils.light((StiColor)splineSeries.getLineColorNegative(), (int)70), scaledLineWidth);
                penLight.setPenStyle(dashStyle);
                StiNullableDrawing.DrawCurve(context, penLight, this.getPoints(), tension, chart.isAnimation);
                context.PopTransform();
            }
            context.PopClip();
        }
        context.PopSmoothingMode();
    }

    public StiSplineSeriesGeom(StiAreaGeom areaGeom, StiPoint[] pointsFrom, StiPoint[] points, IStiSeries series) {
        super(areaGeom, pointsFrom, points, series);
    }
}

