/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.radarAxis;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripPositionXF;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.interfaces.axis.IStiAxisTicks;
import com.stimulsoft.report.chart.interfaces.radarAxis.IStiYRadarAxis;

public class StiRadarAxisGeom
extends StiCellGeom {
    private final IStiYRadarAxis axis;

    public final IStiYRadarAxis getAxis() {
        return this.axis;
    }

    private void DrawAxisLine(StiContext context, StiRectangle rect) {
        double posX = rect.getRight();
        StiPenGeom penLine = new StiPenGeom(this.getAxis().getLineColor(), (double)this.getAxis().getLineWidth());
        context.DrawLine(penLine, posX, rect.y, posX, rect.getBottom());
    }

    private void DrawMinorTicks(StiContext context, StiPenGeom pen, double posX, double posY1, double posY2, IStiAxisTicks ticks) {
        double step = posY2 - posY1;
        double minorStep = step / (double)(ticks.getMinorCount() + 1);
        double minorLength = (double)ticks.getMinorLength() * context.Options.zoom;
        for (int minorIndex = 1; minorIndex <= ticks.getMinorCount(); ++minorIndex) {
            double posY = posY1 + minorStep * (double)minorIndex;
            double posX2 = posX - minorLength;
            context.DrawLine(pen, posX, posY, posX2, posY);
        }
    }

    private void DrawTicks(StiContext context, StiRectangle rect, IStiAxisTicks ticks, StiPenGeom penLine) {
        if (!ticks.getVisible()) {
            return;
        }
        double ticksLength = (double)ticks.getLength() * context.Options.zoom;
        double posX1 = rect.getRight();
        double posX2 = posX1 - ticksLength;
        int index = 0;
        for (StiStripPositionXF strip : this.getAxis().getInfo().TicksCollection) {
            double posY = strip.Position;
            context.DrawLine(penLine, posX1, posY, posX2, posY);
            if (ticks.getMinorVisible() && index != this.getAxis().getInfo().TicksCollection.size() - 1) {
                double posY2 = this.getAxis().getInfo().TicksCollection.get((int)(index + 1)).Position;
                this.DrawMinorTicks(context, penLine, posX1, posY, posY2, ticks);
            }
            ++index;
        }
    }

    private void DrawAxis(StiContext context, StiRectangle rect) {
        StiPenGeom penLine = new StiPenGeom(this.getAxis().getLineColor(), (double)this.getAxis().getLineWidth());
        penLine.setPenStyle(this.getAxis().getLineStyle());
        this.DrawTicks(context, rect, this.getAxis().getArea().getYAxis().getTicks(), penLine);
        this.DrawAxisLine(context, rect);
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle rect = this.getClientRectangle();
        if (rect.width <= 0.0 || rect.height <= 0.0) {
            return;
        }
        this.DrawAxis(context, rect);
    }

    public StiRadarAxisGeom(IStiYRadarAxis axis, StiRectangle clientRectangle) {
        super(clientRectangle);
        this.axis = axis;
    }
}

