/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.marker;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiCloseFigureSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiLinesSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.interfaces.legend.IStiLegendMarker;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.funnel.IStiFunnelSeries;
import java.util.ArrayList;

public class StiLegendFunnelMarker
implements IStiLegendMarker {
    @Override
    public void Draw(StiContext context, IStiSeries serie, StiRectangle rect, int colorIndex, int colorCount, int index) {
        IStiFunnelSeries series = (IStiFunnelSeries)serie;
        StiBrush seriesBrush = series.getBrush();
        if (series.getAllowApplyBrush()) {
            seriesBrush = series.getCore().GetSeriesBrush(colorIndex, colorCount);
            seriesBrush = series.ProcessSeriesColors(colorIndex, seriesBrush);
        }
        StiColor borderColor = series.getBorderColor().clone();
        if (series.getAllowApplyBorderColor()) {
            borderColor = (StiColor)series.getCore().GetSeriesBorderColor(colorIndex, colorCount);
        }
        ArrayList<Object> path = new ArrayList<Object>();
        StiPenGeom pen = new StiPenGeom(borderColor);
        context.PushSmoothingModeToAntiAlias();
        StiPoint[] points = new StiPoint[]{new StiPoint(rect.x, rect.y), new StiPoint(rect.getRight(), rect.y), new StiPoint(rect.x + rect.width * 3.0 / 4.0, rect.getTop() + rect.height / 2.0), new StiPoint(rect.x + rect.width * 3.0 / 4.0, rect.getBottom()), new StiPoint(rect.x + rect.width * 1.0 / 4.0, rect.getBottom()), new StiPoint(rect.x + rect.width * 1.0 / 4.0, rect.getTop() + rect.height / 2.0)};
        path.add(new StiLinesSegmentGeom(points));
        path.add(new StiCloseFigureSegmentGeom());
        context.FillPath((Object)seriesBrush, path, (Object)rect, null, index);
        context.DrawPath(pen, path, null);
        context.PopSmoothingMode();
    }
}

