/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.trendLines;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.report.chart.core.trendLines.StiTrendLineCoreXF;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.trendLines.StiTrendCurveGeom;
import com.stimulsoft.report.chart.interfaces.trendLines.IStiTrendLine;

public class StiTrendLineLogarithmicCoreXF
extends StiTrendLineCoreXF {
    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"PropertyMain", (String)"Logarithmic");
    }

    @Override
    public void RenderTrendLine(StiAreaGeom geom, StiPoint[] points, double posY) {
        if (points.length > 0) {
            double[] valuesX = new double[points.length];
            double[] valuesY = new double[points.length];
            double maxValue = points[0].getValue().x;
            double minValue = points[0].getValue().x;
            for (int pointIndex = 0; pointIndex < points.length; ++pointIndex) {
                valuesX[pointIndex] = (float)Math.log(points[pointIndex].getValue().x);
                valuesY[pointIndex] = points[pointIndex].getValue().y;
                if (maxValue < points[pointIndex].getValue().x) {
                    maxValue = points[pointIndex].getValue().x;
                }
                if (!(minValue > points[pointIndex].getValue().x)) continue;
                minValue = points[pointIndex].getValue().x;
            }
            int countPoints = points.length;
            float sumX = this.Sum(valuesX);
            float sumY = this.Sum(valuesY);
            float sumX2 = this.SumSqr(valuesX);
            float sumProductionsXY = this.SumProductions(valuesX, valuesY);
            float c = sumX * sumX - sumX2 * (float)countPoints;
            float a = (sumY * sumX - sumProductionsXY * (float)countPoints) / c;
            float b = (sumX * sumProductionsXY - sumX2 * sumY) / c;
            StiPoint[] pointTemp = new StiPoint[31];
            for (int index = 0; index < 31; ++index) {
                double x = minValue + (maxValue - minValue) / 30.0 * (double)index;
                float y = a * (float)Math.log(x) + b;
                pointTemp[index] = new StiPoint(x, (double)y);
            }
            StiTrendCurveGeom curve = new StiTrendCurveGeom(pointTemp, this.getTrendLine());
            geom.CreateChildGeoms();
            geom.getChildGeoms().add(curve);
        }
    }

    public StiTrendLineLogarithmicCoreXF(IStiTrendLine trendLine) {
        super(trendLine);
    }
}

