/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.seriesLabels.axis;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiLabelAnimation;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.context.chart.geoms.StiStringFormatGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.enums.StiRotationMode;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.core.seriesLabels.axis.StiAxisSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.enums.StiChartSeriesOrientation;
import com.stimulsoft.report.chart.enums.StiSeriesLabelsPosition;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.axis.StiCenterAxisLabelsGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;

public class StiCenterAxisLabelsCoreXF
extends StiAxisSeriesLabelsCoreXF {
    @Override
    public StiSeriesLabelsGeom RenderLabel(IStiSeries series, StiContext context, StiPoint endPoint, StiPoint startPoint, int pointIndex, Double value, Double labelValue, String argumentText, String tag, int colorIndex, int colorCount, StiRectangle rect, StiAnimation animation) {
        return this.RenderLabel(series, context, endPoint, startPoint, pointIndex, value, labelValue, argumentText, tag, 0.0, colorIndex, colorCount, rect, animation);
    }

    @Override
    public StiSeriesLabelsGeom RenderLabel(IStiSeries series, StiContext context, StiPoint endPoint, StiPoint startPoint, int pointIndex, Double value, Double labelValue, String argumentText, String tag, double weight, int colorIndex, int colorCount, StiRectangle rect, StiAnimation animation) {
        StiLabelAnimation animationLabel;
        if (value == null && !this.getSeriesLabels().getShowNulls()) {
            return null;
        }
        if (value != null && value == 0.0 && !this.getSeriesLabels().getShowZeros()) {
            return null;
        }
        if (value == null) {
            value = 0.0;
        }
        if (labelValue == null) {
            labelValue = 0.0;
        }
        String labelText = this.GetLabelText(series, labelValue, argumentText, tag, series.getCoreTitle(), weight, false);
        StiColor labelColor = this.GetLabelColor(series, colorIndex, colorCount);
        StiColor labelBorderColor = this.GetBorderColor(series, colorIndex, colorCount);
        StiStringFormatGeom sf = context.GetDefaultStringFormat();
        StiFontGeom font = StiFontGeom.ChangeFontSize((StiFont)this.getSeriesLabels().getFont(), (double)(this.getSeriesLabels().getFont().size * context.Options.zoom));
        StiColor seriesBorderColor = (StiColor)series.getCore().GetSeriesBorderColor(colorIndex, colorCount);
        StiBrush seriesBrush = series.getCore().GetSeriesBrush(colorIndex, colorCount);
        StiBrush seriesLabelsBrush = this.ProcessSeriesColors(pointIndex, this.getSeriesLabels().getBrush(), series);
        StiRectangle labelRect = this.GetLabelRect(context, endPoint, startPoint, value, labelText, true, font, sf);
        StiLabelAnimation stiLabelAnimation = animationLabel = animation instanceof StiLabelAnimation ? (StiLabelAnimation)animation : null;
        if (animationLabel != null) {
            animationLabel.setLabelRect(this.GetLabelRect(context, animationLabel.getPointFrom(), startPoint, animationLabel.getValueFrom(), String.valueOf(animationLabel.getValueFrom()), true, font, sf));
        }
        return new StiCenterAxisLabelsGeom(this.getSeriesLabels(), series, pointIndex, value, labelRect, labelText, labelColor, labelBorderColor, seriesBrush, seriesLabelsBrush, seriesBorderColor, font, animation);
    }

    protected StiRectangle GetLabelRect(StiContext context, StiPoint endPoint, StiPoint startPoint, Double value, String labelText, boolean checkHeight, StiFontGeom font, StiStringFormatGeom sf) {
        if (this.getSeriesLabels().getChart().getArea().getCore().getSeriesOrientation() == StiChartSeriesOrientation.Vertical) {
            return context.MeasureRotatedString(labelText, font, new StiPoint(endPoint.x, (endPoint.y + startPoint.y) / 2.0), sf, StiRotationMode.CenterCenter, 0.0);
        }
        return context.MeasureRotatedString(labelText, font, new StiPoint((endPoint.x + startPoint.x) / 2.0, endPoint.y), sf, StiRotationMode.CenterCenter, 0.0);
    }

    @Override
    public int getPosition() {
        return StiSeriesLabelsPosition.CenterAxis.getValue();
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"LabelsCenter");
    }

    public StiCenterAxisLabelsCoreXF(IStiSeriesLabels seriesLabels) {
        super(seriesLabels);
    }
}

