/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.pie;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.core.series.pie.StiPieSeriesCoreXF;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.pie.IStiPie3dSeries;
import com.stimulsoft.report.chart.view.series.pie.StiPie3dSeries;
import com.stimulsoft.report.chart.view.series.pie.StiPie3dSlice;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;

public class StiPie3dSeriesCoreXF
extends StiPieSeriesCoreXF {
    private StiPie3dSlice[] mPieSlices;
    private float pieHeight;

    @Override
    public void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, IStiSeries[] seriesArray) {
        this.initializePieSlices(geom.getArea(), rect, seriesArray, (float)context.Options.zoom);
        if (this.mPieSlices == null || this.mPieSlices.length == 0) {
            this.initializeEmptyPieSlices(geom.getArea(), rect, seriesArray, (float)context.Options.zoom);
        }
        this.drawBottoms(geom);
        if (this.pieHeight > 0.0f) {
            this.drawSliceSides(geom);
        }
        this.drawTops(geom);
        this.drawLabels(geom, context);
    }

    private void drawLabels(StiAreaGeom areaGeom, StiContext context) {
        if (this.mPieSlices == null) {
            return;
        }
        for (int index = 0; index < this.mPieSlices.length; ++index) {
            StiPie3dSlice pieSlice = this.mPieSlices[index];
            pieSlice.drawLabels(areaGeom, context);
        }
    }

    private void drawTops(StiAreaGeom areaGeom) {
        if (this.mPieSlices == null) {
            return;
        }
        for (int index = 0; index < this.mPieSlices.length; ++index) {
            StiPie3dSlice pieSlice = this.mPieSlices[index];
            pieSlice.drawTopPieSliceGeom(areaGeom);
        }
    }

    private void drawSliceSides(StiAreaGeom areaGeom) {
        StiPie3dSlice[] splitSlices;
        if (this.mPieSlices == null) {
            return;
        }
        ArrayList<StiPie3dSlice> pieSlicesList = new ArrayList<StiPie3dSlice>(Arrays.asList(this.mPieSlices));
        if (pieSlicesList.isEmpty()) {
            return;
        }
        StiPie3dSlice pieSlice = null;
        if (this.mPieSlices[0].getStartAngle() > 90.0f && this.mPieSlices[0].getStartAngle() <= 270.0f && this.mPieSlices[0].getStartAngle() + this.mPieSlices[0].getSweepAngle() > 450.0f) {
            pieSlice = (StiPie3dSlice)pieSlicesList.get(0);
            pieSlice.initTextPosition(areaGeom);
            splitSlices = pieSlice.split(0.0f);
            pieSlicesList.set(0, splitSlices[0]);
            if (Math.abs(splitSlices[1].getSweepAngle()) > 0.0f) {
                pieSlicesList.add(1, splitSlices[1]);
            }
        } else if (this.mPieSlices[0].getStartAngle() > 270.0f && this.mPieSlices[0].getStartAngle() + this.mPieSlices[0].getSweepAngle() > 450.0f || this.mPieSlices[0].getStartAngle() < 90.0f && this.mPieSlices[0].getStartAngle() + this.mPieSlices[0].getSweepAngle() > 270.0f) {
            pieSlice = (StiPie3dSlice)pieSlicesList.get(0);
            pieSlice.initTextPosition(areaGeom);
            splitSlices = pieSlice.split(180.0f);
            pieSlicesList.set(0, splitSlices[1]);
            if (Math.abs(splitSlices[1].getSweepAngle()) > 0.0f) {
                pieSlicesList.add(splitSlices[0]);
            }
        }
        pieSlice = (StiPie3dSlice)pieSlicesList.get(0);
        pieSlice.drawSides(areaGeom);
        int incrementIndex = 1;
        int decrementIndex = pieSlicesList.size() - 1;
        while (incrementIndex < decrementIndex) {
            StiPie3dSlice sliceRight;
            float angle2;
            StiPie3dSlice sliceLeft = (StiPie3dSlice)pieSlicesList.get(decrementIndex);
            float angle1 = sliceLeft.getStartAngle() - 90.0f;
            if (angle1 > 180.0f || angle1 < 0.0f) {
                angle1 = 0.0f;
            }
            if ((angle2 = (450.0f - (sliceRight = (StiPie3dSlice)pieSlicesList.get(incrementIndex)).getEndAngle()) % 360.0f) > 180.0f || angle2 < 0.0f) {
                angle2 = 0.0f;
            }
            if (angle2 >= angle1) {
                sliceRight.drawSides(areaGeom);
                ++incrementIndex;
                continue;
            }
            if (!(angle2 < angle1)) continue;
            sliceLeft.drawSides(areaGeom);
            --decrementIndex;
        }
        pieSlice = (StiPie3dSlice)pieSlicesList.get(decrementIndex);
        pieSlice.drawSides(areaGeom);
    }

    private void drawBottoms(StiAreaGeom areaGeom) {
        if (this.mPieSlices == null) {
            return;
        }
        for (int index = 0; index < this.mPieSlices.length; ++index) {
            StiPie3dSlice pieSlice = this.mPieSlices[index];
            pieSlice.drawBottomPieSliceGeom(areaGeom);
        }
    }

    protected void initializePieSlices(IStiArea area, StiRectangle mainRect, IStiSeries[] seriesArray, float zoom) {
        StiRectangle boundingRect = this.measureBoundingRect(mainRect);
        ArrayList<StiPie3dSlice> listPieSlices = new ArrayList<StiPie3dSlice>();
        float gradPerValue = this.GetGradPerValue(seriesArray, false);
        IStiPie3dSeries currentSeries = seriesArray[0] instanceof IStiPie3dSeries ? (IStiPie3dSeries)seriesArray[0] : null;
        float startAngle = currentSeries.getStartAngle() % 360.0f;
        int colorCount = this.GetColorCount(seriesArray, false);
        this.pieHeight = currentSeries.getOptions3D().getHeight() * zoom;
        float largestDisplacement = this.getLargestDisplacement(zoom);
        StiSize topEllipeSize = this.getTopEllipseSize(boundingRect, zoom);
        int colorIndex = 0;
        int backPieIndex = -1;
        for (IStiSeries ser1 : seriesArray) {
            IStiPie3dSeries ser = (IStiPie3dSeries)ser1;
            for (int index = 0; index < ser.getValues().length; ++index) {
                Double value = ser.getValues()[index];
                if (value != 0.0) {
                    BigDecimal decGradPerValue = new BigDecimal(gradPerValue);
                    BigDecimal decValue = new BigDecimal(Math.abs(value));
                    BigDecimal step = decGradPerValue.multiply(decValue);
                    float sweepAngle = (float)((double)gradPerValue * Math.abs(value));
                    StiBrush seriesBrush = ser.getBrush();
                    if (ser.getAllowApplyBrush()) {
                        seriesBrush = ser.getCore().GetSeriesBrush(colorIndex, colorCount);
                        seriesBrush = ser.ProcessSeriesBrushes(index, seriesBrush);
                    }
                    if (ser.getOptions3D().getOpacity() >= 0.0f && ser.getOptions3D().getOpacity() < 1.0f) {
                        StiColor color = StiBrush.ToColor((StiBrush)seriesBrush);
                        color = StiColor.fromArgb((int)((int)(255.0f * ser.getOptions3D().getOpacity())), (int)color.r, (int)color.g, (int)color.b);
                        seriesBrush = new StiSolidBrush(color);
                    }
                    StiColor borderColor = ser.getBorderColor();
                    if (ser.getAllowApplyBorderColor()) {
                        borderColor = (StiColor)ser.getCore().GetSeriesBorderColor(colorIndex, colorCount);
                    }
                    float xDisplacement = this.getLargestDisplacement(zoom);
                    float yDisplacement = this.getLargestDisplacement(zoom);
                    if (xDisplacement > 0.0f) {
                        StiSize pieDisplacement = this.getSliceDisplacement(startAngle + sweepAngle / 2.0f, xDisplacement, yDisplacement);
                        xDisplacement = (float)pieDisplacement.width;
                        yDisplacement = (float)pieDisplacement.height;
                    }
                    StiRectangle rectPieSlilce = new StiRectangle(boundingRect.x + (double)(2.0f * largestDisplacement) + (double)xDisplacement, boundingRect.y + (double)(2.0f * largestDisplacement) + (double)yDisplacement, topEllipeSize.width, topEllipeSize.height);
                    StiPie3dSlice slice = new StiPie3dSlice(area, value, this.GetArgumentText(ser, index), ser.getCore().GetTag(index), index, ser, rectPieSlilce, this.pieHeight, startAngle % 360.0f, sweepAngle, seriesBrush, borderColor, colorIndex, colorCount);
                    if (backPieIndex > -1 || startAngle <= 270.0f && startAngle + sweepAngle > 270.0f || startAngle >= 270.0f && startAngle + sweepAngle > 630.0f) {
                        listPieSlices.add(++backPieIndex, slice);
                    } else {
                        listPieSlices.add(slice);
                    }
                    startAngle += sweepAngle;
                }
                ++colorIndex;
                if (!(startAngle > 360.0f)) continue;
                startAngle -= 360.0f;
            }
        }
        this.mPieSlices = listPieSlices.toArray(new StiPie3dSlice[0]);
    }

    private StiRectangle measureBoundingRect(StiRectangle mainRect) {
        float factor = 1.61f;
        StiRectangle boundingRect = StiRectangle.getEmpty();
        if (mainRect.width / mainRect.height > (double)factor) {
            double width = mainRect.height * (double)factor;
            boundingRect = new StiRectangle((mainRect.width - width) / 2.0, 0.0, width, mainRect.height);
        } else {
            double height = mainRect.width / (double)factor;
            boundingRect = new StiRectangle(0.0, (mainRect.height - height) / 2.0, mainRect.width, height);
        }
        boundingRect = new StiRectangle(boundingRect.x + boundingRect.width * (double)0.025f, boundingRect.y + boundingRect.height * (double)0.025f, boundingRect.width * (double)0.95f, boundingRect.height * (double)0.95f);
        return boundingRect;
    }

    protected void initializeEmptyPieSlices(IStiArea area, StiRectangle mainRect, IStiSeries[] seriesArray, float zoom) {
        StiRectangle boundingRect = this.measureBoundingRect(mainRect);
        ArrayList<StiPie3dSlice> listPieSlices = new ArrayList<StiPie3dSlice>();
        StiChart emptyChart = new StiChart();
        StiPie3dSeries emptySeries = new StiPie3dSeries();
        emptySeries.setChart(emptyChart);
        double[] emptyValues = new double[]{1.0, 3.0};
        float gradPerValue = 90.0f;
        float startAngle = 0.0f;
        this.pieHeight = 20.0f * zoom;
        float largestDisplacement = this.getLargestDisplacement(zoom);
        StiSize topEllipeSize = this.getTopEllipseSize(boundingRect, zoom);
        int colorIndex = 0;
        int backPieIndex = -1;
        for (int index = 0; index < emptyValues.length; ++index) {
            double value = emptyValues[index];
            if (value != 0.0) {
                float sweepAngle = (float)((double)gradPerValue * Math.abs(value));
                StiSolidBrush seriesBrush = new StiSolidBrush(StiColor.FromArgb((int)50, (StiColor)StiColorEnum.LightGray.color()));
                StiColor borderColor = StiColorEnum.LightGray.color();
                float xDisplacement = this.getLargestDisplacement(zoom);
                float yDisplacement = this.getLargestDisplacement(zoom);
                if (xDisplacement > 0.0f) {
                    StiSize pieDisplacement = this.getSliceDisplacement(startAngle + sweepAngle / 2.0f, xDisplacement, yDisplacement);
                    xDisplacement = (float)pieDisplacement.width;
                    yDisplacement = (float)pieDisplacement.height;
                }
                StiRectangle rectPieSlilce = new StiRectangle(boundingRect.x + (double)(2.0f * largestDisplacement) + (double)xDisplacement, boundingRect.y + (double)(2.0f * largestDisplacement) + (double)yDisplacement, topEllipeSize.width, topEllipeSize.height);
                StiPie3dSlice slice = new StiPie3dSlice(area, value, "", null, index, emptySeries, rectPieSlilce, this.pieHeight, startAngle % 360.0f, sweepAngle, (StiBrush)seriesBrush, borderColor, 0, 0);
                if (backPieIndex > -1 || startAngle <= 270.0f && startAngle + sweepAngle > 270.0f || startAngle >= 270.0f && startAngle + sweepAngle > 630.0f) {
                    listPieSlices.add(++backPieIndex, slice);
                } else {
                    listPieSlices.add(slice);
                }
                startAngle += sweepAngle;
            }
            ++colorIndex;
            if (!(startAngle > 360.0f)) continue;
            startAngle -= 360.0f;
        }
        this.mPieSlices = listPieSlices.toArray(new StiPie3dSlice[0]);
    }

    private StiSize getTopEllipseSize(StiRectangle boundingRect, float zoom) {
        float distance = this.getLargestDisplacement(zoom);
        float widthTopEllipse = (float)boundingRect.width - 4.0f * distance;
        float heightTopEllipse = (float)boundingRect.height - 4.0f * distance - this.pieHeight;
        if (widthTopEllipse < 1.0f) {
            widthTopEllipse = 1.0f;
        }
        if (heightTopEllipse < 1.0f) {
            heightTopEllipse = 1.0f;
        }
        return new StiSize((double)widthTopEllipse, (double)heightTopEllipse);
    }

    private StiSize getLargestDisplacementEllipseSize(float zoom) {
        float distance = this.getLargestDisplacement(zoom);
        return new StiSize((double)distance, (double)distance);
    }

    protected final StiSize getSliceDisplacement(float angle, float xDisplacement, float yDisplacement) {
        if (xDisplacement == 0.0f) {
            return StiSize.getEmpty();
        }
        float xDisplacementCal = (float)((double)xDisplacement * Math.cos((double)angle * Math.PI / 180.0));
        float yDisplacementCal = (float)((double)yDisplacement * Math.sin((double)angle * Math.PI / 180.0));
        return new StiSize((double)xDisplacementCal, (double)yDisplacementCal);
    }

    private float getLargestDisplacement(double zoom) {
        return ((IStiPie3dSeries)this.getSeries()).getOptions3D().getDistance() * (float)zoom;
    }

    @Override
    public String getLocalizedName() {
        return String.format("3D %1$s", StiLocalization.Get((String)"Chart", (String)"Pie"));
    }

    public StiPie3dSeriesCoreXF(IStiSeries series) {
        super(series);
    }
}

