/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.clusteredColumn;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiColumnAnimation;
import com.stimulsoft.base.context.chart.animation.StiLabelAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.core.area.StiAxisAreaCoreXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.core.series.StiSeriesCoreXF;
import com.stimulsoft.report.chart.core.seriesLabels.axis.StiAxisSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.enums.StiSeriesLabelsValueType;
import com.stimulsoft.report.chart.enums.StiSeriesYAxis;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.areas.StiAxisAreaGeom;
import com.stimulsoft.report.chart.geoms.series.clusteredColumn.StiClusteredColumnSeriesElementGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.areas.clusteredColumn.IStiClusteredColumnArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredColumn.IStiClusteredColumnSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.interfaces.seriesLabels.axis.IStiAxisSeriesLabels;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.view.series.StiSeries;
import java.util.ArrayList;

public class StiClusteredColumnSeriesCoreXF
extends StiSeriesCoreXF {
    @Override
    public void ApplyStyle(IStiChartStyle style, StiColor color) {
        super.ApplyStyle(style, color);
        if (this.getSeries().getAllowApplyStyle()) {
            ((IStiClusteredColumnSeries)this.getSeries()).setBrush(style.getCore().GetColumnBrush(color));
            ((IStiClusteredColumnSeries)this.getSeries()).setBorderColor(style.getCore().GetColumnBorder(color));
        }
    }

    @Override
    public void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, IStiSeries[] series) {
        ArrayList<StiSeriesLabelsGeom> seriesLabelsList = new ArrayList<StiSeriesLabelsGeom>();
        if (series == null || series.length == 0 || this.getSeries().getChart() == null) {
            return;
        }
        boolean isAnimationChangingValues = ((StiChart)this.getSeries().getChart()).isAnimationChangingValues();
        IStiArea area = geom.getArea();
        IStiAxisArea axisArea = area instanceof IStiAxisArea ? (IStiAxisArea)area : null;
        boolean sideBySide = true;
        if (area instanceof IStiClusteredColumnArea) {
            sideBySide = ((IStiClusteredColumnArea)area).isSideBySide();
        }
        boolean getStartFromZero = axisArea.getXAxis().getCore().GetStartFromZero();
        float posY = (float)axisArea.getAxisCore().GetDividerY();
        float posRightY = (float)axisArea.getAxisCore().GetDividerRightY();
        int colorIndex = 0;
        int colorCount = axisArea.getAxisCore().ValuesCount * series.length;
        ArrayList pointsLists = new ArrayList();
        for (int index = 0; index < series.length; ++index) {
            pointsLists.add(new ArrayList());
        }
        float sumSeriesWidth = 0.0f;
        if (sideBySide) {
            for (IStiSeries ser : series) {
                sumSeriesWidth = (float)((double)sumSeriesWidth + axisArea.getXAxis().getInfo().Step / (double)series.length * (double)((IStiClusteredColumnSeries)ser).getWidth());
            }
        }
        for (int pointIndex = 0; pointIndex < axisArea.getAxisCore().ValuesCount; ++pointIndex) {
            double seriesLeftPos = this.MeasureLeftPosition(axisArea, pointIndex, sumSeriesWidth, getStartFromZero);
            int seriesIndex = 0;
            if (axisArea.getReverseHor()) {
                seriesIndex = series.length - 1;
            }
            while (seriesIndex < series.length && !axisArea.getReverseHor() || seriesIndex >= 0 && axisArea.getReverseHor()) {
                double minWidth;
                IStiClusteredColumnSeries currentSeries = series[seriesIndex] instanceof IStiClusteredColumnSeries ? (IStiClusteredColumnSeries)series[seriesIndex] : null;
                double seriesWidth = sideBySide ? axisArea.getXAxis().getInfo().Step / (double)series.length * (double)currentSeries.getWidth() : axisArea.getXAxis().getInfo().Step * (double)currentSeries.getWidth();
                if (seriesWidth < (minWidth = 1.5 * context.Options.zoom)) {
                    seriesWidth = minWidth;
                }
                if (!sideBySide) {
                    int index = getStartFromZero ? pointIndex + 1 : pointIndex;
                    seriesLeftPos = axisArea.getXAxis().getInfo().Step * (double)index - seriesWidth / 2.0;
                }
                Double[] valuesStartApproximation = ((StiSeries)series[seriesIndex]).GetApproximationValuesStart();
                if (pointIndex < currentSeries.getValues().length) {
                    Double value = this.GetSeriesCurrentValue(axisArea, currentSeries, pointIndex);
                    StiRectangle columnRect = this.GetColumnRect(context, currentSeries, value, seriesLeftPos, seriesWidth);
                    Double valueStart = this.GetSeriesValueStart(axisArea, currentSeries.getValuesStart(), pointIndex);
                    Double valueStartApproximation = this.GetSeriesValueStart(axisArea, valuesStartApproximation, pointIndex);
                    StiRectangle columnRectStart = this.GetColumnRect(context, currentSeries, valueStartApproximation != null ? valueStartApproximation : 0.0, seriesLeftPos, seriesWidth);
                    StiRectangle clipRect = ((StiAxisAreaGeom)geom).getView().getClientRectangle();
                    clipRect.x = 0.0;
                    clipRect.y = 0.0;
                    StiRectangle columnRectCheck = columnRect.clone();
                    columnRectCheck.x += geom.getClientRectangle().x;
                    columnRectCheck.y += geom.getClientRectangle().y;
                    if (columnRectCheck.getRight() > clipRect.x && columnRectCheck.x < clipRect.getRight() || ((IStiAxisArea)this.getSeries().getChart().getArea()).getXAxis().getRange().getAuto()) {
                        IStiAxisSeriesLabels labels;
                        StiBrush seriesBrush = this.GetSeriesBrush(currentSeries, value, colorIndex, colorCount, pointIndex);
                        StiColor seriesBorderColor = (StiColor)currentSeries.getCore().GetSeriesBorderColor(colorIndex, colorCount);
                        if (this.getSeries().getChart() != null && this.getSeries().getChart().getStyle() != null && columnRect.height > 0.0) {
                            Integer beginTime = isAnimationChangingValues ? 0 : StiChartHelper.GlobalBeginTimeElement / ((StiAxisAreaCoreXF)axisArea.getCore()).ValuesCount * pointIndex;
                            StiColumnAnimation animation = new StiColumnAnimation(Double.valueOf(value == null ? 0.0 : value), columnRectStart, StiChartHelper.GlobalDurationElement, beginTime);
                            StiClusteredColumnSeriesElementGeom seriesColumnGeom = new StiClusteredColumnSeriesElementGeom(geom, value == null ? 0.0 : value, pointIndex, seriesBrush, seriesBorderColor, currentSeries, columnRect, (StiAnimation)animation);
                            seriesColumnGeom.setInteraction(this.getInteraction(axisArea, currentSeries, pointIndex));
                            geom.CreateChildGeoms();
                            geom.getChildGeoms().add(seriesColumnGeom);
                        }
                        if ((labels = currentSeries.getCore().GetSeriesLabels()) != null && labels.getVisible()) {
                            StiPoint endPoint = this.GetPointEnd(currentSeries, value, seriesLeftPos, seriesWidth);
                            Double seriesValue = 0.0;
                            if (value != null) {
                                seriesValue = axisArea.getReverseVert() ? -value.doubleValue() : value;
                            }
                            StiOpacityAnimation animation = null;
                            if (isAnimationChangingValues) {
                                if (labels.getValueType() == StiSeriesLabelsValueType.Value && StiValidationUtil.isNullOrEmpty((String)labels.getFormat())) {
                                    StiPoint endStiPointrom = this.GetPointEnd(currentSeries, valueStart, seriesLeftPos, seriesWidth);
                                    animation = new StiLabelAnimation(valueStart, value, new StiPoint(endStiPointrom.x, endStiPointrom.y), new StiPoint(endPoint.x, endPoint.y), StiChartHelper.GlobalBeginTimeElement, Integer.valueOf(0));
                                } else {
                                    animation = new StiOpacityAnimation(StiChartHelper.GlobalBeginTimeElement, Integer.valueOf(0));
                                }
                            }
                            if (labels.getStep() == 0 || pointIndex % labels.getStep() == 0) {
                                int argumentIndex = axisArea.getXAxis().getStartFromZero() ? pointIndex + 1 : pointIndex;
                                StiSeriesLabelsGeom seriesLabelsGeom = ((StiAxisSeriesLabelsCoreXF)labels.getCore()).RenderLabel(currentSeries, context, this.CorrectPoint(endPoint, rect), this.CorrectPoint(new StiPoint(endPoint.x, (double)posY), rect), pointIndex, value, seriesValue, axisArea.getAxisCore().GetArgumentLabel((StiStripLineXF)axisArea.getXAxis().getInfo().StripLines.get(argumentIndex), currentSeries), currentSeries.getCore().GetTag(pointIndex), colorIndex, colorCount, rect, (StiAnimation)animation);
                                if (seriesLabelsGeom != null) {
                                    seriesLabelsList.add(seriesLabelsGeom);
                                    seriesLabelsGeom.setClientRectangle(this.CheckLabelsRect((IStiSeriesLabels)labels, geom, seriesLabelsGeom.getClientRectangle()));
                                }
                            }
                        }
                    }
                }
                seriesLeftPos += seriesWidth;
                ++colorIndex;
                if (axisArea.getReverseHor()) {
                    --seriesIndex;
                    continue;
                }
                ++seriesIndex;
            }
        }
        for (StiSeriesLabelsGeom seriesLabelsGeom : seriesLabelsList) {
            geom.CreateChildGeoms();
            geom.getChildGeoms().add(seriesLabelsGeom);
        }
        if (geom.getArea().getChart().getSeriesLabels().getPreventIntersection()) {
            this.CheckIntersectionLabels(geom);
        }
    }

    private StiPoint CorrectPoint(StiPoint point, StiRectangle rect) {
        if (point.y < 0.0) {
            return new StiPoint(point.x, 0.0);
        }
        if (point.y > rect.height) {
            return new StiPoint(point.x, rect.height);
        }
        return point;
    }

    @Override
    public StiBrush GetSeriesBrush(int colorIndex, int colorCount) {
        StiBrush brush = super.GetSeriesBrush(colorIndex, colorCount);
        if (brush == null) {
            return ((IStiClusteredColumnSeries)this.getSeries()).getBrush();
        }
        return brush;
    }

    @Override
    public Object GetSeriesBorderColor(int colorIndex, int colorCount) {
        Object color = super.GetSeriesBorderColor(colorIndex, colorCount);
        if (color == null) {
            return ((IStiClusteredColumnSeries)this.getSeries()).getBorderColor();
        }
        return color;
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"ClusteredColumn");
    }

    public StiClusteredColumnSeriesCoreXF(IStiSeries series) {
        super(series);
    }

    private StiRectangle GetColumnRect(StiContext context, IStiClusteredColumnSeries currentSeries, Double value, double seriesLeftPos, double seriesWidth) {
        IStiAxisArea axisArea = (IStiAxisArea)currentSeries.getChart().getArea();
        double seriesHeight = 0.0;
        double seriesTopPos = 0.0;
        double posY = axisArea.getAxisCore().GetDividerY();
        double posRightY = axisArea.getAxisCore().GetDividerRightY();
        if (currentSeries.getYAxis() == StiSeriesYAxis.LeftYAxis) {
            seriesHeight = (float)((value == null ? 0.0 : value) * axisArea.getYAxis().getInfo().Dpi);
            seriesTopPos = -seriesHeight + posY;
        } else {
            seriesHeight = (float)((value == null ? 0.0 : value) * axisArea.getYRightAxis().getInfo().Dpi);
            seriesTopPos = -seriesHeight + posRightY;
        }
        if (currentSeries.getShowZeros() && (value == null || value == 0.0)) {
            seriesHeight = Math.max(context.Options.zoom, 2.0);
            if (!axisArea.getReverseVert()) {
                seriesTopPos -= seriesHeight;
            }
        }
        if (value != null && value < 0.0) {
            seriesTopPos = currentSeries.getYAxis() == StiSeriesYAxis.LeftYAxis ? posY : posRightY;
            seriesHeight = -seriesHeight;
        }
        return new StiRectangle(seriesLeftPos, seriesTopPos, seriesWidth, seriesHeight);
    }

    private StiPoint GetPointEnd(IStiClusteredColumnSeries currentSeries, Double value, double seriesLeftPos, double seriesWidth) {
        IStiAxisArea axisArea = (IStiAxisArea)currentSeries.getChart().getArea();
        double posY = axisArea.getAxisCore().GetDividerY();
        double posRightY = axisArea.getAxisCore().GetDividerRightY();
        StiPoint endPoint = currentSeries.getYAxis() == StiSeriesYAxis.LeftYAxis ? new StiPoint(seriesLeftPos + seriesWidth / 2.0, (double)(-((float)((value == null ? 0.0 : value) * axisArea.getYAxis().getInfo().Dpi))) + posY) : new StiPoint(seriesLeftPos + seriesWidth / 2.0, (double)(-((float)((value == null ? 0.0 : value) * axisArea.getYRightAxis().getInfo().Dpi))) + posRightY);
        return endPoint;
    }

    private double MeasureLeftPosition(IStiAxisArea axisArea, int pointIndex, float sumSeriesWidth, boolean startFromZero) {
        double posX = startFromZero ? axisArea.getXAxis().getInfo().StripPositions[pointIndex + 1] : axisArea.getXAxis().getInfo().StripPositions[pointIndex];
        double seriesLeftPos = (posX -= axisArea.getXAxis().getInfo().Step / 2.0) + (axisArea.getXAxis().getInfo().Step - (double)sumSeriesWidth) / 2.0;
        return seriesLeftPos;
    }

    private Double GetSeriesCurrentValue(IStiAxisArea axisArea, IStiClusteredColumnSeries currentSeries, int pointIndex) {
        Double value;
        Double d = value = axisArea.getReverseHor() ? currentSeries.getValues()[currentSeries.getValues().length - pointIndex - 1] : currentSeries.getValues()[pointIndex];
        if (axisArea.getReverseVert() && value != null) {
            value = -value.doubleValue();
        }
        return value;
    }

    private Double GetSeriesValueStart(IStiAxisArea axisArea, Double[] valuesStart, int pointIndex) {
        Double valueStart = null;
        if (((StiChart)this.getSeries().getChart()).isAnimationChangingValues()) {
            if (valuesStart != null && valuesStart.length > pointIndex) {
                Double d = valueStart = axisArea.getReverseHor() ? valuesStart[valuesStart.length - pointIndex - 1] : valuesStart[pointIndex];
            }
            if (axisArea.getReverseVert() && valueStart != null) {
                valueStart = -valueStart.doubleValue();
            }
        }
        return valueStart;
    }

    private StiBrush GetSeriesBrush(IStiClusteredColumnSeries currentSeries, Double value, int colorIndex, int colorCount, int pointIndex) {
        StiBrush seriesBrush = currentSeries.getCore().GetSeriesBrush(colorIndex, colorCount);
        if (currentSeries.getAllowApplyBrushNegative() && value < 0.0) {
            seriesBrush = currentSeries.getBrushNegative();
        }
        seriesBrush = currentSeries.ProcessSeriesBrushes(pointIndex, seriesBrush);
        return seriesBrush;
    }
}

