/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.radarAxis;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.context.chart.geoms.StiStringFormatGeom;
import com.stimulsoft.base.drawing.StiTextUtil;
import com.stimulsoft.base.drawing.enums.StiRotationMode;
import com.stimulsoft.base.drawing.enums.StiStringAlignment;
import com.stimulsoft.base.drawing.enums.StiStringFormatFlags;
import com.stimulsoft.base.drawing.enums.StiStringTrimming;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChartOptions;
import com.stimulsoft.report.chart.core.axis.StiAxisInfoXF;
import com.stimulsoft.report.chart.core.axis.StiAxisLabelInfoXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripPositionXF;
import com.stimulsoft.report.chart.core.radarAxis.StiRadarAxisCoreXF;
import com.stimulsoft.report.chart.enums.StiLabelsPlacement;
import com.stimulsoft.report.chart.enums.StiMarkerAlignment;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.radarAxis.StiRadarAxisGeom;
import com.stimulsoft.report.chart.geoms.radarAxis.StiYRadarAxisLabelGeom;
import com.stimulsoft.report.chart.interfaces.radarAxis.IStiRadarAxis;
import com.stimulsoft.report.chart.interfaces.radarAxis.IStiYRadarAxis;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import java.math.BigDecimal;
import java.util.ArrayList;

public class StiYRadarAxisCoreXF
extends StiRadarAxisCoreXF {
    @Override
    public void applyStyle(IStiChartStyle style) {
        if (this.getAxis().getAllowApplyStyle()) {
            this.getYAxis().setLineColor(style.getCore().getAxisLineColor());
            this.getYAxis().getLabels().getCore().applyStyle(style);
        }
    }

    public final StiCellGeom Render(StiContext context, StiRectangle rect) {
        if (!this.getAxis().getVisible()) {
            return null;
        }
        StiRectangle axisRect = this.GetAxisRect(context, rect, false, false, true);
        IStiRadarAxis tempVar = this.getAxis();
        StiRadarAxisGeom geom = new StiRadarAxisGeom((IStiYRadarAxis)(tempVar instanceof IStiYRadarAxis ? tempVar : null), axisRect);
        this.RenderLabels(context, axisRect, geom);
        return geom;
    }

    private ArrayList<StiAxisLabelInfoXF> MeasureStripLines(StiContext context, StiRectangle rect) {
        ArrayList<StiAxisLabelInfoXF> infos = new ArrayList<StiAxisLabelInfoXF>();
        if (this.getYAxis().getInfo().LabelsCollection != null && this.getYAxis().getLabels().getPlacement() != StiLabelsPlacement.None) {
            int index = 0;
            for (StiStripPositionXF label : this.getYAxis().getInfo().LabelsCollection) {
                StiRotationMode rotationMode;
                double value = label.StripLine.getValue();
                String text = this.GetLabelText(label.StripLine, null);
                double posY = label.Position;
                StiStringFormatGeom sf = context.GetGenericStringFormat();
                StiFontGeom font = StiFontGeom.ChangeFontSize((StiFont)this.getYAxis().getLabels().getFont(), (double)(this.getYAxis().getLabels().getFont().size * context.Options.zoom));
                StiMarkerAlignment alignment = this.GetTextAlignment();
                float angle = -this.getYAxis().getLabels().getAngle();
                StiPoint point = StiPoint.getEmpty();
                if (alignment == StiMarkerAlignment.Left) {
                    rotationMode = StiRotationMode.LeftCenter;
                    point = new StiPoint(0.0, posY);
                    angle = 0.0f;
                } else {
                    rotationMode = StiRotationMode.RightCenter;
                    point = new StiPoint(rect.width - this.GetTicksMaxLength(context) - this.GetLabelsSpaceAxis(context), posY);
                }
                if (this.getYAxis().getLabels().getPlacement() == StiLabelsPlacement.TwoLines && index & true) {
                    point.x -= this.GetLabelsTwoLinesDestination(context);
                }
                StiRectangle textRectF = context.MeasureRotatedString(text, font, point, sf, rotationMode, (double)angle, (int)((double)this.getYAxis().getLabels().getWidth() * context.Options.zoom), this.getYAxis().getLabels().getWordWrap());
                StiAxisLabelInfoXF info = new StiAxisLabelInfoXF();
                info.Angle = angle;
                info.setClientRectangle(textRectF);
                info.RotationMode = rotationMode;
                info.TextPoint = point.clone();
                info.Text = text;
                info.StripLine = label.StripLine;
                infos.add(info);
                ++index;
            }
        }
        return infos;
    }

    private void RenderLabels(StiContext context, StiRectangle rect, StiRadarAxisGeom geom) {
        if (this.getYAxis().getLabels().getPlacement() != StiLabelsPlacement.None) {
            ArrayList<StiAxisLabelInfoXF> infos = this.MeasureStripLines(context, rect);
            geom.CreateChildGeoms();
            for (StiAxisLabelInfoXF info : infos) {
                if (info.getClientRectangle().isEmpty().booleanValue()) continue;
                StiYRadarAxisLabelGeom labelGeom = new StiYRadarAxisLabelGeom(this.getYAxis(), info.getClientRectangle(), info.TextPoint, info.Text, info.StripLine, info.Angle, info.RotationMode);
                geom.getChildGeoms().add(labelGeom);
            }
        }
    }

    public final void CalculateStripPositions(double topPosition, double bottomPosition) {
        bottomPosition -= topPosition;
        topPosition = 0.0;
        if (this.getYAxis().getInfo().StripLines == null || this.getYAxis().getInfo().StripLines.size() < 2) {
            this.getYAxis().getInfo().StripPositions = new double[0];
        } else {
            this.getYAxis().getInfo().StripPositions = new double[this.getYAxis().getInfo().StripLines.size()];
            this.getYAxis().getInfo().StripPositions[0] = topPosition;
            this.getYAxis().getInfo().StripPositions[this.getYAxis().getInfo().StripPositions.length - 1] = bottomPosition;
            for (int index = 1; index < this.getYAxis().getInfo().StripPositions.length - 1; ++index) {
                this.getYAxis().getInfo().StripPositions[index] = topPosition + (double)index * this.getYAxis().getInfo().Step;
            }
        }
    }

    public final StiRectangle GetAxisRect(StiContext context, StiRectangle rect, boolean includeAxisArrow, boolean includeLabelsHeight, boolean isDrawing) {
        StiRectangle axisRect = new StiRectangle(rect.width / 2.0 - this.GetTicksMaxLength(context), 0.0, this.GetTicksMaxLength(context), rect.height / 2.0);
        return axisRect;
    }

    protected final double GetTicksMaxLength(StiContext context) {
        return (double)this.getYAxis().getYCore().getTicksMaxLength() * context.Options.zoom;
    }

    protected final double GetLabelsSpaceAxis(StiContext context) {
        return 5.0 * context.Options.zoom;
    }

    protected final double GetLabelsTwoLinesDestination(StiContext context) {
        return this.getYAxis().getLabels().getFont().getSize() * 2.0 * context.Options.zoom;
    }

    protected final StiMarkerAlignment GetTextAlignment() {
        IStiRadarAxis tempVar = this.getAxis();
        IStiYRadarAxis radarAxis = (IStiYRadarAxis)(tempVar instanceof IStiYRadarAxis ? tempVar : null);
        if (this.getYAxis().getLabels().getPlacement() == StiLabelsPlacement.TwoLines) {
            return StiMarkerAlignment.Right;
        }
        return this.getYAxis().getLabels().getTextAlignment();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String GetLabelText(StiStripLineXF line, IStiSeries series) {
        Object value = line.getValueObject();
        if (this.getYAxis().getLabels().getFormat() == null || this.getYAxis().getLabels().getFormat().trim().length() == 0) return String.format("%1$s%2$s%3$s", this.getYAxis().getLabels().getTextBefore(), StiTextUtil.toString((Object)value), this.getYAxis().getLabels().getTextAfter());
        try {
            if (value instanceof String) {
                value = new BigDecimal(value.toString());
            }
            if (StiChartOptions.getOldChartPercentMode() || !this.getYAxis().getLabels().getFormat().startsWith("P")) return String.format("%1$s%1s%3$s", this.getYAxis().getLabels().getTextBefore(), StiTextUtil.toString((Object)value), this.getYAxis().getLabels().getTextAfter());
            int signs = 0;
            if (this.getYAxis().getLabels().getFormat().length() <= 1) return String.format("%1$s%1s%3$s%4$s", this.getYAxis().getLabels().getTextBefore(), StiTextUtil.toString((Object)value), "%", this.getYAxis().getLabels().getTextAfter());
            try {
                String tempVar = this.getYAxis().getLabels().getFormat();
                signs = Integer.parseInt(tempVar.substring(0, 0) + tempVar.substring(1));
                return String.format("%1$s%1s%3$s%4$s", this.getYAxis().getLabels().getTextBefore(), StiTextUtil.toString((Object)value), "%", this.getYAxis().getLabels().getTextAfter());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return String.format("%1$s%1s%3$s%4$s", this.getYAxis().getLabels().getTextBefore(), StiTextUtil.toString((Object)value), "%", this.getYAxis().getLabels().getTextAfter());
        }
        catch (Exception exception) {
            try {
                return String.format("%1$s%2$s%3$s", this.getYAxis().getLabels().getTextBefore(), StiTextUtil.toString((Object)value), this.getYAxis().getLabels().getTextAfter());
            }
            catch (Exception exception2) {
                return StiTextUtil.toString((Object)value);
            }
        }
    }

    public final StiStringFormatGeom GetStringFormatGeom(StiContext context) {
        StiStringFormatGeom sf = context.GetGenericStringFormat();
        sf.setTrimming(StiStringTrimming.None);
        sf.getFormatFlags().OR((IStiEnum)StiStringFormatFlags.MeasureTrailingSpaces);
        sf.getFormatFlags().OR((IStiEnum)StiStringFormatFlags.NoWrap);
        if (this.getYAxis().getLabels().getWidth() > 0.0f) {
            StiMarkerAlignment alignment = this.GetTextAlignment();
            if (alignment == StiMarkerAlignment.Left) {
                sf.setAlignment(StiStringAlignment.Near);
            } else {
                sf.setAlignment(StiStringAlignment.Far);
            }
        }
        return sf;
    }

    public final StiFontGeom GetFontGeom(StiContext context) {
        StiFontGeom font = StiFontGeom.ChangeFontSize((StiFont)this.getYAxis().getLabels().getFont(), (double)(this.getYAxis().getLabels().getFont().size * context.Options.zoom));
        return font;
    }

    public final IStiYRadarAxis getYAxis() {
        IStiRadarAxis tempVar = this.getAxis();
        return (IStiYRadarAxis)(tempVar instanceof IStiYRadarAxis ? tempVar : null);
    }

    public final StiAxisInfoXF getInfo() {
        return this.getYAxis().getInfo();
    }

    public final void setInfo(StiAxisInfoXF value) {
        this.getYAxis().setInfo(value);
    }

    public final float getTicksMaxLength() {
        if (this.getAxis().getVisible()) {
            return Math.max(this.getYAxis().getTicks().getVisible() ? this.getYAxis().getTicks().getLength() : 0.0f, this.getYAxis().getTicks().getMinorVisible() ? this.getYAxis().getTicks().getMinorLength() : 0.0f);
        }
        return 0.0f;
    }

    public StiYRadarAxisCoreXF(IStiRadarAxis axis) {
        super(axis);
    }
}

