/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.radarAxis;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.context.chart.geoms.StiStringFormatGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiRotationMode;
import com.stimulsoft.base.drawing.enums.StiStringFormatFlags;
import com.stimulsoft.base.drawing.enums.StiStringTrimming;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChartOptions;
import com.stimulsoft.report.chart.core.radarAxis.StiRadarAxisCoreXF;
import com.stimulsoft.report.chart.geoms.radarAxis.StiXRadarAxisLabelGeom;
import com.stimulsoft.report.chart.interfaces.radarAxis.IStiRadarAxis;
import com.stimulsoft.report.chart.interfaces.radarAxis.IStiXRadarAxis;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import java.math.BigDecimal;

public class StiXRadarAxisCoreXF
extends StiRadarAxisCoreXF {
    @Override
    public void applyStyle(IStiChartStyle style) {
        if (this.getAxis().getAllowApplyStyle()) {
            ((IStiXRadarAxis)this.getAxis()).getLabels().getCore().applyStyle(style);
        }
    }

    public StiXRadarAxisLabelGeom RenderLabel(StiContext context, IStiSeries series, StiPoint point, Object argument, float angle, int colorIndex, int colorCount) {
        String argumentText = this.GetLabelText(argument);
        StiRectangle rect = this.GetLabelRect(context, point, argumentText, 0.0f);
        rect.x = -rect.width / 2.0;
        rect.y = -rect.height / 2.0;
        StiRectangle labelRect = this.GetLabelRect(context, point, argumentText, angle);
        StiColor borderColor = ((IStiXRadarAxis)this.getAxis()).getLabels().getBorderColor();
        StiSolidBrush labelBrush = new StiSolidBrush(((IStiXRadarAxis)this.getAxis()).getLabels().getColor());
        IStiRadarAxis tempVar = this.getAxis();
        return new StiXRadarAxisLabelGeom((IStiXRadarAxis)(tempVar instanceof IStiXRadarAxis ? tempVar : null), argumentText, (StiBrush)labelBrush, borderColor, angle, rect, labelRect, point);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String GetLabelText(Object value) {
        IStiRadarAxis tempVar = this.getAxis();
        IStiXRadarAxis xAxis = (IStiXRadarAxis)(tempVar instanceof IStiXRadarAxis ? tempVar : null);
        if (xAxis.getLabels().getFormat() == null || xAxis.getLabels().getFormat().trim().length() == 0) return String.format("%1$s%2$s%3$s", xAxis.getLabels().getTextBefore(), value, xAxis.getLabels().getTextAfter());
        try {
            if (value instanceof String) {
                value = new BigDecimal(value.toString());
            }
            if (StiChartOptions.getOldChartPercentMode() || !xAxis.getLabels().getFormat().startsWith("P")) return String.format("%1$s%1s%3$s", xAxis.getLabels().getTextBefore(), value, xAxis.getLabels().getTextAfter());
            int signs = 0;
            if (xAxis.getLabels().getFormat().length() <= 1) return String.format("%1$s%1s%3$s%4$s", xAxis.getLabels().getTextBefore(), value, "%", xAxis.getLabels().getTextAfter());
            try {
                String tempVar2 = xAxis.getLabels().getFormat();
                signs = Integer.parseInt(tempVar2.substring(0, 0) + tempVar2.substring(1));
                return String.format("%1$s%1s%3$s%4$s", xAxis.getLabels().getTextBefore(), value, "%", xAxis.getLabels().getTextAfter());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return String.format("%1$s%1s%3$s%4$s", xAxis.getLabels().getTextBefore(), value, "%", xAxis.getLabels().getTextAfter());
        }
        catch (Exception exception) {
            try {
                return String.format("%1$s%2$s%3$s", xAxis.getLabels().getTextBefore(), value, xAxis.getLabels().getTextAfter());
            }
            catch (Exception exception2) {
                return value.toString();
            }
        }
    }

    public StiRectangle GetLabelRect(StiContext context, StiPoint point, String text, float angle) {
        StiFontGeom font = StiFontGeom.ChangeFontSize((StiFont)((IStiXRadarAxis)this.getAxis()).getLabels().getFont(), (double)(((IStiXRadarAxis)this.getAxis()).getLabels().getFont().getSize() * context.Options.zoom));
        StiStringFormatGeom sf = context.GetGenericStringFormat();
        sf.setTrimming(StiStringTrimming.None);
        sf.getFormatFlags().OR((IStiEnum)StiStringFormatFlags.MeasureTrailingSpaces);
        sf.getFormatFlags().OR((IStiEnum)StiStringFormatFlags.NoWrap);
        return context.MeasureRotatedString(text, font, point, sf, StiRotationMode.CenterBottom, (double)angle);
    }

    public final IStiXRadarAxis getXAxis() {
        IStiRadarAxis tempVar = this.getAxis();
        return (IStiXRadarAxis)(tempVar instanceof IStiXRadarAxis ? tempVar : null);
    }

    public StiXRadarAxisCoreXF(IStiRadarAxis axis) {
        super(axis);
    }
}

