/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.area.stackedColumn;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.report.chart.core.area.StiAxisAreaCoreXF;
import com.stimulsoft.report.chart.enums.StiChartAreaPosition;
import com.stimulsoft.report.chart.enums.StiSeriesYAxis;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.axis.IStiAxis;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.enums.StiGlobalGuiStyle;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class StiStackedColumnAreaCoreXF
extends StiAxisAreaCoreXF {
    private ArrayList PrepareSeriesRange(Class seriesType) {
        ArrayList<Double> minValues = new ArrayList<Double>();
        ArrayList<Double> maxValues = new ArrayList<Double>();
        ArrayList<Double> minValuesRight = new ArrayList<Double>();
        ArrayList<Double> maxValuesRight = new ArrayList<Double>();
        ArrayList<IStiSeries> seriesCollection = this.GetSeries();
        for (int indexPoint = 0; indexPoint < this.ValuesCount; ++indexPoint) {
            for (IStiSeries series : seriesCollection) {
                Double value;
                if (series.getClass() != seriesType) continue;
                if (series.getYAxis() == StiSeriesYAxis.LeftYAxis) {
                    minValues.add(0.0);
                    maxValues.add(0.0);
                    if (indexPoint >= series.getValues().length) continue;
                    value = series.getValues()[indexPoint];
                    if (value != null && value > 0.0) {
                        maxValues.set(indexPoint, (Double)maxValues.get(indexPoint) + value);
                        continue;
                    }
                    minValues.set(indexPoint, (Double)minValues.get(indexPoint) + (value == null ? 0.0 : value));
                    continue;
                }
                minValuesRight.add(0.0);
                maxValuesRight.add(0.0);
                if (indexPoint >= series.getValues().length) continue;
                value = series.getValues()[indexPoint];
                if (value != null && value > 0.0) {
                    maxValuesRight.set(indexPoint, (Double)maxValuesRight.get(indexPoint) + value);
                    continue;
                }
                minValuesRight.set(indexPoint, (Double)minValuesRight.get(indexPoint) + (value == null ? 0.0 : value));
            }
        }
        ArrayList<ArrayList<Double>> values = new ArrayList<ArrayList<Double>>();
        values.add(minValues);
        values.add(maxValues);
        values.add(minValuesRight);
        values.add(maxValuesRight);
        return values;
    }

    @Override
    protected void PrepareRange(IStiAxis specXAxis, IStiAxis specXTopAxis, IStiAxis specYAxis, IStiAxis specYRightAxis) {
        ArrayList<IStiSeries> seriesCollection = this.GetSeries();
        Hashtable seriesTypes = new Hashtable();
        for (IStiSeries series : seriesCollection) {
            seriesTypes.put(series.getClass(), series.getClass());
        }
        ArrayList<Double> minValues = new ArrayList<Double>();
        ArrayList<Double> maxValues = new ArrayList<Double>();
        ArrayList<Double> minValuesRight = new ArrayList<Double>();
        ArrayList<Double> maxValuesRight = new ArrayList<Double>();
        for (Class seriesType : seriesTypes.values()) {
            double value;
            ArrayList values = this.PrepareSeriesRange(seriesType);
            int index = 0;
            Iterator iterator = ((ArrayList)values.get(0)).iterator();
            while (iterator.hasNext()) {
                value = (Double)iterator.next();
                if (minValues.size() <= index) {
                    minValues.add(value);
                } else {
                    minValues.set(index, Math.min((Double)minValues.get(index), value));
                }
                ++index;
            }
            index = 0;
            iterator = ((ArrayList)values.get(1)).iterator();
            while (iterator.hasNext()) {
                value = (Double)iterator.next();
                if (maxValues.size() <= index) {
                    maxValues.add(value);
                } else {
                    maxValues.set(index, Math.max((Double)maxValues.get(index), value));
                }
                ++index;
            }
            index = 0;
            iterator = ((ArrayList)values.get(2)).iterator();
            while (iterator.hasNext()) {
                value = (Double)iterator.next();
                if (minValuesRight.size() <= index) {
                    minValuesRight.add(value);
                } else {
                    minValuesRight.set(index, Math.min((Double)minValuesRight.get(index), value));
                }
                ++index;
            }
            index = 0;
            iterator = ((ArrayList)values.get(3)).iterator();
            while (iterator.hasNext()) {
                value = (Double)iterator.next();
                if (maxValuesRight.size() <= index) {
                    maxValuesRight.add(value);
                } else {
                    maxValuesRight.set(index, Math.max((Double)maxValuesRight.get(index), value));
                }
                ++index;
            }
        }
        if (minValues.isEmpty()) {
            minValues = minValuesRight;
        }
        if (maxValues.isEmpty()) {
            maxValues = maxValuesRight;
        }
        if (minValuesRight.isEmpty()) {
            minValuesRight = minValues;
        }
        if (maxValuesRight.isEmpty()) {
            maxValuesRight = maxValues;
        }
        boolean firstValue = true;
        Iterator iterator = minValues.iterator();
        while (iterator.hasNext()) {
            double value = (Double)iterator.next();
            if (firstValue) {
                specYAxis.getInfo().Minimum = value;
                firstValue = false;
                continue;
            }
            specYAxis.getInfo().Minimum = Math.min(value, specYAxis.getInfo().Minimum);
        }
        firstValue = true;
        iterator = maxValues.iterator();
        while (iterator.hasNext()) {
            double value = (Double)iterator.next();
            if (firstValue) {
                specYAxis.getInfo().Maximum = value;
                firstValue = false;
                continue;
            }
            specYAxis.getInfo().Maximum = Math.max(value, specYAxis.getInfo().Maximum);
        }
        firstValue = true;
        iterator = minValuesRight.iterator();
        while (iterator.hasNext()) {
            double value = (Double)iterator.next();
            if (firstValue) {
                specYRightAxis.getInfo().Minimum = value;
                firstValue = false;
                continue;
            }
            specYRightAxis.getInfo().Minimum = Math.min(value, specYRightAxis.getInfo().Minimum);
        }
        firstValue = true;
        iterator = maxValuesRight.iterator();
        while (iterator.hasNext()) {
            double value = (Double)iterator.next();
            if (firstValue) {
                specYRightAxis.getInfo().Maximum = value;
                firstValue = false;
                continue;
            }
            specYRightAxis.getInfo().Maximum = Math.max(value, specYRightAxis.getInfo().Maximum);
        }
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"StackedColumn");
    }

    @Override
    public int getPosition() {
        return StiChartAreaPosition.StackedColumn.getValue();
    }

    public StiStackedColumnAreaCoreXF(IStiArea area) {
        super(area);
    }

    public void ApplyStyle(StiGlobalGuiStyle style) {
    }
}

