/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes.aztec;

import com.stimulsoft.report.barCodes.aztec.BitArray;
import com.stimulsoft.report.barCodes.aztec.HighLevelEncoder;
import com.stimulsoft.report.barCodes.aztec.StiAztecException;
import com.stimulsoft.report.barCodes.aztec.Token;
import java.util.LinkedList;

public class State {
    public static final State INITIAL_STATE = new State(Token.EMPTY, 0, 0, 0);
    public final int mode;
    public final Token token;
    public final int binaryShiftByteCount;
    public final int bitCount;

    public State(Token token, int mode, int binaryBytes, int bitCount) {
        this.token = token;
        this.mode = mode;
        this.binaryShiftByteCount = binaryBytes;
        this.bitCount = bitCount;
    }

    public State AppendFLGn(int eci) {
        State result = this.ShiftAndAppend(4, 0);
        Token token = result.token;
        int bitsAdded = 3;
        if (eci < 0) {
            token = token.Add(0, 3);
        } else {
            int d1 = eci % 10;
            int d2 = eci / 10;
            if (d2 > 0) {
                token = token.Add(2, 3);
                token = token.Add(d2 + 2, 4);
                token = token.Add(d1 + 2, 4);
                bitsAdded += 8;
            } else {
                token = token.Add(1, 3);
                token = token.Add(d1 + 2, 4);
                bitsAdded += 4;
            }
        }
        return new State(token, this.mode, 0, this.bitCount + bitsAdded);
    }

    public State LatchAndAppend(int mode, int value) {
        int bitCount = this.bitCount;
        Token token = this.token;
        if (mode != this.mode) {
            int latch = HighLevelEncoder.LATCH_TABLE[this.mode][mode];
            token = token.Add(latch & 0xFFFF, latch >> 16);
            bitCount += latch >> 16;
        }
        int latchModeBitCount = mode == 2 ? 4 : 5;
        token = token.Add(value, latchModeBitCount);
        return new State(token, mode, 0, bitCount + latchModeBitCount);
    }

    public State ShiftAndAppend(int mode, int value) {
        Token token = this.token;
        int thisModeBitCount = this.mode == 2 ? 4 : 5;
        token = token.Add(HighLevelEncoder.SHIFT_TABLE[this.mode][mode], thisModeBitCount);
        token = token.Add(value, 5);
        return new State(token, this.mode, 0, this.bitCount + thisModeBitCount + 5);
    }

    public State AddBinaryShiftChar(int index) {
        Token token = this.token;
        int mode = this.mode;
        int bitCount = this.bitCount;
        if (this.mode == 4 || this.mode == 2) {
            int latch = HighLevelEncoder.LATCH_TABLE[mode][0];
            token = token.Add(latch & 0xFFFF, latch >> 16);
            bitCount += latch >> 16;
            mode = 0;
        }
        int deltaBitCount = this.binaryShiftByteCount == 0 || this.binaryShiftByteCount == 31 ? 18 : (this.binaryShiftByteCount == 62 ? 9 : 8);
        State result = new State(token, mode, this.binaryShiftByteCount + 1, bitCount + deltaBitCount);
        if (result.binaryShiftByteCount == 2078) {
            result = result.EndBinaryShift(index + 1);
        }
        return result;
    }

    public State EndBinaryShift(int index) {
        if (this.binaryShiftByteCount == 0) {
            return this;
        }
        Token token = this.token;
        token = token.AddBinaryShift(index - this.binaryShiftByteCount, this.binaryShiftByteCount);
        return new State(token, this.mode, 0, this.bitCount);
    }

    public boolean IsBetterThanOrEqualTo(State other) {
        int newModeBitCount = this.bitCount + (HighLevelEncoder.LATCH_TABLE[this.mode][other.mode] >> 16);
        if (this.binaryShiftByteCount < other.binaryShiftByteCount) {
            newModeBitCount += State.CalculateBinaryShiftCost(other) - State.CalculateBinaryShiftCost(this);
        } else if (this.binaryShiftByteCount > other.binaryShiftByteCount && other.binaryShiftByteCount > 0) {
            newModeBitCount += 10;
        }
        return newModeBitCount <= other.bitCount;
    }

    public BitArray ToBitArray(byte[] text) throws StiAztecException {
        LinkedList<Token> symbols = new LinkedList<Token>();
        Token token = this.EndBinaryShift((int)text.length).token;
        while (token != null) {
            symbols.addFirst(token);
            token = token.previous;
        }
        BitArray bitArray = new BitArray();
        for (Token symbol : symbols) {
            symbol.AppendTo(bitArray, text);
        }
        return bitArray;
    }

    private static int CalculateBinaryShiftCost(State state) {
        if (state.binaryShiftByteCount > 62) {
            return 21;
        }
        if (state.binaryShiftByteCount > 31) {
            return 20;
        }
        if (state.binaryShiftByteCount > 0) {
            return 10;
        }
        return 0;
    }
}

