/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes.aztec;

import com.stimulsoft.report.barCodes.aztec.BitArray;
import com.stimulsoft.report.barCodes.aztec.State;
import com.stimulsoft.report.barCodes.aztec.StiAztecException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class HighLevelEncoder {
    static final int MODE_UPPER = 0;
    static final int MODE_LOWER = 1;
    static final int MODE_DIGIT = 2;
    static final int MODE_MIXED = 3;
    static final int MODE_PUNCT = 4;
    static final int[][] LATCH_TABLE;
    static final int[][] CHAR_MAP;
    static final int[][] SHIFT_TABLE;
    private final byte[] text;
    private final int eci;

    public HighLevelEncoder(byte[] text, int eci) {
        this.text = text;
        this.eci = eci;
    }

    public BitArray Encode() throws StiAztecException {
        State initialState = State.INITIAL_STATE;
        if (this.eci != 0) {
            initialState = initialState.AppendFLGn(this.eci);
        }
        List<State> states = new ArrayList<State>();
        states.add(initialState);
        for (int index = 0; index < this.text.length; ++index) {
            int pairCode;
            byte nextChar = index + 1 < this.text.length ? this.text[index + 1] : (byte)0;
            switch (this.text[index]) {
                case 13: {
                    pairCode = nextChar == 10 ? 2 : 0;
                    break;
                }
                case 46: {
                    pairCode = nextChar == 32 ? 3 : 0;
                    break;
                }
                case 44: {
                    pairCode = nextChar == 32 ? 4 : 0;
                    break;
                }
                case 58: {
                    pairCode = nextChar == 32 ? 5 : 0;
                    break;
                }
                default: {
                    pairCode = 0;
                }
            }
            if (pairCode > 0) {
                states = HighLevelEncoder.UpdateStateListForPair(states, index, pairCode);
                ++index;
                continue;
            }
            states = this.UpdateStateListForChar(states, index);
        }
        State minState = null;
        for (State state : states) {
            if (minState == null) {
                minState = state;
                continue;
            }
            if (state.bitCount >= minState.bitCount) continue;
            minState = state;
        }
        return minState.ToBitArray(this.text);
    }

    private List<State> UpdateStateListForChar(List<State> states, int index) {
        LinkedList<State> result = new LinkedList<State>();
        for (State state : states) {
            this.UpdateStateForChar(state, index, result);
        }
        return HighLevelEncoder.SimplifyStates(result);
    }

    private void UpdateStateForChar(State state, int index, List<State> result) {
        char ch = (char)(this.text[index] & 0xFF);
        boolean charInCurrentTable = CHAR_MAP[state.mode][ch] > 0;
        State stateNoBinary = null;
        for (int mode = 0; mode <= 4; ++mode) {
            int charInMode = CHAR_MAP[mode][ch];
            if (charInMode <= 0) continue;
            if (stateNoBinary == null) {
                stateNoBinary = state.EndBinaryShift(index);
            }
            if (!charInCurrentTable || mode == state.mode || mode == 2) {
                State latchState = stateNoBinary.LatchAndAppend(mode, charInMode);
                result.add(latchState);
            }
            if (charInCurrentTable || SHIFT_TABLE[state.mode][mode] < 0) continue;
            State shiftState = stateNoBinary.ShiftAndAppend(mode, charInMode);
            result.add(shiftState);
        }
        if (state.binaryShiftByteCount > 0 || CHAR_MAP[state.mode][ch] == 0) {
            State binaryState = state.AddBinaryShiftChar(index);
            result.add(binaryState);
        }
    }

    private static List<State> UpdateStateListForPair(List<State> states, int index, int pairCode) {
        LinkedList<State> result = new LinkedList<State>();
        for (State state : states) {
            HighLevelEncoder.UpdateStateForPair(state, index, pairCode, result);
        }
        return HighLevelEncoder.SimplifyStates(result);
    }

    private static void UpdateStateForPair(State state, int index, int pairCode, List<State> result) {
        State stateNoBinary = state.EndBinaryShift(index);
        result.add(stateNoBinary.LatchAndAppend(4, pairCode));
        if (state.mode != 4) {
            result.add(stateNoBinary.ShiftAndAppend(4, pairCode));
        }
        if (pairCode == 3 || pairCode == 4) {
            State digitState = stateNoBinary.LatchAndAppend(2, 16 - pairCode).LatchAndAppend(2, 1);
            result.add(digitState);
        }
        if (state.binaryShiftByteCount > 0) {
            State binaryState = state.AddBinaryShiftChar(index).AddBinaryShiftChar(index + 1);
            result.add(binaryState);
        }
    }

    private static List<State> SimplifyStates(List<State> states) {
        LinkedList<State> result = new LinkedList<State>();
        ArrayList<State> removeList = new ArrayList<State>();
        for (State newState : states) {
            boolean add = true;
            removeList.clear();
            for (State oldState : result) {
                if (oldState.IsBetterThanOrEqualTo(newState)) {
                    add = false;
                    break;
                }
                if (!newState.IsBetterThanOrEqualTo(oldState)) continue;
                removeList.add(oldState);
            }
            if (add) {
                result.addLast(newState);
            }
            result.removeAll(removeList);
        }
        return result;
    }

    static {
        int c;
        LATCH_TABLE = new int[][]{{0, 327708, 327710, 327709, 656318}, {590318, 0, 327710, 327709, 656318}, {262158, 590300, 0, 590301, 932798}, {327709, 327708, 656318, 0, 327710}, {327711, 656380, 656382, 656381, 0}};
        CHAR_MAP = new int[5][];
        SHIFT_TABLE = new int[6][];
        HighLevelEncoder.CHAR_MAP[0] = new int[256];
        HighLevelEncoder.CHAR_MAP[1] = new int[256];
        HighLevelEncoder.CHAR_MAP[2] = new int[256];
        HighLevelEncoder.CHAR_MAP[3] = new int[256];
        HighLevelEncoder.CHAR_MAP[4] = new int[256];
        HighLevelEncoder.SHIFT_TABLE[0] = new int[6];
        HighLevelEncoder.SHIFT_TABLE[1] = new int[6];
        HighLevelEncoder.SHIFT_TABLE[2] = new int[6];
        HighLevelEncoder.SHIFT_TABLE[3] = new int[6];
        HighLevelEncoder.SHIFT_TABLE[4] = new int[6];
        HighLevelEncoder.SHIFT_TABLE[5] = new int[6];
        HighLevelEncoder.CHAR_MAP[0][32] = 1;
        for (c = 65; c <= 90; ++c) {
            HighLevelEncoder.CHAR_MAP[0][c] = c - 65 + 2;
        }
        HighLevelEncoder.CHAR_MAP[1][32] = 1;
        for (c = 97; c <= 122; ++c) {
            HighLevelEncoder.CHAR_MAP[1][c] = c - 97 + 2;
        }
        HighLevelEncoder.CHAR_MAP[2][32] = 1;
        for (c = 48; c <= 57; ++c) {
            HighLevelEncoder.CHAR_MAP[2][c] = c - 48 + 2;
        }
        HighLevelEncoder.CHAR_MAP[2][44] = 12;
        HighLevelEncoder.CHAR_MAP[2][46] = 13;
        int[] mixedTable = new int[]{0, 32, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 27, 28, 29, 30, 31, 64, 92, 94, 95, 96, 124, 126, 127};
        for (int i = 0; i < mixedTable.length; ++i) {
            HighLevelEncoder.CHAR_MAP[3][mixedTable[i]] = i;
        }
        int[] punctTable = new int[]{0, 13, 0, 0, 0, 0, 33, 39, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 58, 59, 60, 61, 62, 63, 91, 93, 123, 125};
        for (int i = 0; i < punctTable.length; ++i) {
            if (punctTable[i] <= 0) continue;
            HighLevelEncoder.CHAR_MAP[4][punctTable[i]] = i;
        }
        for (int[] table : SHIFT_TABLE) {
            for (int i = 0; i < table.length; ++i) {
                table[i] = -1;
            }
        }
        HighLevelEncoder.SHIFT_TABLE[0][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[1][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[1][0] = 28;
        HighLevelEncoder.SHIFT_TABLE[3][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[2][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[2][0] = 15;
    }
}

