/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes.aztec;

import com.stimulsoft.report.barCodes.aztec.StiAztecException;

public class BitArray {
    private int[] bits = new int[1];
    public int size = 0;

    public int getSizeInBytes() {
        return this.size + 7 >> 3;
    }

    public boolean get(int i) {
        return (this.bits[i >> 5] & 1 << (i & 0x1F)) != 0;
    }

    public void set(int i, boolean value) {
        if (value) {
            int n = i >> 5;
            this.bits[n] = this.bits[n] | 1 << (i & 0x1F);
        }
    }

    private void EnsureCapacity(int size) {
        if (size > this.bits.length << 5) {
            int[] newBits = BitArray.MakeArray(size);
            System.arraycopy(this.bits, 0, newBits, 0, this.bits.length);
            this.bits = newBits;
        }
    }

    public void AppendBit(boolean bit) {
        this.EnsureCapacity(this.size + 1);
        if (bit) {
            int n = this.size >> 5;
            this.bits[n] = this.bits[n] | 1 << (this.size & 0x1F);
        }
        ++this.size;
    }

    public void AppendBits(int value, int numBits) throws StiAztecException {
        if (numBits < 0 || numBits > 32) {
            throw new StiAztecException("Num bits must be between 0 and 32");
        }
        this.EnsureCapacity(this.size + numBits);
        for (int numBitsLeft = numBits; numBitsLeft > 0; --numBitsLeft) {
            this.AppendBit((value >> numBitsLeft - 1 & 1) == 1);
        }
    }

    public void AppendBitArray(BitArray other) {
        int otherSize = other.size;
        this.EnsureCapacity(this.size + otherSize);
        for (int i = 0; i < otherSize; ++i) {
            this.AppendBit(other.get(i));
        }
    }

    private static int[] MakeArray(int size) {
        return new int[size + 31 >> 5];
    }
}

