/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes.aztec;

import com.stimulsoft.report.barCodes.aztec.BitArray;
import com.stimulsoft.report.barCodes.aztec.StiAztecException;
import com.stimulsoft.report.barCodes.aztec.Token;

public class BinaryShiftToken
extends Token {
    private final short binaryShiftStart;
    private final short binaryShiftByteCount;

    public BinaryShiftToken(Token previous, int binaryShiftStart, int binaryShiftByteCount) {
        super(previous);
        this.binaryShiftStart = (short)binaryShiftStart;
        this.binaryShiftByteCount = (short)binaryShiftByteCount;
    }

    @Override
    public void AppendTo(BitArray bitArray, byte[] text) throws StiAztecException {
        for (int i = 0; i < this.binaryShiftByteCount; ++i) {
            if (i == 0 || i == 31 && this.binaryShiftByteCount <= 62) {
                bitArray.AppendBits(31, 5);
                if (this.binaryShiftByteCount > 62) {
                    bitArray.AppendBits(this.binaryShiftByteCount - 31, 16);
                } else if (i == 0) {
                    bitArray.AppendBits(Math.min(this.binaryShiftByteCount, 31), 5);
                } else {
                    bitArray.AppendBits(this.binaryShiftByteCount - 31, 5);
                }
            }
            bitArray.AppendBits(text[this.binaryShiftStart + i], 8);
        }
    }
}

